
// ID-FMA.POV include file

#include "colors.inc"
#include "glass.inc"
#include "textures.inc"

//--textures definitions--------------------------------

#declare Landscape=pigment {
            gradient x
            sine_wave
            turbulence 0.7
            octaves 7
            lambda 0.5
            omega 0.5
            scale .01
}

// Height_field generates a field  <0,0,0>   <1,1,0>
#declare My_Cliff= height_field {
	function 50, 50 {
		pigment{Landscape}
 	}
	smooth
	scale <20,100,40>   // orig  50,0,50   30, 30 , 3
	finish {
		specular 0.1 
		roughness 2
		phong .7   	// bumpy
		reflection {.4}	// bumpy
	}
	normal {
		bumps .1 scale 2
	       sine_wave
	}
	pigment {rgb <.7,.7,.1>}
}

#declare OceanArea = texture {
      pigment {
        bozo
        turbulence .5
        lambda 2
        color_map {
          [0.00, 0.33 color rgb <0, 0, 1>
                      color rgb <0, 0, 1>]
          [0.33, 0.66 color rgbf <1, 1, 1, 1>
                      color rgbf <1, 1, 1, 1>]
          [0.66, 1.00 color rgb <0, 0, 1>
                      color rgb <0, 0, 1>]
        }
      }
    }


#declare WHITE_GLASS = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 1.00
        phong_size 36.4
        refraction 1.0
	ior 1.1
    }
    pigment { color rgbf <0.926, 0.925, 0.926, 0.670> }
}

#declare Stone1 = texture {
 pigment {
   crackle solid
   color_map {
     [0  Black]
     [.2 Wheat*.5]
     [.4 Black]
     [.6 Wheat*.5]
     [.8 Black]
     [1 Wheat*.5]}
 }
 finish {phong .7 reflection {.4}}
 normal {bumps .1 scale .2}
 scale .1
}

#declare Stone2 = texture {
 pigment {
   crackle solid
   color_map {
      [0 Red]
      [.2 Wheat]
      [.4 Tan]
      [.6 Wheat]
      [.8 Red*.5]
      [1 Wheat]
   }
 }
 finish {phong .7 reflection {.5}}
 normal {bumps .1 scale .4}
 scale .05
}

#declare Zinc1 = texture {
 pigment {Gray80}
 finish {phong .7
 reflection {.3}}
 normal {bumps .002 scale <.1,.1,10>}
}

#declare Zinc2 = texture {
 pigment {Gray90}
 finish {
   phong .6
   reflection {.05}
 }
 normal {bumps .002 scale <.1,.1,10> rotate y*90}
}

#declare Zinc3 = texture {
 pigment {Gray60}
 finish {
   phong .5
   reflection {.3}
 }
 normal {bumps .002 scale <.1,.1,10> rotate y*180}
}

#declare Zinc = texture {
 crackle solid
 texture_map { [0.0 Zinc1] [0.5 Zinc2] [1.0 Zinc3] }
 scale 1
}
  
  

#declare Pig1 = pigment {
 leopard
 color_map {
  [0 SteelBlue]
  [1 Yellow]
 }
 sine_wave
 scale .05
}

#declare Pig2 = pigment {
 wrinkles
 color_map {
  [0.0 Orange]
  [0.5 White]
  [1.0 White]
 }
}

//the complex pigment
#declare Pig3 = pigment {
 bozo
 pigment_map {
 [0 Pig1]
 [1 Pig2]
 }
 triangle_wave
 scale 1.5
}

///------------------------------------------------------
///-----------------------------------------------------

//#declare Text_Tex = texture {
//  pigment { granite scale 0.5 }
//  finish { specular 0.7 }
//}

#macro  MyText(tText, Loc)
text {
  ttf
  "crystal.ttf",
  contact(tText)
  0.1,
  0
  scale 0.3
  translate Loc
  pigment {rgb <1,1,0>}
}
#end

#declare My_Sphere =  sphere { 
  <.2,.2,.2> 2
  pigment { rgb .2 }
  normal {
    julia <-.5,.5> 10 8
    exponent 4
    slope_map { [0 <0,1>][.5 <3,0>][1 <0,1>] }
    scale 1.5
  }
  finish { specular .3 reflection 1.20 }
//  translate y*2
//  scale .15 
//  translate <0,1,0>
}

#declare My_mm = intersection {
text {
  ttf "crystal.ttf", "m",
  0.4, // depth
  0  // spacing
  texture { WHITE_GLASS }  // Text_tex
  translate <-.2,0,-.2>
  scale 100
  rotate <0,-90,0>
}

text {
  ttf "crystal.ttf", "m",
  0.4, // depth
  0  // spacing
  texture { WHITE_GLASS }  // Text_tex
  translate <-.2,0,-.2>
  scale 100
}

//rotate <0,-45,0>
//translate <25, 25, -25>
  scale 1/100
}
  