// Persistence Of Vision Ray Tracer Scene Description File
// File: ID_FMA.POV
// Vers: 3.5
// Desc: 2002/01/15, IRTC Contest FORCE
//      ID_FMA.POV  by Iain Davidson
//
//   This scene is intended to be run as an animation.
//   A brief visual pun about Force being mathematically equivalant
//   to Mass times Accelloration  (i.e. F=ma)
//
//   Made mostly from demo textures and shapes from POVray 3.5 (beta 9)
//   (www.povray.org) for the Internet Ray Tracing Contest (IRTC) at
//   (www.irtc.org.
//
//  If you modify this code, please drop me a note about your revisions.
//  Suggestions about improvements or ideas are encouraged and appriecated.
//   
//  Timeline table of frame count, is located at the bottom of the POV
//  file.   POV file is organized in 'ACT's of the animation, where
//  each component 'actor' has specific 'roles/timing' which they have
//  to do.... independent of each other.
//
// Date: 2002/01/01  to 2002/01/15
// Auth: Iain Davidson   (www.dystopia.org/irtc)
//
// TOOLS:  POV-Ray for Windows 3.5 (beta 9)
//	   All calculations/setup were done by hand.
// 	   BMP2AVI  to Create AVI file
//
// DESC
// +w320 +h240 +a0.3 +kfi0 +kff999
//
// p.s. this is my very first IRTC entry, as an excercise to learning examples for
//      POV-Ray for Windows 3.5  (beta 9)  and about the IRTC process.  In a period
//      of two weeks, I learned POVray 3.5, found the IRTC web site, designed an
//      animation, developed the animation, and submitted my package to IRTC.

#version 3.5;

/// --- Include Files ----

#include "id_fma.inc"

/// --- Global Settings ----

global_settings {assumed_gamma 1.0}


/////////////////////////////////////////////////////
/// --- Lights ----
/////////////////////////////////////////////////////

light_source {		// Put a little Green Light on the subject
  <500, 500, -500>
  color rgb <.7, 1.2, .7>  // .3 .8 .3  // .9
  //igd scale back a little ?
}

light_source {		// Put a little Red Light on the Subject
  <200,600,-400>
  color rgb <1.2,.7,.7>   // .8 .3 .3   // .9
  //igd scale back a little ?  or increase
}


/////////////////////////////////////////////////////
/// --- Sky ----
/////////////////////////////////////////////////////

// POV-Ray 'Sky_sphere' example
sky_sphere {		// Helps with the reflections
  pigment {
    gradient y
    color_map {
	[ 0.0  color SeaGreen ]
        [ 0.3  color CornflowerBlue ]
        [ 1.0  color NewMidnightBlue ]
     }
     scale 2
     translate <0,-100,0>
  }
}

// POV ray, 'fog' example
fog {			// Put a little mystery into it
  fog_type 1               // 1=constant, 2=ground_fog
  distance 30
  
  color gray               // can also have 'filter' and 'transmit'
}

/////////////////////////////////////////////////////
/// --- floor ---
/////////////////////////////////////////////////////
// Want a checker crackle-brown floor or a plain black-white one
#declare FancyFloor = 1 ;   // 0= Draft Rendering

// POV Ray, 'Crackle_Pigment.pov' example
#if (FancyFloor)
#declare My_Floor_T=
  texture {
     checker
     texture {Stone1}
     texture {Stone2}
     scale 10
  }
#else
#declare My_Floor_T=
  pigment {
     checker
     color White
     color Black
     scale 10
  }
#end  
  
// Make a 'Platform' (Half-Sphere) for the objects
intersection {  
  plane {
     y,0
     texture { My_Floor_T }
  }
  sphere {
     <0,0,0>
     100
     texture { My_Floor_T }
 }
}

///////////////////////////////////////////////////////////////////// 
///--------------  RAMP
///////////////////////////////////////////////////////////////////// 

#declare CylX1   = 70;    // Start of Ramp
#declare CylX2   = 170;   // End of Ramp
			// Note: the length of Ramp is (X2 - X1)
		
#declare Cliffx  = CylX2-5;  // Top of Cliff (into Ramp by 5)
#declare Cliffy	 = -90;	     // Bottom Edge Start

#declare RampGrade = .5;

intersection {
   object {		// This is the top edge of Ramp
     plane {y, 0
        texture { My_Floor_T }
	translate <10,0,0>
     }
     rotate <0,0,RampGrade>			// Slight incline....
     translate <CylX1,0,0>    		// We move the pattern to Match 'platform'
   }
   
   object {		// This is the bottom 'half-cylinder' of the Ramp
      cylinder {
   	 <CylX1,0,0>
   	 <CylX2,0,0>
	 10
      }
      texture { My_Floor_T}
   } 
   translate <0,0,0>   // This is where the ramp starts
}

// Cliff + Cut
intersection {
   object {
     plane {y, .5
  //       no_shadow
	pigment { checker BrightGold color rgb <0,1,0> scale 1}
	finish { 
//       	reflection .8 
	    specular 1 
        }
     }
     rotate <0,0,RampGrade>
     translate <Cliffx-10,0,0>
   }

   object { 
 	My_Cliff
	rotate <0,-90,-5>
	translate <Cliffx,Cliffy,-10>
   }
}

// SpotLight
light_source {		// Put a little Red Light on the Subject
  <Cliffx,Cliffy+100,-10>
  color DarkGreen
}


/// ------ SPEED REGULATOR ------
// remember that in .INI you'll have to also increase Final_Frame by factor below
// Add more frames between Frame Counts, by dividing factor.
#declare FramesPerClick=2 ;  
#declare f_n = frame_number/FramesPerClick;


///------ ACT I  -----------------------------------
///------ ACT I  -----------------------------------
///------ ACT I  -----------------------------------

#declare ActIFinal = 71;  //igd 64

#if (f_n<=ActIFinal)

// Major 'Hackish' way of doing a timeline,  in future could define
//  a spline for:  CamLook, CamLoc, FLoc, SphereLoc, RCELoc, RCERot, etc....

// abbreivate f_n vs clock 'tic' for ease of use 
// Added "Slow-Motion' time for the intro-duction
//       endes up offset all f_ns by (SlowMo*SloMoStop) but doesn't effect timings
//       set 'SloMo' to '1' to disable
// Note: Remember to Add More 'Frames' to INI when using this.
//	 (SLoMo*SloMoStop)

#declare SloMo     = 2;
#declare SloMoStop = 12;

#if (f_n<(SloMo*SloMoStop) )
  #declare fn = f_n/SloMo;
#else
  #declare fn = f_n-(SloMoStop*(SloMo-1));
#end

#declare BallMoves = 28;
#declare FramesPerRot  = 24;   // Ball Rotation

#declare CamScan   = 0;
#declare CamStop   = 10;
#declare CamMoves  = BallMoves;
#declare CamFollows= 32;
//#declare CamM	   = 45;
#declare CamEnd    = ActIFinal;

#declare FStart    = 1.5;   //Achnor point for the 'FORCE'
#declare FInto     = 1.5;  // How much into the ball to move it.
#declare FBack     = 12;
#declare FRun      = 20;
#declare FMoves    = 30;
#declare FMHit     = 46;
#declare FEnd	   = ActIFinal;

#declare RCEMoves	= BallMoves;
#declare RCEGone     	= 54;
#declare RCEEnd		= ActIFinal;

//#declare MMoves		= BallMoves;
#declare MStart		= 43;
#declare MEnd		= ActIFinal;


/// --- Camera ----
#switch (fn)
#range (0, CamStop)  // Pan Scan over Title
   #declare CamLoc = < 10, 10, 30-(fn*4)> ;
   #declare CamLook= CamLoc+<0,-5,10>;
   #declare CamRot = <0,0,0>;
  #break
#range (CamStop,CamMoves) // Rest Until the Ball was hit
   #declare CamLoc = < 10, 10, 30-(CamStop*4)> ;
   #declare CamLook= CamLoc+<0,-5,10>;
   #declare CamRot = <0,0,0>;
  #break
#range (CamMoves,CamFollows)       //Forced Ball movement, move camera too
   #declare CamLoc = < 10, 10, 30-(CamStop*4)-(fn-CamMoves)*1>;
   #declare CamLook= CamLoc+<0,-5,10> ;
   #declare CamRot = <0,0+(fn-CamMoves)*10,0>;
  #break
#range (CamFollows,CamEnd)       // Cam Follows the F   igd was CamEnd
   #declare CamLoc = < 10+(fn-CamFollows)*2, 10, 30-(CamStop*4)-(CamFollows-CamMoves)*1+(fn-CamFollows)*2>;
   #declare CamLook= CamLoc+<0,-5,10> ;
   #declare CamRot = <0,0+(CamFollows-CamMoves)*10,0>;
  #break
#end

camera {
  location CamLoc
  look_at  CamLook
  rotate CamRot
}

/////////////////////////////////////////////////////
/// --------------- F -------------------------
/////////////////////////////////////////////////////

#switch (fn)
#range(0,FBack)    // F stays until running start
     #declare FLoc=<FStart,0,0>;
  #break
#range (FBack,FRun)    // F  steps back
     #declare FLoc=<FStart - (fn-FBack)*2,0,0>;
  #break
#range (FRun,BallMoves)    // F  Runs Forward   igd BallMoves - 1
     #declare FLoc=<FStart - (FRun-FBack)*2+(fn-FRun)*2,0,0>;
  #break
#range (BallMoves,FMoves) // F pushes ball out of the way, and stops
     #declare FLoc=<FStart+FInto,0,0>;
  #break
#range (FMoves,FMHit) // F Moves and continues on to Hitting the M
     #declare FLoc=<FStart+FInto+(fn-FMoves)*4,0,0>;
  #break
#range (FMHit,FEnd) // F Moves and continues on
     #declare FLoc=<FStart+FInto+(FMHit-FMoves)*4+(fn-FMHit)*3,0,0>;
  #break
#end

//igd  MY_F  object

text {
  ttf "timrom.ttf", "F",   //crystal.tff
  .2, // depth
  0  // spacing
  texture {
        pigment { granite scale 0.5 }
        pigment {
          pigment_pattern {Pig3}
          color_map {
            [0 OrangeRed*.1]  //.2
            [1 OrangeRed*2.5]     // 1.5
          }
        }
        normal { pigment_pattern {Pig3} .4 }
        finish {phong .8 phong_size 10}
        translate y*2
  }
//  finish { specular 0.7 }
  // rotate <0, -20, 0>
  scale 6

// igd rotate for the ramp
//
  translate FLoc //BallLoc <10, 0, 0>
}


/////////////////////////////////////////////////////
/// --------------- Metal Sphere -------------------------
///  aka  'O'
/////////////////////////////////////////////////////
// Note: Doesn't do much, but in future could re-appear in scene
//

#switch(fn)
#range(0,BallMoves)     // ball stays until pushed
     #declare SphereLoc=<FStart+5,2,0.5>;
     #break
#else          // ball is now moving out of the way
     #declare SphereLoc=<(FStart+(fn-BallMoves)*2)+5,2,0.5-((fn-BallMoves)*2) >;
#end

#declare SphereRot = ( mod(360*(fn/FramesPerRot),360) );

/// Sphere from: POVray 'pgiment_pattern.pov' uses 'Julia4' pattern
object {
  My_Sphere
  rotate <SphereRot,SphereRot,0> //<360*clock,360*clock,0>  //x*360*clock

  translate SphereLoc //<clock*20+4, 1, -clock*20>
}


/////////////////////////////////////////////////////
/// --------------- RCE -------------------------
/////////////////////////////////////////////////////

#switch (fn)
#range(0, RCEMoves)   // RCE stays until pushed
     #declare RCELoc=<FStart+7,0,0>;
     #declare RCERot =<0,0,0>;
     #declare RCEScale = <1,1,1>;
     #break
#range(RCEMoves,RCEGone)  // RCE moves and gets smaller
     #declare RCEfn  = (fn-RCEMoves);
     #declare RCELoc = <FStart+7+RCEfn*3,0+(RCEfn*2)*0+4,0 >;
     #declare RCERot = <0,0,-(fn-RCEMoves)*5>;
     #declare RCESmaller = 1-(.1+fn-RCEMoves)/(RCEGone-RCEMoves);
     #declare RCEScale = <1,RCESmaller,1>;
     #break
#range(RCEGone,RCEEnd)  //  RCE is 'Gone' (i.e. out of Scene under floor) 
     #declare RCEfn  = (fn-RCEMoves);
     #declare RCELoc = <FStart+7+RCEfn*3,0+(RCEfn*2)*0+(-10),0 >;
     #declare RCERot = <0,0,-90>;
     #declare RCEScale = <1,1,1>;
     #break
#end

text {
  ttf "timrom.ttf", "RCE",   //crystal.tff
  .2, // depth
  0  // spacing
  texture {
//     pigment { granite scale 0.5 }

        pigment {
          pigment_pattern {Pig3}
          color_map {
            [0 OrangeRed*.2]
            [1 OrangeRed*1.5]
          }
        }
        normal { pigment_pattern {Pig3} .4 }
        finish {phong .8 phong_size 10}
        translate y*2
  }
//  finish { specular 0.7 }
  // rotate <0, -20, 0>

  scale 6

  translate <-7,0,0>
  rotate RCERot
  translate <7,0,0,>
  
  translate RCELoc // <FStart+7, 0, 0>

  scale RCEScale
}

/////////////////////////////////////////////////////
/// --------------- m -------------------------
/////////////////////////////////////////////////////

#switch(fn)
#range(MStart,MEnd)  // 
	#declare Mfn  = (fn-MStart);
//	#declare MLoc = <FStart+7+Mfn*3,0,0 >;
//	#declare MLoc = RCELoc+<1,-4,0>;
	#declare MLoc = FLoc+<4,0,0>;

	#declare MSmaller = (Mfn+.01)/(MEnd-MStart);  //  0.01 -> 1.01 (avoid 0!)
	#declare MScale = <1,MSmaller,1>;

	object { 
	  My_mm 		// Size = 1
	  scale 6
	  scale MScale   // Opposite than RCE
	  translate MLoc
	} 
#end

/////////////////////////////////////////////////////
/// ------- Opening Text ---------------
/////////////////////////////////////////////////////


text { ttf "timrom.ttf" "IRTC"
 .2*2, 0

  texture {
     T_Glass3
  /**
         Glass                          // use the predefined "glass"
         pigment {color green 0.90 filter 0.85}    // transmit most of it's light
         finish {
             phong 1 phong_size 300          // Very tight highlights
             reflection {0.15}                 // Needs a little reflection added
         }
  **/
  }

/**  Phase I
 texture {
   pigment { color rgbt <0.5, 0.5, 0.7, 0.5> }
   finish { diffuse 0.2 specular 0.6 }
 }
**/
 interior {
    ior 1.5
 }

#if (fn>BallMoves) 		// igd 'fancy' flash needed?
 pigment { color <.1,0,0> }
#end

 scale 5
 translate <10, 0, 8>
}

text { ttf "timrom.ttf" "Jan 15 2002"
 .2*2, 0

 texture {
   pigment { color rgbt <0.5, 0.5, 0.7, 0.5> }
   finish { diffuse 0.2 specular 0.6 reflection 2.20 }  // reflect 1.2
 }
 interior {
    ior 1.5
 }
 scale 5
 translate <-6, 0, 13>
}

text { ttf "timrom.ttf" "www.dystopia.org/irtc"
    .1*2, 0
    scale 3.5
    texture {
       pigment {Col_Glass_Green }
    }
    interior  {I_Glass}

// igd better?

    finish { 
       phong 1
       phong_size 300          // Very tight highlights
       reflection {0.1}  // .55
    } 
  translate <-6, 1.2, 20>
}

text { ttf "timrom.ttf" "By Iain Davidson"
    .2*2, 0
    scale 5
    pigment {
    	Pig3
    }
//  normals { wrinkles 0.5 }   // create a wrinkly surface (0...1 or more)
  translate <-8, 0, 30>
  }


text { ttf "timrom.ttf" "ID-FMA"
    .2*2, 0
    scale 5
    pigment {
    	Pig3
    }
//  normals { wrinkles 0.5 }   // create a wrinkly surface (0...1 or more)
  translate <1.4, 0, 40>
  }

#end  /// end of Act I


///-------- Act II ----------------------------------
///-------- Act II ----------------------------------
///-------- Act II ----------------------------------
#declare ActIIFinal=110;

#if ( (f_n>ActIFinal) & (f_n<=ActIIFinal) )

/// Re-Adjust Counter to something new
/// Start over again from Zero... 0 ....
/// ( this allows additions to the First Act without effecting the following Acts }
#declare fn = f_n-ActIFinal;

// Note: Be aware this is based on F last location from Act I, manually updated
#declare  FLast = <107,0,0>
#declare  FSlow = 20;
#declare  FFall = FSlow+6
#declare  FEnd  = ActIIFinal-ActIFinal;

#declare  MSlow = FSlow;
#declare  MFall = FSlow+3;
#declare  MEnd  = ActIIFinal-ActIFinal;

#declare CamStop = FSlow;
#declare CamZoom = FSlow+6;
#declare CamFall2 = CamZoom+10;
#declare CamEnd	 = CamFall2+20;
   
/////////////////////////////////////////////////////
/// --------------- F -------------------------
/////////////////////////////////////////////////////

#switch(fn)
#range(0,FSlow)
	#declare FLoc=FLast+<(fn)*2.5,0,0>;
	#break
#range(FSlow,FFall)   			// F Slows down to the edge
	#declare FLoc=FLast+<(FSlow*2.5)+((fn-FSlow)*1.5),0,0>;
	#break
#range(FFall,FEnd)   			// F Slows down to the edge
	#declare FLoc=FLast+<(FSlow*2.5)+((fn-FSlow)*1.5),0-(fn-FFall)*.5,0>;
	#break
#end

//igd  MY_F object

// #declare F_Text = concat("F-" str(frame_number,0,0) "-"str(f_n,0,1) "-" str(fn,0,1) ); // Debugging
#declare F_Text = "F";

text {
  ttf "timrom.ttf", F_Text,   //crystal.tff
  .2, // depth
  0  // spacing
  texture {
//        pigment { granite scale 0.5 }
        pigment {
          pigment_pattern {Pig3}
          color_map {
            [0 OrangeRed*.1]  //.2
            [1 OrangeRed*2.5]     // 1.5
          }
        }
        normal { pigment_pattern {Pig3} .4 }
        finish {phong .8 phong_size 10}
        translate y*2
  }
//  finish { specular 0.7 }
  // rotate <0, -20, 0>
  scale 6

// Going up the floor
  translate FLoc-<CylX1,0,0>
  rotate <0,0,RampGrade>
  translate <CylX1,0,0>
//or  
//  translate FLoc
}

/////////////////////////////////////////////////////
/// --------------- m -------------------------
/////////////////////////////////////////////////////
//#declare  MLast = <107,0,0>

#switch(fn)
#range(0,MSlow)
	#declare MLoc = FLoc+<4,0,0>;
	#break
#range(MSlow,MFall)			// After the F slows down, M moves on
	#declare MLoc = FLoc+<4+(fn-MSlow)*2.5,0,0>;
	#break
#range(MFall,MEnd)			// M drifts off the edge
	#declare MLoc = FLoc+<4+(MFall-MSlow)*2.5+(fn-MFall)*2, 0-(fn-MFall)*.5,0>;
	#break
#end

object { 
  My_mm 			// Size = 1
  scale 6

// Going up the floor/ramp
  translate MLoc-<CylX1,0,0>
  rotate <0,0,RampGrade>
  translate <CylX1,0,0>

//  translate MLoc
}

/////////////////////////////////////////////////////
/// --------------- Camera -------------------------
/////////////////////////////////////////////////////

/// --- Camera ----  Panning along with M
#switch(fn)
#range(0,CamStop)
	#declare CamLoc = <130+(fn*1), 20-(fn*.5), -25>;
	#declare CamLook= MLoc ;
	#break
#range(CamStop,CamZoom)
	#declare CamLoc = <130+(CamStop*1)+(fn-CamStop)*5, 20-(CamStop*.5)-((fn-CamStop)*.5), -25+(fn-CamStop)*3>;
	#declare CamLook= MLoc ;
	#break
#range(CamZoom,CamFall2)
	#declare CamLoc = <130+(CamStop*1)+(CamZoom-CamStop)*5+(fn-CamZoom)*5, 20-(CamStop*.5)-((CamZoom-CamStop)*.5), -25+(CamZoom-CamStop)*3+(fn-CamZoom)*.7>;
	#declare CamLook= MLoc ;
	#break
#range(CamFall2,CamEnd)
	#declare CamLoc = <130+(CamStop*1)+(CamZoom-CamStop)*5+(CamFall2-CamZoom)*5, 20-(CamStop*.5)-((CamZoom-CamStop)*.5), -25+(CamZoom-CamStop)*3+(CamFall2-CamZoom)*.7>;
	#declare CamLook= MLoc ;
	#break
#range(CamEnd,999)
	#break
#end

camera {
  location CamLoc 	// +<(((10))),(((20))),-(((20)))> debuging
  look_at  CamLook
}

//----------------------------------------------------------------------------------
//----  2nd Platform, or is that Third ?  ------------------------------------------
//----------------------------------------------------------------------------------

intersection {  
  plane { y,0
     texture { My_Floor_T }
  }
  sphere { <0,0,0> 100
     texture { My_Floor_T }
 }
 translate <Cliffx+50,Cliffy,-50>
}


#end


///-------- Act III ----------------------------------
///-------- Act III ----------------------------------
///-------- Act III ----------------------------------
#declare ActIIIFinal = ActIIFinal+9;

#if ( (f_n>ActIIFinal) & (f_n<=ActIIIFinal) )

#declare fn = f_n-ActIIFinal;

//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
/** 
   Note, Ran out of time to implement the original idea of squashing POV logo
         and showing the 'irtc' disc. 

/// ---- Logo ---------------------------
/// ---- Logo ---------------------------
/// ---- Logo ---------------------------
#declare DiscRot=<360*(fn/16),0,0>

#swtich(fn)
#range(0,LogoHit)
	#declare LogoScale=<1,1,1>
	#declare DiscLoc=<0,0,0>
	#break
#range(LogoHit,Squash)
	#declare LogoScale=<.1,.1,.1>
	#declare DiscLoc=<-60,5,0>
	#break
#range(Squash,Expand)
	#declare LogoScale=<.1,.1,.1>
	#declare DiscLoc=<-60,5,0>
	#break
#end


#include "logo.inc"
#declare LogoPigment =
pigment {
   planar scale 2 translate y
   color_map {
      [0.0, color <1.0, 0.4, 0.4>] // Red
      [0.5, color <0.4, 0.9, 0.4>] // Green
      [1.0, color <0.4, 0.4, 1.0>] // Blue
   }
}
camera {
  location <7,10,7>
  look_at  <0,4,0>
}

object {
   Povray_Logo_Bevel
   pigment {LogoPigment}
   rotate -360*((frame_number)/16) * y
   scale 2
   translate <-50,0,60>
   scale LogoScale
}

#include "irtc_disc.inc"

***/

/// ---- mmmm ---------------------------
#declare   MEnd=10;

#switch(fn)
#range(0,MEnd)
	#declare MLoc = <12, 26-(fn-0)*3, 40>;
	#break
#end

object { 
  My_mm
  scale 6

  translate MLoc
}

/// --- Camera ----  Panning along with M
#declare CamLoc  = < 10, 10, 30>;
#declare CamLook = < 10, MLoc.y, MLoc.z >;

camera {
  location CamLoc
  look_at  CamLook
}

text { ttf "timrom.ttf" "ID-F  a"
    .2*2, 0
    scale 5
    pigment {
    	Pig3
    }
//  normals { wrinkles 0.5 }   // create a wrinkly surface (0...1 or more)
  translate <1.4, 0, 40>
  }


#end


///-------- Act X ----------------------------------
///-------- Act X ----------------------------------
///-------- Act X ----------------------------------

#declare ActXFinal=ActIIIFinal+10;
#if ( (f_n>=ActIIIFinal) & (f_n < ActXFinal) )

////-----------------------------------------------------------------------------
/////////////////////////////////////////////////////
/// ------- Closing Text ---------------
/////////////////////////////////////////////////////
////-----------------------------------------------------------------------------


//// Ending Text
plane {z, 35.5
       pigment { color NavyBlue }
}

text { ttf "timrom.ttf" "F = m a"
  .2*2, 0 scale 1
  pigment { Firebrick }
  translate <8.5, 12.3, 35>
  }

text { ttf "timrom.ttf" " Force"
  .2*2, 0 scale 1
  pigment { Firebrick }
  translate <6, 11, 35>
  }

text { ttf "timrom.ttf" "  = mass"
  .2*2, 0 scale 1
  pigment { Firebrick }
  translate <7, 10, 35>
  }

text { ttf "timrom.ttf" "  x acceleration"
    .2*2, 0 scale 1
    pigment { Firebrick }
   translate <6, 9, 35>
  }

text { ttf "timrom.ttf" " (c) Copyright www.dystopia.org/irtc"
    .2*2, 0  scale .4
    pigment { White }
   translate <6, 8.2, 35>
  }

#declare CamLoc  = < 9, 12, 30>;
#declare CamLook = < 9, 10, 40> ;

camera {
  location CamLoc
  look_at  CamLook
}


#end


/*******************************************************************************
       thumbnail of Timeline of Frame action
       
   Clock = 0..1 for entire presentation
   fn    = 0..999  frames of presentation

- ACT I - (Clicks are aprox)
000 -		= opening title  (moving back over text
012 -		=  F moves back
020 -		= F moves forward Into
028 -		= F hits letters
030 -		= letters scatter
033 -		= as F moves forward
045		= RCE becomes M
000		= Meets 'M'
040 -  069	= Pushes M, faster and faster

- ACT II -
040 -  069	= Pushes M, across ramp
070 -		= see cliff
080 -		= F stops
085		= M continues

- ACT III -
090		= M falls down
095		= Camera shot up
100		= watches M fall down cliff
110		= glance down, see Logo

- ACT IV -
115		= looks up
120		= glanes back and forth
125		= watches fall down
130		= squashes logo
135		= m springs back up

- ACT V -

140		= 'a' makes an appearance instead
145		= standing on 'award'
150		= F falls down
151		= hits M coming back up
155		= F M A

- ACT VI -
160		= Pause (gray screen)
165		= Force = Mass x Acceloration (veritical reading)
170		= Twists text
175		= F = m a

- ACT VII -
185		= Add titles 
180		= fall to floor
190		= fade out away
190		= fade to close to intro as possible.

...	...	= Ending matches beginning to make a loop


TODO list:   (i.e. not enough time to implement......)
-	Update all lines with 'igd' by them
-	Move all standard objects to a 'inc' file.
-	Clean up comments consistant indent
-    Fix 'ACTCXXXFinal' counting, should be indepndent of each other       
*****************************************************************************/

