// Persistence of Vision Ray Tracer Scene Description File
// File: nena.pov
// Vers: 3.1g
// Desc: pawn/girl
// Date: Jan 03 2002
// Auth: Gustavo Reyes
//

//******************************************************GIRL DEFINITION
// all objects are centered in 0,0,0 axis for
// later arrange to make different movements

#declare cuerpog = cone { -2.75*y, 3.8,  2.75*y, 1.2 pigment { SpicyPink } }
#declare cabezag = sphere { 0, 4.4 }

#declare hombror = object { softsquare (1) scale <.4, 1, .4> }
#declare brazor = cylinder { <-4, 0, 0>, < 0, 0, 0>, .4 }

#declare hombrol = object { softsquare (1) scale <.4, 1, .4> }
#declare brazol = cylinder {  <4, 0, 0>, <0, 0, 0>, .4 }

#declare chuflin = union {
        object { softsquare (.3) scale <.4, .8, .4> }
        object { softtriangle (.2) rotate -90*y translate -1*x }
        object { softtriangle (.2) rotate 90*y translate 1*x }
        rotate -90*x }
#declare chuflinr = object { chuflin rotate <0, 90, -15> translate <-4.4, 9.5, 0> }
#declare chuflinl = object { chuflin rotate <0, 90,  15> translate <4.4, 9.5, 0> }

#declare pelor = create_spline ( 
   array[4] { 
   < 0.0, 6.0, 0.0>,
   <-1.0, 8.0, 0.0>,
   <-2.0, 4.0, 0.0>,
   <-2.0,-10.0, 0.0> },
   create_hermite_spline + spline_sampling (on)
   + spline_translate (<0, 4, 0>) ) 

#declare pelol = create_spline ( 
   array[4] { 
   < 0.0, 6.0, 0.0>,
   < 1.0, 8.0, 0.0>,
   < 2.0, 4.0, 0.0>,
   < 2.0,-10.0, 0.0> },
   create_hermite_spline + spline_sampling (on)
   + spline_translate (<0, 4, 0>) )

#declare pelo = union {
        create_spline_object (pelor, spline_steps (30)+ spline_translate (-4.4*x) )
        create_spline_object (pelor, spline_steps (30)+ spline_rotate (-15*y)+ spline_translate (-4.4*x) )
        create_spline_object (pelor, spline_steps (30)+ spline_rotate ( 15*y)+ spline_translate (-4.4*x) )
        create_spline_object (pelol, spline_steps (30)+ spline_translate (4.4*x) )
        create_spline_object (pelol, spline_steps (30)+ spline_rotate (-15*y)+ spline_translate (4.4*x) )
        create_spline_object (pelol, spline_steps (30)+ spline_rotate ( 15*y)+ spline_translate (4.4*x) )
        pigment { color Orange }
        }

#declare pupila = sphere { 0, .5 scale <2, 2, .3> pigment { color White } }
#declare iris = sphere { 0, .5 scale <1, 1.2, .55> pigment { color Black } }

#declare parpador = difference {
        sphere { 0, .5 scale <2, 2, .6> pigment { color Gray30 } }
        sphere { 0, .5 scale <3, 4, 1> pigment { color Black } translate -1.2*y
                #declare clock_type = "Triangle"
                #declare clock_repeat = 1;
                //#declare clock_start = .1
                #include "clockmod.inc"
                translate -1*y*mclock
                #declare clock_combine = ""
                }
        }
#declare parpadol = difference {
        sphere { 0, .5 scale <2, 2, .6> pigment { color Gray30 } }
        sphere { 0, .5 scale <3, 4, 1> pigment { color Black } translate -1.2*y
                #declare clock_type = "Triangle"
                #declare clock_repeat = 1;
                #include "clockmod.inc"
                translate -1*y*mclock
                #declare clock_combine = ""
                }
        }

#declare ceja = difference {
                cylinder { <0, 0, -.2>, <0, 0, .2>, 1 }
                sphere { 0, .6 scale <2, 1.5, 3> translate -.1*y }
                pigment { color Gray20 } }

#declare reye = union {
        object { pupila }
        object { iris }
        object { parpador }
        object { ceja rotate -8*z translate <0, .6, .2> }
        }

#declare leye = union {
        object { pupila }
        object { iris }
        object { parpadol }
        object { ceja rotate -10*z translate <-.1, .5, .2> }
        }

//******************************************GIRL STANDING W/EYES MOVING

#declare nenadepie = union {
        object { cuerpog translate 2.75*y }
        object { cabezag translate 8.75*y }
        object { hombror rotate 8*z translate <-2, 3.4, 0> }
        object { brazor rotate 8*z translate <-2, 3.4, 0> }
        object { hombrol rotate -8*z translate <2, 3.4, 0> }
        object { brazol rotate -8*z translate <2, 3.4, 0> }
        object { reye scale 1.3*x
                      rotate 30*y
                      rotate -8*x
                      scale 1.5
                      translate <-2.2, 8, -3.7> }
        object { leye rotate -30*y
                      rotate -8*x
                      scale 1.4
                      translate <2.1, 8, -3.7> }
        object { chuflinr pigment { color SpicyPink } }
        object { chuflinl pigment { color SpicyPink } }
        object { pelo }
        pigment { color Orange }
        }

//*********************************************************GIRL WALKING
//girl, standing on floor plane 0*y moving her eyes and rotating arms
//in 180 degrees way like she was walking

#version 3

#declare arm_r = object { brazor
                /*#declare clock_type = "oscillation"
                        #declare clock_repeat = 0;
                        #include "clockmod.inc"
                        rotate  55*y*mclock
                
                #declare clock_combine = "" */
                rotate 8*z translate <-2, 3.4, 0>}

#declare arm_l = object { brazol
                /*#declare clock_type = "oscillation"
                                #declare clock_repeat = 0;
                                #include "clockmod.inc"
                                rotate  55*y*mclock
                
                #declare clock_combine = "" */
                rotate -8*z translate <2, 3.4, 0>}

#version 3.1
#declare nena_arms = union {        
        object { cuerpog translate 2.75*y }
        object { cabezag translate 8.75*y }
        object { hombror rotate 8*z translate <-2, 3.4, 0> }
        object { hombrol rotate -8*z translate <2, 3.4, 0> }
        object { reye scale 1.3*x rotate 30*y 
                      rotate -8*x  scale 1.5
                      translate <-2.2, 8, -3.7> }
        object { leye rotate -30*y rotate -8*x
                      scale 1.4 translate <2.1, 8, -3.7> }
        object { arm_r }
        object { arm_l }
        object { chuflinr pigment { color SpicyPink } }
        object { chuflinl pigment { color SpicyPink } }
        object { pelo }
        pigment { color Orange }
        }

//*********************************************************GIRL SHEARED
//the same girl as before, in a fast walk, the matrix shears she, to
//make more realistic her walk

#declare nena_jump = object { nena_arms
                #declare clock_type = "jump"
                                #declare clock_repeat = 3;
                                #include "clockmod.inc"
                                translate 2*y*mclock
                #declare clock_combine = ""
                pigment { color Orange } }



//object { nenadepie  pigment { color Orange } }
//object { nena_arms pigment { color Orange } }
#declare nena_jump1 = object { nena_jump
                matrix
                        < 1.0, 0.0, 0.0,
                          0.0, 1.0, -.5,
                          0.0, 0.0, 1.0,
                          0.0, 0.0, -1>
                }

//still unfinished: nena_head_yes

//***************************************GIRL MOVING HEAD LEFT TO RIGHT
#include "clockmod.inc"
#declare sayno = union {
                object { cabezag translate 8.75*y }
                object { reye scale 1.3*x
                              rotate 30*y
                              rotate -8*x
                              scale 1.5
                              translate <-2.2, 8, -3.7> }
                object { leye rotate -30*y
                              rotate -8*x
                              scale 1.4
                              translate <2.1, 8, -3.7> }
                object { chuflinr pigment { color SpicyPink } }
                object { chuflinl pigment { color SpicyPink } }
                object { pelo }
                #declare clock_type = "recoil"
                                #declare clock_repeat = 1;
                                #include "clockmod.inc"
                                rotate 55*y*mclock
                }

#declare nena_no = union {
        object { cuerpog translate 2.75*y }
        object { hombror rotate 8*z translate <-2, 3.4, 0> }
        object { brazor rotate 8*z translate <-2, 3.4, 0> }
        object { hombrol rotate -8*z translate <2, 3.4, 0> }
        object { brazol rotate -8*z translate <2, 3.4, 0> }
        object { sayno }
        pigment { color Orange }
        }