// Persistence of Vision Ray Tracer Scene Description File
// File: scene.pov
// Vers: 3.1g
// Desc: this is the main movie scene, from wich the render starts
// Date: 01/08/2002
// Auth: Gustavo Reyes 

#include "colors.inc"
#include "stage.inc"
#include "spline.mcr"
#include "softform.inc"
#include "nena.v1.inc"
#include "nene.v1.inc"
//#include "axis.inc"
#include "fromsky.inc"
#include "hiper_cube.inc"

default { finish { phong .5 phong_size 100 ambient .5 diffuse .6 }
        pigment { color Red } }

//scene 1 :the boy  walks from the 0*x to 80*x, and the girl get out
//         from her home
//scene 2: the camera takes back and fade with bumps over the lens
//scene 3: the girl is being seen from her left side, turns her head
//         making a smile and puts her right eye wide shut 
//scene 4: the girl turn her head and kiss the boy sheared
//scene 5: psicologicals forces objects falls from the sky, over the boy
//scene 6: finally girls walk with a smile, over the camera

//******************************************************************************
//****
//**** SCENE 11
//****
//******************************************************************************
// rendered with +kfi841 +kff880 -d +ft +w480 +h360 command line parameters

#include "skies.inc"
sky_sphere { S_Cloud2 }

#include "clockmod.inc"
object { plato }
object { block2 }
object { block3scene }

object { cubo scale 9 rotate 90*x
                rotate -90*y
                translate <126, 1, -22> }

camera { location <145, 10, -14> look_at <125, 9.5, -14>
         translate 3*x translate -2*y*clock }

#declare travel = create_spline ( 
   array[4] { 
   <121, 1, -7>,
   <135, 1, -9>,
   <130, 1, -14>,
   <145, 1, -15>,
 },
   create_bezier_spline + spline_sampling (on))
//preview_spline (travel, + spline_accuracy (1))

object { nena_jump rotate 180*y
        animate_by_spline (travel, auto_banking (1/2))}

object { nene_no rotate -90*y translate <119, 0, -18> }
