// Draw a castle in the distance
#include "CommonDefinitions.inc"
#include "textures.inc"
#include "colors.inc"
#include "stones.inc"
#include "woods.inc"

#declare CastleWall =
  difference {
    box {
      <-WallLength / 2, 0, 0>
      <WallLength / 2, WallHeight, WallDepth>
    }
    box {
      <-WallLength, WallHeight + 1*cm, 30*cm>
      <WallLength, WallHeight - 1.8*m, WallDepth - 30*cm>
    }
    #ifndef (fastRender)
      #local i = 1;
      #while ( i < WallLength )
        box {
          <-WallLength / 2 + i, WallHeight + 1*cm, -1*cm>
          <-WallLength / 2 + i+1*m, WallHeight - 1*m, WallDepth +1*cm>
        }
        #declare i = i + 2;
      #end
    #end  
  }    

#declare CastleTurret =
    union {
      cylinder {
        <0, 0, 0>
        <0, 25*m, 0>    
        5*m
      }  
      cone {
        <0, 25*m, 0>
        5*m
        <0, 30*m, 0>
        7*m
      }
      difference {
        cylinder {
          <0, 30*m, 0>
          <0, 35*m, 0>
          7*m
        }
        cylinder {
          <0, (35-1.8)*m, 0>
          <0, 36*m, 0>
          7*m - 30*cm
        }    
      }
    }
          
union {
  object {
    difference {
      object { CastleWall }
      union { cylinder { <0, 10*m, -100*m > <0, 10*m, 10*m> 4*m } box { <-4*m, 0, -100*m> <4*m, 10*m, 10*m> } }
    }
  }    
  object { CastleWall rotate 90*y translate <-WallLength/2, 0, WallLength/2> }
  object { CastleWall rotate -90*y translate <WallLength/2, 0, WallLength/2> }
  object { CastleWall rotate 180*y translate <0, 0, WallLength> }
  object { CastleTurret translate <-WallLength / 2 + WallDepth/2, 0, WallDepth/2> }
  object { CastleTurret translate <WallLength / 2 - WallDepth/2, 0, WallDepth/2> }
  object { CastleTurret translate <-WallLength / 2 + WallDepth/2, 0, WallLength-WallDepth/2> }
  object { CastleTurret translate <WallLength / 2 - WallDepth/2, 0, WallLength-WallDepth/2> }
  //texture { brick texture { pigment { color rgb <0.3, 0.2, 0.35> } } texture { T_Stone8 } scale 0.2 }
  texture { T_Stone8 }
    
}
      
union {
  cylinder {
    <0, 10*m, 1*m >
    <0, 10*m, 1.3*m>
    4*m
  }
  box {
    <-4*m, 0, 1*m>
    <4*m, 10*m, 1.3*m>
  }
  texture { T_Wood1}
}

#declare HAS_NORTH_WINDOW = 1;
#declare HAS_SOUTH_WINDOW = 2;
#declare HAS_EAST_WINDOW = 4;
#declare HAS_WEST_WINDOW = 8;
#declare HAS_ALL_WINDOWS = HAS_NORTH_WINDOW + HAS_SOUTH_WINDOW + HAS_EAST_WINDOW + HAS_WEST_WINDOW;

#macro DrawTurret( pRadius, pHeight, pRoofHeight, pWindows )
  #local top= (pHeight-2*m) -1*m;
  #local bottom = 0.85*pHeight + 1*m;
  #local aRadius = (top - bottom) / 4;
  #local _windowCutout =
      union {        
        cylinder {
          <0, top - aRadius, 0>
          <0, top-aRadius, -100*m>
          aRadius
        }
        box {
          <-aRadius, bottom, 0>
          <aRadius, bottom + 3*aRadius, -100*m>
        }
      }
      
  #local _windowDecoration =     
      union {
        intersection {
          difference {
            cylinder { <0, 0, 0> <0, pHeight, 0> pRadius +40*cm }          
            cylinder { <0, 0, 0> <0, pHeight, 0> pRadius -40*cm }
          }
          box { <-aRadius-40*cm, bottom+1*mm, 0> <aRadius + 40*cm, bottom - 40*cm, -1000*m> }
          texture { T_Stone3 }
        }
        
        // Do the finish around the window  
        #local _angle = 0;
        #while ( _angle < 180 )
          intersection {
            difference {
              cylinder { <0, 0, -1000> <0, 0, 1000> aRadius+40*cm }
              cylinder { <0, 0, -1001> <0, 0, 1001> aRadius-1*mm }
            }
            plane { -y 0 rotate (_angle+1)*z }
            plane { y 0 rotate (_angle+29)*z }
            difference {
              cylinder { <0, 0, 0> <0, pHeight, 0> pRadius+1*cm }
              cylinder { <0, 0, 0> <0, pHeight, 0> pRadius-31*cm }
              translate pRadius*z
            }  
            translate <0, top-aRadius, -pRadius>
            texture { T_Stone3 }
          }
          #declare _angle = _angle + 30;          
        #end
        
        // Now do the bits down the sides
        #local aHeight = bottom;
        #while (aHeight < top-aRadius)   
          #local _nextHeight = aHeight + (top - bottom - aRadius) / 6;
          intersection {
            difference {
              box {<-aRadius-40*cm, aHeight+1.5*cm, 0> <aRadius+40*cm, _nextHeight - 1*cm, -1000>}
              box {<-aRadius+1*cm, 0, 0> <aRadius-1.5*cm, 1000, -1000>}
            }  
            difference {
              cylinder { <0, 0, 0> <0, pHeight, 0> pRadius+1*cm }
              cylinder { <0, 0, 0> <0, pHeight, 0> pRadius-31*cm }
            }
            texture { T_Stone3 }
          }    
          #local aHeight = _nextHeight;
        #end
              
      }  
          
  union {          
    difference {
      cylinder {
        <0, 0, 0>
        <0, pHeight, 0>
        pRadius
      }  
      cylinder {
        <0, 0.85*pHeight, 0>
        <0, pHeight - 2*m, 0>
        pRadius - 30*cm
      }
      #if ( pWindows & HAS_SOUTH_WINDOW )
        object { _windowCutout }
      #end
      #if ( pWindows & HAS_NORTH_WINDOW )
        object { _windowCutout rotate 180 * y }
      #end
      #if ( pWindows & HAS_EAST_WINDOW )
        object { _windowCutout rotate 90*y }
      #end
      #if ( pWindows & HAS_WEST_WINDOW )
        object { _windowCutout rotate 270*y }
      #end
      texture { T_Stone8 }
    }  
    
    #if ( pWindows & HAS_SOUTH_WINDOW )
      object { _windowDecoration }
    #end
    #if ( pWindows & HAS_NORTH_WINDOW )
      object { _windowDecoration rotate 180 * y }
    #end
    #if ( pWindows & HAS_EAST_WINDOW )
      object { _windowDecoration rotate 90*y }
    #end
    #if ( pWindows & HAS_WEST_WINDOW )
      object { _windowDecoration rotate 270*y }
    #end

    #if (pRoofHeight > 0)
      cone {
        <0, pHeight, 0>
        pRadius+1*m
        <0, pHeight+pRoofHeight, 0>
        0
        texture {
          pigment {
            brick
            Black
            MidnightBlue
          }
          scale 0.1
        }
      }
    #end  
  }  
#end

// Inside the walled fence. The wizard's residence
union {
  difference {
    box {
      <-40*m, 0, 90*m>
      <40*m, 10*m, 40*m>
    }
    box {
      <-40*m + 30*cm, 10.1*m, 90*m-30*cm>
      <40*m - 30*cm, 10*m-1.8*m, 40*m+30*cm>
    }
    texture { T_Stone8 }
  }
             
  object { DrawTurret( 8*m, 50*m, 15*m, HAS_ALL_WINDOWS) translate 75*m*z }
  object { DrawTurret( 5*m, 30*m, 10*m, HAS_ALL_WINDOWS ) translate <30*m, 0, 60*m>  }
  
  cylinder {
    <0, 20*m, 75*m>
    <-20*m, 40*m, 75*m>
    4*m
    clipped_by {
      box {
        <0, 0, 0>
        <-100, 35*m, 100>
      }
    }
    texture { T_Stone8 }    
  }
                 
  object { DrawTurret( 5*m, 10*m, 7.5*m, HAS_ALL_WINDOWS) translate <-15*m, 35*m, 75*m> }
}    

