#ifndef (__COMMON_DEFINITIONS__)
#declare __COMMON_DEFINITIONS__ = true;

#include "ConversionUnits.inc"
#declare WallLength = 100*m;
#declare WallHeight = 20*m;
#declare WallDepth = 3*m;


#macro  From( _startPos, _startTime )
  #declare __startClock__ = _startTime;
  _startPos
  #declare __startPos__ = _startPos;
#end

#macro To( _endPos, _endTime )
  #if (vClock > __startClock__)
    #if (vClock <= _endTime)
      #declare __loc__ = ((vClock - __startClock__) / (_endTime - __startClock__))*(_endPos - __startPos__);
    #else
      #declare __loc__ = (_endPos - __startPos__);
    #end
    #declare __startClock__ = _endTime;
    #declare __startPos__ = _endPos;    
     + __loc__
  #end  
#end

#macro  Declare_From( _variable, _startPos, _startTime )
  #declare __startClock__ = _startTime;
  #declare _variable = _startPos;
  #declare __startPos__ = _startPos;
#end

#macro Declare_To( _variable, _endPos, _endTime )
  #if (vClock > __startClock__)
    #if (vClock <= _endTime)
      #declare __loc__ = ((vClock - __startClock__) / (_endTime - __startClock__))*(_endPos - __startPos__);
    #else
      #declare __loc__ = (_endPos - __startPos__);
    #end
    #declare __startClock__ = _endTime;
    #declare __startPos__ = _endPos;    
    #declare _variable = _variable + __loc__;
  #end  
#end


#macro Interpolate(pVar, pPos1, pTime1, pPos2, pTime2 )
  #if (vClock <= pTime1)
    #declare loc = pPos1;
  #else
    #if (vClock >= pTime2)
      #declare loc = pPos2;
    #else
      #declare loc = (pPos1 + ((vClock - pTime1)/(pTime2-pTime1))*(pPos2-pPos1));
    #end
  #end
  #declare pVar = loc   
#end


#macro clockToSegmentTime( pClock, pSegmentTimes )
  #local sum = 0;
  #local i = 0;
  #local counter = 0;
  #while (i < dimension_size( pSegmentTimes, 1 ) )
    #local sum = sum + pSegmentTimes[i];
    #if (pSegmentTimes[i] > 0)
      #declare counter = counter + 1;
    #end  
    #declare i = i + 1;
  #end
  #if (!clock_on)
    #local j = 0;
    #local i = 0;
    #while (i < dimension_size( pSegmentTimes, 1 ) )
      #debug concat("Frame ", str(i+1, 2, 0), ": ", str( j, 4, 4), " -> ", str( j + pSegmentTimes[i]/sum, 4, 4), "\n")
      #local j = j + pSegmentTimes[i]/sum; 
      #declare i = i + 1;
    #end
  #end
  #debug concat( "Total animation length = ", str(sum, 4, 4), " seconds [", str(sum*25, 1, 0)," frames] over ", str(counter, 1, 0), " positive sized segments\n" )
  #declare sTime = 0;
  #local i = 0;
  #while ( i < dimension_size( pSegmentTimes, 1 ) )
    #declare eTime = sTime + pSegmentTimes[i]/sum;
    #declare segment = i+1;
    #if ((pClock >= sTime) & (pClock <= eTime))
      // This is the current segment
      #declare i = dimension_size( pSegmentTimes, 1 );
    #else
      #declare sTime = eTime;
    #end    
    #declare i = i + 1;
  #end
     
//  #if ((pClock > eTime) | (pClock < sTime) )
//    #error concat( "pClock = ", str( pClock, 4, 4), " but is not in the range (", str( sTime, 4, 4), " to ", str( eTime, 4, 4 ), "\n" )
//  #end
  #debug concat( "At clock = ", str( pClock, 4, 4 ), ", segment = ", str( segment, 1, 0), ", time Range = [", str( sTime, 4, 4), ", ", str( eTime, 4, 4), "]\n")
#end

#end  // ifndef