#declare height1 = 50*m*0.85;

// Draw the ground
#declare Ground = 
  union {
    lathe { // RotSweep001
      cubic_spline
      13  // control points
      <1.0, -1.0>,
      <4.179476, -0.308568>,
      <4.660902, -0.036386>,
      <4.128765, -0.000637>,
      <3.448075, 0.047757>,
      <2.801353, 0.317766>,
      <2.018855, 0.591807>,
      <1.518652, 1.107702>,
      <1.140583, 1.599099>,
      <0.721429, 1.671909>,
      <0.348144, 1.679326>,
      <0.009445, 1.676388>,
      <-0.046931, 1.673887>
      scale <150, 100, 150>
      translate -100*y*1.673887
    }
    
    plane {
      y
      0
      translate -100*y*1.673887
    }
    sphere  {
      <0, -18*m, -940*m>
      20*m
      translate -100*y*1.673887
    }  
    material {
      texture {
        pigment {
          bozo
          color_map {
            [0 color rgb <0, 0.3, 0>]
            [0.3 color rgb <0, 1, 0>]
            [0.7 color rgb <0, 1, 0>]
            [0.9 color rgb <0.25, 0.8, 0.125>]
            [1.0 color rgb <0.25, 0.5, 0.125>]
          }
          turbulence 3  
          scale 30
        }
        finish {
          reflection 0
        }  
      }
    }
  }



background { color rgb <0.2, 0.1, 1> }

#declare SimpleTree =
    union {
      cone {
        <0, 1*m, 0>
        4*m
        <0, 12*m, 0>
        0
        texture {
          pigment {
            leopard
            color_map {
              [0 color rgbt <0, 0, 0, 1>]
              [0.05 color rgbt <0, 0, 0, 1>]
              [0.05001 color rgb <0.2, 0.4, 0.1>]
              [0.1 color rgb <0, 0.4, 0>]
              [1 color rgb <0, 1, 0>]
            }                
            turbulence 2.5
          }
        }
      }
      cylinder {
        <0, 0, 0>
        <0, 1.1*m, 0>
        0.7
        pigment { color Brown }
      }
    }

object { Ground }    

#ifndef (fastRender)        
  #declare ExclusionZone = 
      union {
        box {
          <-WallLength/2 - 30*m, 0, -30*m>
          <WallLength/2 + 30*m, 0.1, WallLength + 30*m>
        }
        box {
          <-10*m , 0, 0>
          <10*m, 0.1, -1000*m>
        }
      }
  
  #declare TreeRnd = seed( 1000 );
  #declare i = 0;
  #while ( i < 3000 )
    #declare xx = rand(TreeRnd) * 2000 - 1000;
    #declare zz = rand(TreeRnd) * 2000 - 1000;
    #declare NormVect = <0, 0, 0>;
    #declare tmpVect = trace( ExclusionZone, <xx, 1000, zz>, -y, NormVect );
    #if (vlength( NormVect ) = 0) 
      #declare NormVect = <0, 0, 0>;
      #declare IntersectVect = trace( Ground, <xx, 1000, zz>, -y, NormVect );
      #if (vlength(NormVect) != 0)
        object {SimpleTree translate IntersectVect}
      #end  
    #end  
    #declare i = i + 1;
  #end    
#end
                                            
// Draw some hills off in the far distance. The shape doesn't really matter (they'll be too
// far away to see), just the shape
#ifndef( fastRender )
  #declare MountainRadius = 10*km;
  #declare MountainHeight = .26*km;
  #declare i = 0;
  
  #declare MountainRand = seed( 234 );
  
  union {
    torus {
      MountainRadius
      MountainHeight
    }
    #declare i = 0;
    #while ( i < 1000 )
      #declare i = i + 1;
      #declare aAngle = 2*pi*rand( MountainRand );
      #declare aRadius = MountainRadius * (0.95 + 0.4*rand(MountainRand));
      sphere {
        <aRadius * cos(aAngle), 0, aRadius * sin(aAngle)>
        MountainHeight * (0.6 + (0.8*rand(MountainRand)))
        no_shadow
      }  
    #end  
    pigment {
      onion 
      color_map {
        [0 color rgb <0, 0.01, 0.01>]
        [1 color rgb <0, 0, 0>]
      }
      scale 100
      turbulence 5.2  
    }  
  }
#end

