#include "colors.inc"
#include "textures.inc"
#include "conversionUnits.inc"

#declare __particleMass = 0.01;

#macro InitParticles( _numParticles, _upVector, _affectedByGravity )
   #declare __particlePositionArray = array[_numParticles]
   #declare __particleVectorArray = array[_numParticles]
   #declare __particleStickynessArray = array[_numParticles]
   #declare __particleDeformabilityArray = array[_numParticles]
   #declare __upVector = _upVector;
   #declare __affectedByGravity = _affectedByGravity;
   #declare __particleObjectArray = array[ 10000 ]
   #declare __particleObjectElasticityArray = array[ 10000 ] 
   #declare __particleObjectCounter = 0;
   #declare __particleCounter = 0;
   #declare __lastParsedTime = 0;
   #declare __particlesInitialised = false;
   
   // See if any variables have been written to process
   #if (vClock > 0)
      #fopen VAR_FILE "c:\\pov_vars.tmp" read
      #ifdef (VAR_FILE)
         // The file existed, assume the right Format
         #read (VAR_FILE, __lastParsedTime, __particleCounter)
         #local i = 0;
         #local a = 0;
         #local b = 0;
#debug concat( "Reading: time = ", str( __lastParsedTime, 4, 4), " particleCounter = ", str( __particleCounter, 4, 4), "\n" )
         #while (i<__particleCounter)
            #undef a
            #undef b
            #undef c
            #undef d
            #read (VAR_FILE, a, b, c, d )
            
//#debug "Read " DumpVector(a, "") #debug " and " DumpVector(b, "\n")
            
            #declare __particlePositionArray[i] = a;
            #declare __particleVectorArray[i] = b;
            #declare __particleStickynessArray[i] = c;
            #declare __particleDeformabilityArray[i] = d;
            #local i = i + 1;
         #end
         #declare __particlesInitialised = true;
         #fclose VAR_FILE
      #end      
   #end   
#end

#macro EndParticles()
   // Write out the variables to a file for the next iteration
   #fopen VAR_FILE "c:\\pov_vars.tmp" write
   #ifdef (VAR_FILE)
      // The file existed, assume the right Format
      #write (VAR_FILE, __lastParsedTime, ",", __particleCounter, ",")
      #local i = 0;
      #while (i<__particleCounter)
         #write (VAR_FILE, __particlePositionArray[i], ",", __particleVectorArray[i], ",", __particleStickynessArray[i], ",", __particleDeformabilityArray[i], "," )
         #local i = i + 1;
      #end
      #fclose VAR_FILE
   #end      
#end      

#macro AddParticle( _initLoc, _initVelocity, _stickyness, _deformability )
   #if (__particlesInitialised = false)
      #declare __particlePositionArray[ __particleCounter ] = _initLoc;
      #declare __particleVectorArray[ __particleCounter ] = _initVelocity;
      #declare __particleStickynessArray[ __particleCounter ] = _stickyness;
      #declare __particleDeformabilityArray[ __particleCounter ] = _deformability;
      #declare __particleCounter = __particleCounter + 1;
   #end   
#end

#declare particleSize = 50*cm;

// vloc = trace( __particleObjectArray[i], startLoc, directionLoc, vNormal );

#macro DumpVector(_vec, _str)
   #debug concat( "<", str( _vec.x, 4, 4 ), ", ", str( _vec.y, 4, 4 ), ", ", str( _vec.z, 4, 4 ), ">", _str )
#end

#macro CollidesWithParticle( _particleLoc, _particleSize, _Object, _Collides, _CollisionLoc, _CollisionNormal )
   // Step around a sphere, going from y = sin(pi/2) to y = -sin(pi/2), x,z going to cos(theta), sin(theta) where 0 <= theta < 2*pi
   #local collideSteps = 8;   // Total of collideSteps^2 steps
   #local yIncr = pi / collideSteps;
   #local thetaIncr = 2*pi / collideSteps;
   #local _Collides = false;

   #local continue = true;   
   #local yStep = -pi/2;
   #while (continue & yStep <= pi/2)          
      #local thetaStep = 0;
      #while (continue & thetaStep < 2*pi)
         #local rayVect = <cos(thetaStep), sin(yStep), sin(thetaStep)>;
         #local aNormal = <0, 0, 0>;
         #local aLoc = <0, 0, 0>;
         #local aLoc = trace( _Object, _particleLoc, rayVect, aNormal );
         #if (aNormal.x != 0 | aNormal.y != 0 | aNormal.z != 0)
            #if (vlength(aLoc - _particleLoc) <= _particleSize )
#debug concat( "vlength = ", str( vlength( aLoc - _particleLoc ), 4, 4), "\n" )            
               // This ray collides
               #local continue = false;
               #local _Collides = true;
               #local _CollisionLoc = aLoc;
               #local _CollisionNormal = aNormal;
            #end
         #end   
         #local thetaStep = thetaStep + thetaIncr;
      #end   
      #local yStep = yStep + yIncr;
   #end
#end

/*
// Test the macro
#declare a = <0, 0, 0>;
#declare b = <0, 0, 0>;
#declare collides = true;
CollidesWithParticle( <0.3, 0, 0>, 0.5, plane { x, 0 }, collides, a, b )
#if (collides)
   #debug "Collides at "
   DumpVector( a, " with normal of " )
   DumpVector( b, "\n" )
#else
   #debug "No collision"   
#end
#error "testing"
*/
   
#declare timeQuantum = 0.01;

#macro DrawParticles( _timeInSeconds, _Particle )
   #if ( _timeInSeconds < __lastParsedTime )
      #error "You cannot go backwards in time!!"
   #end   
   #local gravityVector = vnormalize( -__upVector );
   #if (__affectedByGravity)
      #local downAcceleration = 9.8 * gravityVector;
   #else
      #local downAcceleration = 0;
   #end
   #local nettForce = downAcceleration;
   #local thisParticle = 0;
   union {
      #while (thisParticle < __particleCounter)
         #declare currTime = __lastParsedTime;
         #while (currTime < _timeInSeconds)
            // Displacement: s = ut + 1/2at*t
            #declare newPosition = __particlePositionArray[thisParticle] + __particleVectorArray[thisParticle] * timeQuantum + 0.5 * nettForce * timeQuantum * timeQuantum;
            #declare movementLength = vlength(newPosition - __particlePositionArray[thisParticle]);
            // velocity: v = u + at
            #declare newVelocity = __particleVectorArray[thisParticle] + nettForce*timeQuantum;
//#debug "newVelocity  = " DumpVector( newVelocity, "\n" )            
            
            // See if this new position will intercept any objects
            #local objectId = 0;
            #local collisionLength = -1;
            #while (objectId < __particleObjectCounter)
               #local vNormal = <0, 0, 0>;
               #local vLoc = trace( __particleObjectArray[objectId], __particlePositionArray[thisParticle], __particleVectorArray[thisParticle], vNormal);
               #if (vNormal.x != 0 | vNormal.y != 0 | vNormal.z != 0)
//#debug "Collision detected at " DumpVector( vLoc, "\n" )
                  // We've intercepted this object, determine if this is the smallest collision (vlength smallest)
                  #local thisCollision = vlength( vLoc - __particlePositionArray[thisParticle]) - (particleSize * __particleDeformabilityArray[thisParticle]);
//#debug concat("Length to collision  ", str( thisCollision, 4, 4), "\n")
                  #if ( (collisionLength < 0 | thisCollision < collisionLength ) & (thisCollision < movementLength))
//#debug "Active collision\n"                  
                     #local collisionLength = thisCollision;
//#debug concat( "CollisionLength = ", str( collisionLength, 4, 4 ), "\n" )                     
                     // Now rotate this vector 180 degrees around the normal
                     #local newVelocity = vaxis_rotate(__particlePositionArray[thisParticle]-vLoc, vNormal, 180);
//#debug "normalised Velocity  = " DumpVector( newVelocity, "\n" )
                     
                     // Make the size of the new velocity the same as the original less the elasticity
                     #local newVelocity = vnormalize(newVelocity) * vlength(__particleVectorArray[thisParticle]) * __particleObjectElasticityArray[objectId];
//#debug "new Velocity  = " DumpVector( newVelocity, "\n" )            

                     // Derive the new position
                     #local newPosition = vLoc + (movementLength - collisionLength + 2 * (particleSize*__particleDeformabilityArray[thisParticle])) * vnormalize( newVelocity );
//#debug "newPosition  = " DumpVector( newPosition, "\n" )            
                  #end   
               #end   
               #local objectId = objectId + 1;
            #end
            #declare __particlePositionArray[thisParticle] = newPosition;
            #declare __particleVectorArray[thisParticle] = newVelocity;
            #declare currTime = currTime + timeQuantum;
         #end         
         //#local displacement = __particleVectorArray[thisParticle] * _timeInSeconds + 0.5 * nettForce * _timeInSeconds * _timeInSeconds + __particlePositionArray[thisParticle];
         #local displacement = __particlePositionArray[thisParticle];
         #local thisParticle = thisParticle + 1;
         object { _Particle translate displacement }   
         /*
         sphere {
            displacement
            easyblob( 1, particleSize, 1 )
         } */   
      #end
      //threshold 1
   }  
   #declare __lastParsedTime = currTime;
#end

#macro ParticleInteractor(_object, _elasticity)
   #declare __particleObjectArray[__particleObjectCounter] = _object
   #declare __particleObjectElasticityArray[__particleObjectCounter] = _elasticity;
   #declare __particleObjectCounter = __particleObjectCounter + 1;
   object { _object }
#end
   

/************   
#declare numParticles = 5;
InitParticles( numParticles, y, true )
#declare rnd = seed( 1 );

//ParticleInteractor( plane { y 0 texture { pigment { checker color rgb <1, 1, 0> color rgb <0, 1, 1> } } rotate 45*z } )
ParticleInteractor( plane { y 0 texture { pigment { checker color rgb <1, 1, 0> color rgb <0, 1, 1> } } rotate 25*z translate -2*y}, 0.8 )
ParticleInteractor( plane { y 0 texture { pigment { checker color rgb <1, 0, 0> color rgb <0, 1, 0> scale 0.2} } rotate -90*z translate -2*x}, 0.7 )
ParticleInteractor( plane { -z 0 texture { pigment { checker color rgb <1, 1, 1> color rgb <0, 0, 0> scale 0.4} } translate 2*z}, 0.9 )
ParticleInteractor( plane { z 0 texture { pigment { color rgbt 1 } } translate -1*z}, 1 )

#declare i = 0;
#while (i<4)
   ParticleInteractor( sphere { <4*rand(rnd)-2, 4*rand(rnd)-2, 4*rand(rnd)-2>, 0.5 * rand( rnd ) texture { pigment { color rgb <rand(rnd), rand(rnd), rand(rnd)> } } }, 1.5 )
   #declare i = i + 1;
#end

#declare i = 0;
#while (i < numParticles)
   //AddParticle( <-25, -3, 0>, 20*<0.3, 1, 0> + <4*(2*rand( rnd )-1), 4*(2*rand( rnd )-1), 4*(2*rand( rnd )-1)> )
   // AddParticle( <0, 3, 0>, <0, 0, 0> )
   AddParticle( <0.5, 3, 0>, <(2*rand( rnd )-1), (2*rand( rnd )-1), (2*rand( rnd )-1)>, 0, 0.1 )
   #declare i = i + 1;
#end

#declare TotalFrames = final_frame;
#declare TotalTime = TotalFrames / 25;    // 25fps
#declare CurrentTime = TotalTime * clock;

object {        
   DrawParticles( CurrentTime )
   //DrawParticles( 3 )
   texture { pigment { color rgb <0.9, 0.7, 0.8> } finish { reflection 0.7 } }
}
   
camera {
   location <0, 2.5, -4>
   look_at <0, 0.0, 0>
}

light_source {
   <10, 40, -2>
   1
}

EndParticles()
******************************/                       