/* 
	Match include file for Brass and Steel
	By Daniel Dresser
*/

/*
	This is not a really great match, but it's
	good enough for a rendering where you never 
	see it up close.  There are some half-implemented 
	ideas in here
*/	

#include "colors.inc"
#include "woods.inc"

/*light_source{<1000,1000,1000> rgb<1,1,1>}

camera{
	up    <0,0.75,0>
  right  <1,0,0>
  //up    <0,0.24,0>
  //right  <0.32,0,0>
  //up    <0,0.12,0>
  //right  <0.16,0,0>
  //up    <0,0.06,0>
  //right  <0.08,0,0>
	//location <400,-400,-1200>
	//location <-1000,-300,1000>
	//location <20,-20,60>
	//location <100,-100,-200>
	//location <300,000,1300>
	location <20,12,13>
	//look_at <0,-800,500>
	//look_at <500,300,300>
	sky <0,0,1>
	look_at <0,0,0>	
	//orthographic
}*/

//This is fiddling with creative ways
//to line things up
#declare Tr_Scorch=transform{
	rotate x*90
	scale 5
	translate z*0
}

#declare TrBack_Scorch=transform{
	translate z*0
	scale 1/5
	rotate x*-90
}
              
#macro limit(vector,lim)
	#if (vlength(vector)<lim)
		(vector)
	#else
		(vector/vlength(vector)*lim)
	#end
#end			

//This generates a vector which is pseudorandom, and changes
//smoothly over time - I'm sure there are better ways to do this,
//but overlapping random sine waves works

//I used the same method in the main file for fire, and I should have
//called this function, but I'm not worrying about it now
#macro randomvector(time,theseed)
	#declare R=seed(theseed);
	<sin((time+rand(R)*2-1)/((rand(R)+0.3)*3))+
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3))+
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3)),
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3))+
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3))+
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3)),
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3))+
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3))+
		sin((time+rand(R)*2-1)/((rand(R)+0.3)*3))>/3
#end		
                                                  
//The match flame should be influenced by rotation and speed, but
//I never quite got to it properly
#macro match(rot,speed,time)//Time in 1/2 frames,speed in units per frame
	#declare firebasecenter=(<0,0,-1>-limit(speed*0.5,0.5)+randomvector(time,1414)*0.5);
	#declare firebasesize=2+randomvector(time,1144)*0.5;
	#declare firebaserot=<0,0,0>+randomvector(time,14125)*45;
	#declare firetopcenter=(<0,0,2>+randomvector(time,541)-limit(speed*1,1.5));
	#declare firetopsize=<2,1.5,3>+randomvector(time,532)*0.3;
	#declare firetoprot=randomvector(time,325)*10;
	union{
		box{
			<1,0.5,0>
			<-1,-0.5,-30>
			rotate rot                        
			texture{
				spherical
				scale firebasesize
				rotate firebaserot
				translate firebasecenter
				texture_map{
					[0 
						planar
						transform Tr_Scorch
						translate -firebasecenter
						rotate -firebaserot
						scale 1/firebasesize
						texture_map{
							[0 T_Wood3 scale 15 rotate x*1 transform TrBack_Scorch]
							[1 pigment{rgb<0.3,0.3,0.3>} normal{bumps scale <0.1,0.1,0.5>} transform TrBack_Scorch]
						}
					]
					[0.2 pigment {
								planar
								rotate x*90
								translate z*-1
								color_map {
									[0 Black]
									[1 rgb<1,0.5,0>]
								}	
							} finish{ambient rgb <3,3,0>}]	
					[0.4 pigment{rgb<0.3,0.3,0.3>} normal{bumps scale <0.1,0.1,0.5>}]
				}
			}	
		}
		
		sphere{
			0,1
			hollow on
			pigment{Clear}
			interior{
				media{
					emission rgb<0,0,0.2>
      		scattering{1,0.1}
        	density{
	        	spherical
        		color_map{
	        		[0.999 Blue]
        			[0.9992 Black]
        		}	
        		scale 1000
        		translate firetopcenter*0.1
        	}	
				}
			}
			scale firebasesize*1.2
			rotate firebaserot
			translate firebasecenter-firetopcenter*0.2
		}
		
	#declare fireshape=blob{
				threshold 0.5
				sphere{
					0,1 strength 1
					scale firebasesize*2
					rotate firebaserot
					translate firebasecenter
				}
				sphere{
					0,1 strength 1
					scale firetopsize*2
					rotate firetoprot
					translate firetopcenter
				}
				sphere{
					0,1 strength 1
					scale firetopsize*2
					scale <0.5,0.5,1>
					translate z*1
					rotate firetoprot
					translate firetopcenter
				}
				
			}
	  	
		object{
		 	object{fireshape hollow on}
			pigment{Clear}
			no_shadow
			interior{
				media{
					emission rgb 0.8
      		scattering{1,0.1}
					density{
						planar
						color_map{
							[0 rgb<0,0,0>]
							[0.5 rgb <0.5,0,0>]
							[1 rgb <1,0.5,0>]
						}
						rotate x*90
						scale <1,1,7>
						translate z*5
						scale <1,1,0.1>
						warp{
							black_hole <0,0,-1>,2
							inverse
						}
						scale <1,1,10>
					}
				}
			}
		}
		
		light_source{firetopcenter,rgb<0.4,0.2,0>}
	}	
#end

/*object{
	match(<0,-45+clock*90,0>,<-2,0,0>,clock*40)	
	translate <10-clock*20,0,0>
}*/	