// IRTC Entry for Paul Lewellen
// Completed April 10, 2002
// Animation transformations generated exclusively by hand 
// =============================
// Settings used for IRTC entry:
// Quality: 2
// Clock from 0 to 1
// 500 frames                   
// 320x240, AA 0.3, Radiosity
// =============================
// Geometry generated by L3P v1.3 20010120  (C) 1998-2001 Lars C. Hassing  lch@ccieurope.com
// WWW: http://home16.inet.tele.dk/hassing/l3p.html
// WWW: http://www.ldraw.org/download/software/l3p
// Date: Sat Apr 06 19:26:14 2002
// Input file: irtc.mpd
// ModelDir: 
// LDRAWDIR: D:\ldraw\ldraw
// LGEODIR: D:\ldraw\lgeo
// Commandline: D:\LDRAW\LDRAW\MODELS\L3P.EXE -b -f -o -lgeo irtc.mpd irtc.pov
#declare FADE = 1-((((clock-0.36)/0.05)-.5)*(((clock-0.36)/0.05)-.5)*4)
#include "literay.inc"
#declare QUAL = 2;  // Quality level, 0=BBox, 1=no refr, 2=normal, 3=studlogo

#declare SW = 0.5;  // Width of seam between two bricks

#declare STUDS = 1;  // 1=on 0=off

#declare BUMPS = 1;  // 1=on 0=off


#declare BUMPNORMAL = normal { bumps 0.01 scale 20 }
#declare AMB = 0.4;
#declare DIF = 0.4;


#declare O7071 = sqrt(0.5);

#declare L3Logo = union {
	sphere {<-59,0,-96>,6}
	cylinder {<-59,0,-96>,<59,0,-122>,6 open}
	sphere {<59,0,-122>,6}
	cylinder {<59,0,-122>,<59,0,-84>,6 open}
	sphere {<59,0,-84>,6}

	sphere {<-59,0,-36>,6}
	cylinder {<-59,0,-36>,<-59,0,1>,6 open}
	sphere {<-59,0,1>,6}
	cylinder {<0,0,-49>,<0,0,-25>,6 open}
	sphere {<0,0,-25>,6}
	sphere {<59,0,-62>,6}
	cylinder {<59,0,-62>,<59,0,-24>,6 open}
	sphere {<59,0,-24>,6}
	cylinder {<-59,0,-36>,<59,0,-62>,6 open}

	sphere {<-35.95,0,57>,6}
	torus {18.45,6 clipped_by{plane{<40,0,-9>,0}} translate<-40,0,39>}
	cylinder {<-44.05,0,21>,<35.95,0,3>,6 open}
	torus {18.45,6 clipped_by{plane{<-40,0,9>,0}} translate<40,0,21>}
	cylinder {<44.05,0,39>,<0,0,49>,6 open}
	sphere {<0,0,49>,6}
	cylinder {<0,0,49>,<0,0,34>,6 open}
	sphere {<0,0,34>,6}

	torus {18.45,6 clipped_by{plane{<40,0,-9>,0}} translate<-40,0,99>}
	cylinder {<-44.05,0,81>,<35.95,0,63>,6 open}
	torus {18.45,6 clipped_by{plane{<-40,0,9>,0}} translate<40,0,81>}
	cylinder {<44.05,0,99>,<-35.95,0,117>,6 open}

	scale 4.5/128
}


#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#include "lg_defs.inc"
#include "lg_color.inc"
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end

#if (QUAL > 2)
	#declare lg_knob_l3temp = union {
		object { lg_knob }
		object {
			L3Logo
			matrix <0,-LG_BRICK_WIDTH/20,0, 0,0,-LG_BRICK_HEIGHT/24, -LG_BRICK_WIDTH/20,0,0, 0,0,4*LG_BRICK_HEIGHT/24>
		}
	}
	#declare lg_knob = object { lg_knob_l3temp }
	#declare lg_knob_l3temp = merge {
		object { lg_knob_clear }
		object {
			L3Logo
			matrix <0,-LG_BRICK_WIDTH/20,0, 0,0,-LG_BRICK_HEIGHT/24, -LG_BRICK_WIDTH/20,0,0, 0,0,4*LG_BRICK_HEIGHT/24>
		}
	}
	#declare lg_knob_clear = object { lg_knob_l3temp }
#end


#ifndef (Color7)
#declare Color7 = #if (version >= 3.1) material { #end texture {
	lg_grey
} #if (version >= 3.1) } #end
#declare Color7_slope = #if (version >= 3.1) material { #end texture {
	lg_grey
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color2)
#declare Color2 = #if (version >= 3.1) material { #end texture {
	lg_green
} #if (version >= 3.1) } #end
#declare Color2_slope = #if (version >= 3.1) material { #end texture {
	lg_green
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color0)
#declare Color0 = #if (version >= 3.1) material { #end texture {
	lg_black
} #if (version >= 3.1) } #end
#declare Color0_slope = #if (version >= 3.1) material { #end texture {
	lg_black
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color4)
#declare Color4 = #if (version >= 3.1) material { #end texture {
	lg_red
} #if (version >= 3.1) } #end
#declare Color4_slope = #if (version >= 3.1) material { #end texture {
	lg_red
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color0x06C00C00)
#declare Color0x06C00C00 = #if (version >= 3.1) material { #end texture {
	pigment { rgb <0.8,0,0> #if (QUAL > 1) filter 0.9 #end }
	finish {
		ambient 0.3
		diffuse 0.6
		#if (QUAL > 1)
			reflection 0.25
			refraction 1
			ior 1.5
			phong 0.3
			phong_size 60
		#end
	}
} #if (version >= 3.1) } #end
#declare Color0x06C00C00_slope = #if (version >= 3.1) material { #end texture {
	pigment { rgb <0.8,0,0> #if (QUAL > 1) filter 0.9 #end }
	finish {
		ambient 0.3
		diffuse 0.6
		#if (QUAL > 1)
			reflection 0.25
			refraction 1
			ior 1.5
			phong 0.3
			phong_size 60
		#end
	}
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color0x06AD5AD5)
#declare Color0x06AD5AD5 = #if (version >= 3.1) material { #end texture {
	pigment { rgb <0.666667,0.866667,0.333333> #if (QUAL > 1) filter 0.9 #end }
	finish {
		ambient 0.3
		diffuse 0.6
		#if (QUAL > 1)
			reflection 0.25
			refraction 1
			ior 1.5
			phong 0.3
			phong_size 60
		#end
	}
} #if (version >= 3.1) } #end
#declare Color0x06AD5AD5_slope = #if (version >= 3.1) material { #end texture {
	pigment { rgb <0.666667,0.866667,0.333333> #if (QUAL > 1) filter 0.9 #end }
	finish {
		ambient 0.3
		diffuse 0.6
		#if (QUAL > 1)
			reflection 0.25
			refraction 1
			ior 1.5
			phong 0.3
			phong_size 60
		#end
	}
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color1)
#declare Color1 = #if (version >= 3.1) material { #end texture {
	lg_blue
} #if (version >= 3.1) } #end
#declare Color1_slope = #if (version >= 3.1) material { #end texture {
	lg_blue
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color14)
#declare Color14 = #if (version >= 3.1) material { #end texture {
	lg_yellow
} #if (version >= 3.1) } #end
#declare Color14_slope = #if (version >= 3.1) material { #end texture {
	lg_yellow
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare _4_dash_4disc_dot_dat = #if (version >= 3.1)
	disc { <0,0,0>, <0,1,0>, 1 }
#else
	cylinder { <0,-0.001,0>, <0,0.001,0>, 1 }
#end

#declare _4_dash_4cyli_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open }

#declare stud2_dot_dat = object {
	lg_tech_knob
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}

#declare _2986_dot_dat = #if (QUAL = 0) box { <-23.52,-4,-23.52>, <23.52,40,23.52> } #else union {
// Electric Technic Micromotor
// Name: 2986.dat
// Author: (c)Remco Braak 1997 (rbraak@nat.vu.nl)
// Official LCad update 99-01
	mesh {
		triangle { <-20,40,-20>, <-8,40,-20>, <-6,40,-16> }
		triangle { <-6,40,-16>, <-16,40,-16>, <-20,40,-20> }
		triangle { <20,40,-20>, <8,40,-20>, <6,40,-16> }
		triangle { <6,40,-16>, <16,40,-16>, <20,40,-20> }
		triangle { <-20,40,20>, <-8,40,20>, <-6,40,16> }
		triangle { <-6,40,16>, <-16,40,16>, <-20,40,20> }
		triangle { <20,40,20>, <8,40,20>, <6,40,16> }
		triangle { <6,40,16>, <16,40,16>, <20,40,20> }
		triangle { <-20,40,-20>, <-20,40,-4>, <-16,40,-4> }
		triangle { <-16,40,-4>, <-16,40,-16>, <-20,40,-20> }
		triangle { <20,40,-20>, <20,40,-4>, <16,40,-4> }
		triangle { <16,40,-4>, <16,40,-16>, <20,40,-20> }
		triangle { <-20,40,20>, <-20,40,4>, <-16,40,4> }
		triangle { <-16,40,4>, <-16,40,16>, <-20,40,20> }
		triangle { <20,40,20>, <20,40,4>, <16,40,4> }
		triangle { <16,40,4>, <16,40,16>, <20,40,20> }
		triangle { <-20,40,-4>, <-20,40,4>, <20,40,4> }
		triangle { <20,40,4>, <20,40,-4>, <-20,40,-4> }
		triangle { <-6.92,40,-4>, <-5.66,40,-5.66>, <5.66,40,-5.66> }
		triangle { <5.66,40,-5.66>, <6.92,40,-4>, <-6.92,40,-4> }
		triangle { <-6.92,40,4>, <-5.66,40,5.66>, <5.66,40,5.66> }
		triangle { <5.66,40,5.66>, <6.92,40,4>, <-6.92,40,4> }
		triangle { <-5.66,40,-5.66>, <-3,40,-7.41>, <3,40,-7.41> }
		triangle { <3,40,-7.41>, <5.66,40,-5.66>, <-5.66,40,-5.66> }
		triangle { <-5.66,40,5.66>, <-3,40,7.41>, <3,40,7.41> }
		triangle { <3,40,7.41>, <5.66,40,5.66>, <-5.66,40,5.66> }
		triangle { <-3,40,-7.41>, <-3,40,-10>, <3,40,-10> }
		triangle { <3,40,-10>, <3,40,-7.41>, <-3,40,-7.41> }
		triangle { <-3,40,7.41>, <-3,40,10>, <3,40,10> }
		triangle { <3,40,10>, <3,40,7.41>, <-3,40,7.41> }
		triangle { <-2,40,-10>, <-2,40,-20>, <2,40,-20> }
		triangle { <2,40,-20>, <2,40,-10>, <-2,40,-10> }
		triangle { <-2,40,10>, <-2,40,20>, <2,40,20> }
		triangle { <2,40,20>, <2,40,10>, <-2,40,10> }
		triangle { <-8,40,-20>, <-8,36,-20>, <-6,36,-16> }
		triangle { <-6,36,-16>, <-6,40,-16>, <-8,40,-20> }
		triangle { <-6,40,-16>, <-6,36,-16>, <-16,36,-16> }
		triangle { <-16,36,-16>, <-16,40,-16>, <-6,40,-16> }
	}
	mesh {
		triangle { <-16,40,-16>, <-16,36,-16>, <-16,36,-4> }
		triangle { <-16,36,-4>, <-16,40,-4>, <-16,40,-16> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-16,40,-4>, <-16,36,-4>, <-6.92,36,-4> }
		triangle { <-6.92,36,-4>, <-6.92,40,-4>, <-16,40,-4> }
		triangle { <-6.92,40,-4>, <-6.92,36,-4>, <-5.66,36,-5.66> }
		triangle { <-5.66,36,-5.66>, <-5.66,40,-5.66>, <-6.92,40,-4> }
		triangle { <-5.66,40,-5.66>, <-5.66,36,-5.66>, <-3,36,-7.41> }
		triangle { <-3,36,-7.41>, <-3,40,-7.41>, <-5.66,40,-5.66> }
		triangle { <-3,40,-7.41>, <-3,36,-7.41>, <-3,36,-10> }
		triangle { <-3,36,-10>, <-3,40,-10>, <-3,40,-7.41> }
		triangle { <-3,40,-10>, <-3,36,-10>, <-2,36,-10> }
		triangle { <-2,36,-10>, <-2,40,-10>, <-3,40,-10> }
		triangle { <-2,40,-10>, <-2,36,-10>, <-2,36,-20> }
		triangle { <-2,36,-20>, <-2,40,-20>, <-2,40,-10> }
		triangle { <-8,40,20>, <-8,36,20>, <-6,36,16> }
		triangle { <-6,36,16>, <-6,40,16>, <-8,40,20> }
		triangle { <-6,40,16>, <-6,36,16>, <-16,36,16> }
		triangle { <-16,36,16>, <-16,40,16>, <-6,40,16> }
	}
	mesh {
		triangle { <-16,40,16>, <-16,36,16>, <-16,36,4> }
		triangle { <-16,36,4>, <-16,40,4>, <-16,40,16> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-16,40,4>, <-16,36,4>, <-6.92,36,4> }
		triangle { <-6.92,36,4>, <-6.92,40,4>, <-16,40,4> }
		triangle { <-6.92,40,4>, <-6.92,36,4>, <-5.66,36,5.66> }
		triangle { <-5.66,36,5.66>, <-5.66,40,5.66>, <-6.92,40,4> }
		triangle { <-5.66,40,5.66>, <-5.66,36,5.66>, <-3,36,7.41> }
		triangle { <-3,36,7.41>, <-3,40,7.41>, <-5.66,40,5.66> }
		triangle { <-3,40,7.41>, <-3,36,7.41>, <-3,36,10> }
		triangle { <-3,36,10>, <-3,40,10>, <-3,40,7.41> }
		triangle { <-3,40,10>, <-3,36,10>, <-2,36,10> }
		triangle { <-2,36,10>, <-2,40,10>, <-3,40,10> }
		triangle { <-2,40,10>, <-2,36,10>, <-2,36,20> }
		triangle { <-2,36,20>, <-2,40,20>, <-2,40,10> }
		triangle { <8,40,-20>, <8,36,-20>, <6,36,-16> }
		triangle { <6,36,-16>, <6,40,-16>, <8,40,-20> }
		triangle { <6,40,-16>, <6,36,-16>, <16,36,-16> }
		triangle { <16,36,-16>, <16,40,-16>, <6,40,-16> }
	}
	mesh {
		triangle { <16,40,-16>, <16,36,-16>, <16,36,-4> }
		triangle { <16,36,-4>, <16,40,-4>, <16,40,-16> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <16,40,-4>, <16,36,-4>, <6.92,36,-4> }
		triangle { <6.92,36,-4>, <6.92,40,-4>, <16,40,-4> }
		triangle { <6.92,40,-4>, <6.92,36,-4>, <5.66,36,-5.66> }
		triangle { <5.66,36,-5.66>, <5.66,40,-5.66>, <6.92,40,-4> }
		triangle { <5.66,40,-5.66>, <5.66,36,-5.66>, <3,36,-7.41> }
		triangle { <3,36,-7.41>, <3,40,-7.41>, <5.66,40,-5.66> }
		triangle { <3,40,-7.41>, <3,36,-7.41>, <3,36,-10> }
		triangle { <3,36,-10>, <3,40,-10>, <3,40,-7.41> }
		triangle { <3,40,-10>, <3,36,-10>, <2,36,-10> }
		triangle { <2,36,-10>, <2,40,-10>, <3,40,-10> }
		triangle { <2,40,-10>, <2,36,-10>, <2,36,-20> }
		triangle { <2,36,-20>, <2,40,-20>, <2,40,-10> }
		triangle { <8,40,20>, <8,36,20>, <6,36,16> }
		triangle { <6,36,16>, <6,40,16>, <8,40,20> }
		triangle { <6,40,16>, <6,36,16>, <16,36,16> }
		triangle { <16,36,16>, <16,40,16>, <6,40,16> }
	}
	mesh {
		triangle { <16,40,16>, <16,36,16>, <16,36,4> }
		triangle { <16,36,4>, <16,40,4>, <16,40,16> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <16,40,4>, <16,36,4>, <6.92,36,4> }
		triangle { <6.92,36,4>, <6.92,40,4>, <16,40,4> }
		triangle { <6.92,40,4>, <6.92,36,4>, <5.66,36,5.66> }
		triangle { <5.66,36,5.66>, <5.66,40,5.66>, <6.92,40,4> }
		triangle { <5.66,40,5.66>, <5.66,36,5.66>, <3,36,7.41> }
		triangle { <3,36,7.41>, <3,40,7.41>, <5.66,40,5.66> }
		triangle { <3,40,7.41>, <3,36,7.41>, <3,36,10> }
		triangle { <3,36,10>, <3,40,10>, <3,40,7.41> }
		triangle { <3,40,10>, <3,36,10>, <2,36,10> }
		triangle { <2,36,10>, <2,40,10>, <3,40,10> }
		triangle { <2,40,10>, <2,36,10>, <2,36,20> }
		triangle { <2,36,20>, <2,40,20>, <2,40,10> }
		triangle { <-16,36,-4>, <-6.92,36,-4>, <-5.66,36,-5.66> }
		triangle { <-5.66,36,-5.66>, <-16,36,-16>, <-16,36,-4> }
		triangle { <-16,36,-16>, <-5.66,36,-5.66>, <-3,36,-7.41> }
		triangle { <-3,36,-7.41>, <-3,36,-10>, <-16,36,-16> }
		triangle { <-3,36,-10>, <-16,36,-16>, <-6,36,-16> }
		triangle { <-6,36,-16>, <-2,36,-10>, <-3,36,-10> }
		triangle { <-2,36,-10>, <-6,36,-16>, <-2,36,-20> }
		triangle { <-2,36,-20>, <-6,36,-16>, <-8,36,-20> }
		triangle { <-16,36,4>, <-6.92,36,4>, <-5.66,36,5.66> }
		triangle { <-5.66,36,5.66>, <-16,36,16>, <-16,36,4> }
		triangle { <-16,36,16>, <-5.66,36,5.66>, <-3,36,7.41> }
		triangle { <-3,36,7.41>, <-3,36,10>, <-16,36,16> }
		triangle { <-3,36,10>, <-16,36,16>, <-6,36,16> }
		triangle { <-6,36,16>, <-2,36,10>, <-3,36,10> }
		triangle { <-2,36,10>, <-6,36,16>, <-2,36,20> }
		triangle { <-2,36,20>, <-6,36,16>, <-8,36,20> }
		triangle { <16,36,-4>, <6.92,36,-4>, <5.66,36,-5.66> }
		triangle { <5.66,36,-5.66>, <16,36,-16>, <16,36,-4> }
		triangle { <16,36,-16>, <5.66,36,-5.66>, <3,36,-7.41> }
		triangle { <3,36,-7.41>, <3,36,-10>, <16,36,-16> }
		triangle { <3,36,-10>, <16,36,-16>, <6,36,-16> }
		triangle { <6,36,-16>, <2,36,-10>, <3,36,-10> }
		triangle { <2,36,-10>, <6,36,-16>, <2,36,-20> }
		triangle { <2,36,-20>, <6,36,-16>, <8,36,-20> }
		triangle { <16,36,4>, <6.92,36,4>, <5.66,36,5.66> }
		triangle { <5.66,36,5.66>, <16,36,16>, <16,36,4> }
		triangle { <16,36,16>, <5.66,36,5.66>, <3,36,7.41> }
		triangle { <3,36,7.41>, <3,36,10>, <16,36,16> }
		triangle { <3,36,10>, <16,36,16>, <6,36,16> }
		triangle { <6,36,16>, <2,36,10>, <3,36,10> }
		triangle { <2,36,10>, <6,36,16>, <2,36,20> }
		triangle { <2,36,20>, <6,36,16>, <8,36,20> }
		triangle { <-2,40,-20>, <2,40,-20>, <2,36,-20> }
		triangle { <2,36,-20>, <-2,36,-20>, <-2,40,-20> }
		triangle { <-8,40,-20>, <-20,40,-20>, <-20,36,-20> }
		triangle { <-20,36,-20>, <-8,36,-20>, <-8,40,-20> }
		triangle { <8,40,-20>, <20,40,-20>, <20,36,-20> }
		triangle { <20,36,-20>, <8,36,-20>, <8,40,-20> }
		triangle { <-20,36,-20>, <-20,8,-20>, <20,8,-20> }
		triangle { <20,8,-20>, <20,36,-20>, <-20,36,-20> }
		triangle { <-2,40,20>, <2,40,20>, <2,36,20> }
		triangle { <2,36,20>, <-2,36,20>, <-2,40,20> }
		triangle { <-8,40,20>, <-20,40,20>, <-20,36,20> }
		triangle { <-20,36,20>, <-8,36,20>, <-8,40,20> }
		triangle { <8,40,20>, <20,40,20>, <20,36,20> }
		triangle { <20,36,20>, <8,36,20>, <8,40,20> }
		triangle { <-20,36,20>, <-20,8,20>, <20,8,20> }
		triangle { <20,8,20>, <20,36,20>, <-20,36,20> }
		triangle { <-20,40,-20>, <-20,40,20>, <-20,8,20> }
		triangle { <-20,8,20>, <-20,8,-20>, <-20,40,-20> }
		triangle { <20,40,-20>, <20,40,20>, <20,8,20> }
		triangle { <20,8,20>, <20,8,-20>, <20,40,-20> }
		triangle { <-20,8,-20>, <-20,8,20>, <20,8,20> }
		triangle { <20,8,20>, <20,8,-20>, <-20,8,-20> }
	}
	object { _4_dash_4disc_dot_dat matrix <12.75,0,-2.54,0,1,0,2.54,0,12.75,0,8,0> }
	object { _4_dash_4cyli_dot_dat matrix <19.62,0,-3.9,0,8,0,3.9,0,19.62,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <12.75,0,-2.54,0,8,0,2.54,0,12.75,0,0,0> }
	mesh {
		triangle { <2.54,0,12.75>, <3.9,0,19.61>, <11.12,0,16.62> }
		triangle { <11.12,0,16.62>, <7.23,0,10.8>, <2.54,0,12.75> }
		triangle { <7.23,0,10.8>, <11.12,0,16.62>, <16.62,0,11.12> }
		triangle { <16.62,0,11.12>, <10.8,0,7.23>, <7.23,0,10.8> }
		triangle { <10.8,0,7.23>, <16.62,0,11.12>, <19.61,0,3.9> }
		triangle { <19.61,0,3.9>, <12.75,0,2.54>, <10.8,0,7.23> }
		triangle { <2.54,0,-12.75>, <3.9,0,-19.61>, <11.12,0,-16.62> }
		triangle { <11.12,0,-16.62>, <7.23,0,-10.8>, <2.54,0,-12.75> }
		triangle { <7.23,0,-10.8>, <11.12,0,-16.62>, <16.62,0,-11.12> }
		triangle { <16.62,0,-11.12>, <10.8,0,-7.23>, <7.23,0,-10.8> }
		triangle { <10.8,0,-7.23>, <16.62,0,-11.12>, <19.61,0,-3.9> }
		triangle { <19.61,0,-3.9>, <12.75,0,-2.54>, <10.8,0,-7.23> }
		triangle { <-2.54,0,12.75>, <-3.9,0,19.61>, <-11.12,0,16.62> }
		triangle { <-11.12,0,16.62>, <-7.23,0,10.8>, <-2.54,0,12.75> }
		triangle { <-7.23,0,10.8>, <-11.12,0,16.62>, <-16.62,0,11.12> }
		triangle { <-16.62,0,11.12>, <-10.8,0,7.23>, <-7.23,0,10.8> }
		triangle { <-10.8,0,7.23>, <-16.62,0,11.12>, <-19.61,0,3.9> }
		triangle { <-19.61,0,3.9>, <-12.75,0,2.54>, <-10.8,0,7.23> }
		triangle { <-2.54,0,-12.75>, <-3.9,0,-19.61>, <-11.12,0,-16.62> }
		triangle { <-11.12,0,-16.62>, <-7.23,0,-10.8>, <-2.54,0,-12.75> }
		triangle { <-7.23,0,-10.8>, <-11.12,0,-16.62>, <-16.62,0,-11.12> }
		triangle { <-16.62,0,-11.12>, <-10.8,0,-7.23>, <-7.23,0,-10.8> }
		triangle { <-10.8,0,-7.23>, <-16.62,0,-11.12>, <-19.61,0,-3.9> }
		triangle { <-19.61,0,-3.9>, <-12.75,0,-2.54>, <-10.8,0,-7.23> }
		triangle { <2.54,0,12.75>, <3.9,0,19.61>, <-3.9,0,19.61> }
		triangle { <-3.9,0,19.61>, <-2.54,0,12.75>, <2.54,0,12.75> }
		triangle { <2.54,0,-12.75>, <3.9,0,-19.61>, <-3.9,0,-19.61> }
		triangle { <-3.9,0,-19.61>, <-2.54,0,-12.75>, <2.54,0,-12.75> }
		triangle { <12.75,0,2.54>, <19.61,0,3.9>, <19.61,0,-3.9> }
		triangle { <19.61,0,-3.9>, <12.75,0,-2.54>, <12.75,0,2.54> }
		triangle { <-12.75,0,2.54>, <-19.61,0,3.9>, <-19.61,0,-3.9> }
		triangle { <-19.61,0,-3.9>, <-12.75,0,-2.54>, <-12.75,0,2.54> }
	}
	object { _4_dash_4cyli_dot_dat matrix <12.75,0,-2.54,0,8,0,2.54,0,12.75,0,0,0> #if (version >= 3.1) material #else texture #end { Color0 } }
	object { _4_dash_4disc_dot_dat matrix <12.75,0,-2.54,0,1,0,2.54,0,12.75,0,0,0> #if (version >= 3.1) material #else texture #end { Color0 } }
	object { _4_dash_4disc_dot_dat matrix <12.75,0,-2.54,0,1,0,2.54,0,12.75,0,8,0> #if (version >= 3.1) material #else texture #end { Color0 } }
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (version >= 3.1) material #else texture #end { Color0 } }
// 
	#end
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3456)
		#include "lg_3456.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3456_dot_dat = #if (QUAL = 0) box { <-140,-4,-60>, <140,8,60> } #else object {
// Plate  6 x 14
	lg_3456
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3456_dot_dat_clear = #if (QUAL = 0) box { <-140,-4,-60>, <140,8,60> } #else object {
// Plate  6 x 14
	lg_3456_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4079)
		#include "lg_4079.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4079_dot_dat = #if (QUAL = 0) box { <-20,-40,-20>, <20,8,25> } #else object {
// Minifig Seat  2 x  2
	lg_4079
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4079_dot_dat_clear = #if (QUAL = 0) box { <-20,-40,-20>, <20,8,25> } #else object {
// Minifig Seat  2 x  2
	lg_4079_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4032)
		#include "lg_4032.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4032_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else object {
// Plate  2 x  2 Round
	lg_4032
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4032_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else object {
// Plate  2 x  2 Round
	lg_4032_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare ring1_dot_dat = #if (version >= 3.1)
	disc { <0,0,0>, <0,1,0>, 2, 1 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 2 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 1 }
	}
#end

#declare ring2_dot_dat = #if (version >= 3.1)
	disc { <0,0,0>, <0,1,0>, 3, 2 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 3 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 2 }
	}
#end

#declare ring4_dot_dat = #if (version >= 3.1)
	disc { <0,0,0>, <0,1,0>, 5, 4 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 5 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 4 }
	}
#end

#declare box_dot_dat = box { <-1,-1,-1>, <1,1,1> }

#declare _4_dash_8sphe_dot_dat = sphere { <0,0,0>, 1 clipped_by { box { <-1,0,-1>, <2,2,2> } } }

#declare _4489_dot_dat = #if (QUAL = 0) box { <-42,-42,-13>, <42,42,8> } #else union {
// Castle Wagon Wheel Large
// Name: 4489.dat
// Author: James Jessiman
// Original LDraw Part - LDraw beta 0.27 Archive
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,0,-13,0,4,0,0,0,8> }
	object { _4_dash_4cyli_dot_dat matrix <10,0,0,0,0,-13,0,10,0,0,0,6> }
	object { ring1_dot_dat matrix <4,0,0,0,0,1,0,4,0,0,0,8> }
	object { ring2_dot_dat matrix <2,0,0,0,0,1,0,2,0,0,0,-5> }
	object { ring4_dot_dat matrix <2,0,0,0,0,1,0,2,0,0,0,-7> }
	mesh {
		triangle { <8,0,8>, <7.39,-3.06,8>, <7.95,-3.29,6.6> }
		triangle { <7.95,-3.29,6.6>, <8.6,0,6.6>, <8,0,8> }
		triangle { <8.6,0,6.6>, <7.95,-3.29,6.6>, <9.24,-3.83,6> }
		triangle { <9.24,-3.83,6>, <10,0,6>, <8.6,0,6.6> }
		triangle { <6,0,-5>, <5.54,-2.3,-5>, <7.39,-3.06,-7> }
		triangle { <7.39,-3.06,-7>, <8,0,-7>, <6,0,-5> }
		triangle { <7.39,-3.06,8>, <5.66,-5.66,8>, <6.08,-6.08,6.6> }
		triangle { <6.08,-6.08,6.6>, <7.95,-3.29,6.6>, <7.39,-3.06,8> }
		triangle { <7.95,-3.29,6.6>, <6.08,-6.08,6.6>, <7.07,-7.07,6> }
		triangle { <7.07,-7.07,6>, <9.24,-3.83,6>, <7.95,-3.29,6.6> }
		triangle { <5.54,-2.3,-5>, <4.24,-4.24,-5>, <5.66,-5.66,-7> }
		triangle { <5.66,-5.66,-7>, <7.39,-3.06,-7>, <5.54,-2.3,-5> }
		triangle { <5.66,-5.66,8>, <3.06,-7.39,8>, <3.29,-7.95,6.6> }
		triangle { <3.29,-7.95,6.6>, <6.08,-6.08,6.6>, <5.66,-5.66,8> }
		triangle { <6.08,-6.08,6.6>, <3.29,-7.95,6.6>, <3.83,-9.24,6> }
		triangle { <3.83,-9.24,6>, <7.07,-7.07,6>, <6.08,-6.08,6.6> }
		triangle { <4.24,-4.24,-5>, <2.3,-5.54,-5>, <3.06,-7.39,-7> }
		triangle { <3.06,-7.39,-7>, <5.66,-5.66,-7>, <4.24,-4.24,-5> }
		triangle { <3.06,-7.39,8>, <0,-8,8>, <0,-8.6,6.6> }
		triangle { <0,-8.6,6.6>, <3.29,-7.95,6.6>, <3.06,-7.39,8> }
		triangle { <3.29,-7.95,6.6>, <0,-8.6,6.6>, <0,-10,6> }
		triangle { <0,-10,6>, <3.83,-9.24,6>, <3.29,-7.95,6.6> }
		triangle { <2.3,-5.54,-5>, <0,-6,-5>, <0,-8,-7> }
		triangle { <0,-8,-7>, <3.06,-7.39,-7>, <2.3,-5.54,-5> }
		triangle { <0,-8,8>, <-3.06,-7.39,8>, <-3.29,-7.95,6.6> }
		triangle { <-3.29,-7.95,6.6>, <0,-8.6,6.6>, <0,-8,8> }
		triangle { <0,-8.6,6.6>, <-3.29,-7.95,6.6>, <-3.83,-9.24,6> }
		triangle { <-3.83,-9.24,6>, <0,-10,6>, <0,-8.6,6.6> }
		triangle { <0,-6,-5>, <-2.3,-5.54,-5>, <-3.06,-7.39,-7> }
		triangle { <-3.06,-7.39,-7>, <0,-8,-7>, <0,-6,-5> }
		triangle { <-3.06,-7.39,8>, <-5.66,-5.66,8>, <-6.08,-6.08,6.6> }
		triangle { <-6.08,-6.08,6.6>, <-3.29,-7.95,6.6>, <-3.06,-7.39,8> }
		triangle { <-3.29,-7.95,6.6>, <-6.08,-6.08,6.6>, <-7.07,-7.07,6> }
		triangle { <-7.07,-7.07,6>, <-3.83,-9.24,6>, <-3.29,-7.95,6.6> }
		triangle { <-2.3,-5.54,-5>, <-4.24,-4.24,-5>, <-5.66,-5.66,-7> }
		triangle { <-5.66,-5.66,-7>, <-3.06,-7.39,-7>, <-2.3,-5.54,-5> }
		triangle { <-5.66,-5.66,8>, <-7.39,-3.06,8>, <-7.95,-3.29,6.6> }
		triangle { <-7.95,-3.29,6.6>, <-6.08,-6.08,6.6>, <-5.66,-5.66,8> }
		triangle { <-6.08,-6.08,6.6>, <-7.95,-3.29,6.6>, <-9.24,-3.83,6> }
		triangle { <-9.24,-3.83,6>, <-7.07,-7.07,6>, <-6.08,-6.08,6.6> }
		triangle { <-4.24,-4.24,-5>, <-5.54,-2.3,-5>, <-7.39,-3.06,-7> }
		triangle { <-7.39,-3.06,-7>, <-5.66,-5.66,-7>, <-4.24,-4.24,-5> }
		triangle { <-7.39,-3.06,8>, <-8,0,8>, <-8.6,0,6.6> }
		triangle { <-8.6,0,6.6>, <-7.95,-3.29,6.6>, <-7.39,-3.06,8> }
		triangle { <-7.95,-3.29,6.6>, <-8.6,0,6.6>, <-10,0,6> }
		triangle { <-10,0,6>, <-9.24,-3.83,6>, <-7.95,-3.29,6.6> }
		triangle { <-5.54,-2.3,-5>, <-6,0,-5>, <-8,0,-7> }
		triangle { <-8,0,-7>, <-7.39,-3.06,-7>, <-5.54,-2.3,-5> }
		triangle { <-8,0,8>, <-7.39,3.06,8>, <-7.95,3.29,6.6> }
		triangle { <-7.95,3.29,6.6>, <-8.6,0,6.6>, <-8,0,8> }
		triangle { <-8.6,0,6.6>, <-7.95,3.29,6.6>, <-9.24,3.83,6> }
		triangle { <-9.24,3.83,6>, <-10,0,6>, <-8.6,0,6.6> }
		triangle { <-6,0,-5>, <-5.54,2.3,-5>, <-7.39,3.06,-7> }
		triangle { <-7.39,3.06,-7>, <-8,0,-7>, <-6,0,-5> }
		triangle { <-7.39,3.06,8>, <-5.66,5.66,8>, <-6.08,6.08,6.6> }
		triangle { <-6.08,6.08,6.6>, <-7.95,3.29,6.6>, <-7.39,3.06,8> }
		triangle { <-7.95,3.29,6.6>, <-6.08,6.08,6.6>, <-7.07,7.07,6> }
		triangle { <-7.07,7.07,6>, <-9.24,3.83,6>, <-7.95,3.29,6.6> }
		triangle { <-5.54,2.3,-5>, <-4.24,4.24,-5>, <-5.66,5.66,-7> }
		triangle { <-5.66,5.66,-7>, <-7.39,3.06,-7>, <-5.54,2.3,-5> }
		triangle { <-5.66,5.66,8>, <-3.06,7.39,8>, <-3.29,7.95,6.6> }
		triangle { <-3.29,7.95,6.6>, <-6.08,6.08,6.6>, <-5.66,5.66,8> }
		triangle { <-6.08,6.08,6.6>, <-3.29,7.95,6.6>, <-3.83,9.24,6> }
		triangle { <-3.83,9.24,6>, <-7.07,7.07,6>, <-6.08,6.08,6.6> }
		triangle { <-4.24,4.24,-5>, <-2.3,5.54,-5>, <-3.06,7.39,-7> }
		triangle { <-3.06,7.39,-7>, <-5.66,5.66,-7>, <-4.24,4.24,-5> }
		triangle { <-3.06,7.39,8>, <0,8,8>, <0,8.6,6.6> }
		triangle { <0,8.6,6.6>, <-3.29,7.95,6.6>, <-3.06,7.39,8> }
		triangle { <-3.29,7.95,6.6>, <0,8.6,6.6>, <0,10,6> }
		triangle { <0,10,6>, <-3.83,9.24,6>, <-3.29,7.95,6.6> }
		triangle { <-2.3,5.54,-5>, <0,6,-5>, <0,8,-7> }
		triangle { <0,8,-7>, <-3.06,7.39,-7>, <-2.3,5.54,-5> }
		triangle { <0,8,8>, <3.06,7.39,8>, <3.29,7.95,6.6> }
		triangle { <3.29,7.95,6.6>, <0,8.6,6.6>, <0,8,8> }
		triangle { <0,8.6,6.6>, <3.29,7.95,6.6>, <3.83,9.24,6> }
		triangle { <3.83,9.24,6>, <0,10,6>, <0,8.6,6.6> }
		triangle { <0,6,-5>, <2.3,5.54,-5>, <3.06,7.39,-7> }
		triangle { <3.06,7.39,-7>, <0,8,-7>, <0,6,-5> }
		triangle { <3.06,7.39,8>, <5.66,5.66,8>, <6.08,6.08,6.6> }
		triangle { <6.08,6.08,6.6>, <3.29,7.95,6.6>, <3.06,7.39,8> }
		triangle { <3.29,7.95,6.6>, <6.08,6.08,6.6>, <7.07,7.07,6> }
		triangle { <7.07,7.07,6>, <3.83,9.24,6>, <3.29,7.95,6.6> }
		triangle { <2.3,5.54,-5>, <4.24,4.24,-5>, <5.66,5.66,-7> }
		triangle { <5.66,5.66,-7>, <3.06,7.39,-7>, <2.3,5.54,-5> }
		triangle { <5.66,5.66,8>, <7.39,3.06,8>, <7.95,3.29,6.6> }
		triangle { <7.95,3.29,6.6>, <6.08,6.08,6.6>, <5.66,5.66,8> }
		triangle { <6.08,6.08,6.6>, <7.95,3.29,6.6>, <9.24,3.83,6> }
		triangle { <9.24,3.83,6>, <7.07,7.07,6>, <6.08,6.08,6.6> }
		triangle { <4.24,4.24,-5>, <5.54,2.3,-5>, <7.39,3.06,-7> }
		triangle { <7.39,3.06,-7>, <5.66,5.66,-7>, <4.24,4.24,-5> }
		triangle { <7.39,3.06,8>, <8,0,8>, <8.6,0,6.6> }
		triangle { <8.6,0,6.6>, <7.95,3.29,6.6>, <7.39,3.06,8> }
		triangle { <7.95,3.29,6.6>, <8.6,0,6.6>, <10,0,6> }
		triangle { <10,0,6>, <9.24,3.83,6>, <7.95,3.29,6.6> }
		triangle { <5.54,2.3,-5>, <6,0,-5>, <8,0,-7> }
		triangle { <8,0,-7>, <7.39,3.06,-7>, <5.54,2.3,-5> }
	}
	object { box_dot_dat matrix <3,0,0,0,12.5,4,0,0,2,0,-22.5,-3> }
	object { box_dot_dat matrix <2.12,2.12,0,-8.84,8.84,4,0,0,2,15.91,-15.91,-3> }
	object { box_dot_dat matrix <0,3,0,-12.5,0,4,0,0,2,22.5,0,-3> }
	object { box_dot_dat matrix <-2.12,2.12,0,-8.84,-8.84,4,0,0,2,15.91,15.91,-3> }
	object { box_dot_dat matrix <-3,0,0,0,-12.5,4,0,0,2,0,22.5,-3> }
	object { box_dot_dat matrix <-2.12,-2.12,0,8.84,-8.84,4,0,0,2,-15.91,15.91,-3> }
	object { box_dot_dat matrix <0,-3,0,12.5,0,4,0,0,2,-22.5,0,-3> }
	object { box_dot_dat matrix <2.12,-2.12,0,8.84,8.84,4,0,0,2,-15.91,-15.91,-3> }
	mesh {
		triangle { <35,0,-4>, <34.33,-6.83,-4>, <41.19,-8.19,-4> }
		triangle { <41.19,-8.19,-4>, <42,0,-4>, <35,0,-4> }
		triangle { <35,0,-11>, <34.33,-6.83,-11>, <41.19,-8.19,-11> }
		triangle { <41.19,-8.19,-11>, <42,0,-11>, <35,0,-11> }
		triangle { <35,0,-4>, <34.33,-6.83,-4>, <34.33,-6.83,-11> }
		triangle { <34.33,-6.83,-11>, <35,0,-11>, <35,0,-4> }
		triangle { <42,0,-4>, <41.19,-8.19,-4>, <41.19,-8.19,-11> }
		triangle { <41.19,-8.19,-11>, <42,0,-11>, <42,0,-4> }
		triangle { <34.33,-6.83,-4>, <32.34,-13.39,-4>, <38.8,-16.07,-4> }
		triangle { <38.8,-16.07,-4>, <41.19,-8.19,-4>, <34.33,-6.83,-4> }
		triangle { <34.33,-6.83,-11>, <32.34,-13.39,-11>, <38.8,-16.07,-11> }
		triangle { <38.8,-16.07,-11>, <41.19,-8.19,-11>, <34.33,-6.83,-11> }
		triangle { <34.33,-6.83,-4>, <32.34,-13.39,-4>, <32.34,-13.39,-11> }
		triangle { <32.34,-13.39,-11>, <34.33,-6.83,-11>, <34.33,-6.83,-4> }
		triangle { <41.19,-8.19,-4>, <38.8,-16.07,-4>, <38.8,-16.07,-11> }
		triangle { <38.8,-16.07,-11>, <41.19,-8.19,-11>, <41.19,-8.19,-4> }
		triangle { <32.34,-13.39,-4>, <29.1,-19.44,-4>, <34.92,-23.33,-4> }
		triangle { <34.92,-23.33,-4>, <38.8,-16.07,-4>, <32.34,-13.39,-4> }
		triangle { <32.34,-13.39,-11>, <29.1,-19.44,-11>, <34.92,-23.33,-11> }
		triangle { <34.92,-23.33,-11>, <38.8,-16.07,-11>, <32.34,-13.39,-11> }
		triangle { <32.34,-13.39,-4>, <29.1,-19.44,-4>, <29.1,-19.44,-11> }
		triangle { <29.1,-19.44,-11>, <32.34,-13.39,-11>, <32.34,-13.39,-4> }
		triangle { <38.8,-16.07,-4>, <34.92,-23.33,-4>, <34.92,-23.33,-11> }
		triangle { <34.92,-23.33,-11>, <38.8,-16.07,-11>, <38.8,-16.07,-4> }
		triangle { <29.1,-19.44,-4>, <24.75,-24.75,-4>, <29.7,-29.7,-4> }
		triangle { <29.7,-29.7,-4>, <34.92,-23.33,-4>, <29.1,-19.44,-4> }
		triangle { <29.1,-19.44,-11>, <24.75,-24.75,-11>, <29.7,-29.7,-11> }
		triangle { <29.7,-29.7,-11>, <34.92,-23.33,-11>, <29.1,-19.44,-11> }
		triangle { <29.1,-19.44,-4>, <24.75,-24.75,-4>, <24.75,-24.75,-11> }
		triangle { <24.75,-24.75,-11>, <29.1,-19.44,-11>, <29.1,-19.44,-4> }
		triangle { <34.92,-23.33,-4>, <29.7,-29.7,-4>, <29.7,-29.7,-11> }
		triangle { <29.7,-29.7,-11>, <34.92,-23.33,-11>, <34.92,-23.33,-4> }
		triangle { <24.75,-24.75,-4>, <19.44,-29.1,-4>, <23.33,-34.92,-4> }
		triangle { <23.33,-34.92,-4>, <29.7,-29.7,-4>, <24.75,-24.75,-4> }
		triangle { <24.75,-24.75,-11>, <19.44,-29.1,-11>, <23.33,-34.92,-11> }
		triangle { <23.33,-34.92,-11>, <29.7,-29.7,-11>, <24.75,-24.75,-11> }
		triangle { <24.75,-24.75,-4>, <19.44,-29.1,-4>, <19.44,-29.1,-11> }
		triangle { <19.44,-29.1,-11>, <24.75,-24.75,-11>, <24.75,-24.75,-4> }
		triangle { <29.7,-29.7,-4>, <23.33,-34.92,-4>, <23.33,-34.92,-11> }
		triangle { <23.33,-34.92,-11>, <29.7,-29.7,-11>, <29.7,-29.7,-4> }
		triangle { <19.44,-29.1,-4>, <13.39,-32.34,-4>, <16.07,-38.8,-4> }
		triangle { <16.07,-38.8,-4>, <23.33,-34.92,-4>, <19.44,-29.1,-4> }
		triangle { <19.44,-29.1,-11>, <13.39,-32.34,-11>, <16.07,-38.8,-11> }
		triangle { <16.07,-38.8,-11>, <23.33,-34.92,-11>, <19.44,-29.1,-11> }
		triangle { <19.44,-29.1,-4>, <13.39,-32.34,-4>, <13.39,-32.34,-11> }
		triangle { <13.39,-32.34,-11>, <19.44,-29.1,-11>, <19.44,-29.1,-4> }
		triangle { <23.33,-34.92,-4>, <16.07,-38.8,-4>, <16.07,-38.8,-11> }
		triangle { <16.07,-38.8,-11>, <23.33,-34.92,-11>, <23.33,-34.92,-4> }
		triangle { <13.39,-32.34,-4>, <6.83,-34.33,-4>, <8.19,-41.19,-4> }
		triangle { <8.19,-41.19,-4>, <16.07,-38.8,-4>, <13.39,-32.34,-4> }
		triangle { <13.39,-32.34,-11>, <6.83,-34.33,-11>, <8.19,-41.19,-11> }
		triangle { <8.19,-41.19,-11>, <16.07,-38.8,-11>, <13.39,-32.34,-11> }
		triangle { <13.39,-32.34,-4>, <6.83,-34.33,-4>, <6.83,-34.33,-11> }
		triangle { <6.83,-34.33,-11>, <13.39,-32.34,-11>, <13.39,-32.34,-4> }
		triangle { <16.07,-38.8,-4>, <8.19,-41.19,-4>, <8.19,-41.19,-11> }
		triangle { <8.19,-41.19,-11>, <16.07,-38.8,-11>, <16.07,-38.8,-4> }
		triangle { <6.83,-34.33,-4>, <0,-35,-4>, <0,-42,-4> }
		triangle { <0,-42,-4>, <8.19,-41.19,-4>, <6.83,-34.33,-4> }
		triangle { <6.83,-34.33,-11>, <0,-35,-11>, <0,-42,-11> }
		triangle { <0,-42,-11>, <8.19,-41.19,-11>, <6.83,-34.33,-11> }
		triangle { <6.83,-34.33,-4>, <0,-35,-4>, <0,-35,-11> }
		triangle { <0,-35,-11>, <6.83,-34.33,-11>, <6.83,-34.33,-4> }
		triangle { <8.19,-41.19,-4>, <0,-42,-4>, <0,-42,-11> }
		triangle { <0,-42,-11>, <8.19,-41.19,-11>, <8.19,-41.19,-4> }
		triangle { <0,-35,-4>, <-6.83,-34.33,-4>, <-8.19,-41.19,-4> }
		triangle { <-8.19,-41.19,-4>, <0,-42,-4>, <0,-35,-4> }
		triangle { <0,-35,-11>, <-6.83,-34.33,-11>, <-8.19,-41.19,-11> }
		triangle { <-8.19,-41.19,-11>, <0,-42,-11>, <0,-35,-11> }
		triangle { <0,-35,-4>, <-6.83,-34.33,-4>, <-6.83,-34.33,-11> }
		triangle { <-6.83,-34.33,-11>, <0,-35,-11>, <0,-35,-4> }
		triangle { <0,-42,-4>, <-8.19,-41.19,-4>, <-8.19,-41.19,-11> }
		triangle { <-8.19,-41.19,-11>, <0,-42,-11>, <0,-42,-4> }
		triangle { <-6.83,-34.33,-4>, <-13.39,-32.34,-4>, <-16.07,-38.8,-4> }
		triangle { <-16.07,-38.8,-4>, <-8.19,-41.19,-4>, <-6.83,-34.33,-4> }
		triangle { <-6.83,-34.33,-11>, <-13.39,-32.34,-11>, <-16.07,-38.8,-11> }
		triangle { <-16.07,-38.8,-11>, <-8.19,-41.19,-11>, <-6.83,-34.33,-11> }
		triangle { <-6.83,-34.33,-4>, <-13.39,-32.34,-4>, <-13.39,-32.34,-11> }
		triangle { <-13.39,-32.34,-11>, <-6.83,-34.33,-11>, <-6.83,-34.33,-4> }
		triangle { <-8.19,-41.19,-4>, <-16.07,-38.8,-4>, <-16.07,-38.8,-11> }
		triangle { <-16.07,-38.8,-11>, <-8.19,-41.19,-11>, <-8.19,-41.19,-4> }
		triangle { <-13.39,-32.34,-4>, <-19.44,-29.1,-4>, <-23.33,-34.92,-4> }
		triangle { <-23.33,-34.92,-4>, <-16.07,-38.8,-4>, <-13.39,-32.34,-4> }
		triangle { <-13.39,-32.34,-11>, <-19.44,-29.1,-11>, <-23.33,-34.92,-11> }
		triangle { <-23.33,-34.92,-11>, <-16.07,-38.8,-11>, <-13.39,-32.34,-11> }
		triangle { <-13.39,-32.34,-4>, <-19.44,-29.1,-4>, <-19.44,-29.1,-11> }
		triangle { <-19.44,-29.1,-11>, <-13.39,-32.34,-11>, <-13.39,-32.34,-4> }
		triangle { <-16.07,-38.8,-4>, <-23.33,-34.92,-4>, <-23.33,-34.92,-11> }
		triangle { <-23.33,-34.92,-11>, <-16.07,-38.8,-11>, <-16.07,-38.8,-4> }
		triangle { <-19.44,-29.1,-4>, <-24.75,-24.75,-4>, <-29.7,-29.7,-4> }
		triangle { <-29.7,-29.7,-4>, <-23.33,-34.92,-4>, <-19.44,-29.1,-4> }
		triangle { <-19.44,-29.1,-11>, <-24.75,-24.75,-11>, <-29.7,-29.7,-11> }
		triangle { <-29.7,-29.7,-11>, <-23.33,-34.92,-11>, <-19.44,-29.1,-11> }
		triangle { <-19.44,-29.1,-4>, <-24.75,-24.75,-4>, <-24.75,-24.75,-11> }
		triangle { <-24.75,-24.75,-11>, <-19.44,-29.1,-11>, <-19.44,-29.1,-4> }
		triangle { <-23.33,-34.92,-4>, <-29.7,-29.7,-4>, <-29.7,-29.7,-11> }
		triangle { <-29.7,-29.7,-11>, <-23.33,-34.92,-11>, <-23.33,-34.92,-4> }
		triangle { <-24.75,-24.75,-4>, <-29.1,-19.44,-4>, <-34.92,-23.33,-4> }
		triangle { <-34.92,-23.33,-4>, <-29.7,-29.7,-4>, <-24.75,-24.75,-4> }
		triangle { <-24.75,-24.75,-11>, <-29.1,-19.44,-11>, <-34.92,-23.33,-11> }
		triangle { <-34.92,-23.33,-11>, <-29.7,-29.7,-11>, <-24.75,-24.75,-11> }
		triangle { <-24.75,-24.75,-4>, <-29.1,-19.44,-4>, <-29.1,-19.44,-11> }
		triangle { <-29.1,-19.44,-11>, <-24.75,-24.75,-11>, <-24.75,-24.75,-4> }
		triangle { <-29.7,-29.7,-4>, <-34.92,-23.33,-4>, <-34.92,-23.33,-11> }
		triangle { <-34.92,-23.33,-11>, <-29.7,-29.7,-11>, <-29.7,-29.7,-4> }
		triangle { <-29.1,-19.44,-4>, <-32.34,-13.39,-4>, <-38.8,-16.07,-4> }
		triangle { <-38.8,-16.07,-4>, <-34.92,-23.33,-4>, <-29.1,-19.44,-4> }
		triangle { <-29.1,-19.44,-11>, <-32.34,-13.39,-11>, <-38.8,-16.07,-11> }
		triangle { <-38.8,-16.07,-11>, <-34.92,-23.33,-11>, <-29.1,-19.44,-11> }
		triangle { <-29.1,-19.44,-4>, <-32.34,-13.39,-4>, <-32.34,-13.39,-11> }
		triangle { <-32.34,-13.39,-11>, <-29.1,-19.44,-11>, <-29.1,-19.44,-4> }
		triangle { <-34.92,-23.33,-4>, <-38.8,-16.07,-4>, <-38.8,-16.07,-11> }
		triangle { <-38.8,-16.07,-11>, <-34.92,-23.33,-11>, <-34.92,-23.33,-4> }
		triangle { <-32.34,-13.39,-4>, <-34.33,-6.83,-4>, <-41.19,-8.19,-4> }
		triangle { <-41.19,-8.19,-4>, <-38.8,-16.07,-4>, <-32.34,-13.39,-4> }
		triangle { <-32.34,-13.39,-11>, <-34.33,-6.83,-11>, <-41.19,-8.19,-11> }
		triangle { <-41.19,-8.19,-11>, <-38.8,-16.07,-11>, <-32.34,-13.39,-11> }
		triangle { <-32.34,-13.39,-4>, <-34.33,-6.83,-4>, <-34.33,-6.83,-11> }
		triangle { <-34.33,-6.83,-11>, <-32.34,-13.39,-11>, <-32.34,-13.39,-4> }
		triangle { <-38.8,-16.07,-4>, <-41.19,-8.19,-4>, <-41.19,-8.19,-11> }
		triangle { <-41.19,-8.19,-11>, <-38.8,-16.07,-11>, <-38.8,-16.07,-4> }
		triangle { <-34.33,-6.83,-4>, <-35,0,-4>, <-42,0,-4> }
		triangle { <-42,0,-4>, <-41.19,-8.19,-4>, <-34.33,-6.83,-4> }
		triangle { <-34.33,-6.83,-11>, <-35,0,-11>, <-42,0,-11> }
		triangle { <-42,0,-11>, <-41.19,-8.19,-11>, <-34.33,-6.83,-11> }
		triangle { <-34.33,-6.83,-4>, <-35,0,-4>, <-35,0,-11> }
		triangle { <-35,0,-11>, <-34.33,-6.83,-11>, <-34.33,-6.83,-4> }
		triangle { <-41.19,-8.19,-4>, <-42,0,-4>, <-42,0,-11> }
		triangle { <-42,0,-11>, <-41.19,-8.19,-11>, <-41.19,-8.19,-4> }
		triangle { <-35,0,-4>, <-34.33,6.83,-4>, <-41.19,8.19,-4> }
		triangle { <-41.19,8.19,-4>, <-42,0,-4>, <-35,0,-4> }
		triangle { <-35,0,-11>, <-34.33,6.83,-11>, <-41.19,8.19,-11> }
		triangle { <-41.19,8.19,-11>, <-42,0,-11>, <-35,0,-11> }
		triangle { <-35,0,-4>, <-34.33,6.83,-4>, <-34.33,6.83,-11> }
		triangle { <-34.33,6.83,-11>, <-35,0,-11>, <-35,0,-4> }
		triangle { <-42,0,-4>, <-41.19,8.19,-4>, <-41.19,8.19,-11> }
		triangle { <-41.19,8.19,-11>, <-42,0,-11>, <-42,0,-4> }
		triangle { <-34.33,6.83,-4>, <-32.34,13.39,-4>, <-38.8,16.07,-4> }
		triangle { <-38.8,16.07,-4>, <-41.19,8.19,-4>, <-34.33,6.83,-4> }
		triangle { <-34.33,6.83,-11>, <-32.34,13.39,-11>, <-38.8,16.07,-11> }
		triangle { <-38.8,16.07,-11>, <-41.19,8.19,-11>, <-34.33,6.83,-11> }
		triangle { <-34.33,6.83,-4>, <-32.34,13.39,-4>, <-32.34,13.39,-11> }
		triangle { <-32.34,13.39,-11>, <-34.33,6.83,-11>, <-34.33,6.83,-4> }
		triangle { <-41.19,8.19,-4>, <-38.8,16.07,-4>, <-38.8,16.07,-11> }
		triangle { <-38.8,16.07,-11>, <-41.19,8.19,-11>, <-41.19,8.19,-4> }
		triangle { <-32.34,13.39,-4>, <-29.1,19.44,-4>, <-34.92,23.33,-4> }
		triangle { <-34.92,23.33,-4>, <-38.8,16.07,-4>, <-32.34,13.39,-4> }
		triangle { <-32.34,13.39,-11>, <-29.1,19.44,-11>, <-34.92,23.33,-11> }
		triangle { <-34.92,23.33,-11>, <-38.8,16.07,-11>, <-32.34,13.39,-11> }
		triangle { <-32.34,13.39,-4>, <-29.1,19.44,-4>, <-29.1,19.44,-11> }
		triangle { <-29.1,19.44,-11>, <-32.34,13.39,-11>, <-32.34,13.39,-4> }
		triangle { <-38.8,16.07,-4>, <-34.92,23.33,-4>, <-34.92,23.33,-11> }
		triangle { <-34.92,23.33,-11>, <-38.8,16.07,-11>, <-38.8,16.07,-4> }
		triangle { <-29.1,19.44,-4>, <-24.75,24.75,-4>, <-29.7,29.7,-4> }
		triangle { <-29.7,29.7,-4>, <-34.92,23.33,-4>, <-29.1,19.44,-4> }
		triangle { <-29.1,19.44,-11>, <-24.75,24.75,-11>, <-29.7,29.7,-11> }
		triangle { <-29.7,29.7,-11>, <-34.92,23.33,-11>, <-29.1,19.44,-11> }
		triangle { <-29.1,19.44,-4>, <-24.75,24.75,-4>, <-24.75,24.75,-11> }
		triangle { <-24.75,24.75,-11>, <-29.1,19.44,-11>, <-29.1,19.44,-4> }
		triangle { <-34.92,23.33,-4>, <-29.7,29.7,-4>, <-29.7,29.7,-11> }
		triangle { <-29.7,29.7,-11>, <-34.92,23.33,-11>, <-34.92,23.33,-4> }
		triangle { <-24.75,24.75,-4>, <-19.44,29.1,-4>, <-23.33,34.92,-4> }
		triangle { <-23.33,34.92,-4>, <-29.7,29.7,-4>, <-24.75,24.75,-4> }
		triangle { <-24.75,24.75,-11>, <-19.44,29.1,-11>, <-23.33,34.92,-11> }
		triangle { <-23.33,34.92,-11>, <-29.7,29.7,-11>, <-24.75,24.75,-11> }
		triangle { <-24.75,24.75,-4>, <-19.44,29.1,-4>, <-19.44,29.1,-11> }
		triangle { <-19.44,29.1,-11>, <-24.75,24.75,-11>, <-24.75,24.75,-4> }
		triangle { <-29.7,29.7,-4>, <-23.33,34.92,-4>, <-23.33,34.92,-11> }
		triangle { <-23.33,34.92,-11>, <-29.7,29.7,-11>, <-29.7,29.7,-4> }
		triangle { <-19.44,29.1,-4>, <-13.39,32.34,-4>, <-16.07,38.8,-4> }
		triangle { <-16.07,38.8,-4>, <-23.33,34.92,-4>, <-19.44,29.1,-4> }
		triangle { <-19.44,29.1,-11>, <-13.39,32.34,-11>, <-16.07,38.8,-11> }
		triangle { <-16.07,38.8,-11>, <-23.33,34.92,-11>, <-19.44,29.1,-11> }
		triangle { <-19.44,29.1,-4>, <-13.39,32.34,-4>, <-13.39,32.34,-11> }
		triangle { <-13.39,32.34,-11>, <-19.44,29.1,-11>, <-19.44,29.1,-4> }
		triangle { <-23.33,34.92,-4>, <-16.07,38.8,-4>, <-16.07,38.8,-11> }
		triangle { <-16.07,38.8,-11>, <-23.33,34.92,-11>, <-23.33,34.92,-4> }
		triangle { <-13.39,32.34,-4>, <-6.83,34.33,-4>, <-8.19,41.19,-4> }
		triangle { <-8.19,41.19,-4>, <-16.07,38.8,-4>, <-13.39,32.34,-4> }
		triangle { <-13.39,32.34,-11>, <-6.83,34.33,-11>, <-8.19,41.19,-11> }
		triangle { <-8.19,41.19,-11>, <-16.07,38.8,-11>, <-13.39,32.34,-11> }
		triangle { <-13.39,32.34,-4>, <-6.83,34.33,-4>, <-6.83,34.33,-11> }
		triangle { <-6.83,34.33,-11>, <-13.39,32.34,-11>, <-13.39,32.34,-4> }
		triangle { <-16.07,38.8,-4>, <-8.19,41.19,-4>, <-8.19,41.19,-11> }
		triangle { <-8.19,41.19,-11>, <-16.07,38.8,-11>, <-16.07,38.8,-4> }
		triangle { <-6.83,34.33,-4>, <0,35,-4>, <0,42,-4> }
		triangle { <0,42,-4>, <-8.19,41.19,-4>, <-6.83,34.33,-4> }
		triangle { <-6.83,34.33,-11>, <0,35,-11>, <0,42,-11> }
		triangle { <0,42,-11>, <-8.19,41.19,-11>, <-6.83,34.33,-11> }
		triangle { <-6.83,34.33,-4>, <0,35,-4>, <0,35,-11> }
		triangle { <0,35,-11>, <-6.83,34.33,-11>, <-6.83,34.33,-4> }
		triangle { <-8.19,41.19,-4>, <0,42,-4>, <0,42,-11> }
		triangle { <0,42,-11>, <-8.19,41.19,-11>, <-8.19,41.19,-4> }
		triangle { <0,35,-4>, <6.83,34.33,-4>, <8.19,41.19,-4> }
		triangle { <8.19,41.19,-4>, <0,42,-4>, <0,35,-4> }
		triangle { <0,35,-11>, <6.83,34.33,-11>, <8.19,41.19,-11> }
		triangle { <8.19,41.19,-11>, <0,42,-11>, <0,35,-11> }
		triangle { <0,35,-4>, <6.83,34.33,-4>, <6.83,34.33,-11> }
		triangle { <6.83,34.33,-11>, <0,35,-11>, <0,35,-4> }
		triangle { <0,42,-4>, <8.19,41.19,-4>, <8.19,41.19,-11> }
		triangle { <8.19,41.19,-11>, <0,42,-11>, <0,42,-4> }
		triangle { <6.83,34.33,-4>, <13.39,32.34,-4>, <16.07,38.8,-4> }
		triangle { <16.07,38.8,-4>, <8.19,41.19,-4>, <6.83,34.33,-4> }
		triangle { <6.83,34.33,-11>, <13.39,32.34,-11>, <16.07,38.8,-11> }
		triangle { <16.07,38.8,-11>, <8.19,41.19,-11>, <6.83,34.33,-11> }
		triangle { <6.83,34.33,-4>, <13.39,32.34,-4>, <13.39,32.34,-11> }
		triangle { <13.39,32.34,-11>, <6.83,34.33,-11>, <6.83,34.33,-4> }
		triangle { <8.19,41.19,-4>, <16.07,38.8,-4>, <16.07,38.8,-11> }
		triangle { <16.07,38.8,-11>, <8.19,41.19,-11>, <8.19,41.19,-4> }
		triangle { <13.39,32.34,-4>, <19.44,29.1,-4>, <23.33,34.92,-4> }
		triangle { <23.33,34.92,-4>, <16.07,38.8,-4>, <13.39,32.34,-4> }
		triangle { <13.39,32.34,-11>, <19.44,29.1,-11>, <23.33,34.92,-11> }
		triangle { <23.33,34.92,-11>, <16.07,38.8,-11>, <13.39,32.34,-11> }
		triangle { <13.39,32.34,-4>, <19.44,29.1,-4>, <19.44,29.1,-11> }
		triangle { <19.44,29.1,-11>, <13.39,32.34,-11>, <13.39,32.34,-4> }
		triangle { <16.07,38.8,-4>, <23.33,34.92,-4>, <23.33,34.92,-11> }
		triangle { <23.33,34.92,-11>, <16.07,38.8,-11>, <16.07,38.8,-4> }
		triangle { <19.44,29.1,-4>, <24.75,24.75,-4>, <29.7,29.7,-4> }
		triangle { <29.7,29.7,-4>, <23.33,34.92,-4>, <19.44,29.1,-4> }
		triangle { <19.44,29.1,-11>, <24.75,24.75,-11>, <29.7,29.7,-11> }
		triangle { <29.7,29.7,-11>, <23.33,34.92,-11>, <19.44,29.1,-11> }
		triangle { <19.44,29.1,-4>, <24.75,24.75,-4>, <24.75,24.75,-11> }
		triangle { <24.75,24.75,-11>, <19.44,29.1,-11>, <19.44,29.1,-4> }
		triangle { <23.33,34.92,-4>, <29.7,29.7,-4>, <29.7,29.7,-11> }
		triangle { <29.7,29.7,-11>, <23.33,34.92,-11>, <23.33,34.92,-4> }
		triangle { <24.75,24.75,-4>, <29.1,19.44,-4>, <34.92,23.33,-4> }
		triangle { <34.92,23.33,-4>, <29.7,29.7,-4>, <24.75,24.75,-4> }
		triangle { <24.75,24.75,-11>, <29.1,19.44,-11>, <34.92,23.33,-11> }
		triangle { <34.92,23.33,-11>, <29.7,29.7,-11>, <24.75,24.75,-11> }
		triangle { <24.75,24.75,-4>, <29.1,19.44,-4>, <29.1,19.44,-11> }
		triangle { <29.1,19.44,-11>, <24.75,24.75,-11>, <24.75,24.75,-4> }
		triangle { <29.7,29.7,-4>, <34.92,23.33,-4>, <34.92,23.33,-11> }
		triangle { <34.92,23.33,-11>, <29.7,29.7,-11>, <29.7,29.7,-4> }
		triangle { <29.1,19.44,-4>, <32.34,13.39,-4>, <38.8,16.07,-4> }
		triangle { <38.8,16.07,-4>, <34.92,23.33,-4>, <29.1,19.44,-4> }
		triangle { <29.1,19.44,-11>, <32.34,13.39,-11>, <38.8,16.07,-11> }
		triangle { <38.8,16.07,-11>, <34.92,23.33,-11>, <29.1,19.44,-11> }
		triangle { <29.1,19.44,-4>, <32.34,13.39,-4>, <32.34,13.39,-11> }
		triangle { <32.34,13.39,-11>, <29.1,19.44,-11>, <29.1,19.44,-4> }
		triangle { <34.92,23.33,-4>, <38.8,16.07,-4>, <38.8,16.07,-11> }
		triangle { <38.8,16.07,-11>, <34.92,23.33,-11>, <34.92,23.33,-4> }
		triangle { <32.34,13.39,-4>, <34.33,6.83,-4>, <41.19,8.19,-4> }
		triangle { <41.19,8.19,-4>, <38.8,16.07,-4>, <32.34,13.39,-4> }
		triangle { <32.34,13.39,-11>, <34.33,6.83,-11>, <41.19,8.19,-11> }
		triangle { <41.19,8.19,-11>, <38.8,16.07,-11>, <32.34,13.39,-11> }
		triangle { <32.34,13.39,-4>, <34.33,6.83,-4>, <34.33,6.83,-11> }
		triangle { <34.33,6.83,-11>, <32.34,13.39,-11>, <32.34,13.39,-4> }
		triangle { <38.8,16.07,-4>, <41.19,8.19,-4>, <41.19,8.19,-11> }
		triangle { <41.19,8.19,-11>, <38.8,16.07,-11>, <38.8,16.07,-4> }
		triangle { <34.33,6.83,-4>, <35,0,-4>, <42,0,-4> }
		triangle { <42,0,-4>, <41.19,8.19,-4>, <34.33,6.83,-4> }
		triangle { <34.33,6.83,-11>, <35,0,-11>, <42,0,-11> }
		triangle { <42,0,-11>, <41.19,8.19,-11>, <34.33,6.83,-11> }
		triangle { <34.33,6.83,-4>, <35,0,-4>, <35,0,-11> }
		triangle { <35,0,-11>, <34.33,6.83,-11>, <34.33,6.83,-4> }
		triangle { <41.19,8.19,-4>, <42,0,-4>, <42,0,-11> }
		triangle { <42,0,-11>, <41.19,8.19,-11>, <41.19,8.19,-4> }
	}
	object { _4_dash_8sphe_dot_dat matrix <2,0,0,0,0,-2,0,2,0,0,-38.5,-11> }
	object { _4_dash_8sphe_dot_dat matrix <1.41,1.41,0,0,0,-2,-1.41,1.41,0,27.22,-27.22,-11> }
	object { _4_dash_8sphe_dot_dat matrix <0,2,0,0,0,-2,-2,0,0,38.5,0,-11> }
	object { _4_dash_8sphe_dot_dat matrix <-1.41,1.41,0,0,0,-2,-1.41,-1.41,0,27.22,27.22,-11> }
	object { _4_dash_8sphe_dot_dat matrix <-2,0,0,0,0,-2,0,-2,0,0,38.5,-11> }
	object { _4_dash_8sphe_dot_dat matrix <-1.41,-1.41,0,0,0,-2,1.41,-1.41,0,-27.22,27.22,-11> }
	object { _4_dash_8sphe_dot_dat matrix <0,-2,0,0,0,-2,2,0,0,-38.5,0,-11> }
	object { _4_dash_8sphe_dot_dat matrix <1.41,-1.41,0,0,0,-2,1.41,1.41,0,-27.22,-27.22,-11> }
// 
}
#end

#declare legoman_27_s__chair_dot_dat = union {
// The Throne of Legoman
// Name: Legoman's_Chair.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 1 1
	object {
		_4079_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,-9,0>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object {
		_4032_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,-1,0>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object {
		_4489_dot_dat
		matrix <1-SW/84,0,0,0,1-SW/84,0,0,0,1-SW/21,0,0,SW/-8.4>
		matrix <1,0,0,0,0,1,0,-1,0,0,13.001,0>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}                            
	#if (clock>=0.90)
	  rotate (-270*(clock-0.9)/0.1-270*((clock-0.9)*(clock-0.9))/0.01)*y
	#end
// 
}

#ifndef (Color383)
#declare Color383 = #if (version >= 3.1) material { #end texture {
	lg_chrome
} #if (version >= 3.1) } #end
#declare Color383_slope = #if (version >= 3.1) material { #end texture {
	lg_chrome
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color47)
#declare Color47 = #if (version >= 3.1) material { #end texture {
	#if (QUAL > 1) lg_clear #else lg_white #end
} #if (version >= 3.1) } #end
#declare Color47_slope = #if (version >= 3.1) material { #end texture {
	#if (QUAL > 1) lg_clear #else lg_white #end
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare rect_dot_dat = object {
// Rectangle
// Name: RECT.dat
// Author: James Jessiman
// Original LDraw Primitive - LDraw beta 0.27 Archive
	mesh {
		triangle { <1,0,1>, <1,0,-1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,0,1>, <1,0,1> }
// 
	}
}

#declare _4_dash_4ndis_dot_dat = #if (version >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 2, 1
		clipped_by { box { <-1,-1,-1>, <1,1,1> } }
	}
#else
	difference {
		box { <-1,-0.001,-1>, <1,0.001,1> }
		cylinder { <0,-1,0>, <0,1,0>, 1 }
	}
#end

#declare _1_dash_4cyli_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open clipped_by { box { <0,-1,0>,<2,2,2> } } }

#declare studel_dot_dat = union {
// Stud with Electric Contact
// name studel.dat
// (c) Remco Braak 1997
// rbraak@nat.vu.nl
// To be copied into the ldraw\p directory
// Official LCad update 97-01
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,-4,0,0,0,6,0,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,-4,0,0,0,-6,0,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,-4,0,0,0,6,0,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,-3,0,0,0,-6,0,0,0> #if (version >= 3.1) material #else texture #end { Color14 } }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,-1,0,0,0,-6,0,-3,0> }
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,-4,0> }
// 
}

#declare _6035_dot_dat = #if (QUAL = 0) box { <-20,-4,-24>, <20,24,10> } #else union {
// Electric Light & Sound Brick  1 x  2 with Single Side Light
// Name: 6035.dat
// Author: Thomas Burger
// Official LCad update 99-01
// inline of 6034
// --------------
	mesh {
		triangle { <-20,24,-10>, <-16,24,-6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <-20,24,-10> }
		triangle { <-16,24,6>, <-5.5,24,6>, <-3.5,24,10> }
		triangle { <-3.5,24,10>, <-20,24,10>, <-16,24,6> }
		triangle { <-3.5,24,4>, <-5.5,24,6>, <-3.5,24,10> }
		triangle { <-3.5,24,4>, <-3.5,24,6>, <3.5,24,6> }
		triangle { <3.5,24,6>, <3.5,24,4>, <-3.5,24,4> }
		triangle { <3.5,24,4>, <5.5,24,6>, <3.5,24,10> }
		triangle { <16,24,6>, <5.5,24,6>, <3.5,24,10> }
		triangle { <3.5,24,10>, <20,24,10>, <16,24,6> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <20,24,-10> }
		triangle { <-4,24,-1.7>, <-4,24,1.7>, <-1.7,24,1.7> }
		triangle { <-1.7,24,1.7>, <-1.7,24,-1.7>, <-4,24,-1.7> }
		triangle { <-1.7,24,-6>, <-1.7,24,4>, <1.7,24,4> }
		triangle { <1.7,24,4>, <1.7,24,-6>, <-1.7,24,-6> }
		triangle { <4,24,-1.7>, <4,24,1.7>, <1.7,24,1.7> }
		triangle { <1.7,24,1.7>, <1.7,24,-1.7>, <4,24,-1.7> }
// 
// 
// 
// 
// 
// 
// 
		triangle { <1.7,20,-6>, <1.7,20,-1.7>, <1.7,24,-1.7> }
		triangle { <1.7,24,-1.7>, <1.7,24,-6>, <1.7,20,-6> }
		triangle { <1.7,20,-1.7>, <4,20,-1.7>, <4,24,-1.7> }
		triangle { <4,24,-1.7>, <1.7,24,-1.7>, <1.7,20,-1.7> }
		triangle { <4,20,-1.7>, <4,20,1.7>, <4,24,1.7> }
		triangle { <4,24,1.7>, <4,24,-1.7>, <4,20,-1.7> }
		triangle { <4,20,1.7>, <1.7,20,1.7>, <1.7,24,1.7> }
		triangle { <1.7,24,1.7>, <4,24,1.7>, <4,20,1.7> }
		triangle { <1.7,20,1.7>, <1.7,20,4>, <1.7,24,4> }
		triangle { <1.7,24,4>, <1.7,24,1.7>, <1.7,20,1.7> }
		triangle { <1.7,20,4>, <3.5,20,4>, <3.5,24,4> }
		triangle { <3.5,24,4>, <1.7,24,4>, <1.7,20,4> }
		triangle { <3.5,20,4>, <5.5,20,6>, <5.5,24,6> }
		triangle { <5.5,24,6>, <3.5,24,4>, <3.5,20,4> }
		triangle { <5.5,20,6>, <16,20,6>, <16,24,6> }
		triangle { <16,24,6>, <5.5,24,6>, <5.5,20,6> }
		triangle { <1.7,20,-6>, <16,20,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <1.7,24,-6>, <1.7,20,-6> }
	}
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,6,16,22,0> #if (version >= 3.1) material #else texture #end { Color383 } }
// 
	mesh {
		triangle { <-1.7,20,-6>, <-1.7,20,-1.7>, <-1.7,24,-1.7> }
		triangle { <-1.7,24,-1.7>, <-1.7,24,-6>, <-1.7,20,-6> }
		triangle { <-1.7,20,-1.7>, <-4,20,-1.7>, <-4,24,-1.7> }
		triangle { <-4,24,-1.7>, <-1.7,24,-1.7>, <-1.7,20,-1.7> }
		triangle { <-4,20,-1.7>, <-4,20,1.7>, <-4,24,1.7> }
		triangle { <-4,24,1.7>, <-4,24,-1.7>, <-4,20,-1.7> }
		triangle { <-4,20,1.7>, <-1.7,20,1.7>, <-1.7,24,1.7> }
		triangle { <-1.7,24,1.7>, <-4,24,1.7>, <-4,20,1.7> }
		triangle { <-1.7,20,1.7>, <-1.7,20,4>, <-1.7,24,4> }
		triangle { <-1.7,24,4>, <-1.7,24,1.7>, <-1.7,20,1.7> }
		triangle { <-1.7,20,4>, <-3.5,20,4>, <-3.5,24,4> }
		triangle { <-3.5,24,4>, <-1.7,24,4>, <-1.7,20,4> }
		triangle { <-3.5,20,4>, <-5.5,20,6>, <-5.5,24,6> }
		triangle { <-5.5,24,6>, <-3.5,24,4>, <-3.5,20,4> }
		triangle { <-5.5,20,6>, <-16,20,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-5.5,24,6>, <-5.5,20,6> }
		triangle { <-1.7,20,-6>, <-16,20,-6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-1.7,24,-6>, <-1.7,20,-6> }
	}
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,6,-16,22,0> #if (version >= 3.1) material #else texture #end { Color383 } }
// 
	mesh {
		triangle { <-4,20,-1.7>, <-16,20,-6>, <-16,20,6> }
		triangle { <-1.7,20,-1.7>, <-4,20,-1.7>, <-16,20,-6> }
		triangle { <-16,20,-6>, <-1.7,20,-6>, <-1.7,20,-1.7> }
		triangle { <-4,20,-1.7>, <-4,20,1.7>, <-5.5,20,6> }
		triangle { <-5.5,20,6>, <-16,20,6>, <-4,20,-1.7> }
		triangle { <-4,20,1.7>, <-1.7,20,1.7>, <-3.5,20,4> }
		triangle { <-3.5,20,4>, <-5.5,20,6>, <-4,20,1.7> }
		triangle { <-1.7,20,1.7>, <-1.7,20,4>, <-1.7,20,4> }
		triangle { <-1.7,20,4>, <-3.5,20,4>, <-1.7,20,1.7> }
		triangle { <4,20,-1.7>, <16,20,-6>, <16,20,6> }
		triangle { <1.7,20,-1.7>, <4,20,-1.7>, <16,20,-6> }
		triangle { <16,20,-6>, <1.7,20,-6>, <1.7,20,-1.7> }
		triangle { <4,20,-1.7>, <4,20,1.7>, <5.5,20,6> }
		triangle { <5.5,20,6>, <16,20,6>, <4,20,-1.7> }
		triangle { <4,20,1.7>, <1.7,20,1.7>, <3.5,20,4> }
		triangle { <3.5,20,4>, <5.5,20,6>, <4,20,1.7> }
		triangle { <1.7,20,1.7>, <1.7,20,4>, <1.7,20,4> }
		triangle { <1.7,20,4>, <3.5,20,4>, <1.7,20,1.7> }
// ---------
// end inlining
	}
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,0,1,0,6,0,0,10,-8> #if (version >= 3.1) material #else texture #end { Color0 } }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,0,1,0,6,0,0,10,-10> }
	mesh {
		triangle { <6,4,-10>, <6,10,-10>, <20,10,-10> }
		triangle { <20,10,-10>, <20,0,-10>, <6,4,-10> }
		triangle { <-20,10,-10>, <-6,10,-10>, <-6,4,-10> }
		triangle { <-6,4,-10>, <-20,0,-10>, <-20,10,-10> }
		triangle { <-20,10,-10>, <-6,10,-10>, <-6,16,-10> }
		triangle { <-6,16,-10>, <-20,24,-10>, <-20,10,-10> }
		triangle { <6,16,-10>, <20,24,-10>, <20,10,-10> }
		triangle { <20,10,-10>, <6,10,-10>, <6,16,-10> }
		triangle { <-20,0,-10>, <-6,4,-10>, <6,4,-10> }
		triangle { <6,4,-10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,24,-10>, <-6,16,-10>, <6,16,-10> }
		triangle { <6,16,-10>, <20,24,-10>, <-20,24,-10> }
// 
		triangle { <20,0,10>, <20,0,-10>, <20,10,-10> }
		triangle { <20,10,-10>, <20,10,10>, <20,0,10> }
		triangle { <20,10,10>, <20,10,-10>, <20,13.5,-4> }
		triangle { <20,13.5,-4>, <20,13.5,4>, <20,10,10> }
		triangle { <20,10,10>, <20,13.5,4>, <20,17,4> }
		triangle { <20,17,4>, <20,24,10>, <20,10,10> }
		triangle { <20,10,-10>, <20,13.5,-4>, <20,17,-4> }
		triangle { <20,17,-4>, <20,24,-10>, <20,10,-10> }
		triangle { <20,24,10>, <20,24,-10>, <20,17,-4> }
		triangle { <20,17,-4>, <20,17,4>, <20,24,10> }
		triangle { <20,13.5,4>, <20,13.5,-4>, <20,17,-4> }
		triangle { <20,17,-4>, <20,17,4>, <20,13.5,4> }
// 
		triangle { <-20,0,10>, <-20,0,-10>, <-20,10,-10> }
		triangle { <-20,10,-10>, <-20,10,10>, <-20,0,10> }
		triangle { <-20,10,10>, <-20,10,-10>, <-20,13.5,-4> }
		triangle { <-20,13.5,-4>, <-20,13.5,4>, <-20,10,10> }
		triangle { <-20,10,10>, <-20,13.5,4>, <-20,17,4> }
		triangle { <-20,17,4>, <-20,24,10>, <-20,10,10> }
		triangle { <-20,10,-10>, <-20,13.5,-4>, <-20,17,-4> }
		triangle { <-20,17,-4>, <-20,24,-10>, <-20,10,-10> }
		triangle { <-20,24,10>, <-20,24,-10>, <-20,17,-4> }
		triangle { <-20,17,-4>, <-20,17,4>, <-20,24,10> }
		triangle { <-20,13.5,4>, <-20,13.5,-4>, <-20,17,-4> }
		triangle { <-20,17,-4>, <-20,17,4>, <-20,13.5,4> }
// 
// Top
		triangle { <20,0,10>, <3.5,0,10>, <3.5,0,-10> }
		triangle { <3.5,0,-10>, <20,0,-10>, <20,0,10> }
		triangle { <3.5,0,6>, <-3.5,0,6>, <-3.5,0,-10> }
		triangle { <-3.5,0,-10>, <3.5,0,-10>, <3.5,0,6> }
		triangle { <-20,0,10>, <-3.5,0,10>, <-3.5,0,-10> }
		triangle { <-3.5,0,-10>, <-20,0,-10>, <-20,0,10> }
// 
		triangle { <20,24,10>, <3.5,24,10>, <3.5,10,10> }
		triangle { <3.5,10,10>, <20,10,10>, <20,24,10> }
		triangle { <20,10,10>, <3.5,10,10>, <3.5,0,10> }
		triangle { <3.5,0,10>, <20,0,10>, <20,10,10> }
	}
	object { rect_dot_dat matrix <0,5,0,-1,0,0,0,0,2,3.5,5,8> }
	object { rect_dot_dat matrix <0,7,0,-1,0,0,0,0,2,3.5,17,8> }
	mesh {
		triangle { <3.5,24,6>, <-3.5,24,6>, <-3.5,10,6> }
		triangle { <-3.5,10,6>, <3.5,10,6>, <3.5,24,6> }
		triangle { <3.5,10,6>, <-3.5,10,6>, <-3.5,0,6> }
		triangle { <-3.5,0,6>, <3.5,0,6>, <3.5,10,6> }
	}
	object { rect_dot_dat matrix <0,5,0,-1,0,0,0,0,2,-3.5,5,8> }
	object { rect_dot_dat matrix <0,7,0,-1,0,0,0,0,2,-3.5,17,8> }
	mesh {
		triangle { <-20,24,10>, <-3.5,24,10>, <-3.5,10,10> }
		triangle { <-3.5,10,10>, <-20,10,10>, <-20,24,10> }
		triangle { <-20,10,10>, <-3.5,10,10>, <-3.5,0,10> }
		triangle { <-3.5,0,10>, <-20,0,10>, <-20,10,10> }
	}
	#if (STUDS)
		object { studel_dot_dat matrix <0,0,1,0,1,0,-1,0,0,10,0,0> }
		object { studel_dot_dat matrix <0,0,-1,0,1,0,1,0,0,-10,0,0> }
// 
	#end
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-2,0,-6,0,0,10,-8> }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-4,0,-6,0,0,10,-10> #if (version >= 3.1) material #else texture #end { Color47 } }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-4,0,-6,0,0,10,-14> #if (version >= 3.1) material #else texture #end { Color47 } }
	object { _4_dash_8sphe_dot_dat matrix <6,0,0,0,0,-6,0,-6,0,0,10,-18> #if (version >= 3.1) material #else texture #end { Color47 } }
// 
}
#end

#declare ring3_dot_dat = #if (version >= 3.1)
	disc { <0,0,0>, <0,1,0>, 4, 3 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 4 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 3 }
	}
#end

#declare _4773_dot_dat = #if (QUAL = 0) box { <-8,-13.5,-8>, <8,0,8> } #else union {
// Electric Light & Sound Colored Globe
// Name: 4773.dat
// Author: Thomas Burger
// LDRAW_ORG Part UPDATE 2001-02
// 2000-09-18 TLC Removed two cylinders and elongated and
//                repositioned two others to fix two gaps and
//                get rid of redundant polygons.  Also replace
//                16 quads which formed a ring with 4 1/4 rings.
// Travis Cobbs replaced the original 16 quads which formed
// a ring with the following line. Note that it is doubled in
// size to final radii of 6-8.
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,0,0> }
// The following two lines were adjusted by Travis Cobbs to
// the correct positions and lengths.
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,8,0,0,0,6,0,-8,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,9.5,0,0,0,8,0,-9.5,0> }
// The following two lines were commented out by
// Travis Cobbs, since they are unnecessary after the
// adjustments above.
// 1 16 0 -8 0 6 0 0 0 4 0 0 0 6 4-4cyli.dat
// 1 16 0 -9.4 0 8 0 0 0 5 0 0 0 8 4-4cyli.dat
	object { _4_dash_8sphe_dot_dat matrix <6,0,0,0,-4,0,0,0,6,0,-8,0> }
	object { _4_dash_8sphe_dot_dat matrix <8,0,0,0,-4,0,0,0,8,0,-9.5,0> }
// 
}
#end

#ifndef (Color8)
#declare Color8 = #if (version >= 3.1) material { #end texture {
	lg_dark_grey
} #if (version >= 3.1) } #end
#declare Color8_slope = #if (version >= 3.1) material { #end texture {
	lg_dark_grey
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare box3_crosshatch_8p_dot_dat = object {
// box3#8p.dat
// Official LCad update 98-10
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,-1>, <-1,0,-1>, <1,0,-1> }
		triangle { <1,0,-1>, <1,1,-1>, <-1,1,-1> }
	}
}

#declare box4_dot_dat = object {
// Box 4 (four faces)
// Name: BOX4.dat
// Author: James Jessiman
// Original LDraw Primitive - LDraw beta 0.27 Archive
	mesh {
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <-1,1,-1>, <-1,0,-1>, <1,0,-1> }
		triangle { <1,0,-1>, <1,1,-1>, <-1,1,-1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
// 
	}
}

#declare box4_dash_4a_dot_dat = object {
// Box, 4 faces drawn, 4 adjacent edges left out
// Name: box4-4a.dat
// Author: M. Moolhuysen 1998
// Official LCad Update 98-07
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
	}
}

#declare _1_dash_4cyls2_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open
	clipped_by { plane { <1,0,-1>,-O7071 } plane { <1,1,0>,0 } } }

#declare stud4_dot_dat = object {
	lg_plate_cylinder scale <1,1,-1> translate <0,0,LG_PLATE_INNER_HEIGHT>
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}

#declare _1_dash_4ndis_dot_dat = #if (version >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 2, 1
		clipped_by { box { <0,-1,0>, <1,1,1> } }
	}
#else
	difference {
		box { <0,-0.001,0>, <1,0.001,1> }
		cylinder { <0,-1,0>, <0,1,0>, 1 }
	}
#end

#declare _2982_dot_dat = #if (QUAL = 0) box { <-40,-7.5,-20>, <40,8,20> } #else union {
// Electric Light Sensor Bottom
// Name: 2982.dat
// Author: John VanZwieten
// Official LCad update 99-05
// Plate  2 x  4
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
	#end
	mesh {
		triangle { <36,4,16>, <36,4,-16>, <-34,4,-16> }
		triangle { <-34,4,-16>, <-34,4,16>, <36,4,16> }
		triangle { <36,4,-16>, <36,8,-16>, <36,8,16> }
		triangle { <36,8,16>, <36,4,16>, <36,4,-16> }
		triangle { <40,8,20>, <40,8,18>, <-40,8,18> }
		triangle { <-40,8,18>, <-40,8,20>, <40,8,20> }
		triangle { <40,8,-20>, <40,8,-18>, <-40,8,-18> }
		triangle { <-40,8,-18>, <-40,8,-20>, <40,8,-20> }
		triangle { <40,8,20>, <36,8,16>, <36,8,-16> }
		triangle { <36,8,-16>, <40,8,-20>, <40,8,20> }
	}
	object { box3_crosshatch_8p_dot_dat matrix <0,2,0,0,0,2,6,0,0,-20,6,16> }
	object { box3_crosshatch_8p_dot_dat matrix <0,2,0,0,0,2,6,0,0,0,6,16> }
	object { box3_crosshatch_8p_dot_dat matrix <0,2,0,0,0,2,6,0,0,20,6,16> }
	object { box3_crosshatch_8p_dot_dat matrix <0,2,0,0,0,-2,-6,0,0,-20,6,-16> }
	object { box3_crosshatch_8p_dot_dat matrix <0,2,0,0,0,-2,-6,0,0,0,6,-16> }
	object { box3_crosshatch_8p_dot_dat matrix <0,2,0,0,0,-2,-6,0,0,20,6,-16> }
	object { box4_dot_dat matrix <6,0,0,0,4,0,0,0,1,-20,0,17> }
	object { box4_dot_dat matrix <6,0,0,0,4,0,0,0,1,0,0,17> }
	object { box4_dot_dat matrix <6,0,0,0,4,0,0,0,1,20,0,17> }
	object { box4_dot_dat matrix <6,0,0,0,4,0,0,0,1,-20,0,-17> }
	object { box4_dot_dat matrix <6,0,0,0,4,0,0,0,1,0,0,-17> }
	object { box4_dot_dat matrix <6,0,0,0,4,0,0,0,1,20,0,-17> }
	object { box4_dash_4a_dot_dat matrix <4,0,0,0,4,0,0,0,1,10,4,-17> }
	object { box4_dash_4a_dot_dat matrix <4,0,0,0,4,0,0,0,1,-10,4,-17> }
	object { box4_dash_4a_dot_dat matrix <-4,0,0,0,4,0,0,0,-1,10,4,17> }
	object { box4_dash_4a_dot_dat matrix <-4,0,0,0,4,0,0,0,-1,-10,4,17> }
	mesh {
		triangle { <26,8,16>, <26,8,18>, <36,8,18> }
		triangle { <36,8,18>, <36,8,16>, <26,8,16> }
		triangle { <26,8,16>, <26,4,16>, <36,4,16> }
		triangle { <36,4,16>, <36,8,16>, <26,8,16> }
		triangle { <26,8,18>, <26,4,18>, <26,4,16> }
		triangle { <26,4,16>, <26,8,16>, <26,8,18> }
		triangle { <-36,8,16>, <-36,8,18>, <-26,8,18> }
		triangle { <-26,8,18>, <-26,8,16>, <-36,8,16> }
		triangle { <-36,8,16>, <-36,4,16>, <-26,4,16> }
		triangle { <-26,4,16>, <-26,8,16>, <-36,8,16> }
		triangle { <-26,8,16>, <-26,4,16>, <-26,4,18> }
		triangle { <-26,4,18>, <-26,8,18>, <-26,8,16> }
		triangle { <36,8,-16>, <36,8,-18>, <26,8,-18> }
		triangle { <26,8,-18>, <26,8,-16>, <36,8,-16> }
		triangle { <36,8,-16>, <36,4,-16>, <26,4,-16> }
		triangle { <26,4,-16>, <26,8,-16>, <36,8,-16> }
		triangle { <26,8,-16>, <26,4,-16>, <26,4,-18> }
		triangle { <26,4,-18>, <26,8,-18>, <26,8,-16> }
		triangle { <-26,8,-16>, <-26,8,-18>, <-36,8,-18> }
		triangle { <-36,8,-18>, <-36,8,-16>, <-26,8,-16> }
		triangle { <-26,8,-16>, <-26,4,-16>, <-36,4,-16> }
		triangle { <-36,4,-16>, <-36,8,-16>, <-26,8,-16> }
		triangle { <-26,8,-18>, <-26,4,-18>, <-26,4,-16> }
		triangle { <-26,4,-16>, <-26,8,-16>, <-26,8,-18> }
		triangle { <40,0,20>, <40,0,18>, <-40,0,18> }
		triangle { <-40,0,18>, <-40,0,20>, <40,0,20> }
		triangle { <40,0,16>, <40,0,-16>, <-34,0,-16> }
		triangle { <-34,0,-16>, <-34,0,16>, <40,0,16> }
		triangle { <40,0,-18>, <40,0,-20>, <-40,0,-20> }
		triangle { <-40,0,-20>, <-40,0,-18>, <40,0,-18> }
		triangle { <6,0,16>, <14,0,16>, <14,0,18> }
		triangle { <14,0,18>, <6,0,18>, <6,0,16> }
		triangle { <-14,0,16>, <-6,0,16>, <-6,0,18> }
		triangle { <-6,0,18>, <-14,0,18>, <-14,0,16> }
		triangle { <-14,0,-18>, <-6,0,-18>, <-6,0,-16> }
		triangle { <-6,0,-16>, <-14,0,-16>, <-14,0,-18> }
		triangle { <6,0,-18>, <14,0,-18>, <14,0,-16> }
		triangle { <14,0,-16>, <6,0,-16>, <6,0,-18> }
		triangle { <-36,0,16>, <-26,0,16>, <-26,0,18> }
		triangle { <-26,0,18>, <-36,0,18>, <-36,0,16> }
		triangle { <26,0,16>, <36,0,16>, <36,0,18> }
		triangle { <36,0,18>, <26,0,18>, <26,0,16> }
		triangle { <-36,0,-18>, <-26,0,-18>, <-26,0,-16> }
		triangle { <-26,0,-16>, <-36,0,-16>, <-36,0,-18> }
		triangle { <26,0,-18>, <36,0,-18>, <36,0,-16> }
		triangle { <36,0,-16>, <26,0,-16>, <26,0,-18> }
		triangle { <40,0,20>, <36,0,20>, <36,0,-20> }
		triangle { <36,0,-20>, <40,0,-20>, <40,0,20> }
		triangle { <40,0,20>, <40,8,20>, <-40,8,20> }
		triangle { <-40,8,20>, <-40,0,20>, <40,0,20> }
		triangle { <-40,0,-20>, <-40,8,-20>, <40,8,-20> }
		triangle { <40,8,-20>, <40,0,-20>, <-40,0,-20> }
		triangle { <40,0,-20>, <40,8,-20>, <40,8,20> }
		triangle { <40,8,20>, <40,0,20>, <40,0,-20> }
// 
// inner box side
// inner box top
// inner box side
		triangle { <-36,8,16>, <-36,8,7>, <-36,4,7> }
		triangle { <-36,4,7>, <-36,4,16>, <-36,8,16> }
		triangle { <-36,8,-7>, <-36,8,-16>, <-36,4,-16> }
		triangle { <-36,4,-16>, <-36,4,-7>, <-36,8,-7> }
// inner box top
		triangle { <-36,4,16>, <-36,4,10>, <-24,4,10> }
		triangle { <-24,4,10>, <-24,4,16>, <-36,4,16> }
		triangle { <-36,4,-10>, <-36,4,-16>, <-24,4,-16> }
		triangle { <-24,4,-16>, <-24,4,-10>, <-36,4,-10> }
// outer box bottom
// outer box side
// outer box top
// inner+outer box bottom
		triangle { <-36,8,-7>, <-34,8,-5>, <-34,4,-5> }
		triangle { <-34,4,-5>, <-36,4,-7>, <-36,8,-7> }
		triangle { <-36,8,7>, <-34,8,5>, <-34,4,5> }
		triangle { <-34,4,5>, <-36,4,7>, <-36,8,7> }
		triangle { <-34,8,-5>, <-34,4,-5>, <-34,4,5> }
		triangle { <-34,4,5>, <-34,8,5>, <-34,8,-5> }
		triangle { <-34,4,-5>, <-34,4,-10>, <-36,4,-10> }
		triangle { <-36,4,-10>, <-36,4,-7>, <-34,4,-5> }
		triangle { <-34,4,5>, <-34,4,10>, <-36,4,10> }
		triangle { <-36,4,10>, <-36,4,7>, <-34,4,5> }
		triangle { <-40,8,18>, <-40,8,4>, <-36,8,4> }
		triangle { <-36,8,4>, <-36,8,18>, <-40,8,18> }
		triangle { <-36,8,7>, <-36,8,-7>, <-34,8,-5> }
		triangle { <-34,8,-5>, <-34,8,5>, <-36,8,7> }
		triangle { <-40,8,-20>, <-40,8,-4>, <-36,8,-4> }
		triangle { <-36,8,-4>, <-36,8,-18>, <-40,8,-20> }
// outer box side
		triangle { <-40,8,20>, <-40,8,4>, <-40,0,4> }
		triangle { <-40,0,4>, <-40,0,20>, <-40,8,20> }
		triangle { <-40,8,4>, <-36,8,4>, <-36,0,4> }
		triangle { <-36,0,4>, <-40,0,4>, <-40,8,4> }
		triangle { <-36,8,4>, <-36,8,-4>, <-36,0,-4> }
		triangle { <-36,0,-4>, <-36,0,4>, <-36,8,4> }
		triangle { <-36,8,-4>, <-40,8,-4>, <-40,0,-4> }
		triangle { <-40,0,-4>, <-36,0,-4>, <-36,8,-4> }
		triangle { <-40,8,-4>, <-40,8,-20>, <-40,0,-20> }
		triangle { <-40,0,-20>, <-40,0,-4>, <-40,8,-4> }
// outer box top
		triangle { <-40,0,-20>, <-26,0,-20>, <-26,0,-4> }
		triangle { <-26,0,-4>, <-40,0,-4>, <-40,0,-20> }
		triangle { <-36,0,-4>, <-26,0,-4>, <-26,0,4> }
		triangle { <-26,0,4>, <-36,0,4>, <-36,0,-4> }
		triangle { <-40,0,20>, <-26,0,20>, <-26,0,4> }
		triangle { <-26,0,4>, <-40,0,4>, <-40,0,20> }
	}
	object { _1_dash_4ndis_dot_dat matrix <0,3.5,0,1,0,0,0,0,3.5,38,-6,-10.5> }
	object { _1_dash_4ndis_dot_dat matrix <1,3.5,0,1,0,0,0,0,3.5,38,-6,-10.5> }
	object { _1_dash_4cyls2_dot_dat matrix <0,-3.5,0,1,0,0,0,0,3.5,38,-6,-10.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,3.5,0,1,0,0,0,0,-3.5,38,-6,0.5> }
	object { _1_dash_4ndis_dot_dat matrix <1,3.5,0,1,0,0,0,0,-3.5,38,-6,0.5> }
	object { _1_dash_4cyls2_dot_dat matrix <0,-3.5,0,1,0,0,0,0,-3.5,38,-6,0.5> }
// 
	mesh {
		triangle { <38,-6,-3>, <38,-6,-7>, <39,-2.5,-7> }
		triangle { <39,-2.5,-7>, <39,-2.5,-3>, <38,-6,-3> }
		triangle { <39,-2.5,-14>, <39,-2.5,4>, <39,0,4> }
		triangle { <39,0,4>, <39,0,-14>, <39,-2.5,-14> }
// 
	}
	object { _1_dash_4ndis_dot_dat matrix <0,3.5,0,1,0,0,0,0,-3.5,38,-6,-10.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,3.5,0,1,0,0,0,0,-3.5,39,-6,-10.5> }
	object { _1_dash_4cyli_dot_dat matrix <0,3.5,0,1,0,0,0,0,-3.5,38,-6,-10.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,3.5,0,1,0,0,0,0,3.5,38,-6,0.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,3.5,0,1,0,0,0,0,3.5,39,-6,0.5> }
	object { _1_dash_4cyli_dot_dat matrix <0,3.5,0,1,0,0,0,0,3.5,38,-6,0.5> }
	mesh {
		triangle { <38,-6,-3>, <37.5,-6,-4>, <37.5,-6,-6> }
		triangle { <37.5,-6,-6>, <38,-6,-7>, <38,-6,-3> }
		triangle { <37.5,-6,-6>, <37.5,-6,-5>, <37.5,-7.5,-5> }
		triangle { <37.5,-7.5,-5>, <37.5,-7.5,-6>, <37.5,-6,-6> }
// 
	}
}
#end

#declare _2_dash_4cyli_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open clipped_by { box { <-2,-1,0>,<2,2,2> } } }

#declare _2_dash_4disc_dot_dat = #if (version >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 1
		clipped_by { box { <-2,-1,0>, <2,1,2> } }
	}
#else
	cylinder {
		<0,-0.001,0>, <0,0.001,0>, 1
		clipped_by { box { <-2,-1,0>, <2,1,2> } }
	}
#end

#declare _1_dash_4disc_dot_dat = #if (version >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 1
		clipped_by { box { <0,-1,0>, <2,1,2> } }
	}
#else
	cylinder {
		<0,-0.001,0>, <0,0.001,0>, 1
		clipped_by { box { <0,-1,0>, <2,1,2> } }
	}
#end

#declare _880_dot_dat = #if (QUAL = 0) box { <-59,-4,-20>, <40,30,20> } #else union {
// Electric Light Sensor Top
// Name: 880.dat
// Author: John VanZwieten
// Official LCad update 99-05
// wire stump
	mesh {
		triangle { <-36,24,-3>, <-36,24,3>, <-59,24,3> }
		triangle { <-59,24,3>, <-59,24,-3>, <-36,24,-3> }
		triangle { <-36,24,-3>, <-59,24,-3>, <-59,21.5,-3> }
		triangle { <-59,21.5,-3>, <-36,21.5,-3>, <-36,24,-3> }
		triangle { <-36,24,3>, <-59,24,3>, <-59,21.5,3> }
		triangle { <-59,21.5,3>, <-36,21.5,3>, <-36,24,3> }
		triangle { <-36,21.5,-3>, <-36,21.5,3>, <-59,21.5,3> }
		triangle { <-59,21.5,3>, <-59,21.5,-3>, <-36,21.5,-3> }
		triangle { <-59,24,-3>, <-59,24,3>, <-59,21.5,3> }
		triangle { <-59,21.5,3>, <-59,21.5,-3>, <-59,24,-3> }
// inner box bottom
// inner box side
// inner box top
// inner box side
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-36,24,-16>, <-24,24,-16>, <-24,4,-16> }
		triangle { <-24,4,-16>, <-36,4,-16>, <-36,24,-16> }
		triangle { <-24,24,16>, <-36,24,16>, <-36,4,16> }
		triangle { <-36,4,16>, <-24,4,16>, <-24,24,16> }
		triangle { <-36,24,16>, <-36,24,10>, <-36,4,10> }
		triangle { <-36,4,10>, <-36,4,16>, <-36,24,16> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,20,0,0,0,-6,-30,4,10> }
	object { _2_dash_4cyli_dot_dat matrix <0,0,-4,0,20,0,4,0,0,-30,4,0> }
	object { _1_dash_4cyli_dot_dat matrix <0,0,6,0,20,0,-6,0,0,-30,4,-10> }
	mesh {
		triangle { <-36,24,-10>, <-36,24,-16>, <-36,4,-16> }
		triangle { <-36,4,-16>, <-36,4,-10>, <-36,24,-10> }
// inner box top
		triangle { <-36,4,16>, <-36,4,10>, <-24,4,10> }
		triangle { <-24,4,10>, <-24,4,16>, <-36,4,16> }
	}
	object { _1_dash_4disc_dot_dat matrix <-6,0,0,0,1,0,0,0,-6,-30,4,10> }
	mesh {
		triangle { <-30,4,10>, <-30,4,4>, <-24,4,4> }
		triangle { <-24,4,4>, <-24,4,10>, <-30,4,10> }
	}
	object { _1_dash_4ndis_dot_dat matrix <4,0,0,0,1,0,0,0,4,-30,4,0> }
	mesh {
		triangle { <-26,4,4>, <-26,4,-4>, <-24,4,-4> }
		triangle { <-24,4,-4>, <-24,4,4>, <-26,4,4> }
	}
	object { _1_dash_4ndis_dot_dat matrix <0,0,-4,0,1,0,4,0,0,-30,4,0> }
	mesh {
		triangle { <-30,4,-4>, <-30,4,-10>, <-24,4,-10> }
		triangle { <-24,4,-10>, <-24,4,-4>, <-30,4,-4> }
	}
	object { _1_dash_4disc_dot_dat matrix <0,0,6,0,1,0,-6,0,0,-30,4,-10> }
	mesh {
		triangle { <-36,4,-10>, <-36,4,-16>, <-24,4,-16> }
		triangle { <-24,4,-16>, <-24,4,-10>, <-36,4,-10> }
// outer box bottom
// outer box side
// outer box top
// inner+outer box bottom
		triangle { <-40,24,20>, <-40,24,4>, <-36,24,4> }
		triangle { <-36,24,4>, <-36,24,16>, <-40,24,20> }
	}
	object { _1_dash_4ndis_dot_dat matrix <-6,0,0,0,1,0,0,0,-6,-30,24,10> }
	mesh {
		triangle { <-36,24,4>, <-36,24,-4>, <-30,24,-4> }
		triangle { <-30,24,-4>, <-30,24,4>, <-36,24,4> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,0,-4,0,1,0,4,0,0,-30,24,0> }
	object { _1_dash_4ndis_dot_dat matrix <0,0,6,0,1,0,-6,0,0,-30,24,-10> }
	mesh {
		triangle { <-40,24,-20>, <-40,24,-4>, <-36,24,-4> }
		triangle { <-36,24,-4>, <-36,24,-16>, <-40,24,-20> }
// outer box side
		triangle { <-40,24,20>, <-40,24,4>, <-40,0,4> }
		triangle { <-40,0,4>, <-40,0,20>, <-40,24,20> }
		triangle { <-40,24,4>, <-36,24,4>, <-36,0,4> }
		triangle { <-36,0,4>, <-40,0,4>, <-40,24,4> }
		triangle { <-36,24,4>, <-36,24,-4>, <-36,0,-4> }
		triangle { <-36,0,-4>, <-36,0,4>, <-36,24,4> }
		triangle { <-36,24,-4>, <-40,24,-4>, <-40,0,-4> }
		triangle { <-40,0,-4>, <-36,0,-4>, <-36,24,-4> }
		triangle { <-40,24,-4>, <-40,24,-20>, <-40,0,-20> }
		triangle { <-40,0,-20>, <-40,0,-4>, <-40,24,-4> }
// outer box top
		triangle { <-40,0,-20>, <-20,0,-20>, <-20,0,-4> }
		triangle { <-20,0,-4>, <-40,0,-4>, <-40,0,-20> }
		triangle { <-36,0,-4>, <-20,0,-4>, <-20,0,4> }
		triangle { <-20,0,4>, <-36,0,4>, <-36,0,-4> }
		triangle { <-40,0,20>, <-20,0,20>, <-20,0,4> }
		triangle { <-20,0,4>, <-40,0,4>, <-40,0,20> }
// Brick  2 x  4
		triangle { <40,24,20>, <36,24,16>, <-36,24,16> }
		triangle { <-36,24,16>, <-40,24,20>, <40,24,20> }
		triangle { <-40,24,-20>, <-36,24,-16>, <36,24,-16> }
		triangle { <36,24,-16>, <40,24,-20>, <-40,24,-20> }
		triangle { <40,24,-20>, <36,24,-16>, <38,24,-15> }
		triangle { <38,24,-15>, <40,24,-15>, <40,24,-20> }
		triangle { <40,24,5>, <38,24,5>, <36,24,16> }
		triangle { <36,24,16>, <40,24,20>, <40,24,5> }
		triangle { <40,0,20>, <40,0,-20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-20,0,20>, <40,0,20> }
		triangle { <40,0,20>, <40,24,20>, <-40,24,20> }
		triangle { <-40,24,20>, <-40,0,20>, <40,0,20> }
		triangle { <-40,0,-20>, <-40,24,-20>, <40,24,-20> }
		triangle { <40,24,-20>, <40,0,-20>, <-40,0,-20> }
		triangle { <40,0,-20>, <40,24,-20>, <40,24,-15> }
		triangle { <40,24,-15>, <40,0,-15>, <40,0,-20> }
		triangle { <40,0,5>, <40,24,5>, <40,24,20> }
		triangle { <40,24,20>, <40,0,20>, <40,0,5> }
		triangle { <40,0,-15>, <40,13,-15>, <40,13,5> }
		triangle { <40,13,5>, <40,0,5>, <40,0,-15> }
	}
	object { _1_dash_4ndis_dot_dat matrix <0,0,4.5,-1,0,0,0,-4.5,0,40,17.5,0.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,-4.5,0,-1,0,0,0,0,-4.5,40,17.5,-10.5> }
	object { _1_dash_4cyli_dot_dat matrix <0,0,4.5,-1,0,0,0,-4.5,0,40,17.5,0.5> }
	object { _1_dash_4cyli_dot_dat matrix <0,-4.5,0,-1,0,0,0,0,-4.5,40,17.5,-10.5> }
	mesh {
		triangle { <40,17.5,5>, <40,24,5>, <39,24,5> }
		triangle { <39,24,5>, <39,17.5,5>, <40,17.5,5> }
		triangle { <40,17.5,-15>, <40,24,-15>, <39,24,-15> }
		triangle { <39,24,-15>, <39,17.5,-15>, <40,17.5,-15> }
		triangle { <39,13,5>, <39,13,4>, <39,24,4> }
		triangle { <39,24,4>, <39,24,5>, <39,13,5> }
		triangle { <39,13,-15>, <39,13,-14>, <39,24,-14> }
		triangle { <39,24,-14>, <39,24,-15>, <39,13,-15> }
		triangle { <39,13,4>, <39,14,4>, <39,14,-14> }
		triangle { <39,14,-14>, <39,13,-14>, <39,13,4> }
		triangle { <39,24,-14>, <38,24,-14>, <38,17.5,-14> }
		triangle { <38,17.5,-14>, <39,17.5,-14>, <39,24,-14> }
		triangle { <39,24,4>, <38,24,4>, <38,17.5,4> }
		triangle { <38,17.5,4>, <39,17.5,4>, <39,24,4> }
		triangle { <39,24,-14>, <38,24,-14>, <38,24,-15> }
		triangle { <38,24,-15>, <39,24,-15>, <39,24,-14> }
		triangle { <39,24,4>, <38,24,4>, <38,24,5> }
		triangle { <38,24,5>, <39,24,5>, <39,24,4> }
	}
	object { _1_dash_4ndis_dot_dat matrix <0,0,3.5,-1,0,0,0,-3.5,0,39,17.5,0.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,-3.5,0,-1,0,0,0,0,-3.5,39,17.5,-10.5> }
	object { _1_dash_4cyli_dot_dat matrix <0,0,3.5,-1,0,0,0,-3.5,0,39,17.5,0.5> }
	object { _1_dash_4cyli_dot_dat matrix <0,-3.5,0,-1,0,0,0,0,-3.5,39,17.5,-10.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,-3.5,0,1,0,0,0,0,3.5,38,17.5,-10.5> }
	object { _1_dash_4ndis_dot_dat matrix <1,-3.5,0,1,0,0,0,0,3.5,38,17.5,-10.5> }
	object { _1_dash_4cyls2_dot_dat matrix <0,3.5,0,1,0,0,0,0,3.5,38,17.5,-10.5> }
	object { _1_dash_4ndis_dot_dat matrix <0,-3.5,0,1,0,0,0,0,-3.5,38,17.5,0.5> }
	object { _1_dash_4ndis_dot_dat matrix <1,-3.5,0,1,0,0,0,0,-3.5,38,17.5,0.5> }
	object { _1_dash_4cyls2_dot_dat matrix <0,3.5,0,1,0,0,0,0,-3.5,38,17.5,0.5> }
	mesh {
		triangle { <38,17.5,-7>, <38,17.5,-3>, <38,14,-3> }
		triangle { <38,14,-3>, <38,14,-7>, <38,17.5,-7> }
// 
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
	#end
	object { rect_dot_dat matrix <-6,0,0,0,0,1,0,3,0,-20,27,18> }
	object { rect_dot_dat matrix <-6,0,0,0,0,1,0,2,0,-20,26,16> }
	object { rect_dot_dat matrix <-6,0,0,0,-1,0,0,0,1,-20,28,15> }
	mesh {
		triangle { <-26,28,14>, <-26,30,18>, <-14,30,18> }
		triangle { <-14,30,18>, <-14,28,14>, <-26,28,14> }
		triangle { <-26,28,14>, <-26,30,18>, <-26,28,18> }
		triangle { <-14,28,14>, <-14,30,18>, <-14,28,18> }
		triangle { <-26,28,18>, <-26,24,18>, <-26,24,16> }
		triangle { <-26,24,16>, <-26,28,16>, <-26,28,18> }
		triangle { <-14,28,18>, <-14,24,18>, <-14,24,16> }
		triangle { <-14,24,16>, <-14,28,16>, <-14,28,18> }
// 
	}
	object { rect_dot_dat matrix <-6,0,0,0,0,1,0,3,0,0,27,18> }
	object { rect_dot_dat matrix <-6,0,0,0,0,1,0,2,0,0,26,16> }
	object { rect_dot_dat matrix <-6,0,0,0,-1,0,0,0,1,0,28,15> }
	mesh {
		triangle { <-6,28,14>, <-6,30,18>, <6,30,18> }
		triangle { <6,30,18>, <6,28,14>, <-6,28,14> }
		triangle { <-6,28,14>, <-6,30,18>, <-6,28,18> }
		triangle { <6,28,14>, <6,30,18>, <6,28,18> }
		triangle { <-6,28,18>, <-6,24,18>, <-6,24,16> }
		triangle { <-6,24,16>, <-6,28,16>, <-6,28,18> }
		triangle { <6,28,18>, <6,24,18>, <6,24,16> }
		triangle { <6,24,16>, <6,28,16>, <6,28,18> }
// 
	}
	object { rect_dot_dat matrix <-6,0,0,0,0,1,0,3,0,20,27,18> }
	object { rect_dot_dat matrix <-6,0,0,0,0,1,0,2,0,20,26,16> }
	object { rect_dot_dat matrix <-6,0,0,0,-1,0,0,0,1,20,28,15> }
	mesh {
		triangle { <14,28,14>, <14,30,18>, <26,30,18> }
		triangle { <26,30,18>, <26,28,14>, <14,28,14> }
		triangle { <14,28,14>, <14,30,18>, <14,28,18> }
		triangle { <26,28,14>, <26,30,18>, <26,28,18> }
		triangle { <14,28,18>, <14,24,18>, <14,24,16> }
		triangle { <14,24,16>, <14,28,16>, <14,28,18> }
		triangle { <26,28,18>, <26,24,18>, <26,24,16> }
		triangle { <26,24,16>, <26,28,16>, <26,28,18> }
// 
	}
	object { rect_dot_dat matrix <6,0,0,0,0,-1,0,3,0,20,27,-18> }
	object { rect_dot_dat matrix <6,0,0,0,0,-1,0,2,0,20,26,-16> }
	object { rect_dot_dat matrix <6,0,0,0,-1,0,0,0,-1,20,28,-15> }
	mesh {
		triangle { <26,28,-14>, <26,30,-18>, <14,30,-18> }
		triangle { <14,30,-18>, <14,28,-14>, <26,28,-14> }
		triangle { <26,28,-14>, <26,30,-18>, <26,28,-18> }
		triangle { <14,28,-14>, <14,30,-18>, <14,28,-18> }
		triangle { <26,28,-18>, <26,24,-18>, <26,24,-16> }
		triangle { <26,24,-16>, <26,28,-16>, <26,28,-18> }
		triangle { <14,28,-18>, <14,24,-18>, <14,24,-16> }
		triangle { <14,24,-16>, <14,28,-16>, <14,28,-18> }
// 
	}
	object { rect_dot_dat matrix <6,0,0,0,0,-1,0,3,0,0,27,-18> }
	object { rect_dot_dat matrix <6,0,0,0,0,-1,0,2,0,0,26,-16> }
	object { rect_dot_dat matrix <6,0,0,0,-1,0,0,0,-1,0,28,-15> }
	mesh {
		triangle { <6,28,-14>, <6,30,-18>, <-6,30,-18> }
		triangle { <-6,30,-18>, <-6,28,-14>, <6,28,-14> }
		triangle { <6,28,-14>, <6,30,-18>, <6,28,-18> }
		triangle { <-6,28,-14>, <-6,30,-18>, <-6,28,-18> }
		triangle { <6,28,-18>, <6,24,-18>, <6,24,-16> }
		triangle { <6,24,-16>, <6,28,-16>, <6,28,-18> }
		triangle { <-6,28,-18>, <-6,24,-18>, <-6,24,-16> }
		triangle { <-6,24,-16>, <-6,28,-16>, <-6,28,-18> }
// 
	}
	object { rect_dot_dat matrix <6,0,0,0,0,-1,0,3,0,-20,27,-18> }
	object { rect_dot_dat matrix <6,0,0,0,0,-1,0,2,0,-20,26,-16> }
	object { rect_dot_dat matrix <6,0,0,0,-1,0,0,0,-1,-20,28,-15> }
	mesh {
		triangle { <-14,28,-14>, <-14,30,-18>, <-26,30,-18> }
		triangle { <-26,30,-18>, <-26,28,-14>, <-14,28,-14> }
		triangle { <-14,28,-14>, <-14,30,-18>, <-14,28,-18> }
		triangle { <-26,28,-14>, <-26,30,-18>, <-26,28,-18> }
		triangle { <-14,28,-18>, <-14,24,-18>, <-14,24,-16> }
		triangle { <-14,24,-16>, <-14,28,-16>, <-14,28,-18> }
		triangle { <-26,28,-18>, <-26,24,-18>, <-26,24,-16> }
		triangle { <-26,24,-16>, <-26,28,-16>, <-26,28,-18> }
// 
	}
}
#end

#ifndef (Color36)
#declare Color36 = #if (version >= 3.1) material { #end texture {
	#if (QUAL > 1) lg_clear_red #else lg_red #end
} #if (version >= 3.1) } #end
#declare Color36_slope = #if (version >= 3.1) material { #end texture {
	#if (QUAL > 1) lg_clear_red #else lg_red #end
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare _881_dot_dat = #if (QUAL = 0) box { <35.5,-10,-14.5>, <39.5,-2,4.5> } #else union {
// Electric Light Sensor Glass
// Name: 881.dat
// Author: John VanZwieten
// Official LCad update 99-05
	object { _4_dash_8sphe_dot_dat matrix <0,-4,0,4,0,0,0,0,4,35.5,-6,-10.5> #if (version >= 3.1) material #else texture #end { Color36 } }
	object { _4_dash_8sphe_dot_dat matrix <0,-4,0,4,0,0,0,0,4,35.5,-6,0.5> #if (version >= 3.1) material #else texture #end { Color47 } }
// 
}
#end

#declare _2982c01_dot_dat = #if (QUAL = 0) box { <-59,-28,-20>, <40,8,20> } #else union {
// Electric Light Sensor (Complete Assembly Shortcut)
// Name: 2982c01.dat
// Author: John VanZwieten
// Official LCad update 99-05
	object { _2982_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (version >= 3.1) material #else texture #end { Color8 } }
	object { _880_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,-24,0> }
	object { _881_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
// 
}
#end

#declare axle_dot_dat = intersection {
	cylinder { <0,0,0>, <0,1,0>, 6 }
	union {
		box { <-7,-1,-2>, <7,2,2> }
		box { <-2,-1,-7>, <2,2,7> }
	}
}

#declare _2837_dot_dat = #if (QUAL = 0) box { <-13,-13,-20>, <13,13,2> } #else union {
// ~Electric Technic Motor  9V Shaft
// Name: 2837.dat
// Author: James Jessiman
// Official LCad update 99-03
	object { axle_dot_dat matrix <1,0,0,0,0,-20,0,1,0,0,0,0> }
	object { _4_dash_4disc_dot_dat matrix <13,0,0,0,0,1,0,13,0,0,0,2> }
	object { _4_dash_4disc_dot_dat matrix <13,0,0,0,0,1,0,13,0,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <13,0,0,0,0,2,0,13,0,0,0,0> }
// 
}
#end

#declare stud3_dot_dat = cylinder { <0,0,0>, <0,-4,0>, 4 }

#declare _2_dash_4ndis_dot_dat = #if (version >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 2, 1
		clipped_by { box { <-1,-1,0>, <1,1,1> } }
	}
#else
	difference {
		box { <-1,-0.001,0>, <1,0.001,1> }
		cylinder { <0,-1,0>, <0,1,0>, 1 }
	}
#end

#declare box5_dot_dat = object {
// Box 5 (five faces)
// Name: BOX5.dat
// Author: James Jessiman
// Original LDraw Primitive - LDraw beta 0.27 Archive
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <-1,1,-1>, <-1,0,-1>, <1,0,-1> }
		triangle { <1,0,-1>, <1,1,-1>, <-1,1,-1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
// 
	}
}

#declare _2838_dot_dat = #if (QUAL = 0) box { <-40,26,-50>, <40,56,50> } #else union {
// ~Electric Technic Motor  9V Base
// Name: 2838.dat
// Author: James Jessiman
// Official LCad update 99-03
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,42,12,52,0> #if (version >= 3.1) material #else texture #end { Color14 } }
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,42,-12,52,0> #if (version >= 3.1) material #else texture #end { Color14 } }
	object { rect_dot_dat matrix <0,2,0,1,0,0,0,0,42,16,54,0> #if (version >= 3.1) material #else texture #end { Color14 } }
	object { rect_dot_dat matrix <0,2,0,1,0,0,0,0,42,-16,54,0> #if (version >= 3.1) material #else texture #end { Color14 } }
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,30,52,30> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-30,52,30> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,30,52,10> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-30,52,10> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,30,52,-10> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-30,52,-10> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,30,52,-30> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-30,52,-30> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,52,30> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,52,10> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,52,-10> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,52,-30> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,4,0,52,42> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,0,52,20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,0,52,0> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,0,52,-20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,4,0,52,-42> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,12,52,30> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,-12,52,30> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,12,52,10> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,-12,52,10> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,12,52,-10> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,-12,52,-10> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,12,52,-30> }
	object { box5_dot_dat matrix <4,0,0,0,4,0,0,0,2,-12,52,-30> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,7,18,52,39> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,7,-18,52,39> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,8,18,52,20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,8,-18,52,20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,8,18,52,0> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,8,-18,52,0> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,8,18,52,-20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,8,-18,52,-20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,7,18,52,-39> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,7,-18,52,-39> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,22,52,40> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,-22,52,40> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,22,52,20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,-22,52,20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,22,52,0> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,-22,52,0> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,22,52,-20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,-22,52,-20> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,22,52,-40> }
	object { box5_dot_dat matrix <2,0,0,0,4,0,0,0,2,-22,52,-40> }
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,46,0,56,0> }
	mesh {
		triangle { <40,56,50>, <36,56,46>, <-36,56,46> }
		triangle { <-36,56,46>, <-40,56,50>, <40,56,50> }
		triangle { <-40,56,50>, <-36,56,46>, <-36,56,-46> }
		triangle { <-36,56,-46>, <-40,56,-50>, <-40,56,50> }
		triangle { <-40,56,-50>, <-36,56,-46>, <36,56,-46> }
		triangle { <36,56,-46>, <40,56,-50>, <-40,56,-50> }
		triangle { <40,56,-50>, <36,56,-46>, <36,56,46> }
		triangle { <36,56,46>, <40,56,50>, <40,56,-50> }
	}
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,1,12,26,-47> }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,1,-12,26,-47> }
	mesh {
		triangle { <40,48,50>, <-40,48,50>, <-40,48,-50> }
		triangle { <-40,48,-50>, <40,48,-50>, <40,48,50> }
		triangle { <-13,33,-50>, <-10.61,36.61,-50>, <-10.61,36.61,-48> }
		triangle { <-10.61,36.61,-48>, <-13,33,-48>, <-13,33,-50> }
		triangle { <-10.61,36.61,-50>, <-5.74,39.86,-50>, <-5.74,39.86,-48> }
		triangle { <-5.74,39.86,-48>, <-10.61,36.61,-48>, <-10.61,36.61,-50> }
		triangle { <-5.74,39.86,-50>, <0,41,-50>, <0,41,-48> }
		triangle { <0,41,-48>, <-5.74,39.86,-48>, <-5.74,39.86,-50> }
		triangle { <0,41,-50>, <5.74,39.86,-50>, <5.74,39.86,-48> }
		triangle { <5.74,39.86,-48>, <0,41,-48>, <0,41,-50> }
		triangle { <5.74,39.86,-50>, <10.61,36.61,-50>, <10.61,36.61,-48> }
		triangle { <10.61,36.61,-48>, <5.74,39.86,-48>, <5.74,39.86,-50> }
		triangle { <10.61,36.61,-50>, <13,33,-50>, <13,33,-48> }
		triangle { <13,33,-48>, <10.61,36.61,-48>, <10.61,36.61,-50> }
	}
	object { _2_dash_4cyli_dot_dat matrix <11,0,0,0,0,2,0,11,0,0,26,-48> }
	mesh {
		triangle { <40,56,50>, <40,48,50>, <-40,48,50> }
		triangle { <-40,48,50>, <-40,56,50>, <40,56,50> }
	}
	object { _2_dash_4ndis_dot_dat matrix <11,0,0,0,0,1,0,11,0,0,26,-46> }
	mesh {
		triangle { <13,26,-46>, <11,26,-46>, <11,37,-46> }
		triangle { <11,37,-46>, <13,48,-46>, <13,26,-46> }
		triangle { <-13,26,-46>, <-11,26,-46>, <-11,37,-46> }
		triangle { <-11,37,-46>, <-13,48,-46>, <-13,26,-46> }
		triangle { <13,48,-46>, <11,37,-46>, <-11,37,-46> }
		triangle { <-11,37,-46>, <-13,48,-46>, <13,48,-46> }
	}
	object { _2_dash_4ndis_dot_dat matrix <11,0,0,0,0,1,0,11,0,0,26,-48> }
	mesh {
		triangle { <13,26,-48>, <11,26,-48>, <11,37,-48> }
		triangle { <11,37,-48>, <13,48,-48>, <13,26,-48> }
		triangle { <-13,26,-48>, <-11,26,-48>, <-11,37,-48> }
		triangle { <-11,37,-48>, <-13,48,-48>, <-13,26,-48> }
		triangle { <13,48,-48>, <11,37,-48>, <-11,37,-48> }
		triangle { <-11,37,-48>, <-13,48,-48>, <13,48,-48> }
		triangle { <-13,33,-50>, <-10.61,36.61,-50>, <-13,48,-50> }
		triangle { <-10.61,36.61,-50>, <-5.74,39.86,-50>, <-13,48,-50> }
		triangle { <-5.74,39.86,-50>, <0,41,-50>, <-13,48,-50> }
		triangle { <-13,48,-50>, <0,41,-50>, <13,48,-50> }
		triangle { <0,41,-50>, <5.74,39.86,-50>, <13,48,-50> }
		triangle { <5.74,39.86,-50>, <10.61,36.61,-50>, <13,48,-50> }
		triangle { <10.61,36.61,-50>, <13,33,-50>, <13,48,-50> }
		triangle { <40,56,-50>, <40,48,-50>, <-40,48,-50> }
		triangle { <-40,48,-50>, <-40,56,-50>, <40,56,-50> }
		triangle { <40,56,50>, <40,48,50>, <40,48,-50> }
		triangle { <40,48,-50>, <40,56,-50>, <40,56,50> }
		triangle { <13,26,-46>, <13,26,-48>, <13,33,-48> }
		triangle { <13,33,-48>, <13,48,-46>, <13,26,-46> }
		triangle { <13,48,-46>, <13,33,-48>, <13,33,-50> }
		triangle { <13,33,-50>, <13,48,-50>, <13,48,-46> }
		triangle { <-13,26,-46>, <-13,26,-48>, <-13,33,-48> }
		triangle { <-13,33,-48>, <-13,48,-46>, <-13,26,-46> }
		triangle { <-13,48,-46>, <-13,33,-48>, <-13,33,-50> }
		triangle { <-13,33,-50>, <-13,48,-50>, <-13,48,-46> }
		triangle { <-40,56,50>, <-40,48,50>, <-40,48,-50> }
		triangle { <-40,48,-50>, <-40,56,-50>, <-40,56,50> }
// 
	}
}
#end

#declare stud_dot_dat = object {
	lg_knob
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}

#declare _2839_dot_dat = #if (QUAL = 0) box { <-40,-4,-50>, <40,48,50> } #else union {
// ~Electric Technic Motor  9V Top
// Name: 2839.dat
// Author: James Jessiman
// Official LCad update 99-03
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,1,12,26,-47> }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,1,-12,26,-47> }
	mesh {
		triangle { <38,48,48>, <36,48,46>, <-36,48,46> }
		triangle { <-36,48,46>, <-38,48,48>, <38,48,48> }
		triangle { <38,48,48>, <36,48,46>, <36,48,-46> }
		triangle { <36,48,-46>, <38,48,-48>, <38,48,48> }
		triangle { <-38,48,48>, <-36,48,46>, <-36,48,-46> }
		triangle { <-36,48,-46>, <-38,48,-48>, <-38,48,48> }
		triangle { <38,48,-48>, <36,48,-46>, <13,48,-46> }
		triangle { <13,48,-46>, <13,48,-48>, <38,48,-48> }
		triangle { <-38,48,-48>, <-36,48,-46>, <-13,48,-46> }
		triangle { <-13,48,-46>, <-13,48,-48>, <-38,48,-48> }
		triangle { <40,46,50>, <38,46,48>, <-38,46,48> }
		triangle { <-38,46,48>, <-40,46,50>, <40,46,50> }
		triangle { <40,46,50>, <38,46,48>, <38,46,-48> }
		triangle { <38,46,-48>, <40,46,-50>, <40,46,50> }
		triangle { <-40,46,50>, <-38,46,48>, <-38,46,-48> }
		triangle { <-38,46,-48>, <-40,46,-50>, <-40,46,50> }
		triangle { <40,46,-50>, <38,46,-48>, <15,46,-48> }
		triangle { <15,46,-48>, <15,46,-50>, <40,46,-50> }
		triangle { <-40,46,-50>, <-38,46,-48>, <-15,46,-48> }
		triangle { <-15,46,-48>, <-15,46,-50>, <-40,46,-50> }
		triangle { <40,43,27>, <40,43,-50>, <38,43,-50> }
		triangle { <38,43,-50>, <38,43,27>, <40,43,27> }
		triangle { <-40,43,27>, <-40,43,-50>, <-38,43,-50> }
		triangle { <-38,43,-50>, <-38,43,27>, <-40,43,27> }
		triangle { <40,37,27>, <40,37,-50>, <38,37,-50> }
		triangle { <38,37,-50>, <38,37,27>, <40,37,27> }
		triangle { <-40,37,27>, <-40,37,-50>, <-38,37,-50> }
		triangle { <-38,37,-50>, <-38,37,27>, <-40,37,27> }
		triangle { <40,33,27>, <40,33,-50>, <38,33,-50> }
		triangle { <38,33,-50>, <38,33,27>, <40,33,27> }
		triangle { <-40,33,27>, <-40,33,-50>, <-38,33,-50> }
		triangle { <-38,33,-50>, <-38,33,27>, <-40,33,27> }
		triangle { <40,27,27>, <40,27,-50>, <38,27,-50> }
		triangle { <38,27,-50>, <38,27,27>, <40,27,27> }
		triangle { <-40,27,27>, <-40,27,-50>, <-38,27,-50> }
		triangle { <-38,27,-50>, <-38,27,27>, <-40,27,27> }
		triangle { <40,23,27>, <40,23,-50>, <38,23,-50> }
		triangle { <38,23,-50>, <38,23,27>, <40,23,27> }
		triangle { <-40,23,27>, <-40,23,-50>, <-38,23,-50> }
		triangle { <-38,23,-50>, <-38,23,27>, <-40,23,27> }
		triangle { <40,17,27>, <40,17,-50>, <38,17,-50> }
		triangle { <38,17,-50>, <38,17,27>, <40,17,27> }
		triangle { <-40,17,27>, <-40,17,-50>, <-38,17,-50> }
		triangle { <-38,17,-50>, <-38,17,27>, <-40,17,27> }
		triangle { <40,13,27>, <40,13,-50>, <38,13,-50> }
		triangle { <38,13,-50>, <38,13,27>, <40,13,27> }
		triangle { <-40,13,27>, <-40,13,-50>, <-38,13,-50> }
		triangle { <-38,13,-50>, <-38,13,27>, <-40,13,27> }
		triangle { <40,7,27>, <40,7,-50>, <38,7,-50> }
		triangle { <38,7,-50>, <38,7,27>, <40,7,27> }
		triangle { <-40,7,27>, <-40,7,-50>, <-38,7,-50> }
		triangle { <-38,7,-50>, <-38,7,27>, <-40,7,27> }
	}
	object { _2_dash_4cyli_dot_dat matrix <11,0,0,0,0,2,0,-11,0,0,26,-48> }
	object { _2_dash_4cyli_dot_dat matrix <15,0,0,0,0,2,0,-15,0,0,26,-50> }
	mesh {
		triangle { <36,4,46>, <36,4,-46>, <-36,4,-46> }
		triangle { <-36,4,-46>, <-36,4,46>, <36,4,46> }
		triangle { <40,4,50>, <40,4,-50>, <36,0,-50> }
		triangle { <36,0,-50>, <36,0,50>, <40,4,50> }
		triangle { <-40,4,50>, <-40,4,-50>, <-36,0,-50> }
		triangle { <-36,0,-50>, <-36,0,50>, <-40,4,50> }
		triangle { <36,0,50>, <36,0,-50>, <-36,0,-50> }
		triangle { <-36,0,-50>, <-36,0,50>, <36,0,50> }
		triangle { <40,46,50>, <40,4,50>, <-40,4,50> }
		triangle { <-40,4,50>, <-40,46,50>, <40,46,50> }
		triangle { <40,4,50>, <36,0,50>, <-36,0,50> }
		triangle { <-36,0,50>, <-40,4,50>, <40,4,50> }
		triangle { <38,48,48>, <38,46,48>, <-38,46,48> }
		triangle { <-38,46,48>, <-38,48,48>, <38,48,48> }
		triangle { <36,48,46>, <36,4,46>, <-36,4,46> }
		triangle { <-36,4,46>, <-36,48,46>, <36,48,46> }
	}
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,-2,0,0,0,0,3,40,40,27> }
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,2,0,0,0,0,3,-40,40,27> }
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,-2,0,0,0,0,3,40,30,27> }
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,2,0,0,0,0,3,-40,30,27> }
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,-2,0,0,0,0,3,40,20,27> }
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,2,0,0,0,0,3,-40,20,27> }
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,-2,0,0,0,0,3,40,10,27> }
	object { _2_dash_4cyli_dot_dat matrix <0,3,0,2,0,0,0,0,3,-40,10,27> }
	object { _2_dash_4ndis_dot_dat matrix <11,0,0,0,0,1,0,-11,0,0,26,-46> }
	mesh {
		triangle { <36,48,-46>, <13,48,-46>, <13,26,-46> }
		triangle { <13,26,-46>, <36,4,-46>, <36,48,-46> }
		triangle { <-36,48,-46>, <-13,48,-46>, <-13,26,-46> }
		triangle { <-13,26,-46>, <-36,4,-46>, <-36,48,-46> }
		triangle { <36,4,-46>, <13,26,-46>, <11,26,-46> }
		triangle { <11,26,-46>, <11,15,-46>, <36,4,-46> }
		triangle { <-36,4,-46>, <-13,26,-46>, <-11,26,-46> }
		triangle { <-11,26,-46>, <-11,15,-46>, <-36,4,-46> }
		triangle { <36,4,-46>, <11,15,-46>, <-11,15,-46> }
		triangle { <-11,15,-46>, <-36,4,-46>, <36,4,-46> }
	}
	object { _2_dash_4ndis_dot_dat matrix <11,0,0,0,0,1,0,-11,0,0,26,-48> }
	mesh {
		triangle { <38,48,-48>, <38,46,-48>, <15,46,-48> }
		triangle { <15,46,-48>, <13,48,-48>, <38,48,-48> }
		triangle { <-38,48,-48>, <-38,46,-48>, <-15,46,-48> }
		triangle { <-15,46,-48>, <-13,48,-48>, <-38,48,-48> }
		triangle { <13,48,-48>, <15,46,-48>, <15,11,-48> }
		triangle { <15,11,-48>, <13,26,-48>, <13,48,-48> }
		triangle { <-13,48,-48>, <-15,46,-48>, <-15,11,-48> }
		triangle { <-15,11,-48>, <-13,26,-48>, <-13,48,-48> }
		triangle { <13,26,-48>, <15,11,-48>, <11,15,-48> }
		triangle { <11,15,-48>, <11,26,-48>, <13,26,-48> }
		triangle { <-13,26,-48>, <-15,11,-48>, <-11,15,-48> }
		triangle { <-11,15,-48>, <-11,26,-48>, <-13,26,-48> }
		triangle { <15,11,-48>, <11,15,-48>, <-11,15,-48> }
		triangle { <-11,15,-48>, <-15,11,-48>, <15,11,-48> }
	}
	object { _2_dash_4ndis_dot_dat matrix <15,0,0,0,0,1,0,-15,0,0,26,-50> }
	mesh {
		triangle { <40,46,-50>, <40,43,-50>, <38,43,-50> }
		triangle { <38,43,-50>, <15,46,-50>, <40,46,-50> }
		triangle { <-40,46,-50>, <-40,43,-50>, <-38,43,-50> }
		triangle { <-38,43,-50>, <-15,46,-50>, <-40,46,-50> }
		triangle { <40,37,-50>, <40,33,-50>, <38,33,-50> }
		triangle { <38,33,-50>, <38,37,-50>, <40,37,-50> }
		triangle { <-40,37,-50>, <-40,33,-50>, <-38,33,-50> }
		triangle { <-38,33,-50>, <-38,37,-50>, <-40,37,-50> }
		triangle { <40,27,-50>, <40,23,-50>, <38,23,-50> }
		triangle { <38,23,-50>, <38,27,-50>, <40,27,-50> }
		triangle { <-40,27,-50>, <-40,23,-50>, <-38,23,-50> }
		triangle { <-38,23,-50>, <-38,27,-50>, <-40,27,-50> }
		triangle { <40,17,-50>, <40,13,-50>, <38,13,-50> }
		triangle { <38,13,-50>, <38,17,-50>, <40,17,-50> }
		triangle { <-40,17,-50>, <-40,13,-50>, <-38,13,-50> }
		triangle { <-38,13,-50>, <-38,17,-50>, <-40,17,-50> }
		triangle { <40,7,-50>, <40,4,-50>, <36,0,-50> }
		triangle { <36,0,-50>, <38,7,-50>, <40,7,-50> }
		triangle { <-40,7,-50>, <-40,4,-50>, <-36,0,-50> }
		triangle { <-36,0,-50>, <-38,7,-50>, <-40,7,-50> }
		triangle { <38,43,-50>, <38,7,-50>, <15,11,-50> }
		triangle { <15,11,-50>, <15,46,-50>, <38,43,-50> }
		triangle { <-38,43,-50>, <-38,7,-50>, <-15,11,-50> }
		triangle { <-15,11,-50>, <-15,46,-50>, <-38,43,-50> }
		triangle { <38,7,-50>, <15,11,-50>, <-15,11,-50> }
		triangle { <-15,11,-50>, <-38,7,-50>, <38,7,-50> }
		triangle { <38,7,-50>, <36,0,-50>, <-36,0,-50> }
		triangle { <-36,0,-50>, <-38,7,-50>, <38,7,-50> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,40,40,27> }
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,40,30,27> }
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,40,20,27> }
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,40,10,27> }
	mesh {
		triangle { <40,46,50>, <40,43,30>, <40,43,-50> }
		triangle { <40,43,-50>, <40,46,-50>, <40,46,50> }
		triangle { <40,37,30>, <40,33,30>, <40,33,-50> }
		triangle { <40,33,-50>, <40,37,-50>, <40,37,30> }
		triangle { <40,27,30>, <40,23,30>, <40,23,-50> }
		triangle { <40,23,-50>, <40,27,-50>, <40,27,30> }
		triangle { <40,17,30>, <40,13,30>, <40,13,-50> }
		triangle { <40,13,-50>, <40,17,-50>, <40,17,30> }
		triangle { <40,7,30>, <40,4,50>, <40,4,-50> }
		triangle { <40,4,-50>, <40,7,-50>, <40,7,30> }
		triangle { <40,46,50>, <40,43,30>, <40,7,30> }
		triangle { <40,7,30>, <40,4,50>, <40,46,50> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,38,40,27> }
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,38,30,27> }
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,38,20,27> }
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,38,10,27> }
	mesh {
		triangle { <38,48,48>, <38,46,48>, <38,46,-48> }
		triangle { <38,46,-48>, <38,48,-48>, <38,48,48> }
		triangle { <38,43,27>, <38,37,27>, <38,37,-50> }
		triangle { <38,37,-50>, <38,43,-50>, <38,43,27> }
		triangle { <38,33,27>, <38,27,27>, <38,27,-50> }
		triangle { <38,27,-50>, <38,33,-50>, <38,33,27> }
		triangle { <38,23,27>, <38,17,27>, <38,17,-50> }
		triangle { <38,17,-50>, <38,23,-50>, <38,23,27> }
		triangle { <38,13,27>, <38,7,27>, <38,7,-50> }
		triangle { <38,7,-50>, <38,13,-50>, <38,13,27> }
		triangle { <36,48,46>, <36,4,46>, <36,4,-46> }
		triangle { <36,4,-46>, <36,48,-46>, <36,48,46> }
		triangle { <15,46,-48>, <15,26,-48>, <15,26,-50> }
		triangle { <15,26,-50>, <15,46,-50>, <15,46,-48> }
		triangle { <13,48,-46>, <13,26,-46>, <13,26,-48> }
		triangle { <13,26,-48>, <13,48,-48>, <13,48,-46> }
		triangle { <-13,48,-46>, <-13,26,-46>, <-13,26,-48> }
		triangle { <-13,26,-48>, <-13,48,-48>, <-13,48,-46> }
		triangle { <-15,46,-48>, <-15,26,-48>, <-15,26,-50> }
		triangle { <-15,26,-50>, <-15,46,-50>, <-15,46,-48> }
		triangle { <-36,48,46>, <-36,4,46>, <-36,4,-46> }
		triangle { <-36,4,-46>, <-36,48,-46>, <-36,48,46> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,-38,40,27> }
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,-38,30,27> }
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,-38,20,27> }
	object { _2_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,-38,10,27> }
	mesh {
		triangle { <-38,48,48>, <-38,46,48>, <-38,46,-48> }
		triangle { <-38,46,-48>, <-38,48,-48>, <-38,48,48> }
		triangle { <-38,43,27>, <-38,37,27>, <-38,37,-50> }
		triangle { <-38,37,-50>, <-38,43,-50>, <-38,43,27> }
		triangle { <-38,33,27>, <-38,27,27>, <-38,27,-50> }
		triangle { <-38,27,-50>, <-38,33,-50>, <-38,33,27> }
		triangle { <-38,23,27>, <-38,17,27>, <-38,17,-50> }
		triangle { <-38,17,-50>, <-38,23,-50>, <-38,23,27> }
		triangle { <-38,13,27>, <-38,7,27>, <-38,7,-50> }
		triangle { <-38,7,-50>, <-38,13,-50>, <-38,13,27> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,-40,40,27> }
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,-40,30,27> }
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,-40,20,27> }
	object { _2_dash_4ndis_dot_dat matrix <0,3,0,1,0,0,0,0,3,-40,10,27> }
	mesh {
		triangle { <-40,46,50>, <-40,43,30>, <-40,43,-50> }
		triangle { <-40,43,-50>, <-40,46,-50>, <-40,46,50> }
		triangle { <-40,37,30>, <-40,33,30>, <-40,33,-50> }
		triangle { <-40,33,-50>, <-40,37,-50>, <-40,37,30> }
		triangle { <-40,27,30>, <-40,23,30>, <-40,23,-50> }
		triangle { <-40,23,-50>, <-40,27,-50>, <-40,27,30> }
		triangle { <-40,17,30>, <-40,13,30>, <-40,13,-50> }
		triangle { <-40,13,-50>, <-40,17,-50>, <-40,17,30> }
		triangle { <-40,7,30>, <-40,4,50>, <-40,4,-50> }
		triangle { <-40,4,-50>, <-40,7,-50>, <-40,7,30> }
		triangle { <-40,46,50>, <-40,43,30>, <-40,7,30> }
		triangle { <-40,7,30>, <-40,4,50>, <-40,46,50> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-40> }
// 
	#end
}
#end

#declare _2838c01_dot_dat = #if (QUAL = 0) box { <-40,-4,-70>, <40,56,50> } #else union {
// Electric Technic Motor  9V
// Name: 2838c01.dat
// Author: James Jessiman
// Official LCad update 99-03
	object { _2837_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,26,-50> #if (version >= 3.1) material #else texture #end { Color0 } }
	object { _2838_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (version >= 3.1) material #else texture #end { Color8 } }
	object { _2839_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
// 
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_6215)
		#include "lg_6215.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _6215_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <40,24,20> } #else object {
// Brick  2 x  3 with Curved Top
	lg_6215
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _6215_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-20>, <40,24,20> } #else object {
// Brick  2 x  3 with Curved Top
	lg_6215_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _5306_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <40,16,20> } #else union {
// Electric Brick  2 x  2 x  2/3 with Wire End
// Name: 5306.dat
// Author: Manfred Moolhuysen
// Official LCad update 99-01
// *** Base Part ***
// X-shaped cavity
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,4,5,14,0> }
	mesh {
		triangle { <5,16,4>, <2,16,4>, <2,12,4> }
		triangle { <2,12,4>, <5,12,4>, <5,16,4> }
	}
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,1,2,14,5> }
	mesh {
		triangle { <2,16,6>, <-2,16,6>, <-2,12,6> }
		triangle { <-2,12,6>, <2,12,6>, <2,16,6> }
	}
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,1,-2,14,5> }
	mesh {
		triangle { <-2,16,4>, <-5,16,4>, <-5,12,4> }
		triangle { <-5,12,4>, <-2,12,4>, <-2,16,4> }
	}
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,4,-5,14,0> }
	mesh {
		triangle { <-5,16,-4>, <-2,16,-4>, <-2,12,-4> }
		triangle { <-2,12,-4>, <-5,12,-4>, <-5,16,-4> }
	}
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,1,-2,14,-5> }
	mesh {
		triangle { <-2,16,-6>, <2,16,-6>, <2,12,-6> }
		triangle { <2,12,-6>, <-2,12,-6>, <-2,16,-6> }
	}
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,1,2,14,-5> }
	mesh {
		triangle { <2,16,-4>, <5,16,-4>, <5,12,-4> }
		triangle { <5,12,-4>, <2,12,-4>, <2,16,-4> }
// 
// Cylinder & partition
	}
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,-4,0,0,0,8,0,16,0> }
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,4.18,1.7,14,11.82> }
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,4.18,-1.7,14,11.82> }
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,4.18,-1.7,14,-11.82> }
	object { rect_dot_dat matrix <0,2,0,-1,0,0,0,0,4.18,1.7,14,-11.82> }
	mesh {
		triangle { <1.7,16,16>, <-1.7,16,16>, <-1.7,16,7.64> }
		triangle { <-1.7,16,7.64>, <1.7,16,7.64>, <1.7,16,16> }
		triangle { <1.7,16,-16>, <-1.7,16,-16>, <-1.7,16,-7.64> }
		triangle { <-1.7,16,-7.64>, <1.7,16,-7.64>, <1.7,16,-16> }
// Disc
		triangle { <5,16,-4>, <8,16,0>, <5,16,4> }
		triangle { <5,16,4>, <8,16,0>, <7.36,16,3.04> }
		triangle { <7.36,16,3.04>, <5.6,16,5.6>, <5,16,4> }
		triangle { <5,16,4>, <2,16,4>, <2,16,6> }
		triangle { <2,16,6>, <5.6,16,5.6>, <5,16,4> }
		triangle { <2,16,6>, <5.6,16,5.6>, <3.04,16,7.36> }
		triangle { <3.04,16,7.36>, <1.7,16,7.64>, <2,16,6> }
		triangle { <2,16,6>, <1.7,16,7.64>, <-1.7,16,7.64> }
		triangle { <-1.7,16,7.64>, <-2,16,6>, <2,16,6> }
		triangle { <-2,16,6>, <-1.7,16,7.64>, <-3.04,16,7.36> }
		triangle { <-3.04,16,7.36>, <-5.6,16,5.6>, <-2,16,6> }
		triangle { <-2,16,6>, <-2,16,4>, <-5,16,4> }
		triangle { <-5,16,4>, <-5.6,16,5.6>, <-2,16,6> }
		triangle { <-5,16,4>, <-5.6,16,5.6>, <-7.36,16,3.04> }
		triangle { <-7.36,16,3.04>, <-8,16,0>, <-5,16,4> }
		triangle { <-5,16,4>, <-8,16,0>, <-5,16,-4> }
		triangle { <-5,16,-4>, <-8,16,0>, <-7.36,16,-3.04> }
		triangle { <-7.36,16,-3.04>, <-5.6,16,-5.6>, <-5,16,-4> }
		triangle { <-5,16,-4>, <-2,16,-4>, <-2,16,-6> }
		triangle { <-2,16,-6>, <-5.6,16,-5.6>, <-5,16,-4> }
		triangle { <-2,16,-6>, <-5.6,16,-5.6>, <-3.04,16,-7.36> }
		triangle { <-3.04,16,-7.36>, <-1.7,16,-7.64>, <-2,16,-6> }
		triangle { <-2,16,-6>, <-1.7,16,-7.64>, <1.7,16,-7.64> }
		triangle { <1.7,16,-7.64>, <2,16,-6>, <-2,16,-6> }
		triangle { <2,16,-6>, <1.7,16,-7.64>, <3.04,16,-7.36> }
		triangle { <3.04,16,-7.36>, <5.6,16,-5.6>, <2,16,-6> }
		triangle { <2,16,-6>, <2,16,-4>, <5,16,-4> }
		triangle { <5,16,-4>, <5.6,16,-5.6>, <2,16,-6> }
		triangle { <5,16,-4>, <5.6,16,-5.6>, <7.36,16,-3.04> }
		triangle { <7.36,16,-3.04>, <8,16,0>, <5,16,-4> }
// Cilinder edges
// 
// Clips
	}
	object { _1_dash_4disc_dot_dat matrix <-2,0,0,0,1,0,0,0,-2,16,16,-5> }
	mesh {
		triangle { <16,16,-5>, <14,16,-5>, <14,16,5> }
		triangle { <14,16,5>, <16,16,5>, <16,16,-5> }
	}
	object { _1_dash_4disc_dot_dat matrix <0,0,2,0,1,0,-2,0,0,16,16,5> }
	object { _1_dash_4cyli_dot_dat matrix <-2,0,0,0,-4,0,0,0,-2,16,16,-5> }
	mesh {
		triangle { <14,16,-5>, <14,16,5>, <14,12,5> }
		triangle { <14,12,5>, <14,12,-5>, <14,16,-5> }
	}
	object { _1_dash_4cyli_dot_dat matrix <0,0,2,0,-4,0,-2,0,0,16,16,5> }
// 
	object { _1_dash_4disc_dot_dat matrix <2,0,0,0,1,0,0,0,2,-16,16,5> }
	mesh {
		triangle { <-16,16,5>, <-14,16,5>, <-14,16,-5> }
		triangle { <-14,16,-5>, <-16,16,-5>, <-16,16,5> }
	}
	object { _1_dash_4disc_dot_dat matrix <0,0,-2,0,1,0,2,0,0,-16,16,-5> }
	object { _1_dash_4cyli_dot_dat matrix <2,0,0,0,-4,0,0,0,2,-16,16,5> }
	mesh {
		triangle { <-14,16,5>, <-14,16,-5>, <-14,12,-5> }
		triangle { <-14,12,-5>, <-14,12,5>, <-14,16,5> }
	}
	object { _1_dash_4cyli_dot_dat matrix <0,0,-2,0,-4,0,2,0,0,-16,16,-5> }
// 
	mesh {
		triangle { <16,12,16>, <-16,12,16>, <-16,12,-16> }
		triangle { <-16,12,-16>, <16,12,-16>, <16,12,16> }
// *** Top Part ***
// Underside rim
		triangle { <20,16,3.5>, <16,16,3.5>, <16,16,16> }
		triangle { <16,16,16>, <20,16,20>, <20,16,3.5> }
		triangle { <20,16,20>, <16,16,16>, <-16,16,16> }
		triangle { <-16,16,16>, <-20,16,20>, <20,16,20> }
		triangle { <-20,16,20>, <-16,16,16>, <-16,16,-16> }
		triangle { <-16,16,-16>, <-20,16,-20>, <-20,16,20> }
		triangle { <-20,16,-20>, <-16,16,-16>, <16,16,-16> }
		triangle { <16,16,-16>, <20,16,-20>, <-20,16,-20> }
		triangle { <20,16,-20>, <16,16,-16>, <16,16,-3.5> }
		triangle { <16,16,-3.5>, <20,16,-3.5>, <20,16,-20> }
		triangle { <16,16,7>, <16,16,16>, <16,12,16> }
		triangle { <16,12,16>, <16,12,7>, <16,16,7> }
	}
	object { rect_dot_dat matrix <7.15,0,0,0,0,1,0,-2,0,8.85,14,16> #if (version >= 3.1) material #else texture #end { Color383 } }
	object { rect_dot_dat matrix <7.15,0,0,0,0,1,0,-2,0,-8.85,14,16> #if (version >= 3.1) material #else texture #end { Color383 } }
	mesh {
		triangle { <-16,16,16>, <-16,16,7>, <-16,12,7> }
		triangle { <-16,12,7>, <-16,12,16>, <-16,16,16> }
		triangle { <-16,16,-7>, <-16,16,-16>, <-16,12,-16> }
		triangle { <-16,12,-16>, <-16,12,-7>, <-16,16,-7> }
	}
	object { rect_dot_dat matrix <7.15,0,0,0,0,1,0,-2,0,-8.85,14,-16> #if (version >= 3.1) material #else texture #end { Color383 } }
	object { rect_dot_dat matrix <7.15,0,0,0,0,1,0,-2,0,8.85,14,-16> #if (version >= 3.1) material #else texture #end { Color383 } }
	mesh {
		triangle { <16,16,-16>, <16,16,-7>, <16,12,-7> }
		triangle { <16,12,-7>, <16,12,-16>, <16,16,-16> }
// 
// left-side (back half)
		triangle { <20,16,20>, <20,16,3.5>, <20,11,3.5> }
		triangle { <20,11,3.5>, <20,11,20>, <20,16,20> }
		triangle { <20,11,20>, <20,11,15>, <20,6,15> }
		triangle { <20,6,15>, <20,6,20>, <20,11,20> }
		triangle { <20,11,7>, <20,11,3.5>, <20,6,3.5> }
		triangle { <20,6,3.5>, <20,6,7>, <20,11,7> }
		triangle { <20,6,20>, <20,6,3.5>, <20,0,3.5> }
		triangle { <20,0,3.5>, <20,0,20>, <20,6,20> }
	}
	object { box5_dot_dat matrix <0,2.5,0,-3,0,0,0,0,4,20,8.5,11> }
// left-side recess in middle
	object { rect_dot_dat matrix <2,0,0,0,0,1,0,8,0,18,8,3.5> }
	mesh {
		triangle { <16,16,3.5>, <16,16,-3.5>, <16,0,-3.5> }
		triangle { <16,0,-3.5>, <16,0,3.5>, <16,16,3.5> }
	}
	object { rect_dot_dat matrix <2,0,0,0,0,1,0,8,0,18,8,-3.5> }
// left-side (front half)
	mesh {
		triangle { <20,16,-20>, <20,16,-3.5>, <20,11,-3.5> }
		triangle { <20,11,-3.5>, <20,11,-20>, <20,16,-20> }
		triangle { <20,11,-20>, <20,11,-15>, <20,6,-15> }
		triangle { <20,6,-15>, <20,6,-20>, <20,11,-20> }
		triangle { <20,11,-7>, <20,11,-3.5>, <20,6,-3.5> }
		triangle { <20,6,-3.5>, <20,6,-7>, <20,11,-7> }
		triangle { <20,6,-20>, <20,6,-3.5>, <20,0,-3.5> }
		triangle { <20,0,-3.5>, <20,0,-20>, <20,6,-20> }
	}
	object { box5_dot_dat matrix <0,2.5,0,-3,0,0,0,0,4,20,8.5,-11> }
// right-side
	mesh {
		triangle { <-20,16,20>, <-20,16,-20>, <-20,11,-20> }
		triangle { <-20,11,-20>, <-20,11,20>, <-20,16,20> }
		triangle { <-20,11,20>, <-20,11,15>, <-20,6,15> }
		triangle { <-20,6,15>, <-20,6,20>, <-20,11,20> }
		triangle { <-20,11,7>, <-20,11,-7>, <-20,6,-7> }
		triangle { <-20,6,-7>, <-20,6,7>, <-20,11,7> }
		triangle { <-20,11,-20>, <-20,11,-15>, <-20,6,-15> }
		triangle { <-20,6,-15>, <-20,6,-20>, <-20,11,-20> }
		triangle { <-20,6,20>, <-20,6,-20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-20,0,20>, <-20,6,20> }
	}
	object { box5_dot_dat matrix <0,-2.5,0,3,0,0,0,0,4,-20,8.5,11> }
	object { box5_dot_dat matrix <0,-2.5,0,3,0,0,0,0,4,-20,8.5,-11> }
// back- and front-side
	object { rect_dot_dat matrix <20,0,0,0,0,1,0,8,0,0,8,20> }
	object { rect_dot_dat matrix <20,0,0,0,0,1,0,8,0,0,8,-20> }
// top
	mesh {
		triangle { <20,0,20>, <20,0,3.5>, <16,0,3.5> }
		triangle { <16,0,3.5>, <16,0,20>, <20,0,20> }
		triangle { <20,0,-20>, <20,0,-3.5>, <16,0,-3.5> }
		triangle { <16,0,-3.5>, <16,0,-20>, <20,0,-20> }
		triangle { <16,0,20>, <16,0,-20>, <2,0,-20> }
		triangle { <2,0,-20>, <2,0,20>, <16,0,20> }
		triangle { <2,0,20>, <2,0,6>, <-2,0,6> }
		triangle { <-2,0,6>, <-2,0,20>, <2,0,20> }
		triangle { <2,0,3>, <2,0,-3>, <-2,0,-3> }
		triangle { <-2,0,-3>, <-2,0,3>, <2,0,3> }
		triangle { <2,0,-20>, <2,0,-6>, <-2,0,-6> }
		triangle { <-2,0,-6>, <-2,0,-20>, <2,0,-20> }
		triangle { <-2,0,20>, <-2,0,-20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-20,0,20>, <-2,0,20> }
	}
	object { box5_dot_dat matrix <2,0,0,0,3,0,0,0,1.5,0,0,4.5> }
	object { box5_dot_dat matrix <2,0,0,0,3,0,0,0,1.5,0,0,-4.5> }
	#if (STUDS)
		object { studel_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,10,0,10> }
		object { studel_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,-10,0,10> }
		object { studel_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { studel_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
// wire stump
	#end
	mesh {
		triangle { <16,6.5,3>, <16,6.5,-3>, <40,6.5,-3> }
		triangle { <40,6.5,-3>, <40,6.5,3>, <16,6.5,3> }
		triangle { <16,6.5,3>, <40,6.5,3>, <40,4,3> }
		triangle { <40,4,3>, <16,4,3>, <16,6.5,3> }
		triangle { <16,6.5,-3>, <40,6.5,-3>, <40,4,-3> }
		triangle { <40,4,-3>, <16,4,-3>, <16,6.5,-3> }
		triangle { <16,4,3>, <16,4,-3>, <40,4,-3> }
		triangle { <40,4,-3>, <40,4,3>, <16,4,3> }
		triangle { <40,6.5,3>, <40,6.5,-3>, <40,4,-3> }
		triangle { <40,4,-3>, <40,4,3>, <40,6.5,3> }
// 
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3659)
		#include "lg_3659.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3659_dot_dat = #if (QUAL = 0) box { <-40,-4,-10>, <40,24,10> } #else object {
// Arch  1 x  4
	lg_3659
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3659_dot_dat_clear = #if (QUAL = 0) box { <-40,-4,-10>, <40,24,10> } #else object {
// Arch  1 x  4
	lg_3659_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3006)
		#include "lg_3006.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3006_dot_dat = #if (QUAL = 0) box { <-100,-4,-20>, <100,24,20> } #else object {
// Brick  2 x 10
	lg_3006
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3006_dot_dat_clear = #if (QUAL = 0) box { <-100,-4,-20>, <100,24,20> } #else object {
// Brick  2 x 10
	lg_3006_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3001)
		#include "lg_3001.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3001_dot_dat = #if (QUAL = 0) box { <-40,-4,-20>, <40,24,20> } #else object {
// Brick  2 x  4
	lg_3001
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3001_dot_dat_clear = #if (QUAL = 0) box { <-40,-4,-20>, <40,24,20> } #else object {
// Brick  2 x  4
	lg_3001_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#ifndef (Color366)
#declare Color366 = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.782353,0.621569,0.198039> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
} #if (version >= 3.1) } #end
#declare Color366_slope = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.782353,0.621569,0.198039> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color15)
#declare Color15 = #if (version >= 3.1) material { #end texture {
	lg_white
} #if (version >= 3.1) } #end
#declare Color15_slope = #if (version >= 3.1) material { #end texture {
	lg_white
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare box4_dash_1_dot_dat = object {
// Box, 4 faces drawn, 1 edge left out
// Name: box4-1.dat
// Author: Tore Eriksson 1998
// Official LCad Update 98-07
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
	}
}

#declare s_slash_3004p90a_dot_dat = #if (QUAL = 0) box { <-12.56,1.94,-10>, <5.2,19.7,-10> } #else union {
// ~Subpart Brick  1 x  2 with Classic Space Logo Pattern - Gold
// Name: s\3004p90a.dat
// Author: Chris Dee (chris_w_dee@hotmail.com)
// Official LCad Subpart 2000-01
	object { _2_dash_4disc_dot_dat matrix <7.113,-2.947,0,0,0,1,-2.947,-7.113,0,-2.5,12,-10> }
	mesh {
		triangle { <0.447,19.113,-10>, <2.945,17.445,-10>, <-2.5,19.7,-10> }
		triangle { <-2.5,19.7,-10>, <2.945,17.445,-10>, <4.613,14.947,-10> }
		triangle { <4.613,14.947,-10>, <-5.447,19.163,-10>, <-2.5,19.7,-10> }
		triangle { <-5.447,19.113,-10>, <4.613,14.947,-10>, <5.2,12,-10> }
		triangle { <5.2,12,-10>, <-7.945,17.445,-10>, <-5.447,19.113,-10> }
		triangle { <-7.945,17.445,-10>, <5.2,12,-10>, <5.171,11.853,-10> }
		triangle { <5.171,11.853,-10>, <-8.027,17.32,-10>, <-7.945,17.445,-10> }
// 
	}
}
#end

#declare _3004p90_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else union {
// Brick  1 x  2 with Classic Space Logo Pattern
// Name: 3004p90.DAT
// Author: Chris Dee (chris_w_dee@hotmail.com)
// Official LCad Part 2000-01
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { box4_dash_1_dot_dat matrix <20,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
	object { s_slash_3004p90a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (version >= 3.1) material #else texture #end { Color366 } }
	mesh {
		triangle { <-20,0,-10>, <-19.296,9.865,-10>, <2.046,1.025,-10> }
		triangle { <2.046,1.025,-10>, <2.046,0,-10>, <-20,0,-10> }
		triangle { <2.046,1.025,-10>, <2.046,0,-10>, <20,0,-10> }
		triangle { <20,0,-10>, <16.477,1.109,-10>, <2.046,1.025,-10> }
		triangle { <16.477,1.109,-10>, <20,0,-10>, <20,8.87,-10> }
		triangle { <20,8.87,-10>, <19.691,8.87,-10>, <16.477,1.109,-10> }
		triangle { <19.691,8.87,-10>, <20,8.87,-10>, <20,24,-10> }
		triangle { <20,24,-10>, <7.961,16.759,-10>, <19.691,8.87,-10> }
		triangle { <7.961,16.759,-10>, <20,24,-10>, <-6.531,24,-10> }
		triangle { <-6.531,24,-10>, <-6.531,22.762,-10>, <7.961,16.759,-10> }
		triangle { <-6.531,22.762,-10>, <-6.531,24,-10>, <-20,24,-10> }
		triangle { <-20,24,-10>, <-15.009,20.212,-10>, <-6.531,22.762,-10> }
		triangle { <-15.009,20.212,-10>, <-20,24,-10>, <-19.296,9.865,-10> }
		triangle { <-20,24,-10>, <-20,0,-10>, <-19.296,9.865,-10> }
	}
	mesh {
		triangle { <-5.447,4.887,-10>, <-5.714,4.24,-10>, <-8.44,6.06,-10> }
		triangle { <-8.44,6.06,-10>, <-7.945,6.555,-10>, <-5.447,4.887,-10> }
		triangle { <-7.945,6.555,-10>, <-8.44,6.06,-10>, <-10.259,8.786,-10> }
		triangle { <-10.259,8.786,-10>, <-9.613,9.053,-10>, <-7.945,6.555,-10> }
		triangle { <-9.613,9.053,-10>, <-10.259,8.786,-10>, <-10.9,12,-10> }
		triangle { <-10.9,12,-10>, <-10.2,12,-10>, <-9.613,9.053,-10> }
		triangle { <-10.2,12,-10>, <-10.9,12,-10>, <-10.26,15.214,-10> }
		triangle { <-10.26,15.214,-10>, <-9.613,14.947,-10>, <-10.2,12,-10> }
		triangle { <-8.027,17.32,-10>, <-7.945,17.445,-10>, <-8.439,17.939,-10> }
		triangle { <-8.439,17.939,-10>, <-8.674,17.589,-10>, <-8.027,17.32,-10> }
		triangle { <-7.945,17.445,-10>, <-8.44,17.94,-10>, <-5.714,19.759,-10> }
		triangle { <-5.714,19.759,-10>, <-5.447,19.113,-10>, <-7.945,17.445,-10> }
		triangle { <-5.447,19.113,-10>, <-5.714,19.759,-10>, <-2.5,20.4,-10> }
		triangle { <-2.5,20.4,-10>, <-2.5,19.7,-10>, <-5.447,19.113,-10> }
		triangle { <-2.5,19.7,-10>, <-2.5,20.4,-10>, <0.714,19.76,-10> }
		triangle { <0.714,19.76,-10>, <0.447,19.113,-10>, <-2.5,19.7,-10> }
		triangle { <0.447,19.113,-10>, <0.714,19.76,-10>, <3.44,17.94,-10> }
		triangle { <3.44,17.94,-10>, <2.945,17.445,-10>, <0.447,19.113,-10> }
		triangle { <2.945,17.445,-10>, <3.44,17.94,-10>, <5.259,15.214,-10> }
		triangle { <5.259,15.214,-10>, <4.613,14.947,-10>, <2.945,17.445,-10> }
		triangle { <4.613,14.947,-10>, <5.259,15.214,-10>, <5.9,12,-10> }
		triangle { <5.9,12,-10>, <5.2,12,-10>, <4.613,14.947,-10> }
		triangle { <5.171,11.853,-10>, <5.2,12,-10>, <5.9,12,-10> }
		triangle { <5.9,12,-10>, <5.817,11.586,-10>, <5.171,11.853,-10> }
		triangle { <4.613,9.053,-10>, <5.26,8.786,-10>, <3.44,6.06,-10> }
		triangle { <3.44,6.06,-10>, <2.945,6.555,-10>, <4.613,9.053,-10> }
		triangle { <2.945,6.555,-10>, <3.44,6.06,-10>, <0.714,4.241,-10> }
		triangle { <0.714,4.241,-10>, <0.447,4.887,-10>, <2.945,6.555,-10> }
		triangle { <0.447,4.887,-10>, <0.714,4.241,-10>, <-2.5,3.6,-10> }
		triangle { <-2.5,3.6,-10>, <-2.5,4.3,-10>, <0.447,4.887,-10> }
		triangle { <-2.5,4.3,-10>, <-2.5,3.6,-10>, <-5.714,4.24,-10> }
		triangle { <-5.714,4.24,-10>, <-5.447,4.887,-10>, <-2.5,4.3,-10> }
		triangle { <-10.26,15.214,-10>, <-9.993,15.861,-10>, <10.702,7.289,-10> }
		triangle { <10.702,7.289,-10>, <10.111,6.777,-10>, <-10.26,15.214,-10> }
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-9.993,15.861,-10>, <-9.457,17.155,-10>, <6.064,10.726,-10> }
		triangle { <6.064,10.726,-10>, <5.529,9.432,-10>, <-9.993,15.861,-10> }
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <-9.457,17.155,-10>, <-9.189,17.802,-10>, <11.182,9.364,-10> }
		triangle { <11.182,9.364,-10>, <11.238,8.583,-10>, <-9.457,17.155,-10> }
		triangle { <6.064,10.726,-10>, <5.529,9.432,-10>, <6.176,9.164,-10> }
		triangle { <6.176,9.164,-10>, <6.711,10.457,-10>, <6.064,10.726,-10> }
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <6.711,10.457,-10>, <6.176,9.164,-10>, <7.468,8.629,-10> }
		triangle { <7.468,8.629,-10>, <8.004,9.922,-10>, <6.711,10.457,-10> }
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <8.004,9.922,-10>, <7.468,8.629,-10>, <8.115,8.36,-10> }
		triangle { <8.115,8.36,-10>, <8.651,9.654,-10>, <8.004,9.922,-10> }
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <8.651,9.654,-10>, <8.115,8.36,-10>, <8.762,8.093,-10> }
		triangle { <8.762,8.093,-10>, <9.298,9.386,-10>, <8.651,9.654,-10> }
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <9.298,9.386,-10>, <8.762,8.093,-10>, <9.408,7.825,-10> }
		triangle { <9.408,7.825,-10>, <9.945,9.119,-10>, <9.298,9.386,-10> }
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <9.945,9.119,-10>, <9.408,7.825,-10>, <10.702,7.289,-10> }
		triangle { <10.702,7.289,-10>, <11.238,8.583,-10>, <9.945,9.119,-10> }
		triangle { <10.702,7.289,-10>, <11.192,4.814,-10>, <13.335,9.987,-10> }
		triangle { <13.335,9.987,-10>, <11.238,8.583,-10>, <10.702,7.289,-10> }
		triangle { <11.192,4.814,-10>, <13.667,5.302,-10>, <14.74,7.89,-10> }
		triangle { <14.74,7.89,-10>, <13.335,9.987,-10>, <11.192,4.814,-10> }
		triangle { <13.667,5.302,-10>, <16.523,4.878,-10>, <17.058,6.172,-10> }
		triangle { <17.058,6.172,-10>, <14.74,7.89,-10>, <13.667,5.302,-10> }
		triangle { <16.523,4.878,-10>, <17.058,6.172,-10>, <17.437,5.258,-10> }
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <10.702,7.289,-10>, <10.111,6.777,-10>, <10.278,4.434,-10> }
		triangle { <10.278,4.434,-10>, <11.192,4.814,-10>, <10.702,7.289,-10> }
		triangle { <11.192,4.814,-10>, <10.278,4.434,-10>, <11.571,3.898,-10> }
		triangle { <11.192,4.814,-10>, <11.571,3.898,-10>, <13.4,4.657,-10> }
		triangle { <13.4,4.657,-10>, <13.667,5.302,-10>, <11.192,4.814,-10> }
		triangle { <13.667,5.302,-10>, <13.4,4.657,-10>, <16.254,4.231,-10> }
		triangle { <16.254,4.231,-10>, <16.523,4.878,-10>, <13.667,5.302,-10> }
		triangle { <16.523,4.878,-10>, <16.254,4.231,-10>, <18.084,4.989,-10> }
		triangle { <18.084,4.989,-10>, <17.437,5.258,-10>, <16.523,4.878,-10> }
		triangle { <17.437,5.258,-10>, <18.084,4.989,-10>, <17.327,6.819,-10> }
		triangle { <17.327,6.819,-10>, <17.058,6.172,-10>, <17.437,5.258,-10> }
		triangle { <17.058,6.172,-10>, <17.327,6.819,-10>, <15.007,8.536,-10> }
		triangle { <15.007,8.536,-10>, <14.74,7.89,-10>, <17.058,6.172,-10> }
		triangle { <14.74,7.89,-10>, <15.007,8.536,-10>, <14.25,10.366,-10> }
		triangle { <14.25,10.366,-10>, <13.335,9.987,-10>, <14.74,7.89,-10> }
		triangle { <13.335,9.987,-10>, <14.25,10.366,-10>, <12.956,10.901,-10> }
		triangle { <13.335,9.987,-10>, <12.956,10.901,-10>, <11.182,9.364,-10> }
		triangle { <11.182,9.364,-10>, <11.238,8.583,-10>, <13.335,9.987,-10> }
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-9.993,15.861,-10>, <-9.457,17.155,-10>, <-12.178,17.902,-10> }
		triangle { <-12.178,17.902,-10>, <-12.713,16.609,-10>, <-9.993,15.861,-10> }
		triangle { <-12.713,16.609,-10>, <-12.178,17.902,-10>, <-15.435,17.358,-10> }
		triangle { <-15.435,17.358,-10>, <-15.702,16.711,-10>, <-12.713,16.609,-10> }
		triangle { <-15.702,16.711,-10>, <-15.969,16.064,-10>, <-13.272,13.431,-10> }
		triangle { <-13.272,13.431,-10>, <-13.004,14.078,-10>, <-15.702,16.711,-10> }
		triangle { <-13.004,14.078,-10>, <-13.272,13.431,-10>, <-10.9,12,-10> }
		triangle { <-10.9,12,-10>, <-10.761,12.7,-10>, <-13.004,14.078,-10> }
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <-10.761,12.7,-10>, <-10.26,15.214,-10>, <-13.004,14.078,-10> }
		triangle { <-13.004,14.078,-10>, <-10.26,15.214,-10>, <-9.993,15.861,-10> }
		triangle { <-9.993,15.861,-10>, <-12.713,16.609,-10>, <-13.004,14.078,-10> }
		triangle { <-13.004,14.078,-10>, <-12.713,16.609,-10>, <-15.702,16.711,-10> }
		triangle { <-9.457,17.155,-10>, <-9.189,17.802,-10>, <-11.909,18.549,-10> }
		triangle { <-11.909,18.549,-10>, <-12.178,17.902,-10>, <-9.457,17.155,-10> }
		triangle { <-12.178,17.902,-10>, <-11.909,18.549,-10>, <-15.166,18.005,-10> }
		triangle { <-15.166,18.005,-10>, <-15.435,17.358,-10>, <-12.178,17.902,-10> }
		triangle { <-15.166,18.005,-10>, <-16.349,16.978,-10>, <-16.238,15.417,-10> }
		triangle { <-15.969,16.064,-10>, <-16.238,15.417,-10>, <-13.54,12.784,-10> }
		triangle { <-13.54,12.784,-10>, <-13.272,13.431,-10>, <-15.969,16.064,-10> }
		triangle { <-13.272,13.431,-10>, <-13.54,12.784,-10>, <-10.735,11.174,-10> }
		triangle { <-10.735,11.174,-10>, <-10.9,12,-10>, <-13.272,13.431,-10> }
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-16.349,16.978,-10>, <-19.296,9.865,-10>, <-18.649,9.598,-10> }
		triangle { <-18.649,9.598,-10>, <-16.238,15.417,-10>, <-16.349,16.978,-10> }
		triangle { <-16.238,15.417,-10>, <-18.649,9.598,-10>, <-15.415,8.258,-10> }
		triangle { <-15.415,8.258,-10>, <-13.54,12.784,-10>, <-16.238,15.417,-10> }
		triangle { <-13.54,12.784,-10>, <-15.415,8.258,-10>, <-12.453,7.03,-10> }
		triangle { <-12.453,7.03,-10>, <-10.735,11.174,-10>, <-13.54,12.784,-10> }
		triangle { <-10.735,11.174,-10>, <-12.453,7.03,-10>, <-11.202,6.512,-10> }
		triangle { <-11.202,6.512,-10>, <-10.262,8.786,-10>, <-10.735,11.174,-10> }
		triangle { <-10.262,8.786,-10>, <-11.202,6.512,-10>, <-8.684,5.469,-10> }
		triangle { <-8.684,5.469,-10>, <-8.439,6.061,-10>, <-10.262,8.786,-10> }
		triangle { <-8.439,6.061,-10>, <-8.684,5.469,-10>, <-5.714,4.24,-10> }
		triangle { <-5.714,4.24,-10>, <-2.745,3.009,-10>, <-2.5,3.6,-10> }
		triangle { <-2.5,3.6,-10>, <-2.745,3.009,-10>, <-0.226,1.966,-10> }
		triangle { <-0.226,1.966,-10>, <0.714,4.238,-10>, <-2.5,3.6,-10> }
		triangle { <0.714,4.238,-10>, <-0.226,1.966,-10>, <1.455,1.27,-10> }
		triangle { <1.455,1.27,-10>, <3.439,6.061,-10>, <0.714,4.238,-10> }
		triangle { <3.439,6.061,-10>, <1.455,1.27,-10>, <2.046,1.025,-10> }
		triangle { <2.046,1.025,-10>, <5.26,8.786,-10>, <3.439,6.061,-10> }
		triangle { <5.26,8.786,-10>, <2.046,1.025,-10>, <9.039,4.189,-10> }
		triangle { <9.039,4.189,-10>, <10.111,6.777,-10>, <5.26,8.786,-10> }
		triangle { <10.111,6.777,-10>, <9.039,4.189,-10>, <10.009,3.788,-10> }
		triangle { <10.009,3.788,-10>, <10.278,4.434,-10>, <10.111,6.777,-10> }
		triangle { <10.278,4.434,-10>, <10.009,3.788,-10>, <11.303,3.251,-10> }
		triangle { <11.303,3.251,-10>, <11.571,3.898,-10>, <10.278,4.434,-10> }
		triangle { <11.571,3.898,-10>, <11.303,3.251,-10>, <12.596,2.717,-10> }
		triangle { <12.596,2.717,-10>, <13.4,4.657,-10>, <11.571,3.898,-10> }
		triangle { <13.4,4.657,-10>, <12.596,2.717,-10>, <15.183,1.644,-10> }
		triangle { <15.183,1.644,-10>, <16.254,4.231,-10>, <13.4,4.657,-10> }
		triangle { <16.254,4.231,-10>, <15.183,1.644,-10>, <16.477,1.109,-10> }
		triangle { <16.477,1.109,-10>, <18.084,4.989,-10>, <16.254,4.231,-10> }
		triangle { <18.084,4.989,-10>, <19.691,8.87,-10>, <18.398,9.406,-10> }
		triangle { <18.398,9.406,-10>, <17.327,6.819,-10>, <18.084,4.989,-10> }
		triangle { <17.327,6.819,-10>, <18.398,9.406,-10>, <15.811,10.477,-10> }
		triangle { <15.811,10.477,-10>, <15.007,8.536,-10>, <17.327,6.819,-10> }
		triangle { <15.007,8.536,-10>, <15.811,10.477,-10>, <14.517,11.013,-10> }
		triangle { <14.517,11.013,-10>, <14.25,10.366,-10>, <15.007,8.536,-10> }
		triangle { <14.25,10.366,-10>, <14.517,11.013,-10>, <13.223,11.548,-10> }
		triangle { <13.223,11.548,-10>, <12.956,10.901,-10>, <14.25,10.366,-10> }
		triangle { <12.956,10.901,-10>, <13.223,11.548,-10>, <12.255,11.95,-10> }
		triangle { <12.255,11.95,-10>, <11.182,9.364,-10>, <12.956,10.901,-10> }
		triangle { <11.182,9.364,-10>, <12.255,11.95,-10>, <7.961,16.759,-10> }
		triangle { <7.961,16.759,-10>, <5.817,11.586,-10>, <11.182,9.364,-10> }
		triangle { <5.817,11.586,-10>, <7.961,16.759,-10>, <7.884,16.791,-10> }
		triangle { <7.884,16.791,-10>, <5.9,12,-10>, <5.817,11.586,-10> }
		triangle { <5.9,12,-10>, <7.884,16.791,-10>, <6.202,17.488,-10> }
		triangle { <6.202,17.488,-10>, <5.262,15.214,-10>, <5.9,12,-10> }
		triangle { <5.262,15.214,-10>, <6.202,17.488,-10>, <3.684,18.531,-10> }
		triangle { <3.684,18.531,-10>, <3.439,17.939,-10>, <5.262,15.214,-10> }
		triangle { <3.439,17.939,-10>, <3.684,18.531,-10>, <0.714,19.76,-10> }
		triangle { <0.714,19.76,-10>, <-2.255,20.991,-10>, <-2.5,20.4,-10> }
		triangle { <-2.5,20.4,-10>, <-2.255,20.991,-10>, <-4.774,22.034,-10> }
		triangle { <-4.774,22.034,-10>, <-5.714,19.762,-10>, <-2.5,20.4,-10> }
		triangle { <-5.714,19.762,-10>, <-4.774,22.034,-10>, <-6.455,22.73,-10> }
		triangle { <-6.455,22.73,-10>, <-8.439,17.939,-10>, <-5.714,19.762,-10> }
		triangle { <-8.439,17.939,-10>, <-6.455,22.73,-10>, <-6.531,22.762,-10> }
		triangle { <-6.531,22.762,-10>, <-8.674,17.589,-10>, <-8.439,17.939,-10> }
		triangle { <-6.531,22.762,-10>, <-8.674,17.589,-10>, <-11.909,18.549,-10> }
		triangle { <-11.909,18.549,-10>, <-6.531,22.762,-10>, <-15.009,20.212,-10> }
		triangle { <-15.009,20.212,-10>, <-15.166,18.005,-10>, <-11.909,18.549,-10> }
		triangle { <-15.166,18.005,-10>, <-15.009,20.212,-10>, <-16.349,16.978,-10> }
		triangle { <2.046,1.025,-10>, <9.039,4.189,-10>, <16.477,1.109,-10> }
		triangle { <19.691,8.87,-10>, <12.255,11.95,-10>, <7.961,16.759,-10> }
// 
	}
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_32014)
		#include "lg_32014.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _32014_dot_dat = #if (QUAL = 0) box { <-10,-30,-30>, <10,10,10> } #else object {
// Technic Angle Connector #6
	lg_32014
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _32014_dot_dat_clear = #if (QUAL = 0) box { <-10,-30,-30>, <10,10,10> } #else object {
// Technic Angle Connector #6
	lg_32014_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3705)
		#include "lg_3705.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3705_dot_dat = #if (QUAL = 0) box { <-40,-6,-6>, <40,6,6> } #else object {
// Technic Axle  4
	lg_3705
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3705_dot_dat_clear = #if (QUAL = 0) box { <-40,-6,-6>, <40,6,6> } #else object {
// Technic Axle  4
	lg_3705_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3706)
		#include "lg_3706.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3706_dot_dat = #if (QUAL = 0) box { <-60,-6,-6>, <60,6,6> } #else object {
// Technic Axle  6
	lg_3706
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3706_dot_dat_clear = #if (QUAL = 0) box { <-60,-6,-6>, <60,6,6> } #else object {
// Technic Axle  6
	lg_3706_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_2637)
		#include "lg_2637.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _2637_dot_dat = #if (QUAL = 0) box { <-10,-10,-310>, <10,10,10> } #else object {
// Technic Link 16L
	lg_2637
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _2637_dot_dat_clear = #if (QUAL = 0) box { <-10,-10,-310>, <10,10,10> } #else object {
// Technic Link 16L
	lg_2637_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_32064)
		#include "lg_32064.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _32064_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else object {
// Technic Brick  1 x  2 with Axlehole
	lg_32064
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _32064_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else object {
// Technic Brick  1 x  2 with Axlehole
	lg_32064_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _32073_dot_dat = #if (QUAL = 0) box { <-50,-6,-6>, <50,6,6> } #else object {
// Technic Axle  5
// Name: 32073.dat
// Author: Rob
// Official LCad update 98-10
	object { axle_dot_dat matrix <0,1,0,-100,0,0,0,0,1,50,0,0> }
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3894)
		#include "lg_3894.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3894_dot_dat = #if (QUAL = 0) box { <-60,-4,-10>, <60,24,10> } #else object {
// Technic Brick  1 x  6 with Holes
	lg_3894
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3894_dot_dat_clear = #if (QUAL = 0) box { <-60,-4,-10>, <60,24,10> } #else object {
// Technic Brick  1 x  6 with Holes
	lg_3894_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _71427c01_dot_dat = #if (QUAL = 0) box { <-40,-4,-60>, <40,75,40> } #else union {
// Electric Technic Mini-Motor  9v
// Name: 71427c01.dat
// Author: John VanZwieten
// Official LCad update 99-03
	object { box3_crosshatch_8p_dot_dat matrix <0,0,-20,0,4,0,4,0,0,0,0,20> }
	object { _4_dash_4ndis_dot_dat matrix <9,0,0,0,0,1,0,-9,0,0,42,-40> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,0,1,0,-9,0,0,42,-40> #if (version >= 3.1) material #else texture #end { Color0 } }
	object { axle_dot_dat matrix <1,0,0,0,0,-20,0,1,0,0,42,-40> #if (version >= 3.1) material #else texture #end { Color0 } }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,68,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,68,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,68,-20> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,16,0,72,-20> }
	mesh {
		triangle { <40,72,0>, <36,72,-4>, <-36,72,-4> }
		triangle { <-36,72,-4>, <-40,72,0>, <40,72,0> }
		triangle { <40,72,-40>, <36,72,-36>, <-36,72,-36> }
		triangle { <-36,72,-36>, <-40,72,-40>, <40,72,-40> }
		triangle { <40,72,0>, <36,72,-4>, <36,72,-36> }
		triangle { <36,72,-36>, <40,72,-40>, <40,72,0> }
		triangle { <-40,72,0>, <-36,72,-4>, <-36,72,-36> }
		triangle { <-36,72,-36>, <-40,72,-40>, <-40,72,0> }
	}
	object { box4_dash_1_dot_dat matrix <-6,0,0,0,-4,0,0,0,18,-30,72,18> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,-30,68,18> }
	object { _4_dash_4cyli_dot_dat matrix <2,0,0,0,4,0,0,0,2,-30,68,18> }
	object { ring1_dot_dat matrix <2,0,0,0,1,0,0,0,2,-30,72,18> }
	object { box4_dash_1_dot_dat matrix <1.5,0,0,0,4,0,0,0,2,-30,68,2> }
	object { rect_dot_dat matrix <2.25,0,0,0,0,1,0,-2,0,-26.25,70,0> }
	object { rect_dot_dat matrix <2.25,0,0,0,0,1,0,-2,0,-33.75,70,0> }
	mesh {
		triangle { <-40,72,0>, <-40,72,40>, <-36,72,36> }
		triangle { <-36,72,36>, <-36,72,0>, <-40,72,0> }
		triangle { <-40,72,40>, <-20,72,40>, <-24,72,36> }
		triangle { <-24,72,36>, <-36,72,36>, <-40,72,40> }
		triangle { <-20,72,40>, <-20,72,0>, <-24,72,0> }
		triangle { <-24,72,0>, <-24,72,36>, <-20,72,40> }
	}
	object { box4_dash_1_dot_dat matrix <-6,0,0,0,-4,0,0,0,18,30,72,18> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,30,68,18> }
	object { _4_dash_4cyli_dot_dat matrix <2,0,0,0,4,0,0,0,2,30,68,18> }
	object { ring1_dot_dat matrix <2,0,0,0,1,0,0,0,2,30,72,18> }
	object { box4_dash_1_dot_dat matrix <1.5,0,0,0,4,0,0,0,2,30,68,2> }
	object { rect_dot_dat matrix <2.25,0,0,0,0,1,0,-2,0,33.75,70,0> }
	object { rect_dot_dat matrix <2.25,0,0,0,0,1,0,-2,0,26.25,70,0> }
	mesh {
		triangle { <20,72,0>, <20,72,40>, <24,72,36> }
		triangle { <24,72,36>, <24,72,0>, <20,72,0> }
		triangle { <20,72,40>, <40,72,40>, <36,72,36> }
		triangle { <36,72,36>, <24,72,36>, <20,72,40> }
		triangle { <40,72,40>, <40,72,0>, <36,72,0> }
		triangle { <36,72,0>, <36,72,36>, <40,72,40> }
// 
	}
	object { _2_dash_4cyli_dot_dat matrix <20,0,0,0,0,-40,0,3,0,0,72,40> }
	object { _2_dash_4disc_dot_dat matrix <20,0,0,0,0,-1,0,3,0,0,72,0> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,28,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-39,28,26> }
	mesh {
		triangle { <-39,32,0>, <-40,32,0>, <-40,32,26> }
		triangle { <-40,32,26>, <-39,32,26>, <-39,32,0> }
		triangle { <-39,24,0>, <-40,24,0>, <-40,24,26> }
		triangle { <-40,24,26>, <-39,24,26>, <-39,24,0> }
		triangle { <-39,24,26>, <-39,24,0>, <-39,32,0> }
		triangle { <-39,32,0>, <-39,32,26>, <-39,24,26> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-39,28,26> }
	mesh {
		triangle { <-39,24,0>, <-30,24,0>, <-30,32,0> }
		triangle { <-30,32,0>, <-39,32,0>, <-39,24,0> }
		triangle { <-30,24,0>, <-30,24,-39>, <-30,32,-39> }
		triangle { <-30,32,-39>, <-30,32,0>, <-30,24,0> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,28,-39> }
	mesh {
		triangle { <-40,24,0>, <-40,24,-40>, <-30,24,-40> }
		triangle { <-30,24,-40>, <-30,24,0>, <-40,24,0> }
		triangle { <-40,32,0>, <-40,32,-40>, <-30,32,-40> }
		triangle { <-30,32,-40>, <-30,32,0>, <-40,32,0> }
		triangle { <-40,16,30>, <-40,16,-40>, <-40,24,-40> }
		triangle { <-40,24,-40>, <-40,24,30>, <-40,16,30> }
		triangle { <-40,32,30>, <-40,32,-40>, <-40,40,-40> }
		triangle { <-40,40,-40>, <-40,40,30>, <-40,32,30> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-40,28,26> }
	mesh {
		triangle { <-40,16,-40>, <-26,16,-40>, <-26,24,-40> }
		triangle { <-26,24,-40>, <-40,24,-40>, <-40,16,-40> }
		triangle { <-40,32,-40>, <-26,32,-40>, <-26,40,-40> }
		triangle { <-26,40,-40>, <-40,40,-40>, <-40,32,-40> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,28,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,60,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-39,60,26> }
	mesh {
		triangle { <-39,64,0>, <-40,64,0>, <-40,64,26> }
		triangle { <-40,64,26>, <-39,64,26>, <-39,64,0> }
		triangle { <-39,56,0>, <-40,56,0>, <-40,56,26> }
		triangle { <-40,56,26>, <-39,56,26>, <-39,56,0> }
		triangle { <-39,56,26>, <-39,56,0>, <-39,64,0> }
		triangle { <-39,64,0>, <-39,64,26>, <-39,56,26> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-39,60,26> }
	mesh {
		triangle { <-39,56,0>, <-30,56,0>, <-30,64,0> }
		triangle { <-30,64,0>, <-39,64,0>, <-39,56,0> }
		triangle { <-30,56,0>, <-30,56,-39>, <-30,64,-39> }
		triangle { <-30,64,-39>, <-30,64,0>, <-30,56,0> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,60,-39> }
	mesh {
		triangle { <-40,56,0>, <-40,56,-40>, <-30,56,-40> }
		triangle { <-30,56,-40>, <-30,56,0>, <-40,56,0> }
		triangle { <-40,64,0>, <-40,64,-40>, <-30,64,-40> }
		triangle { <-30,64,-40>, <-30,64,0>, <-40,64,0> }
		triangle { <-40,48,30>, <-40,48,-40>, <-40,56,-40> }
		triangle { <-40,56,-40>, <-40,56,30>, <-40,48,30> }
		triangle { <-40,64,30>, <-40,64,-40>, <-40,72,-40> }
		triangle { <-40,72,-40>, <-40,72,30>, <-40,64,30> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-40,60,26> }
	mesh {
		triangle { <-40,48,-40>, <-26,48,-40>, <-26,56,-40> }
		triangle { <-26,56,-40>, <-40,56,-40>, <-40,48,-40> }
		triangle { <-40,64,-40>, <-26,64,-40>, <-26,72,-40> }
		triangle { <-26,72,-40>, <-40,72,-40>, <-40,64,-40> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,60,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,28,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,-4,0,1,0,0,0,0,4,39,28,26> }
	mesh {
		triangle { <39,24,0>, <40,24,0>, <40,24,26> }
		triangle { <40,24,26>, <39,24,26>, <39,24,0> }
		triangle { <39,32,0>, <40,32,0>, <40,32,26> }
		triangle { <40,32,26>, <39,32,26>, <39,32,0> }
		triangle { <39,32,26>, <39,32,0>, <39,24,0> }
		triangle { <39,24,0>, <39,24,26>, <39,32,26> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,-4,0,1,0,0,0,0,4,39,28,26> }
	mesh {
		triangle { <39,32,0>, <30,32,0>, <30,24,0> }
		triangle { <30,24,0>, <39,24,0>, <39,32,0> }
		triangle { <30,32,0>, <30,32,-39>, <30,24,-39> }
		triangle { <30,24,-39>, <30,24,0>, <30,32,0> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,28,-39> }
	mesh {
		triangle { <40,32,0>, <40,32,-40>, <30,32,-40> }
		triangle { <30,32,-40>, <30,32,0>, <40,32,0> }
		triangle { <40,24,0>, <40,24,-40>, <30,24,-40> }
		triangle { <30,24,-40>, <30,24,0>, <40,24,0> }
		triangle { <40,40,30>, <40,40,-40>, <40,32,-40> }
		triangle { <40,32,-40>, <40,32,30>, <40,40,30> }
		triangle { <40,24,30>, <40,24,-40>, <40,16,-40> }
		triangle { <40,16,-40>, <40,16,30>, <40,24,30> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,-4,0,1,0,0,0,0,4,40,28,26> }
	mesh {
		triangle { <40,40,-40>, <26,40,-40>, <26,32,-40> }
		triangle { <26,32,-40>, <40,32,-40>, <40,40,-40> }
		triangle { <40,24,-40>, <26,24,-40>, <26,16,-40> }
		triangle { <26,16,-40>, <40,16,-40>, <40,24,-40> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,28,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,60,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,-4,0,1,0,0,0,0,4,39,60,26> }
	mesh {
		triangle { <39,56,0>, <40,56,0>, <40,56,26> }
		triangle { <40,56,26>, <39,56,26>, <39,56,0> }
		triangle { <39,64,0>, <40,64,0>, <40,64,26> }
		triangle { <40,64,26>, <39,64,26>, <39,64,0> }
		triangle { <39,64,26>, <39,64,0>, <39,56,0> }
		triangle { <39,56,0>, <39,56,26>, <39,64,26> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,-4,0,1,0,0,0,0,4,39,60,26> }
	mesh {
		triangle { <39,64,0>, <30,64,0>, <30,56,0> }
		triangle { <30,56,0>, <39,56,0>, <39,64,0> }
		triangle { <30,64,0>, <30,64,-39>, <30,56,-39> }
		triangle { <30,56,-39>, <30,56,0>, <30,64,0> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,60,-39> }
	mesh {
		triangle { <40,64,0>, <40,64,-40>, <30,64,-40> }
		triangle { <30,64,-40>, <30,64,0>, <40,64,0> }
		triangle { <40,56,0>, <40,56,-40>, <30,56,-40> }
		triangle { <30,56,-40>, <30,56,0>, <40,56,0> }
		triangle { <40,72,30>, <40,72,-40>, <40,64,-40> }
		triangle { <40,64,-40>, <40,64,30>, <40,72,30> }
		triangle { <40,56,30>, <40,56,-40>, <40,48,-40> }
		triangle { <40,48,-40>, <40,48,30>, <40,56,30> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,-4,0,1,0,0,0,0,4,40,60,26> }
	mesh {
		triangle { <40,72,-40>, <26,72,-40>, <26,64,-40> }
		triangle { <26,64,-40>, <40,64,-40>, <40,72,-40> }
		triangle { <40,56,-40>, <26,56,-40>, <26,48,-40> }
		triangle { <26,48,-40>, <40,48,-40>, <40,56,-40> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,60,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,44,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-39,44,26> }
	mesh {
		triangle { <-39,48,-40>, <-40,48,-40>, <-40,48,26> }
		triangle { <-40,48,26>, <-39,48,26>, <-39,48,-40> }
		triangle { <-39,40,-40>, <-40,40,-40>, <-40,40,26> }
		triangle { <-40,40,26>, <-39,40,26>, <-39,40,-40> }
		triangle { <-39,40,26>, <-39,40,0>, <-39,48,0> }
		triangle { <-39,48,0>, <-39,48,26>, <-39,40,26> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-39,44,26> }
	mesh {
		triangle { <-39,40,-39>, <-30,40,-39>, <-30,48,-39> }
		triangle { <-30,48,-39>, <-39,48,-39>, <-39,40,-39> }
		triangle { <-39,40,0>, <-39,40,-39>, <-39,48,-39> }
		triangle { <-39,48,-39>, <-39,48,0>, <-39,40,0> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,44,-39> }
	mesh {
		triangle { <-40,40,-39>, <-40,40,-40>, <-30,40,-40> }
		triangle { <-30,40,-40>, <-30,40,-39>, <-40,40,-39> }
		triangle { <-40,48,-39>, <-40,48,-40>, <-30,48,-40> }
		triangle { <-30,48,-40>, <-30,48,-39>, <-40,48,-39> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,4,0,-1,0,0,0,0,4,-40,44,26> }
	object { _2_dash_4ndis_dot_dat matrix <0,4,0,0,0,1,4,0,0,-30,44,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,44,-40> }
	object { _2_dash_4cyli_dot_dat matrix <0,-4,0,1,0,0,0,0,4,39,44,26> }
	mesh {
		triangle { <39,40,-40>, <40,40,-40>, <40,40,26> }
		triangle { <40,40,26>, <39,40,26>, <39,40,-40> }
		triangle { <39,48,-40>, <40,48,-40>, <40,48,26> }
		triangle { <40,48,26>, <39,48,26>, <39,48,-40> }
		triangle { <39,48,26>, <39,48,0>, <39,40,0> }
		triangle { <39,40,0>, <39,40,26>, <39,48,26> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,-4,0,1,0,0,0,0,4,39,44,26> }
	mesh {
		triangle { <39,48,-39>, <30,48,-39>, <30,40,-39> }
		triangle { <30,40,-39>, <39,40,-39>, <39,48,-39> }
		triangle { <39,48,0>, <39,48,-39>, <39,40,-39> }
		triangle { <39,40,-39>, <39,40,0>, <39,48,0> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,44,-39> }
	mesh {
		triangle { <40,48,-39>, <40,48,-40>, <30,48,-40> }
		triangle { <30,48,-40>, <30,48,-39>, <40,48,-39> }
		triangle { <40,40,-39>, <40,40,-40>, <30,40,-40> }
		triangle { <30,40,-40>, <30,40,-39>, <40,40,-39> }
	}
	object { _2_dash_4ndis_dot_dat matrix <0,-4,0,1,0,0,0,0,4,40,44,26> }
	object { _2_dash_4ndis_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,30,44,-40> }
// 
	mesh {
		triangle { <-40,4,40>, <-40,4,30>, <-40,72,30> }
		triangle { <-40,72,30>, <-40,72,40>, <-40,4,40> }
		triangle { <40,4,40>, <40,4,30>, <40,72,30> }
		triangle { <40,72,30>, <40,72,40>, <40,4,40> }
		triangle { <-40,4,0>, <-40,16,0>, <-40,16,30> }
		triangle { <-40,16,30>, <-40,4,30>, <-40,4,0> }
		triangle { <40,4,0>, <40,16,0>, <40,16,30> }
		triangle { <40,16,30>, <40,4,30>, <40,4,0> }
		triangle { <-40,4,0>, <-40,4,40>, <-36,0,40> }
		triangle { <-36,0,40>, <-36,0,0>, <-40,4,0> }
		triangle { <40,4,0>, <40,4,40>, <36,0,40> }
		triangle { <36,0,40>, <36,0,0>, <40,4,0> }
		triangle { <-36,0,0>, <-36,0,40>, <-4,0,40> }
		triangle { <-4,0,40>, <-4,0,0>, <-36,0,0> }
		triangle { <36,0,0>, <36,0,40>, <4,0,40> }
		triangle { <4,0,40>, <4,0,0>, <36,0,0> }
	}
	mesh {
		triangle { <-20,12,0>, <20,12,0>, <20,16,0> }
		triangle { <20,16,0>, <-20,16,0>, <-20,12,0> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-40,4,0>, <-36,0,0>, <-4,0,0> }
		triangle { <-4,0,0>, <-4,4,0>, <-40,4,0> }
		triangle { <40,4,0>, <36,0,0>, <4,0,0> }
		triangle { <4,0,0>, <4,4,0>, <40,4,0> }
		triangle { <-40,4,0>, <40,4,0>, <40,12,0> }
		triangle { <40,12,0>, <-40,12,0>, <-40,4,0> }
		triangle { <-40,12,0>, <-20,12,0>, <-20,16,0> }
		triangle { <-20,16,0>, <-40,16,0>, <-40,12,0> }
		triangle { <40,12,0>, <20,12,0>, <20,16,0> }
		triangle { <20,16,0>, <40,16,0>, <40,12,0> }
	}
	mesh {
		triangle { <-20,16,0>, <20,16,0>, <20,16,-38> }
		triangle { <20,16,-38>, <-20,16,-38>, <-20,16,0> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-20,16,-40>, <-20,16,-38>, <20,16,-38> }
		triangle { <20,16,-38>, <20,16,-40>, <-20,16,-40> }
		triangle { <-40,16,0>, <-37,16,-3>, <-37,16,-37> }
		triangle { <-37,16,-37>, <-40,16,-40>, <-40,16,0> }
		triangle { <-40,16,0>, <-20,16,0>, <-23,16,-3> }
		triangle { <-23,16,-3>, <-37,16,-3>, <-40,16,0> }
		triangle { <-20,16,0>, <-20,16,-40>, <-23,16,-37> }
		triangle { <-23,16,-37>, <-23,16,-3>, <-20,16,0> }
		triangle { <-40,16,-40>, <-37,16,-37>, <-23,16,-37> }
		triangle { <-23,16,-37>, <-20,16,-40>, <-40,16,-40> }
		triangle { <-37,16,-3>, <-23,16,-3>, <-27,20,-3> }
		triangle { <-27,20,-3>, <-37,20,-3>, <-37,16,-3> }
		triangle { <-23,16,-3>, <-23,16,-37>, <-27,20,-37> }
		triangle { <-27,20,-37>, <-27,20,-3>, <-23,16,-3> }
		triangle { <-23,16,-37>, <-37,16,-37>, <-37,20,-37> }
		triangle { <-37,20,-37>, <-27,20,-37>, <-23,16,-37> }
		triangle { <-37,16,-37>, <-37,16,-3>, <-37,20,-3> }
		triangle { <-37,20,-3>, <-37,20,-37>, <-37,16,-37> }
		triangle { <-37,20,-3>, <-27,20,-3>, <-27,20,-37> }
		triangle { <-27,20,-37>, <-37,20,-37>, <-37,20,-3> }
		triangle { <40,16,0>, <37,16,-3>, <37,16,-37> }
		triangle { <37,16,-37>, <40,16,-40>, <40,16,0> }
		triangle { <40,16,0>, <20,16,0>, <23,16,-3> }
		triangle { <23,16,-3>, <37,16,-3>, <40,16,0> }
		triangle { <20,16,0>, <20,16,-40>, <23,16,-37> }
		triangle { <23,16,-37>, <23,16,-3>, <20,16,0> }
		triangle { <40,16,-40>, <37,16,-37>, <23,16,-37> }
		triangle { <23,16,-37>, <20,16,-40>, <40,16,-40> }
		triangle { <37,16,-3>, <23,16,-3>, <27,20,-3> }
		triangle { <27,20,-3>, <37,20,-3>, <37,16,-3> }
		triangle { <23,16,-3>, <23,16,-37>, <27,20,-37> }
		triangle { <27,20,-37>, <27,20,-3>, <23,16,-3> }
		triangle { <23,16,-37>, <37,16,-37>, <37,20,-37> }
		triangle { <37,20,-37>, <27,20,-37>, <23,16,-37> }
		triangle { <37,16,-37>, <37,16,-3>, <37,20,-3> }
		triangle { <37,20,-3>, <37,20,-37>, <37,16,-37> }
		triangle { <37,20,-3>, <27,20,-3>, <27,20,-37> }
		triangle { <27,20,-37>, <37,20,-37>, <37,20,-3> }
		triangle { <-26,16,-40>, <-9,33,-40>, <-9,51,-40> }
		triangle { <-9,51,-40>, <-26,72,-40>, <-26,16,-40> }
		triangle { <-26,16,-40>, <26,16,-40>, <9,33,-40> }
		triangle { <9,33,-40>, <-9,33,-40>, <-26,16,-40> }
		triangle { <26,16,-40>, <26,72,-40>, <9,51,-40> }
		triangle { <9,51,-40>, <9,33,-40>, <26,16,-40> }
		triangle { <-26,72,-40>, <-9,51,-40>, <9,51,-40> }
		triangle { <9,51,-40>, <26,72,-40>, <-26,72,-40> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,-30,20,-30> }
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,-30,20,-10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,30> }
		object { studel_dot_dat matrix <0,0,-1,0,1,0,1,0,0,-10,16,-30> #if (version >= 3.1) material #else texture #end { Color0 } }
		object { studel_dot_dat matrix <0,0,-1,0,1,0,1,0,0,-10,16,-10> #if (version >= 3.1) material #else texture #end { Color0 } }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { studel_dot_dat matrix <0,0,1,0,1,0,-1,0,0,10,16,-30> #if (version >= 3.1) material #else texture #end { Color0 } }
		object { studel_dot_dat matrix <0,0,1,0,1,0,-1,0,0,10,16,-10> #if (version >= 3.1) material #else texture #end { Color0 } }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,30,20,-30> }
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,30,20,-10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,30> }
	#end
	mesh {
		triangle { <-38,64,40>, <-22,64,40>, <-22,64,39> }
		triangle { <-22,64,39>, <-38,64,39>, <-38,64,40> }
		triangle { <38,64,40>, <22,64,40>, <22,64,39> }
		triangle { <22,64,39>, <38,64,39>, <38,64,40> }
	}
	object { _2_dash_4cyli_dot_dat matrix <22,0,0,0,0,-1,0,10,0,0,64,40> }
	mesh {
		triangle { <-36.1,62,40>, <-21,62,40>, <-21,62,39> }
		triangle { <-21,62,39>, <-36.1,62,39>, <-36.1,62,40> }
		triangle { <36.1,62,40>, <21,62,40>, <21,62,39> }
		triangle { <21,62,39>, <36.1,62,39>, <36.1,62,40> }
	}
	object { _2_dash_4cyli_dot_dat matrix <21,0,0,0,0,-1,0,10,0,0,62,40> }
	mesh {
		triangle { <-36.1,62,39>, <-21,62,39>, <-20,64,39> }
		triangle { <-20,64,39>, <-38,64,39>, <-36.1,62,39> }
		triangle { <36.1,62,39>, <21,62,39>, <20,64,39> }
		triangle { <20,64,39>, <38,64,39>, <36.1,62,39> }
	}
	object { _2_dash_4disc_dot_dat matrix <21,0,0,0,0,-1,0,10,0,0,62,40> }
	object { _2_dash_4disc_dot_dat matrix <22,0,0,0,0,-1,0,10,0,0,64,39> }
	mesh {
		triangle { <-36.1,5,40>, <-36.1,62,40>, <-36.1,62,39> }
		triangle { <-36.1,62,39>, <-36.1,5,39>, <-36.1,5,40> }
		triangle { <-38,5,40>, <-35,2,40>, <-35,2,39> }
		triangle { <-35,2,39>, <-38,5,39>, <-38,5,40> }
		triangle { <-35,2,40>, <-6,2,40>, <-6,2,39> }
		triangle { <-6,2,39>, <-35,2,39>, <-35,2,40> }
		triangle { <-6,2,40>, <-6,6,40>, <-6,6,39> }
		triangle { <-6,6,39>, <-6,2,39>, <-6,2,40> }
		triangle { <-38,5,40>, <-38,64,40>, <-38,64,39> }
		triangle { <-38,64,39>, <-38,5,39>, <-38,5,40> }
		triangle { <38,5,40>, <35,2,40>, <35,2,39> }
		triangle { <35,2,39>, <38,5,39>, <38,5,40> }
		triangle { <35,2,40>, <6,2,40>, <6,2,39> }
		triangle { <6,2,39>, <35,2,39>, <35,2,40> }
		triangle { <6,2,40>, <6,6,40>, <6,6,39> }
		triangle { <6,6,39>, <6,2,39>, <6,2,40> }
		triangle { <38,5,40>, <38,64,40>, <38,64,39> }
		triangle { <38,64,39>, <38,5,39>, <38,5,40> }
		triangle { <-6,6,40>, <6,6,40>, <6,6,39> }
		triangle { <6,6,39>, <-6,6,39>, <-6,6,40> }
		triangle { <-38,5,39>, <-38,64,39>, <-36.1,62,39> }
		triangle { <-36.1,62,39>, <-36.1,5,39>, <-38,5,39> }
		triangle { <38,5,39>, <38,64,39>, <36.1,62,39> }
		triangle { <36.1,62,39>, <36.1,5,39>, <38,5,39> }
		triangle { <-35,2,39>, <-38,5,39>, <-36.1,5,39> }
		triangle { <-36.1,5,39>, <-32.3,4,39>, <-35,2,39> }
		triangle { <-35,2,39>, <-32.3,4,39>, <-6,4,39> }
		triangle { <-6,4,39>, <-6,2,39>, <-35,2,39> }
		triangle { <35,2,39>, <38,5,39>, <36.1,5,39> }
		triangle { <36.1,5,39>, <32.3,4,39>, <35,2,39> }
		triangle { <35,2,39>, <32.3,4,39>, <6,4,39> }
		triangle { <6,4,39>, <6,2,39>, <35,2,39> }
		triangle { <-6,4,39>, <-9.5,4,39>, <-9.5,8,39> }
		triangle { <-9.5,8,39>, <-6,8,39>, <-6,4,39> }
		triangle { <6,4,39>, <9.5,4,39>, <9.5,8,39> }
		triangle { <9.5,8,39>, <6,8,39>, <6,4,39> }
		triangle { <-6,6,39>, <-6,8,39>, <6,8,39> }
		triangle { <6,8,39>, <6,6,39>, <-6,6,39> }
		triangle { <-28.5,20,39>, <-28.5,4,39>, <-32.3,4,39> }
		triangle { <-32.3,4,39>, <-32.3,20,39>, <-28.5,20,39> }
		triangle { <-28.5,20,39>, <-28.5,20,40>, <-32.3,20,40> }
		triangle { <-32.3,20,40>, <-32.3,20,39>, <-28.5,20,39> }
		triangle { <-32.3,20,39>, <-32.3,20,40>, <-32.3,4,40> }
		triangle { <-32.3,4,40>, <-32.3,4,39>, <-32.3,20,39> }
		triangle { <-28.5,4,39>, <-28.5,4,40>, <-28.5,20,40> }
		triangle { <-28.5,20,40>, <-28.5,20,39>, <-28.5,4,39> }
		triangle { <-32.3,20,40>, <-32.3,4,40>, <-36.1,5,40> }
		triangle { <-36.1,5,40>, <-36.1,20,40>, <-32.3,20,40> }
		triangle { <-32.3,4,39>, <-32.3,4,40>, <-36.1,5,40> }
		triangle { <-36.1,5,40>, <-36.1,5,39>, <-32.3,4,39> }
		triangle { <-20.9,20,39>, <-20.9,4,39>, <-24.7,4,39> }
		triangle { <-24.7,4,39>, <-24.7,20,39>, <-20.9,20,39> }
		triangle { <-20.9,20,39>, <-20.9,20,40>, <-24.7,20,40> }
		triangle { <-24.7,20,40>, <-24.7,20,39>, <-20.9,20,39> }
		triangle { <-24.7,20,39>, <-24.7,20,40>, <-24.7,4,40> }
		triangle { <-24.7,4,40>, <-24.7,4,39>, <-24.7,20,39> }
		triangle { <-20.9,4,39>, <-20.9,4,40>, <-20.9,20,40> }
		triangle { <-20.9,20,40>, <-20.9,20,39>, <-20.9,4,39> }
		triangle { <-24.7,20,40>, <-24.7,4,40>, <-28.5,4,40> }
		triangle { <-28.5,4,40>, <-28.5,20,40>, <-24.7,20,40> }
		triangle { <-24.7,4,39>, <-24.7,4,40>, <-28.5,4,40> }
		triangle { <-28.5,4,40>, <-28.5,4,39>, <-24.7,4,39> }
		triangle { <-13.3,18,39>, <-13.3,4,39>, <-17.1,4,39> }
		triangle { <-17.1,4,39>, <-17.1,20,39>, <-13.3,18,39> }
		triangle { <-13.3,18,39>, <-13.3,18,40>, <-17.1,20,40> }
		triangle { <-17.1,20,40>, <-17.1,20,39>, <-13.3,18,39> }
		triangle { <-17.1,20,39>, <-17.1,20,40>, <-17.1,4,40> }
		triangle { <-17.1,4,40>, <-17.1,4,39>, <-17.1,20,39> }
		triangle { <-13.3,4,39>, <-13.3,4,40>, <-13.3,18,40> }
		triangle { <-13.3,18,40>, <-13.3,18,39>, <-13.3,4,39> }
		triangle { <-17.1,20,40>, <-17.1,4,40>, <-20.9,4,40> }
		triangle { <-20.9,4,40>, <-20.9,20,40>, <-17.1,20,40> }
		triangle { <-17.1,4,39>, <-17.1,4,40>, <-20.9,4,40> }
		triangle { <-20.9,4,40>, <-20.9,4,39>, <-17.1,4,39> }
		triangle { <-5.7,16,39>, <-5.7,8,39>, <-9.5,4,39> }
		triangle { <-9.5,4,39>, <-9.5,17,39>, <-5.7,16,39> }
		triangle { <-5.7,16,39>, <-5.7,16,40>, <-9.5,17,40> }
		triangle { <-9.5,17,40>, <-9.5,17,39>, <-5.7,16,39> }
		triangle { <-9.5,17,39>, <-9.5,17,40>, <-9.5,4,40> }
		triangle { <-9.5,4,40>, <-9.5,4,39>, <-9.5,17,39> }
		triangle { <-5.7,8,39>, <-5.7,8,40>, <-5.7,16,40> }
		triangle { <-5.7,16,40>, <-5.7,16,39>, <-5.7,8,39> }
		triangle { <-9.5,17,40>, <-9.5,4,40>, <-13.3,4,40> }
		triangle { <-13.3,4,40>, <-13.3,18,40>, <-9.5,17,40> }
		triangle { <-9.5,4,39>, <-9.5,4,40>, <-13.3,4,40> }
		triangle { <-13.3,4,40>, <-13.3,4,39>, <-9.5,4,39> }
		triangle { <1.9,16,39>, <1.9,8,39>, <-1.9,8,39> }
		triangle { <-1.9,8,39>, <-1.9,16,39>, <1.9,16,39> }
		triangle { <1.9,16,39>, <1.9,16,40>, <-1.9,16,40> }
		triangle { <-1.9,16,40>, <-1.9,16,39>, <1.9,16,39> }
		triangle { <-1.9,16,39>, <-1.9,16,40>, <-1.9,8,40> }
		triangle { <-1.9,8,40>, <-1.9,8,39>, <-1.9,16,39> }
		triangle { <1.9,8,39>, <1.9,8,40>, <1.9,16,40> }
		triangle { <1.9,16,40>, <1.9,16,39>, <1.9,8,39> }
		triangle { <-1.9,16,40>, <-1.9,8,40>, <-5.7,8,40> }
		triangle { <-5.7,8,40>, <-5.7,16,40>, <-1.9,16,40> }
		triangle { <-1.9,8,39>, <-1.9,8,40>, <-5.7,8,40> }
		triangle { <-5.7,8,40>, <-5.7,8,39>, <-1.9,8,39> }
		triangle { <9.5,17,39>, <9.5,4,39>, <5.7,8,39> }
		triangle { <5.7,8,39>, <5.7,16,39>, <9.5,17,39> }
		triangle { <9.5,17,39>, <9.5,17,40>, <5.7,16,40> }
		triangle { <5.7,16,40>, <5.7,16,39>, <9.5,17,39> }
		triangle { <5.7,16,39>, <5.7,16,40>, <5.7,8,40> }
		triangle { <5.7,8,40>, <5.7,8,39>, <5.7,16,39> }
		triangle { <9.5,4,39>, <9.5,4,40>, <9.5,17,40> }
		triangle { <9.5,17,40>, <9.5,17,39>, <9.5,4,39> }
		triangle { <5.7,16,40>, <5.7,8,40>, <1.9,8,40> }
		triangle { <1.9,8,40>, <1.9,16,40>, <5.7,16,40> }
		triangle { <5.7,8,39>, <5.7,8,40>, <1.9,8,40> }
		triangle { <1.9,8,40>, <1.9,8,39>, <5.7,8,39> }
		triangle { <17.1,20,39>, <17.1,4,39>, <13.3,4,39> }
		triangle { <13.3,4,39>, <13.3,18,39>, <17.1,20,39> }
		triangle { <17.1,20,39>, <17.1,20,40>, <13.3,18,40> }
		triangle { <13.3,18,40>, <13.3,18,39>, <17.1,20,39> }
		triangle { <13.3,18,39>, <13.3,18,40>, <13.3,4,40> }
		triangle { <13.3,4,40>, <13.3,4,39>, <13.3,18,39> }
		triangle { <17.1,4,39>, <17.1,4,40>, <17.1,20,40> }
		triangle { <17.1,20,40>, <17.1,20,39>, <17.1,4,39> }
		triangle { <13.3,18,40>, <13.3,4,40>, <9.5,4,40> }
		triangle { <9.5,4,40>, <9.5,17,40>, <13.3,18,40> }
		triangle { <13.3,4,39>, <13.3,4,40>, <9.5,4,40> }
		triangle { <9.5,4,40>, <9.5,4,39>, <13.3,4,39> }
		triangle { <24.7,20,39>, <24.7,4,39>, <20.9,4,39> }
		triangle { <20.9,4,39>, <20.9,20,39>, <24.7,20,39> }
		triangle { <24.7,20,39>, <24.7,20,40>, <20.9,20,40> }
		triangle { <20.9,20,40>, <20.9,20,39>, <24.7,20,39> }
		triangle { <20.9,20,39>, <20.9,20,40>, <20.9,4,40> }
		triangle { <20.9,4,40>, <20.9,4,39>, <20.9,20,39> }
		triangle { <24.7,4,39>, <24.7,4,40>, <24.7,20,40> }
		triangle { <24.7,20,40>, <24.7,20,39>, <24.7,4,39> }
		triangle { <20.9,20,40>, <20.9,4,40>, <17.1,4,40> }
		triangle { <17.1,4,40>, <17.1,20,40>, <20.9,20,40> }
		triangle { <20.9,4,39>, <20.9,4,40>, <17.1,4,40> }
		triangle { <17.1,4,40>, <17.1,4,39>, <20.9,4,39> }
		triangle { <32.3,20,39>, <32.3,4,39>, <28.5,4,39> }
		triangle { <28.5,4,39>, <28.5,20,39>, <32.3,20,39> }
		triangle { <32.3,20,39>, <32.3,20,40>, <28.5,20,40> }
		triangle { <28.5,20,40>, <28.5,20,39>, <32.3,20,39> }
		triangle { <28.5,20,39>, <28.5,20,40>, <28.5,4,40> }
		triangle { <28.5,4,40>, <28.5,4,39>, <28.5,20,39> }
		triangle { <32.3,4,39>, <32.3,4,40>, <32.3,20,40> }
		triangle { <32.3,20,40>, <32.3,20,39>, <32.3,4,39> }
		triangle { <28.5,20,40>, <28.5,4,40>, <24.7,4,40> }
		triangle { <24.7,4,40>, <24.7,20,40>, <28.5,20,40> }
		triangle { <28.5,4,39>, <28.5,4,40>, <24.7,4,40> }
		triangle { <24.7,4,40>, <24.7,4,39>, <28.5,4,39> }
		triangle { <36.1,62,39>, <36.1,62,40>, <36.1,5,40> }
		triangle { <36.1,5,40>, <36.1,5,39>, <36.1,62,39> }
		triangle { <36.1,20,40>, <36.1,5,40>, <32.3,4,40> }
		triangle { <32.3,4,40>, <32.3,20,40>, <36.1,20,40> }
		triangle { <36.1,5,39>, <36.1,5,40>, <32.3,4,40> }
		triangle { <32.3,4,40>, <32.3,4,39>, <36.1,5,39> }
		triangle { <5.7,16,40>, <-5.7,16,40>, <-9.5,17,40> }
		triangle { <-9.5,17,40>, <9.5,17,40>, <5.7,16,40> }
		triangle { <9.5,17,40>, <13.3,18,40>, <-13.3,18,40> }
		triangle { <-13.3,18,40>, <-9.5,17,40>, <9.5,17,40> }
		triangle { <13.3,18,40>, <17.1,20,40>, <-17.1,20,40> }
		triangle { <-17.1,20,40>, <-13.3,18,40>, <13.3,18,40> }
		triangle { <36,20,40>, <-36,20,40>, <-36,62,40> }
		triangle { <-36,62,40>, <36,62,40>, <36,20,40> }
		triangle { <-4,4,40>, <-6,6,40>, <6,6,40> }
		triangle { <6,6,40>, <4,4,40>, <-4,4,40> }
		triangle { <-4,4,40>, <-6,6,40>, <-6,2,40> }
		triangle { <-6,2,40>, <-4,0,40>, <-4,4,40> }
		triangle { <-4,0,40>, <-6,2,40>, <-35,2,40> }
		triangle { <-35,2,40>, <-36,0,40>, <-4,0,40> }
		triangle { <-35,2,40>, <-36,0,40>, <-40,4,40> }
		triangle { <-40,4,40>, <-38,5,40>, <-35,2,40> }
		triangle { <-40,4,40>, <-38,5,40>, <-38,64,40> }
		triangle { <-38,64,40>, <-40,72,40>, <-40,4,40> }
		triangle { <-38,64,40>, <-40,72,40>, <-20,72,40> }
		triangle { <-20,72,40>, <-22,64,40>, <-38,64,40> }
		triangle { <4,4,40>, <6,6,40>, <6,2,40> }
		triangle { <6,2,40>, <4,0,40>, <4,4,40> }
		triangle { <4,0,40>, <6,2,40>, <35,2,40> }
		triangle { <35,2,40>, <36,0,40>, <4,0,40> }
		triangle { <35,2,40>, <36,0,40>, <40,4,40> }
		triangle { <40,4,40>, <38,5,40>, <35,2,40> }
		triangle { <40,4,40>, <38,5,40>, <38,64,40> }
		triangle { <38,64,40>, <40,72,40>, <40,4,40> }
		triangle { <38,64,40>, <40,72,40>, <20,72,40> }
		triangle { <20,72,40>, <22,64,40>, <38,64,40> }
		triangle { <22,64,40>, <20.326,67.827,40>, <18.478,73.148,40> }
		triangle { <18.478,73.148,40>, <20,72,40>, <22,64,40> }
		triangle { <20.326,67.827,40>, <15.556,71.071,40>, <14.142,74.121,40> }
		triangle { <14.142,74.121,40>, <18.478,73.148,40>, <20.326,67.827,40> }
		triangle { <15.556,71.071,40>, <8.419,73.239,40>, <7.654,74.772,40> }
		triangle { <7.654,74.772,40>, <14.142,74.121,40>, <15.556,71.071,40> }
		triangle { <8.419,73.239,40>, <0,74,40>, <0,75,40> }
		triangle { <0,75,40>, <7.654,74.772,40>, <8.419,73.239,40> }
		triangle { <-22,64,40>, <-20.326,67.827,40>, <-18.478,73.148,40> }
		triangle { <-18.478,73.148,40>, <-20,72,40>, <-22,64,40> }
		triangle { <-20.326,67.827,40>, <-15.556,71.071,40>, <-14.142,74.121,40> }
		triangle { <-14.142,74.121,40>, <-18.478,73.148,40>, <-20.326,67.827,40> }
		triangle { <-15.556,71.071,40>, <-8.419,73.239,40>, <-7.654,74.772,40> }
		triangle { <-7.654,74.772,40>, <-14.142,74.121,40>, <-15.556,71.071,40> }
		triangle { <-8.419,73.239,40>, <0,74,40>, <0,75,40> }
		triangle { <0,75,40>, <-7.654,74.772,40>, <-8.419,73.239,40> }
// 
	}
}
#end

#declare _32296_dot_dat = #if (QUAL = 0) box { <-27,-27,-10>, <27,27,10> } #else union {
// Technic Gear 20 Tooth Double Bevel
// Name: 32296.dat
// Author: Marc Klein
// Official LCAD Part - 2000-02 Update
// Created with stl2dat conversion tool
	object { _2_dash_4cyli_dot_dat matrix <0,1,0,0,0,-20,-1,0,0,-10,0,10> }
	object { _2_dash_4cyli_dot_dat matrix <1,0,0,0,0,-20,0,1,0,0,10,10> }
	object { _2_dash_4cyli_dot_dat matrix <0,-1,0,0,0,-20,1,0,0,10,0,10> }
	object { _2_dash_4cyli_dot_dat matrix <-1,0,0,0,0,-20,0,-1,0,0,-10,10> }
	object { _1_dash_4cyli_dot_dat matrix <6.51,0,0,0,0,-20,0,6.51,0,-9.513,-9.513,10> }
	object { _1_dash_4cyli_dot_dat matrix <0,6.51,0,0,0,-20,-6.51,0,0,9.513,-9.513,10> }
	object { _1_dash_4cyli_dot_dat matrix <0,-6.51,0,0,0,-20,6.51,0,0,-9.513,9.513,10> }
	object { _1_dash_4cyli_dot_dat matrix <-6.51,0,0,0,0,-20,0,-6.51,0,9.513,9.513,10> }
	mesh {
		triangle { <16.73,-3,-1>, <11.62,-3,-1>, <16.88,-2.004,-1> }
		triangle { <16.88,-2.004,-1>, <11.62,-3,-1>, <11.96,-1,-1> }
		triangle { <11.96,-1,-1>, <16.97,-1,-1>, <16.88,-2.004,-1> }
		triangle { <16.97,-1,1>, <11.96,-1,1>, <16.88,-2.004,1> }
		triangle { <16.88,-2.004,1>, <11.96,-1,1>, <11.62,-3,1> }
		triangle { <11.62,-3,1>, <16.73,-3,1>, <16.88,-2.004,1> }
		triangle { <1,-16.97,-1>, <1,-11.96,-1>, <2.004,-16.88,-1> }
		triangle { <2.004,-16.88,-1>, <1,-11.96,-1>, <3,-11.62,-1> }
		triangle { <3,-11.62,-1>, <3,-16.73,-1>, <2.004,-16.88,-1> }
		triangle { <3,-16.73,1>, <3,-11.62,1>, <2.004,-16.88,1> }
		triangle { <2.004,-16.88,1>, <3,-11.62,1>, <1,-11.96,1> }
		triangle { <1,-11.96,1>, <1,-16.97,1>, <2.004,-16.88,1> }
		triangle { <-3,-16.73,-1>, <-3,-11.62,-1>, <-2.004,-16.88,-1> }
		triangle { <-2.004,-16.88,-1>, <-3,-11.62,-1>, <-1,-11.96,-1> }
		triangle { <-1,-11.96,-1>, <-1,-16.97,-1>, <-2.004,-16.88,-1> }
		triangle { <-1,-16.97,1>, <-1,-11.96,1>, <-2.004,-16.88,1> }
		triangle { <-2.004,-16.88,1>, <-1,-11.96,1>, <-3,-11.62,1> }
		triangle { <-3,-11.62,1>, <-3,-16.73,1>, <-2.004,-16.88,1> }
		triangle { <-16.97,-1,-1>, <-11.96,-1,-1>, <-16.88,-2.004,-1> }
		triangle { <-16.88,-2.004,-1>, <-11.96,-1,-1>, <-11.62,-3,-1> }
		triangle { <-11.62,-3,-1>, <-16.73,-3,-1>, <-16.88,-2.004,-1> }
		triangle { <-16.73,-3,1>, <-11.62,-3,1>, <-16.88,-2.004,1> }
		triangle { <-16.88,-2.004,1>, <-11.62,-3,1>, <-11.96,-1,1> }
		triangle { <-11.96,-1,1>, <-16.97,-1,1>, <-16.88,-2.004,1> }
		triangle { <-16.73,3,-1>, <-11.62,3,-1>, <-16.88,2.004,-1> }
		triangle { <-16.88,2.004,-1>, <-11.62,3,-1>, <-11.96,1,-1> }
		triangle { <-11.96,1,-1>, <-16.97,1,-1>, <-16.88,2.004,-1> }
		triangle { <-16.97,1,1>, <-11.96,1,1>, <-16.88,2.004,1> }
		triangle { <-16.88,2.004,1>, <-11.96,1,1>, <-11.62,3,1> }
		triangle { <-11.62,3,1>, <-16.73,3,1>, <-16.88,2.004,1> }
		triangle { <-1,16.97,-1>, <-1,11.96,-1>, <-2.004,16.88,-1> }
		triangle { <-2.004,16.88,-1>, <-1,11.96,-1>, <-3,11.62,-1> }
		triangle { <-3,11.62,-1>, <-3,16.73,-1>, <-2.004,16.88,-1> }
		triangle { <-3,16.73,1>, <-3,11.62,1>, <-2.004,16.88,1> }
		triangle { <-2.004,16.88,1>, <-3,11.62,1>, <-1,11.96,1> }
		triangle { <-1,11.96,1>, <-1,16.97,1>, <-2.004,16.88,1> }
		triangle { <3,16.73,-1>, <3,11.62,-1>, <2.004,16.88,-1> }
		triangle { <2.004,16.88,-1>, <3,11.62,-1>, <1,11.96,-1> }
		triangle { <1,11.96,-1>, <1,16.97,-1>, <2.004,16.88,-1> }
		triangle { <1,16.97,1>, <1,11.96,1>, <2.004,16.88,1> }
		triangle { <2.004,16.88,1>, <1,11.96,1>, <3,11.62,1> }
		triangle { <3,11.62,1>, <3,16.73,1>, <2.004,16.88,1> }
		triangle { <16.97,1,-1>, <11.96,1,-1>, <16.88,2.004,-1> }
		triangle { <16.88,2.004,-1>, <11.96,1,-1>, <11.62,3,-1> }
		triangle { <11.62,3,-1>, <16.73,3,-1>, <16.88,2.004,-1> }
		triangle { <16.73,3,1>, <11.62,3,1>, <16.88,2.004,1> }
		triangle { <16.88,2.004,1>, <11.62,3,1>, <11.96,1,1> }
		triangle { <11.96,1,1>, <16.97,1,1>, <16.88,2.004,1> }
		triangle { <3,9.513,-10>, <3,11.62,-10>, <3,11.62,-1> }
		triangle { <3,11.62,-1>, <3,9.513,10>, <3,9.513,-10> }
		triangle { <3,9.513,10>, <3,11.62,-1>, <3,11.62,1> }
		triangle { <3,11.62,1>, <3,11.62,-1>, <3,16.73,-1> }
		triangle { <3,16.73,-1>, <3,16.73,1>, <3,11.62,1> }
		triangle { <3,11.62,1>, <3,11.62,10>, <3,9.513,10> }
		triangle { <11.62,3,10>, <11.62,3,1>, <9.513,3,10> }
		triangle { <9.513,3,10>, <11.62,3,1>, <11.62,3,-1> }
		triangle { <9.513,3,10>, <11.62,3,-1>, <11.62,3,-10> }
		triangle { <11.62,3,-10>, <9.513,3,-10>, <9.513,3,10> }
		triangle { <11.62,3,-1>, <11.62,3,1>, <16.73,3,1> }
		triangle { <16.73,3,1>, <16.73,3,-1>, <11.62,3,-1> }
		triangle { <-9.513,3,-10>, <-11.62,3,-10>, <-11.62,3,-1> }
		triangle { <-11.62,3,-1>, <-9.513,3,10>, <-9.513,3,-10> }
		triangle { <-9.513,3,10>, <-11.62,3,-1>, <-11.62,3,1> }
		triangle { <-11.62,3,1>, <-11.62,3,-1>, <-16.73,3,-1> }
		triangle { <-16.73,3,-1>, <-16.73,3,1>, <-11.62,3,1> }
		triangle { <-11.62,3,1>, <-11.62,3,10>, <-9.513,3,10> }
		triangle { <-3,11.62,10>, <-3,11.62,1>, <-3,9.513,10> }
		triangle { <-3,9.513,10>, <-3,11.62,1>, <-3,11.62,-1> }
		triangle { <-3,9.513,10>, <-3,11.62,-1>, <-3,11.62,-10> }
		triangle { <-3,11.62,-10>, <-3,9.513,-10>, <-3,9.513,10> }
		triangle { <-3,11.62,-1>, <-3,11.62,1>, <-3,16.73,1> }
		triangle { <-3,16.73,1>, <-3,16.73,-1>, <-3,11.62,-1> }
		triangle { <3,-11.62,10>, <3,-11.62,1>, <3,-9.513,10> }
		triangle { <3,-9.513,10>, <3,-11.62,1>, <3,-11.62,-1> }
		triangle { <3,-9.513,10>, <3,-11.62,-1>, <3,-11.62,-10> }
		triangle { <3,-11.62,-10>, <3,-9.513,-10>, <3,-9.513,10> }
		triangle { <3,-11.62,-1>, <3,-11.62,1>, <3,-16.73,1> }
		triangle { <3,-16.73,1>, <3,-16.73,-1>, <3,-11.62,-1> }
		triangle { <9.513,-3,-10>, <11.62,-3,-10>, <11.62,-3,-1> }
		triangle { <11.62,-3,-1>, <9.513,-3,10>, <9.513,-3,-10> }
		triangle { <9.513,-3,10>, <11.62,-3,-1>, <11.62,-3,1> }
		triangle { <11.62,-3,1>, <11.62,-3,-1>, <16.73,-3,-1> }
		triangle { <16.73,-3,-1>, <16.73,-3,1>, <11.62,-3,1> }
		triangle { <11.62,-3,1>, <11.62,-3,10>, <9.513,-3,10> }
		triangle { <-3,-9.513,-10>, <-3,-11.62,-10>, <-3,-11.62,-1> }
		triangle { <-3,-11.62,-1>, <-3,-9.513,10>, <-3,-9.513,-10> }
		triangle { <-3,-9.513,10>, <-3,-11.62,-1>, <-3,-11.62,1> }
		triangle { <-3,-11.62,1>, <-3,-11.62,-1>, <-3,-16.73,-1> }
		triangle { <-3,-16.73,-1>, <-3,-16.73,1>, <-3,-11.62,1> }
		triangle { <-3,-11.62,1>, <-3,-11.62,10>, <-3,-9.513,10> }
		triangle { <-11.62,-3,10>, <-11.62,-3,1>, <-9.513,-3,10> }
		triangle { <-9.513,-3,10>, <-11.62,-3,1>, <-11.62,-3,-1> }
		triangle { <-9.513,-3,10>, <-11.62,-3,-1>, <-11.62,-3,-10> }
		triangle { <-11.62,-3,-10>, <-9.513,-3,-10>, <-9.513,-3,10> }
		triangle { <-11.62,-3,-1>, <-11.62,-3,1>, <-16.73,-3,1> }
		triangle { <-16.73,-3,1>, <-16.73,-3,-1>, <-11.62,-3,-1> }
		triangle { <3.496,-7.021,-10>, <0.7071,-10.71,-10>, <4.908,-4.908,-10> }
		triangle { <4.908,-4.908,-10>, <0.7071,-10.71,-10>, <0.9239,-10.38,-10> }
		triangle { <4.908,-4.908,-10>, <0.9239,-10.38,-10>, <2.296,-5.543,-10> }
		triangle { <2.296,-5.543,-10>, <0.9239,-10.38,-10>, <1,-10,-10> }
		triangle { <2.296,-5.543,-10>, <1,-10,-10>, <1,-5.801,-10> }
		triangle { <4.908,-4.908,-10>, <2.296,-5.543,-10>, <7.021,-3.496,-10> }
		triangle { <7.021,-3.496,-10>, <2.296,-5.543,-10>, <3.597,-4.803,-10> }
		triangle { <7.021,-3.496,-10>, <3.597,-4.803,-10>, <11.96,-1,-10> }
		triangle { <11.96,-1,-10>, <3.597,-4.803,-10>, <4.803,-3.597,-10> }
		triangle { <11.96,-1,-10>, <4.803,-3.597,-10>, <5.543,-2.296,-10> }
		triangle { <5.543,-2.296,-10>, <10.38,-0.9239,-10>, <11.96,-1,-10> }
		triangle { <10.38,-0.9239,-10>, <5.543,-2.296,-10>, <10,-1,-10> }
		triangle { <10,-1,-10>, <5.543,-2.296,-10>, <5.801,-1,-10> }
		triangle { <3.496,-7.021,-10>, <3,-9.513,-10>, <0.7071,-10.71,-10> }
		triangle { <0.7071,-10.71,-10>, <3,-9.513,-10>, <3,-11.62,-10> }
		triangle { <0.7071,-10.71,-10>, <3,-11.62,-10>, <1,-11.96,-10> }
		triangle { <1,-11.96,-10>, <0.3827,-10.92,-10>, <0.7071,-10.71,-10> }
		triangle { <0.3827,-10.92,-10>, <1,-11.96,-10>, <-1,-16.97,-10> }
		triangle { <-1,-16.97,-10>, <0,-11,-10>, <0.3827,-10.92,-10> }
		triangle { <-1,-16.97,-10>, <1,-11.96,-10>, <1,-16.97,-10> }
		triangle { <1,-16.97,-10>, <-1.582,-19.87,-10>, <-1,-16.97,-10> }
		triangle { <-1,-16.97,-10>, <-1.582,-19.87,-10>, <-6.965,-15.51,-10> }
		triangle { <-6.965,-15.51,-10>, <-1.582,-19.87,-10>, <-4.637,-19.39,-10> }
		triangle { <-4.637,-19.39,-10>, <-15.15,-12.96,-10>, <-6.965,-15.51,-10> }
		triangle { <-6.965,-15.51,-10>, <-15.15,-12.96,-10>, <-12.02,-12.02,-10> }
		triangle { <-12.02,-12.02,-10>, <-15.15,-12.96,-10>, <-15.51,-6.965,-10> }
		triangle { <10.92,-0.3827,-10>, <11,0,-10>, <16.97,-1,-10> }
		triangle { <16.97,-1,-10>, <11,0,-10>, <10.92,0.3827,-10> }
		triangle { <16.97,-1,-10>, <10.92,0.3827,-10>, <11.96,1,-10> }
		triangle { <11.96,1,-10>, <16.97,1,-10>, <16.97,-1,-10> }
		triangle { <11.96,1,-10>, <10.92,0.3827,-10>, <10.71,0.7071,-10> }
		triangle { <10.71,0.7071,-10>, <11.62,3,-10>, <11.96,1,-10> }
		triangle { <11.62,3,-10>, <10.71,0.7071,-10>, <10.38,0.9239,-10> }
		triangle { <10.38,0.9239,-10>, <9.513,3,-10>, <11.62,3,-10> }
		triangle { <9.513,3,-10>, <10.38,0.9239,-10>, <10,1,-10> }
		triangle { <10,1,-10>, <7.021,3.496,-10>, <9.513,3,-10> }
		triangle { <7.021,3.496,-10>, <10,1,-10>, <5.828,1,-10> }
		triangle { <5.828,1,-10>, <5.657,2,-10>, <7.021,3.496,-10> }
		triangle { <0,11,-10>, <-0.3827,10.92,-10>, <-3,11.62,-10> }
		triangle { <-3,11.62,-10>, <-0.3827,10.92,-10>, <-3,9.513,-10> }
		triangle { <-3,9.513,-10>, <-0.3827,10.92,-10>, <-0.7071,10.71,-10> }
		triangle { <-3,9.513,-10>, <-0.7071,10.71,-10>, <-3.496,7.021,-10> }
		triangle { <-3.496,7.021,-10>, <-0.7071,10.71,-10>, <-4.908,4.908,-10> }
		triangle { <-19.87,-1.582,-10>, <-23,0,-10>, <-16.97,-1,-10> }
		triangle { <-16.97,-1,-10>, <-23,0,-10>, <-11,0,-10> }
		triangle { <-16.97,-1,-10>, <-11,0,-10>, <-10.92,-0.3827,-10> }
		triangle { <-10.92,-0.3827,-10>, <-11.96,-1,-10>, <-16.97,-1,-10> }
		triangle { <-11.96,-1,-10>, <-10.92,-0.3827,-10>, <-10.71,-0.7071,-10> }
		triangle { <-10.71,-0.7071,-10>, <-11.62,-3,-10>, <-11.96,-1,-10> }
		triangle { <-11.62,-3,-10>, <-10.71,-0.7071,-10>, <-10.38,-0.9239,-10> }
		triangle { <-10.38,-0.9239,-10>, <-9.513,-3,-10>, <-11.62,-3,-10> }
		triangle { <-9.513,-3,-10>, <-10.38,-0.9239,-10>, <-10,-1,-10> }
		triangle { <-10,-1,-10>, <-7.021,-3.496,-10>, <-9.513,-3,-10> }
		triangle { <-7.021,-3.496,-10>, <-10,-1,-10>, <-4.908,-4.908,-10> }
		triangle { <-4.908,-4.908,-10>, <-10,-1,-10>, <-5.657,-2,-10> }
		triangle { <-4.908,-4.908,-10>, <-5.657,-2,-10>, <-2,-2,-10> }
		triangle { <3,11.62,-10>, <3,9.513,-10>, <2,2,-10> }
		triangle { <2,2,-10>, <3,9.513,-10>, <3.496,7.021,-10> }
		triangle { <2,2,-10>, <3.496,7.021,-10>, <4.908,4.908,-10> }
		triangle { <4.908,4.908,-10>, <5.657,2,-10>, <2,2,-10> }
		triangle { <5.657,2,-10>, <4.908,4.908,-10>, <7.021,3.496,-10> }
		triangle { <-4.908,4.908,-10>, <-0.9239,10.38,-10>, <-2.296,5.543,-10> }
		triangle { <-2.296,5.543,-10>, <-0.9239,10.38,-10>, <-1,10,-10> }
		triangle { <-2.296,5.543,-10>, <-1,10,-10>, <-1,5.801,-10> }
		triangle { <-4.803,3.597,-10>, <-10,1,-10>, <-3.597,4.803,-10> }
		triangle { <-3.597,4.803,-10>, <-10,1,-10>, <-10.38,0.9239,-10> }
		triangle { <-10.38,0.9239,-10>, <-11.96,1,-10>, <-3.597,4.803,-10> }
		triangle { <-3.597,4.803,-10>, <-11.96,1,-10>, <-2.296,5.543,-10> }
		triangle { <-2.296,5.543,-10>, <-11.96,1,-10>, <-7.021,3.496,-10> }
		triangle { <-2.296,5.543,-10>, <-7.021,3.496,-10>, <-4.908,4.908,-10> }
		triangle { <-19.87,-1.582,-10>, <-16.97,-1,-10>, <-19.39,-4.637,-10> }
		triangle { <-19.39,-4.637,-10>, <-16.97,-1,-10>, <-17.01,-10.4,-10> }
		triangle { <-17.01,-10.4,-10>, <-18.41,-7.646,-10>, <-19.39,-4.637,-10> }
		triangle { <-19.39,-4.637,-10>, <-18.41,-7.646,-10>, <-21.87,-7.107,-10> }
		triangle { <16.97,-1,-10>, <16.97,1,-10>, <19.39,4.637,-10> }
		triangle { <16.97,-1,-10>, <19.39,4.637,-10>, <19.39,-4.637,-10> }
		triangle { <19.39,-4.637,-10>, <15.51,-6.965,-10>, <16.97,-1,-10> }
		triangle { <15.51,-6.965,-10>, <19.39,-4.637,-10>, <21.87,-7.107,-10> }
		triangle { <21.87,-7.107,-10>, <18.41,-7.646,-10>, <15.51,-6.965,-10> }
		triangle { <15.51,-6.965,-10>, <18.41,-7.646,-10>, <17.01,-10.4,-10> }
		triangle { <17.01,-10.4,-10>, <12.02,-12.02,-10>, <15.51,-6.965,-10> }
		triangle { <12.02,-12.02,-10>, <17.01,-10.4,-10>, <18.61,-13.52,-10> }
		triangle { <-7.021,3.496,-10>, <-11.96,1,-10>, <-9.513,3,-10> }
		triangle { <-9.513,3,-10>, <-11.96,1,-10>, <-11.62,3,-10> }
		triangle { <0.3827,10.92,-10>, <-3,11.62,-10>, <3,11.62,-10> }
		triangle { <3,11.62,-10>, <-3,11.62,-10>, <-1,11.96,-10> }
		triangle { <-1,11.96,-10>, <1,11.96,-10>, <3,11.62,-10> }
		triangle { <1,11.96,-10>, <-1,11.96,-10>, <-1,16.97,-10> }
		triangle { <1,11.96,-10>, <-1,16.97,-10>, <-1.582,19.87,-10> }
		triangle { <-1.582,19.87,-10>, <1,16.97,-10>, <1,11.96,-10> }
		triangle { <1,16.97,-10>, <-1.582,19.87,-10>, <0,23,-10> }
		triangle { <0,23,-10>, <1.582,19.87,-10>, <1,16.97,-10> }
		triangle { <1,5.828,-10>, <1,10,-10>, <2,5.657,-10> }
		triangle { <2,5.657,-10>, <1,10,-10>, <0.9239,10.38,-10> }
		triangle { <2,5.657,-10>, <0.9239,10.38,-10>, <3,11.62,-10> }
		triangle { <3,11.62,-10>, <0.9239,10.38,-10>, <0.7071,10.71,-10> }
		triangle { <3,11.62,-10>, <0.7071,10.71,-10>, <0.3827,10.92,-10> }
		triangle { <-4.908,-4.908,-10>, <-2,-2,-10>, <-2,-5.657,-10> }
		triangle { <-2,-5.657,-10>, <-3.496,-7.021,-10>, <-4.908,-4.908,-10> }
		triangle { <-3.496,-7.021,-10>, <-2,-5.657,-10>, <-1,-11.96,-10> }
		triangle { <-1,-11.96,-10>, <-3,-9.513,-10>, <-3.496,-7.021,-10> }
		triangle { <-1,-11.96,-10>, <-2,-5.657,-10>, <-0.9239,-10.38,-10> }
		triangle { <-1,-11.96,-10>, <-0.9239,-10.38,-10>, <-1,-16.97,-10> }
		triangle { <-1,-16.97,-10>, <-0.9239,-10.38,-10>, <-0.7071,-10.71,-10> }
		triangle { <-1,-16.97,-10>, <-0.7071,-10.71,-10>, <-0.3827,-10.92,-10> }
		triangle { <11.96,-1,-10>, <10.38,-0.9239,-10>, <16.97,-1,-10> }
		triangle { <16.97,-1,-10>, <10.38,-0.9239,-10>, <10.71,-0.7071,-10> }
		triangle { <16.97,-1,-10>, <10.71,-0.7071,-10>, <10.92,-0.3827,-10> }
		triangle { <11.62,-3,-10>, <9.513,-3,-10>, <11.96,-1,-10> }
		triangle { <11.96,-1,-10>, <9.513,-3,-10>, <7.021,-3.496,-10> }
		triangle { <12.02,-12.02,-10>, <15.15,-12.96,-10>, <6.965,-15.51,-10> }
		triangle { <6.965,-15.51,-10>, <15.15,-12.96,-10>, <1.582,-19.87,-10> }
		triangle { <6.965,-15.51,-10>, <1.582,-19.87,-10>, <1,-16.97,-10> }
		triangle { <1,-16.97,-10>, <1.582,-19.87,-10>, <0,-23,-10> }
		triangle { <0,-23,-10>, <-1.582,-19.87,-10>, <1,-16.97,-10> }
		triangle { <-13.52,-18.61,-10>, <-12.96,-15.15,-10>, <-10.4,-17.01,-10> }
		triangle { <-10.4,-17.01,-10>, <-12.96,-15.15,-10>, <-15.15,-12.96,-10> }
		triangle { <-10.4,-17.01,-10>, <-15.15,-12.96,-10>, <-4.637,-19.39,-10> }
		triangle { <-4.637,-19.39,-10>, <-7.646,-18.41,-10>, <-10.4,-17.01,-10> }
		triangle { <-7.646,-18.41,-10>, <-4.637,-19.39,-10>, <-7.107,-21.87,-10> }
		triangle { <-18.61,-13.52,-10>, <-17.01,-10.4,-10>, <-15.15,-12.96,-10> }
		triangle { <-15.15,-12.96,-10>, <-17.01,-10.4,-10>, <-16.97,-1,-10> }
		triangle { <-16.97,-1,-10>, <-15.51,-6.965,-10>, <-15.15,-12.96,-10> }
		triangle { <21.87,7.107,-10>, <19.39,4.637,-10>, <18.41,7.646,-10> }
		triangle { <18.41,7.646,-10>, <19.39,4.637,-10>, <16.97,1,-10> }
		triangle { <16.97,1,-10>, <17.01,10.4,-10>, <18.41,7.646,-10> }
		triangle { <17.01,10.4,-10>, <16.97,1,-10>, <15.51,6.965,-10> }
		triangle { <15.51,6.965,-10>, <15.15,12.96,-10>, <17.01,10.4,-10> }
		triangle { <17.01,10.4,-10>, <15.15,12.96,-10>, <18.61,13.52,-10> }
		triangle { <-1,16.97,-10>, <-6.965,15.51,-10>, <-1.582,19.87,-10> }
		triangle { <-1.582,19.87,-10>, <-6.965,15.51,-10>, <-15.15,12.96,-10> }
		triangle { <-15.15,12.96,-10>, <-4.637,19.39,-10>, <-1.582,19.87,-10> }
		triangle { <-4.637,19.39,-10>, <-15.15,12.96,-10>, <-10.4,17.01,-10> }
		triangle { <-10.4,17.01,-10>, <-7.646,18.41,-10>, <-4.637,19.39,-10> }
		triangle { <-1,-5.828,-10>, <-1,-10,-10>, <-2,-5.657,-10> }
		triangle { <-2,-5.657,-10>, <-1,-10,-10>, <-0.9239,-10.38,-10> }
		triangle { <23,0,-10>, <19.87,-1.582,-10>, <19.87,1.582,-10> }
		triangle { <19.87,1.582,-10>, <19.87,-1.582,-10>, <19.39,-4.637,-10> }
		triangle { <19.39,-4.637,-10>, <19.39,4.637,-10>, <19.87,1.582,-10> }
		triangle { <-13.52,18.61,-10>, <-10.4,17.01,-10>, <-12.96,15.15,-10> }
		triangle { <-12.96,15.15,-10>, <-10.4,17.01,-10>, <-15.15,12.96,-10> }
		triangle { <-11,0,-10>, <-23,0,-10>, <-16.97,1,-10> }
		triangle { <-16.97,1,-10>, <-10.92,0.3827,-10>, <-11,0,-10> }
		triangle { <-16.97,1,-10>, <-23,0,-10>, <-19.87,1.582,-10> }
		triangle { <-16.97,1,-10>, <-19.87,1.582,-10>, <-15.51,6.965,-10> }
		triangle { <-15.51,6.965,-10>, <-19.87,1.582,-10>, <-19.39,4.637,-10> }
		triangle { <-19.39,4.637,-10>, <-17.01,10.4,-10>, <-15.51,6.965,-10> }
		triangle { <-15.51,6.965,-10>, <-17.01,10.4,-10>, <-12.02,12.02,-10> }
		triangle { <-12.02,12.02,-10>, <-17.01,10.4,-10>, <-18.61,13.52,-10> }
		triangle { <-12.02,12.02,-10>, <-18.61,13.52,-10>, <-15.15,12.96,-10> }
		triangle { <12.02,12.02,-10>, <6.965,15.51,-10>, <1.582,19.87,-10> }
		triangle { <1.582,19.87,-10>, <6.965,15.51,-10>, <1,16.97,-10> }
		triangle { <-0.3827,-10.92,-10>, <0,-11,-10>, <-1,-16.97,-10> }
		triangle { <12.96,-15.15,-10>, <10.4,-17.01,-10>, <4.637,-19.39,-10> }
		triangle { <4.637,-19.39,-10>, <10.4,-17.01,-10>, <7.646,-18.41,-10> }
		triangle { <4.637,-19.39,-10>, <7.646,-18.41,-10>, <7.107,-21.87,-10> }
		triangle { <12.96,-15.15,-10>, <4.637,-19.39,-10>, <1.582,-19.87,-10> }
		triangle { <1.582,-19.87,-10>, <15.15,-12.96,-10>, <12.96,-15.15,-10> }
		triangle { <-3,-11.62,-10>, <-3,-9.513,-10>, <-1,-11.96,-10> }
		triangle { <-10.71,0.7071,-10>, <-16.97,1,-10>, <-10.38,0.9239,-10> }
		triangle { <-10.38,0.9239,-10>, <-16.97,1,-10>, <-11.96,1,-10> }
		triangle { <15.51,6.965,-10>, <12.02,12.02,-10>, <15.15,12.96,-10> }
		triangle { <15.15,12.96,-10>, <12.02,12.02,-10>, <1.582,19.87,-10> }
		triangle { <1.582,19.87,-10>, <4.637,19.39,-10>, <15.15,12.96,-10> }
		triangle { <13.52,18.61,-10>, <12.96,15.15,-10>, <10.4,17.01,-10> }
		triangle { <10.4,17.01,-10>, <12.96,15.15,-10>, <15.15,12.96,-10> }
		triangle { <10.4,17.01,-10>, <15.15,12.96,-10>, <4.637,19.39,-10> }
		triangle { <4.637,19.39,-10>, <7.646,18.41,-10>, <10.4,17.01,-10> }
		triangle { <7.646,18.41,-10>, <4.637,19.39,-10>, <7.107,21.87,-10> }
		triangle { <-5.801,1,-10>, <-10,1,-10>, <-5.543,2.296,-10> }
		triangle { <-5.543,2.296,-10>, <-10,1,-10>, <-4.803,3.597,-10> }
		triangle { <-21.87,7.107,-10>, <-18.41,7.646,-10>, <-19.39,4.637,-10> }
		triangle { <-19.39,4.637,-10>, <-18.41,7.646,-10>, <-17.01,10.4,-10> }
		triangle { <-10.92,0.3827,-10>, <-16.97,1,-10>, <-10.71,0.7071,-10> }
		triangle { <-4.908,4.908,-10>, <-0.7071,10.71,-10>, <-0.9239,10.38,-10> }
		triangle { <12.02,-12.02,-10>, <18.61,-13.52,-10>, <15.15,-12.96,-10> }
		triangle { <-10,-1,-10>, <-5.828,-1,-10>, <-5.657,-2,-10> }
		triangle { <-6.965,15.51,-10>, <-12.02,12.02,-10>, <-15.15,12.96,-10> }
		triangle { <3.597,-4.803,-10>, <2.5,-2.5,-10>, <4.803,-3.597,-10> }
		triangle { <12.96,-15.15,-10>, <13.52,-18.61,-10>, <10.4,-17.01,-10> }
		triangle { <3,11.62,-10>, <2,2,-10>, <2,5.657,-10> }
		triangle { <-7.646,18.41,-10>, <-7.107,21.87,-10>, <-4.637,19.39,-10> }
		triangle { <-3.597,4.803,-10>, <-2.5,2.5,-10>, <-4.803,3.597,-10> }
		triangle { <-1,5.801,10>, <-1,10,10>, <-2.296,5.543,10> }
		triangle { <-2.296,5.543,10>, <-1,10,10>, <-3,9.513,10> }
		triangle { <-3,9.513,10>, <-3.597,4.803,10>, <-2.296,5.543,10> }
		triangle { <-3.597,4.803,10>, <-3,9.513,10>, <-3.496,7.021,10> }
		triangle { <-3.597,4.803,10>, <-3.496,7.021,10>, <-4.803,3.597,10> }
		triangle { <-4.803,3.597,10>, <-3.496,7.021,10>, <-5.543,2.296,10> }
		triangle { <-3,9.513,10>, <-1,10,10>, <-0.9239,10.38,10> }
		triangle { <-0.9239,10.38,10>, <-3,11.62,10>, <-3,9.513,10> }
		triangle { <-3,11.62,10>, <-0.9239,10.38,10>, <-0.7071,10.71,10> }
		triangle { <-0.7071,10.71,10>, <-1,11.96,10>, <-3,11.62,10> }
		triangle { <-1,11.96,10>, <-0.7071,10.71,10>, <-0.3827,10.92,10> }
		triangle { <-3,-9.513,10>, <-0.7071,-10.71,10>, <-3.496,-7.021,10> }
		triangle { <-3.496,-7.021,10>, <-0.7071,-10.71,10>, <-0.9239,-10.38,10> }
		triangle { <-3.496,-7.021,10>, <-0.9239,-10.38,10>, <-1,-10,10> }
		triangle { <4.908,4.908,10>, <2,2,10>, <5.657,2,10> }
		triangle { <5.657,2,10>, <7.021,3.496,10>, <4.908,4.908,10> }
		triangle { <7.021,3.496,10>, <5.657,2,10>, <11.96,1,10> }
		triangle { <11.96,1,10>, <9.513,3,10>, <7.021,3.496,10> }
		triangle { <11.96,1,10>, <5.657,2,10>, <10.38,0.9239,10> }
		triangle { <11.96,1,10>, <10.38,0.9239,10>, <16.97,1,10> }
		triangle { <16.97,1,10>, <10.38,0.9239,10>, <10.71,0.7071,10> }
		triangle { <16.97,1,10>, <10.71,0.7071,10>, <10.92,0.3827,10> }
		triangle { <-0.3827,10.92,10>, <0,11,10>, <-1,11.96,10> }
		triangle { <-1,11.96,10>, <0,11,10>, <0.3827,10.92,10> }
		triangle { <0.3827,10.92,10>, <-1,16.97,10>, <-1,11.96,10> }
		triangle { <-1,16.97,10>, <0.3827,10.92,10>, <0.7071,10.71,10> }
		triangle { <-1,16.97,10>, <0.7071,10.71,10>, <0.9239,10.38,10> }
		triangle { <0.9239,10.38,10>, <1,11.96,10>, <-1,16.97,10> }
		triangle { <18.61,-13.52,10>, <12.02,-12.02,10>, <15.15,-12.96,10> }
		triangle { <15.15,-12.96,10>, <12.02,-12.02,10>, <6.965,-15.51,10> }
		triangle { <15.15,-12.96,10>, <6.965,-15.51,10>, <1.582,-19.87,10> }
		triangle { <1.582,-19.87,10>, <4.637,-19.39,10>, <15.15,-12.96,10> }
		triangle { <1.582,-19.87,10>, <6.965,-15.51,10>, <1,-16.97,10> }
		triangle { <1.582,-19.87,10>, <1,-16.97,10>, <-1,-11.96,10> }
		triangle { <-1,-11.96,10>, <-1,-16.97,10>, <1.582,-19.87,10> }
		triangle { <-1,-11.96,10>, <1,-16.97,10>, <0,-11,10> }
		triangle { <0,-11,10>, <-0.3827,-10.92,10>, <-1,-11.96,10> }
		triangle { <-1,-11.96,10>, <-0.3827,-10.92,10>, <-0.7071,-10.71,10> }
		triangle { <-0.7071,-10.71,10>, <-3,-11.62,10>, <-1,-11.96,10> }
		triangle { <-3,-11.62,10>, <-0.7071,-10.71,10>, <-3,-9.513,10> }
		triangle { <1,11.96,10>, <0.9239,10.38,10>, <1,10,10> }
		triangle { <1,10,10>, <3,11.62,10>, <1,11.96,10> }
		triangle { <3,11.62,10>, <1,10,10>, <1,5.828,10> }
		triangle { <1,5.828,10>, <2,5.657,10>, <3,11.62,10> }
		triangle { <3,11.62,10>, <2,5.657,10>, <3,9.513,10> }
		triangle { <3,9.513,10>, <2,5.657,10>, <2,2,10> }
		triangle { <2,2,10>, <3.496,7.021,10>, <3,9.513,10> }
		triangle { <3.496,7.021,10>, <2,2,10>, <4.908,4.908,10> }
		triangle { <-10.92,-0.3827,10>, <-11,0,10>, <-16.97,-1,10> }
		triangle { <-16.97,-1,10>, <-11,0,10>, <-10.92,0.3827,10> }
		triangle { <-16.97,-1,10>, <-10.92,0.3827,10>, <-11.96,1,10> }
		triangle { <-11.96,1,10>, <-16.97,1,10>, <-16.97,-1,10> }
		triangle { <-11.96,1,10>, <-10.92,0.3827,10>, <-10.71,0.7071,10> }
		triangle { <-10.71,0.7071,10>, <-11.62,3,10>, <-11.96,1,10> }
		triangle { <-11.62,3,10>, <-10.71,0.7071,10>, <-10.38,0.9239,10> }
		triangle { <-10.38,0.9239,10>, <-9.513,3,10>, <-11.62,3,10> }
		triangle { <-9.513,3,10>, <-10.38,0.9239,10>, <-10,1,10> }
		triangle { <-10,1,10>, <-7.021,3.496,10>, <-9.513,3,10> }
		triangle { <-7.021,3.496,10>, <-10,1,10>, <-5.801,1,10> }
		triangle { <-5.801,1,10>, <-5.543,2.296,10>, <-7.021,3.496,10> }
		triangle { <-4.908,4.908,10>, <-5.543,2.296,10>, <-3.496,7.021,10> }
		triangle { <-1,-10,10>, <-1,-5.828,10>, <-2,-5.657,10> }
		triangle { <-2,-5.657,10>, <-3.496,-7.021,10>, <-1,-10,10> }
		triangle { <-3.496,-7.021,10>, <-2,-5.657,10>, <-4.908,-4.908,10> }
		triangle { <-4.908,-4.908,10>, <-2,-5.657,10>, <-7.021,-3.496,10> }
		triangle { <5.828,1,10>, <10,1,10>, <5.657,2,10> }
		triangle { <5.657,2,10>, <10,1,10>, <10.38,0.9239,10> }
		triangle { <-16.97,-1,10>, <-16.97,1,10>, <-19.39,4.637,10> }
		triangle { <-16.97,-1,10>, <-19.39,4.637,10>, <-19.39,-4.637,10> }
		triangle { <-19.39,-4.637,10>, <-15.51,-6.965,10>, <-16.97,-1,10> }
		triangle { <-15.51,-6.965,10>, <-19.39,-4.637,10>, <-21.87,-7.107,10> }
		triangle { <-21.87,-7.107,10>, <-18.41,-7.646,10>, <-15.51,-6.965,10> }
		triangle { <-2,-5.657,10>, <-2,-2,10>, <-5.657,-2,10> }
		triangle { <-5.657,-2,10>, <-7.021,-3.496,10>, <-2,-5.657,10> }
		triangle { <-7.021,-3.496,10>, <-5.657,-2,10>, <-11.96,-1,10> }
		triangle { <-11.96,-1,10>, <-9.513,-3,10>, <-7.021,-3.496,10> }
		triangle { <-11.96,-1,10>, <-5.657,-2,10>, <-10.38,-0.9239,10> }
		triangle { <-11.96,-1,10>, <-10.38,-0.9239,10>, <-16.97,-1,10> }
		triangle { <-16.97,-1,10>, <-10.38,-0.9239,10>, <-10.71,-0.7071,10> }
		triangle { <-16.97,-1,10>, <-10.71,-0.7071,10>, <-10.92,-0.3827,10> }
		triangle { <11.62,-3,10>, <11.96,-1,10>, <11,0,10> }
		triangle { <11,0,10>, <10.92,-0.3827,10>, <11.62,-3,10> }
		triangle { <11,0,10>, <11.96,-1,10>, <16.97,-1,10> }
		triangle { <16.97,-1,10>, <16.97,1,10>, <11,0,10> }
		triangle { <11,0,10>, <16.97,1,10>, <10.92,0.3827,10> }
		triangle { <11.62,3,10>, <9.513,3,10>, <11.96,1,10> }
		triangle { <-15.51,6.965,10>, <-12.02,12.02,10>, <-15.15,12.96,10> }
		triangle { <-15.15,12.96,10>, <-12.02,12.02,10>, <-6.965,15.51,10> }
		triangle { <-15.15,12.96,10>, <-6.965,15.51,10>, <4.637,19.39,10> }
		triangle { <4.637,19.39,10>, <-6.965,15.51,10>, <-1,16.97,10> }
		triangle { <4.637,19.39,10>, <-1,16.97,10>, <1,16.97,10> }
		triangle { <1,16.97,10>, <7.646,18.41,10>, <4.637,19.39,10> }
		triangle { <7.646,18.41,10>, <1,16.97,10>, <10.4,17.01,10> }
		triangle { <10.4,17.01,10>, <1,16.97,10>, <6.965,15.51,10> }
		triangle { <6.965,15.51,10>, <12.96,15.15,10>, <10.4,17.01,10> }
		triangle { <10.4,17.01,10>, <12.96,15.15,10>, <13.52,18.61,10> }
		triangle { <5.801,-1,10>, <5.543,-2.296,10>, <10,-1,10> }
		triangle { <10,-1,10>, <5.543,-2.296,10>, <4.908,-4.908,10> }
		triangle { <10,-1,10>, <4.908,-4.908,10>, <10.38,-0.9239,10> }
		triangle { <10.38,-0.9239,10>, <4.908,-4.908,10>, <7.021,-3.496,10> }
		triangle { <10.38,-0.9239,10>, <7.021,-3.496,10>, <10.71,-0.7071,10> }
		triangle { <10.71,-0.7071,10>, <7.021,-3.496,10>, <9.513,-3,10> }
		triangle { <10.71,-0.7071,10>, <9.513,-3,10>, <10.92,-0.3827,10> }
		triangle { <10.92,-0.3827,10>, <9.513,-3,10>, <11.62,-3,10> }
		triangle { <-5.828,-1,10>, <-10,-1,10>, <-5.657,-2,10> }
		triangle { <-5.657,-2,10>, <-10,-1,10>, <-10.38,-0.9239,10> }
		triangle { <-21.87,7.107,10>, <-19.39,4.637,10>, <-18.41,7.646,10> }
		triangle { <-18.41,7.646,10>, <-19.39,4.637,10>, <-16.97,1,10> }
		triangle { <-16.97,1,10>, <-17.01,10.4,10>, <-18.41,7.646,10> }
		triangle { <-17.01,10.4,10>, <-16.97,1,10>, <-15.51,6.965,10> }
		triangle { <-15.51,6.965,10>, <-15.15,12.96,10>, <-17.01,10.4,10> }
		triangle { <-17.01,10.4,10>, <-15.15,12.96,10>, <-18.61,13.52,10> }
		triangle { <-1,-16.97,10>, <-6.965,-15.51,10>, <-4.637,-19.39,10> }
		triangle { <-4.637,-19.39,10>, <1.582,-19.87,10>, <-1,-16.97,10> }
		triangle { <1.582,-19.87,10>, <-4.637,-19.39,10>, <-1.582,-19.87,10> }
		triangle { <1.582,-19.87,10>, <-1.582,-19.87,10>, <0,-23,10> }
		triangle { <-7.646,-18.41,10>, <-7.107,-21.87,10>, <-4.637,-19.39,10> }
		triangle { <-4.637,-19.39,10>, <-6.965,-15.51,10>, <-7.646,-18.41,10> }
		triangle { <-6.965,-15.51,10>, <-12.02,-12.02,10>, <-18.41,-7.646,10> }
		triangle { <-18.41,-7.646,10>, <-12.02,-12.02,10>, <-15.51,-6.965,10> }
		triangle { <3.597,-4.803,10>, <1,-10,10>, <4.803,-3.597,10> }
		triangle { <4.803,-3.597,10>, <1,-10,10>, <0.9239,-10.38,10> }
		triangle { <0.9239,-10.38,10>, <1,-11.96,10>, <4.803,-3.597,10> }
		triangle { <4.803,-3.597,10>, <1,-11.96,10>, <5.543,-2.296,10> }
		triangle { <5.543,-2.296,10>, <1,-11.96,10>, <3.496,-7.021,10> }
		triangle { <5.543,-2.296,10>, <3.496,-7.021,10>, <4.908,-4.908,10> }
		triangle { <3.496,-7.021,10>, <1,-11.96,10>, <3,-9.513,10> }
		triangle { <3,-9.513,10>, <1,-11.96,10>, <3,-11.62,10> }
		triangle { <-11.62,-3,10>, <-9.513,-3,10>, <-11.96,-1,10> }
		triangle { <16.97,1,10>, <16.97,-1,10>, <17.01,-10.4,10> }
		triangle { <16.97,1,10>, <17.01,-10.4,10>, <18.41,-7.646,10> }
		triangle { <18.41,-7.646,10>, <19.87,-1.582,10>, <16.97,1,10> }
		triangle { <19.87,-1.582,10>, <18.41,-7.646,10>, <19.39,-4.637,10> }
		triangle { <19.39,-4.637,10>, <18.41,-7.646,10>, <21.87,-7.107,10> }
		triangle { <16.97,-1,10>, <15.51,-6.965,10>, <17.01,-10.4,10> }
		triangle { <17.01,-10.4,10>, <15.51,-6.965,10>, <12.02,-12.02,10> }
		triangle { <17.01,-10.4,10>, <12.02,-12.02,10>, <18.61,-13.52,10> }
		triangle { <1.582,19.87,10>, <-1.582,19.87,10>, <-7.646,18.41,10> }
		triangle { <-7.646,18.41,10>, <-1.582,19.87,10>, <-4.637,19.39,10> }
		triangle { <-7.646,18.41,10>, <-4.637,19.39,10>, <-7.107,21.87,10> }
		triangle { <-13.52,18.61,10>, <-12.96,15.15,10>, <-10.4,17.01,10> }
		triangle { <-10.4,17.01,10>, <-12.96,15.15,10>, <-15.15,12.96,10> }
		triangle { <-10.4,17.01,10>, <-15.15,12.96,10>, <-7.646,18.41,10> }
		triangle { <-7.646,18.41,10>, <-15.15,12.96,10>, <4.637,19.39,10> }
		triangle { <4.637,19.39,10>, <1.582,19.87,10>, <-7.646,18.41,10> }
		triangle { <-18.61,-13.52,10>, <-15.15,-12.96,10>, <-17.01,-10.4,10> }
		triangle { <-17.01,-10.4,10>, <-15.15,-12.96,10>, <-12.96,-15.15,10> }
		triangle { <-12.96,-15.15,10>, <-7.646,-18.41,10>, <-17.01,-10.4,10> }
		triangle { <-17.01,-10.4,10>, <-7.646,-18.41,10>, <-6.965,-15.51,10> }
		triangle { <-6.965,-15.51,10>, <-18.41,-7.646,10>, <-17.01,-10.4,10> }
		triangle { <19.87,-1.582,10>, <23,0,10>, <19.87,1.582,10> }
		triangle { <19.87,1.582,10>, <16.97,1,10>, <19.87,-1.582,10> }
		triangle { <16.97,1,10>, <19.87,1.582,10>, <15.51,6.965,10> }
		triangle { <15.51,6.965,10>, <19.87,1.582,10>, <12.02,12.02,10> }
		triangle { <0.7071,-10.71,10>, <1,-16.97,10>, <0.9239,-10.38,10> }
		triangle { <0.9239,-10.38,10>, <1,-16.97,10>, <1,-11.96,10> }
		triangle { <13.52,-18.61,10>, <12.96,-15.15,10>, <10.4,-17.01,10> }
		triangle { <10.4,-17.01,10>, <12.96,-15.15,10>, <15.15,-12.96,10> }
		triangle { <10.4,-17.01,10>, <15.15,-12.96,10>, <4.637,-19.39,10> }
		triangle { <4.637,-19.39,10>, <7.646,-18.41,10>, <10.4,-17.01,10> }
		triangle { <7.646,-18.41,10>, <4.637,-19.39,10>, <7.107,-21.87,10> }
		triangle { <-13.52,-18.61,10>, <-10.4,-17.01,10>, <-12.96,-15.15,10> }
		triangle { <-12.96,-15.15,10>, <-10.4,-17.01,10>, <-7.646,-18.41,10> }
		triangle { <1,-5.801,10>, <1,-10,10>, <2.296,-5.543,10> }
		triangle { <2.296,-5.543,10>, <1,-10,10>, <3.597,-4.803,10> }
		triangle { <0.7071,-10.71,10>, <0.3827,-10.92,10>, <1,-16.97,10> }
		triangle { <1,-16.97,10>, <0.3827,-10.92,10>, <0,-11,10> }
		triangle { <-23,0,10>, <-19.87,-1.582,10>, <-19.87,1.582,10> }
		triangle { <-19.87,1.582,10>, <-19.87,-1.582,10>, <-19.39,-4.637,10> }
		triangle { <-19.39,-4.637,10>, <-19.39,4.637,10>, <-19.87,1.582,10> }
		triangle { <6.965,15.51,10>, <12.02,12.02,10>, <12.96,15.15,10> }
		triangle { <12.96,15.15,10>, <12.02,12.02,10>, <19.87,1.582,10> }
		triangle { <12.96,15.15,10>, <19.87,1.582,10>, <18.41,7.646,10> }
		triangle { <18.41,7.646,10>, <17.01,10.4,10>, <12.96,15.15,10> }
		triangle { <18.41,7.646,10>, <19.87,1.582,10>, <19.39,4.637,10> }
		triangle { <18.41,7.646,10>, <19.39,4.637,10>, <21.87,7.107,10> }
		triangle { <18.61,13.52,10>, <15.15,12.96,10>, <17.01,10.4,10> }
		triangle { <17.01,10.4,10>, <15.15,12.96,10>, <12.96,15.15,10> }
		triangle { <-5.543,2.296,10>, <-4.908,4.908,10>, <-7.021,3.496,10> }
		triangle { <-1,16.97,10>, <1,11.96,10>, <1,16.97,10> }
		triangle { <-4.803,3.597,10>, <-2.5,2.5,10>, <-3.597,4.803,10> }
		triangle { <7.646,18.41,10>, <7.107,21.87,10>, <4.637,19.39,10> }
		triangle { <1.582,19.87,10>, <0,23,10>, <-1.582,19.87,10> }
		triangle { <4.803,-3.597,10>, <2.5,-2.5,10>, <3.597,-4.803,10> }
		triangle { <11.62,-3,-1>, <11.62,-3,-10>, <11.96,-1,-10> }
		triangle { <11.96,-1,-10>, <11.96,-1,-1>, <11.62,-3,-1> }
		triangle { <11.96,-1,-1>, <11.96,-1,-10>, <16.97,-1,-10> }
		triangle { <16.97,-1,-10>, <16.97,-1,-1>, <11.96,-1,-1> }
		triangle { <1,-16.97,-1>, <1,-16.97,-10>, <1,-11.96,-10> }
		triangle { <1,-11.96,-10>, <1,-11.96,-1>, <1,-16.97,-1> }
		triangle { <1,-11.96,-10>, <3,-11.62,-10>, <3,-11.62,-1> }
		triangle { <3,-11.62,-1>, <1,-11.96,-1>, <1,-11.96,-10> }
		triangle { <-3,-11.62,-1>, <-3,-11.62,-10>, <-1,-11.96,-10> }
		triangle { <-1,-11.96,-10>, <-1,-11.96,-1>, <-3,-11.62,-1> }
		triangle { <-1,-11.96,-10>, <-1,-16.97,-10>, <-1,-16.97,-1> }
		triangle { <-1,-16.97,-1>, <-1,-11.96,-1>, <-1,-11.96,-10> }
		triangle { <-16.97,-1,-1>, <-16.97,-1,-10>, <-11.96,-1,-10> }
		triangle { <-11.96,-1,-10>, <-11.96,-1,-1>, <-16.97,-1,-1> }
		triangle { <-11.96,-1,-10>, <-11.62,-3,-10>, <-11.62,-3,-1> }
		triangle { <-11.62,-3,-1>, <-11.96,-1,-1>, <-11.96,-1,-10> }
		triangle { <-11.62,3,-1>, <-11.62,3,-10>, <-11.96,1,-10> }
		triangle { <-11.96,1,-10>, <-11.96,1,-1>, <-11.62,3,-1> }
		triangle { <-11.96,1,-1>, <-11.96,1,-10>, <-16.97,1,-10> }
		triangle { <-16.97,1,-10>, <-16.97,1,-1>, <-11.96,1,-1> }
		triangle { <-3,11.62,-10>, <-3,11.62,-1>, <-1,11.96,-1> }
		triangle { <-1,11.96,-1>, <-1,11.96,-10>, <-3,11.62,-10> }
		triangle { <-1,16.97,-10>, <-1,11.96,-10>, <-1,11.96,-1> }
		triangle { <-1,11.96,-1>, <-1,16.97,-1>, <-1,16.97,-10> }
		triangle { <3,11.62,-1>, <3,11.62,-10>, <1,11.96,-10> }
		triangle { <1,11.96,-10>, <1,11.96,-1>, <3,11.62,-1> }
		triangle { <1,11.96,-1>, <1,11.96,-10>, <1,16.97,-10> }
		triangle { <1,16.97,-10>, <1,16.97,-1>, <1,11.96,-1> }
		triangle { <11.96,1,-1>, <11.96,1,-10>, <11.62,3,-10> }
		triangle { <11.62,3,-10>, <11.62,3,-1>, <11.96,1,-1> }
		triangle { <16.97,1,-10>, <11.96,1,-10>, <11.96,1,-1> }
		triangle { <11.96,1,-1>, <16.97,1,-1>, <16.97,1,-10> }
		triangle { <-19.39,4.637,-10>, <-19.39,4.637,10>, <-25.37,6.066,3> }
		triangle { <-25.37,6.066,3>, <-25.37,6.066,-3>, <-19.39,4.637,-10> }
		triangle { <-17.01,10.4,-10>, <-17.01,10.4,10>, <-22.25,13.61,3> }
		triangle { <-22.25,13.61,3>, <-22.25,13.61,-3>, <-17.01,10.4,-10> }
		triangle { <-12.96,15.15,-10>, <-12.96,15.15,10>, <-16.96,19.82,3> }
		triangle { <-16.96,19.82,3>, <-16.96,19.82,-3>, <-12.96,15.15,-10> }
		triangle { <-7.646,18.41,-10>, <-7.646,18.41,10>, <-10,24.09,3> }
		triangle { <-10,24.09,3>, <-10,24.09,-3>, <-7.646,18.41,-10> }
		triangle { <-1.582,19.87,-10>, <-1.582,19.87,10>, <-2.07,26,3> }
		triangle { <-2.07,26,3>, <-2.07,26,-3>, <-1.582,19.87,-10> }
		triangle { <4.637,19.39,-10>, <4.637,19.39,10>, <6.066,25.37,3> }
		triangle { <6.066,25.37,3>, <6.066,25.37,-3>, <4.637,19.39,-10> }
		triangle { <10.4,17.01,-10>, <10.4,17.01,10>, <13.61,22.25,3> }
		triangle { <13.61,22.25,3>, <13.61,22.25,-3>, <10.4,17.01,-10> }
		triangle { <15.15,12.96,-10>, <15.15,12.96,10>, <19.82,16.96,3> }
		triangle { <19.82,16.96,3>, <19.82,16.96,-3>, <15.15,12.96,-10> }
		triangle { <18.41,7.646,-10>, <18.41,7.646,10>, <24.09,10,3> }
		triangle { <24.09,10,3>, <24.09,10,-3>, <18.41,7.646,-10> }
		triangle { <19.87,1.582,-10>, <19.87,1.582,10>, <26,2.07,3> }
		triangle { <26,2.07,3>, <26,2.07,-3>, <19.87,1.582,-10> }
		triangle { <19.39,-4.637,-10>, <19.39,-4.637,10>, <25.37,-6.066,3> }
		triangle { <25.37,-6.066,3>, <25.37,-6.066,-3>, <19.39,-4.637,-10> }
		triangle { <17.01,-10.4,-10>, <17.01,-10.4,10>, <22.25,-13.61,3> }
		triangle { <22.25,-13.61,3>, <22.25,-13.61,-3>, <17.01,-10.4,-10> }
		triangle { <12.96,-15.15,-10>, <12.96,-15.15,10>, <16.96,-19.82,3> }
		triangle { <16.96,-19.82,3>, <16.96,-19.82,-3>, <12.96,-15.15,-10> }
		triangle { <7.646,-18.41,-10>, <7.646,-18.41,10>, <10,-24.09,3> }
		triangle { <10,-24.09,3>, <10,-24.09,-3>, <7.646,-18.41,-10> }
		triangle { <1.582,-19.87,-10>, <1.582,-19.87,10>, <2.07,-26,3> }
		triangle { <2.07,-26,3>, <2.07,-26,-3>, <1.582,-19.87,-10> }
		triangle { <-4.637,-19.39,-10>, <-4.637,-19.39,10>, <-6.066,-25.37,3> }
		triangle { <-6.066,-25.37,3>, <-6.066,-25.37,-3>, <-4.637,-19.39,-10> }
		triangle { <-10.4,-17.01,-10>, <-10.4,-17.01,10>, <-13.61,-22.25,3> }
		triangle { <-13.61,-22.25,3>, <-13.61,-22.25,-3>, <-10.4,-17.01,-10> }
		triangle { <-15.15,-12.96,-10>, <-15.15,-12.96,10>, <-19.82,-16.96,3> }
		triangle { <-19.82,-16.96,3>, <-19.82,-16.96,-3>, <-15.15,-12.96,-10> }
		triangle { <-21.87,7.107,10>, <-24.73,8.034,8>, <-19.39,4.637,10> }
		triangle { <-24.09,10,3>, <-25.37,6.066,3>, <-24.73,8.034,8> }
		triangle { <-18.61,13.52,10>, <-21.03,15.28,8>, <-17.01,10.4,10> }
		triangle { <-19.82,16.96,3>, <-22.25,13.61,3>, <-21.03,15.28,8> }
		triangle { <-19.82,16.96,3>, <-20.63,17.54,3>, <-23.06,14.2,3> }
		triangle { <-23.06,14.2,3>, <-22.25,13.61,3>, <-19.82,16.96,3> }
		triangle { <-13.52,18.61,10>, <-15.28,21.03,8>, <-12.96,15.15,10> }
		triangle { <-13.61,22.25,3>, <-16.96,19.82,3>, <-15.28,21.03,8> }
		triangle { <-13.61,22.25,3>, <-14.2,23.06,3>, <-17.54,20.63,3> }
		triangle { <-17.54,20.63,3>, <-16.96,19.82,3>, <-13.61,22.25,3> }
		triangle { <-7.107,21.87,10>, <-8.034,24.73,8>, <-7.646,18.41,10> }
		triangle { <-6.066,25.37,3>, <-10,24.09,3>, <-8.034,24.73,8> }
		triangle { <-6.066,25.37,3>, <-6.375,26.32,3>, <-10.31,25.04,3> }
		triangle { <-10.31,25.04,3>, <-10,24.09,3>, <-6.066,25.37,3> }
		triangle { <0,23,10>, <0,26,8>, <-1.582,19.87,10> }
		triangle { <2.07,26,3>, <-2.07,26,3>, <0,26,8> }
		triangle { <2.07,26,3>, <2.07,27,3>, <-2.07,27,3> }
		triangle { <-2.07,27,3>, <-2.07,26,3>, <2.07,26,3> }
		triangle { <7.107,21.87,10>, <8.034,24.73,8>, <4.637,19.39,10> }
		triangle { <10,24.09,3>, <6.066,25.37,3>, <8.034,24.73,8> }
		triangle { <10,24.09,3>, <10.31,25.04,3>, <6.375,26.32,3> }
		triangle { <6.375,26.32,3>, <6.066,25.37,3>, <10,24.09,3> }
		triangle { <13.52,18.61,10>, <15.28,21.03,8>, <10.4,17.01,10> }
		triangle { <16.96,19.82,3>, <13.61,22.25,3>, <15.28,21.03,8> }
		triangle { <16.96,19.82,3>, <17.54,20.63,3>, <14.2,23.06,3> }
		triangle { <14.2,23.06,3>, <13.61,22.25,3>, <16.96,19.82,3> }
		triangle { <18.61,13.52,10>, <21.03,15.28,8>, <15.15,12.96,10> }
		triangle { <22.25,13.61,3>, <19.82,16.96,3>, <21.03,15.28,8> }
		triangle { <22.25,13.61,3>, <23.06,14.2,3>, <20.63,17.54,3> }
		triangle { <20.63,17.54,3>, <19.82,16.96,3>, <22.25,13.61,3> }
		triangle { <21.87,7.107,10>, <24.73,8.034,8>, <18.41,7.646,10> }
		triangle { <25.37,6.066,3>, <24.09,10,3>, <24.73,8.034,8> }
		triangle { <25.37,6.066,3>, <26.32,6.375,3>, <25.04,10.31,3> }
		triangle { <25.04,10.31,3>, <24.09,10,3>, <25.37,6.066,3> }
		triangle { <23,0,10>, <26,0,8>, <19.87,1.582,10> }
		triangle { <26,-2.07,3>, <26,2.07,3>, <26,0,8> }
		triangle { <26,-2.07,3>, <27,-2.07,3>, <27,2.07,3> }
		triangle { <27,2.07,3>, <26,2.07,3>, <26,-2.07,3> }
		triangle { <21.87,-7.107,10>, <24.73,-8.034,8>, <19.39,-4.637,10> }
		triangle { <24.09,-10,3>, <25.37,-6.066,3>, <24.73,-8.034,8> }
		triangle { <24.09,-10,3>, <25.04,-10.31,3>, <26.32,-6.375,3> }
		triangle { <26.32,-6.375,3>, <25.37,-6.066,3>, <24.09,-10,3> }
		triangle { <18.61,-13.52,10>, <21.03,-15.28,8>, <17.01,-10.4,10> }
		triangle { <19.82,-16.96,3>, <22.25,-13.61,3>, <21.03,-15.28,8> }
		triangle { <19.82,-16.96,3>, <20.63,-17.54,3>, <23.06,-14.2,3> }
		triangle { <23.06,-14.2,3>, <22.25,-13.61,3>, <19.82,-16.96,3> }
		triangle { <13.52,-18.61,10>, <15.28,-21.03,8>, <12.96,-15.15,10> }
		triangle { <13.61,-22.25,3>, <16.96,-19.82,3>, <15.28,-21.03,8> }
		triangle { <13.61,-22.25,3>, <14.2,-23.06,3>, <17.54,-20.63,3> }
		triangle { <17.54,-20.63,3>, <16.96,-19.82,3>, <13.61,-22.25,3> }
		triangle { <7.107,-21.87,10>, <8.034,-24.73,8>, <7.646,-18.41,10> }
		triangle { <6.066,-25.37,3>, <10,-24.09,3>, <8.034,-24.73,8> }
		triangle { <6.066,-25.37,3>, <6.375,-26.32,3>, <10.31,-25.04,3> }
		triangle { <10.31,-25.04,3>, <10,-24.09,3>, <6.066,-25.37,3> }
		triangle { <0,-23,10>, <0,-26,8>, <1.582,-19.87,10> }
		triangle { <-2.07,-26,3>, <2.07,-26,3>, <0,-26,8> }
		triangle { <-2.07,-26,3>, <-2.07,-27,3>, <2.07,-27,3> }
		triangle { <2.07,-27,3>, <2.07,-26,3>, <-2.07,-26,3> }
		triangle { <-7.107,-21.87,10>, <-8.034,-24.73,8>, <-4.637,-19.39,10> }
		triangle { <-10,-24.09,3>, <-6.066,-25.37,3>, <-8.034,-24.73,8> }
		triangle { <-10,-24.09,3>, <-10.31,-25.04,3>, <-6.375,-26.32,3> }
		triangle { <-6.375,-26.32,3>, <-6.066,-25.37,3>, <-10,-24.09,3> }
		triangle { <-13.52,-18.61,10>, <-15.28,-21.03,8>, <-10.4,-17.01,10> }
		triangle { <-16.96,-19.82,3>, <-13.61,-22.25,3>, <-15.28,-21.03,8> }
		triangle { <-16.96,-19.82,3>, <-17.54,-20.63,3>, <-14.2,-23.06,3> }
		triangle { <-14.2,-23.06,3>, <-13.61,-22.25,3>, <-16.96,-19.82,3> }
		triangle { <-18.61,-13.52,10>, <-21.03,-15.28,8>, <-15.15,-12.96,10> }
		triangle { <-22.25,-13.61,3>, <-19.82,-16.96,3>, <-21.03,-15.28,8> }
		triangle { <-22.25,-13.61,3>, <-23.06,-14.2,3>, <-20.63,-17.54,3> }
		triangle { <-20.63,-17.54,3>, <-19.82,-16.96,3>, <-22.25,-13.61,3> }
		triangle { <-21.87,-7.107,10>, <-24.73,-8.034,8>, <-18.41,-7.646,10> }
		triangle { <-18.41,-7.646,-10>, <-18.41,-7.646,10>, <-24.09,-10,3> }
		triangle { <-24.09,-10,3>, <-24.09,-10,-3>, <-18.41,-7.646,-10> }
		triangle { <-25.37,-6.066,3>, <-24.09,-10,3>, <-24.73,-8.034,8> }
		triangle { <-25.37,-6.066,3>, <-26.32,-6.375,3>, <-25.04,-10.31,3> }
		triangle { <-25.04,-10.31,3>, <-24.09,-10,3>, <-25.37,-6.066,3> }
		triangle { <-18.41,7.646,10>, <-18.41,7.646,-10>, <-24.09,10,-3> }
		triangle { <-24.09,10,-3>, <-24.09,10,3>, <-18.41,7.646,10> }
		triangle { <-24.73,8.034,-8>, <-25.37,6.066,-3>, <-24.09,10,-3> }
		triangle { <-24.73,8.034,-8>, <-21.87,7.107,-10>, <-19.39,4.637,-10> }
		triangle { <-15.15,12.96,10>, <-15.15,12.96,-10>, <-19.82,16.96,-3> }
		triangle { <-19.82,16.96,-3>, <-19.82,16.96,3>, <-15.15,12.96,10> }
		triangle { <-21.03,15.28,-8>, <-22.25,13.61,-3>, <-19.82,16.96,-3> }
		triangle { <-21.03,15.28,-8>, <-18.61,13.52,-10>, <-17.01,10.4,-10> }
		triangle { <-10.4,17.01,10>, <-10.4,17.01,-10>, <-13.61,22.25,-3> }
		triangle { <-13.61,22.25,-3>, <-13.61,22.25,3>, <-10.4,17.01,10> }
		triangle { <-15.28,21.03,-8>, <-16.96,19.82,-3>, <-13.61,22.25,-3> }
		triangle { <-15.28,21.03,-8>, <-13.52,18.61,-10>, <-12.96,15.15,-10> }
		triangle { <-4.637,19.39,10>, <-4.637,19.39,-10>, <-6.066,25.37,-3> }
		triangle { <-6.066,25.37,-3>, <-6.066,25.37,3>, <-4.637,19.39,10> }
		triangle { <-8.034,24.73,-8>, <-10,24.09,-3>, <-6.066,25.37,-3> }
		triangle { <-8.034,24.73,-8>, <-7.107,21.87,-10>, <-7.646,18.41,-10> }
		triangle { <1.582,19.87,10>, <1.582,19.87,-10>, <2.07,26,-3> }
		triangle { <2.07,26,-3>, <2.07,26,3>, <1.582,19.87,10> }
		triangle { <0,26,-8>, <-2.07,26,-3>, <2.07,26,-3> }
		triangle { <0,26,-8>, <0,23,-10>, <-1.582,19.87,-10> }
		triangle { <7.646,18.41,10>, <7.646,18.41,-10>, <10,24.09,-3> }
		triangle { <10,24.09,-3>, <10,24.09,3>, <7.646,18.41,10> }
		triangle { <8.034,24.73,-8>, <6.066,25.37,-3>, <10,24.09,-3> }
		triangle { <8.034,24.73,-8>, <7.107,21.87,-10>, <4.637,19.39,-10> }
		triangle { <12.96,15.15,10>, <12.96,15.15,-10>, <16.96,19.82,-3> }
		triangle { <16.96,19.82,-3>, <16.96,19.82,3>, <12.96,15.15,10> }
		triangle { <15.28,21.03,-8>, <13.61,22.25,-3>, <16.96,19.82,-3> }
		triangle { <15.28,21.03,-8>, <13.52,18.61,-10>, <10.4,17.01,-10> }
		triangle { <17.01,10.4,10>, <17.01,10.4,-10>, <22.25,13.61,-3> }
		triangle { <22.25,13.61,-3>, <22.25,13.61,3>, <17.01,10.4,10> }
		triangle { <21.03,15.28,-8>, <19.82,16.96,-3>, <22.25,13.61,-3> }
		triangle { <21.03,15.28,-8>, <18.61,13.52,-10>, <15.15,12.96,-10> }
		triangle { <19.39,4.637,10>, <19.39,4.637,-10>, <25.37,6.066,-3> }
		triangle { <25.37,6.066,-3>, <25.37,6.066,3>, <19.39,4.637,10> }
		triangle { <24.73,8.034,-8>, <24.09,10,-3>, <25.37,6.066,-3> }
		triangle { <24.73,8.034,-8>, <21.87,7.107,-10>, <18.41,7.646,-10> }
		triangle { <19.87,-1.582,10>, <19.87,-1.582,-10>, <26,-2.07,-3> }
		triangle { <26,-2.07,-3>, <26,-2.07,3>, <19.87,-1.582,10> }
		triangle { <26,0,-8>, <26,2.07,-3>, <26,-2.07,-3> }
		triangle { <26,0,-8>, <23,0,-10>, <19.87,1.582,-10> }
		triangle { <18.41,-7.646,10>, <18.41,-7.646,-10>, <24.09,-10,-3> }
		triangle { <24.09,-10,-3>, <24.09,-10,3>, <18.41,-7.646,10> }
		triangle { <24.73,-8.034,-8>, <25.37,-6.066,-3>, <24.09,-10,-3> }
		triangle { <24.73,-8.034,-8>, <21.87,-7.107,-10>, <19.39,-4.637,-10> }
		triangle { <15.15,-12.96,10>, <15.15,-12.96,-10>, <19.82,-16.96,-3> }
		triangle { <19.82,-16.96,-3>, <19.82,-16.96,3>, <15.15,-12.96,10> }
		triangle { <21.03,-15.28,-8>, <22.25,-13.61,-3>, <19.82,-16.96,-3> }
		triangle { <21.03,-15.28,-8>, <18.61,-13.52,-10>, <17.01,-10.4,-10> }
		triangle { <10.4,-17.01,10>, <10.4,-17.01,-10>, <13.61,-22.25,-3> }
		triangle { <13.61,-22.25,-3>, <13.61,-22.25,3>, <10.4,-17.01,10> }
		triangle { <15.28,-21.03,-8>, <16.96,-19.82,-3>, <13.61,-22.25,-3> }
		triangle { <15.28,-21.03,-8>, <13.52,-18.61,-10>, <12.96,-15.15,-10> }
		triangle { <4.637,-19.39,10>, <4.637,-19.39,-10>, <6.066,-25.37,-3> }
		triangle { <6.066,-25.37,-3>, <6.066,-25.37,3>, <4.637,-19.39,10> }
		triangle { <8.034,-24.73,-8>, <10,-24.09,-3>, <6.066,-25.37,-3> }
		triangle { <8.034,-24.73,-8>, <7.107,-21.87,-10>, <7.646,-18.41,-10> }
		triangle { <-1.582,-19.87,10>, <-1.582,-19.87,-10>, <-2.07,-26,-3> }
		triangle { <-2.07,-26,-3>, <-2.07,-26,3>, <-1.582,-19.87,10> }
		triangle { <0,-26,-8>, <2.07,-26,-3>, <-2.07,-26,-3> }
		triangle { <0,-26,-8>, <0,-23,-10>, <1.582,-19.87,-10> }
		triangle { <-7.646,-18.41,10>, <-7.646,-18.41,-10>, <-10,-24.09,-3> }
		triangle { <-10,-24.09,-3>, <-10,-24.09,3>, <-7.646,-18.41,10> }
		triangle { <-8.034,-24.73,-8>, <-6.066,-25.37,-3>, <-10,-24.09,-3> }
		triangle { <-8.034,-24.73,-8>, <-7.107,-21.87,-10>, <-4.637,-19.39,-10> }
		triangle { <-12.96,-15.15,10>, <-12.96,-15.15,-10>, <-16.96,-19.82,-3> }
		triangle { <-16.96,-19.82,-3>, <-16.96,-19.82,3>, <-12.96,-15.15,10> }
		triangle { <-15.28,-21.03,-8>, <-13.61,-22.25,-3>, <-16.96,-19.82,-3> }
		triangle { <-15.28,-21.03,-8>, <-13.52,-18.61,-10>, <-10.4,-17.01,-10> }
		triangle { <-17.01,-10.4,10>, <-17.01,-10.4,-10>, <-22.25,-13.61,-3> }
		triangle { <-22.25,-13.61,-3>, <-22.25,-13.61,3>, <-17.01,-10.4,10> }
		triangle { <-21.03,-15.28,-8>, <-19.82,-16.96,-3>, <-22.25,-13.61,-3> }
		triangle { <-21.03,-15.28,-8>, <-18.61,-13.52,-10>, <-15.15,-12.96,-10> }
		triangle { <-19.39,-4.637,10>, <-19.39,-4.637,-10>, <-25.37,-6.066,-3> }
		triangle { <-25.37,-6.066,-3>, <-25.37,-6.066,3>, <-19.39,-4.637,10> }
		triangle { <-24.73,-8.034,-8>, <-24.09,-10,-3>, <-25.37,-6.066,-3> }
		triangle { <-24.73,-8.034,-8>, <-21.87,-7.107,-10>, <-18.41,-7.646,-10> }
		triangle { <-24.09,-10,-3>, <-25.04,-10.31,-3>, <-26.32,-6.375,-3> }
		triangle { <-26.32,-6.375,-3>, <-25.37,-6.066,-3>, <-24.09,-10,-3> }
		triangle { <-19.82,-16.96,-3>, <-20.63,-17.54,-3>, <-23.06,-14.2,-3> }
		triangle { <-23.06,-14.2,-3>, <-22.25,-13.61,-3>, <-19.82,-16.96,-3> }
		triangle { <-13.61,-22.25,-3>, <-14.2,-23.06,-3>, <-17.54,-20.63,-3> }
		triangle { <-17.54,-20.63,-3>, <-16.96,-19.82,-3>, <-13.61,-22.25,-3> }
		triangle { <-6.066,-25.37,-3>, <-6.375,-26.32,-3>, <-10.31,-25.04,-3> }
		triangle { <-10.31,-25.04,-3>, <-10,-24.09,-3>, <-6.066,-25.37,-3> }
		triangle { <2.07,-26,-3>, <2.07,-27,-3>, <-2.07,-27,-3> }
		triangle { <-2.07,-27,-3>, <-2.07,-26,-3>, <2.07,-26,-3> }
		triangle { <10,-24.09,-3>, <10.31,-25.04,-3>, <6.375,-26.32,-3> }
		triangle { <6.375,-26.32,-3>, <6.066,-25.37,-3>, <10,-24.09,-3> }
		triangle { <16.96,-19.82,-3>, <17.54,-20.63,-3>, <14.2,-23.06,-3> }
		triangle { <14.2,-23.06,-3>, <13.61,-22.25,-3>, <16.96,-19.82,-3> }
		triangle { <22.25,-13.61,-3>, <23.06,-14.2,-3>, <20.63,-17.54,-3> }
		triangle { <20.63,-17.54,-3>, <19.82,-16.96,-3>, <22.25,-13.61,-3> }
		triangle { <25.37,-6.066,-3>, <26.32,-6.375,-3>, <25.04,-10.31,-3> }
		triangle { <25.04,-10.31,-3>, <24.09,-10,-3>, <25.37,-6.066,-3> }
		triangle { <26,2.07,-3>, <27,2.07,-3>, <27,-2.07,-3> }
		triangle { <27,-2.07,-3>, <26,-2.07,-3>, <26,2.07,-3> }
		triangle { <24.09,10,-3>, <25.04,10.31,-3>, <26.32,6.375,-3> }
		triangle { <26.32,6.375,-3>, <25.37,6.066,-3>, <24.09,10,-3> }
		triangle { <19.82,16.96,-3>, <20.63,17.54,-3>, <23.06,14.2,-3> }
		triangle { <23.06,14.2,-3>, <22.25,13.61,-3>, <19.82,16.96,-3> }
		triangle { <13.61,22.25,-3>, <14.2,23.06,-3>, <17.54,20.63,-3> }
		triangle { <17.54,20.63,-3>, <16.96,19.82,-3>, <13.61,22.25,-3> }
		triangle { <6.066,25.37,-3>, <6.375,26.32,-3>, <10.31,25.04,-3> }
		triangle { <10.31,25.04,-3>, <10,24.09,-3>, <6.066,25.37,-3> }
		triangle { <-2.07,26,-3>, <-2.07,27,-3>, <2.07,27,-3> }
		triangle { <2.07,27,-3>, <2.07,26,-3>, <-2.07,26,-3> }
		triangle { <-10,24.09,-3>, <-10.31,25.04,-3>, <-6.375,26.32,-3> }
		triangle { <-6.375,26.32,-3>, <-6.066,25.37,-3>, <-10,24.09,-3> }
		triangle { <-16.96,19.82,-3>, <-17.54,20.63,-3>, <-14.2,23.06,-3> }
		triangle { <-14.2,23.06,-3>, <-13.61,22.25,-3>, <-16.96,19.82,-3> }
		triangle { <-22.25,13.61,-3>, <-23.06,14.2,-3>, <-20.63,17.54,-3> }
		triangle { <-20.63,17.54,-3>, <-19.82,16.96,-3>, <-22.25,13.61,-3> }
		triangle { <-25.37,6.066,-3>, <-26.32,6.375,-3>, <-25.04,10.31,-3> }
		triangle { <-25.04,10.31,-3>, <-24.09,10,-3>, <-25.37,6.066,-3> }
		triangle { <-23,0,10>, <-26,0,8>, <-19.87,-1.582,10> }
		triangle { <-26,-2.07,-3>, <-19.87,-1.582,-10>, <-19.87,-1.582,10> }
		triangle { <-19.87,-1.582,10>, <-26,-2.07,3>, <-26,-2.07,-3> }
		triangle { <-26,2.07,3>, <-26,-2.07,3>, <-26,0,8> }
		triangle { <-27,2.07,3>, <-27,-2.07,3>, <-26,-2.07,3> }
		triangle { <-26,-2.07,3>, <-26,2.07,3>, <-27,2.07,3> }
		triangle { <-26,2.07,3>, <-19.87,1.582,10>, <-19.87,1.582,-10> }
		triangle { <-19.87,1.582,-10>, <-26,2.07,-3>, <-26,2.07,3> }
		triangle { <-26,0,-8>, <-26,-2.07,-3>, <-26,2.07,-3> }
		triangle { <-26,0,-8>, <-23,0,-10>, <-19.87,-1.582,-10> }
		triangle { <-27,-2.07,-3>, <-27,2.07,-3>, <-26,2.07,-3> }
		triangle { <-26,2.07,-3>, <-26,-2.07,-3>, <-27,-2.07,-3> }
		triangle { <-27,2.07,-3>, <-27,-2.07,-3>, <-27,-2.07,3> }
		triangle { <-27,-2.07,3>, <-27,2.07,3>, <-27,2.07,-3> }
		triangle { <-26,2.07,3>, <-26,2.07,-3>, <-27,2.07,-3> }
		triangle { <-27,2.07,-3>, <-27,2.07,3>, <-26,2.07,3> }
		triangle { <-19.39,4.637,-10>, <-19.87,1.582,-10>, <-19.87,1.582,10> }
		triangle { <-19.87,1.582,10>, <-19.39,4.637,10>, <-19.39,4.637,-10> }
		triangle { <-19.39,-4.637,10>, <-19.87,-1.582,10>, <-19.87,-1.582,-10> }
		triangle { <-19.87,-1.582,-10>, <-19.39,-4.637,-10>, <-19.39,-4.637,10> }
		triangle { <-26,-2.07,-3>, <-26,-2.07,3>, <-27,-2.07,3> }
		triangle { <-27,-2.07,3>, <-27,-2.07,-3>, <-26,-2.07,-3> }
		triangle { <-19.87,-1.582,-10>, <-26,-2.07,-3>, <-26,0,-8> }
		triangle { <-19.87,1.582,-10>, <-23,0,-10>, <-26,0,-8> }
		triangle { <-26,2.07,-3>, <-19.87,1.582,-10>, <-26,0,-8> }
		triangle { <-26,-2.07,3>, <-19.87,-1.582,10>, <-26,0,8> }
		triangle { <-26,0,8>, <-23,0,10>, <-19.87,1.582,10> }
		triangle { <-26,0,8>, <-19.87,1.582,10>, <-26,2.07,3> }
		triangle { <-26.32,-6.375,3>, <-26.32,-6.375,-3>, <-25.04,-10.31,-3> }
		triangle { <-25.04,-10.31,-3>, <-25.04,-10.31,3>, <-26.32,-6.375,3> }
		triangle { <-26.32,-6.375,3>, <-25.37,-6.066,3>, <-25.37,-6.066,-3> }
		triangle { <-25.37,-6.066,-3>, <-26.32,-6.375,-3>, <-26.32,-6.375,3> }
		triangle { <-18.41,-7.646,-10>, <-17.01,-10.4,-10>, <-17.01,-10.4,10> }
		triangle { <-17.01,-10.4,10>, <-18.41,-7.646,10>, <-18.41,-7.646,-10> }
		triangle { <-25.04,-10.31,-3>, <-24.09,-10,-3>, <-24.09,-10,3> }
		triangle { <-24.09,-10,3>, <-25.04,-10.31,3>, <-25.04,-10.31,-3> }
		triangle { <-24.09,10,3>, <-25.04,10.31,3>, <-26.32,6.375,3> }
		triangle { <-26.32,6.375,3>, <-25.37,6.066,3>, <-24.09,10,3> }
		triangle { <-23.06,-14.2,3>, <-23.06,-14.2,-3>, <-20.63,-17.54,-3> }
		triangle { <-20.63,-17.54,-3>, <-20.63,-17.54,3>, <-23.06,-14.2,3> }
		triangle { <-23.06,-14.2,3>, <-22.25,-13.61,3>, <-22.25,-13.61,-3> }
		triangle { <-22.25,-13.61,-3>, <-23.06,-14.2,-3>, <-23.06,-14.2,3> }
		triangle { <-12.96,-15.15,10>, <-15.15,-12.96,10>, <-15.15,-12.96,-10> }
		triangle { <-15.15,-12.96,-10>, <-12.96,-15.15,-10>, <-12.96,-15.15,10> }
		triangle { <-20.63,-17.54,-3>, <-19.82,-16.96,-3>, <-19.82,-16.96,3> }
		triangle { <-19.82,-16.96,3>, <-20.63,-17.54,3>, <-20.63,-17.54,-3> }
		triangle { <-17.54,-20.63,3>, <-17.54,-20.63,-3>, <-14.2,-23.06,-3> }
		triangle { <-14.2,-23.06,-3>, <-14.2,-23.06,3>, <-17.54,-20.63,3> }
		triangle { <-17.54,-20.63,3>, <-16.96,-19.82,3>, <-16.96,-19.82,-3> }
		triangle { <-16.96,-19.82,-3>, <-17.54,-20.63,-3>, <-17.54,-20.63,3> }
		triangle { <-7.646,-18.41,10>, <-10.4,-17.01,10>, <-10.4,-17.01,-10> }
		triangle { <-10.4,-17.01,-10>, <-7.646,-18.41,-10>, <-7.646,-18.41,10> }
		triangle { <-14.2,-23.06,-3>, <-13.61,-22.25,-3>, <-13.61,-22.25,3> }
		triangle { <-13.61,-22.25,3>, <-14.2,-23.06,3>, <-14.2,-23.06,-3> }
		triangle { <-10.31,-25.04,-3>, <-6.375,-26.32,-3>, <-6.375,-26.32,3> }
		triangle { <-6.375,-26.32,3>, <-10.31,-25.04,3>, <-10.31,-25.04,-3> }
		triangle { <-10.31,-25.04,3>, <-10,-24.09,3>, <-10,-24.09,-3> }
		triangle { <-10,-24.09,-3>, <-10.31,-25.04,-3>, <-10.31,-25.04,3> }
		triangle { <-1.582,-19.87,10>, <-4.637,-19.39,10>, <-4.637,-19.39,-10> }
		triangle { <-4.637,-19.39,-10>, <-1.582,-19.87,-10>, <-1.582,-19.87,10> }
		triangle { <-6.375,-26.32,-3>, <-6.066,-25.37,-3>, <-6.066,-25.37,3> }
		triangle { <-6.066,-25.37,3>, <-6.375,-26.32,3>, <-6.375,-26.32,-3> }
		triangle { <-2.07,-27,3>, <-2.07,-27,-3>, <2.07,-27,-3> }
		triangle { <2.07,-27,-3>, <2.07,-27,3>, <-2.07,-27,3> }
		triangle { <-2.07,-27,3>, <-2.07,-26,3>, <-2.07,-26,-3> }
		triangle { <-2.07,-26,-3>, <-2.07,-27,-3>, <-2.07,-27,3> }
		triangle { <4.637,-19.39,10>, <1.582,-19.87,10>, <1.582,-19.87,-10> }
		triangle { <1.582,-19.87,-10>, <4.637,-19.39,-10>, <4.637,-19.39,10> }
		triangle { <2.07,-27,-3>, <2.07,-26,-3>, <2.07,-26,3> }
		triangle { <2.07,-26,3>, <2.07,-27,3>, <2.07,-27,-3> }
		triangle { <6.375,-26.32,3>, <6.375,-26.32,-3>, <10.31,-25.04,-3> }
		triangle { <10.31,-25.04,-3>, <10.31,-25.04,3>, <6.375,-26.32,3> }
		triangle { <6.375,-26.32,3>, <6.066,-25.37,3>, <6.066,-25.37,-3> }
		triangle { <6.066,-25.37,-3>, <6.375,-26.32,-3>, <6.375,-26.32,3> }
		triangle { <7.646,-18.41,-10>, <10.4,-17.01,-10>, <10.4,-17.01,10> }
		triangle { <10.4,-17.01,10>, <7.646,-18.41,10>, <7.646,-18.41,-10> }
		triangle { <10.31,-25.04,-3>, <10,-24.09,-3>, <10,-24.09,3> }
		triangle { <10,-24.09,3>, <10.31,-25.04,3>, <10.31,-25.04,-3> }
		triangle { <14.2,-23.06,3>, <14.2,-23.06,-3>, <17.54,-20.63,-3> }
		triangle { <17.54,-20.63,-3>, <17.54,-20.63,3>, <14.2,-23.06,3> }
		triangle { <14.2,-23.06,3>, <13.61,-22.25,3>, <13.61,-22.25,-3> }
		triangle { <13.61,-22.25,-3>, <14.2,-23.06,-3>, <14.2,-23.06,3> }
		triangle { <12.96,-15.15,-10>, <15.15,-12.96,-10>, <15.15,-12.96,10> }
		triangle { <15.15,-12.96,10>, <12.96,-15.15,10>, <12.96,-15.15,-10> }
		triangle { <17.54,-20.63,-3>, <16.96,-19.82,-3>, <16.96,-19.82,3> }
		triangle { <16.96,-19.82,3>, <17.54,-20.63,3>, <17.54,-20.63,-3> }
		triangle { <20.63,-17.54,3>, <20.63,-17.54,-3>, <23.06,-14.2,-3> }
		triangle { <23.06,-14.2,-3>, <23.06,-14.2,3>, <20.63,-17.54,3> }
		triangle { <20.63,-17.54,3>, <19.82,-16.96,3>, <19.82,-16.96,-3> }
		triangle { <19.82,-16.96,-3>, <20.63,-17.54,-3>, <20.63,-17.54,3> }
		triangle { <17.01,-10.4,-10>, <18.41,-7.646,-10>, <18.41,-7.646,10> }
		triangle { <18.41,-7.646,10>, <17.01,-10.4,10>, <17.01,-10.4,-10> }
		triangle { <23.06,-14.2,-3>, <22.25,-13.61,-3>, <22.25,-13.61,3> }
		triangle { <22.25,-13.61,3>, <23.06,-14.2,3>, <23.06,-14.2,-3> }
		triangle { <25.04,-10.31,3>, <25.04,-10.31,-3>, <26.32,-6.375,-3> }
		triangle { <26.32,-6.375,-3>, <26.32,-6.375,3>, <25.04,-10.31,3> }
		triangle { <25.04,-10.31,3>, <24.09,-10,3>, <24.09,-10,-3> }
		triangle { <24.09,-10,-3>, <25.04,-10.31,-3>, <25.04,-10.31,3> }
		triangle { <19.39,-4.637,-10>, <19.87,-1.582,-10>, <19.87,-1.582,10> }
		triangle { <19.87,-1.582,10>, <19.39,-4.637,10>, <19.39,-4.637,-10> }
		triangle { <26.32,-6.375,-3>, <25.37,-6.066,-3>, <25.37,-6.066,3> }
		triangle { <25.37,-6.066,3>, <26.32,-6.375,3>, <26.32,-6.375,-3> }
		triangle { <27,-2.07,-3>, <27,2.07,-3>, <27,2.07,3> }
		triangle { <27,2.07,3>, <27,-2.07,3>, <27,-2.07,-3> }
		triangle { <27,-2.07,3>, <26,-2.07,3>, <26,-2.07,-3> }
		triangle { <26,-2.07,-3>, <27,-2.07,-3>, <27,-2.07,3> }
		triangle { <19.87,1.582,-10>, <19.39,4.637,-10>, <19.39,4.637,10> }
		triangle { <19.39,4.637,10>, <19.87,1.582,10>, <19.87,1.582,-10> }
		triangle { <27,2.07,-3>, <26,2.07,-3>, <26,2.07,3> }
		triangle { <26,2.07,3>, <27,2.07,3>, <27,2.07,-3> }
		triangle { <26.32,6.375,3>, <26.32,6.375,-3>, <25.04,10.31,-3> }
		triangle { <25.04,10.31,-3>, <25.04,10.31,3>, <26.32,6.375,3> }
		triangle { <26.32,6.375,3>, <25.37,6.066,3>, <25.37,6.066,-3> }
		triangle { <25.37,6.066,-3>, <26.32,6.375,-3>, <26.32,6.375,3> }
		triangle { <18.41,7.646,-10>, <17.01,10.4,-10>, <17.01,10.4,10> }
		triangle { <17.01,10.4,10>, <18.41,7.646,10>, <18.41,7.646,-10> }
		triangle { <25.04,10.31,-3>, <24.09,10,-3>, <24.09,10,3> }
		triangle { <24.09,10,3>, <25.04,10.31,3>, <25.04,10.31,-3> }
		triangle { <23.06,14.2,3>, <23.06,14.2,-3>, <20.63,17.54,-3> }
		triangle { <20.63,17.54,-3>, <20.63,17.54,3>, <23.06,14.2,3> }
		triangle { <23.06,14.2,3>, <22.25,13.61,3>, <22.25,13.61,-3> }
		triangle { <22.25,13.61,-3>, <23.06,14.2,-3>, <23.06,14.2,3> }
		triangle { <15.15,12.96,-10>, <12.96,15.15,-10>, <12.96,15.15,10> }
		triangle { <12.96,15.15,10>, <15.15,12.96,10>, <15.15,12.96,-10> }
		triangle { <20.63,17.54,-3>, <19.82,16.96,-3>, <19.82,16.96,3> }
		triangle { <19.82,16.96,3>, <20.63,17.54,3>, <20.63,17.54,-3> }
		triangle { <17.54,20.63,3>, <17.54,20.63,-3>, <14.2,23.06,-3> }
		triangle { <14.2,23.06,-3>, <14.2,23.06,3>, <17.54,20.63,3> }
		triangle { <17.54,20.63,3>, <16.96,19.82,3>, <16.96,19.82,-3> }
		triangle { <16.96,19.82,-3>, <17.54,20.63,-3>, <17.54,20.63,3> }
		triangle { <7.646,18.41,10>, <10.4,17.01,10>, <10.4,17.01,-10> }
		triangle { <10.4,17.01,-10>, <7.646,18.41,-10>, <7.646,18.41,10> }
		triangle { <14.2,23.06,-3>, <13.61,22.25,-3>, <13.61,22.25,3> }
		triangle { <13.61,22.25,3>, <14.2,23.06,3>, <14.2,23.06,-3> }
		triangle { <10.31,25.04,3>, <10.31,25.04,-3>, <6.375,26.32,-3> }
		triangle { <6.375,26.32,-3>, <6.375,26.32,3>, <10.31,25.04,3> }
		triangle { <10.31,25.04,3>, <10,24.09,3>, <10,24.09,-3> }
		triangle { <10,24.09,-3>, <10.31,25.04,-3>, <10.31,25.04,3> }
		triangle { <4.637,19.39,-10>, <1.582,19.87,-10>, <1.582,19.87,10> }
		triangle { <1.582,19.87,10>, <4.637,19.39,10>, <4.637,19.39,-10> }
		triangle { <6.375,26.32,-3>, <6.066,25.37,-3>, <6.066,25.37,3> }
		triangle { <6.066,25.37,3>, <6.375,26.32,3>, <6.375,26.32,-3> }
		triangle { <2.07,27,3>, <2.07,27,-3>, <-2.07,27,-3> }
		triangle { <-2.07,27,-3>, <-2.07,27,3>, <2.07,27,3> }
		triangle { <2.07,27,3>, <2.07,26,3>, <2.07,26,-3> }
		triangle { <2.07,26,-3>, <2.07,27,-3>, <2.07,27,3> }
		triangle { <-4.637,19.39,10>, <-1.582,19.87,10>, <-1.582,19.87,-10> }
		triangle { <-1.582,19.87,-10>, <-4.637,19.39,-10>, <-4.637,19.39,10> }
		triangle { <-2.07,27,-3>, <-2.07,26,-3>, <-2.07,26,3> }
		triangle { <-2.07,26,3>, <-2.07,27,3>, <-2.07,27,-3> }
		triangle { <-6.375,26.32,-3>, <-10.31,25.04,-3>, <-10.31,25.04,3> }
		triangle { <-10.31,25.04,3>, <-6.375,26.32,3>, <-6.375,26.32,-3> }
		triangle { <-6.375,26.32,3>, <-6.066,25.37,3>, <-6.066,25.37,-3> }
		triangle { <-6.066,25.37,-3>, <-6.375,26.32,-3>, <-6.375,26.32,3> }
		triangle { <-7.646,18.41,-10>, <-10.4,17.01,-10>, <-10.4,17.01,10> }
		triangle { <-10.4,17.01,10>, <-7.646,18.41,10>, <-7.646,18.41,-10> }
		triangle { <-10.31,25.04,-3>, <-10,24.09,-3>, <-10,24.09,3> }
		triangle { <-10,24.09,3>, <-10.31,25.04,3>, <-10.31,25.04,-3> }
		triangle { <-14.2,23.06,3>, <-14.2,23.06,-3>, <-17.54,20.63,-3> }
		triangle { <-17.54,20.63,-3>, <-17.54,20.63,3>, <-14.2,23.06,3> }
		triangle { <-14.2,23.06,3>, <-13.61,22.25,3>, <-13.61,22.25,-3> }
		triangle { <-13.61,22.25,-3>, <-14.2,23.06,-3>, <-14.2,23.06,3> }
		triangle { <-12.96,15.15,-10>, <-15.15,12.96,-10>, <-15.15,12.96,10> }
		triangle { <-15.15,12.96,10>, <-12.96,15.15,10>, <-12.96,15.15,-10> }
		triangle { <-17.54,20.63,-3>, <-16.96,19.82,-3>, <-16.96,19.82,3> }
		triangle { <-16.96,19.82,3>, <-17.54,20.63,3>, <-17.54,20.63,-3> }
		triangle { <-20.63,17.54,3>, <-20.63,17.54,-3>, <-23.06,14.2,-3> }
		triangle { <-23.06,14.2,-3>, <-23.06,14.2,3>, <-20.63,17.54,3> }
		triangle { <-20.63,17.54,3>, <-19.82,16.96,3>, <-19.82,16.96,-3> }
		triangle { <-19.82,16.96,-3>, <-20.63,17.54,-3>, <-20.63,17.54,3> }
		triangle { <-17.01,10.4,-10>, <-18.41,7.646,-10>, <-18.41,7.646,10> }
		triangle { <-18.41,7.646,10>, <-17.01,10.4,10>, <-17.01,10.4,-10> }
		triangle { <-23.06,14.2,-3>, <-22.25,13.61,-3>, <-22.25,13.61,3> }
		triangle { <-22.25,13.61,3>, <-23.06,14.2,3>, <-23.06,14.2,-3> }
		triangle { <-25.04,10.31,3>, <-25.04,10.31,-3>, <-26.32,6.375,-3> }
		triangle { <-26.32,6.375,-3>, <-26.32,6.375,3>, <-25.04,10.31,3> }
		triangle { <-25.04,10.31,3>, <-24.09,10,3>, <-24.09,10,-3> }
		triangle { <-24.09,10,-3>, <-25.04,10.31,-3>, <-25.04,10.31,3> }
		triangle { <-26.32,6.375,-3>, <-25.37,6.066,-3>, <-25.37,6.066,3> }
		triangle { <-25.37,6.066,3>, <-26.32,6.375,3>, <-26.32,6.375,-3> }
		triangle { <-19.39,-4.637,-10>, <-21.87,-7.107,-10>, <-24.73,-8.034,-8> }
		triangle { <-25.37,-6.066,-3>, <-19.39,-4.637,-10>, <-24.73,-8.034,-8> }
		triangle { <-17.01,-10.4,-10>, <-18.61,-13.52,-10>, <-21.03,-15.28,-8> }
		triangle { <-22.25,-13.61,-3>, <-17.01,-10.4,-10>, <-21.03,-15.28,-8> }
		triangle { <-12.96,-15.15,-10>, <-13.52,-18.61,-10>, <-15.28,-21.03,-8> }
		triangle { <-16.96,-19.82,-3>, <-12.96,-15.15,-10>, <-15.28,-21.03,-8> }
		triangle { <-7.646,-18.41,-10>, <-7.107,-21.87,-10>, <-8.034,-24.73,-8> }
		triangle { <-10,-24.09,-3>, <-7.646,-18.41,-10>, <-8.034,-24.73,-8> }
		triangle { <-1.582,-19.87,-10>, <0,-23,-10>, <0,-26,-8> }
		triangle { <-2.07,-26,-3>, <-1.582,-19.87,-10>, <0,-26,-8> }
		triangle { <4.637,-19.39,-10>, <7.107,-21.87,-10>, <8.034,-24.73,-8> }
		triangle { <6.066,-25.37,-3>, <4.637,-19.39,-10>, <8.034,-24.73,-8> }
		triangle { <10.4,-17.01,-10>, <13.52,-18.61,-10>, <15.28,-21.03,-8> }
		triangle { <13.61,-22.25,-3>, <10.4,-17.01,-10>, <15.28,-21.03,-8> }
		triangle { <15.15,-12.96,-10>, <18.61,-13.52,-10>, <21.03,-15.28,-8> }
		triangle { <19.82,-16.96,-3>, <15.15,-12.96,-10>, <21.03,-15.28,-8> }
		triangle { <18.41,-7.646,-10>, <21.87,-7.107,-10>, <24.73,-8.034,-8> }
		triangle { <24.09,-10,-3>, <18.41,-7.646,-10>, <24.73,-8.034,-8> }
		triangle { <19.87,-1.582,-10>, <23,0,-10>, <26,0,-8> }
		triangle { <26,-2.07,-3>, <19.87,-1.582,-10>, <26,0,-8> }
		triangle { <19.39,4.637,-10>, <21.87,7.107,-10>, <24.73,8.034,-8> }
		triangle { <25.37,6.066,-3>, <19.39,4.637,-10>, <24.73,8.034,-8> }
		triangle { <17.01,10.4,-10>, <18.61,13.52,-10>, <21.03,15.28,-8> }
		triangle { <22.25,13.61,-3>, <17.01,10.4,-10>, <21.03,15.28,-8> }
		triangle { <12.96,15.15,-10>, <13.52,18.61,-10>, <15.28,21.03,-8> }
		triangle { <16.96,19.82,-3>, <12.96,15.15,-10>, <15.28,21.03,-8> }
		triangle { <7.646,18.41,-10>, <7.107,21.87,-10>, <8.034,24.73,-8> }
		triangle { <10,24.09,-3>, <7.646,18.41,-10>, <8.034,24.73,-8> }
		triangle { <1.582,19.87,-10>, <0,23,-10>, <0,26,-8> }
		triangle { <2.07,26,-3>, <1.582,19.87,-10>, <0,26,-8> }
		triangle { <-4.637,19.39,-10>, <-7.107,21.87,-10>, <-8.034,24.73,-8> }
		triangle { <-6.066,25.37,-3>, <-4.637,19.39,-10>, <-8.034,24.73,-8> }
		triangle { <-10.4,17.01,-10>, <-13.52,18.61,-10>, <-15.28,21.03,-8> }
		triangle { <-13.61,22.25,-3>, <-10.4,17.01,-10>, <-15.28,21.03,-8> }
		triangle { <-15.15,12.96,-10>, <-18.61,13.52,-10>, <-21.03,15.28,-8> }
		triangle { <-19.82,16.96,-3>, <-15.15,12.96,-10>, <-21.03,15.28,-8> }
		triangle { <-18.41,7.646,-10>, <-21.87,7.107,-10>, <-24.73,8.034,-8> }
		triangle { <-24.09,10,-3>, <-18.41,7.646,-10>, <-24.73,8.034,-8> }
		triangle { <-24.09,-10,3>, <-18.41,-7.646,10>, <-24.73,-8.034,8> }
		triangle { <-24.73,-8.034,8>, <-21.87,-7.107,10>, <-19.39,-4.637,10> }
		triangle { <-24.73,-8.034,8>, <-19.39,-4.637,10>, <-25.37,-6.066,3> }
		triangle { <-19.82,-16.96,3>, <-15.15,-12.96,10>, <-21.03,-15.28,8> }
		triangle { <-21.03,-15.28,8>, <-18.61,-13.52,10>, <-17.01,-10.4,10> }
		triangle { <-21.03,-15.28,8>, <-17.01,-10.4,10>, <-22.25,-13.61,3> }
		triangle { <-13.61,-22.25,3>, <-10.4,-17.01,10>, <-15.28,-21.03,8> }
		triangle { <-15.28,-21.03,8>, <-13.52,-18.61,10>, <-12.96,-15.15,10> }
		triangle { <-15.28,-21.03,8>, <-12.96,-15.15,10>, <-16.96,-19.82,3> }
		triangle { <-6.066,-25.37,3>, <-4.637,-19.39,10>, <-8.034,-24.73,8> }
		triangle { <-8.034,-24.73,8>, <-7.107,-21.87,10>, <-7.646,-18.41,10> }
		triangle { <-8.034,-24.73,8>, <-7.646,-18.41,10>, <-10,-24.09,3> }
		triangle { <2.07,-26,3>, <1.582,-19.87,10>, <0,-26,8> }
		triangle { <0,-26,8>, <0,-23,10>, <-1.582,-19.87,10> }
		triangle { <0,-26,8>, <-1.582,-19.87,10>, <-2.07,-26,3> }
		triangle { <10,-24.09,3>, <7.646,-18.41,10>, <8.034,-24.73,8> }
		triangle { <8.034,-24.73,8>, <7.107,-21.87,10>, <4.637,-19.39,10> }
		triangle { <8.034,-24.73,8>, <4.637,-19.39,10>, <6.066,-25.37,3> }
		triangle { <16.96,-19.82,3>, <12.96,-15.15,10>, <15.28,-21.03,8> }
		triangle { <15.28,-21.03,8>, <13.52,-18.61,10>, <10.4,-17.01,10> }
		triangle { <15.28,-21.03,8>, <10.4,-17.01,10>, <13.61,-22.25,3> }
		triangle { <22.25,-13.61,3>, <17.01,-10.4,10>, <21.03,-15.28,8> }
		triangle { <21.03,-15.28,8>, <18.61,-13.52,10>, <15.15,-12.96,10> }
		triangle { <21.03,-15.28,8>, <15.15,-12.96,10>, <19.82,-16.96,3> }
		triangle { <25.37,-6.066,3>, <19.39,-4.637,10>, <24.73,-8.034,8> }
		triangle { <24.73,-8.034,8>, <21.87,-7.107,10>, <18.41,-7.646,10> }
		triangle { <24.73,-8.034,8>, <18.41,-7.646,10>, <24.09,-10,3> }
		triangle { <26,2.07,3>, <19.87,1.582,10>, <26,0,8> }
		triangle { <26,0,8>, <23,0,10>, <19.87,-1.582,10> }
		triangle { <26,0,8>, <19.87,-1.582,10>, <26,-2.07,3> }
		triangle { <24.09,10,3>, <18.41,7.646,10>, <24.73,8.034,8> }
		triangle { <24.73,8.034,8>, <21.87,7.107,10>, <19.39,4.637,10> }
		triangle { <24.73,8.034,8>, <19.39,4.637,10>, <25.37,6.066,3> }
		triangle { <19.82,16.96,3>, <15.15,12.96,10>, <21.03,15.28,8> }
		triangle { <21.03,15.28,8>, <18.61,13.52,10>, <17.01,10.4,10> }
		triangle { <21.03,15.28,8>, <17.01,10.4,10>, <22.25,13.61,3> }
		triangle { <13.61,22.25,3>, <10.4,17.01,10>, <15.28,21.03,8> }
		triangle { <15.28,21.03,8>, <13.52,18.61,10>, <12.96,15.15,10> }
		triangle { <15.28,21.03,8>, <12.96,15.15,10>, <16.96,19.82,3> }
		triangle { <6.066,25.37,3>, <4.637,19.39,10>, <8.034,24.73,8> }
		triangle { <8.034,24.73,8>, <7.107,21.87,10>, <7.646,18.41,10> }
		triangle { <8.034,24.73,8>, <7.646,18.41,10>, <10,24.09,3> }
		triangle { <-2.07,26,3>, <-1.582,19.87,10>, <0,26,8> }
		triangle { <0,26,8>, <0,23,10>, <1.582,19.87,10> }
		triangle { <0,26,8>, <1.582,19.87,10>, <2.07,26,3> }
		triangle { <-10,24.09,3>, <-7.646,18.41,10>, <-8.034,24.73,8> }
		triangle { <-8.034,24.73,8>, <-7.107,21.87,10>, <-4.637,19.39,10> }
		triangle { <-8.034,24.73,8>, <-4.637,19.39,10>, <-6.066,25.37,3> }
		triangle { <-16.96,19.82,3>, <-12.96,15.15,10>, <-15.28,21.03,8> }
		triangle { <-15.28,21.03,8>, <-13.52,18.61,10>, <-10.4,17.01,10> }
		triangle { <-15.28,21.03,8>, <-10.4,17.01,10>, <-13.61,22.25,3> }
		triangle { <-22.25,13.61,3>, <-17.01,10.4,10>, <-21.03,15.28,8> }
		triangle { <-21.03,15.28,8>, <-18.61,13.52,10>, <-15.15,12.96,10> }
		triangle { <-21.03,15.28,8>, <-15.15,12.96,10>, <-19.82,16.96,3> }
		triangle { <-25.37,6.066,3>, <-19.39,4.637,10>, <-24.73,8.034,8> }
		triangle { <-24.73,8.034,8>, <-21.87,7.107,10>, <-18.41,7.646,10> }
		triangle { <-24.73,8.034,8>, <-18.41,7.646,10>, <-24.09,10,3> }
		triangle { <-18.41,-7.646,-10>, <-24.09,-10,-3>, <-24.73,-8.034,-8> }
		triangle { <-15.15,-12.96,-10>, <-19.82,-16.96,-3>, <-21.03,-15.28,-8> }
		triangle { <-10.4,-17.01,-10>, <-13.61,-22.25,-3>, <-15.28,-21.03,-8> }
		triangle { <-4.637,-19.39,-10>, <-6.066,-25.37,-3>, <-8.034,-24.73,-8> }
		triangle { <1.582,-19.87,-10>, <2.07,-26,-3>, <0,-26,-8> }
		triangle { <7.646,-18.41,-10>, <10,-24.09,-3>, <8.034,-24.73,-8> }
		triangle { <12.96,-15.15,-10>, <16.96,-19.82,-3>, <15.28,-21.03,-8> }
		triangle { <17.01,-10.4,-10>, <22.25,-13.61,-3>, <21.03,-15.28,-8> }
		triangle { <19.39,-4.637,-10>, <25.37,-6.066,-3>, <24.73,-8.034,-8> }
		triangle { <19.87,1.582,-10>, <26,2.07,-3>, <26,0,-8> }
		triangle { <18.41,7.646,-10>, <24.09,10,-3>, <24.73,8.034,-8> }
		triangle { <15.15,12.96,-10>, <19.82,16.96,-3>, <21.03,15.28,-8> }
		triangle { <10.4,17.01,-10>, <13.61,22.25,-3>, <15.28,21.03,-8> }
		triangle { <4.637,19.39,-10>, <6.066,25.37,-3>, <8.034,24.73,-8> }
		triangle { <-1.582,19.87,-10>, <-2.07,26,-3>, <0,26,-8> }
		triangle { <-7.646,18.41,-10>, <-10,24.09,-3>, <-8.034,24.73,-8> }
		triangle { <-12.96,15.15,-10>, <-16.96,19.82,-3>, <-15.28,21.03,-8> }
		triangle { <-17.01,10.4,-10>, <-22.25,13.61,-3>, <-21.03,15.28,-8> }
		triangle { <-19.39,4.637,-10>, <-25.37,6.066,-3>, <-24.73,8.034,-8> }
		triangle { <-2,-5.657,-10>, <-2,-2,-10>, <-2,-2,10> }
		triangle { <-2,-2,10>, <-2,-5.657,10>, <-2,-5.657,-10> }
		triangle { <-2,-2,-10>, <-5.657,-2,-10>, <-5.657,-2,10> }
		triangle { <-5.657,-2,10>, <-2,-2,10>, <-2,-2,-10> }
		triangle { <-5.657,-2,-10>, <-5.828,-1,-10>, <-5.828,-1,10> }
		triangle { <-5.828,-1,10>, <-5.657,-2,10>, <-5.657,-2,-10> }
		triangle { <-5.828,-1,-10>, <-10,-1,-10>, <-10,-1,10> }
		triangle { <-10,-1,10>, <-5.828,-1,10>, <-5.828,-1,-10> }
		triangle { <-10,1,-10>, <-5.801,1,-10>, <-5.801,1,10> }
		triangle { <-5.801,1,10>, <-10,1,10>, <-10,1,-10> }
		triangle { <-5.801,1,-10>, <-5.543,2.296,-10>, <-5.543,2.296,10> }
		triangle { <-5.543,2.296,10>, <-5.801,1,10>, <-5.801,1,-10> }
		triangle { <-5.543,2.296,-10>, <-4.803,3.597,-10>, <-4.803,3.597,10> }
		triangle { <-4.803,3.597,10>, <-5.543,2.296,10>, <-5.543,2.296,-10> }
		triangle { <-4.803,3.597,-10>, <-2.5,2.5,-10>, <-2.5,2.5,10> }
		triangle { <-2.5,2.5,10>, <-4.803,3.597,10>, <-4.803,3.597,-10> }
		triangle { <-2.5,2.5,-10>, <-3.597,4.803,-10>, <-3.597,4.803,10> }
		triangle { <-3.597,4.803,10>, <-2.5,2.5,10>, <-2.5,2.5,-10> }
		triangle { <-3.597,4.803,-10>, <-2.296,5.543,-10>, <-2.296,5.543,10> }
		triangle { <-2.296,5.543,10>, <-3.597,4.803,10>, <-3.597,4.803,-10> }
		triangle { <-2.296,5.543,-10>, <-1,5.801,-10>, <-1,5.801,10> }
		triangle { <-1,5.801,10>, <-2.296,5.543,10>, <-2.296,5.543,-10> }
		triangle { <-1,5.801,-10>, <-1,10,-10>, <-1,10,10> }
		triangle { <-1,10,10>, <-1,5.801,10>, <-1,5.801,-10> }
		triangle { <1,10,-10>, <1,5.828,-10>, <1,5.828,10> }
		triangle { <1,5.828,10>, <1,10,10>, <1,10,-10> }
		triangle { <1,5.828,-10>, <2,5.657,-10>, <2,5.657,10> }
		triangle { <2,5.657,10>, <1,5.828,10>, <1,5.828,-10> }
		triangle { <2,5.657,-10>, <2,2,-10>, <2,2,10> }
		triangle { <2,2,10>, <2,5.657,10>, <2,5.657,-10> }
		triangle { <2,2,-10>, <5.657,2,-10>, <5.657,2,10> }
		triangle { <5.657,2,10>, <2,2,10>, <2,2,-10> }
		triangle { <5.657,2,-10>, <5.828,1,-10>, <5.828,1,10> }
		triangle { <5.828,1,10>, <5.657,2,10>, <5.657,2,-10> }
		triangle { <5.828,1,-10>, <10,1,-10>, <10,1,10> }
		triangle { <10,1,10>, <5.828,1,10>, <5.828,1,-10> }
		triangle { <10,-1,-10>, <5.801,-1,-10>, <5.801,-1,10> }
		triangle { <5.801,-1,10>, <10,-1,10>, <10,-1,-10> }
		triangle { <5.801,-1,-10>, <5.543,-2.296,-10>, <5.543,-2.296,10> }
		triangle { <5.543,-2.296,10>, <5.801,-1,10>, <5.801,-1,-10> }
		triangle { <5.543,-2.296,-10>, <4.803,-3.597,-10>, <4.803,-3.597,10> }
		triangle { <4.803,-3.597,10>, <5.543,-2.296,10>, <5.543,-2.296,-10> }
		triangle { <4.803,-3.597,-10>, <2.5,-2.5,-10>, <2.5,-2.5,10> }
		triangle { <2.5,-2.5,10>, <4.803,-3.597,10>, <4.803,-3.597,-10> }
		triangle { <2.5,-2.5,-10>, <3.597,-4.803,-10>, <3.597,-4.803,10> }
		triangle { <3.597,-4.803,10>, <2.5,-2.5,10>, <2.5,-2.5,-10> }
		triangle { <3.597,-4.803,-10>, <2.296,-5.543,-10>, <2.296,-5.543,10> }
		triangle { <2.296,-5.543,10>, <3.597,-4.803,10>, <3.597,-4.803,-10> }
		triangle { <2.296,-5.543,-10>, <1,-5.801,-10>, <1,-5.801,10> }
		triangle { <1,-5.801,10>, <2.296,-5.543,10>, <2.296,-5.543,-10> }
		triangle { <1,-5.801,-10>, <1,-10,-10>, <1,-10,10> }
		triangle { <1,-10,10>, <1,-5.801,10>, <1,-5.801,-10> }
		triangle { <-1,-10,-10>, <-1,-5.828,-10>, <-1,-5.828,10> }
		triangle { <-1,-5.828,10>, <-1,-10,10>, <-1,-10,-10> }
		triangle { <-1,-5.828,10>, <-1,-5.828,-10>, <-2,-5.657,-10> }
		triangle { <-2,-5.657,-10>, <-2,-5.657,10>, <-1,-5.828,10> }
		triangle { <-16.73,-3,-1>, <-16.73,-3,1>, <-15.51,-6.965,10> }
		triangle { <-15.51,-6.965,10>, <-15.51,-6.965,-10>, <-16.73,-3,-1> }
		triangle { <-15.51,-6.965,-10>, <-15.51,-6.965,10>, <-12.02,-12.02,10> }
		triangle { <-12.02,-12.02,10>, <-12.02,-12.02,-10>, <-15.51,-6.965,-10> }
		triangle { <-12.02,-12.02,-10>, <-12.02,-12.02,10>, <-6.965,-15.51,10> }
		triangle { <-6.965,-15.51,10>, <-6.965,-15.51,-10>, <-12.02,-12.02,-10> }
		triangle { <-6.965,-15.51,-10>, <-6.965,-15.51,10>, <-3,-16.73,1> }
		triangle { <-3,-16.73,1>, <-3,-16.73,-1>, <-6.965,-15.51,-10> }
		triangle { <-6.965,-15.51,-10>, <-3,-16.73,-1>, <-1,-16.97,-10> }
		triangle { <-1,-16.97,-10>, <-3,-16.73,-1>, <-2.004,-16.88,-1> }
		triangle { <-1,-16.97,-10>, <-2.004,-16.88,-1>, <-1,-16.97,-1> }
		triangle { <-1,-16.97,1>, <-2.004,-16.88,1>, <-1,-16.97,10> }
		triangle { <-1,-16.97,10>, <-2.004,-16.88,1>, <-3,-16.73,1> }
		triangle { <-1,-16.97,10>, <-3,-16.73,1>, <-6.965,-15.51,10> }
		triangle { <-15.51,-6.965,10>, <-16.73,-3,1>, <-16.97,-1,10> }
		triangle { <-16.97,-1,10>, <-16.73,-3,1>, <-16.88,-2.004,1> }
		triangle { <-16.97,-1,10>, <-16.88,-2.004,1>, <-16.97,-1,1> }
		triangle { <-16.97,-1,-1>, <-16.88,-2.004,-1>, <-16.97,-1,-10> }
		triangle { <-16.97,-1,-10>, <-16.88,-2.004,-1>, <-16.73,-3,-1> }
		triangle { <-16.97,-1,-10>, <-16.73,-3,-1>, <-15.51,-6.965,-10> }
		triangle { <-16.97,-1,1>, <-11.96,-1,1>, <-11.96,-1,10> }
		triangle { <-11.96,-1,10>, <-16.97,-1,10>, <-16.97,-1,1> }
		triangle { <-11.62,-3,1>, <-11.62,-3,10>, <-11.96,-1,10> }
		triangle { <-11.96,-1,10>, <-11.96,-1,1>, <-11.62,-3,1> }
		triangle { <-3,-11.62,1>, <-1,-11.96,1>, <-1,-11.96,10> }
		triangle { <-1,-11.96,10>, <-3,-11.62,10>, <-3,-11.62,1> }
		triangle { <-1,-11.96,10>, <-1,-11.96,1>, <-1,-16.97,1> }
		triangle { <-1,-16.97,1>, <-1,-16.97,10>, <-1,-11.96,10> }
		triangle { <11.62,-3,1>, <11.96,-1,1>, <11.96,-1,10> }
		triangle { <11.96,-1,10>, <11.62,-3,10>, <11.62,-3,1> }
		triangle { <11.96,-1,1>, <16.97,-1,1>, <16.97,-1,10> }
		triangle { <16.97,-1,10>, <11.96,-1,10>, <11.96,-1,1> }
		triangle { <3,-16.73,-1>, <3,-16.73,1>, <6.965,-15.51,10> }
		triangle { <6.965,-15.51,10>, <6.965,-15.51,-10>, <3,-16.73,-1> }
		triangle { <6.965,-15.51,-10>, <6.965,-15.51,10>, <12.02,-12.02,10> }
		triangle { <12.02,-12.02,10>, <12.02,-12.02,-10>, <6.965,-15.51,-10> }
		triangle { <12.02,-12.02,-10>, <12.02,-12.02,10>, <15.51,-6.965,10> }
		triangle { <15.51,-6.965,10>, <15.51,-6.965,-10>, <12.02,-12.02,-10> }
		triangle { <15.51,-6.965,-10>, <15.51,-6.965,10>, <16.73,-3,1> }
		triangle { <16.73,-3,1>, <16.73,-3,-1>, <15.51,-6.965,-10> }
		triangle { <15.51,-6.965,-10>, <16.73,-3,-1>, <16.97,-1,-10> }
		triangle { <16.97,-1,-10>, <16.73,-3,-1>, <16.88,-2.004,-1> }
		triangle { <16.97,-1,-10>, <16.88,-2.004,-1>, <16.97,-1,-1> }
		triangle { <16.97,-1,1>, <16.88,-2.004,1>, <16.97,-1,10> }
		triangle { <16.97,-1,10>, <16.88,-2.004,1>, <16.73,-3,1> }
		triangle { <16.97,-1,10>, <16.73,-3,1>, <15.51,-6.965,10> }
		triangle { <6.965,-15.51,10>, <3,-16.73,1>, <1,-16.97,10> }
		triangle { <1,-16.97,10>, <3,-16.73,1>, <2.004,-16.88,1> }
		triangle { <1,-16.97,10>, <2.004,-16.88,1>, <1,-16.97,1> }
		triangle { <1,-16.97,-1>, <2.004,-16.88,-1>, <1,-16.97,-10> }
		triangle { <1,-16.97,-10>, <2.004,-16.88,-1>, <3,-16.73,-1> }
		triangle { <1,-16.97,-10>, <3,-16.73,-1>, <6.965,-15.51,-10> }
		triangle { <1,-16.97,1>, <1,-11.96,1>, <1,-11.96,10> }
		triangle { <1,-11.96,10>, <1,-16.97,10>, <1,-16.97,1> }
		triangle { <3,-11.62,1>, <3,-11.62,10>, <1,-11.96,10> }
		triangle { <1,-11.96,10>, <1,-11.96,1>, <3,-11.62,1> }
		triangle { <-1,11.96,1>, <-3,11.62,1>, <-3,11.62,10> }
		triangle { <-3,11.62,10>, <-1,11.96,10>, <-1,11.96,1> }
		triangle { <-11.62,3,1>, <-11.96,1,1>, <-11.96,1,10> }
		triangle { <-11.96,1,10>, <-11.62,3,10>, <-11.62,3,1> }
		triangle { <-11.96,1,1>, <-16.97,1,1>, <-16.97,1,10> }
		triangle { <-16.97,1,10>, <-11.96,1,10>, <-11.96,1,1> }
		triangle { <-3,16.73,-1>, <-3,16.73,1>, <-6.965,15.51,10> }
		triangle { <-6.965,15.51,10>, <-6.965,15.51,-10>, <-3,16.73,-1> }
		triangle { <-6.965,15.51,-10>, <-6.965,15.51,10>, <-12.02,12.02,10> }
		triangle { <-12.02,12.02,10>, <-12.02,12.02,-10>, <-6.965,15.51,-10> }
		triangle { <-12.02,12.02,-10>, <-12.02,12.02,10>, <-15.51,6.965,10> }
		triangle { <-15.51,6.965,10>, <-15.51,6.965,-10>, <-12.02,12.02,-10> }
		triangle { <-15.51,6.965,-10>, <-15.51,6.965,10>, <-16.73,3,1> }
		triangle { <-16.73,3,1>, <-16.73,3,-1>, <-15.51,6.965,-10> }
		triangle { <-15.51,6.965,-10>, <-16.73,3,-1>, <-16.97,1,-10> }
		triangle { <-16.97,1,-10>, <-16.73,3,-1>, <-16.88,2.004,-1> }
		triangle { <-16.97,1,-10>, <-16.88,2.004,-1>, <-16.97,1,-1> }
		triangle { <-16.97,1,1>, <-16.88,2.004,1>, <-16.97,1,10> }
		triangle { <-16.97,1,10>, <-16.88,2.004,1>, <-16.73,3,1> }
		triangle { <-16.97,1,10>, <-16.73,3,1>, <-15.51,6.965,10> }
		triangle { <-6.965,15.51,10>, <-3,16.73,1>, <-1,16.97,10> }
		triangle { <-1,16.97,10>, <-3,16.73,1>, <-2.004,16.88,1> }
		triangle { <-1,16.97,10>, <-2.004,16.88,1>, <-1,16.97,1> }
		triangle { <-1,16.97,-1>, <-2.004,16.88,-1>, <-1,16.97,-10> }
		triangle { <-1,16.97,-10>, <-2.004,16.88,-1>, <-3,16.73,-1> }
		triangle { <-1,16.97,-10>, <-3,16.73,-1>, <-6.965,15.51,-10> }
		triangle { <-1,16.97,10>, <-1,16.97,1>, <-1,11.96,1> }
		triangle { <-1,11.96,1>, <-1,11.96,10>, <-1,16.97,10> }
		triangle { <11.96,1,1>, <11.62,3,1>, <11.62,3,10> }
		triangle { <11.62,3,10>, <11.96,1,10>, <11.96,1,1> }
		triangle { <3,11.62,1>, <1,11.96,1>, <1,11.96,10> }
		triangle { <1,11.96,10>, <3,11.62,10>, <3,11.62,1> }
		triangle { <1,11.96,1>, <1,16.97,1>, <1,16.97,10> }
		triangle { <1,16.97,10>, <1,11.96,10>, <1,11.96,1> }
		triangle { <16.73,3,-1>, <16.73,3,1>, <15.51,6.965,10> }
		triangle { <15.51,6.965,10>, <15.51,6.965,-10>, <16.73,3,-1> }
		triangle { <15.51,6.965,-10>, <15.51,6.965,10>, <12.02,12.02,10> }
		triangle { <12.02,12.02,10>, <12.02,12.02,-10>, <15.51,6.965,-10> }
		triangle { <12.02,12.02,-10>, <12.02,12.02,10>, <6.965,15.51,10> }
		triangle { <6.965,15.51,10>, <6.965,15.51,-10>, <12.02,12.02,-10> }
		triangle { <6.965,15.51,-10>, <6.965,15.51,10>, <3,16.73,1> }
		triangle { <3,16.73,1>, <3,16.73,-1>, <6.965,15.51,-10> }
		triangle { <6.965,15.51,-10>, <3,16.73,-1>, <1,16.97,-10> }
		triangle { <1,16.97,-10>, <3,16.73,-1>, <2.004,16.88,-1> }
		triangle { <1,16.97,-10>, <2.004,16.88,-1>, <1,16.97,-1> }
		triangle { <1,16.97,1>, <2.004,16.88,1>, <1,16.97,10> }
		triangle { <1,16.97,10>, <2.004,16.88,1>, <3,16.73,1> }
		triangle { <1,16.97,10>, <3,16.73,1>, <6.965,15.51,10> }
		triangle { <15.51,6.965,10>, <16.73,3,1>, <16.97,1,10> }
		triangle { <16.97,1,10>, <16.73,3,1>, <16.88,2.004,1> }
		triangle { <16.97,1,10>, <16.88,2.004,1>, <16.97,1,1> }
		triangle { <16.97,1,-1>, <16.88,2.004,-1>, <16.97,1,-10> }
		triangle { <16.97,1,-10>, <16.88,2.004,-1>, <16.73,3,-1> }
		triangle { <16.97,1,-10>, <16.73,3,-1>, <15.51,6.965,-10> }
		triangle { <16.97,1,10>, <16.97,1,1>, <11.96,1,1> }
		triangle { <11.96,1,1>, <11.96,1,10>, <16.97,1,10> }
// 
	}
}
#end

#declare _60_dot_dat = #if (QUAL = 0) box { <-32.98,-32.98,-10>, <32.98,32.98,10> } #else object {
// ~Technic Gear 24 Tooth Clutch Outside
// Name: 60.dat
// Author: (c)Marc Klein 2000 (marckl@easynet.fr)
// Based on James Jessiman's file 3648.dat
// Official LCAD Part - 2000-02 Update
	mesh {
		triangle { <0,9,-10>, <0,25,-10>, <6.47,24.15,-10> }
		triangle { <6.47,24.15,-10>, <3.44,8.31,-10>, <0,9,-10> }
		triangle { <3.44,8.31,-10>, <6.47,24.15,-10>, <12.5,21.65,-10> }
		triangle { <3.44,8.31,-10>, <12.5,21.65,-10>, <17.68,17.68,-10> }
		triangle { <17.68,17.68,-10>, <6.36,6.36,-10>, <3.44,8.31,-10> }
		triangle { <6.36,6.36,-10>, <17.68,17.68,-10>, <21.65,12.5,-10> }
		triangle { <21.65,12.5,-10>, <8.31,3.44,-10>, <6.36,6.36,-10> }
		triangle { <8.31,3.44,-10>, <21.65,12.5,-10>, <24.15,6.47,-10> }
		triangle { <8.31,3.44,-10>, <24.15,6.47,-10>, <25,0,-10> }
		triangle { <25,0,-10>, <9,0,-10>, <8.31,3.44,-10> }
		triangle { <9,0,-10>, <25,0,-10>, <24.15,-6.47,-10> }
		triangle { <24.15,-6.47,-10>, <8.31,-3.44,-10>, <9,0,-10> }
		triangle { <8.31,-3.44,-10>, <24.15,-6.47,-10>, <21.65,-12.5,-10> }
		triangle { <8.31,-3.44,-10>, <21.65,-12.5,-10>, <17.68,-17.68,-10> }
		triangle { <17.68,-17.68,-10>, <6.36,-6.36,-10>, <8.31,-3.44,-10> }
		triangle { <6.36,-6.36,-10>, <17.68,-17.68,-10>, <12.5,-21.65,-10> }
		triangle { <12.5,-21.65,-10>, <3.44,-8.31,-10>, <6.36,-6.36,-10> }
		triangle { <3.44,-8.31,-10>, <12.5,-21.65,-10>, <6.47,-24.15,-10> }
		triangle { <3.44,-8.31,-10>, <6.47,-24.15,-10>, <0,-25,-10> }
		triangle { <0,-25,-10>, <0,-9,-10>, <3.44,-8.31,-10> }
		triangle { <0,-9,-10>, <0,-25,-10>, <-6.47,-24.15,-10> }
		triangle { <-6.47,-24.15,-10>, <-3.44,-8.31,-10>, <0,-9,-10> }
		triangle { <-3.44,-8.31,-10>, <-6.47,-24.15,-10>, <-12.5,-21.65,-10> }
		triangle { <-3.44,-8.31,-10>, <-12.5,-21.65,-10>, <-17.68,-17.68,-10> }
		triangle { <-17.68,-17.68,-10>, <-6.36,-6.36,-10>, <-3.44,-8.31,-10> }
		triangle { <-6.36,-6.36,-10>, <-17.68,-17.68,-10>, <-21.65,-12.5,-10> }
		triangle { <-21.65,-12.5,-10>, <-8.31,-3.44,-10>, <-6.36,-6.36,-10> }
		triangle { <-8.31,-3.44,-10>, <-21.65,-12.5,-10>, <-24.15,-6.47,-10> }
		triangle { <-8.31,-3.44,-10>, <-24.15,-6.47,-10>, <-25,0,-10> }
		triangle { <-25,0,-10>, <-9,0,-10>, <-8.31,-3.44,-10> }
		triangle { <-9,0,-10>, <-25,0,-10>, <-24.15,6.47,-10> }
		triangle { <-24.15,6.47,-10>, <-8.31,3.44,-10>, <-9,0,-10> }
		triangle { <-8.31,3.44,-10>, <-24.15,6.47,-10>, <-21.65,12.5,-10> }
		triangle { <-8.31,3.44,-10>, <-21.65,12.5,-10>, <-17.68,17.68,-10> }
		triangle { <-17.68,17.68,-10>, <-6.36,6.36,-10>, <-8.31,3.44,-10> }
		triangle { <-6.36,6.36,-10>, <-17.68,17.68,-10>, <-12.5,21.65,-10> }
		triangle { <-12.5,21.65,-10>, <-3.44,8.31,-10>, <-6.36,6.36,-10> }
		triangle { <-3.44,8.31,-10>, <-12.5,21.65,-10>, <-6.47,24.15,-10> }
		triangle { <-3.44,8.31,-10>, <-6.47,24.15,-10>, <0,25,-10> }
		triangle { <0,25,-10>, <0,9,-10>, <-3.44,8.31,-10> }
		triangle { <0,9,10>, <0,25,10>, <6.47,24.15,10> }
		triangle { <6.47,24.15,10>, <3.44,8.31,10>, <0,9,10> }
		triangle { <3.44,8.31,10>, <6.47,24.15,10>, <12.5,21.65,10> }
		triangle { <3.44,8.31,10>, <12.5,21.65,10>, <17.68,17.68,10> }
		triangle { <17.68,17.68,10>, <6.36,6.36,10>, <3.44,8.31,10> }
		triangle { <6.36,6.36,10>, <17.68,17.68,10>, <21.65,12.5,10> }
		triangle { <21.65,12.5,10>, <8.31,3.44,10>, <6.36,6.36,10> }
		triangle { <8.31,3.44,10>, <21.65,12.5,10>, <24.15,6.47,10> }
		triangle { <8.31,3.44,10>, <24.15,6.47,10>, <25,0,10> }
		triangle { <25,0,10>, <9,0,10>, <8.31,3.44,10> }
		triangle { <9,0,10>, <25,0,10>, <24.15,-6.47,10> }
		triangle { <24.15,-6.47,10>, <8.31,-3.44,10>, <9,0,10> }
		triangle { <8.31,-3.44,10>, <24.15,-6.47,10>, <21.65,-12.5,10> }
		triangle { <8.31,-3.44,10>, <21.65,-12.5,10>, <17.68,-17.68,10> }
		triangle { <17.68,-17.68,10>, <6.36,-6.36,10>, <8.31,-3.44,10> }
		triangle { <6.36,-6.36,10>, <17.68,-17.68,10>, <12.5,-21.65,10> }
		triangle { <12.5,-21.65,10>, <3.44,-8.31,10>, <6.36,-6.36,10> }
		triangle { <3.44,-8.31,10>, <12.5,-21.65,10>, <6.47,-24.15,10> }
		triangle { <3.44,-8.31,10>, <6.47,-24.15,10>, <0,-25,10> }
		triangle { <0,-25,10>, <0,-9,10>, <3.44,-8.31,10> }
		triangle { <0,-9,10>, <0,-25,10>, <-6.47,-24.15,10> }
		triangle { <-6.47,-24.15,10>, <-3.44,-8.31,10>, <0,-9,10> }
		triangle { <-3.44,-8.31,10>, <-6.47,-24.15,10>, <-12.5,-21.65,10> }
		triangle { <-3.44,-8.31,10>, <-12.5,-21.65,10>, <-17.68,-17.68,10> }
		triangle { <-17.68,-17.68,10>, <-6.36,-6.36,10>, <-3.44,-8.31,10> }
		triangle { <-6.36,-6.36,10>, <-17.68,-17.68,10>, <-21.65,-12.5,10> }
		triangle { <-21.65,-12.5,10>, <-8.31,-3.44,10>, <-6.36,-6.36,10> }
		triangle { <-8.31,-3.44,10>, <-21.65,-12.5,10>, <-24.15,-6.47,10> }
		triangle { <-8.31,-3.44,10>, <-24.15,-6.47,10>, <-25,0,10> }
		triangle { <-25,0,10>, <-9,0,10>, <-8.31,-3.44,10> }
		triangle { <-9,0,10>, <-25,0,10>, <-24.15,6.47,10> }
		triangle { <-24.15,6.47,10>, <-8.31,3.44,10>, <-9,0,10> }
		triangle { <-8.31,3.44,10>, <-24.15,6.47,10>, <-21.65,12.5,10> }
		triangle { <-8.31,3.44,10>, <-21.65,12.5,10>, <-17.68,17.68,10> }
		triangle { <-17.68,17.68,10>, <-6.36,6.36,10>, <-8.31,3.44,10> }
		triangle { <-6.36,6.36,10>, <-17.68,17.68,10>, <-12.5,21.65,10> }
		triangle { <-12.5,21.65,10>, <-3.44,8.31,10>, <-6.36,6.36,10> }
		triangle { <-3.44,8.31,10>, <-12.5,21.65,10>, <-6.47,24.15,10> }
		triangle { <-3.44,8.31,10>, <-6.47,24.15,10>, <0,25,10> }
		triangle { <0,25,10>, <0,9,10>, <-3.44,8.31,10> }
		triangle { <25,0,-10>, <24.15,-6.47,-10>, <24.15,-6.47,-6> }
		triangle { <24.15,-6.47,-6>, <25,0,-6>, <25,0,-10> }
		triangle { <24.15,-6.47,-10>, <21.65,-12.5,-10>, <21.65,-12.5,-6> }
		triangle { <21.65,-12.5,-6>, <24.15,-6.47,-6>, <24.15,-6.47,-10> }
		triangle { <21.65,-12.5,-10>, <17.68,-17.68,-10>, <17.68,-17.68,-6> }
		triangle { <17.68,-17.68,-6>, <21.65,-12.5,-6>, <21.65,-12.5,-10> }
		triangle { <17.68,-17.68,-10>, <12.5,-21.65,-10>, <12.5,-21.65,-6> }
		triangle { <12.5,-21.65,-6>, <17.68,-17.68,-6>, <17.68,-17.68,-10> }
		triangle { <12.5,-21.65,-10>, <6.47,-24.15,-10>, <6.47,-24.15,-6> }
		triangle { <6.47,-24.15,-6>, <12.5,-21.65,-6>, <12.5,-21.65,-10> }
		triangle { <6.47,-24.15,-10>, <0,-25,-10>, <0,-25,-6> }
		triangle { <0,-25,-6>, <6.47,-24.15,-6>, <6.47,-24.15,-10> }
		triangle { <0,-25,-10>, <-6.47,-24.15,-10>, <-6.47,-24.15,-6> }
		triangle { <-6.47,-24.15,-6>, <0,-25,-6>, <0,-25,-10> }
		triangle { <-6.47,-24.15,-10>, <-12.5,-21.65,-10>, <-12.5,-21.65,-6> }
		triangle { <-12.5,-21.65,-6>, <-6.47,-24.15,-6>, <-6.47,-24.15,-10> }
		triangle { <-12.5,-21.65,-10>, <-17.68,-17.68,-10>, <-17.68,-17.68,-6> }
		triangle { <-17.68,-17.68,-6>, <-12.5,-21.65,-6>, <-12.5,-21.65,-10> }
		triangle { <-17.68,-17.68,-10>, <-21.65,-12.5,-10>, <-21.65,-12.5,-6> }
		triangle { <-21.65,-12.5,-6>, <-17.68,-17.68,-6>, <-17.68,-17.68,-10> }
		triangle { <-21.65,-12.5,-10>, <-24.15,-6.47,-10>, <-24.15,-6.47,-6> }
		triangle { <-24.15,-6.47,-6>, <-21.65,-12.5,-6>, <-21.65,-12.5,-10> }
		triangle { <-24.15,-6.47,-10>, <-25,0,-10>, <-25,0,-6> }
		triangle { <-25,0,-6>, <-24.15,-6.47,-6>, <-24.15,-6.47,-10> }
		triangle { <-25,0,-10>, <-24.15,6.47,-10>, <-24.15,6.47,-6> }
		triangle { <-24.15,6.47,-6>, <-25,0,-6>, <-25,0,-10> }
		triangle { <-24.15,6.47,-10>, <-21.65,12.5,-10>, <-21.65,12.5,-6> }
		triangle { <-21.65,12.5,-6>, <-24.15,6.47,-6>, <-24.15,6.47,-10> }
		triangle { <-21.65,12.5,-10>, <-17.68,17.68,-10>, <-17.68,17.68,-6> }
		triangle { <-17.68,17.68,-6>, <-21.65,12.5,-6>, <-21.65,12.5,-10> }
		triangle { <-17.68,17.68,-10>, <-12.5,21.65,-10>, <-12.5,21.65,-6> }
		triangle { <-12.5,21.65,-6>, <-17.68,17.68,-6>, <-17.68,17.68,-10> }
		triangle { <-12.5,21.65,-10>, <-6.47,24.15,-10>, <-6.47,24.15,-6> }
		triangle { <-6.47,24.15,-6>, <-12.5,21.65,-6>, <-12.5,21.65,-10> }
		triangle { <-6.47,24.15,-10>, <0,25,-10>, <0,25,-6> }
		triangle { <0,25,-6>, <-6.47,24.15,-6>, <-6.47,24.15,-10> }
		triangle { <0,25,-10>, <6.47,24.15,-10>, <6.47,24.15,-6> }
		triangle { <6.47,24.15,-6>, <0,25,-6>, <0,25,-10> }
		triangle { <6.47,24.15,-10>, <12.5,21.65,-10>, <12.5,21.65,-6> }
		triangle { <12.5,21.65,-6>, <6.47,24.15,-6>, <6.47,24.15,-10> }
		triangle { <12.5,21.65,-10>, <17.68,17.68,-10>, <17.68,17.68,-6> }
		triangle { <17.68,17.68,-6>, <12.5,21.65,-6>, <12.5,21.65,-10> }
		triangle { <17.68,17.68,-10>, <21.65,12.5,-10>, <21.65,12.5,-6> }
		triangle { <21.65,12.5,-6>, <17.68,17.68,-6>, <17.68,17.68,-10> }
		triangle { <21.65,12.5,-10>, <24.15,6.47,-10>, <24.15,6.47,-6> }
		triangle { <24.15,6.47,-6>, <21.65,12.5,-6>, <21.65,12.5,-10> }
		triangle { <24.15,6.47,-10>, <25,0,-10>, <25,0,-6> }
		triangle { <25,0,-6>, <24.15,6.47,-6>, <24.15,6.47,-10> }
		triangle { <25,0,6>, <24.15,-6.47,6>, <24.15,-6.47,10> }
		triangle { <24.15,-6.47,10>, <25,0,10>, <25,0,6> }
		triangle { <24.15,-6.47,6>, <21.65,-12.5,6>, <21.65,-12.5,10> }
		triangle { <21.65,-12.5,10>, <24.15,-6.47,10>, <24.15,-6.47,6> }
		triangle { <21.65,-12.5,6>, <17.68,-17.68,6>, <17.68,-17.68,10> }
		triangle { <17.68,-17.68,10>, <21.65,-12.5,10>, <21.65,-12.5,6> }
		triangle { <17.68,-17.68,6>, <12.5,-21.65,6>, <12.5,-21.65,10> }
		triangle { <12.5,-21.65,10>, <17.68,-17.68,10>, <17.68,-17.68,6> }
		triangle { <12.5,-21.65,6>, <6.47,-24.15,6>, <6.47,-24.15,10> }
		triangle { <6.47,-24.15,10>, <12.5,-21.65,10>, <12.5,-21.65,6> }
		triangle { <6.47,-24.15,6>, <0,-25,6>, <0,-25,10> }
		triangle { <0,-25,10>, <6.47,-24.15,10>, <6.47,-24.15,6> }
		triangle { <0,-25,6>, <-6.47,-24.15,6>, <-6.47,-24.15,10> }
		triangle { <-6.47,-24.15,10>, <0,-25,10>, <0,-25,6> }
		triangle { <-6.47,-24.15,6>, <-12.5,-21.65,6>, <-12.5,-21.65,10> }
		triangle { <-12.5,-21.65,10>, <-6.47,-24.15,10>, <-6.47,-24.15,6> }
		triangle { <-12.5,-21.65,6>, <-17.68,-17.68,6>, <-17.68,-17.68,10> }
		triangle { <-17.68,-17.68,10>, <-12.5,-21.65,10>, <-12.5,-21.65,6> }
		triangle { <-17.68,-17.68,6>, <-21.65,-12.5,6>, <-21.65,-12.5,10> }
		triangle { <-21.65,-12.5,10>, <-17.68,-17.68,10>, <-17.68,-17.68,6> }
		triangle { <-21.65,-12.5,6>, <-24.15,-6.47,6>, <-24.15,-6.47,10> }
		triangle { <-24.15,-6.47,10>, <-21.65,-12.5,10>, <-21.65,-12.5,6> }
		triangle { <-24.15,-6.47,6>, <-25,0,6>, <-25,0,10> }
		triangle { <-25,0,10>, <-24.15,-6.47,10>, <-24.15,-6.47,6> }
		triangle { <-25,0,6>, <-24.15,6.47,6>, <-24.15,6.47,10> }
		triangle { <-24.15,6.47,10>, <-25,0,10>, <-25,0,6> }
		triangle { <-24.15,6.47,6>, <-21.65,12.5,6>, <-21.65,12.5,10> }
		triangle { <-21.65,12.5,10>, <-24.15,6.47,10>, <-24.15,6.47,6> }
		triangle { <-21.65,12.5,6>, <-17.68,17.68,6>, <-17.68,17.68,10> }
		triangle { <-17.68,17.68,10>, <-21.65,12.5,10>, <-21.65,12.5,6> }
		triangle { <-17.68,17.68,6>, <-12.5,21.65,6>, <-12.5,21.65,10> }
		triangle { <-12.5,21.65,10>, <-17.68,17.68,10>, <-17.68,17.68,6> }
		triangle { <-12.5,21.65,6>, <-6.47,24.15,6>, <-6.47,24.15,10> }
		triangle { <-6.47,24.15,10>, <-12.5,21.65,10>, <-12.5,21.65,6> }
		triangle { <-6.47,24.15,6>, <0,25,6>, <0,25,10> }
		triangle { <0,25,10>, <-6.47,24.15,10>, <-6.47,24.15,6> }
		triangle { <0,25,6>, <6.47,24.15,6>, <6.47,24.15,10> }
		triangle { <6.47,24.15,10>, <0,25,10>, <0,25,6> }
		triangle { <6.47,24.15,6>, <12.5,21.65,6>, <12.5,21.65,10> }
		triangle { <12.5,21.65,10>, <6.47,24.15,10>, <6.47,24.15,6> }
		triangle { <12.5,21.65,6>, <17.68,17.68,6>, <17.68,17.68,10> }
		triangle { <17.68,17.68,10>, <12.5,21.65,10>, <12.5,21.65,6> }
		triangle { <17.68,17.68,6>, <21.65,12.5,6>, <21.65,12.5,10> }
		triangle { <21.65,12.5,10>, <17.68,17.68,10>, <17.68,17.68,6> }
		triangle { <21.65,12.5,6>, <24.15,6.47,6>, <24.15,6.47,10> }
		triangle { <24.15,6.47,10>, <21.65,12.5,10>, <21.65,12.5,6> }
		triangle { <24.15,6.47,6>, <25,0,6>, <25,0,10> }
		triangle { <25,0,10>, <24.15,6.47,10>, <24.15,6.47,6> }
// James Jessimans original file follows:
// Inlined: 3648.dat
// Technic Gear 24 Tooth (needs work)
		triangle { <26.87,2.65,-6>, <32.98,1.08,-6>, <32.98,1.08,6> }
		triangle { <32.98,1.08,6>, <26.87,2.65,6>, <26.87,2.65,-6> }
		triangle { <32.98,1.08,-6>, <32.98,-1.08,-6>, <32.98,-1.08,6> }
		triangle { <32.98,-1.08,6>, <32.98,1.08,6>, <32.98,1.08,-6> }
		triangle { <32.98,-1.08,-6>, <26.87,-2.65,-6>, <26.87,-2.65,6> }
		triangle { <26.87,-2.65,6>, <32.98,-1.08,6>, <32.98,-1.08,-6> }
		triangle { <26.87,-2.65,-6>, <26.64,-4.4,-6>, <26.64,-4.4,6> }
		triangle { <26.64,-4.4,6>, <26.87,-2.65,6>, <26.87,-2.65,-6> }
		triangle { <26.87,2.65,-6>, <32.98,1.08,-6>, <32.98,-1.08,-6> }
		triangle { <32.98,-1.08,-6>, <26.87,-2.65,-6>, <26.87,2.65,-6> }
		triangle { <26.87,2.65,6>, <32.98,1.08,6>, <32.98,-1.08,6> }
		triangle { <32.98,-1.08,6>, <26.87,-2.65,6>, <26.87,2.65,6> }
		triangle { <26.87,2.65,-6>, <25,0,-6>, <24.15,-6.47,-6> }
		triangle { <24.15,-6.47,-6>, <26.87,-2.65,-6>, <26.87,2.65,-6> }
		triangle { <26.87,2.65,6>, <25,0,6>, <24.15,-6.47,6> }
		triangle { <24.15,-6.47,6>, <26.87,-2.65,6>, <26.87,2.65,6> }
		triangle { <26.87,-2.65,-6>, <24.15,-6.47,-6>, <26.64,-4.4,-6> }
		triangle { <26.87,-2.65,6>, <24.15,-6.47,6>, <26.64,-4.4,6> }
		triangle { <26.64,-4.4,-6>, <32.14,-7.49,-6>, <32.14,-7.49,6> }
		triangle { <32.14,-7.49,6>, <26.64,-4.4,6>, <26.64,-4.4,-6> }
		triangle { <32.14,-7.49,-6>, <31.58,-9.58,-6>, <31.58,-9.58,6> }
		triangle { <31.58,-9.58,6>, <32.14,-7.49,6>, <32.14,-7.49,-6> }
		triangle { <31.58,-9.58,-6>, <25.27,-9.51,-6>, <25.27,-9.51,6> }
		triangle { <25.27,-9.51,6>, <31.58,-9.58,6>, <31.58,-9.58,-6> }
		triangle { <25.27,-9.51,-6>, <24.59,-11.14,-6>, <24.59,-11.14,6> }
		triangle { <24.59,-11.14,6>, <25.27,-9.51,6>, <25.27,-9.51,-6> }
		triangle { <26.64,-4.4,-6>, <32.14,-7.49,-6>, <31.58,-9.58,-6> }
		triangle { <31.58,-9.58,-6>, <25.27,-9.51,-6>, <26.64,-4.4,-6> }
		triangle { <26.64,-4.4,6>, <32.14,-7.49,6>, <31.58,-9.58,6> }
		triangle { <31.58,-9.58,6>, <25.27,-9.51,6>, <26.64,-4.4,6> }
		triangle { <26.64,-4.4,-6>, <24.15,-6.47,-6>, <21.65,-12.5,-6> }
		triangle { <21.65,-12.5,-6>, <25.27,-9.51,-6>, <26.64,-4.4,-6> }
		triangle { <26.64,-4.4,6>, <24.15,-6.47,6>, <21.65,-12.5,6> }
		triangle { <21.65,-12.5,6>, <25.27,-9.51,6>, <26.64,-4.4,6> }
		triangle { <25.27,-9.51,-6>, <21.65,-12.5,-6>, <24.59,-11.14,-6> }
		triangle { <25.27,-9.51,6>, <21.65,-12.5,6>, <24.59,-11.14,6> }
		triangle { <24.59,-11.14,-6>, <29.1,-15.56,-6>, <29.1,-15.56,6> }
		triangle { <29.1,-15.56,6>, <24.59,-11.14,6>, <24.59,-11.14,-6> }
		triangle { <29.1,-15.56,-6>, <28.02,-17.43,-6>, <28.02,-17.43,6> }
		triangle { <28.02,-17.43,6>, <29.1,-15.56,6>, <29.1,-15.56,-6> }
		triangle { <28.02,-17.43,-6>, <21.95,-15.73,-6>, <21.95,-15.73,6> }
		triangle { <21.95,-15.73,6>, <28.02,-17.43,6>, <28.02,-17.43,-6> }
		triangle { <21.95,-15.73,-6>, <20.87,-17.13,-6>, <20.87,-17.13,6> }
		triangle { <20.87,-17.13,6>, <21.95,-15.73,6>, <21.95,-15.73,-6> }
		triangle { <24.59,-11.14,-6>, <29.1,-15.56,-6>, <28.02,-17.43,-6> }
		triangle { <28.02,-17.43,-6>, <21.95,-15.73,-6>, <24.59,-11.14,-6> }
		triangle { <24.59,-11.14,6>, <29.1,-15.56,6>, <28.02,-17.43,6> }
		triangle { <28.02,-17.43,6>, <21.95,-15.73,6>, <24.59,-11.14,6> }
		triangle { <24.59,-11.14,-6>, <21.65,-12.5,-6>, <17.68,-17.68,-6> }
		triangle { <17.68,-17.68,-6>, <21.95,-15.73,-6>, <24.59,-11.14,-6> }
		triangle { <24.59,-11.14,6>, <21.65,-12.5,6>, <17.68,-17.68,6> }
		triangle { <17.68,-17.68,6>, <21.95,-15.73,6>, <24.59,-11.14,6> }
		triangle { <21.95,-15.73,-6>, <17.68,-17.68,-6>, <20.87,-17.13,-6> }
		triangle { <21.95,-15.73,6>, <17.68,-17.68,6>, <20.87,-17.13,6> }
		triangle { <20.87,-17.13,-6>, <24.09,-22.56,-6>, <24.09,-22.56,6> }
		triangle { <24.09,-22.56,6>, <20.87,-17.13,6>, <20.87,-17.13,-6> }
		triangle { <24.09,-22.56,-6>, <22.56,-24.09,-6>, <22.56,-24.09,6> }
		triangle { <22.56,-24.09,6>, <24.09,-22.56,6>, <24.09,-22.56,-6> }
		triangle { <22.56,-24.09,-6>, <17.13,-20.87,-6>, <17.13,-20.87,6> }
		triangle { <17.13,-20.87,6>, <22.56,-24.09,6>, <22.56,-24.09,-6> }
		triangle { <17.13,-20.87,-6>, <15.73,-21.95,-6>, <15.73,-21.95,6> }
		triangle { <15.73,-21.95,6>, <17.13,-20.87,6>, <17.13,-20.87,-6> }
		triangle { <20.87,-17.13,-6>, <24.09,-22.56,-6>, <22.56,-24.09,-6> }
		triangle { <22.56,-24.09,-6>, <17.13,-20.87,-6>, <20.87,-17.13,-6> }
		triangle { <20.87,-17.13,6>, <24.09,-22.56,6>, <22.56,-24.09,6> }
		triangle { <22.56,-24.09,6>, <17.13,-20.87,6>, <20.87,-17.13,6> }
		triangle { <20.87,-17.13,-6>, <17.68,-17.68,-6>, <12.5,-21.65,-6> }
		triangle { <12.5,-21.65,-6>, <17.13,-20.87,-6>, <20.87,-17.13,-6> }
		triangle { <20.87,-17.13,6>, <17.68,-17.68,6>, <12.5,-21.65,6> }
		triangle { <12.5,-21.65,6>, <17.13,-20.87,6>, <20.87,-17.13,6> }
		triangle { <17.13,-20.87,-6>, <12.5,-21.65,-6>, <15.73,-21.95,-6> }
		triangle { <17.13,-20.87,6>, <12.5,-21.65,6>, <15.73,-21.95,6> }
		triangle { <15.73,-21.95,-6>, <17.43,-28.02,-6>, <17.43,-28.02,6> }
		triangle { <17.43,-28.02,6>, <15.73,-21.95,6>, <15.73,-21.95,-6> }
		triangle { <17.43,-28.02,-6>, <15.56,-29.1,-6>, <15.56,-29.1,6> }
		triangle { <15.56,-29.1,6>, <17.43,-28.02,6>, <17.43,-28.02,-6> }
		triangle { <15.56,-29.1,-6>, <11.14,-24.59,-6>, <11.14,-24.59,6> }
		triangle { <11.14,-24.59,6>, <15.56,-29.1,6>, <15.56,-29.1,-6> }
		triangle { <11.14,-24.59,-6>, <9.51,-25.27,-6>, <9.51,-25.27,6> }
		triangle { <9.51,-25.27,6>, <11.14,-24.59,6>, <11.14,-24.59,-6> }
		triangle { <15.73,-21.95,-6>, <17.43,-28.02,-6>, <15.56,-29.1,-6> }
		triangle { <15.56,-29.1,-6>, <11.14,-24.59,-6>, <15.73,-21.95,-6> }
		triangle { <15.73,-21.95,6>, <17.43,-28.02,6>, <15.56,-29.1,6> }
		triangle { <15.56,-29.1,6>, <11.14,-24.59,6>, <15.73,-21.95,6> }
		triangle { <15.73,-21.95,-6>, <12.5,-21.65,-6>, <6.47,-24.15,-6> }
		triangle { <6.47,-24.15,-6>, <11.14,-24.59,-6>, <15.73,-21.95,-6> }
		triangle { <15.73,-21.95,6>, <12.5,-21.65,6>, <6.47,-24.15,6> }
		triangle { <6.47,-24.15,6>, <11.14,-24.59,6>, <15.73,-21.95,6> }
		triangle { <11.14,-24.59,-6>, <6.47,-24.15,-6>, <9.51,-25.27,-6> }
		triangle { <11.14,-24.59,6>, <6.47,-24.15,6>, <9.51,-25.27,6> }
		triangle { <9.51,-25.27,-6>, <9.58,-31.58,-6>, <9.58,-31.58,6> }
		triangle { <9.58,-31.58,6>, <9.51,-25.27,6>, <9.51,-25.27,-6> }
		triangle { <9.58,-31.58,-6>, <7.49,-32.14,-6>, <7.49,-32.14,6> }
		triangle { <7.49,-32.14,6>, <9.58,-31.58,6>, <9.58,-31.58,-6> }
		triangle { <7.49,-32.14,-6>, <4.4,-26.64,-6>, <4.4,-26.64,6> }
		triangle { <4.4,-26.64,6>, <7.49,-32.14,6>, <7.49,-32.14,-6> }
		triangle { <4.4,-26.64,-6>, <2.65,-26.87,-6>, <2.65,-26.87,6> }
		triangle { <2.65,-26.87,6>, <4.4,-26.64,6>, <4.4,-26.64,-6> }
		triangle { <9.51,-25.27,-6>, <9.58,-31.58,-6>, <7.49,-32.14,-6> }
		triangle { <7.49,-32.14,-6>, <4.4,-26.64,-6>, <9.51,-25.27,-6> }
		triangle { <9.51,-25.27,6>, <9.58,-31.58,6>, <7.49,-32.14,6> }
		triangle { <7.49,-32.14,6>, <4.4,-26.64,6>, <9.51,-25.27,6> }
		triangle { <9.51,-25.27,-6>, <6.47,-24.15,-6>, <0,-25,-6> }
		triangle { <0,-25,-6>, <4.4,-26.64,-6>, <9.51,-25.27,-6> }
		triangle { <9.51,-25.27,6>, <6.47,-24.15,6>, <0,-25,6> }
		triangle { <0,-25,6>, <4.4,-26.64,6>, <9.51,-25.27,6> }
		triangle { <4.4,-26.64,-6>, <0,-25,-6>, <2.65,-26.87,-6> }
		triangle { <4.4,-26.64,6>, <0,-25,6>, <2.65,-26.87,6> }
		triangle { <2.65,-26.87,-6>, <1.08,-32.98,-6>, <1.08,-32.98,6> }
		triangle { <1.08,-32.98,6>, <2.65,-26.87,6>, <2.65,-26.87,-6> }
		triangle { <1.08,-32.98,-6>, <-1.08,-32.98,-6>, <-1.08,-32.98,6> }
		triangle { <-1.08,-32.98,6>, <1.08,-32.98,6>, <1.08,-32.98,-6> }
		triangle { <-1.08,-32.98,-6>, <-2.65,-26.87,-6>, <-2.65,-26.87,6> }
		triangle { <-2.65,-26.87,6>, <-1.08,-32.98,6>, <-1.08,-32.98,-6> }
		triangle { <-2.65,-26.87,-6>, <-4.4,-26.64,-6>, <-4.4,-26.64,6> }
		triangle { <-4.4,-26.64,6>, <-2.65,-26.87,6>, <-2.65,-26.87,-6> }
		triangle { <2.65,-26.87,-6>, <1.08,-32.98,-6>, <-1.08,-32.98,-6> }
		triangle { <-1.08,-32.98,-6>, <-2.65,-26.87,-6>, <2.65,-26.87,-6> }
		triangle { <2.65,-26.87,6>, <1.08,-32.98,6>, <-1.08,-32.98,6> }
		triangle { <-1.08,-32.98,6>, <-2.65,-26.87,6>, <2.65,-26.87,6> }
		triangle { <2.65,-26.87,-6>, <0,-25,-6>, <-6.47,-24.15,-6> }
		triangle { <-6.47,-24.15,-6>, <-2.65,-26.87,-6>, <2.65,-26.87,-6> }
		triangle { <2.65,-26.87,6>, <0,-25,6>, <-6.47,-24.15,6> }
		triangle { <-6.47,-24.15,6>, <-2.65,-26.87,6>, <2.65,-26.87,6> }
		triangle { <-2.65,-26.87,-6>, <-6.47,-24.15,-6>, <-4.4,-26.64,-6> }
		triangle { <-2.65,-26.87,6>, <-6.47,-24.15,6>, <-4.4,-26.64,6> }
		triangle { <-4.4,-26.64,-6>, <-7.49,-32.14,-6>, <-7.49,-32.14,6> }
		triangle { <-7.49,-32.14,6>, <-4.4,-26.64,6>, <-4.4,-26.64,-6> }
		triangle { <-7.49,-32.14,-6>, <-9.58,-31.58,-6>, <-9.58,-31.58,6> }
		triangle { <-9.58,-31.58,6>, <-7.49,-32.14,6>, <-7.49,-32.14,-6> }
		triangle { <-9.58,-31.58,-6>, <-9.51,-25.27,-6>, <-9.51,-25.27,6> }
		triangle { <-9.51,-25.27,6>, <-9.58,-31.58,6>, <-9.58,-31.58,-6> }
		triangle { <-9.51,-25.27,-6>, <-11.14,-24.59,-6>, <-11.14,-24.59,6> }
		triangle { <-11.14,-24.59,6>, <-9.51,-25.27,6>, <-9.51,-25.27,-6> }
		triangle { <-4.4,-26.64,-6>, <-7.49,-32.14,-6>, <-9.58,-31.58,-6> }
		triangle { <-9.58,-31.58,-6>, <-9.51,-25.27,-6>, <-4.4,-26.64,-6> }
		triangle { <-4.4,-26.64,6>, <-7.49,-32.14,6>, <-9.58,-31.58,6> }
		triangle { <-9.58,-31.58,6>, <-9.51,-25.27,6>, <-4.4,-26.64,6> }
		triangle { <-4.4,-26.64,-6>, <-6.47,-24.15,-6>, <-12.5,-21.65,-6> }
		triangle { <-12.5,-21.65,-6>, <-9.51,-25.27,-6>, <-4.4,-26.64,-6> }
		triangle { <-4.4,-26.64,6>, <-6.47,-24.15,6>, <-12.5,-21.65,6> }
		triangle { <-12.5,-21.65,6>, <-9.51,-25.27,6>, <-4.4,-26.64,6> }
		triangle { <-9.51,-25.27,-6>, <-12.5,-21.65,-6>, <-11.14,-24.59,-6> }
		triangle { <-9.51,-25.27,6>, <-12.5,-21.65,6>, <-11.14,-24.59,6> }
		triangle { <-11.14,-24.59,-6>, <-15.56,-29.1,-6>, <-15.56,-29.1,6> }
		triangle { <-15.56,-29.1,6>, <-11.14,-24.59,6>, <-11.14,-24.59,-6> }
		triangle { <-15.56,-29.1,-6>, <-17.43,-28.02,-6>, <-17.43,-28.02,6> }
		triangle { <-17.43,-28.02,6>, <-15.56,-29.1,6>, <-15.56,-29.1,-6> }
		triangle { <-17.43,-28.02,-6>, <-15.73,-21.95,-6>, <-15.73,-21.95,6> }
		triangle { <-15.73,-21.95,6>, <-17.43,-28.02,6>, <-17.43,-28.02,-6> }
		triangle { <-15.73,-21.95,-6>, <-17.13,-20.87,-6>, <-17.13,-20.87,6> }
		triangle { <-17.13,-20.87,6>, <-15.73,-21.95,6>, <-15.73,-21.95,-6> }
		triangle { <-11.14,-24.59,-6>, <-15.56,-29.1,-6>, <-17.43,-28.02,-6> }
		triangle { <-17.43,-28.02,-6>, <-15.73,-21.95,-6>, <-11.14,-24.59,-6> }
		triangle { <-11.14,-24.59,6>, <-15.56,-29.1,6>, <-17.43,-28.02,6> }
		triangle { <-17.43,-28.02,6>, <-15.73,-21.95,6>, <-11.14,-24.59,6> }
		triangle { <-11.14,-24.59,-6>, <-12.5,-21.65,-6>, <-17.68,-17.68,-6> }
		triangle { <-17.68,-17.68,-6>, <-15.73,-21.95,-6>, <-11.14,-24.59,-6> }
		triangle { <-11.14,-24.59,6>, <-12.5,-21.65,6>, <-17.68,-17.68,6> }
		triangle { <-17.68,-17.68,6>, <-15.73,-21.95,6>, <-11.14,-24.59,6> }
		triangle { <-15.73,-21.95,-6>, <-17.68,-17.68,-6>, <-17.13,-20.87,-6> }
		triangle { <-15.73,-21.95,6>, <-17.68,-17.68,6>, <-17.13,-20.87,6> }
		triangle { <-17.13,-20.87,-6>, <-22.56,-24.09,-6>, <-22.56,-24.09,6> }
		triangle { <-22.56,-24.09,6>, <-17.13,-20.87,6>, <-17.13,-20.87,-6> }
		triangle { <-22.56,-24.09,-6>, <-24.09,-22.56,-6>, <-24.09,-22.56,6> }
		triangle { <-24.09,-22.56,6>, <-22.56,-24.09,6>, <-22.56,-24.09,-6> }
		triangle { <-24.09,-22.56,-6>, <-20.87,-17.13,-6>, <-20.87,-17.13,6> }
		triangle { <-20.87,-17.13,6>, <-24.09,-22.56,6>, <-24.09,-22.56,-6> }
		triangle { <-20.87,-17.13,-6>, <-21.95,-15.73,-6>, <-21.95,-15.73,6> }
		triangle { <-21.95,-15.73,6>, <-20.87,-17.13,6>, <-20.87,-17.13,-6> }
		triangle { <-17.13,-20.87,-6>, <-22.56,-24.09,-6>, <-24.09,-22.56,-6> }
		triangle { <-24.09,-22.56,-6>, <-20.87,-17.13,-6>, <-17.13,-20.87,-6> }
		triangle { <-17.13,-20.87,6>, <-22.56,-24.09,6>, <-24.09,-22.56,6> }
		triangle { <-24.09,-22.56,6>, <-20.87,-17.13,6>, <-17.13,-20.87,6> }
		triangle { <-17.13,-20.87,-6>, <-17.68,-17.68,-6>, <-21.65,-12.5,-6> }
		triangle { <-21.65,-12.5,-6>, <-20.87,-17.13,-6>, <-17.13,-20.87,-6> }
		triangle { <-17.13,-20.87,6>, <-17.68,-17.68,6>, <-21.65,-12.5,6> }
		triangle { <-21.65,-12.5,6>, <-20.87,-17.13,6>, <-17.13,-20.87,6> }
		triangle { <-20.87,-17.13,-6>, <-21.65,-12.5,-6>, <-21.95,-15.73,-6> }
		triangle { <-20.87,-17.13,6>, <-21.65,-12.5,6>, <-21.95,-15.73,6> }
// Gear Wheel 24
		triangle { <-21.95,-15.73,-6>, <-28.02,-17.43,-6>, <-28.02,-17.43,6> }
		triangle { <-28.02,-17.43,6>, <-21.95,-15.73,6>, <-21.95,-15.73,-6> }
		triangle { <-28.02,-17.43,-6>, <-29.1,-15.56,-6>, <-29.1,-15.56,6> }
		triangle { <-29.1,-15.56,6>, <-28.02,-17.43,6>, <-28.02,-17.43,-6> }
		triangle { <-29.1,-15.56,-6>, <-24.59,-11.14,-6>, <-24.59,-11.14,6> }
		triangle { <-24.59,-11.14,6>, <-29.1,-15.56,6>, <-29.1,-15.56,-6> }
		triangle { <-24.59,-11.14,-6>, <-25.27,-9.51,-6>, <-25.27,-9.51,6> }
		triangle { <-25.27,-9.51,6>, <-24.59,-11.14,6>, <-24.59,-11.14,-6> }
		triangle { <-21.95,-15.73,-6>, <-28.02,-17.43,-6>, <-29.1,-15.56,-6> }
		triangle { <-29.1,-15.56,-6>, <-24.59,-11.14,-6>, <-21.95,-15.73,-6> }
		triangle { <-21.95,-15.73,6>, <-28.02,-17.43,6>, <-29.1,-15.56,6> }
		triangle { <-29.1,-15.56,6>, <-24.59,-11.14,6>, <-21.95,-15.73,6> }
		triangle { <-21.95,-15.73,-6>, <-21.65,-12.5,-6>, <-24.15,-6.47,-6> }
		triangle { <-24.15,-6.47,-6>, <-24.59,-11.14,-6>, <-21.95,-15.73,-6> }
		triangle { <-21.95,-15.73,6>, <-21.65,-12.5,6>, <-24.15,-6.47,6> }
		triangle { <-24.15,-6.47,6>, <-24.59,-11.14,6>, <-21.95,-15.73,6> }
		triangle { <-24.59,-11.14,-6>, <-24.15,-6.47,-6>, <-25.27,-9.51,-6> }
		triangle { <-24.59,-11.14,6>, <-24.15,-6.47,6>, <-25.27,-9.51,6> }
		triangle { <-25.27,-9.51,-6>, <-31.58,-9.58,-6>, <-31.58,-9.58,6> }
		triangle { <-31.58,-9.58,6>, <-25.27,-9.51,6>, <-25.27,-9.51,-6> }
		triangle { <-31.58,-9.58,-6>, <-32.14,-7.49,-6>, <-32.14,-7.49,6> }
		triangle { <-32.14,-7.49,6>, <-31.58,-9.58,6>, <-31.58,-9.58,-6> }
		triangle { <-32.14,-7.49,-6>, <-26.64,-4.4,-6>, <-26.64,-4.4,6> }
		triangle { <-26.64,-4.4,6>, <-32.14,-7.49,6>, <-32.14,-7.49,-6> }
		triangle { <-26.64,-4.4,-6>, <-26.87,-2.65,-6>, <-26.87,-2.65,6> }
		triangle { <-26.87,-2.65,6>, <-26.64,-4.4,6>, <-26.64,-4.4,-6> }
		triangle { <-25.27,-9.51,-6>, <-31.58,-9.58,-6>, <-32.14,-7.49,-6> }
		triangle { <-32.14,-7.49,-6>, <-26.64,-4.4,-6>, <-25.27,-9.51,-6> }
		triangle { <-25.27,-9.51,6>, <-31.58,-9.58,6>, <-32.14,-7.49,6> }
		triangle { <-32.14,-7.49,6>, <-26.64,-4.4,6>, <-25.27,-9.51,6> }
		triangle { <-25.27,-9.51,-6>, <-24.15,-6.47,-6>, <-25,0,-6> }
		triangle { <-25,0,-6>, <-26.64,-4.4,-6>, <-25.27,-9.51,-6> }
		triangle { <-25.27,-9.51,6>, <-24.15,-6.47,6>, <-25,0,6> }
		triangle { <-25,0,6>, <-26.64,-4.4,6>, <-25.27,-9.51,6> }
		triangle { <-26.64,-4.4,-6>, <-25,0,-6>, <-26.87,-2.65,-6> }
		triangle { <-26.64,-4.4,6>, <-25,0,6>, <-26.87,-2.65,6> }
		triangle { <-26.87,-2.65,-6>, <-32.98,-1.08,-6>, <-32.98,-1.08,6> }
		triangle { <-32.98,-1.08,6>, <-26.87,-2.65,6>, <-26.87,-2.65,-6> }
		triangle { <-32.98,-1.08,-6>, <-32.98,1.08,-6>, <-32.98,1.08,6> }
		triangle { <-32.98,1.08,6>, <-32.98,-1.08,6>, <-32.98,-1.08,-6> }
		triangle { <-32.98,1.08,-6>, <-26.87,2.65,-6>, <-26.87,2.65,6> }
		triangle { <-26.87,2.65,6>, <-32.98,1.08,6>, <-32.98,1.08,-6> }
		triangle { <-26.87,2.65,-6>, <-26.64,4.4,-6>, <-26.64,4.4,6> }
		triangle { <-26.64,4.4,6>, <-26.87,2.65,6>, <-26.87,2.65,-6> }
		triangle { <-26.87,-2.65,-6>, <-32.98,-1.08,-6>, <-32.98,1.08,-6> }
		triangle { <-32.98,1.08,-6>, <-26.87,2.65,-6>, <-26.87,-2.65,-6> }
		triangle { <-26.87,-2.65,6>, <-32.98,-1.08,6>, <-32.98,1.08,6> }
		triangle { <-32.98,1.08,6>, <-26.87,2.65,6>, <-26.87,-2.65,6> }
		triangle { <-26.87,-2.65,-6>, <-25,0,-6>, <-24.15,6.47,-6> }
		triangle { <-24.15,6.47,-6>, <-26.87,2.65,-6>, <-26.87,-2.65,-6> }
		triangle { <-26.87,-2.65,6>, <-25,0,6>, <-24.15,6.47,6> }
		triangle { <-24.15,6.47,6>, <-26.87,2.65,6>, <-26.87,-2.65,6> }
		triangle { <-26.87,2.65,-6>, <-24.15,6.47,-6>, <-26.64,4.4,-6> }
		triangle { <-26.87,2.65,6>, <-24.15,6.47,6>, <-26.64,4.4,6> }
		triangle { <-26.64,4.4,-6>, <-32.14,7.49,-6>, <-32.14,7.49,6> }
		triangle { <-32.14,7.49,6>, <-26.64,4.4,6>, <-26.64,4.4,-6> }
		triangle { <-32.14,7.49,-6>, <-31.58,9.58,-6>, <-31.58,9.58,6> }
		triangle { <-31.58,9.58,6>, <-32.14,7.49,6>, <-32.14,7.49,-6> }
		triangle { <-31.58,9.58,-6>, <-25.27,9.51,-6>, <-25.27,9.51,6> }
		triangle { <-25.27,9.51,6>, <-31.58,9.58,6>, <-31.58,9.58,-6> }
		triangle { <-25.27,9.51,-6>, <-24.59,11.14,-6>, <-24.59,11.14,6> }
		triangle { <-24.59,11.14,6>, <-25.27,9.51,6>, <-25.27,9.51,-6> }
		triangle { <-26.64,4.4,-6>, <-32.14,7.49,-6>, <-31.58,9.58,-6> }
		triangle { <-31.58,9.58,-6>, <-25.27,9.51,-6>, <-26.64,4.4,-6> }
		triangle { <-26.64,4.4,6>, <-32.14,7.49,6>, <-31.58,9.58,6> }
		triangle { <-31.58,9.58,6>, <-25.27,9.51,6>, <-26.64,4.4,6> }
		triangle { <-26.64,4.4,-6>, <-24.15,6.47,-6>, <-21.65,12.5,-6> }
		triangle { <-21.65,12.5,-6>, <-25.27,9.51,-6>, <-26.64,4.4,-6> }
		triangle { <-26.64,4.4,6>, <-24.15,6.47,6>, <-21.65,12.5,6> }
		triangle { <-21.65,12.5,6>, <-25.27,9.51,6>, <-26.64,4.4,6> }
		triangle { <-25.27,9.51,-6>, <-21.65,12.5,-6>, <-24.59,11.14,-6> }
		triangle { <-25.27,9.51,6>, <-21.65,12.5,6>, <-24.59,11.14,6> }
		triangle { <-24.59,11.14,-6>, <-29.1,15.56,-6>, <-29.1,15.56,6> }
		triangle { <-29.1,15.56,6>, <-24.59,11.14,6>, <-24.59,11.14,-6> }
		triangle { <-29.1,15.56,-6>, <-28.02,17.43,-6>, <-28.02,17.43,6> }
		triangle { <-28.02,17.43,6>, <-29.1,15.56,6>, <-29.1,15.56,-6> }
		triangle { <-28.02,17.43,-6>, <-21.95,15.73,-6>, <-21.95,15.73,6> }
		triangle { <-21.95,15.73,6>, <-28.02,17.43,6>, <-28.02,17.43,-6> }
		triangle { <-21.95,15.73,-6>, <-20.87,17.13,-6>, <-20.87,17.13,6> }
		triangle { <-20.87,17.13,6>, <-21.95,15.73,6>, <-21.95,15.73,-6> }
		triangle { <-24.59,11.14,-6>, <-29.1,15.56,-6>, <-28.02,17.43,-6> }
		triangle { <-28.02,17.43,-6>, <-21.95,15.73,-6>, <-24.59,11.14,-6> }
		triangle { <-24.59,11.14,6>, <-29.1,15.56,6>, <-28.02,17.43,6> }
		triangle { <-28.02,17.43,6>, <-21.95,15.73,6>, <-24.59,11.14,6> }
		triangle { <-24.59,11.14,-6>, <-21.65,12.5,-6>, <-17.68,17.68,-6> }
		triangle { <-17.68,17.68,-6>, <-21.95,15.73,-6>, <-24.59,11.14,-6> }
		triangle { <-24.59,11.14,6>, <-21.65,12.5,6>, <-17.68,17.68,6> }
		triangle { <-17.68,17.68,6>, <-21.95,15.73,6>, <-24.59,11.14,6> }
		triangle { <-21.95,15.73,-6>, <-17.68,17.68,-6>, <-20.87,17.13,-6> }
		triangle { <-21.95,15.73,6>, <-17.68,17.68,6>, <-20.87,17.13,6> }
		triangle { <-20.87,17.13,-6>, <-24.09,22.56,-6>, <-24.09,22.56,6> }
		triangle { <-24.09,22.56,6>, <-20.87,17.13,6>, <-20.87,17.13,-6> }
		triangle { <-24.09,22.56,-6>, <-22.56,24.09,-6>, <-22.56,24.09,6> }
		triangle { <-22.56,24.09,6>, <-24.09,22.56,6>, <-24.09,22.56,-6> }
		triangle { <-22.56,24.09,-6>, <-17.13,20.87,-6>, <-17.13,20.87,6> }
		triangle { <-17.13,20.87,6>, <-22.56,24.09,6>, <-22.56,24.09,-6> }
		triangle { <-17.13,20.87,-6>, <-15.73,21.95,-6>, <-15.73,21.95,6> }
		triangle { <-15.73,21.95,6>, <-17.13,20.87,6>, <-17.13,20.87,-6> }
		triangle { <-20.87,17.13,-6>, <-24.09,22.56,-6>, <-22.56,24.09,-6> }
		triangle { <-22.56,24.09,-6>, <-17.13,20.87,-6>, <-20.87,17.13,-6> }
		triangle { <-20.87,17.13,6>, <-24.09,22.56,6>, <-22.56,24.09,6> }
		triangle { <-22.56,24.09,6>, <-17.13,20.87,6>, <-20.87,17.13,6> }
		triangle { <-20.87,17.13,-6>, <-17.68,17.68,-6>, <-12.5,21.65,-6> }
		triangle { <-12.5,21.65,-6>, <-17.13,20.87,-6>, <-20.87,17.13,-6> }
		triangle { <-20.87,17.13,6>, <-17.68,17.68,6>, <-12.5,21.65,6> }
		triangle { <-12.5,21.65,6>, <-17.13,20.87,6>, <-20.87,17.13,6> }
		triangle { <-17.13,20.87,-6>, <-12.5,21.65,-6>, <-15.73,21.95,-6> }
		triangle { <-17.13,20.87,6>, <-12.5,21.65,6>, <-15.73,21.95,6> }
		triangle { <-15.73,21.95,-6>, <-17.43,28.02,-6>, <-17.43,28.02,6> }
		triangle { <-17.43,28.02,6>, <-15.73,21.95,6>, <-15.73,21.95,-6> }
		triangle { <-17.43,28.02,-6>, <-15.56,29.1,-6>, <-15.56,29.1,6> }
		triangle { <-15.56,29.1,6>, <-17.43,28.02,6>, <-17.43,28.02,-6> }
		triangle { <-15.56,29.1,-6>, <-11.14,24.59,-6>, <-11.14,24.59,6> }
		triangle { <-11.14,24.59,6>, <-15.56,29.1,6>, <-15.56,29.1,-6> }
		triangle { <-11.14,24.59,-6>, <-9.51,25.27,-6>, <-9.51,25.27,6> }
		triangle { <-9.51,25.27,6>, <-11.14,24.59,6>, <-11.14,24.59,-6> }
		triangle { <-15.73,21.95,-6>, <-17.43,28.02,-6>, <-15.56,29.1,-6> }
		triangle { <-15.56,29.1,-6>, <-11.14,24.59,-6>, <-15.73,21.95,-6> }
		triangle { <-15.73,21.95,6>, <-17.43,28.02,6>, <-15.56,29.1,6> }
		triangle { <-15.56,29.1,6>, <-11.14,24.59,6>, <-15.73,21.95,6> }
		triangle { <-15.73,21.95,-6>, <-12.5,21.65,-6>, <-6.47,24.15,-6> }
		triangle { <-6.47,24.15,-6>, <-11.14,24.59,-6>, <-15.73,21.95,-6> }
		triangle { <-15.73,21.95,6>, <-12.5,21.65,6>, <-6.47,24.15,6> }
		triangle { <-6.47,24.15,6>, <-11.14,24.59,6>, <-15.73,21.95,6> }
		triangle { <-11.14,24.59,-6>, <-6.47,24.15,-6>, <-9.51,25.27,-6> }
		triangle { <-11.14,24.59,6>, <-6.47,24.15,6>, <-9.51,25.27,6> }
		triangle { <-9.51,25.27,-6>, <-9.58,31.58,-6>, <-9.58,31.58,6> }
		triangle { <-9.58,31.58,6>, <-9.51,25.27,6>, <-9.51,25.27,-6> }
		triangle { <-9.58,31.58,-6>, <-7.49,32.14,-6>, <-7.49,32.14,6> }
		triangle { <-7.49,32.14,6>, <-9.58,31.58,6>, <-9.58,31.58,-6> }
		triangle { <-7.49,32.14,-6>, <-4.4,26.64,-6>, <-4.4,26.64,6> }
		triangle { <-4.4,26.64,6>, <-7.49,32.14,6>, <-7.49,32.14,-6> }
		triangle { <-4.4,26.64,-6>, <-2.65,26.87,-6>, <-2.65,26.87,6> }
		triangle { <-2.65,26.87,6>, <-4.4,26.64,6>, <-4.4,26.64,-6> }
		triangle { <-9.51,25.27,-6>, <-9.58,31.58,-6>, <-7.49,32.14,-6> }
		triangle { <-7.49,32.14,-6>, <-4.4,26.64,-6>, <-9.51,25.27,-6> }
		triangle { <-9.51,25.27,6>, <-9.58,31.58,6>, <-7.49,32.14,6> }
		triangle { <-7.49,32.14,6>, <-4.4,26.64,6>, <-9.51,25.27,6> }
		triangle { <-9.51,25.27,-6>, <-6.47,24.15,-6>, <0,25,-6> }
		triangle { <0,25,-6>, <-4.4,26.64,-6>, <-9.51,25.27,-6> }
		triangle { <-9.51,25.27,6>, <-6.47,24.15,6>, <0,25,6> }
		triangle { <0,25,6>, <-4.4,26.64,6>, <-9.51,25.27,6> }
		triangle { <-4.4,26.64,-6>, <0,25,-6>, <-2.65,26.87,-6> }
		triangle { <-4.4,26.64,6>, <0,25,6>, <-2.65,26.87,6> }
		triangle { <-2.65,26.87,-6>, <-1.08,32.98,-6>, <-1.08,32.98,6> }
		triangle { <-1.08,32.98,6>, <-2.65,26.87,6>, <-2.65,26.87,-6> }
		triangle { <-1.08,32.98,-6>, <1.08,32.98,-6>, <1.08,32.98,6> }
		triangle { <1.08,32.98,6>, <-1.08,32.98,6>, <-1.08,32.98,-6> }
		triangle { <1.08,32.98,-6>, <2.65,26.87,-6>, <2.65,26.87,6> }
		triangle { <2.65,26.87,6>, <1.08,32.98,6>, <1.08,32.98,-6> }
		triangle { <2.65,26.87,-6>, <4.4,26.64,-6>, <4.4,26.64,6> }
		triangle { <4.4,26.64,6>, <2.65,26.87,6>, <2.65,26.87,-6> }
		triangle { <-2.65,26.87,-6>, <-1.08,32.98,-6>, <1.08,32.98,-6> }
		triangle { <1.08,32.98,-6>, <2.65,26.87,-6>, <-2.65,26.87,-6> }
		triangle { <-2.65,26.87,6>, <-1.08,32.98,6>, <1.08,32.98,6> }
		triangle { <1.08,32.98,6>, <2.65,26.87,6>, <-2.65,26.87,6> }
		triangle { <-2.65,26.87,-6>, <0,25,-6>, <6.47,24.15,-6> }
		triangle { <6.47,24.15,-6>, <2.65,26.87,-6>, <-2.65,26.87,-6> }
		triangle { <-2.65,26.87,6>, <0,25,6>, <6.47,24.15,6> }
		triangle { <6.47,24.15,6>, <2.65,26.87,6>, <-2.65,26.87,6> }
		triangle { <2.65,26.87,-6>, <6.47,24.15,-6>, <4.4,26.64,-6> }
		triangle { <2.65,26.87,6>, <6.47,24.15,6>, <4.4,26.64,6> }
		triangle { <4.4,26.64,-6>, <7.49,32.14,-6>, <7.49,32.14,6> }
		triangle { <7.49,32.14,6>, <4.4,26.64,6>, <4.4,26.64,-6> }
		triangle { <7.49,32.14,-6>, <9.58,31.58,-6>, <9.58,31.58,6> }
		triangle { <9.58,31.58,6>, <7.49,32.14,6>, <7.49,32.14,-6> }
		triangle { <9.58,31.58,-6>, <9.51,25.27,-6>, <9.51,25.27,6> }
		triangle { <9.51,25.27,6>, <9.58,31.58,6>, <9.58,31.58,-6> }
		triangle { <9.51,25.27,-6>, <11.14,24.59,-6>, <11.14,24.59,6> }
		triangle { <11.14,24.59,6>, <9.51,25.27,6>, <9.51,25.27,-6> }
		triangle { <4.4,26.64,-6>, <7.49,32.14,-6>, <9.58,31.58,-6> }
		triangle { <9.58,31.58,-6>, <9.51,25.27,-6>, <4.4,26.64,-6> }
		triangle { <4.4,26.64,6>, <7.49,32.14,6>, <9.58,31.58,6> }
		triangle { <9.58,31.58,6>, <9.51,25.27,6>, <4.4,26.64,6> }
		triangle { <4.4,26.64,-6>, <6.47,24.15,-6>, <12.5,21.65,-6> }
		triangle { <12.5,21.65,-6>, <9.51,25.27,-6>, <4.4,26.64,-6> }
		triangle { <4.4,26.64,6>, <6.47,24.15,6>, <12.5,21.65,6> }
		triangle { <12.5,21.65,6>, <9.51,25.27,6>, <4.4,26.64,6> }
		triangle { <9.51,25.27,-6>, <12.5,21.65,-6>, <11.14,24.59,-6> }
		triangle { <9.51,25.27,6>, <12.5,21.65,6>, <11.14,24.59,6> }
		triangle { <11.14,24.59,-6>, <15.56,29.1,-6>, <15.56,29.1,6> }
		triangle { <15.56,29.1,6>, <11.14,24.59,6>, <11.14,24.59,-6> }
		triangle { <15.56,29.1,-6>, <17.43,28.02,-6>, <17.43,28.02,6> }
		triangle { <17.43,28.02,6>, <15.56,29.1,6>, <15.56,29.1,-6> }
		triangle { <17.43,28.02,-6>, <15.73,21.95,-6>, <15.73,21.95,6> }
		triangle { <15.73,21.95,6>, <17.43,28.02,6>, <17.43,28.02,-6> }
		triangle { <15.73,21.95,-6>, <17.13,20.87,-6>, <17.13,20.87,6> }
		triangle { <17.13,20.87,6>, <15.73,21.95,6>, <15.73,21.95,-6> }
		triangle { <11.14,24.59,-6>, <15.56,29.1,-6>, <17.43,28.02,-6> }
		triangle { <17.43,28.02,-6>, <15.73,21.95,-6>, <11.14,24.59,-6> }
		triangle { <11.14,24.59,6>, <15.56,29.1,6>, <17.43,28.02,6> }
		triangle { <17.43,28.02,6>, <15.73,21.95,6>, <11.14,24.59,6> }
		triangle { <11.14,24.59,-6>, <12.5,21.65,-6>, <17.68,17.68,-6> }
		triangle { <17.68,17.68,-6>, <15.73,21.95,-6>, <11.14,24.59,-6> }
		triangle { <11.14,24.59,6>, <12.5,21.65,6>, <17.68,17.68,6> }
		triangle { <17.68,17.68,6>, <15.73,21.95,6>, <11.14,24.59,6> }
		triangle { <15.73,21.95,-6>, <17.68,17.68,-6>, <17.13,20.87,-6> }
		triangle { <15.73,21.95,6>, <17.68,17.68,6>, <17.13,20.87,6> }
		triangle { <17.13,20.87,-6>, <22.56,24.09,-6>, <22.56,24.09,6> }
		triangle { <22.56,24.09,6>, <17.13,20.87,6>, <17.13,20.87,-6> }
		triangle { <22.56,24.09,-6>, <24.09,22.56,-6>, <24.09,22.56,6> }
		triangle { <24.09,22.56,6>, <22.56,24.09,6>, <22.56,24.09,-6> }
		triangle { <24.09,22.56,-6>, <20.87,17.13,-6>, <20.87,17.13,6> }
		triangle { <20.87,17.13,6>, <24.09,22.56,6>, <24.09,22.56,-6> }
		triangle { <20.87,17.13,-6>, <21.95,15.73,-6>, <21.95,15.73,6> }
		triangle { <21.95,15.73,6>, <20.87,17.13,6>, <20.87,17.13,-6> }
		triangle { <17.13,20.87,-6>, <22.56,24.09,-6>, <24.09,22.56,-6> }
		triangle { <24.09,22.56,-6>, <20.87,17.13,-6>, <17.13,20.87,-6> }
		triangle { <17.13,20.87,6>, <22.56,24.09,6>, <24.09,22.56,6> }
		triangle { <24.09,22.56,6>, <20.87,17.13,6>, <17.13,20.87,6> }
		triangle { <17.13,20.87,-6>, <17.68,17.68,-6>, <21.65,12.5,-6> }
		triangle { <21.65,12.5,-6>, <20.87,17.13,-6>, <17.13,20.87,-6> }
		triangle { <17.13,20.87,6>, <17.68,17.68,6>, <21.65,12.5,6> }
		triangle { <21.65,12.5,6>, <20.87,17.13,6>, <17.13,20.87,6> }
		triangle { <20.87,17.13,-6>, <21.65,12.5,-6>, <21.95,15.73,-6> }
		triangle { <20.87,17.13,6>, <21.65,12.5,6>, <21.95,15.73,6> }
		triangle { <21.95,15.73,-6>, <28.02,17.43,-6>, <28.02,17.43,6> }
		triangle { <28.02,17.43,6>, <21.95,15.73,6>, <21.95,15.73,-6> }
		triangle { <28.02,17.43,-6>, <29.1,15.56,-6>, <29.1,15.56,6> }
		triangle { <29.1,15.56,6>, <28.02,17.43,6>, <28.02,17.43,-6> }
		triangle { <29.1,15.56,-6>, <24.59,11.14,-6>, <24.59,11.14,6> }
		triangle { <24.59,11.14,6>, <29.1,15.56,6>, <29.1,15.56,-6> }
		triangle { <24.59,11.14,-6>, <25.27,9.51,-6>, <25.27,9.51,6> }
		triangle { <25.27,9.51,6>, <24.59,11.14,6>, <24.59,11.14,-6> }
		triangle { <21.95,15.73,-6>, <28.02,17.43,-6>, <29.1,15.56,-6> }
		triangle { <29.1,15.56,-6>, <24.59,11.14,-6>, <21.95,15.73,-6> }
		triangle { <21.95,15.73,6>, <28.02,17.43,6>, <29.1,15.56,6> }
		triangle { <29.1,15.56,6>, <24.59,11.14,6>, <21.95,15.73,6> }
		triangle { <21.95,15.73,-6>, <21.65,12.5,-6>, <24.15,6.47,-6> }
		triangle { <24.15,6.47,-6>, <24.59,11.14,-6>, <21.95,15.73,-6> }
		triangle { <21.95,15.73,6>, <21.65,12.5,6>, <24.15,6.47,6> }
		triangle { <24.15,6.47,6>, <24.59,11.14,6>, <21.95,15.73,6> }
		triangle { <24.59,11.14,-6>, <24.15,6.47,-6>, <25.27,9.51,-6> }
		triangle { <24.59,11.14,6>, <24.15,6.47,6>, <25.27,9.51,6> }
		triangle { <25.27,9.51,-6>, <31.58,9.58,-6>, <31.58,9.58,6> }
		triangle { <31.58,9.58,6>, <25.27,9.51,6>, <25.27,9.51,-6> }
		triangle { <31.58,9.58,-6>, <32.14,7.49,-6>, <32.14,7.49,6> }
		triangle { <32.14,7.49,6>, <31.58,9.58,6>, <31.58,9.58,-6> }
		triangle { <32.14,7.49,-6>, <26.64,4.4,-6>, <26.64,4.4,6> }
		triangle { <26.64,4.4,6>, <32.14,7.49,6>, <32.14,7.49,-6> }
		triangle { <26.64,4.4,-6>, <26.87,2.65,-6>, <26.87,2.65,6> }
		triangle { <26.87,2.65,6>, <26.64,4.4,6>, <26.64,4.4,-6> }
		triangle { <25.27,9.51,-6>, <31.58,9.58,-6>, <32.14,7.49,-6> }
		triangle { <32.14,7.49,-6>, <26.64,4.4,-6>, <25.27,9.51,-6> }
		triangle { <25.27,9.51,6>, <31.58,9.58,6>, <32.14,7.49,6> }
		triangle { <32.14,7.49,6>, <26.64,4.4,6>, <25.27,9.51,6> }
		triangle { <25.27,9.51,-6>, <24.15,6.47,-6>, <25,0,-6> }
		triangle { <25,0,-6>, <26.64,4.4,-6>, <25.27,9.51,-6> }
		triangle { <25.27,9.51,6>, <24.15,6.47,6>, <25,0,6> }
		triangle { <25,0,6>, <26.64,4.4,6>, <25.27,9.51,6> }
		triangle { <26.64,4.4,-6>, <25,0,-6>, <26.87,2.65,-6> }
		triangle { <26.64,4.4,6>, <25,0,6>, <26.87,2.65,6> }
// End of original 3648.dat file
	}
}
#end

#declare _61_dot_dat = #if (QUAL = 0) box { <-9,-9,-10>, <9,9,10> } #else union {
// ~Technic Gear 24 Tooth Clutch Center
// Name: 61.dat
// Author: (c)Marc Klein
// Based on Steve Bliss's file 4265c.dat
// Official LCAD Part - 2000-02 Update
	mesh {
		triangle { <6,0,-10>, <5.58,2,-10>, <5.58,2,10> }
		triangle { <5.58,2,10>, <6,0,10>, <6,0,-10> }
		triangle { <5.58,2,-10>, <4,2,-10>, <4,2,10> }
		triangle { <4,2,10>, <5.58,2,10>, <5.58,2,-10> }
		triangle { <4,2,-10>, <2.5,2.5,-10>, <2.5,2.5,10> }
		triangle { <2.5,2.5,10>, <4,2,10>, <4,2,-10> }
		triangle { <2.5,2.5,-10>, <2,4,-10>, <2,4,10> }
		triangle { <2,4,10>, <2.5,2.5,10>, <2.5,2.5,-10> }
		triangle { <2,4,-10>, <2,5.58,-10>, <2,5.58,10> }
		triangle { <2,5.58,10>, <2,4,10>, <2,4,-10> }
		triangle { <0,6,-10>, <2,5.58,-10>, <2,5.58,10> }
		triangle { <2,5.58,10>, <0,6,10>, <0,6,-10> }
		triangle { <5.58,2,-10>, <4,2,-10>, <4.26,4.26,-10> }
		triangle { <4.26,4.26,-10>, <5.52,2.28,-10>, <5.58,2,-10> }
		triangle { <4,2,-10>, <2.5,2.5,-10>, <2,4,-10> }
		triangle { <2,4,-10>, <4.26,4.26,-10>, <4,2,-10> }
		triangle { <2,5.58,-10>, <2,4,-10>, <4.26,4.26,-10> }
		triangle { <4.26,4.26,-10>, <2.28,5.52,-10>, <2,5.58,-10> }
		triangle { <5.58,2,10>, <4,2,10>, <4.26,4.26,10> }
		triangle { <4.26,4.26,10>, <5.52,2.28,10>, <5.58,2,10> }
		triangle { <4,2,10>, <2.5,2.5,10>, <2,4,10> }
		triangle { <2,4,10>, <4.26,4.26,10>, <4,2,10> }
		triangle { <2,5.58,10>, <2,4,10>, <4.26,4.26,10> }
		triangle { <4.26,4.26,10>, <2.28,5.52,10>, <2,5.58,10> }
		triangle { <-3.743,4.577,-10>, <-2.5,2.5,-10>, <-4.577,3.743,-10> }
		triangle { <-4.577,3.743,-10>, <-4.25,4.25,-10>, <-3.743,4.577,-10> }
		triangle { <-3.743,4.577,10>, <-2.5,2.5,10>, <-4.577,3.743,10> }
		triangle { <-4.577,3.743,10>, <-4.25,4.25,10>, <-3.743,4.577,10> }
		triangle { <0,6,-10>, <-2.296,5.543,-10>, <-2.296,5.543,10> }
		triangle { <-2.296,5.543,10>, <0,6,10>, <0,6,-10> }
		triangle { <-2.296,5.543,-10>, <-3.743,4.577,-10>, <-3.743,4.577,10> }
		triangle { <-3.743,4.577,10>, <-2.296,5.543,10>, <-2.296,5.543,-10> }
		triangle { <-3.743,4.577,-10>, <-2.5,2.5,-10>, <-2.5,2.5,10> }
		triangle { <-2.5,2.5,10>, <-3.743,4.577,10>, <-3.743,4.577,-10> }
		triangle { <-2.5,2.5,-10>, <-4.577,3.743,-10>, <-4.577,3.743,10> }
		triangle { <-4.577,3.743,10>, <-2.5,2.5,10>, <-2.5,2.5,-10> }
		triangle { <-4.577,3.743,-10>, <-5.543,2.296,-10>, <-5.543,2.296,10> }
		triangle { <-5.543,2.296,10>, <-4.577,3.743,10>, <-4.577,3.743,-10> }
		triangle { <-5.543,2.296,-10>, <-6,0,-10>, <-6,0,10> }
		triangle { <-6,0,10>, <-5.543,2.296,10>, <-5.543,2.296,-10> }
		triangle { <3.743,-4.577,-10>, <2.5,-2.5,-10>, <4.577,-3.743,-10> }
		triangle { <4.577,-3.743,-10>, <4.25,-4.25,-10>, <3.743,-4.577,-10> }
		triangle { <3.743,-4.577,10>, <2.5,-2.5,10>, <4.577,-3.743,10> }
		triangle { <4.577,-3.743,10>, <4.25,-4.25,10>, <3.743,-4.577,10> }
		triangle { <0,-6,-10>, <2.296,-5.543,-10>, <2.296,-5.543,10> }
		triangle { <2.296,-5.543,10>, <0,-6,10>, <0,-6,-10> }
		triangle { <2.296,-5.543,-10>, <3.743,-4.577,-10>, <3.743,-4.577,10> }
		triangle { <3.743,-4.577,10>, <2.296,-5.543,10>, <2.296,-5.543,-10> }
		triangle { <3.743,-4.577,-10>, <2.5,-2.5,-10>, <2.5,-2.5,10> }
		triangle { <2.5,-2.5,10>, <3.743,-4.577,10>, <3.743,-4.577,-10> }
		triangle { <2.5,-2.5,-10>, <4.577,-3.743,-10>, <4.577,-3.743,10> }
		triangle { <4.577,-3.743,10>, <2.5,-2.5,10>, <2.5,-2.5,-10> }
		triangle { <4.577,-3.743,-10>, <5.543,-2.296,-10>, <5.543,-2.296,10> }
		triangle { <5.543,-2.296,10>, <4.577,-3.743,10>, <4.577,-3.743,-10> }
		triangle { <5.543,-2.296,-10>, <6,0,-10>, <6,0,10> }
		triangle { <6,0,10>, <5.543,-2.296,10>, <5.543,-2.296,-10> }
	}
	object { ring2_dot_dat matrix <3,0,0,0,0,1,0,3,0,0,0,-10> }
	object { ring2_dot_dat matrix <3,0,0,0,0,1,0,3,0,0,0,10> }
	mesh {
		triangle { <-6,0,-10>, <-5.58,-2,-10>, <-5.58,-2,10> }
		triangle { <-5.58,-2,10>, <-6,0,10>, <-6,0,-10> }
		triangle { <-5.58,-2,-10>, <-4,-2,-10>, <-4,-2,10> }
		triangle { <-4,-2,10>, <-5.58,-2,10>, <-5.58,-2,-10> }
		triangle { <-4,-2,-10>, <-2.5,-2.5,-10>, <-2.5,-2.5,10> }
		triangle { <-2.5,-2.5,10>, <-4,-2,10>, <-4,-2,-10> }
		triangle { <-2.5,-2.5,-10>, <-2,-4,-10>, <-2,-4,10> }
		triangle { <-2,-4,10>, <-2.5,-2.5,10>, <-2.5,-2.5,-10> }
		triangle { <-2,-4,-10>, <-2,-5.58,-10>, <-2,-5.58,10> }
		triangle { <-2,-5.58,10>, <-2,-4,10>, <-2,-4,-10> }
		triangle { <0,-6,-10>, <-2,-5.58,-10>, <-2,-5.58,10> }
		triangle { <-2,-5.58,10>, <0,-6,10>, <0,-6,-10> }
		triangle { <-5.58,-2,-10>, <-4,-2,-10>, <-4.26,-4.26,-10> }
		triangle { <-4.26,-4.26,-10>, <-5.52,-2.28,-10>, <-5.58,-2,-10> }
		triangle { <-4,-2,-10>, <-2.5,-2.5,-10>, <-2,-4,-10> }
		triangle { <-2,-4,-10>, <-4.26,-4.26,-10>, <-4,-2,-10> }
		triangle { <-2,-5.58,-10>, <-2,-4,-10>, <-4.26,-4.26,-10> }
		triangle { <-4.26,-4.26,-10>, <-2.28,-5.52,-10>, <-2,-5.58,-10> }
		triangle { <-5.58,-2,10>, <-4,-2,10>, <-4.26,-4.26,10> }
		triangle { <-4.26,-4.26,10>, <-5.52,-2.28,10>, <-5.58,-2,10> }
		triangle { <-4,-2,10>, <-2.5,-2.5,10>, <-2,-4,10> }
		triangle { <-2,-4,10>, <-4.26,-4.26,10>, <-4,-2,10> }
		triangle { <-2,-5.58,10>, <-2,-4,10>, <-4.26,-4.26,10> }
		triangle { <-4.26,-4.26,10>, <-2.28,-5.52,10>, <-2,-5.58,10> }
// 
	}
}
#end

#declare _60c01_dot_dat = #if (QUAL = 0) box { <-32.98,-32.98,-10>, <32.98,32.98,10> } #else union {
// Technic Gear 24 Tooth Clutch
// Name: 60c01.dat
// Author: (c)Marc Klein 2000 (marckl@easynet.fr)
// Based on James Jessiman's file 3648.dat
// Official LCAD Part - 2000-02 Update
	object { _60_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	object { _61_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (version >= 3.1) material #else texture #end { Color8 } }
// 
}
#end

#declare halfclaw_dot_dat = union {
// One Leg of the Claw
// Name: HalfClaw.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_3705_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,0,0,0>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3705_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,0,149,-2>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32014_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,149,52>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3706_dot_dat
		matrix <0,-1,0,1,0,0,0,0,1,0,76,52>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32014_dot_dat
		matrix <-1,0,0,0,-1,0,0,0,1,0,0,52>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_60c01_dot_dat
		matrix <1-SW/65.96,0,0,0,1-SW/65.96,0,0,0,1-SW/20,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,0,0,-31>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
// 
}

#declare claw_dot_dat = union {
// ClawDesign
// Name: Claw.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_3894_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-7,-3,-11>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3894_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-7,-3,9>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_71427c01_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/79,0,0,0,1-SW/100,0,SW/2.22535,SW/-10>
		matrix <1,0,0,0,1,0,0,0,1,-7,-75,19>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32296_dot_dat
		matrix <1-SW/54,0,0,0,1-SW/54,0,0,0,1-SW/20,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,-7,-33,-33>
		#if (version >= 3.1) material #else texture #end { Color7 }  
		#if (clock>=0.41 & clock<0.53)
                  rotate (45*(clock-0.41)/0.12)*z
                #end           
                #if (clock>=0.53)
                  rotate (45)*z
                #end 
                #if (clock>=0.58 & clock<0.65)
                  rotate (-50*(clock-0.58)/0.07)*z
                #end      
                #if (clock>=0.65)
                  rotate (-50)*z
                #end  
                #if (clock>=0.88 & clock<0.90)
                  rotate (10)*z
                #end
	}
	object { halfclaw_dot_dat matrix <1,0,0,0,1,0,0,0,1,-47,8,-2> 
	  #if (version >= 3.1) material 
	  #else texture #end { Color7 }   
	  #if (clock>=0.41 & clock<0.53)
            rotate (45*(clock-0.41)/0.12)*z
          #end           
          #if (clock>=0.53)
            rotate (45)*z
          #end 
          #if (clock>=0.58 & clock<0.65)
            rotate (-50*(clock-0.58)/0.07)*z
          #end      
          #if (clock>=0.65)
            rotate (-50)*z
          #end  
          #if (clock>=0.88 & clock<0.90)
            rotate (10)*z
          #end
	}
	object { halfclaw_dot_dat matrix <1,0,0,0,1,0,0,0,1,33,7,-2>
	  #if (version >= 3.1) material
	  #else texture #end { Color7 }  
	  #if (clock>=0.41 & clock<0.53)
            rotate (-45*(clock-0.41)/0.12)*z
          #end           
          #if (clock>=0.53)
            rotate (-45)*z
          #end 
          #if (clock>=0.58 & clock<0.65)
            rotate (50*(clock-0.58)/0.07)*z
          #end      
          #if (clock>=0.65)
            rotate (50)*z
          #end 
          #if (clock>=0.88 & clock<0.90)
            rotate (-10)*z
          #end
	}
// 
}

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3003)
		#include "lg_3003.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3003_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,24,20> } #else object {
// Brick  2 x  2
	lg_3003
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3003_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-20>, <20,24,20> } #else object {
// Brick  2 x  2
	lg_3003_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare armthingy_dot_dat = union {
// Magneto-ARMS
// Name: ArmThingy.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER -22 24 58 1 "Rottie"
// ROTATION CONFIG 0 0
	object {
		_32014_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,154,2,4>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32014_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,-153,3,4>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3705_dot_dat
		matrix <0,1,0,0,0,-1,-1,0,0,-153,-52,4>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3705_dot_dat
		matrix <0,1,0,0,0,-1,-1,0,0,154,-52,4>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32014_dot_dat
		matrix <0,0,1,0,-1,0,1,0,0,154,-105,4>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32014_dot_dat
		matrix <0,0,-1,0,-1,0,-1,0,0,-153.088,-105,4.99>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3706_dot_dat
		matrix <-1,0,0,0,-1,0,0,0,1,-77,-105,4.99>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3706_dot_dat
		matrix <-1,0,0,0,-1,0,0,0,1,79,-105,4.99>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2637_dot_dat
		matrix <0,-1,0,1,0,0,0,0,1,32,-105,-146>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2637_dot_dat
		matrix <0,-1,0,1,0,0,0,0,1,-33,-105,-146>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32064_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,9,-115,-296>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32073_dot_dat
		matrix <1-SW/100,0,0,0,1-SW/12,0,0,0,1-SW/12,0,0,0>
		matrix <-1,0,0,0,-1,0,0,0,1,-1,-105,-296>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_32064_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,-11,-115,-296>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object { claw_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,-10,-161.969,-296.875> #if (version >= 3.1) material #else texture #end { Color4 } }
	object {
		_3003_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,-1,-138,-297>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}     
	#if (clock>=0.41 & clock<0.53)
          rotate (-45*(clock-0.41)/0.12)*x
        #end       
        #if (clock>=0.53 & clock<0.58)
          rotate (-45+22.5*(clock-0.53)/0.05)*x
        #end  
        #if (clock>=0.58 & clock<0.65)
          rotate (-23+27.5*(clock-0.58)/0.07)*x
        #end   
        #if (clock>=0.68)
	  #if (clock<0.73)
	    rotate (5-45*(clock-0.68)/0.05)*x
	  #end
	  #if (clock>=0.73 & clock<0.83)
	    rotate -40*x
	  #end
	  #if (clock>=0.83 & clock<0.88)                
	    rotate (-40+45*(clock-0.83)/0.05)*x
	  #end  
	  #if (clock>=0.88)                
	    rotate (5-95*(clock-0.88)/0.12)*x
	  #end 
	#end 
// 
}

#declare whole__arm_dot_dat = union {
// New Model
// Name: Whole_Arm.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_6035_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/34,0,SW/2.8,SW/-4.85714>
		matrix <0,0,-1,0,1,0,1,0,0,-49,32,-1>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}  
	object {
		_4773_dot_dat
		matrix <1-SW/16,0,0,0,1-SW/13.5,0,0,0,1-SW/16,0,SW/-2,0>
		matrix <0,0,-1,1,0,0,0,-1,0,-60,43,-1>
		#if (version >= 3.1) material #else texture #end { Color0x06C00C00 }
	}
	object {
		_2982c01_dot_dat
		matrix <1-SW/99,0,0,0,1-SW/36,0,0,0,1-SW/40,SW/-10.4211,SW/-3.6,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-17.998,81,-1.002>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2838c01_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/60,0,0,0,1-SW/120,0,SW/2.30769,SW/-12>
		matrix <-1,0,0,0,1,0,0,0,-1,1,33,70>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_6215_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-0.001,33,-1>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_2838c01_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/60,0,0,0,1-SW/120,0,SW/2.30769,SW/-12>
		matrix <1,0,0,0,1,0,0,0,1,0.999,33,-72.002>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_5306_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/20,0,0,0,1-SW/40,SW/6,SW/3.33333,0>
		matrix <1,0,0,0,1,0,0,0,1,-39.001,17,-0.999>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3659_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-10,9,-1>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3006_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,21.001,9,-1.004>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3001_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-19.002,9,-82.002>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3001_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-19.003,9,79.998>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3004p90_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,21.002,9,108.996>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3004p90_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,20.996,9,-111.002>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object { armthingy_dot_dat matrix <0,0,-1,0,1,0,1,0,0,4.002,55.002,-1.001> #if (version >= 3.1) material #else texture #end { Color7 } }
        #if (clock>=0.41 & clock<0.53)
          rotate (90*(clock-0.41)/0.12)*y
        #end      
        #if (clock>=0.53)
          rotate 90*y
        #end   
        #if (clock>=0.73 & clock<0.83)
	    rotate -90*(clock-0.73)/0.1*y
	 #end     
	 #if (clock>=0.83)
	    rotate -90*y
	 #end
// 
}

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3702)
		#include "lg_3702.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3702_dot_dat = #if (QUAL = 0) box { <-80,-4,-10>, <80,24,10> } #else object {
// Technic Brick  1 x  8 with Holes
	lg_3702
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3702_dot_dat_clear = #if (QUAL = 0) box { <-80,-4,-10>, <80,24,10> } #else object {
// Technic Brick  1 x  8 with Holes
	lg_3702_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3032)
		#include "lg_3032.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3032_dot_dat = #if (QUAL = 0) box { <-60,-4,-40>, <60,8,40> } #else object {
// Plate  4 x  6
	lg_3032
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3032_dot_dat_clear = #if (QUAL = 0) box { <-60,-4,-40>, <60,8,40> } #else object {
// Plate  4 x  6
	lg_3032_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4019)
		#include "lg_4019.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4019_dot_dat = #if (QUAL = 0) box { <-21.97,-21.97,-10>, <21.97,21.97,10> } #else object {
// Technic Gear 16 Tooth
	lg_4019
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4019_dot_dat_clear = #if (QUAL = 0) box { <-21.97,-21.97,-10>, <21.97,21.97,10> } #else object {
// Technic Gear 16 Tooth
	lg_4019_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare bushloc2_dot_dat = object {
// Bush Lock 2
// Name: BUSHLOC2.dat
// Author: James Jessiman
// Original LDraw Primitive - LDraw beta 0.27 Archive
	mesh {
		triangle { <6,0,0>, <6,2,0>, <9,2,0> }
		triangle { <9,2,0>, <9,0,0>, <6,0,0> }
		triangle { <6,0,0>, <5.88,0,-1.17>, <8.83,0,-1.76> }
		triangle { <8.83,0,-1.76>, <9,0,0>, <6,0,0> }
		triangle { <5.88,0,-1.17>, <5.88,2,-1.17>, <8.83,2,-1.76> }
		triangle { <8.83,2,-1.76>, <8.83,0,-1.76>, <5.88,0,-1.17> }
		triangle { <5.88,2,-1.17>, <5.54,2,-2.3>, <8.31,2,-3.44> }
		triangle { <8.31,2,-3.44>, <8.83,2,-1.76>, <5.88,2,-1.17> }
		triangle { <5.88,0,-1.17>, <5.88,2,-1.17>, <5.54,2,-2.3> }
		triangle { <5.54,2,-2.3>, <5.54,0,-2.3>, <5.88,0,-1.17> }
		triangle { <8.83,0,-1.76>, <8.83,2,-1.76>, <8.31,2,-3.44> }
		triangle { <8.31,2,-3.44>, <8.31,0,-3.44>, <8.83,0,-1.76> }
		triangle { <5.54,0,-2.3>, <5.54,2,-2.3>, <8.31,2,-3.44> }
		triangle { <8.31,2,-3.44>, <8.31,0,-3.44>, <5.54,0,-2.3> }
		triangle { <5.54,0,-2.3>, <4.99,0,-3.33>, <7.48,0,-5> }
		triangle { <7.48,0,-5>, <8.31,0,-3.44>, <5.54,0,-2.3> }
		triangle { <4.99,0,-3.33>, <4.99,2,-3.33>, <7.48,2,-5> }
		triangle { <7.48,2,-5>, <7.48,0,-5>, <4.99,0,-3.33> }
		triangle { <4.99,2,-3.33>, <4.24,2,-4.24>, <6.36,2,-6.36> }
		triangle { <6.36,2,-6.36>, <7.48,2,-5>, <4.99,2,-3.33> }
		triangle { <4.99,0,-3.33>, <4.99,2,-3.33>, <4.24,2,-4.24> }
		triangle { <4.24,2,-4.24>, <4.24,0,-4.24>, <4.99,0,-3.33> }
		triangle { <7.48,0,-5>, <7.48,2,-5>, <6.36,2,-6.36> }
		triangle { <6.36,2,-6.36>, <6.36,0,-6.36>, <7.48,0,-5> }
		triangle { <4.24,0,-4.24>, <4.24,2,-4.24>, <6.36,2,-6.36> }
		triangle { <6.36,2,-6.36>, <6.36,0,-6.36>, <4.24,0,-4.24> }
		triangle { <4.24,0,-4.24>, <3.33,0,-4.99>, <5,0,-7.48> }
		triangle { <5,0,-7.48>, <6.36,0,-6.36>, <4.24,0,-4.24> }
		triangle { <3.33,0,-4.99>, <3.33,2,-4.99>, <5,2,-7.48> }
		triangle { <5,2,-7.48>, <5,0,-7.48>, <3.33,0,-4.99> }
		triangle { <3.33,2,-4.99>, <2.3,2,-5.54>, <3.44,2,-8.31> }
		triangle { <3.44,2,-8.31>, <5,2,-7.48>, <3.33,2,-4.99> }
		triangle { <3.33,0,-4.99>, <3.33,2,-4.99>, <2.3,2,-5.54> }
		triangle { <2.3,2,-5.54>, <2.3,0,-5.54>, <3.33,0,-4.99> }
		triangle { <5,0,-7.48>, <5,2,-7.48>, <3.44,2,-8.31> }
		triangle { <3.44,2,-8.31>, <3.44,0,-8.31>, <5,0,-7.48> }
		triangle { <2.3,0,-5.54>, <2.3,2,-5.54>, <3.44,2,-8.31> }
		triangle { <3.44,2,-8.31>, <3.44,0,-8.31>, <2.3,0,-5.54> }
		triangle { <2.3,0,-5.54>, <1.17,0,-5.88>, <1.76,0,-8.83> }
		triangle { <1.76,0,-8.83>, <3.44,0,-8.31>, <2.3,0,-5.54> }
		triangle { <1.17,0,-5.88>, <1.17,2,-5.88>, <1.76,2,-8.83> }
		triangle { <1.76,2,-8.83>, <1.76,0,-8.83>, <1.17,0,-5.88> }
		triangle { <1.17,2,-5.88>, <0,2,-6>, <0,2,-9> }
		triangle { <0,2,-9>, <1.76,2,-8.83>, <1.17,2,-5.88> }
		triangle { <1.17,0,-5.88>, <1.17,2,-5.88>, <0,2,-6> }
		triangle { <0,2,-6>, <0,0,-6>, <1.17,0,-5.88> }
		triangle { <1.76,0,-8.83>, <1.76,2,-8.83>, <0,2,-9> }
		triangle { <0,2,-9>, <0,0,-9>, <1.76,0,-8.83> }
		triangle { <0,0,-6>, <0,2,-6>, <0,2,-9> }
		triangle { <0,2,-9>, <0,0,-9>, <0,0,-6> }
		triangle { <0,0,-6>, <-1.17,0,-5.88>, <-1.76,0,-8.83> }
		triangle { <-1.76,0,-8.83>, <0,0,-9>, <0,0,-6> }
		triangle { <-1.17,0,-5.88>, <-1.17,2,-5.88>, <-1.76,2,-8.83> }
		triangle { <-1.76,2,-8.83>, <-1.76,0,-8.83>, <-1.17,0,-5.88> }
		triangle { <-1.17,2,-5.88>, <-2.3,2,-5.54>, <-3.44,2,-8.31> }
		triangle { <-3.44,2,-8.31>, <-1.76,2,-8.83>, <-1.17,2,-5.88> }
		triangle { <-1.17,0,-5.88>, <-1.17,2,-5.88>, <-2.3,2,-5.54> }
		triangle { <-2.3,2,-5.54>, <-2.3,0,-5.54>, <-1.17,0,-5.88> }
		triangle { <-1.76,0,-8.83>, <-1.76,2,-8.83>, <-3.44,2,-8.31> }
		triangle { <-3.44,2,-8.31>, <-3.44,0,-8.31>, <-1.76,0,-8.83> }
		triangle { <-2.3,0,-5.54>, <-2.3,2,-5.54>, <-3.44,2,-8.31> }
		triangle { <-3.44,2,-8.31>, <-3.44,0,-8.31>, <-2.3,0,-5.54> }
		triangle { <-2.3,0,-5.54>, <-3.33,0,-4.99>, <-5,0,-7.48> }
		triangle { <-5,0,-7.48>, <-3.44,0,-8.31>, <-2.3,0,-5.54> }
		triangle { <-3.33,0,-4.99>, <-3.33,2,-4.99>, <-5,2,-7.48> }
		triangle { <-5,2,-7.48>, <-5,0,-7.48>, <-3.33,0,-4.99> }
		triangle { <-3.33,2,-4.99>, <-4.24,2,-4.24>, <-6.36,2,-6.36> }
		triangle { <-6.36,2,-6.36>, <-5,2,-7.48>, <-3.33,2,-4.99> }
		triangle { <-3.33,0,-4.99>, <-3.33,2,-4.99>, <-4.24,2,-4.24> }
		triangle { <-4.24,2,-4.24>, <-4.24,0,-4.24>, <-3.33,0,-4.99> }
		triangle { <-5,0,-7.48>, <-5,2,-7.48>, <-6.36,2,-6.36> }
		triangle { <-6.36,2,-6.36>, <-6.36,0,-6.36>, <-5,0,-7.48> }
		triangle { <-4.24,0,-4.24>, <-4.24,2,-4.24>, <-6.36,2,-6.36> }
		triangle { <-6.36,2,-6.36>, <-6.36,0,-6.36>, <-4.24,0,-4.24> }
		triangle { <-4.24,0,-4.24>, <-4.99,0,-3.33>, <-7.48,0,-5> }
		triangle { <-7.48,0,-5>, <-6.36,0,-6.36>, <-4.24,0,-4.24> }
		triangle { <-4.99,0,-3.33>, <-4.99,2,-3.33>, <-7.48,2,-5> }
		triangle { <-7.48,2,-5>, <-7.48,0,-5>, <-4.99,0,-3.33> }
		triangle { <-4.99,2,-3.33>, <-5.54,2,-2.3>, <-8.31,2,-3.44> }
		triangle { <-8.31,2,-3.44>, <-7.48,2,-5>, <-4.99,2,-3.33> }
		triangle { <-4.99,0,-3.33>, <-4.99,2,-3.33>, <-5.54,2,-2.3> }
		triangle { <-5.54,2,-2.3>, <-5.54,0,-2.3>, <-4.99,0,-3.33> }
		triangle { <-7.48,0,-5>, <-7.48,2,-5>, <-8.31,2,-3.44> }
		triangle { <-8.31,2,-3.44>, <-8.31,0,-3.44>, <-7.48,0,-5> }
		triangle { <-5.54,0,-2.3>, <-5.54,2,-2.3>, <-8.31,2,-3.44> }
		triangle { <-8.31,2,-3.44>, <-8.31,0,-3.44>, <-5.54,0,-2.3> }
		triangle { <-5.54,0,-2.3>, <-5.88,0,-1.17>, <-8.83,0,-1.76> }
		triangle { <-8.83,0,-1.76>, <-8.31,0,-3.44>, <-5.54,0,-2.3> }
		triangle { <-5.88,0,-1.17>, <-5.88,2,-1.17>, <-8.83,2,-1.76> }
		triangle { <-8.83,2,-1.76>, <-8.83,0,-1.76>, <-5.88,0,-1.17> }
		triangle { <-5.88,2,-1.17>, <-6,2,0>, <-9,2,0> }
		triangle { <-9,2,0>, <-8.83,2,-1.76>, <-5.88,2,-1.17> }
		triangle { <-5.88,0,-1.17>, <-5.88,2,-1.17>, <-6,2,0> }
		triangle { <-6,2,0>, <-6,0,0>, <-5.88,0,-1.17> }
		triangle { <-8.83,0,-1.76>, <-8.83,2,-1.76>, <-9,2,0> }
		triangle { <-9,2,0>, <-9,0,0>, <-8.83,0,-1.76> }
		triangle { <-6,0,0>, <-6,2,0>, <-9,2,0> }
		triangle { <-9,2,0>, <-9,0,0>, <-6,0,0> }
		triangle { <-6,0,0>, <-5.88,0,1.17>, <-8.83,0,1.76> }
		triangle { <-8.83,0,1.76>, <-9,0,0>, <-6,0,0> }
		triangle { <-5.88,0,1.17>, <-5.88,2,1.17>, <-8.83,2,1.76> }
		triangle { <-8.83,2,1.76>, <-8.83,0,1.76>, <-5.88,0,1.17> }
		triangle { <-5.88,2,1.17>, <-5.54,2,2.3>, <-8.31,2,3.44> }
		triangle { <-8.31,2,3.44>, <-8.83,2,1.76>, <-5.88,2,1.17> }
		triangle { <-5.88,0,1.17>, <-5.88,2,1.17>, <-5.54,2,2.3> }
		triangle { <-5.54,2,2.3>, <-5.54,0,2.3>, <-5.88,0,1.17> }
		triangle { <-8.83,0,1.76>, <-8.83,2,1.76>, <-8.31,2,3.44> }
		triangle { <-8.31,2,3.44>, <-8.31,0,3.44>, <-8.83,0,1.76> }
		triangle { <-5.54,0,2.3>, <-5.54,2,2.3>, <-8.31,2,3.44> }
		triangle { <-8.31,2,3.44>, <-8.31,0,3.44>, <-5.54,0,2.3> }
		triangle { <-5.54,0,2.3>, <-4.99,0,3.33>, <-7.48,0,5> }
		triangle { <-7.48,0,5>, <-8.31,0,3.44>, <-5.54,0,2.3> }
		triangle { <-4.99,0,3.33>, <-4.99,2,3.33>, <-7.48,2,5> }
		triangle { <-7.48,2,5>, <-7.48,0,5>, <-4.99,0,3.33> }
		triangle { <-4.99,2,3.33>, <-4.24,2,4.24>, <-6.36,2,6.36> }
		triangle { <-6.36,2,6.36>, <-7.48,2,5>, <-4.99,2,3.33> }
		triangle { <-4.99,0,3.33>, <-4.99,2,3.33>, <-4.24,2,4.24> }
		triangle { <-4.24,2,4.24>, <-4.24,0,4.24>, <-4.99,0,3.33> }
		triangle { <-7.48,0,5>, <-7.48,2,5>, <-6.36,2,6.36> }
		triangle { <-6.36,2,6.36>, <-6.36,0,6.36>, <-7.48,0,5> }
		triangle { <-4.24,0,4.24>, <-4.24,2,4.24>, <-6.36,2,6.36> }
		triangle { <-6.36,2,6.36>, <-6.36,0,6.36>, <-4.24,0,4.24> }
		triangle { <-4.24,0,4.24>, <-3.33,0,4.99>, <-5,0,7.48> }
		triangle { <-5,0,7.48>, <-6.36,0,6.36>, <-4.24,0,4.24> }
		triangle { <-3.33,0,4.99>, <-3.33,2,4.99>, <-5,2,7.48> }
		triangle { <-5,2,7.48>, <-5,0,7.48>, <-3.33,0,4.99> }
		triangle { <-3.33,2,4.99>, <-2.3,2,5.54>, <-3.44,2,8.31> }
		triangle { <-3.44,2,8.31>, <-5,2,7.48>, <-3.33,2,4.99> }
		triangle { <-3.33,0,4.99>, <-3.33,2,4.99>, <-2.3,2,5.54> }
		triangle { <-2.3,2,5.54>, <-2.3,0,5.54>, <-3.33,0,4.99> }
		triangle { <-5,0,7.48>, <-5,2,7.48>, <-3.44,2,8.31> }
		triangle { <-3.44,2,8.31>, <-3.44,0,8.31>, <-5,0,7.48> }
		triangle { <-2.3,0,5.54>, <-2.3,2,5.54>, <-3.44,2,8.31> }
		triangle { <-3.44,2,8.31>, <-3.44,0,8.31>, <-2.3,0,5.54> }
		triangle { <-2.3,0,5.54>, <-1.17,0,5.88>, <-1.76,0,8.83> }
		triangle { <-1.76,0,8.83>, <-3.44,0,8.31>, <-2.3,0,5.54> }
		triangle { <-1.17,0,5.88>, <-1.17,2,5.88>, <-1.76,2,8.83> }
		triangle { <-1.76,2,8.83>, <-1.76,0,8.83>, <-1.17,0,5.88> }
		triangle { <-1.17,2,5.88>, <0,2,6>, <0,2,9> }
		triangle { <0,2,9>, <-1.76,2,8.83>, <-1.17,2,5.88> }
		triangle { <-1.17,0,5.88>, <-1.17,2,5.88>, <0,2,6> }
		triangle { <0,2,6>, <0,0,6>, <-1.17,0,5.88> }
		triangle { <-1.76,0,8.83>, <-1.76,2,8.83>, <0,2,9> }
		triangle { <0,2,9>, <0,0,9>, <-1.76,0,8.83> }
		triangle { <0,0,6>, <0,2,6>, <0,2,9> }
		triangle { <0,2,9>, <0,0,9>, <0,0,6> }
		triangle { <0,0,6>, <1.17,0,5.88>, <1.76,0,8.83> }
		triangle { <1.76,0,8.83>, <0,0,9>, <0,0,6> }
		triangle { <1.17,0,5.88>, <1.17,2,5.88>, <1.76,2,8.83> }
		triangle { <1.76,2,8.83>, <1.76,0,8.83>, <1.17,0,5.88> }
		triangle { <1.17,2,5.88>, <2.3,2,5.54>, <3.44,2,8.31> }
		triangle { <3.44,2,8.31>, <1.76,2,8.83>, <1.17,2,5.88> }
		triangle { <1.17,0,5.88>, <1.17,2,5.88>, <2.3,2,5.54> }
		triangle { <2.3,2,5.54>, <2.3,0,5.54>, <1.17,0,5.88> }
		triangle { <1.76,0,8.83>, <1.76,2,8.83>, <3.44,2,8.31> }
		triangle { <3.44,2,8.31>, <3.44,0,8.31>, <1.76,0,8.83> }
		triangle { <2.3,0,5.54>, <2.3,2,5.54>, <3.44,2,8.31> }
		triangle { <3.44,2,8.31>, <3.44,0,8.31>, <2.3,0,5.54> }
		triangle { <2.3,0,5.54>, <3.33,0,4.99>, <5,0,7.48> }
		triangle { <5,0,7.48>, <3.44,0,8.31>, <2.3,0,5.54> }
		triangle { <3.33,0,4.99>, <3.33,2,4.99>, <5,2,7.48> }
		triangle { <5,2,7.48>, <5,0,7.48>, <3.33,0,4.99> }
		triangle { <3.33,2,4.99>, <4.24,2,4.24>, <6.36,2,6.36> }
		triangle { <6.36,2,6.36>, <5,2,7.48>, <3.33,2,4.99> }
		triangle { <3.33,0,4.99>, <3.33,2,4.99>, <4.24,2,4.24> }
		triangle { <4.24,2,4.24>, <4.24,0,4.24>, <3.33,0,4.99> }
		triangle { <5,0,7.48>, <5,2,7.48>, <6.36,2,6.36> }
		triangle { <6.36,2,6.36>, <6.36,0,6.36>, <5,0,7.48> }
		triangle { <4.24,0,4.24>, <4.24,2,4.24>, <6.36,2,6.36> }
		triangle { <6.36,2,6.36>, <6.36,0,6.36>, <4.24,0,4.24> }
		triangle { <4.24,0,4.24>, <4.99,0,3.33>, <7.48,0,5> }
		triangle { <7.48,0,5>, <6.36,0,6.36>, <4.24,0,4.24> }
		triangle { <4.99,0,3.33>, <4.99,2,3.33>, <7.48,2,5> }
		triangle { <7.48,2,5>, <7.48,0,5>, <4.99,0,3.33> }
		triangle { <4.99,2,3.33>, <5.54,2,2.3>, <8.31,2,3.44> }
		triangle { <8.31,2,3.44>, <7.48,2,5>, <4.99,2,3.33> }
		triangle { <4.99,0,3.33>, <4.99,2,3.33>, <5.54,2,2.3> }
		triangle { <5.54,2,2.3>, <5.54,0,2.3>, <4.99,0,3.33> }
		triangle { <7.48,0,5>, <7.48,2,5>, <8.31,2,3.44> }
		triangle { <8.31,2,3.44>, <8.31,0,3.44>, <7.48,0,5> }
		triangle { <5.54,0,2.3>, <5.54,2,2.3>, <8.31,2,3.44> }
		triangle { <8.31,2,3.44>, <8.31,0,3.44>, <5.54,0,2.3> }
		triangle { <5.54,0,2.3>, <5.88,0,1.17>, <8.83,0,1.76> }
		triangle { <8.83,0,1.76>, <8.31,0,3.44>, <5.54,0,2.3> }
		triangle { <5.88,0,1.17>, <5.88,2,1.17>, <8.83,2,1.76> }
		triangle { <8.83,2,1.76>, <8.83,0,1.76>, <5.88,0,1.17> }
		triangle { <5.88,2,1.17>, <6,2,0>, <9,2,0> }
		triangle { <9,2,0>, <8.83,2,1.76>, <5.88,2,1.17> }
		triangle { <5.88,0,1.17>, <5.88,2,1.17>, <6,2,0> }
		triangle { <6,2,0>, <6,0,0>, <5.88,0,1.17> }
		triangle { <8.83,0,1.76>, <8.83,2,1.76>, <9,2,0> }
		triangle { <9,2,0>, <9,0,0>, <8.83,0,1.76> }
// 
	}
}

#declare axlehole_dot_dat = object {
// Axle Hole
// Name: axlehole.dat
// Author: James Jessiman
// Original LDraw Primitive 2000-01
// 2000-04-23 SEB Added conditional edges along outermost diameters
// 2 24 6    0 0    5.52 0 2.28
// 2 24 5.52 0 2.28 4.26 0 4.26
// 2 24 4.26 0 4.26 2.28 0 5.52
// 2 24 2.28 0 5.52 0    0 6
// 2 24 6    0 0    5.58 0 2
// 2 24 2    0 5.58 0    0 6
// 2 24 -6    0 0    -5.58 0 2
// 2 24 -2    0 5.58 -0    0 6
// 2 24 6    0 -0    5.58 0 -2
// 2 24 2    0 -5.58 0    0 -6
// 2 24 -6    0 -0    -5.58 0 -2
// 2 24 -2    0 -5.58 -0    0 -6
// 2 24 6    1 0    5.58 1 2
// 2 24 2    1 5.58 0    1 6
// 2 24 -6    1 0    -5.58 1 2
// 2 24 -2    1 5.58 -0    1 6
// 2 24 6    1 -0    5.58 1 -2
// 2 24 2    1 -5.58 0    1 -6
// 2 24 -6    1 -0    -5.58 1 -2
// 2 24 -2    1 -5.58 -0    1 -6
	mesh {
		triangle { <6,0,0>, <5.58,0,2>, <5.58,1,2> }
		triangle { <5.58,1,2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,2>, <2,0,2>, <2,1,2> }
		triangle { <2,1,2>, <5.58,1,2>, <5.58,0,2> }
		triangle { <2,0,2>, <2,0,5.58>, <2,1,5.58> }
		triangle { <2,1,5.58>, <2,1,2>, <2,0,2> }
		triangle { <2,0,5.58>, <0,0,6>, <0,1,6> }
		triangle { <0,1,6>, <2,1,5.58>, <2,0,5.58> }
		triangle { <-6,0,0>, <-5.58,0,2>, <-5.58,1,2> }
		triangle { <-5.58,1,2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,2>, <-2,0,2>, <-2,1,2> }
		triangle { <-2,1,2>, <-5.58,1,2>, <-5.58,0,2> }
		triangle { <-2,0,2>, <-2,0,5.58>, <-2,1,5.58> }
		triangle { <-2,1,5.58>, <-2,1,2>, <-2,0,2> }
		triangle { <-2,0,5.58>, <0,0,6>, <0,1,6> }
		triangle { <0,1,6>, <-2,1,5.58>, <-2,0,5.58> }
		triangle { <6,0,0>, <5.58,0,-2>, <5.58,1,-2> }
		triangle { <5.58,1,-2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,-2>, <2,0,-2>, <2,1,-2> }
		triangle { <2,1,-2>, <5.58,1,-2>, <5.58,0,-2> }
		triangle { <2,0,-2>, <2,0,-5.58>, <2,1,-5.58> }
		triangle { <2,1,-5.58>, <2,1,-2>, <2,0,-2> }
		triangle { <2,0,-5.58>, <0,0,-6>, <0,1,-6> }
		triangle { <0,1,-6>, <2,1,-5.58>, <2,0,-5.58> }
		triangle { <-6,0,0>, <-5.58,0,-2>, <-5.58,1,-2> }
		triangle { <-5.58,1,-2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,-2>, <-2,0,-2>, <-2,1,-2> }
		triangle { <-2,1,-2>, <-5.58,1,-2>, <-5.58,0,-2> }
		triangle { <-2,0,-2>, <-2,0,-5.58>, <-2,1,-5.58> }
		triangle { <-2,1,-5.58>, <-2,1,-2>, <-2,0,-2> }
		triangle { <-2,0,-5.58>, <0,0,-6>, <0,1,-6> }
		triangle { <0,1,-6>, <-2,1,-5.58>, <-2,0,-5.58> }
		triangle { <5.58,0,2>, <5.52,0,2.28>, <2,0,2> }
		triangle { <5.52,0,2.28>, <4.26,0,4.26>, <2,0,2> }
		triangle { <4.26,0,4.26>, <2.28,0,5.52>, <2,0,2> }
		triangle { <2.28,0,5.52>, <2,0,5.58>, <2,0,2> }
		triangle { <-5.58,0,2>, <-5.52,0,2.28>, <-2,0,2> }
		triangle { <-5.52,0,2.28>, <-4.26,0,4.26>, <-2,0,2> }
		triangle { <-4.26,0,4.26>, <-2.28,0,5.52>, <-2,0,2> }
		triangle { <-2.28,0,5.52>, <-2,0,5.58>, <-2,0,2> }
		triangle { <5.58,0,-2>, <5.52,0,-2.28>, <2,0,-2> }
		triangle { <5.52,0,-2.28>, <4.26,0,-4.26>, <2,0,-2> }
		triangle { <4.26,0,-4.26>, <2.28,0,-5.52>, <2,0,-2> }
		triangle { <2.28,0,-5.52>, <2,0,-5.58>, <2,0,-2> }
		triangle { <-5.58,0,-2>, <-5.52,0,-2.28>, <-2,0,-2> }
		triangle { <-5.52,0,-2.28>, <-4.26,0,-4.26>, <-2,0,-2> }
		triangle { <-4.26,0,-4.26>, <-2.28,0,-5.52>, <-2,0,-2> }
		triangle { <-2.28,0,-5.52>, <-2,0,-5.58>, <-2,0,-2> }
		triangle { <5.58,1,2>, <5.52,1,2.28>, <2,1,2> }
		triangle { <5.52,1,2.28>, <4.26,1,4.26>, <2,1,2> }
		triangle { <4.26,1,4.26>, <2.28,1,5.52>, <2,1,2> }
		triangle { <2.28,1,5.52>, <2,1,5.58>, <2,1,2> }
		triangle { <-5.58,1,2>, <-5.52,1,2.28>, <-2,1,2> }
		triangle { <-5.52,1,2.28>, <-4.26,1,4.26>, <-2,1,2> }
		triangle { <-4.26,1,4.26>, <-2.28,1,5.52>, <-2,1,2> }
		triangle { <-2.28,1,5.52>, <-2,1,5.58>, <-2,1,2> }
		triangle { <5.58,1,-2>, <5.52,1,-2.28>, <2,1,-2> }
		triangle { <5.52,1,-2.28>, <4.26,1,-4.26>, <2,1,-2> }
		triangle { <4.26,1,-4.26>, <2.28,1,-5.52>, <2,1,-2> }
		triangle { <2.28,1,-5.52>, <2,1,-5.58>, <2,1,-2> }
		triangle { <-5.58,1,-2>, <-5.52,1,-2.28>, <-2,1,-2> }
		triangle { <-5.52,1,-2.28>, <-4.26,1,-4.26>, <-2,1,-2> }
		triangle { <-4.26,1,-4.26>, <-2.28,1,-5.52>, <-2,1,-2> }
		triangle { <-2.28,1,-5.52>, <-2,1,-5.58>, <-2,1,-2> }
	}
}

#declare _4265a_dot_dat = #if (QUAL = 0) box { <-9,-9,-5>, <9,9,5> } #else union {
// Technic Bush 1/2 Type I
// Name: 4265a.dat
// Author: James Jessiman
// Official LCad update 99-05
	object { axlehole_dot_dat matrix <1,0,0,0,0,8,0,1,0,0,0,-5> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,0,3,0,9,0,0,0,-5> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,0,1,0,9,0,0,0,2> }
	object { bushloc2_dot_dat matrix <-1,0,0,0,0,1,0,1,0,0,0,3> }
	mesh {
		triangle { <0,6,-5>, <-2.3,5.54,-5>, <-3.44,8.31,-5> }
		triangle { <-3.44,8.31,-5>, <0,9,-5>, <0,6,-5> }
		triangle { <0,9,-2>, <-3.44,8.31,-2>, <-2.9,7,-1.42> }
		triangle { <-2.9,7,-1.42>, <0,7.58,-1.42>, <0,9,-2> }
		triangle { <0,7.58,-1.42>, <-2.9,7,-1.42>, <-2.68,6.47,0> }
		triangle { <-2.68,6.47,0>, <0,7,0>, <0,7.58,-1.42> }
		triangle { <0,7,0>, <-2.68,6.47,0>, <-2.9,7,1.42> }
		triangle { <-2.9,7,1.42>, <0,7.58,1.42>, <0,7,0> }
		triangle { <0,7.58,1.42>, <-2.9,7,1.42>, <-3.44,8.31,2> }
		triangle { <-3.44,8.31,2>, <0,9,2>, <0,7.58,1.42> }
		triangle { <-2.3,5.54,-5>, <-4.24,4.24,-5>, <-6.36,6.36,-5> }
		triangle { <-6.36,6.36,-5>, <-3.44,8.31,-5>, <-2.3,5.54,-5> }
		triangle { <-3.44,8.31,-2>, <-6.36,6.36,-2>, <-5.36,5.36,-1.42> }
		triangle { <-5.36,5.36,-1.42>, <-2.9,7,-1.42>, <-3.44,8.31,-2> }
		triangle { <-2.9,7,-1.42>, <-5.36,5.36,-1.42>, <-4.95,4.95,0> }
		triangle { <-4.95,4.95,0>, <-2.68,6.47,0>, <-2.9,7,-1.42> }
		triangle { <-2.68,6.47,0>, <-4.95,4.95,0>, <-5.36,5.36,1.42> }
		triangle { <-5.36,5.36,1.42>, <-2.9,7,1.42>, <-2.68,6.47,0> }
		triangle { <-2.9,7,1.42>, <-5.36,5.36,1.42>, <-6.36,6.36,2> }
		triangle { <-6.36,6.36,2>, <-3.44,8.31,2>, <-2.9,7,1.42> }
		triangle { <-4.24,4.24,-5>, <-5.54,2.3,-5>, <-8.31,3.44,-5> }
		triangle { <-8.31,3.44,-5>, <-6.36,6.36,-5>, <-4.24,4.24,-5> }
		triangle { <-6.36,6.36,-2>, <-8.31,3.44,-2>, <-7,2.9,-1.42> }
		triangle { <-7,2.9,-1.42>, <-5.36,5.36,-1.42>, <-6.36,6.36,-2> }
		triangle { <-5.36,5.36,-1.42>, <-7,2.9,-1.42>, <-6.47,2.68,0> }
		triangle { <-6.47,2.68,0>, <-4.95,4.95,0>, <-5.36,5.36,-1.42> }
		triangle { <-4.95,4.95,0>, <-6.47,2.68,0>, <-7,2.9,1.42> }
		triangle { <-7,2.9,1.42>, <-5.36,5.36,1.42>, <-4.95,4.95,0> }
		triangle { <-5.36,5.36,1.42>, <-7,2.9,1.42>, <-8.31,3.44,2> }
		triangle { <-8.31,3.44,2>, <-6.36,6.36,2>, <-5.36,5.36,1.42> }
		triangle { <-5.54,2.3,-5>, <-6,0,-5>, <-9,0,-5> }
		triangle { <-9,0,-5>, <-8.31,3.44,-5>, <-5.54,2.3,-5> }
		triangle { <-8.31,3.44,-2>, <-9,0,-2>, <-7.58,0,-1.42> }
		triangle { <-7.58,0,-1.42>, <-7,2.9,-1.42>, <-8.31,3.44,-2> }
		triangle { <-7,2.9,-1.42>, <-7.58,0,-1.42>, <-7,0,0> }
		triangle { <-7,0,0>, <-6.47,2.68,0>, <-7,2.9,-1.42> }
		triangle { <-6.47,2.68,0>, <-7,0,0>, <-7.58,0,1.42> }
		triangle { <-7.58,0,1.42>, <-7,2.9,1.42>, <-6.47,2.68,0> }
		triangle { <-7,2.9,1.42>, <-7.58,0,1.42>, <-9,0,2> }
		triangle { <-9,0,2>, <-8.31,3.44,2>, <-7,2.9,1.42> }
		triangle { <-6,0,-5>, <-5.54,-2.3,-5>, <-8.31,-3.44,-5> }
		triangle { <-8.31,-3.44,-5>, <-9,0,-5>, <-6,0,-5> }
		triangle { <-9,0,-2>, <-8.31,-3.44,-2>, <-7,-2.9,-1.42> }
		triangle { <-7,-2.9,-1.42>, <-7.58,0,-1.42>, <-9,0,-2> }
		triangle { <-7.58,0,-1.42>, <-7,-2.9,-1.42>, <-6.47,-2.68,0> }
		triangle { <-6.47,-2.68,0>, <-7,0,0>, <-7.58,0,-1.42> }
		triangle { <-7,0,0>, <-6.47,-2.68,0>, <-7,-2.9,1.42> }
		triangle { <-7,-2.9,1.42>, <-7.58,0,1.42>, <-7,0,0> }
		triangle { <-7.58,0,1.42>, <-7,-2.9,1.42>, <-8.31,-3.44,2> }
		triangle { <-8.31,-3.44,2>, <-9,0,2>, <-7.58,0,1.42> }
		triangle { <-5.54,-2.3,-5>, <-4.24,-4.24,-5>, <-6.36,-6.36,-5> }
		triangle { <-6.36,-6.36,-5>, <-8.31,-3.44,-5>, <-5.54,-2.3,-5> }
		triangle { <-8.31,-3.44,-2>, <-6.36,-6.36,-2>, <-5.36,-5.36,-1.42> }
		triangle { <-5.36,-5.36,-1.42>, <-7,-2.9,-1.42>, <-8.31,-3.44,-2> }
		triangle { <-7,-2.9,-1.42>, <-5.36,-5.36,-1.42>, <-4.95,-4.95,0> }
		triangle { <-4.95,-4.95,0>, <-6.47,-2.68,0>, <-7,-2.9,-1.42> }
		triangle { <-6.47,-2.68,0>, <-4.95,-4.95,0>, <-5.36,-5.36,1.42> }
		triangle { <-5.36,-5.36,1.42>, <-7,-2.9,1.42>, <-6.47,-2.68,0> }
		triangle { <-7,-2.9,1.42>, <-5.36,-5.36,1.42>, <-6.36,-6.36,2> }
		triangle { <-6.36,-6.36,2>, <-8.31,-3.44,2>, <-7,-2.9,1.42> }
		triangle { <-4.24,-4.24,-5>, <-2.3,-5.54,-5>, <-3.44,-8.31,-5> }
		triangle { <-3.44,-8.31,-5>, <-6.36,-6.36,-5>, <-4.24,-4.24,-5> }
		triangle { <-6.36,-6.36,-2>, <-3.44,-8.31,-2>, <-2.9,-7,-1.42> }
		triangle { <-2.9,-7,-1.42>, <-5.36,-5.36,-1.42>, <-6.36,-6.36,-2> }
		triangle { <-5.36,-5.36,-1.42>, <-2.9,-7,-1.42>, <-2.68,-6.47,0> }
		triangle { <-2.68,-6.47,0>, <-4.95,-4.95,0>, <-5.36,-5.36,-1.42> }
		triangle { <-4.95,-4.95,0>, <-2.68,-6.47,0>, <-2.9,-7,1.42> }
		triangle { <-2.9,-7,1.42>, <-5.36,-5.36,1.42>, <-4.95,-4.95,0> }
		triangle { <-5.36,-5.36,1.42>, <-2.9,-7,1.42>, <-3.44,-8.31,2> }
		triangle { <-3.44,-8.31,2>, <-6.36,-6.36,2>, <-5.36,-5.36,1.42> }
		triangle { <-2.3,-5.54,-5>, <0,-6,-5>, <0,-9,-5> }
		triangle { <0,-9,-5>, <-3.44,-8.31,-5>, <-2.3,-5.54,-5> }
		triangle { <-3.44,-8.31,-2>, <0,-9,-2>, <0,-7.58,-1.42> }
		triangle { <0,-7.58,-1.42>, <-2.9,-7,-1.42>, <-3.44,-8.31,-2> }
		triangle { <-2.9,-7,-1.42>, <0,-7.58,-1.42>, <0,-7,0> }
		triangle { <0,-7,0>, <-2.68,-6.47,0>, <-2.9,-7,-1.42> }
		triangle { <-2.68,-6.47,0>, <0,-7,0>, <0,-7.58,1.42> }
		triangle { <0,-7.58,1.42>, <-2.9,-7,1.42>, <-2.68,-6.47,0> }
		triangle { <-2.9,-7,1.42>, <0,-7.58,1.42>, <0,-9,2> }
		triangle { <0,-9,2>, <-3.44,-8.31,2>, <-2.9,-7,1.42> }
		triangle { <0,-6,-5>, <2.3,-5.54,-5>, <3.44,-8.31,-5> }
		triangle { <3.44,-8.31,-5>, <0,-9,-5>, <0,-6,-5> }
		triangle { <0,-9,-2>, <3.44,-8.31,-2>, <2.9,-7,-1.42> }
		triangle { <2.9,-7,-1.42>, <0,-7.58,-1.42>, <0,-9,-2> }
		triangle { <0,-7.58,-1.42>, <2.9,-7,-1.42>, <2.68,-6.47,0> }
		triangle { <2.68,-6.47,0>, <0,-7,0>, <0,-7.58,-1.42> }
		triangle { <0,-7,0>, <2.68,-6.47,0>, <2.9,-7,1.42> }
		triangle { <2.9,-7,1.42>, <0,-7.58,1.42>, <0,-7,0> }
		triangle { <0,-7.58,1.42>, <2.9,-7,1.42>, <3.44,-8.31,2> }
		triangle { <3.44,-8.31,2>, <0,-9,2>, <0,-7.58,1.42> }
		triangle { <2.3,-5.54,-5>, <4.24,-4.24,-5>, <6.36,-6.36,-5> }
		triangle { <6.36,-6.36,-5>, <3.44,-8.31,-5>, <2.3,-5.54,-5> }
		triangle { <3.44,-8.31,-2>, <6.36,-6.36,-2>, <5.36,-5.36,-1.42> }
		triangle { <5.36,-5.36,-1.42>, <2.9,-7,-1.42>, <3.44,-8.31,-2> }
		triangle { <2.9,-7,-1.42>, <5.36,-5.36,-1.42>, <4.95,-4.95,0> }
		triangle { <4.95,-4.95,0>, <2.68,-6.47,0>, <2.9,-7,-1.42> }
		triangle { <2.68,-6.47,0>, <4.95,-4.95,0>, <5.36,-5.36,1.42> }
		triangle { <5.36,-5.36,1.42>, <2.9,-7,1.42>, <2.68,-6.47,0> }
		triangle { <2.9,-7,1.42>, <5.36,-5.36,1.42>, <6.36,-6.36,2> }
		triangle { <6.36,-6.36,2>, <3.44,-8.31,2>, <2.9,-7,1.42> }
		triangle { <4.24,-4.24,-5>, <5.54,-2.3,-5>, <8.31,-3.44,-5> }
		triangle { <8.31,-3.44,-5>, <6.36,-6.36,-5>, <4.24,-4.24,-5> }
		triangle { <6.36,-6.36,-2>, <8.31,-3.44,-2>, <7,-2.9,-1.42> }
		triangle { <7,-2.9,-1.42>, <5.36,-5.36,-1.42>, <6.36,-6.36,-2> }
		triangle { <5.36,-5.36,-1.42>, <7,-2.9,-1.42>, <6.47,-2.68,0> }
		triangle { <6.47,-2.68,0>, <4.95,-4.95,0>, <5.36,-5.36,-1.42> }
		triangle { <4.95,-4.95,0>, <6.47,-2.68,0>, <7,-2.9,1.42> }
		triangle { <7,-2.9,1.42>, <5.36,-5.36,1.42>, <4.95,-4.95,0> }
		triangle { <5.36,-5.36,1.42>, <7,-2.9,1.42>, <8.31,-3.44,2> }
		triangle { <8.31,-3.44,2>, <6.36,-6.36,2>, <5.36,-5.36,1.42> }
		triangle { <5.54,-2.3,-5>, <6,0,-5>, <9,0,-5> }
		triangle { <9,0,-5>, <8.31,-3.44,-5>, <5.54,-2.3,-5> }
		triangle { <8.31,-3.44,-2>, <9,0,-2>, <7.58,0,-1.42> }
		triangle { <7.58,0,-1.42>, <7,-2.9,-1.42>, <8.31,-3.44,-2> }
		triangle { <7,-2.9,-1.42>, <7.58,0,-1.42>, <7,0,0> }
		triangle { <7,0,0>, <6.47,-2.68,0>, <7,-2.9,-1.42> }
		triangle { <6.47,-2.68,0>, <7,0,0>, <7.58,0,1.42> }
		triangle { <7.58,0,1.42>, <7,-2.9,1.42>, <6.47,-2.68,0> }
		triangle { <7,-2.9,1.42>, <7.58,0,1.42>, <9,0,2> }
		triangle { <9,0,2>, <8.31,-3.44,2>, <7,-2.9,1.42> }
		triangle { <6,0,-5>, <5.54,2.3,-5>, <8.31,3.44,-5> }
		triangle { <8.31,3.44,-5>, <9,0,-5>, <6,0,-5> }
		triangle { <9,0,-2>, <8.31,3.44,-2>, <7,2.9,-1.42> }
		triangle { <7,2.9,-1.42>, <7.58,0,-1.42>, <9,0,-2> }
		triangle { <7.58,0,-1.42>, <7,2.9,-1.42>, <6.47,2.68,0> }
		triangle { <6.47,2.68,0>, <7,0,0>, <7.58,0,-1.42> }
		triangle { <7,0,0>, <6.47,2.68,0>, <7,2.9,1.42> }
		triangle { <7,2.9,1.42>, <7.58,0,1.42>, <7,0,0> }
		triangle { <7.58,0,1.42>, <7,2.9,1.42>, <8.31,3.44,2> }
		triangle { <8.31,3.44,2>, <9,0,2>, <7.58,0,1.42> }
		triangle { <5.54,2.3,-5>, <4.24,4.24,-5>, <6.36,6.36,-5> }
		triangle { <6.36,6.36,-5>, <8.31,3.44,-5>, <5.54,2.3,-5> }
		triangle { <8.31,3.44,-2>, <6.36,6.36,-2>, <5.36,5.36,-1.42> }
		triangle { <5.36,5.36,-1.42>, <7,2.9,-1.42>, <8.31,3.44,-2> }
		triangle { <7,2.9,-1.42>, <5.36,5.36,-1.42>, <4.95,4.95,0> }
		triangle { <4.95,4.95,0>, <6.47,2.68,0>, <7,2.9,-1.42> }
		triangle { <6.47,2.68,0>, <4.95,4.95,0>, <5.36,5.36,1.42> }
		triangle { <5.36,5.36,1.42>, <7,2.9,1.42>, <6.47,2.68,0> }
		triangle { <7,2.9,1.42>, <5.36,5.36,1.42>, <6.36,6.36,2> }
		triangle { <6.36,6.36,2>, <8.31,3.44,2>, <7,2.9,1.42> }
		triangle { <4.24,4.24,-5>, <2.3,5.54,-5>, <3.44,8.31,-5> }
		triangle { <3.44,8.31,-5>, <6.36,6.36,-5>, <4.24,4.24,-5> }
		triangle { <6.36,6.36,-2>, <3.44,8.31,-2>, <2.9,7,-1.42> }
		triangle { <2.9,7,-1.42>, <5.36,5.36,-1.42>, <6.36,6.36,-2> }
		triangle { <5.36,5.36,-1.42>, <2.9,7,-1.42>, <2.68,6.47,0> }
		triangle { <2.68,6.47,0>, <4.95,4.95,0>, <5.36,5.36,-1.42> }
		triangle { <4.95,4.95,0>, <2.68,6.47,0>, <2.9,7,1.42> }
		triangle { <2.9,7,1.42>, <5.36,5.36,1.42>, <4.95,4.95,0> }
		triangle { <5.36,5.36,1.42>, <2.9,7,1.42>, <3.44,8.31,2> }
		triangle { <3.44,8.31,2>, <6.36,6.36,2>, <5.36,5.36,1.42> }
		triangle { <2.3,5.54,-5>, <0,6,-5>, <0,9,-5> }
		triangle { <0,9,-5>, <3.44,8.31,-5>, <2.3,5.54,-5> }
		triangle { <3.44,8.31,-2>, <0,9,-2>, <0,7.58,-1.42> }
		triangle { <0,7.58,-1.42>, <2.9,7,-1.42>, <3.44,8.31,-2> }
		triangle { <2.9,7,-1.42>, <0,7.58,-1.42>, <0,7,0> }
		triangle { <0,7,0>, <2.68,6.47,0>, <2.9,7,-1.42> }
		triangle { <2.68,6.47,0>, <0,7,0>, <0,7.58,1.42> }
		triangle { <0,7.58,1.42>, <2.9,7,1.42>, <2.68,6.47,0> }
		triangle { <2.9,7,1.42>, <0,7.58,1.42>, <0,9,2> }
		triangle { <0,9,2>, <3.44,8.31,2>, <2.9,7,1.42> }
// 
	}
}
#end

#declare axlehol5_dot_dat = object {
// Axle Hole #5
// Name: axlehol5.dat
// Author: James Jessiman
// Original LDraw Primitive 2000-01
// 2000-04-23 SEB Added conditional edges along outermost diameters
// 2 24 6    0 0    5.52 0 2.28
// 2 24 5.52 0 2.28 4.26 0 4.26
// 2 24 4.26 0 4.26 2.28 0 5.52
// 2 24 2.28 0 5.52 0    0 6
// 2 24 2    0 5.58 0    0 6
// 2 24 -2    0 5.58 -0    0 6
// 2 24 2    0 -5.58 0    0 -6
// 2 24 -2    0 -5.58 -0    0 -6
// 2 24 2    1 5.58 0    1 6
// 2 24 -2    1 5.58 -0    1 6
// 2 24 2    1 -5.58 0    1 -6
// 2 24 -2    1 -5.58 -0    1 -6
// 2 24 2    0 5.58 2    1 5.58
// 2 24 -2    0 5.58 -2    1 5.58
// 2 24 2    0 -5.58 2    1 -5.58
// 2 24 -2    0 -5.58 -2    1 -5.58
	mesh {
		triangle { <6,0,0>, <5.58,0,2>, <5.58,1,2> }
		triangle { <5.58,1,2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,2>, <2,0,2>, <2,1,2> }
		triangle { <2,1,2>, <5.58,1,2>, <5.58,0,2> }
		triangle { <2,0,2>, <2,0,5.58>, <2,1,5.58> }
		triangle { <2,1,5.58>, <2,1,2>, <2,0,2> }
// 4 16 2    0 5.58 0    0 6    0    1 6    2    1 5.58
		triangle { <-6,0,0>, <-5.58,0,2>, <-5.58,1,2> }
		triangle { <-5.58,1,2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,2>, <-2,0,2>, <-2,1,2> }
		triangle { <-2,1,2>, <-5.58,1,2>, <-5.58,0,2> }
		triangle { <-2,0,2>, <-2,0,5.58>, <-2,1,5.58> }
		triangle { <-2,1,5.58>, <-2,1,2>, <-2,0,2> }
// 4 16 -2    0 5.58 -0    0 6    -0    1 6    -2    1 5.58
		triangle { <6,0,0>, <5.58,0,-2>, <5.58,1,-2> }
		triangle { <5.58,1,-2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,-2>, <2,0,-2>, <2,1,-2> }
		triangle { <2,1,-2>, <5.58,1,-2>, <5.58,0,-2> }
		triangle { <2,0,-2>, <2,0,-5.58>, <2,1,-5.58> }
		triangle { <2,1,-5.58>, <2,1,-2>, <2,0,-2> }
// 4 16 2    0 -5.58 0    0 -6    0    1 -6    2    1 -5.58
		triangle { <-6,0,0>, <-5.58,0,-2>, <-5.58,1,-2> }
		triangle { <-5.58,1,-2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,-2>, <-2,0,-2>, <-2,1,-2> }
		triangle { <-2,1,-2>, <-5.58,1,-2>, <-5.58,0,-2> }
		triangle { <-2,0,-2>, <-2,0,-5.58>, <-2,1,-5.58> }
		triangle { <-2,1,-5.58>, <-2,1,-2>, <-2,0,-2> }
// 4 16 -2    0 -5.58 -0    0 -6    -0    1 -6    -2    1 -5.58
		triangle { <5.58,0,2>, <5.52,0,2.28>, <2,0,2> }
		triangle { <5.52,0,2.28>, <4.26,0,4.26>, <2,0,2> }
		triangle { <4.26,0,4.26>, <2.28,0,5.52>, <2,0,2> }
		triangle { <2.28,0,5.52>, <2,0,5.58>, <2,0,2> }
		triangle { <-5.58,0,2>, <-5.52,0,2.28>, <-2,0,2> }
		triangle { <-5.52,0,2.28>, <-4.26,0,4.26>, <-2,0,2> }
		triangle { <-4.26,0,4.26>, <-2.28,0,5.52>, <-2,0,2> }
		triangle { <-2.28,0,5.52>, <-2,0,5.58>, <-2,0,2> }
		triangle { <5.58,0,-2>, <5.52,0,-2.28>, <2,0,-2> }
		triangle { <5.52,0,-2.28>, <4.26,0,-4.26>, <2,0,-2> }
		triangle { <4.26,0,-4.26>, <2.28,0,-5.52>, <2,0,-2> }
		triangle { <2.28,0,-5.52>, <2,0,-5.58>, <2,0,-2> }
		triangle { <-5.58,0,-2>, <-5.52,0,-2.28>, <-2,0,-2> }
		triangle { <-5.52,0,-2.28>, <-4.26,0,-4.26>, <-2,0,-2> }
		triangle { <-4.26,0,-4.26>, <-2.28,0,-5.52>, <-2,0,-2> }
		triangle { <-2.28,0,-5.52>, <-2,0,-5.58>, <-2,0,-2> }
		triangle { <5.58,1,2>, <5.52,1,2.28>, <2,1,2> }
		triangle { <5.52,1,2.28>, <4.26,1,4.26>, <2,1,2> }
		triangle { <4.26,1,4.26>, <2.28,1,5.52>, <2,1,2> }
		triangle { <2.28,1,5.52>, <2,1,5.58>, <2,1,2> }
		triangle { <-5.58,1,2>, <-5.52,1,2.28>, <-2,1,2> }
		triangle { <-5.52,1,2.28>, <-4.26,1,4.26>, <-2,1,2> }
		triangle { <-4.26,1,4.26>, <-2.28,1,5.52>, <-2,1,2> }
		triangle { <-2.28,1,5.52>, <-2,1,5.58>, <-2,1,2> }
		triangle { <5.58,1,-2>, <5.52,1,-2.28>, <2,1,-2> }
		triangle { <5.52,1,-2.28>, <4.26,1,-4.26>, <2,1,-2> }
		triangle { <4.26,1,-4.26>, <2.28,1,-5.52>, <2,1,-2> }
		triangle { <2.28,1,-5.52>, <2,1,-5.58>, <2,1,-2> }
		triangle { <-5.58,1,-2>, <-5.52,1,-2.28>, <-2,1,-2> }
		triangle { <-5.52,1,-2.28>, <-4.26,1,-4.26>, <-2,1,-2> }
		triangle { <-4.26,1,-4.26>, <-2.28,1,-5.52>, <-2,1,-2> }
		triangle { <-2.28,1,-5.52>, <-2,1,-5.58>, <-2,1,-2> }
	}
}

#declare _32039_dot_dat = #if (QUAL = 0) box { <-10,-9,-29>, <10,9,10> } #else union {
// Technic Connector with Axlehole
// Name: 32039.dat
// Author: Fredrik Glckner
// Official LCad update 99-05
	object { axlehol5_dot_dat matrix <-1,0,0,0,0,19.5,0,1,0,0,0,-9.5> }
	mesh {
		triangle { <0,6,-6>, <0,6,-5>, <-1,5.79,-5> }
		triangle { <-1,5.79,-5>, <-1.2,5.75,-6>, <0,6,-6> }
		triangle { <-2,5.58,10>, <0,6,10>, <0,6,5> }
		triangle { <0,6,5>, <-1,5.79,5>, <-2,5.58,10> }
		triangle { <0,6,-6>, <0,6,-5>, <1,5.79,-5> }
		triangle { <1,5.79,-5>, <1.2,5.75,-6>, <0,6,-6> }
		triangle { <2,5.58,10>, <0,6,10>, <0,6,5> }
		triangle { <0,6,5>, <1,5.79,5>, <2,5.58,10> }
		triangle { <0,-6,-6>, <0,-6,-5>, <-1,-5.79,-5> }
		triangle { <-1,-5.79,-5>, <-1.2,-5.75,-6>, <0,-6,-6> }
		triangle { <-2,-5.58,10>, <0,-6,10>, <0,-6,5> }
		triangle { <0,-6,5>, <-1,-5.79,5>, <-2,-5.58,10> }
		triangle { <0,-6,-6>, <0,-6,-5>, <1,-5.79,-5> }
		triangle { <1,-5.79,-5>, <1.2,-5.75,-6>, <0,-6,-6> }
		triangle { <2,-5.58,10>, <0,-6,10>, <0,-6,5> }
		triangle { <0,-6,5>, <1,-5.79,5>, <2,-5.58,10> }
		triangle { <-1,5.79,-5>, <-1,5.79,5>, <-2,5.58,10> }
		triangle { <-1,5.79,-5>, <-2,5.58,10>, <-2,5.58,-6> }
		triangle { <-2,5.58,-6>, <-1.2,5.75,-6>, <-1,5.79,-5> }
		triangle { <1,5.79,-5>, <1,5.79,5>, <2,5.58,10> }
		triangle { <1,5.79,-5>, <2,5.58,10>, <2,5.58,-6> }
		triangle { <2,5.58,-6>, <1.2,5.75,-6>, <1,5.79,-5> }
		triangle { <-1,-5.79,-5>, <-1,-5.79,5>, <-2,-5.58,10> }
		triangle { <-1,-5.79,-5>, <-2,-5.58,10>, <-2,-5.58,-6> }
		triangle { <-2,-5.58,-6>, <-1.2,-5.75,-6>, <-1,-5.79,-5> }
		triangle { <1,-5.79,-5>, <1,-5.79,5>, <2,-5.58,10> }
		triangle { <1,-5.79,-5>, <2,-5.58,10>, <2,-5.58,-6> }
		triangle { <2,-5.58,-6>, <1.2,-5.75,-6>, <1,-5.79,-5> }
		triangle { <-2.68,6.47,-6>, <0,7,-6>, <0,7,-5> }
		triangle { <0,7,-5>, <-1,6.79,-5>, <-2.68,6.47,-6> }
		triangle { <-2.68,6.47,6>, <0,7,6>, <0,7,5> }
		triangle { <0,7,5>, <-1,6.79,5>, <-2.68,6.47,6> }
		triangle { <2.68,6.47,-6>, <0,7,-6>, <0,7,-5> }
		triangle { <0,7,-5>, <1,6.79,-5>, <2.68,6.47,-6> }
		triangle { <2.68,6.47,6>, <0,7,6>, <0,7,5> }
		triangle { <0,7,5>, <1,6.79,5>, <2.68,6.47,6> }
		triangle { <-2.68,-6.47,-6>, <0,-7,-6>, <0,-7,-5> }
		triangle { <0,-7,-5>, <-1,-6.79,-5>, <-2.68,-6.47,-6> }
		triangle { <-2.68,-6.47,6>, <0,-7,6>, <0,-7,5> }
		triangle { <0,-7,5>, <-1,-6.79,5>, <-2.68,-6.47,6> }
		triangle { <2.68,-6.47,-6>, <0,-7,-6>, <0,-7,-5> }
		triangle { <0,-7,-5>, <1,-6.79,-5>, <2.68,-6.47,-6> }
		triangle { <2.68,-6.47,6>, <0,-7,6>, <0,-7,5> }
		triangle { <0,-7,5>, <1,-6.79,5>, <2.68,-6.47,6> }
		triangle { <-2.68,6.47,-6>, <-1,6.79,-5>, <-1,6.79,5> }
		triangle { <-1,6.79,5>, <-2.68,6.47,6>, <-2.68,6.47,-6> }
		triangle { <2.68,6.47,-6>, <1,6.79,-5>, <1,6.79,5> }
		triangle { <1,6.79,5>, <2.68,6.47,6>, <2.68,6.47,-6> }
		triangle { <-2.68,-6.47,-6>, <-1,-6.79,-5>, <-1,-6.79,5> }
		triangle { <-1,-6.79,5>, <-2.68,-6.47,6>, <-2.68,-6.47,-6> }
		triangle { <2.68,-6.47,-6>, <1,-6.79,-5>, <1,-6.79,5> }
		triangle { <1,-6.79,5>, <2.68,-6.47,6>, <2.68,-6.47,-6> }
		triangle { <-1,5.79,-5>, <-1,6.79,-5>, <-1,6.79,5> }
		triangle { <-1,6.79,5>, <-1,5.79,5>, <-1,5.79,-5> }
		triangle { <1,5.79,-5>, <1,6.79,-5>, <1,6.79,5> }
		triangle { <1,6.79,5>, <1,5.79,5>, <1,5.79,-5> }
		triangle { <-1,-5.79,-5>, <-1,-6.79,-5>, <-1,-6.79,5> }
		triangle { <-1,-6.79,5>, <-1,-5.79,5>, <-1,-5.79,-5> }
		triangle { <1,-5.79,-5>, <1,-6.79,-5>, <1,-6.79,5> }
		triangle { <1,-6.79,5>, <1,-5.79,5>, <1,-5.79,-5> }
		triangle { <-1,5.79,-5>, <-1,6.79,-5>, <0,7,-5> }
		triangle { <0,7,-5>, <0,6,-5>, <-1,5.79,-5> }
		triangle { <-1,5.79,5>, <-1,6.79,5>, <0,7,5> }
		triangle { <0,7,5>, <0,6,5>, <-1,5.79,5> }
		triangle { <1,5.79,-5>, <1,6.79,-5>, <0,7,-5> }
		triangle { <0,7,-5>, <0,6,-5>, <1,5.79,-5> }
		triangle { <1,5.79,5>, <1,6.79,5>, <0,7,5> }
		triangle { <0,7,5>, <0,6,5>, <1,5.79,5> }
		triangle { <-1,-5.79,-5>, <-1,-6.79,-5>, <0,-7,-5> }
		triangle { <0,-7,-5>, <0,-6,-5>, <-1,-5.79,-5> }
		triangle { <-1,-5.79,5>, <-1,-6.79,5>, <0,-7,5> }
		triangle { <0,-7,5>, <0,-6,5>, <-1,-5.79,5> }
		triangle { <1,-5.79,-5>, <1,-6.79,-5>, <0,-7,-5> }
		triangle { <0,-7,-5>, <0,-6,-5>, <1,-5.79,-5> }
		triangle { <1,-5.79,5>, <1,-6.79,5>, <0,-7,5> }
		triangle { <0,-7,5>, <0,-6,5>, <1,-5.79,5> }
		triangle { <2.68,6.47,-6>, <4.95,4.95,-6>, <4.95,4.95,6> }
		triangle { <4.95,4.95,6>, <2.68,6.47,6>, <2.68,6.47,-6> }
		triangle { <4.95,4.95,-6>, <6.47,2.68,-6>, <6.47,2.68,6> }
		triangle { <6.47,2.68,6>, <4.95,4.95,6>, <4.95,4.95,-6> }
		triangle { <6.47,2.68,-6>, <7,0,-6>, <7,0,6> }
		triangle { <7,0,6>, <6.47,2.68,6>, <6.47,2.68,-6> }
		triangle { <7,0,-6>, <6.47,-2.68,-6>, <6.47,-2.68,6> }
		triangle { <6.47,-2.68,6>, <7,0,6>, <7,0,-6> }
		triangle { <6.47,-2.68,-6>, <4.95,-4.95,-6>, <4.95,-4.95,6> }
		triangle { <4.95,-4.95,6>, <6.47,-2.68,6>, <6.47,-2.68,-6> }
		triangle { <4.95,-4.95,-6>, <2.68,-6.47,-6>, <2.68,-6.47,6> }
		triangle { <2.68,-6.47,6>, <4.95,-4.95,6>, <4.95,-4.95,-6> }
		triangle { <-2.68,-6.47,-6>, <-4.95,-4.95,-6>, <-4.95,-4.95,6> }
		triangle { <-4.95,-4.95,6>, <-2.68,-6.47,6>, <-2.68,-6.47,-6> }
		triangle { <-4.95,-4.95,-6>, <-6.47,-2.68,-6>, <-6.47,-2.68,6> }
		triangle { <-6.47,-2.68,6>, <-4.95,-4.95,6>, <-4.95,-4.95,-6> }
		triangle { <-6.47,-2.68,-6>, <-7,0,-6>, <-7,0,6> }
		triangle { <-7,0,6>, <-6.47,-2.68,6>, <-6.47,-2.68,-6> }
		triangle { <-7,0,-6>, <-6.47,2.68,-6>, <-6.47,2.68,6> }
		triangle { <-6.47,2.68,6>, <-7,0,6>, <-7,0,-6> }
		triangle { <-6.47,2.68,-6>, <-4.95,4.95,-6>, <-4.95,4.95,6> }
		triangle { <-4.95,4.95,6>, <-6.47,2.68,6>, <-6.47,2.68,-6> }
		triangle { <-4.95,4.95,-6>, <-2.68,6.47,-6>, <-2.68,6.47,6> }
		triangle { <-2.68,6.47,6>, <-4.95,4.95,6>, <-4.95,4.95,-6> }
		triangle { <-2.3,5.54,10>, <-3.44,8.31,10>, <-4.55,7.57,10> }
		triangle { <-4.55,7.57,10>, <-4.24,4.24,10>, <-2.3,5.54,10> }
		triangle { <-5.54,2.3,10>, <-8.31,3.44,10>, <-7.57,4.55,10> }
		triangle { <-7.57,4.55,10>, <-4.24,4.24,10>, <-5.54,2.3,10> }
		triangle { <-4.55,7.57,10>, <-5.76,5.76,10>, <-4.24,4.24,10> }
		triangle { <-7.57,4.55,10>, <-5.76,5.76,10>, <-4.24,4.24,10> }
		triangle { <-2.3,-5.54,10>, <-3.44,-8.31,10>, <-4.55,-7.57,10> }
		triangle { <-4.55,-7.57,10>, <-4.24,-4.24,10>, <-2.3,-5.54,10> }
		triangle { <-5.54,-2.3,10>, <-8.31,-3.44,10>, <-7.57,-4.55,10> }
		triangle { <-7.57,-4.55,10>, <-4.24,-4.24,10>, <-5.54,-2.3,10> }
		triangle { <-4.55,-7.57,10>, <-5.76,-5.76,10>, <-4.24,-4.24,10> }
		triangle { <-7.57,-4.55,10>, <-5.76,-5.76,10>, <-4.24,-4.24,10> }
		triangle { <2.3,5.54,10>, <3.44,8.31,10>, <4.55,7.57,10> }
		triangle { <4.55,7.57,10>, <4.24,4.24,10>, <2.3,5.54,10> }
		triangle { <5.54,2.3,10>, <8.31,3.44,10>, <7.57,4.55,10> }
		triangle { <7.57,4.55,10>, <4.24,4.24,10>, <5.54,2.3,10> }
		triangle { <4.55,7.57,10>, <5.76,5.76,10>, <4.24,4.24,10> }
		triangle { <7.57,4.55,10>, <5.76,5.76,10>, <4.24,4.24,10> }
		triangle { <2.3,-5.54,10>, <3.44,-8.31,10>, <4.55,-7.57,10> }
		triangle { <4.55,-7.57,10>, <4.24,-4.24,10>, <2.3,-5.54,10> }
		triangle { <5.54,-2.3,10>, <8.31,-3.44,10>, <7.57,-4.55,10> }
		triangle { <7.57,-4.55,10>, <4.24,-4.24,10>, <5.54,-2.3,10> }
		triangle { <4.55,-7.57,10>, <5.76,-5.76,10>, <4.24,-4.24,10> }
		triangle { <7.57,-4.55,10>, <5.76,-5.76,10>, <4.24,-4.24,10> }
		triangle { <-2.68,6.47,6>, <-3.44,8.31,7>, <-4.55,7.57,7> }
		triangle { <-4.55,7.57,7>, <-4.95,4.95,6>, <-2.68,6.47,6> }
		triangle { <-6.47,2.68,6>, <-8.31,3.44,7>, <-7.57,4.55,7> }
		triangle { <-7.57,4.55,7>, <-4.95,4.95,6>, <-6.47,2.68,6> }
		triangle { <-4.55,7.57,7>, <-5.76,5.76,6.57>, <-4.95,4.95,6> }
		triangle { <-7.57,4.55,7>, <-5.76,5.76,6.57>, <-4.95,4.95,6> }
		triangle { <-2.68,-6.47,6>, <-3.44,-8.31,7>, <-4.55,-7.57,7> }
		triangle { <-4.55,-7.57,7>, <-4.95,-4.95,6>, <-2.68,-6.47,6> }
		triangle { <-6.47,-2.68,6>, <-8.31,-3.44,7>, <-7.57,-4.55,7> }
		triangle { <-7.57,-4.55,7>, <-4.95,-4.95,6>, <-6.47,-2.68,6> }
		triangle { <-4.55,-7.57,7>, <-5.76,-5.76,6.57>, <-4.95,-4.95,6> }
		triangle { <-7.57,-4.55,7>, <-5.76,-5.76,6.57>, <-4.95,-4.95,6> }
		triangle { <2.68,6.47,6>, <3.44,8.31,7>, <4.55,7.57,7> }
		triangle { <4.55,7.57,7>, <4.95,4.95,6>, <2.68,6.47,6> }
		triangle { <6.47,2.68,6>, <8.31,3.44,7>, <7.57,4.55,7> }
		triangle { <7.57,4.55,7>, <4.95,4.95,6>, <6.47,2.68,6> }
		triangle { <4.55,7.57,7>, <5.76,5.76,6.57>, <4.95,4.95,6> }
		triangle { <7.57,4.55,7>, <5.76,5.76,6.57>, <4.95,4.95,6> }
		triangle { <2.68,-6.47,6>, <3.44,-8.31,7>, <4.55,-7.57,7> }
		triangle { <4.55,-7.57,7>, <4.95,-4.95,6>, <2.68,-6.47,6> }
		triangle { <6.47,-2.68,6>, <8.31,-3.44,7>, <7.57,-4.55,7> }
		triangle { <7.57,-4.55,7>, <4.95,-4.95,6>, <6.47,-2.68,6> }
		triangle { <4.55,-7.57,7>, <5.76,-5.76,6.57>, <4.95,-4.95,6> }
		triangle { <7.57,-4.55,7>, <5.76,-5.76,6.57>, <4.95,-4.95,6> }
		triangle { <0,9,10>, <-3.44,8.31,10>, <-3.44,8.31,7> }
		triangle { <-3.44,8.31,7>, <0,9,7>, <0,9,10> }
		triangle { <-3.44,8.31,10>, <-4.55,7.57,10>, <-4.55,7.57,7> }
		triangle { <-4.55,7.57,7>, <-3.44,8.31,7>, <-3.44,8.31,10> }
		triangle { <-4.55,7.57,10>, <-5.76,5.76,10>, <-5.76,5.76,6.57> }
		triangle { <-5.76,5.76,6.57>, <-4.55,7.57,7>, <-4.55,7.57,10> }
		triangle { <-5.76,5.76,10>, <-7.57,4.55,10>, <-7.57,4.55,7> }
		triangle { <-7.57,4.55,7>, <-5.76,5.76,6.57>, <-5.76,5.76,10> }
		triangle { <-7.57,4.55,10>, <-8.31,3.44,10>, <-8.31,3.44,7> }
		triangle { <-8.31,3.44,7>, <-7.57,4.55,7>, <-7.57,4.55,10> }
		triangle { <-8.31,3.44,10>, <-9,0,10>, <-9,0,7> }
		triangle { <-9,0,7>, <-8.31,3.44,7>, <-8.31,3.44,10> }
		triangle { <0,-9,10>, <-3.44,-8.31,10>, <-3.44,-8.31,7> }
		triangle { <-3.44,-8.31,7>, <0,-9,7>, <0,-9,10> }
		triangle { <-3.44,-8.31,10>, <-4.55,-7.57,10>, <-4.55,-7.57,7> }
		triangle { <-4.55,-7.57,7>, <-3.44,-8.31,7>, <-3.44,-8.31,10> }
		triangle { <-4.55,-7.57,10>, <-5.76,-5.76,10>, <-5.76,-5.76,6.57> }
		triangle { <-5.76,-5.76,6.57>, <-4.55,-7.57,7>, <-4.55,-7.57,10> }
		triangle { <-5.76,-5.76,10>, <-7.57,-4.55,10>, <-7.57,-4.55,7> }
		triangle { <-7.57,-4.55,7>, <-5.76,-5.76,6.57>, <-5.76,-5.76,10> }
		triangle { <-7.57,-4.55,10>, <-8.31,-3.44,10>, <-8.31,-3.44,7> }
		triangle { <-8.31,-3.44,7>, <-7.57,-4.55,7>, <-7.57,-4.55,10> }
		triangle { <-8.31,-3.44,10>, <-9,0,10>, <-9,0,7> }
		triangle { <-9,0,7>, <-8.31,-3.44,7>, <-8.31,-3.44,10> }
		triangle { <0,9,10>, <3.44,8.31,10>, <3.44,8.31,7> }
		triangle { <3.44,8.31,7>, <0,9,7>, <0,9,10> }
		triangle { <3.44,8.31,10>, <4.55,7.57,10>, <4.55,7.57,7> }
		triangle { <4.55,7.57,7>, <3.44,8.31,7>, <3.44,8.31,10> }
		triangle { <4.55,7.57,10>, <5.76,5.76,10>, <5.76,5.76,6.57> }
		triangle { <5.76,5.76,6.57>, <4.55,7.57,7>, <4.55,7.57,10> }
		triangle { <5.76,5.76,10>, <7.57,4.55,10>, <7.57,4.55,7> }
		triangle { <7.57,4.55,7>, <5.76,5.76,6.57>, <5.76,5.76,10> }
		triangle { <7.57,4.55,10>, <8.31,3.44,10>, <8.31,3.44,7> }
		triangle { <8.31,3.44,7>, <7.57,4.55,7>, <7.57,4.55,10> }
		triangle { <8.31,3.44,10>, <9,0,10>, <9,0,7> }
		triangle { <9,0,7>, <8.31,3.44,7>, <8.31,3.44,10> }
		triangle { <0,-9,10>, <3.44,-8.31,10>, <3.44,-8.31,7> }
		triangle { <3.44,-8.31,7>, <0,-9,7>, <0,-9,10> }
		triangle { <3.44,-8.31,10>, <4.55,-7.57,10>, <4.55,-7.57,7> }
		triangle { <4.55,-7.57,7>, <3.44,-8.31,7>, <3.44,-8.31,10> }
		triangle { <4.55,-7.57,10>, <5.76,-5.76,10>, <5.76,-5.76,6.57> }
		triangle { <5.76,-5.76,6.57>, <4.55,-7.57,7>, <4.55,-7.57,10> }
		triangle { <5.76,-5.76,10>, <7.57,-4.55,10>, <7.57,-4.55,7> }
		triangle { <7.57,-4.55,7>, <5.76,-5.76,6.57>, <5.76,-5.76,10> }
		triangle { <7.57,-4.55,10>, <8.31,-3.44,10>, <8.31,-3.44,7> }
		triangle { <8.31,-3.44,7>, <7.57,-4.55,7>, <7.57,-4.55,10> }
		triangle { <8.31,-3.44,10>, <9,0,10>, <9,0,7> }
		triangle { <9,0,7>, <8.31,-3.44,7>, <8.31,-3.44,10> }
		triangle { <0,7,6>, <2.68,6.47,6>, <3.44,8.31,7> }
		triangle { <3.44,8.31,7>, <0,9,7>, <0,7,6> }
		triangle { <0,6,10>, <2.3,5.54,10>, <3.44,8.31,10> }
		triangle { <3.44,8.31,10>, <0,9,10>, <0,6,10> }
		triangle { <6.47,2.68,6>, <7,0,6>, <9,0,7> }
		triangle { <9,0,7>, <8.31,3.44,7>, <6.47,2.68,6> }
		triangle { <5.54,2.3,10>, <6,0,10>, <9,0,10> }
		triangle { <9,0,10>, <8.31,3.44,10>, <5.54,2.3,10> }
		triangle { <7,0,6>, <6.47,-2.68,6>, <8.31,-3.44,7> }
		triangle { <8.31,-3.44,7>, <9,0,7>, <7,0,6> }
		triangle { <6,0,10>, <5.54,-2.3,10>, <8.31,-3.44,10> }
		triangle { <8.31,-3.44,10>, <9,0,10>, <6,0,10> }
		triangle { <2.68,-6.47,6>, <0,-7,6>, <0,-9,7> }
		triangle { <0,-9,7>, <3.44,-8.31,7>, <2.68,-6.47,6> }
		triangle { <2.3,-5.54,10>, <0,-6,10>, <0,-9,10> }
		triangle { <0,-9,10>, <3.44,-8.31,10>, <2.3,-5.54,10> }
		triangle { <0,-7,6>, <-2.68,-6.47,6>, <-3.44,-8.31,7> }
		triangle { <-3.44,-8.31,7>, <0,-9,7>, <0,-7,6> }
		triangle { <0,-6,10>, <-2.3,-5.54,10>, <-3.44,-8.31,10> }
		triangle { <-3.44,-8.31,10>, <0,-9,10>, <0,-6,10> }
		triangle { <-6.47,-2.68,6>, <-7,0,6>, <-9,0,7> }
		triangle { <-9,0,7>, <-8.31,-3.44,7>, <-6.47,-2.68,6> }
		triangle { <-5.54,-2.3,10>, <-6,0,10>, <-9,0,10> }
		triangle { <-9,0,10>, <-8.31,-3.44,10>, <-5.54,-2.3,10> }
		triangle { <-7,0,6>, <-6.47,2.68,6>, <-8.31,3.44,7> }
		triangle { <-8.31,3.44,7>, <-9,0,7>, <-7,0,6> }
		triangle { <-6,0,10>, <-5.54,2.3,10>, <-8.31,3.44,10> }
		triangle { <-8.31,3.44,10>, <-9,0,10>, <-6,0,10> }
		triangle { <-2.68,6.47,6>, <0,7,6>, <0,9,7> }
		triangle { <0,9,7>, <-3.44,8.31,7>, <-2.68,6.47,6> }
		triangle { <-2.3,5.54,10>, <0,6,10>, <0,9,10> }
		triangle { <0,9,10>, <-3.44,8.31,10>, <-2.3,5.54,10> }
	}
	object { _4_dash_4ndis_dot_dat matrix <7,0,0,0,0,1,0,-7,0,0,0,-6> }
	mesh {
		triangle { <7,7,-6>, <7,-7,-6>, <9,-7,-6> }
		triangle { <9,-7,-6>, <9,7,-6>, <7,7,-6> }
		triangle { <-7,7,-6>, <-7,-7,-6>, <-9,-7,-6> }
		triangle { <-9,-7,-6>, <-9,7,-6>, <-7,7,-6> }
		triangle { <9,-7,-6>, <-9,-7,-6>, <-7,-7,-10> }
		triangle { <-7,-7,-10>, <7,-7,-10>, <9,-7,-6> }
		triangle { <9,7,-6>, <-9,7,-6>, <-7,7,-10> }
		triangle { <-7,7,-10>, <7,7,-10>, <9,7,-6> }
		triangle { <-9,-7,-14.59>, <-7,-7,-14.59>, <-7,-7,-10> }
		triangle { <-7,-7,-10>, <-9,-7,-6>, <-9,-7,-14.59> }
		triangle { <-9,7,-14.59>, <-7,7,-14.59>, <-7,7,-10> }
		triangle { <-7,7,-10>, <-9,7,-6>, <-9,7,-14.59> }
		triangle { <9,-7,-14.59>, <7,-7,-14.59>, <7,-7,-10> }
		triangle { <7,-7,-10>, <9,-7,-6>, <9,-7,-14.59> }
		triangle { <9,7,-14.59>, <7,7,-14.59>, <7,7,-10> }
		triangle { <7,7,-10>, <9,7,-6>, <9,7,-14.59> }
		triangle { <-9,7,-11>, <-9,7,-6>, <-9,-7,-6> }
		triangle { <-9,-7,-6>, <-9,-7,-11>, <-9,7,-11> }
		triangle { <9,7,-11>, <9,7,-6>, <9,-7,-6> }
		triangle { <9,-7,-6>, <9,-7,-11>, <9,7,-11> }
		triangle { <-7,7,-10>, <7,7,-10>, <7,-7,-10> }
		triangle { <7,-7,-10>, <-7,-7,-10>, <-7,7,-10> }
		triangle { <-7,-2,-10>, <7,-2,-10>, <7,-2,-13.29> }
		triangle { <7,-2,-13.29>, <-7,-2,-13.29>, <-7,-2,-10> }
		triangle { <-7,2,-10>, <7,2,-10>, <7,2,-13.29> }
		triangle { <7,2,-13.29>, <-7,2,-13.29>, <-7,2,-10> }
		triangle { <9,6.36,-13.64>, <9,7,-13>, <9,7,-14.59> }
		triangle { <9,6.36,-13.64>, <9,3.44,-11.68>, <9,7,-11.24> }
		triangle { <9,7,-11.24>, <9,7,-13>, <9,6.36,-13.64> }
		triangle { <9,3.44,-11.68>, <9,0,-11>, <9,7,-11> }
		triangle { <9,7,-11>, <9,7,-11.24>, <9,3.44,-11.68> }
		triangle { <9,0,-11>, <9,-3.44,-11.68>, <9,-7,-11.24> }
		triangle { <9,-7,-11.24>, <9,-7,-11>, <9,0,-11> }
		triangle { <9,-3.44,-11.68>, <9,-6.36,-13.64>, <9,-7,-13> }
		triangle { <9,-7,-13>, <9,-7,-11.24>, <9,-3.44,-11.68> }
		triangle { <9,-6.36,-13.64>, <9,-7,-13>, <9,-7,-14.59> }
		triangle { <-9,6.36,-13.64>, <-9,7,-13>, <-9,7,-14.59> }
		triangle { <-9,6.36,-13.64>, <-9,3.44,-11.68>, <-9,7,-11.24> }
		triangle { <-9,7,-11.24>, <-9,7,-13>, <-9,6.36,-13.64> }
		triangle { <-9,3.44,-11.68>, <-9,0,-11>, <-9,7,-11> }
		triangle { <-9,7,-11>, <-9,7,-11.24>, <-9,3.44,-11.68> }
		triangle { <-9,0,-11>, <-9,-3.44,-11.68>, <-9,-7,-11.24> }
		triangle { <-9,-7,-11.24>, <-9,-7,-11>, <-9,0,-11> }
		triangle { <-9,-3.44,-11.68>, <-9,-6.36,-13.64>, <-9,-7,-13> }
		triangle { <-9,-7,-13>, <-9,-7,-11.24>, <-9,-3.44,-11.68> }
		triangle { <-9,-6.36,-13.64>, <-9,-7,-13>, <-9,-7,-14.59> }
		triangle { <7,6.36,-13.64>, <7,7,-13>, <7,7,-14.59> }
		triangle { <7,6.36,-13.64>, <7,3.44,-11.68>, <7,7,-11.24> }
		triangle { <7,7,-11.24>, <7,7,-13>, <7,6.36,-13.64> }
		triangle { <7,3.44,-11.68>, <7,0,-11>, <7,7,-11> }
		triangle { <7,7,-11>, <7,7,-11.24>, <7,3.44,-11.68> }
		triangle { <7,0,-11>, <7,-3.44,-11.68>, <7,-7,-11.24> }
		triangle { <7,-7,-11.24>, <7,-7,-11>, <7,0,-11> }
		triangle { <7,-3.44,-11.68>, <7,-6.36,-13.64>, <7,-7,-13> }
		triangle { <7,-7,-13>, <7,-7,-11.24>, <7,-3.44,-11.68> }
		triangle { <7,-6.36,-13.64>, <7,-7,-13>, <7,-7,-14.59> }
		triangle { <-7,6.36,-13.64>, <-7,7,-13>, <-7,7,-14.59> }
		triangle { <-7,6.36,-13.64>, <-7,3.44,-11.68>, <-7,7,-11.24> }
		triangle { <-7,7,-11.24>, <-7,7,-13>, <-7,6.36,-13.64> }
		triangle { <-7,3.44,-11.68>, <-7,0,-11>, <-7,7,-11> }
		triangle { <-7,7,-11>, <-7,7,-11.24>, <-7,3.44,-11.68> }
		triangle { <-7,0,-11>, <-7,-3.44,-11.68>, <-7,-7,-11.24> }
		triangle { <-7,-7,-11.24>, <-7,-7,-11>, <-7,0,-11> }
		triangle { <-7,-3.44,-11.68>, <-7,-6.36,-13.64>, <-7,-7,-13> }
		triangle { <-7,-7,-13>, <-7,-7,-11.24>, <-7,-3.44,-11.68> }
		triangle { <-7,-6.36,-13.64>, <-7,-7,-13>, <-7,-7,-14.59> }
	}
	object { axlehol5_dot_dat matrix <0,0,1,20,0,0,0,1,0,-10,0,-20> }
	mesh {
		triangle { <-10,5.58,-18>, <-10,6,-20>, <-5,6,-20> }
		triangle { <-5,6,-20>, <-5,5.79,-19>, <-10,5.58,-18> }
		triangle { <6,6,-20>, <5,6,-20>, <5,5.79,-19> }
		triangle { <5,5.79,-19>, <6,5.75,-18.8>, <6,6,-20> }
		triangle { <-10,5.58,-22>, <-10,6,-20>, <-5,6,-20> }
		triangle { <-5,6,-20>, <-5,5.79,-21>, <-10,5.58,-22> }
		triangle { <6,6,-20>, <5,6,-20>, <5,5.79,-21> }
		triangle { <5,5.79,-21>, <6,5.75,-21.2>, <6,6,-20> }
		triangle { <-10,-5.58,-18>, <-10,-6,-20>, <-5,-6,-20> }
		triangle { <-5,-6,-20>, <-5,-5.79,-19>, <-10,-5.58,-18> }
		triangle { <6,-6,-20>, <5,-6,-20>, <5,-5.79,-19> }
		triangle { <5,-5.79,-19>, <6,-5.75,-18.8>, <6,-6,-20> }
		triangle { <-10,-5.58,-22>, <-10,-6,-20>, <-5,-6,-20> }
		triangle { <-5,-6,-20>, <-5,-5.79,-21>, <-10,-5.58,-22> }
		triangle { <6,-6,-20>, <5,-6,-20>, <5,-5.79,-21> }
		triangle { <5,-5.79,-21>, <6,-5.75,-21.2>, <6,-6,-20> }
		triangle { <-10,5.58,-18>, <-5,5.79,-19>, <5,5.79,-19> }
		triangle { <-10,5.58,-18>, <5,5.79,-19>, <6,5.75,-18.8> }
		triangle { <6,5.75,-18.8>, <6,5.58,-18>, <-10,5.58,-18> }
		triangle { <-10,5.58,-22>, <-5,5.79,-21>, <5,5.79,-21> }
		triangle { <-10,5.58,-22>, <5,5.79,-21>, <6,5.75,-21.2> }
		triangle { <6,5.75,-21.2>, <6,5.58,-22>, <-10,5.58,-22> }
		triangle { <-10,-5.58,-18>, <-5,-5.79,-19>, <5,-5.79,-19> }
		triangle { <-10,-5.58,-18>, <5,-5.79,-19>, <6,-5.75,-18.8> }
		triangle { <6,-5.75,-18.8>, <6,-5.58,-18>, <-10,-5.58,-18> }
		triangle { <-10,-5.58,-22>, <-5,-5.79,-21>, <5,-5.79,-21> }
		triangle { <-10,-5.58,-22>, <5,-5.79,-21>, <6,-5.75,-21.2> }
		triangle { <6,-5.75,-21.2>, <6,-5.58,-22>, <-10,-5.58,-22> }
		triangle { <-6,6.47,-17.32>, <-6,7,-20>, <-5,7,-20> }
		triangle { <-5,7,-20>, <-5,6.79,-19>, <-6,6.47,-17.32> }
		triangle { <6,6.47,-17.32>, <6,7,-20>, <5,7,-20> }
		triangle { <5,7,-20>, <5,6.79,-19>, <6,6.47,-17.32> }
		triangle { <-6,6.47,-22.68>, <-6,7,-20>, <-5,7,-20> }
		triangle { <-5,7,-20>, <-5,6.79,-21>, <-6,6.47,-22.68> }
		triangle { <6,6.47,-22.68>, <6,7,-20>, <5,7,-20> }
		triangle { <5,7,-20>, <5,6.79,-21>, <6,6.47,-22.68> }
		triangle { <-6,-6.47,-17.32>, <-6,-7,-20>, <-5,-7,-20> }
		triangle { <-5,-7,-20>, <-5,-6.79,-19>, <-6,-6.47,-17.32> }
		triangle { <6,-6.47,-17.32>, <6,-7,-20>, <5,-7,-20> }
		triangle { <5,-7,-20>, <5,-6.79,-19>, <6,-6.47,-17.32> }
		triangle { <-6,-6.47,-22.68>, <-6,-7,-20>, <-5,-7,-20> }
		triangle { <-5,-7,-20>, <-5,-6.79,-21>, <-6,-6.47,-22.68> }
		triangle { <6,-6.47,-22.68>, <6,-7,-20>, <5,-7,-20> }
		triangle { <5,-7,-20>, <5,-6.79,-21>, <6,-6.47,-22.68> }
		triangle { <-6,6.47,-17.32>, <-5,6.79,-19>, <5,6.79,-19> }
		triangle { <5,6.79,-19>, <6,6.47,-17.32>, <-6,6.47,-17.32> }
		triangle { <-6,6.47,-22.68>, <-5,6.79,-21>, <5,6.79,-21> }
		triangle { <5,6.79,-21>, <6,6.47,-22.68>, <-6,6.47,-22.68> }
		triangle { <-6,-6.47,-17.32>, <-5,-6.79,-19>, <5,-6.79,-19> }
		triangle { <5,-6.79,-19>, <6,-6.47,-17.32>, <-6,-6.47,-17.32> }
		triangle { <-6,-6.47,-22.68>, <-5,-6.79,-21>, <5,-6.79,-21> }
		triangle { <5,-6.79,-21>, <6,-6.47,-22.68>, <-6,-6.47,-22.68> }
		triangle { <-5,5.79,-19>, <-5,6.79,-19>, <5,6.79,-19> }
		triangle { <5,6.79,-19>, <5,5.79,-19>, <-5,5.79,-19> }
		triangle { <-5,5.79,-21>, <-5,6.79,-21>, <5,6.79,-21> }
		triangle { <5,6.79,-21>, <5,5.79,-21>, <-5,5.79,-21> }
		triangle { <-5,-5.79,-19>, <-5,-6.79,-19>, <5,-6.79,-19> }
		triangle { <5,-6.79,-19>, <5,-5.79,-19>, <-5,-5.79,-19> }
		triangle { <-5,-5.79,-21>, <-5,-6.79,-21>, <5,-6.79,-21> }
		triangle { <5,-6.79,-21>, <5,-5.79,-21>, <-5,-5.79,-21> }
		triangle { <-5,5.79,-19>, <-5,6.79,-19>, <-5,7,-20> }
		triangle { <-5,7,-20>, <-5,6,-20>, <-5,5.79,-19> }
		triangle { <5,5.79,-19>, <5,6.79,-19>, <5,7,-20> }
		triangle { <5,7,-20>, <5,6,-20>, <5,5.79,-19> }
		triangle { <-5,5.79,-21>, <-5,6.79,-21>, <-5,7,-20> }
		triangle { <-5,7,-20>, <-5,6,-20>, <-5,5.79,-21> }
		triangle { <5,5.79,-21>, <5,6.79,-21>, <5,7,-20> }
		triangle { <5,7,-20>, <5,6,-20>, <5,5.79,-21> }
		triangle { <-5,-5.79,-19>, <-5,-6.79,-19>, <-5,-7,-20> }
		triangle { <-5,-7,-20>, <-5,-6,-20>, <-5,-5.79,-19> }
		triangle { <5,-5.79,-19>, <5,-6.79,-19>, <5,-7,-20> }
		triangle { <5,-7,-20>, <5,-6,-20>, <5,-5.79,-19> }
		triangle { <-5,-5.79,-21>, <-5,-6.79,-21>, <-5,-7,-20> }
		triangle { <-5,-7,-20>, <-5,-6,-20>, <-5,-5.79,-21> }
		triangle { <5,-5.79,-21>, <5,-6.79,-21>, <5,-7,-20> }
		triangle { <5,-7,-20>, <5,-6,-20>, <5,-5.79,-21> }
		triangle { <-6,6.47,-22.68>, <-6,4.95,-24.95>, <6,4.95,-24.95> }
		triangle { <6,4.95,-24.95>, <6,6.47,-22.68>, <-6,6.47,-22.68> }
		triangle { <-6,4.95,-24.95>, <-6,2.68,-26.47>, <6,2.68,-26.47> }
		triangle { <6,2.68,-26.47>, <6,4.95,-24.95>, <-6,4.95,-24.95> }
		triangle { <-6,2.68,-26.47>, <-6,0,-27>, <6,0,-27> }
		triangle { <6,0,-27>, <6,2.68,-26.47>, <-6,2.68,-26.47> }
		triangle { <-6,0,-27>, <-6,-2.68,-26.47>, <6,-2.68,-26.47> }
		triangle { <6,-2.68,-26.47>, <6,0,-27>, <-6,0,-27> }
		triangle { <-6,-2.68,-26.47>, <-6,-4.95,-24.95>, <6,-4.95,-24.95> }
		triangle { <6,-4.95,-24.95>, <6,-2.68,-26.47>, <-6,-2.68,-26.47> }
		triangle { <-6,-4.95,-24.95>, <-6,-6.47,-22.68>, <6,-6.47,-22.68> }
		triangle { <6,-6.47,-22.68>, <6,-4.95,-24.95>, <-6,-4.95,-24.95> }
		triangle { <-6,-6.47,-17.32>, <-6,-4.95,-15.05>, <6,-4.95,-15.05> }
		triangle { <6,-4.95,-15.05>, <6,-6.47,-17.32>, <-6,-6.47,-17.32> }
		triangle { <-6,-4.95,-15.05>, <-6,-2.68,-13.53>, <6,-2.68,-13.53> }
		triangle { <6,-2.68,-13.53>, <6,-4.95,-15.05>, <-6,-4.95,-15.05> }
		triangle { <-6,-2.68,-13.53>, <-6,0,-13>, <6,0,-13> }
		triangle { <6,0,-13>, <6,-2.68,-13.53>, <-6,-2.68,-13.53> }
		triangle { <-6,0,-13>, <-6,2.68,-13.53>, <6,2.68,-13.53> }
		triangle { <6,2.68,-13.53>, <6,0,-13>, <-6,0,-13> }
		triangle { <-6,2.68,-13.53>, <-6,4.95,-15.05>, <6,4.95,-15.05> }
		triangle { <6,4.95,-15.05>, <6,2.68,-13.53>, <-6,2.68,-13.53> }
		triangle { <-6,4.95,-15.05>, <-6,6.47,-17.32>, <6,6.47,-17.32> }
		triangle { <6,6.47,-17.32>, <6,4.95,-15.05>, <-6,4.95,-15.05> }
	}
	object { _4_dash_4cyli_dot_dat matrix <0,0,9,3,0,0,0,9,0,-10,0,-20> }
	mesh {
		triangle { <-6,7,-20>, <-6,6.47,-22.68>, <-7,8.31,-23.44> }
		triangle { <-7,8.31,-23.44>, <-7,9,-20>, <-6,7,-20> }
		triangle { <-10,6,-20>, <-10,5.54,-22.3>, <-10,8.31,-23.44> }
		triangle { <-10,8.31,-23.44>, <-10,9,-20>, <-10,6,-20> }
		triangle { <-6,6.47,-22.68>, <-6,4.95,-24.95>, <-7,6.36,-26.36> }
		triangle { <-7,6.36,-26.36>, <-7,8.31,-23.44>, <-6,6.47,-22.68> }
		triangle { <-10,5.54,-22.3>, <-10,4.24,-24.24>, <-10,6.36,-26.36> }
		triangle { <-10,6.36,-26.36>, <-10,8.31,-23.44>, <-10,5.54,-22.3> }
		triangle { <-6,4.95,-24.95>, <-6,2.68,-26.47>, <-7,3.44,-28.31> }
		triangle { <-7,3.44,-28.31>, <-7,6.36,-26.36>, <-6,4.95,-24.95> }
		triangle { <-10,4.24,-24.24>, <-10,2.3,-25.54>, <-10,3.44,-28.31> }
		triangle { <-10,3.44,-28.31>, <-10,6.36,-26.36>, <-10,4.24,-24.24> }
		triangle { <-6,2.68,-26.47>, <-6,0,-27>, <-7,0,-29> }
		triangle { <-7,0,-29>, <-7,3.44,-28.31>, <-6,2.68,-26.47> }
		triangle { <-10,2.3,-25.54>, <-10,0,-26>, <-10,0,-29> }
		triangle { <-10,0,-29>, <-10,3.44,-28.31>, <-10,2.3,-25.54> }
		triangle { <-6,0,-27>, <-6,-2.68,-26.47>, <-7,-3.44,-28.31> }
		triangle { <-7,-3.44,-28.31>, <-7,0,-29>, <-6,0,-27> }
		triangle { <-10,0,-26>, <-10,-2.3,-25.54>, <-10,-3.44,-28.31> }
		triangle { <-10,-3.44,-28.31>, <-10,0,-29>, <-10,0,-26> }
		triangle { <-6,-2.68,-26.47>, <-6,-4.95,-24.95>, <-7,-6.36,-26.36> }
		triangle { <-7,-6.36,-26.36>, <-7,-3.44,-28.31>, <-6,-2.68,-26.47> }
		triangle { <-10,-2.3,-25.54>, <-10,-4.24,-24.24>, <-10,-6.36,-26.36> }
		triangle { <-10,-6.36,-26.36>, <-10,-3.44,-28.31>, <-10,-2.3,-25.54> }
		triangle { <-6,-4.95,-24.95>, <-6,-6.47,-22.68>, <-7,-8.31,-23.44> }
		triangle { <-7,-8.31,-23.44>, <-7,-6.36,-26.36>, <-6,-4.95,-24.95> }
		triangle { <-10,-4.24,-24.24>, <-10,-5.54,-22.3>, <-10,-8.31,-23.44> }
		triangle { <-10,-8.31,-23.44>, <-10,-6.36,-26.36>, <-10,-4.24,-24.24> }
		triangle { <-6,-6.47,-22.68>, <-6,-7,-20>, <-7,-9,-20> }
		triangle { <-7,-9,-20>, <-7,-8.31,-23.44>, <-6,-6.47,-22.68> }
		triangle { <-10,-5.54,-22.3>, <-10,-6,-20>, <-10,-9,-20> }
		triangle { <-10,-9,-20>, <-10,-8.31,-23.44>, <-10,-5.54,-22.3> }
		triangle { <-6,-7,-20>, <-6,-6.47,-17.32>, <-7,-8.31,-16.56> }
		triangle { <-7,-8.31,-16.56>, <-7,-9,-20>, <-6,-7,-20> }
		triangle { <-10,-6,-20>, <-10,-5.54,-17.7>, <-10,-8.31,-16.56> }
		triangle { <-10,-8.31,-16.56>, <-10,-9,-20>, <-10,-6,-20> }
		triangle { <-6,-6.47,-17.32>, <-6,-4.95,-15.05>, <-7,-6.36,-13.64> }
		triangle { <-7,-6.36,-13.64>, <-7,-8.31,-16.56>, <-6,-6.47,-17.32> }
		triangle { <-10,-5.54,-17.7>, <-10,-4.24,-15.76>, <-10,-6.36,-13.64> }
		triangle { <-10,-6.36,-13.64>, <-10,-8.31,-16.56>, <-10,-5.54,-17.7> }
		triangle { <-6,-4.95,-15.05>, <-6,-2.68,-13.53>, <-7,-3.44,-11.69> }
		triangle { <-7,-3.44,-11.69>, <-7,-6.36,-13.64>, <-6,-4.95,-15.05> }
		triangle { <-10,-4.24,-15.76>, <-10,-2.3,-14.46>, <-10,-3.44,-11.69> }
		triangle { <-10,-3.44,-11.69>, <-10,-6.36,-13.64>, <-10,-4.24,-15.76> }
		triangle { <-6,-2.68,-13.53>, <-6,0,-13>, <-7,0,-11> }
		triangle { <-7,0,-11>, <-7,-3.44,-11.69>, <-6,-2.68,-13.53> }
		triangle { <-10,-2.3,-14.46>, <-10,0,-14>, <-10,0,-11> }
		triangle { <-10,0,-11>, <-10,-3.44,-11.69>, <-10,-2.3,-14.46> }
		triangle { <-6,0,-13>, <-6,2.68,-13.53>, <-7,3.44,-11.69> }
		triangle { <-7,3.44,-11.69>, <-7,0,-11>, <-6,0,-13> }
		triangle { <-10,0,-14>, <-10,2.3,-14.46>, <-10,3.44,-11.69> }
		triangle { <-10,3.44,-11.69>, <-10,0,-11>, <-10,0,-14> }
		triangle { <-6,2.68,-13.53>, <-6,4.95,-15.05>, <-7,6.36,-13.64> }
		triangle { <-7,6.36,-13.64>, <-7,3.44,-11.69>, <-6,2.68,-13.53> }
		triangle { <-10,2.3,-14.46>, <-10,4.24,-15.76>, <-10,6.36,-13.64> }
		triangle { <-10,6.36,-13.64>, <-10,3.44,-11.69>, <-10,2.3,-14.46> }
		triangle { <-6,4.95,-15.05>, <-6,6.47,-17.32>, <-7,8.31,-16.56> }
		triangle { <-7,8.31,-16.56>, <-7,6.36,-13.64>, <-6,4.95,-15.05> }
		triangle { <-10,4.24,-15.76>, <-10,5.54,-17.7>, <-10,8.31,-16.56> }
		triangle { <-10,8.31,-16.56>, <-10,6.36,-13.64>, <-10,4.24,-15.76> }
		triangle { <-6,6.47,-17.32>, <-6,7,-20>, <-7,9,-20> }
		triangle { <-7,9,-20>, <-7,8.31,-16.56>, <-6,6.47,-17.32> }
		triangle { <-10,5.54,-17.7>, <-10,6,-20>, <-10,9,-20> }
		triangle { <-10,9,-20>, <-10,8.31,-16.56>, <-10,5.54,-17.7> }
		triangle { <6,5.75,-21.2>, <10,5.58,-22>, <10,6,-20> }
		triangle { <10,6,-20>, <6,6,-20>, <6,5.75,-21.2> }
		triangle { <6,5.75,-18.8>, <10,5.58,-18>, <10,6,-20> }
		triangle { <10,6,-20>, <6,6,-20>, <6,5.75,-18.8> }
		triangle { <6,-5.75,-21.2>, <10,-5.58,-22>, <10,-6,-20> }
		triangle { <10,-6,-20>, <6,-6,-20>, <6,-5.75,-21.2> }
		triangle { <6,-5.75,-18.8>, <10,-5.58,-18>, <10,-6,-20> }
		triangle { <10,-6,-20>, <6,-6,-20>, <6,-5.75,-18.8> }
		triangle { <10,5.58,-22>, <6,5.75,-21.2>, <6,5.58,-22> }
		triangle { <10,5.58,-18>, <6,5.75,-18.8>, <6,5.58,-18> }
		triangle { <10,-5.58,-22>, <6,-5.75,-21.2>, <6,-5.58,-22> }
		triangle { <10,-5.58,-18>, <6,-5.75,-18.8>, <6,-5.58,-18> }
	}
	object { _4_dash_4cyli_dot_dat matrix <0,0,-9,-3,0,0,0,9,0,10,0,-20> }
	mesh {
		triangle { <6,7,-20>, <6,6.47,-17.32>, <7,8.31,-16.56> }
		triangle { <7,8.31,-16.56>, <7,9,-20>, <6,7,-20> }
		triangle { <10,6,-20>, <10,5.54,-17.7>, <10,8.31,-16.56> }
		triangle { <10,8.31,-16.56>, <10,9,-20>, <10,6,-20> }
		triangle { <6,6.47,-17.32>, <6,4.95,-15.05>, <7,6.36,-13.64> }
		triangle { <7,6.36,-13.64>, <7,8.31,-16.56>, <6,6.47,-17.32> }
		triangle { <10,5.54,-17.7>, <10,4.24,-15.76>, <10,6.36,-13.64> }
		triangle { <10,6.36,-13.64>, <10,8.31,-16.56>, <10,5.54,-17.7> }
		triangle { <6,4.95,-15.05>, <6,2.68,-13.53>, <7,3.44,-11.69> }
		triangle { <7,3.44,-11.69>, <7,6.36,-13.64>, <6,4.95,-15.05> }
		triangle { <10,4.24,-15.76>, <10,2.3,-14.46>, <10,3.44,-11.69> }
		triangle { <10,3.44,-11.69>, <10,6.36,-13.64>, <10,4.24,-15.76> }
		triangle { <6,2.68,-13.53>, <6,0,-13>, <7,0,-11> }
		triangle { <7,0,-11>, <7,3.44,-11.69>, <6,2.68,-13.53> }
		triangle { <10,2.3,-14.46>, <10,0,-14>, <10,0,-11> }
		triangle { <10,0,-11>, <10,3.44,-11.69>, <10,2.3,-14.46> }
		triangle { <6,0,-13>, <6,-2.68,-13.53>, <7,-3.44,-11.69> }
		triangle { <7,-3.44,-11.69>, <7,0,-11>, <6,0,-13> }
		triangle { <10,0,-14>, <10,-2.3,-14.46>, <10,-3.44,-11.69> }
		triangle { <10,-3.44,-11.69>, <10,0,-11>, <10,0,-14> }
		triangle { <6,-2.68,-13.53>, <6,-4.95,-15.05>, <7,-6.36,-13.64> }
		triangle { <7,-6.36,-13.64>, <7,-3.44,-11.69>, <6,-2.68,-13.53> }
		triangle { <10,-2.3,-14.46>, <10,-4.24,-15.76>, <10,-6.36,-13.64> }
		triangle { <10,-6.36,-13.64>, <10,-3.44,-11.69>, <10,-2.3,-14.46> }
		triangle { <6,-4.95,-15.05>, <6,-6.47,-17.32>, <7,-8.31,-16.56> }
		triangle { <7,-8.31,-16.56>, <7,-6.36,-13.64>, <6,-4.95,-15.05> }
		triangle { <10,-4.24,-15.76>, <10,-5.54,-17.7>, <10,-8.31,-16.56> }
		triangle { <10,-8.31,-16.56>, <10,-6.36,-13.64>, <10,-4.24,-15.76> }
		triangle { <6,-6.47,-17.32>, <6,-7,-20>, <7,-9,-20> }
		triangle { <7,-9,-20>, <7,-8.31,-16.56>, <6,-6.47,-17.32> }
		triangle { <10,-5.54,-17.7>, <10,-6,-20>, <10,-9,-20> }
		triangle { <10,-9,-20>, <10,-8.31,-16.56>, <10,-5.54,-17.7> }
		triangle { <6,-7,-20>, <6,-6.47,-22.68>, <7,-8.31,-23.44> }
		triangle { <7,-8.31,-23.44>, <7,-9,-20>, <6,-7,-20> }
		triangle { <10,-6,-20>, <10,-5.54,-22.3>, <10,-8.31,-23.44> }
		triangle { <10,-8.31,-23.44>, <10,-9,-20>, <10,-6,-20> }
		triangle { <6,-6.47,-22.68>, <6,-4.95,-24.95>, <7,-6.36,-26.36> }
		triangle { <7,-6.36,-26.36>, <7,-8.31,-23.44>, <6,-6.47,-22.68> }
		triangle { <10,-5.54,-22.3>, <10,-4.24,-24.24>, <10,-6.36,-26.36> }
		triangle { <10,-6.36,-26.36>, <10,-8.31,-23.44>, <10,-5.54,-22.3> }
		triangle { <6,-4.95,-24.95>, <6,-2.68,-26.47>, <7,-3.44,-28.31> }
		triangle { <7,-3.44,-28.31>, <7,-6.36,-26.36>, <6,-4.95,-24.95> }
		triangle { <10,-4.24,-24.24>, <10,-2.3,-25.54>, <10,-3.44,-28.31> }
		triangle { <10,-3.44,-28.31>, <10,-6.36,-26.36>, <10,-4.24,-24.24> }
		triangle { <6,-2.68,-26.47>, <6,0,-27>, <7,0,-29> }
		triangle { <7,0,-29>, <7,-3.44,-28.31>, <6,-2.68,-26.47> }
		triangle { <10,-2.3,-25.54>, <10,0,-26>, <10,0,-29> }
		triangle { <10,0,-29>, <10,-3.44,-28.31>, <10,-2.3,-25.54> }
		triangle { <6,0,-27>, <6,2.68,-26.47>, <7,3.44,-28.31> }
		triangle { <7,3.44,-28.31>, <7,0,-29>, <6,0,-27> }
		triangle { <10,0,-26>, <10,2.3,-25.54>, <10,3.44,-28.31> }
		triangle { <10,3.44,-28.31>, <10,0,-29>, <10,0,-26> }
		triangle { <6,2.68,-26.47>, <6,4.95,-24.95>, <7,6.36,-26.36> }
		triangle { <7,6.36,-26.36>, <7,3.44,-28.31>, <6,2.68,-26.47> }
		triangle { <10,2.3,-25.54>, <10,4.24,-24.24>, <10,6.36,-26.36> }
		triangle { <10,6.36,-26.36>, <10,3.44,-28.31>, <10,2.3,-25.54> }
		triangle { <6,4.95,-24.95>, <6,6.47,-22.68>, <7,8.31,-23.44> }
		triangle { <7,8.31,-23.44>, <7,6.36,-26.36>, <6,4.95,-24.95> }
		triangle { <10,4.24,-24.24>, <10,5.54,-22.3>, <10,8.31,-23.44> }
		triangle { <10,8.31,-23.44>, <10,6.36,-26.36>, <10,4.24,-24.24> }
		triangle { <6,6.47,-22.68>, <6,7,-20>, <7,9,-20> }
		triangle { <7,9,-20>, <7,8.31,-23.44>, <6,6.47,-22.68> }
		triangle { <10,5.54,-22.3>, <10,6,-20>, <10,9,-20> }
		triangle { <10,9,-20>, <10,8.31,-23.44>, <10,5.54,-22.3> }
// 
	}
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3713)
		#include "lg_3713.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3713_dot_dat = #if (QUAL = 0) box { <-9,-9,-10>, <9,9,10> } #else object {
// Technic Bush
	lg_3713
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3713_dot_dat_clear = #if (QUAL = 0) box { <-9,-9,-10>, <9,9,10> } #else object {
// Technic Bush
	lg_3713_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3031)
		#include "lg_3031.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3031_dot_dat = #if (QUAL = 0) box { <-40,-4,-40>, <40,8,40> } #else object {
// Plate  4 x  4
	lg_3031
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3031_dot_dat_clear = #if (QUAL = 0) box { <-40,-4,-40>, <40,8,40> } #else object {
// Plate  4 x  4
	lg_3031_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_6259)
		#include "lg_6259.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _6259_dot_dat = #if (QUAL = 0) box { <-40,-4,-40>, <40,96,0> } #else object {
// Cylinder  2 x  4 x  4
	lg_6259
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _6259_dot_dat_clear = #if (QUAL = 0) box { <-40,-4,-40>, <40,96,0> } #else object {
// Cylinder  2 x  4 x  4
	lg_6259_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare s_slash_30208_dash_1_dot_dat = #if (QUAL = 0) box { <5.41,-39.645,-33.11>, <39.9,0,6.351> } #else object {
// ~Subpart Cylinder  4 X  4 Hemisphere Multifaceted
// Name: 30208-1.dat
// Author: John VanZwieten
// Official LCad update 99-02
	mesh {
		triangle { <10.69,-38.16,6.351>, <15.97,-36.675,3.175>, <15.97,-36.675,-3.175> }
		triangle { <15.97,-36.675,-3.175>, <10.69,-38.16,-6.351>, <10.69,-38.16,6.351> }
		triangle { <10.69,-38.16,6.351>, <5.41,-39.645,3.175>, <5.41,-39.645,-3.175> }
		triangle { <5.41,-39.645,-3.175>, <10.69,-38.16,-6.351>, <10.69,-38.16,6.351> }
// 
		triangle { <20.59,-33.86,6.351>, <25.265,-31,3.175>, <25.265,-31,-3.175> }
		triangle { <25.265,-31,-3.175>, <20.59,-33.86,-6.351>, <20.59,-33.86,6.351> }
		triangle { <20.59,-33.86,6.351>, <15.915,-36.72,3.175>, <15.915,-36.72,-3.175> }
		triangle { <15.915,-36.72,-3.175>, <20.59,-33.86,-6.351>, <20.59,-33.86,6.351> }
// 
		triangle { <28.96,-27.05,6.351>, <32.7,-23.035,3.175>, <32.7,-23.035,-3.175> }
		triangle { <32.7,-23.035,-3.175>, <28.96,-27.05,-6.351>, <28.96,-27.05,6.351> }
		triangle { <28.96,-27.05,6.351>, <25.22,-31.065,3.175>, <25.22,-31.065,-3.175> }
		triangle { <25.22,-31.065,-3.175>, <28.96,-27.05,-6.351>, <28.96,-27.05,6.351> }
// 
		triangle { <35.18,-18.23,6.351>, <37.71,-13.335,3.175>, <37.71,-13.335,-3.175> }
		triangle { <37.71,-13.335,-3.175>, <35.18,-18.23,-6.351>, <35.18,-18.23,6.351> }
		triangle { <35.18,-18.23,6.351>, <32.65,-23.125,3.175>, <32.65,-23.125,-3.175> }
		triangle { <32.65,-23.125,-3.175>, <35.18,-18.23,-6.351>, <35.18,-18.23,6.351> }
// 
		triangle { <38.8,-8.06,6.351>, <39.9,-2.67,3.175>, <39.9,-2.67,-3.175> }
		triangle { <39.9,-2.67,-3.175>, <38.8,-8.06,-6.351>, <38.8,-8.06,6.351> }
		triangle { <38.8,-8.06,6.351>, <37.7,-13.45,3.175>, <37.7,-13.45,-3.175> }
		triangle { <37.7,-13.45,-3.175>, <38.8,-8.06,-6.351>, <38.8,-8.06,6.351> }
// 
		triangle { <10.52,-38.16,-6.24>, <20.59,-33.86,-6.35>, <15.82,-33.86,-14.74> }
		triangle { <10.52,-38.16,-6.24>, <20.59,-33.86,-6.35>, <15.94,-36.7,-3.17> }
		triangle { <10.52,-38.16,-6.24>, <15.82,-33.86,-14.74>, <10.72,-36.7,-12.29> }
		triangle { <20.78,-32,-12>, <20.59,-33.86,-6.35>, <15.82,-33.86,-14.74> }
// 
		triangle { <20.59,-33.86,-6.35>, <28.96,-27.05,-6.35>, <24.74,-28,-14.28> }
		triangle { <20.59,-33.86,-6.35>, <28.96,-27.05,-6.35>, <25.22,-31.07,-3.17> }
		triangle { <20.59,-33.86,-6.35>, <24.74,-28,-14.28>, <20.78,-32,-12> }
		triangle { <28.96,-27.05,-6.35>, <24.74,-28,-14.28>, <27.92,-26.2,-11.57> }
		triangle { <15.82,-33.86,-14.74>, <20.01,-27.05,-22.02>, <24.74,-28,-14.28> }
		triangle { <15.82,-33.86,-14.74>, <20.01,-27.05,-22.02>, <15.37,-31.07,-20.37> }
		triangle { <15.82,-33.86,-14.74>, <24.74,-28,-14.28>, <20.78,-32,-12> }
		triangle { <20.01,-27.05,-22.02>, <24.74,-28,-14.28>, <23.98,-26.2,-18.4> }
		triangle { <24.74,-28,-14.28>, <29.97,-22.5,-13.98>, <27.09,-22.5,-18.97> }
		triangle { <24.74,-28,-14.28>, <23.98,-26.2,-18.4>, <27.09,-22.5,-18.97> }
		triangle { <24.74,-28,-14.28>, <29.97,-22.5,-13.98>, <27.92,-26.2,-11.57> }
// 
		triangle { <32.65,-23.13,-3.17>, <33.57,-18,-12.22>, <27.92,-26.2,-11.57> }
		triangle { <32.65,-23.13,-3.17>, <33.57,-18,-12.22>, <35.18,-18.23,-6.35> }
		triangle { <32.65,-23.13,-3.17>, <27.92,-26.2,-11.57>, <28.96,-27.05,-6.35> }
		triangle { <33.57,-18,-12.22>, <27.92,-26.2,-11.57>, <29.97,-22.5,-13.98> }
		triangle { <19.09,-23.13,-26.82>, <27.36,-18,-22.96>, <23.98,-26.2,-18.4> }
		triangle { <19.09,-23.13,-26.82>, <27.36,-18,-22.96>, <23.11,-18.23,-27.43> }
		triangle { <19.09,-23.13,-26.82>, <23.98,-26.2,-18.4>, <20.01,-27.05,-22.02> }
		triangle { <27.36,-18,-22.96>, <23.98,-26.2,-18.4>, <27.09,-22.5,-18.97> }
		triangle { <34.68,-12.6,-15.44>, <27.36,-18,-22.96>, <29.97,-22.5,-13.98> }
		triangle { <34.68,-12.6,-15.44>, <27.36,-18,-22.96>, <30.71,-12.6,-22.31> }
		triangle { <34.68,-12.6,-15.44>, <29.97,-22.5,-13.98>, <33.57,-18,-12.22> }
		triangle { <27.36,-18,-22.96>, <29.97,-22.5,-13.98>, <27.09,-22.5,-18.97> }
		triangle { <34.68,-12.6,-15.44>, <38.8,-8.06,-6.35>, <35.18,-18.23,-6.35> }
		triangle { <34.68,-12.6,-15.44>, <38.8,-8.06,-6.35>, <36.83,-8,-13.4> }
		triangle { <34.68,-12.6,-15.44>, <35.18,-18.23,-6.35>, <33.57,-18,-12.22> }
		triangle { <38.8,-8.06,-6.35>, <35.18,-18.23,-6.35>, <37.7,-13.45,-3.17> }
		triangle { <30.71,-12.6,-22.31>, <24.92,-8.06,-30.58>, <23.11,-18.23,-27.43> }
		triangle { <30.71,-12.6,-22.31>, <24.92,-8.06,-30.58>, <30.02,-8,-25.19> }
		triangle { <30.71,-12.6,-22.31>, <23.11,-18.23,-27.43>, <27.36,-18,-22.96> }
		triangle { <24.92,-8.06,-30.58>, <23.11,-18.23,-27.43>, <21.61,-13.45,-31.24> }
		triangle { <36.6,-2.6,-15.92>, <30.02,-8,-25.19>, <34.68,-12.6,-15.44> }
		triangle { <36.6,-2.6,-15.92>, <30.02,-8,-25.19>, <32.09,-2.6,-23.74> }
		triangle { <36.6,-2.6,-15.92>, <34.68,-12.6,-15.44>, <36.83,-8,-13.4> }
		triangle { <30.02,-8,-25.19>, <34.68,-12.6,-15.44>, <30.71,-12.6,-22.31> }
// 
		triangle { <36.6,-2.6,-15.92>, <37.22,0,-14.66>, <31.3,0,-24.9> }
		triangle { <31.3,0,-24.9>, <32.09,-2.6,-23.74>, <36.6,-2.6,-15.92> }
		triangle { <39.9,-2.67,-3.17>, <39.77,0,-3.83>, <39.77,0,3.83> }
		triangle { <39.77,0,3.83>, <39.9,-2.67,3.17>, <39.9,-2.67,-3.17> }
		triangle { <39.9,-2.67,-3.17>, <38.8,-8.06,-6.35>, <36.83,-8,-13.4> }
		triangle { <39.9,-2.67,-3.17>, <36.83,-8,-13.4>, <36.6,-2.6,-15.92> }
		triangle { <39.9,-2.67,-3.17>, <36.6,-2.6,-15.92>, <37.22,0,-14.66> }
		triangle { <39.9,-2.67,-3.17>, <39.77,0,-3.83>, <37.22,0,-14.66> }
		triangle { <24.92,-8.06,-30.58>, <30.02,-8,-25.19>, <32.09,-2.6,-23.74> }
		triangle { <24.92,-8.06,-30.58>, <22.71,-2.67,-33.11>, <32.09,-2.6,-23.74> }
		triangle { <22.71,-2.67,-33.11>, <32.09,-2.6,-23.74>, <31.3,0,-24.9> }
		triangle { <31.3,0,-24.9>, <22.71,-2.67,-33.11>, <23.2,0,-32.52> }
// 
	}
}
#end

#declare ring10_dot_dat = #if (version >= 3.1)
	disc { <0,0,0>, <0,1,0>, 11, 10 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 11 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 10 }
	}
#end

#declare _30208_dot_dat = #if (QUAL = 0) box { <-48.7557,-43.645,-51.268>, <48.7557,0,51.268> } #else union {
// Cylinder  4 x  4 Hemisphere Multifaceted
// Name: 30208.dat
// Author: John VanZwieten
// Official LCad update 99-02
	mesh {
		triangle { <-23.34,0,-31.68>, <-15.31,0,-36.96>, <-15.31,-4,-36.96> }
		triangle { <-15.31,-4,-36.96>, <-23.34,-4,-31.68>, <-23.34,0,-31.68> }
		triangle { <-15.31,0,-36.96>, <0,0,-40>, <0,-4,-40> }
		triangle { <0,-4,-40>, <-15.31,-4,-36.96>, <-15.31,0,-36.96> }
		triangle { <23.34,0,-31.68>, <15.31,0,-36.96>, <15.31,-4,-36.96> }
		triangle { <15.31,-4,-36.96>, <23.34,-4,-31.68>, <23.34,0,-31.68> }
		triangle { <15.31,0,-36.96>, <0,0,-40>, <0,-4,-40> }
		triangle { <0,-4,-40>, <15.31,-4,-36.96>, <15.31,0,-36.96> }
		triangle { <-22.17,0,-30.1>, <-14.54,0,-35.11>, <-14.54,-4,-35.11> }
		triangle { <-14.54,-4,-35.11>, <-22.17,-4,-30.1>, <-22.17,0,-30.1> }
		triangle { <-14.54,0,-35.11>, <0,0,-38>, <0,-4,-38> }
		triangle { <0,-4,-38>, <-14.54,-4,-35.11>, <-14.54,0,-35.11> }
		triangle { <22.17,0,-30.1>, <14.54,0,-35.11>, <14.54,-4,-35.11> }
		triangle { <14.54,-4,-35.11>, <22.17,-4,-30.1>, <22.17,0,-30.1> }
		triangle { <14.54,0,-35.11>, <0,0,-38>, <0,-4,-38> }
		triangle { <0,-4,-38>, <14.54,-4,-35.11>, <14.54,0,-35.11> }
		triangle { <-23.34,0,-31.68>, <-15.31,0,-36.96>, <-14.54,0,-35.11> }
		triangle { <-14.54,0,-35.11>, <-22.17,0,-30.1>, <-23.34,0,-31.68> }
		triangle { <-15.31,0,-36.96>, <0,0,-40>, <0,0,-38> }
		triangle { <0,0,-38>, <-14.54,0,-35.11>, <-15.31,0,-36.96> }
		triangle { <23.34,0,-31.68>, <15.31,0,-36.96>, <14.54,0,-35.11> }
		triangle { <14.54,0,-35.11>, <22.17,0,-30.1>, <23.34,0,-31.68> }
		triangle { <15.31,0,-36.96>, <0,0,-40>, <0,0,-38> }
		triangle { <0,0,-38>, <14.54,0,-35.11>, <15.31,0,-36.96> }
		triangle { <-23.34,0,-31.68>, <-23.34,-4,-31.68>, <-22.17,-4,-30.1> }
		triangle { <-22.17,-4,-30.1>, <-22.17,0,-30.1>, <-23.34,0,-31.68> }
		triangle { <23.34,0,-31.68>, <23.34,-4,-31.68>, <22.17,-4,-30.1> }
		triangle { <22.17,-4,-30.1>, <22.17,0,-30.1>, <23.34,0,-31.68> }
		triangle { <-31.68,0,23.34>, <-36.96,0,15.31>, <-36.96,-4,15.31> }
		triangle { <-36.96,-4,15.31>, <-31.68,-4,23.34>, <-31.68,0,23.34> }
		triangle { <-36.96,0,15.31>, <-40,0,0>, <-40,-4,0> }
		triangle { <-40,-4,0>, <-36.96,-4,15.31>, <-36.96,0,15.31> }
		triangle { <-31.68,0,-23.34>, <-36.96,0,-15.31>, <-36.96,-4,-15.31> }
		triangle { <-36.96,-4,-15.31>, <-31.68,-4,-23.34>, <-31.68,0,-23.34> }
		triangle { <-36.96,0,-15.31>, <-40,0,0>, <-40,-4,0> }
		triangle { <-40,-4,0>, <-36.96,-4,-15.31>, <-36.96,0,-15.31> }
		triangle { <-30.1,0,22.17>, <-35.11,0,14.54>, <-35.11,-4,14.54> }
		triangle { <-35.11,-4,14.54>, <-30.1,-4,22.17>, <-30.1,0,22.17> }
		triangle { <-35.11,0,14.54>, <-38,0,0>, <-38,-4,0> }
		triangle { <-38,-4,0>, <-35.11,-4,14.54>, <-35.11,0,14.54> }
		triangle { <-30.1,0,-22.17>, <-35.11,0,-14.54>, <-35.11,-4,-14.54> }
		triangle { <-35.11,-4,-14.54>, <-30.1,-4,-22.17>, <-30.1,0,-22.17> }
		triangle { <-35.11,0,-14.54>, <-38,0,0>, <-38,-4,0> }
		triangle { <-38,-4,0>, <-35.11,-4,-14.54>, <-35.11,0,-14.54> }
		triangle { <-31.68,0,23.34>, <-36.96,0,15.31>, <-35.11,0,14.54> }
		triangle { <-35.11,0,14.54>, <-30.1,0,22.17>, <-31.68,0,23.34> }
		triangle { <-36.96,0,15.31>, <-40,0,0>, <-38,0,0> }
		triangle { <-38,0,0>, <-35.11,0,14.54>, <-36.96,0,15.31> }
		triangle { <-31.68,0,-23.34>, <-36.96,0,-15.31>, <-35.11,0,-14.54> }
		triangle { <-35.11,0,-14.54>, <-30.1,0,-22.17>, <-31.68,0,-23.34> }
		triangle { <-36.96,0,-15.31>, <-40,0,0>, <-38,0,0> }
		triangle { <-38,0,0>, <-35.11,0,-14.54>, <-36.96,0,-15.31> }
		triangle { <-31.68,0,23.34>, <-31.68,-4,23.34>, <-30.1,-4,22.17> }
		triangle { <-30.1,-4,22.17>, <-30.1,0,22.17>, <-31.68,0,23.34> }
		triangle { <-31.68,0,-23.34>, <-31.68,-4,-23.34>, <-30.1,-4,-22.17> }
		triangle { <-30.1,-4,-22.17>, <-30.1,0,-22.17>, <-31.68,0,-23.34> }
// 
		triangle { <23.34,0,31.68>, <15.31,0,36.96>, <15.31,-4,36.96> }
		triangle { <15.31,-4,36.96>, <23.34,-4,31.68>, <23.34,0,31.68> }
		triangle { <15.31,0,36.96>, <0,0,40>, <0,-4,40> }
		triangle { <0,-4,40>, <15.31,-4,36.96>, <15.31,0,36.96> }
		triangle { <-23.34,0,31.68>, <-15.31,0,36.96>, <-15.31,-4,36.96> }
		triangle { <-15.31,-4,36.96>, <-23.34,-4,31.68>, <-23.34,0,31.68> }
		triangle { <-15.31,0,36.96>, <0,0,40>, <0,-4,40> }
		triangle { <0,-4,40>, <-15.31,-4,36.96>, <-15.31,0,36.96> }
		triangle { <22.17,0,30.1>, <14.54,0,35.11>, <14.54,-4,35.11> }
		triangle { <14.54,-4,35.11>, <22.17,-4,30.1>, <22.17,0,30.1> }
		triangle { <14.54,0,35.11>, <0,0,38>, <0,-4,38> }
		triangle { <0,-4,38>, <14.54,-4,35.11>, <14.54,0,35.11> }
		triangle { <-22.17,0,30.1>, <-14.54,0,35.11>, <-14.54,-4,35.11> }
		triangle { <-14.54,-4,35.11>, <-22.17,-4,30.1>, <-22.17,0,30.1> }
		triangle { <-14.54,0,35.11>, <0,0,38>, <0,-4,38> }
		triangle { <0,-4,38>, <-14.54,-4,35.11>, <-14.54,0,35.11> }
		triangle { <23.34,0,31.68>, <15.31,0,36.96>, <14.54,0,35.11> }
		triangle { <14.54,0,35.11>, <22.17,0,30.1>, <23.34,0,31.68> }
		triangle { <15.31,0,36.96>, <0,0,40>, <0,0,38> }
		triangle { <0,0,38>, <14.54,0,35.11>, <15.31,0,36.96> }
		triangle { <-23.34,0,31.68>, <-15.31,0,36.96>, <-14.54,0,35.11> }
		triangle { <-14.54,0,35.11>, <-22.17,0,30.1>, <-23.34,0,31.68> }
		triangle { <-15.31,0,36.96>, <0,0,40>, <0,0,38> }
		triangle { <0,0,38>, <-14.54,0,35.11>, <-15.31,0,36.96> }
		triangle { <23.34,0,31.68>, <23.34,-4,31.68>, <22.17,-4,30.1> }
		triangle { <22.17,-4,30.1>, <22.17,0,30.1>, <23.34,0,31.68> }
		triangle { <-23.34,0,31.68>, <-23.34,-4,31.68>, <-22.17,-4,30.1> }
		triangle { <-22.17,-4,30.1>, <-22.17,0,30.1>, <-23.34,0,31.68> }
// 
		triangle { <31.68,0,-23.34>, <36.96,0,-15.31>, <36.96,-4,-15.31> }
		triangle { <36.96,-4,-15.31>, <31.68,-4,-23.34>, <31.68,0,-23.34> }
		triangle { <36.96,0,-15.31>, <40,0,0>, <40,-4,0> }
		triangle { <40,-4,0>, <36.96,-4,-15.31>, <36.96,0,-15.31> }
		triangle { <31.68,0,23.34>, <36.96,0,15.31>, <36.96,-4,15.31> }
		triangle { <36.96,-4,15.31>, <31.68,-4,23.34>, <31.68,0,23.34> }
		triangle { <36.96,0,15.31>, <40,0,0>, <40,-4,0> }
		triangle { <40,-4,0>, <36.96,-4,15.31>, <36.96,0,15.31> }
		triangle { <30.1,0,-22.17>, <35.11,0,-14.54>, <35.11,-4,-14.54> }
		triangle { <35.11,-4,-14.54>, <30.1,-4,-22.17>, <30.1,0,-22.17> }
		triangle { <35.11,0,-14.54>, <38,0,0>, <38,-4,0> }
		triangle { <38,-4,0>, <35.11,-4,-14.54>, <35.11,0,-14.54> }
		triangle { <30.1,0,22.17>, <35.11,0,14.54>, <35.11,-4,14.54> }
		triangle { <35.11,-4,14.54>, <30.1,-4,22.17>, <30.1,0,22.17> }
		triangle { <35.11,0,14.54>, <38,0,0>, <38,-4,0> }
		triangle { <38,-4,0>, <35.11,-4,14.54>, <35.11,0,14.54> }
		triangle { <31.68,0,-23.34>, <36.96,0,-15.31>, <35.11,0,-14.54> }
		triangle { <35.11,0,-14.54>, <30.1,0,-22.17>, <31.68,0,-23.34> }
		triangle { <36.96,0,-15.31>, <40,0,0>, <38,0,0> }
		triangle { <38,0,0>, <35.11,0,-14.54>, <36.96,0,-15.31> }
		triangle { <31.68,0,23.34>, <36.96,0,15.31>, <35.11,0,14.54> }
		triangle { <35.11,0,14.54>, <30.1,0,22.17>, <31.68,0,23.34> }
		triangle { <36.96,0,15.31>, <40,0,0>, <38,0,0> }
		triangle { <38,0,0>, <35.11,0,14.54>, <36.96,0,15.31> }
		triangle { <31.68,0,-23.34>, <31.68,-4,-23.34>, <30.1,-4,-22.17> }
		triangle { <30.1,-4,-22.17>, <30.1,0,-22.17>, <31.68,0,-23.34> }
		triangle { <31.68,0,23.34>, <31.68,-4,23.34>, <30.1,-4,22.17> }
		triangle { <30.1,-4,22.17>, <30.1,0,22.17>, <31.68,0,23.34> }
// 
		triangle { <0,-43.63,6.351>, <5.5,-43.63,3.175>, <5.5,-43.63,-3.175> }
		triangle { <5.5,-43.63,-3.175>, <0,-43.63,-6.351>, <0,-43.63,6.351> }
		triangle { <0,-43.63,6.351>, <-5.5,-43.63,3.175>, <-5.5,-43.63,-3.175> }
		triangle { <-5.5,-43.63,-3.175>, <0,-43.63,-6.351>, <0,-43.63,6.351> }
// 
	}
	object { s_slash_30208_dash_1_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,-4,0> }
	object { s_slash_30208_dash_1_dot_dat matrix <0.5,0,-0.87,0,1,0,0.87,0,0.5,0,-4,0> }
	object { s_slash_30208_dash_1_dot_dat matrix <-0.5,0,-0.87,0,1,0,0.87,0,-0.5,0,-4,0> }
	object { s_slash_30208_dash_1_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,0,-4,0> }
	object { s_slash_30208_dash_1_dot_dat matrix <-0.5,0,0.87,0,1,0,-0.87,0,-0.5,0,-4,0> }
	object { s_slash_30208_dash_1_dot_dat matrix <0.5,0,0.87,0,1,0,-0.87,0,0.5,0,-4,0> }
	object { _4_dash_8sphe_dot_dat matrix <36,0,0,0,-36,0,0,0,-36,0,-4,0> }
	object { ring10_dot_dat matrix <3.6,0,0,0,1,0,0,0,3.6,0,-4,0> }
	object { ring10_dot_dat matrix <3.64,0,0,0,1,0,0,0,3.64,0,-4,0> }
// 
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3942)
		#include "lg_3942.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3942_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,48,20> } #else object {
// Cone  2 x  2 x  2
	lg_3942
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3942_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-20>, <20,48,20> } #else object {
// Cone  2 x  2 x  2
	lg_3942_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4589)
		#include "lg_4589.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4589_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else object {
// Cone  1 x  1
	lg_4589
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4589_dot_dat_clear = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else object {
// Cone  1 x  1
	lg_4589_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare ion__cannon_dot_dat = union {
// Lightblaster for senser
// Name: Ion_Cannon.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_4019_dot_dat
		matrix <0,1,0,-1,0,0,0,0,1,0.579,-0.18,-52>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_32014_dot_dat
		matrix <0,1,0,-1,0,0,0,0,1,0,-0.18,78>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3706_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,0,0,0>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3705_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,60,0.82,78>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3894_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,82,-10.18,38>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object {
		_4265a_dot_dat
		matrix <1-SW/18,0,0,0,1-SW/18,0,0,0,1-SW/10,0,0,0>
		matrix <0,0,1,0,1,0,-1,0,0,98,0.82,78>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_32039_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/18,0,0,0,1-SW/39,0,0,SW/-4.10526>
		matrix <0,0,-1,0,1,0,1,0,0,20,-0.18,-2>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_32073_dot_dat
		matrix <1-SW/100,0,0,0,1-SW/12,0,0,0,1-SW/12,0,0,0>
		matrix <-1,0,0,0,1,0,0,0,-1,65,0.82,-2>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_4265a_dot_dat
		matrix <1-SW/18,0,0,0,1-SW/18,0,0,0,1-SW/10,0,0,0>
		matrix <0,0,1,0,1,0,-1,0,0,98,0.82,-2>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3713_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,61,0.82,-2>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3713_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,61,0.82,78>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3031_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,92,-19.18,38>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}                   //EDIT: You may remove this block of code to increase speed dramatically
	object {
		_6259_dot_dat_clear
		matrix <1-0.01/80,0,0,0,1-0.01/100,0,0,0,1-0.01/40,0,0.01/2.17391,0.01/-2>
		matrix <0,0,1,0,1,0,-1,0,0,92,-116.18,38>
		#if (version >= 3.1) material #else texture #end { Color0x06AD5AD5 }
	}
	object {
		_6259_dot_dat_clear
		matrix <1-0.01/80,0,0,0,1-0.01/100,0,0,0,1-0.01/40,0,0.01/2.17391,0.01/-2>
		matrix <0,0,-1,0,1,0,1,0,0,91,-116.18,38>
		#if (version >= 3.1) material #else texture #end { Color0x06AD5AD5 }
	}             
	object {
		_30208_dot_dat
		matrix <1-SW/97.5114,0,0,0,1-SW/43.645,0,0,0,1-SW/102.536,0,SW/-2,0>
		matrix <0,0,-1,0,1,0,1,0,0,92,-116.18,38>
		#if (version >= 3.1) material #else texture #end { Color0x06AD5AD5 }
	}                   //EDIT
	object {
		_3942_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,92,-69.18,38>
		#if (version >= 3.1) material #else texture #end { Color1 }
	}
	object {
		_4589_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,92,-94,38>
		#if (version >= 3.1) material #else texture #end { Color1 }
	}   
	#if (clock>=0.36 & clock <0.41)     
          object {
          //light_source {<257,-24,168>, rgb <0,1,1> spotlight radius 100 falloff 200 point_at <-8,-20,126>}
          cone {
            <92, -116, 39>, 40    // Center and radius of one end
            <92, -500, 39>, 100    // Center and radius of other end
            open              // Removes end caps    
            material { LiteRay scale 20 rotate (clock-0.36)*(clock-0.36)/0.0025*720}
          } 
          }        
        #end  
	#if (clock<.36)
	        rotate int(clock*25)*-10*z
	        #if (mod(clock*100,4)-2<0)
	                rotate -5*(mod(clock*100,4)-2)*z  
	        #end
        #else
                rotate -90*z
        #end 
        #if (clock>=0.36 & clock<0.41)
                rotate 10-10*(clock-0.36)/0.5*z
        #end    
                
// 
}

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_2819)
		#include "lg_2819.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _2819_dot_dat = #if (QUAL = 0) box { <-32,-4,-32>, <32,24,32> } #else object {
// Technic Steering Wheel Small
	lg_2819
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _2819_dot_dat_clear = #if (QUAL = 0) box { <-32,-4,-32>, <32,24,32> } #else object {
// Technic Steering Wheel Small
	lg_2819_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare wheeldriveaxel_dot_dat = union {
// Wheel on Axel with Gear
// Name: WheelDriveAxel.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_4019_dot_dat
		matrix <0.965926,-0.258819,0,0.258819,0.965926,0,0,0,1,0,0,56>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3706_dot_dat
		matrix <0,0,-1,-0.965926,0.258819,0,0.258819,0.965926,0,0,0,4>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2819_dot_dat
		matrix <0,-1,0,0,0,1,-1,0,0,0,0,-61>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}                        
	#if (clock<.36)
	        rotate int(clock*25)*10*z
	        #if (mod(clock*100,4)-2<0)
	                rotate 5*(mod(clock*100,4)-2)*z  
	        #end
        #else
                rotate 90*z
        #end
// 
}

#declare double__gear__axel_dot_dat = union {
// An Axel with 2 Gears
// Name: Double_Gear_Axel.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_4019_dot_dat
		matrix <0,1,0,-1,0,0,0,0,1,0,0,61>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_4019_dot_dat
		matrix <0,-1,0,1,0,0,0,0,1,0,0,-43>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3706_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,0,0,9>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}  
	#if (clock<.36)
	        rotate int(clock*25)*-10*z
	        #if (mod(clock*100,4)-2<0)
	                rotate -5*(mod(clock*100,4)-2)*z  
	        #end
        #else
                rotate -90*z
        #end
// 
}

#declare single__gear__axel_dot_dat = union {
// Single Gear Axel
// Name: Single_Gear_Axel.dat
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_3706_dot_dat
		matrix <0,0,-1,-0.866025,0.5,0,0.5,0.866025,0,0,0,5>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_4019_dot_dat
		matrix <0.5,0.866025,0,-0.866025,0.5,0,0,0,1,0,0,-43>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_4265a_dot_dat
		matrix <1-SW/18,0,0,0,1-SW/18,0,0,0,1-SW/10,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,0,0,56.999>
		#if (version >= 3.1) material #else texture #end { Color7 }
	} 
	#if (clock<.36)
	        rotate int(clock*25)*10*z
	        #if (mod(clock*100,4)-2<0)
	                rotate 5*(mod(clock*100,4)-2)*z  
	        #end
        #else
                rotate 90*z
        #end
// 
}

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3008)
		#include "lg_3008.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3008_dot_dat = #if (QUAL = 0) box { <-80,-4,-10>, <80,24,10> } #else object {
// Brick  1 x  8
	lg_3008
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3008_dot_dat_clear = #if (QUAL = 0) box { <-80,-4,-10>, <80,24,10> } #else object {
// Brick  1 x  8
	lg_3008_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _3008p22_dot_dat = #if (QUAL = 0) box { <-80,-4,-10>, <80,24,10> } #else union {
// Brick  1 x  8 with Ferry Windows Pattern
// Name: 3008p22.dat
// Author: Lars C. Hassing lch@cci.dk 19980718
// Official LCad update 99-04
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-60,4,0> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <80,24,10>, <76,24,6>, <-76,24,6> }
		triangle { <-76,24,6>, <-80,24,10>, <80,24,10> }
		triangle { <-80,24,10>, <-76,24,6>, <-76,24,-6> }
		triangle { <-76,24,-6>, <-80,24,-10>, <-80,24,10> }
		triangle { <-80,24,-10>, <-76,24,-6>, <76,24,-6> }
		triangle { <76,24,-6>, <80,24,-10>, <-80,24,-10> }
		triangle { <80,24,-10>, <76,24,-6>, <76,24,6> }
		triangle { <76,24,6>, <80,24,10>, <80,24,-10> }
	}
	object { box4_dash_1_dot_dat matrix <80,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
	#end
	mesh {
		triangle { <-80,0,-10>, <80,0,-10>, <80,8,-10> }
		triangle { <80,8,-10>, <-80,8,-10>, <-80,0,-10> }
		triangle { <-80,16,-10>, <-80,8,-10>, <-77.56,8,-10> }
		triangle { <-77.56,8,-10>, <-77.56,16,-10>, <-80,16,-10> }
	}
	mesh {
		triangle { <-77.56,16,-10>, <-77.56,8,-10>, <-72.44,8,-10> }
		triangle { <-72.44,8,-10>, <-72.44,16,-10>, <-77.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-72.44,16,-10>, <-72.44,8,-10>, <-67.56,8,-10> }
		triangle { <-67.56,8,-10>, <-67.56,16,-10>, <-72.44,16,-10> }
	}
	mesh {
		triangle { <-67.56,16,-10>, <-67.56,8,-10>, <-62.44,8,-10> }
		triangle { <-62.44,8,-10>, <-62.44,16,-10>, <-67.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-62.44,16,-10>, <-62.44,8,-10>, <-57.56,8,-10> }
		triangle { <-57.56,8,-10>, <-57.56,16,-10>, <-62.44,16,-10> }
	}
	mesh {
		triangle { <-57.56,16,-10>, <-57.56,8,-10>, <-52.44,8,-10> }
		triangle { <-52.44,8,-10>, <-52.44,16,-10>, <-57.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-52.44,16,-10>, <-52.44,8,-10>, <-47.56,8,-10> }
		triangle { <-47.56,8,-10>, <-47.56,16,-10>, <-52.44,16,-10> }
	}
	mesh {
		triangle { <-47.56,16,-10>, <-47.56,8,-10>, <-42.44,8,-10> }
		triangle { <-42.44,8,-10>, <-42.44,16,-10>, <-47.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-42.44,16,-10>, <-42.44,8,-10>, <-37.56,8,-10> }
		triangle { <-37.56,8,-10>, <-37.56,16,-10>, <-42.44,16,-10> }
	}
	mesh {
		triangle { <-37.56,16,-10>, <-37.56,8,-10>, <-32.44,8,-10> }
		triangle { <-32.44,8,-10>, <-32.44,16,-10>, <-37.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-32.44,16,-10>, <-32.44,8,-10>, <-27.56,8,-10> }
		triangle { <-27.56,8,-10>, <-27.56,16,-10>, <-32.44,16,-10> }
	}
	mesh {
		triangle { <-27.56,16,-10>, <-27.56,8,-10>, <-22.44,8,-10> }
		triangle { <-22.44,8,-10>, <-22.44,16,-10>, <-27.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-22.44,16,-10>, <-22.44,8,-10>, <-17.56,8,-10> }
		triangle { <-17.56,8,-10>, <-17.56,16,-10>, <-22.44,16,-10> }
	}
	mesh {
		triangle { <-17.56,16,-10>, <-17.56,8,-10>, <-12.44,8,-10> }
		triangle { <-12.44,8,-10>, <-12.44,16,-10>, <-17.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-12.44,16,-10>, <-12.44,8,-10>, <-7.56,8,-10> }
		triangle { <-7.56,8,-10>, <-7.56,16,-10>, <-12.44,16,-10> }
	}
	mesh {
		triangle { <-7.56,16,-10>, <-7.56,8,-10>, <-2.44,8,-10> }
		triangle { <-2.44,8,-10>, <-2.44,16,-10>, <-7.56,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-2.44,16,-10>, <-2.44,8,-10>, <2.44,8,-10> }
		triangle { <2.44,8,-10>, <2.44,16,-10>, <-2.44,16,-10> }
	}
	mesh {
		triangle { <2.44,16,-10>, <2.44,8,-10>, <7.56,8,-10> }
		triangle { <7.56,8,-10>, <7.56,16,-10>, <2.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <7.56,16,-10>, <7.56,8,-10>, <12.44,8,-10> }
		triangle { <12.44,8,-10>, <12.44,16,-10>, <7.56,16,-10> }
	}
	mesh {
		triangle { <12.44,16,-10>, <12.44,8,-10>, <17.56,8,-10> }
		triangle { <17.56,8,-10>, <17.56,16,-10>, <12.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <17.56,16,-10>, <17.56,8,-10>, <22.44,8,-10> }
		triangle { <22.44,8,-10>, <22.44,16,-10>, <17.56,16,-10> }
	}
	mesh {
		triangle { <22.44,16,-10>, <22.44,8,-10>, <27.56,8,-10> }
		triangle { <27.56,8,-10>, <27.56,16,-10>, <22.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <27.56,16,-10>, <27.56,8,-10>, <32.44,8,-10> }
		triangle { <32.44,8,-10>, <32.44,16,-10>, <27.56,16,-10> }
	}
	mesh {
		triangle { <32.44,16,-10>, <32.44,8,-10>, <37.56,8,-10> }
		triangle { <37.56,8,-10>, <37.56,16,-10>, <32.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <37.56,16,-10>, <37.56,8,-10>, <42.44,8,-10> }
		triangle { <42.44,8,-10>, <42.44,16,-10>, <37.56,16,-10> }
	}
	mesh {
		triangle { <42.44,16,-10>, <42.44,8,-10>, <47.56,8,-10> }
		triangle { <47.56,8,-10>, <47.56,16,-10>, <42.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <47.56,16,-10>, <47.56,8,-10>, <52.44,8,-10> }
		triangle { <52.44,8,-10>, <52.44,16,-10>, <47.56,16,-10> }
	}
	mesh {
		triangle { <52.44,16,-10>, <52.44,8,-10>, <57.56,8,-10> }
		triangle { <57.56,8,-10>, <57.56,16,-10>, <52.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <57.56,16,-10>, <57.56,8,-10>, <62.44,8,-10> }
		triangle { <62.44,8,-10>, <62.44,16,-10>, <57.56,16,-10> }
	}
	mesh {
		triangle { <62.44,16,-10>, <62.44,8,-10>, <67.56,8,-10> }
		triangle { <67.56,8,-10>, <67.56,16,-10>, <62.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <67.56,16,-10>, <67.56,8,-10>, <72.44,8,-10> }
		triangle { <72.44,8,-10>, <72.44,16,-10>, <67.56,16,-10> }
	}
	mesh {
		triangle { <72.44,16,-10>, <72.44,8,-10>, <77.56,8,-10> }
		triangle { <77.56,8,-10>, <77.56,16,-10>, <72.44,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <77.56,16,-10>, <77.56,8,-10>, <80,8,-10> }
		triangle { <80,8,-10>, <80,16,-10>, <77.56,16,-10> }
		triangle { <-80,16,-10>, <80,16,-10>, <80,24,-10> }
		triangle { <80,24,-10>, <-80,24,-10>, <-80,16,-10> }
// 
	}
}
#end

#declare contrap_dot_ldr = union {
// Untitled
// Name: contrap.ldr
// Author: MLCad
// Unofficial Model
// ROTATION CENTER 37.3333 24 6.66667 1 "IonCannon"
// ROTATION CENTER 0 0 0 1 "SecondBase"
// ROTATION CONFIG 0 0
	object {
		_3702_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-22,14,-21>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object {
		_3702_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-21,14,39>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object {
		_3032_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-42,6,9>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object { ion__cannon_dot_dat matrix <1,0,0,0,1,0,0,0,1,38,25,9> #if (version >= 3.1) material #else texture #end { Color4 } }
	object { wheeldriveaxel_dot_dat matrix <1,0,0,0,1,0,0,0,1,-81,25,5> #if (version >= 3.1) material #else texture #end { Color4 } }
	object { double__gear__axel_dot_dat matrix <1,0,0,0,1,0,0,0,1,-42,24,0> #if (version >= 3.1) material #else texture #end { Color4 } }
	object { single__gear__axel_dot_dat matrix <-0.707107,-0.707107,0,0.707107,-0.707107,0,0,0,1,-1.999,23.998,0> #if (version >= 3.1) material #else texture #end { Color4 } }
	object {
		_3008_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,-20.999,37.586,39>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object {
		_3008p22_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-21,37.586,-21>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
// 
}

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_0971)
		#include "lg_0971.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _971_dot_dat = #if (QUAL = 0) box { <-19.5,-9,-11>, <-1.5,28,9> } #else object {
// Minifig Leg Right
	lg_0971
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _971_dot_dat_clear = #if (QUAL = 0) box { <-19.5,-9,-11>, <-1.5,28,9> } #else object {
// Minifig Leg Right
	lg_0971_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_0972)
		#include "lg_0972.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _972_dot_dat = #if (QUAL = 0) box { <1.5,-9,-11>, <19.5,28,9> } #else object {
// Minifig Leg Left
	lg_0972
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _972_dot_dat_clear = #if (QUAL = 0) box { <1.5,-9,-11>, <19.5,28,9> } #else object {
// Minifig Leg Left
	lg_0972_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_0970)
		#include "lg_0970.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _970_dot_dat = #if (QUAL = 0) box { <-18,-11,-10>, <18,21,10> } #else object {
// Minifig Hips
	lg_0970
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _970_dot_dat_clear = #if (QUAL = 0) box { <-18,-11,-10>, <18,21,10> } #else object {
// Minifig Hips
	lg_0970_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_0977)
		#include "lg_0977.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _977_dot_dat = #if (QUAL = 0) box { <-9.52,-4,-6>, <16,8,6> } #else object {
// Minifig Hand
	lg_0977
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _977_dot_dat_clear = #if (QUAL = 0) box { <-9.52,-4,-6>, <16,8,6> } #else object {
// Minifig Hand
	lg_0977_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_0975)
		#include "lg_0975.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _975_dot_dat = #if (QUAL = 0) box { <-29.532,-7.179,-13.695>, <-11.676,24.184,6.748> } #else object {
// Minifig Arm Right
	lg_0975
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _975_dot_dat_clear = #if (QUAL = 0) box { <-29.532,-7.179,-13.695>, <-11.676,24.184,6.748> } #else object {
// Minifig Arm Right
	lg_0975_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_0976)
		#include "lg_0976.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _976_dot_dat = #if (QUAL = 0) box { <11.676,-7.179,-13.695>, <29.532,24.184,6.748> } #else object {
// Minifig Arm Left
	lg_0976
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _976_dot_dat_clear = #if (QUAL = 0) box { <11.676,-7.179,-13.695>, <29.532,24.184,6.748> } #else object {
// Minifig Arm Left
	lg_0976_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _3_dash_4cyli_dot_dat = cylinder {
	<0,0,0>, <0,1,0>, 1 open
	clipped_by { plane { <1,0,-1>, O7071 } }
}

#declare s_slash_973s01_dot_dat = #if (QUAL = 0) box { <-19,-12,-10>, <19,32,10> } #else union {
// ~Subpart Minifig Torso without Front or Back
// Name: s\973s01.dat
// Author: Steve Bliss
// LDRAW_ORG Subpart UPDATE 2002-01
// used for plain & decorated torsos
// put front decoration pattern in Z = -10
// put back decoration pattern at Z = 10
// 1999-04-16 SEB Moved to s\973s01.dat; removed back area; updated comment code
// 1999-04-19 SEB Fixed internal surface error
// 2000-11-05 CWD Removed hard-coded neck mark; now required in main part
// 2002-02-05 CWD Corrected L3P -check warnings; bow-tie quads mainly
// Uncomment for front shell
// 4 16 -19 32 -10   19 32 -10  -19     29 -10   19     29 -10
// 4 16  19 29 -10  -19 29 -10  -14.345  2 -10   14.345  2 -10
// 4 16  12  0 -10  -12  0 -10  -14.345  2 -10   14.345  2 -10
// Uncomment for back shell
// 4 16  19 32  10  -19 32  10   19     29  10  -19     29  10
// 4 16 -19 29  10   19 29  10  -14.345  2  10   14.345  2  10
// 4 16 -12  0  10   12  0  10  -14.345  2  10   14.345  2  10
// Uncomment for neck mark
// 1 16 0 -4 0 4.243 0 -4.243 0 -8 0 -4.243 0 -4.243 1-4cyli.dat
	mesh {
		triangle { <-19,32,-10>, <19,32,-10>, <16,32,-6> }
		triangle { <16,32,-6>, <-16,32,-6>, <-19,32,-10> }
		triangle { <19,32,-10>, <19,32,10>, <16,32,6> }
		triangle { <16,32,6>, <16,32,-6>, <19,32,-10> }
		triangle { <19,32,10>, <-19,32,10>, <-16,32,6> }
		triangle { <-16,32,6>, <16,32,6>, <19,32,10> }
		triangle { <-19,32,10>, <-19,32,-10>, <-16,32,-6> }
		triangle { <-16,32,-6>, <-16,32,6>, <-19,32,10> }
		triangle { <-6.536,32,-6>, <-4,32,-3.464>, <-4,32,-6> }
		triangle { <6.536,32,-6>, <4,32,-3.464>, <4,32,-6> }
		triangle { <-6.536,32,6>, <-4,32,3.464>, <-4,32,6> }
		triangle { <6.536,32,6>, <4,32,3.464>, <4,32,6> }
		triangle { <-6.536,32,-6>, <-6.536,3,-6>, <-4,3,-3.464> }
		triangle { <-4,3,-3.464>, <-4,32,-3.464>, <-6.536,32,-6> }
		triangle { <-4,32,-3.464>, <-4,3,-3.464>, <-4,3,-6> }
		triangle { <-4,3,-6>, <-4,32,-6>, <-4,32,-3.464> }
		triangle { <6.536,32,-6>, <6.536,3,-6>, <4,3,-3.464> }
		triangle { <4,3,-3.464>, <4,32,-3.464>, <6.536,32,-6> }
		triangle { <4,32,-3.464>, <4,3,-3.464>, <4,3,-6> }
		triangle { <4,3,-6>, <4,32,-6>, <4,32,-3.464> }
		triangle { <-6.536,32,6>, <-6.536,3,6>, <-4,3,3.464> }
		triangle { <-4,3,3.464>, <-4,32,3.464>, <-6.536,32,6> }
		triangle { <-4,32,3.464>, <-4,3,3.464>, <-4,3,6> }
		triangle { <-4,3,6>, <-4,32,6>, <-4,32,3.464> }
		triangle { <6.536,32,6>, <6.536,3,6>, <4,3,3.464> }
		triangle { <4,3,3.464>, <4,32,3.464>, <6.536,32,6> }
		triangle { <4,32,3.464>, <4,3,3.464>, <4,3,6> }
		triangle { <4,3,6>, <4,32,6>, <4,32,3.464> }
		triangle { <-16,32,-6>, <-16,32,6>, <-16,23.37,6> }
		triangle { <-16,23.37,6>, <-16,23.37,-6>, <-16,32,-6> }
		triangle { <16,32,-6>, <16,32,6>, <16,23.37,6> }
		triangle { <16,23.37,6>, <16,23.37,-6>, <16,32,-6> }
		triangle { <-16,32,-6>, <16,32,-6>, <16,23.37,-6> }
		triangle { <16,23.37,-6>, <-16,23.37,-6>, <-16,32,-6> }
		triangle { <16,32,6>, <-16,32,6>, <-16,23.37,6> }
		triangle { <-16,23.37,6>, <16,23.37,6>, <16,32,6> }
		triangle { <-16,23.37,-6>, <-16,23.37,6>, <-14.408,14.146,6> }
		triangle { <-14.408,14.146,6>, <-14.408,14.146,-6>, <-16,23.37,-6> }
		triangle { <-12.708,4.296,-6>, <-12.708,4.296,6>, <-12.484,3,6> }
		triangle { <-12.484,3,6>, <-12.484,3,-6>, <-12.708,4.296,-6> }
		triangle { <16,23.37,-6>, <16,23.37,6>, <14.408,14.146,6> }
		triangle { <14.408,14.146,6>, <14.408,14.146,-6>, <16,23.37,-6> }
		triangle { <12.708,4.296,-6>, <12.708,4.296,6>, <12.484,3,6> }
		triangle { <12.484,3,6>, <12.484,3,-6>, <12.708,4.296,-6> }
		triangle { <-16,23.37,-6>, <16,23.37,-6>, <12.484,3,-6> }
		triangle { <12.484,3,-6>, <-12.484,3,-6>, <-16,23.37,-6> }
		triangle { <16,23.37,6>, <-16,23.37,6>, <-12.484,3,6> }
		triangle { <-12.484,3,6>, <12.484,3,6>, <16,23.37,6> }
		triangle { <-12.484,3,-6>, <12.484,3,-6>, <12.484,3,6> }
		triangle { <12.484,3,6>, <-12.484,3,6>, <-12.484,3,-6> }
		triangle { <19,32,-10>, <19,32,10>, <19,29,10> }
		triangle { <19,29,10>, <19,29,-10>, <19,32,-10> }
		triangle { <-19,32,10>, <-19,32,-10>, <-19,29,-10> }
		triangle { <-19,29,-10>, <-19,29,10>, <-19,32,10> }
		triangle { <-19,29,-10>, <-19,29,10>, <-16.378,13.806,10> }
		triangle { <-16.378,13.806,10>, <-16.378,13.806,-10>, <-19,29,-10> }
		triangle { <-14.678,3.956,-10>, <-14.678,3.956,10>, <-14.345,2,10> }
		triangle { <-14.345,2,10>, <-14.345,2,-10>, <-14.678,3.956,-10> }
		triangle { <-14.345,2,-10>, <-14.345,2,10>, <-14,0,8> }
		triangle { <-14,0,8>, <-14,0,-8>, <-14.345,2,-10> }
		triangle { <19,29,-10>, <19,29,10>, <16.378,13.806,10> }
		triangle { <16.378,13.806,10>, <16.378,13.806,-10>, <19,29,-10> }
		triangle { <14.678,3.956,-10>, <14.678,3.956,10>, <14.345,2,10> }
		triangle { <14.345,2,10>, <14.345,2,-10>, <14.678,3.956,-10> }
		triangle { <14.345,2,-10>, <14.345,2,10>, <14,0,8> }
		triangle { <14,0,8>, <14,0,-8>, <14.345,2,-10> }
		triangle { <-14,0,-8>, <-12,0,-10>, <-12,0,10> }
		triangle { <-12,0,10>, <-14,0,8>, <-14,0,-8> }
		triangle { <-12,0,-10>, <-12,0,10>, <12,0,10> }
		triangle { <12,0,10>, <12,0,-10>, <-12,0,-10> }
		triangle { <12,0,-10>, <12,0,10>, <14,0,8> }
		triangle { <14,0,8>, <14,0,-8>, <12,0,-10> }
		triangle { <-14.345,2,-10>, <-14,0,-8>, <-12,0,-10> }
		triangle { <14.345,2,-10>, <14,0,-8>, <12,0,-10> }
		triangle { <14.345,2,10>, <14,0,8>, <12,0,10> }
		triangle { <-14.345,2,10>, <-14,0,8>, <-12,0,10> }
	}
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,-4,0,0,0,6,0,0,0> }
	object { _3_dash_4cyli_dot_dat matrix <4.243,0,-4.243,0,-8,0,4.243,0,4.243,0,-4,0> }
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,-12,0> }
	object { _4_dash_4cyli_dot_dat matrix <0.85,4.925,0,1.97,-0.34,0,0,0,5,13.558,9.221,0> }
	mesh {
		triangle { <16.378,13.806,0>, <16.31,13.412,1.9>, <16.31,13.412,10> }
		triangle { <16.31,13.412,10>, <16.378,13.806,10>, <16.378,13.806,0> }
		triangle { <16.31,13.412,1.9>, <16.123,12.329,3.5>, <16.123,12.329,10> }
		triangle { <16.123,12.329,10>, <16.31,13.412,10>, <16.31,13.412,1.9> }
		triangle { <16.123,12.329,3.5>, <15.851,10.753,4.6>, <15.851,10.753,10> }
		triangle { <15.851,10.753,10>, <16.123,12.329,10>, <16.123,12.329,3.5> }
		triangle { <15.851,10.753,4.6>, <15.528,8.881,5>, <15.528,8.881,10> }
		triangle { <15.528,8.881,10>, <15.851,10.753,10>, <15.851,10.753,4.6> }
		triangle { <15.528,8.881,5>, <15.205,7.01,4.6>, <15.205,7.01,10> }
		triangle { <15.205,7.01,10>, <15.528,8.881,10>, <15.528,8.881,5> }
		triangle { <15.205,7.01,4.6>, <14.933,5.434,3.5>, <14.933,5.434,10> }
		triangle { <14.933,5.434,10>, <15.205,7.01,10>, <15.205,7.01,4.6> }
		triangle { <14.933,5.434,3.5>, <14.746,4.35,1.9>, <14.746,4.35,10> }
		triangle { <14.746,4.35,10>, <14.933,5.434,10>, <14.933,5.434,3.5> }
		triangle { <14.746,4.35,1.9>, <14.678,3.956,0>, <14.678,3.956,10> }
		triangle { <14.678,3.956,10>, <14.746,4.35,10>, <14.746,4.35,1.9> }
		triangle { <14.678,3.956,0>, <14.746,4.35,-1.9>, <14.746,4.35,-10> }
		triangle { <14.746,4.35,-10>, <14.678,3.956,-10>, <14.678,3.956,0> }
		triangle { <14.746,4.35,-1.9>, <14.933,5.434,-3.5>, <14.933,5.434,-10> }
		triangle { <14.933,5.434,-10>, <14.746,4.35,-10>, <14.746,4.35,-1.9> }
		triangle { <14.933,5.434,-3.5>, <15.205,7.01,-4.6>, <15.205,7.01,-10> }
		triangle { <15.205,7.01,-10>, <14.933,5.434,-10>, <14.933,5.434,-3.5> }
		triangle { <15.205,7.01,-4.6>, <15.528,8.881,-5>, <15.528,8.881,-10> }
		triangle { <15.528,8.881,-10>, <15.205,7.01,-10>, <15.205,7.01,-4.6> }
		triangle { <15.528,8.881,-5>, <15.851,10.753,-4.6>, <15.851,10.753,-10> }
		triangle { <15.851,10.753,-10>, <15.528,8.881,-10>, <15.528,8.881,-5> }
		triangle { <15.851,10.753,-4.6>, <16.123,12.329,-3.5>, <16.123,12.329,-10> }
		triangle { <16.123,12.329,-10>, <15.851,10.753,-10>, <15.851,10.753,-4.6> }
		triangle { <16.123,12.329,-3.5>, <16.31,13.412,-1.9>, <16.31,13.412,-10> }
		triangle { <16.31,13.412,-10>, <16.123,12.329,-10>, <16.123,12.329,-3.5> }
		triangle { <16.31,13.412,-1.9>, <16.378,13.806,0>, <16.378,13.806,-10> }
		triangle { <16.378,13.806,-10>, <16.31,13.412,-10>, <16.31,13.412,-1.9> }
		triangle { <14.408,14.146,0>, <14.34,13.752,1.9>, <14.34,13.752,6> }
		triangle { <14.34,13.752,6>, <14.408,14.146,6>, <14.408,14.146,0> }
		triangle { <14.34,13.752,1.9>, <14.153,12.669,3.5>, <14.153,12.669,6> }
		triangle { <14.153,12.669,6>, <14.34,13.752,6>, <14.34,13.752,1.9> }
		triangle { <14.153,12.669,3.5>, <13.881,11.093,4.6>, <13.881,11.093,6> }
		triangle { <13.881,11.093,6>, <14.153,12.669,6>, <14.153,12.669,3.5> }
		triangle { <13.881,11.093,4.6>, <13.558,9.221,5>, <13.558,9.221,6> }
		triangle { <13.558,9.221,6>, <13.881,11.093,6>, <13.881,11.093,4.6> }
		triangle { <13.558,9.221,5>, <13.235,7.35,4.6>, <13.235,7.35,6> }
		triangle { <13.235,7.35,6>, <13.558,9.221,6>, <13.558,9.221,5> }
		triangle { <13.235,7.35,4.6>, <12.963,5.774,3.5>, <12.963,5.774,6> }
		triangle { <12.963,5.774,6>, <13.235,7.35,6>, <13.235,7.35,4.6> }
		triangle { <12.963,5.774,3.5>, <12.776,4.69,1.9>, <12.776,4.69,6> }
		triangle { <12.776,4.69,6>, <12.963,5.774,6>, <12.963,5.774,3.5> }
		triangle { <12.776,4.69,1.9>, <12.708,4.296,0>, <12.708,4.296,6> }
		triangle { <12.708,4.296,6>, <12.776,4.69,6>, <12.776,4.69,1.9> }
		triangle { <12.708,4.296,0>, <12.776,4.69,-1.9>, <12.776,4.69,-6> }
		triangle { <12.776,4.69,-6>, <12.708,4.296,-6>, <12.708,4.296,0> }
		triangle { <12.776,4.69,-1.9>, <12.963,5.774,-3.5>, <12.963,5.774,-6> }
		triangle { <12.963,5.774,-6>, <12.776,4.69,-6>, <12.776,4.69,-1.9> }
		triangle { <12.963,5.774,-3.5>, <13.235,7.35,-4.6>, <13.235,7.35,-6> }
		triangle { <13.235,7.35,-6>, <12.963,5.774,-6>, <12.963,5.774,-3.5> }
		triangle { <13.235,7.35,-4.6>, <13.558,9.221,-5>, <13.558,9.221,-6> }
		triangle { <13.558,9.221,-6>, <13.235,7.35,-6>, <13.235,7.35,-4.6> }
		triangle { <13.558,9.221,-5>, <13.881,11.093,-4.6>, <13.881,11.093,-6> }
		triangle { <13.881,11.093,-6>, <13.558,9.221,-6>, <13.558,9.221,-5> }
		triangle { <13.881,11.093,-4.6>, <14.153,12.669,-3.5>, <14.153,12.669,-6> }
		triangle { <14.153,12.669,-6>, <13.881,11.093,-6>, <13.881,11.093,-4.6> }
		triangle { <14.153,12.669,-3.5>, <14.34,13.752,-1.9>, <14.34,13.752,-6> }
		triangle { <14.34,13.752,-6>, <14.153,12.669,-6>, <14.153,12.669,-3.5> }
		triangle { <14.34,13.752,-1.9>, <14.408,14.146,0>, <14.408,14.146,-6> }
		triangle { <14.408,14.146,-6>, <14.34,13.752,-6>, <14.34,13.752,-1.9> }
	}
	object { _4_dash_4cyli_dot_dat matrix <-0.85,4.925,0,-1.97,-0.34,0,0,0,5,-13.558,9.221,0> }
	mesh {
		triangle { <-16.378,13.806,0>, <-16.31,13.412,1.9>, <-16.31,13.412,10> }
		triangle { <-16.31,13.412,10>, <-16.378,13.806,10>, <-16.378,13.806,0> }
		triangle { <-16.31,13.412,1.9>, <-16.123,12.329,3.5>, <-16.123,12.329,10> }
		triangle { <-16.123,12.329,10>, <-16.31,13.412,10>, <-16.31,13.412,1.9> }
		triangle { <-16.123,12.329,3.5>, <-15.851,10.753,4.6>, <-15.851,10.753,10> }
		triangle { <-15.851,10.753,10>, <-16.123,12.329,10>, <-16.123,12.329,3.5> }
		triangle { <-15.851,10.753,4.6>, <-15.528,8.881,5>, <-15.528,8.881,10> }
		triangle { <-15.528,8.881,10>, <-15.851,10.753,10>, <-15.851,10.753,4.6> }
		triangle { <-15.528,8.881,5>, <-15.205,7.01,4.6>, <-15.205,7.01,10> }
		triangle { <-15.205,7.01,10>, <-15.528,8.881,10>, <-15.528,8.881,5> }
		triangle { <-15.205,7.01,4.6>, <-14.933,5.434,3.5>, <-14.933,5.434,10> }
		triangle { <-14.933,5.434,10>, <-15.205,7.01,10>, <-15.205,7.01,4.6> }
		triangle { <-14.933,5.434,3.5>, <-14.746,4.35,1.9>, <-14.746,4.35,10> }
		triangle { <-14.746,4.35,10>, <-14.933,5.434,10>, <-14.933,5.434,3.5> }
		triangle { <-14.746,4.35,1.9>, <-14.678,3.956,0>, <-14.678,3.956,10> }
		triangle { <-14.678,3.956,10>, <-14.746,4.35,10>, <-14.746,4.35,1.9> }
		triangle { <-14.678,3.956,0>, <-14.746,4.35,-1.9>, <-14.746,4.35,-10> }
		triangle { <-14.746,4.35,-10>, <-14.678,3.956,-10>, <-14.678,3.956,0> }
		triangle { <-14.746,4.35,-1.9>, <-14.933,5.434,-3.5>, <-14.933,5.434,-10> }
		triangle { <-14.933,5.434,-10>, <-14.746,4.35,-10>, <-14.746,4.35,-1.9> }
		triangle { <-14.933,5.434,-3.5>, <-15.205,7.01,-4.6>, <-15.205,7.01,-10> }
		triangle { <-15.205,7.01,-10>, <-14.933,5.434,-10>, <-14.933,5.434,-3.5> }
		triangle { <-15.205,7.01,-4.6>, <-15.528,8.881,-5>, <-15.528,8.881,-10> }
		triangle { <-15.528,8.881,-10>, <-15.205,7.01,-10>, <-15.205,7.01,-4.6> }
		triangle { <-15.528,8.881,-5>, <-15.851,10.753,-4.6>, <-15.851,10.753,-10> }
		triangle { <-15.851,10.753,-10>, <-15.528,8.881,-10>, <-15.528,8.881,-5> }
		triangle { <-15.851,10.753,-4.6>, <-16.123,12.329,-3.5>, <-16.123,12.329,-10> }
		triangle { <-16.123,12.329,-10>, <-15.851,10.753,-10>, <-15.851,10.753,-4.6> }
		triangle { <-16.123,12.329,-3.5>, <-16.31,13.412,-1.9>, <-16.31,13.412,-10> }
		triangle { <-16.31,13.412,-10>, <-16.123,12.329,-10>, <-16.123,12.329,-3.5> }
		triangle { <-16.31,13.412,-1.9>, <-16.378,13.806,0>, <-16.378,13.806,-10> }
		triangle { <-16.378,13.806,-10>, <-16.31,13.412,-10>, <-16.31,13.412,-1.9> }
		triangle { <-14.408,14.146,0>, <-14.34,13.752,1.9>, <-14.34,13.752,6> }
		triangle { <-14.34,13.752,6>, <-14.408,14.146,6>, <-14.408,14.146,0> }
		triangle { <-14.34,13.752,1.9>, <-14.153,12.669,3.5>, <-14.153,12.669,6> }
		triangle { <-14.153,12.669,6>, <-14.34,13.752,6>, <-14.34,13.752,1.9> }
		triangle { <-14.153,12.669,3.5>, <-13.881,11.093,4.6>, <-13.881,11.093,6> }
		triangle { <-13.881,11.093,6>, <-14.153,12.669,6>, <-14.153,12.669,3.5> }
		triangle { <-13.881,11.093,4.6>, <-13.558,9.221,5>, <-13.558,9.221,6> }
		triangle { <-13.558,9.221,6>, <-13.881,11.093,6>, <-13.881,11.093,4.6> }
		triangle { <-13.558,9.221,5>, <-13.235,7.35,4.6>, <-13.235,7.35,6> }
		triangle { <-13.235,7.35,6>, <-13.558,9.221,6>, <-13.558,9.221,5> }
		triangle { <-13.235,7.35,4.6>, <-12.963,5.774,3.5>, <-12.963,5.774,6> }
		triangle { <-12.963,5.774,6>, <-13.235,7.35,6>, <-13.235,7.35,4.6> }
		triangle { <-12.963,5.774,3.5>, <-12.776,4.69,1.9>, <-12.776,4.69,6> }
		triangle { <-12.776,4.69,6>, <-12.963,5.774,6>, <-12.963,5.774,3.5> }
		triangle { <-12.776,4.69,1.9>, <-12.708,4.296,0>, <-12.708,4.296,6> }
		triangle { <-12.708,4.296,6>, <-12.776,4.69,6>, <-12.776,4.69,1.9> }
		triangle { <-12.708,4.296,0>, <-12.776,4.69,-1.9>, <-12.776,4.69,-6> }
		triangle { <-12.776,4.69,-6>, <-12.708,4.296,-6>, <-12.708,4.296,0> }
		triangle { <-12.776,4.69,-1.9>, <-12.963,5.774,-3.5>, <-12.963,5.774,-6> }
		triangle { <-12.963,5.774,-6>, <-12.776,4.69,-6>, <-12.776,4.69,-1.9> }
		triangle { <-12.963,5.774,-3.5>, <-13.235,7.35,-4.6>, <-13.235,7.35,-6> }
		triangle { <-13.235,7.35,-6>, <-12.963,5.774,-6>, <-12.963,5.774,-3.5> }
		triangle { <-13.235,7.35,-4.6>, <-13.558,9.221,-5>, <-13.558,9.221,-6> }
		triangle { <-13.558,9.221,-6>, <-13.235,7.35,-6>, <-13.235,7.35,-4.6> }
		triangle { <-13.558,9.221,-5>, <-13.881,11.093,-4.6>, <-13.881,11.093,-6> }
		triangle { <-13.881,11.093,-6>, <-13.558,9.221,-6>, <-13.558,9.221,-5> }
		triangle { <-13.881,11.093,-4.6>, <-14.153,12.669,-3.5>, <-14.153,12.669,-6> }
		triangle { <-14.153,12.669,-6>, <-13.881,11.093,-6>, <-13.881,11.093,-4.6> }
		triangle { <-14.153,12.669,-3.5>, <-14.34,13.752,-1.9>, <-14.34,13.752,-6> }
		triangle { <-14.34,13.752,-6>, <-14.153,12.669,-6>, <-14.153,12.669,-3.5> }
		triangle { <-14.34,13.752,-1.9>, <-14.408,14.146,0>, <-14.408,14.146,-6> }
		triangle { <-14.408,14.146,-6>, <-14.34,13.752,-6>, <-14.34,13.752,-1.9> }
// 
	}
}
#end

#declare _973p17_dot_dat = #if (QUAL = 0) box { <-19,-12,-10>, <19,32,10> } #else union {
// Minifig Torso with Red V-Neck and Buttons Pattern
// Name: 973p17.dat
// Author: Chris Dee (chris_w_dee@hotmail.com)
// LDRAW_ORG Part UPDATE 2001-01
// 1999-04-16 SEB Updated 973-4t.dat to s\973s01.dat; added back surface
// 2000-11-05 CWD Moved neck mark from s\973s01.dat
// CW compliant
	object { s_slash_973s01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
// Plain back
	mesh {
		triangle { <-19,32,10>, <19,32,10>, <19,29,10> }
		triangle { <19,29,10>, <-19,29,10>, <-19,32,10> }
		triangle { <19,29,10>, <-19,29,10>, <-14.345,2,10> }
		triangle { <-14.345,2,10>, <14.345,2,10>, <19,29,10> }
		triangle { <12,0,10>, <-12,0,10>, <-14.345,2,10> }
		triangle { <-14.345,2,10>, <14.345,2,10>, <12,0,10> }
// Neck mark
	}
	object { _1_dash_4cyli_dot_dat matrix <4.243,0,-4.243,0,-8,0,-4.243,0,-4.243,0,-4,0> #if (version >= 3.1) material #else texture #end { Color15 } }
// Decoration
	mesh {
		triangle { <-12,0,-10>, <-8,0,-10>, <-7.36,2,-10> }
		triangle { <-7.36,2,-10>, <-14.345,2,-10>, <-12,0,-10> }
		triangle { <8,0,-10>, <12,0,-10>, <14.345,2,-10> }
		triangle { <14.345,2,-10>, <7.36,2,-10>, <8,0,-10> }
		triangle { <-14.345,2,-10>, <-7.36,2,-10>, <-6.4,5,-10> }
		triangle { <-6.4,5,-10>, <-14.862,5,-10>, <-14.345,2,-10> }
		triangle { <7.36,2,-10>, <14.345,2,-10>, <14.862,5,-10> }
		triangle { <14.862,5,-10>, <6.4,5,-10>, <7.36,2,-10> }
		triangle { <-14.862,5,-10>, <-6.4,5,-10>, <-3.6,10,-10> }
		triangle { <-3.6,10,-10>, <-15.724,10,-10>, <-14.862,5,-10> }
		triangle { <6.4,5,-10>, <14.862,5,-10>, <15.724,10,-10> }
		triangle { <15.724,10,-10>, <3.6,10,-10>, <6.4,5,-10> }
		triangle { <-15.724,10,-10>, <-3.6,10,-10>, <0,16,-10> }
		triangle { <0,16,-10>, <-16.759,16,-10>, <-15.724,10,-10> }
		triangle { <3.6,10,-10>, <15.724,10,-10>, <16.759,16,-10> }
		triangle { <16.759,16,-10>, <0,16,-10>, <3.6,10,-10> }
		triangle { <-16.759,16,-10>, <-1.4,16,-10>, <-1.4,29,-10> }
		triangle { <-1.4,29,-10>, <-19,29,-10>, <-16.759,16,-10> }
		triangle { <1.4,16,-10>, <16.759,16,-10>, <19,29,-10> }
		triangle { <19,29,-10>, <1.4,29,-10>, <1.4,16,-10> }
		triangle { <-19,29,-10>, <19,29,-10>, <19,32,-10> }
		triangle { <19,32,-10>, <-19,32,-10>, <-19,29,-10> }
		triangle { <-1.4,16,-10>, <1.4,16,-10>, <1.4,17.6,-10> }
		triangle { <1.4,17.6,-10>, <-1.4,17.6,-10>, <-1.4,16,-10> }
		triangle { <-1.4,20.4,-10>, <1.4,20.4,-10>, <1.4,21.6,-10> }
		triangle { <1.4,21.6,-10>, <-1.4,21.6,-10>, <-1.4,20.4,-10> }
		triangle { <-1.4,24.4,-10>, <1.4,24.4,-10>, <1.4,25.6,-10> }
		triangle { <1.4,25.6,-10>, <-1.4,25.6,-10>, <-1.4,24.4,-10> }
		triangle { <-1.4,28.4,-10>, <1.4,28.4,-10>, <1.4,29,-10> }
		triangle { <1.4,29,-10>, <-1.4,29,-10>, <-1.4,28.4,-10> }
	}
	mesh {
		triangle { <-8,0,-10>, <8,0,-10>, <6.4,5,-10> }
		triangle { <6.4,5,-10>, <-6.4,5,-10>, <-8,0,-10> }
		triangle { <-6.4,5,-10>, <6.4,5,-10>, <3.6,10,-10> }
		triangle { <3.6,10,-10>, <-3.6,10,-10>, <-6.4,5,-10> }
		triangle { <-3.6,10,-10>, <3.6,10,-10>, <0,16,-10> }
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
	object { _4_dash_4disc_dot_dat matrix <1.3,0,0,0,0,1,0,-1.3,0,0,19,-10> #if (version >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1.3,0,0,0,0,1,0,-1.3,0,0,19,-10> }
	object { _4_dash_4disc_dot_dat matrix <1.3,0,0,0,0,1,0,-1.3,0,0,23,-10> #if (version >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1.3,0,0,0,0,1,0,-1.3,0,0,23,-10> }
	object { _4_dash_4disc_dot_dat matrix <1.3,0,0,0,0,1,0,-1.3,0,0,27,-10> #if (version >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1.3,0,0,0,0,1,0,-1.3,0,0,27,-10> }
// 
}
#end

#declare s_slash_3626bs01_dot_dat = #if (QUAL = 0) box { <-13,-4,-11.536>, <13,24,13> } #else union {
// ~Subpart Minifig Head - Faceless Subpart (hollow stud)
// Name: 3626bs01.dat
// Author: Tore Eriksson
// Modified March-1999 by : Chris Dee (chris_w_dee@hotmail.com)
// Official LCad update 99-02
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,0,0> }
	object { ring2_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,20,0,0,0,6,0,4,0> }
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,24,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,3,0,0,0,8,0,21,0> }
	mesh {
		triangle { <-3.061,0,7.391>, <-4.415,1.172,10.658>, <-8.157,1.172,8.157> }
		triangle { <-8.157,1.172,8.157>, <-5.657,0,5.657>, <-3.061,0,7.391> }
		triangle { <-5.657,0,5.657>, <-8.157,1.172,8.157>, <-10.658,1.172,4.415> }
		triangle { <-10.658,1.172,4.415>, <-7.391,0,3.061>, <-5.657,0,5.657> }
		triangle { <-7.391,0,3.061>, <-10.658,1.172,4.415>, <-11.536,1.172,0> }
		triangle { <-11.536,1.172,0>, <-8,0,0>, <-7.391,0,3.061> }
		triangle { <-8,0,0>, <-11.536,1.172,0>, <-10.658,1.172,-4.415> }
		triangle { <-10.658,1.172,-4.415>, <-7.391,0,-3.061>, <-8,0,0> }
		triangle { <-7.391,0,-3.061>, <-10.658,1.172,-4.415>, <-8.157,1.172,-8.157> }
		triangle { <-8.157,1.172,-8.157>, <-5.657,0,-5.657>, <-7.391,0,-3.061> }
		triangle { <-5.657,0,-5.657>, <-8.157,1.172,-8.157>, <-4.415,1.172,-10.658> }
		triangle { <-4.415,1.172,-10.658>, <-3.061,0,-7.391>, <-5.657,0,-5.657> }
		triangle { <-3.061,0,-7.391>, <-4.415,1.172,-10.658>, <0,1.172,-11.536> }
		triangle { <0,1.172,-11.536>, <0,0,-8>, <-3.061,0,-7.391> }
		triangle { <0,0,-8>, <0,1.172,-11.536>, <4.415,1.172,-10.658> }
		triangle { <4.415,1.172,-10.658>, <3.061,0,-7.391>, <0,0,-8> }
		triangle { <3.061,0,-7.391>, <4.415,1.172,-10.658>, <8.157,1.172,-8.157> }
		triangle { <8.157,1.172,-8.157>, <5.657,0,-5.657>, <3.061,0,-7.391> }
		triangle { <5.657,0,-5.657>, <8.157,1.172,-8.157>, <10.658,1.172,-4.415> }
		triangle { <10.658,1.172,-4.415>, <7.391,0,-3.061>, <5.657,0,-5.657> }
		triangle { <7.391,0,-3.061>, <10.658,1.172,-4.415>, <11.536,1.172,0> }
		triangle { <11.536,1.172,0>, <8,0,0>, <7.391,0,-3.061> }
		triangle { <8,0,0>, <11.536,1.172,0>, <10.658,1.172,4.415> }
		triangle { <10.658,1.172,4.415>, <7.391,0,3.061>, <8,0,0> }
		triangle { <7.391,0,3.061>, <10.658,1.172,4.415>, <8.157,1.172,8.157> }
		triangle { <8.157,1.172,8.157>, <5.657,0,5.657>, <7.391,0,3.061> }
		triangle { <5.657,0,5.657>, <8.157,1.172,8.157>, <4.415,1.172,10.658> }
		triangle { <4.415,1.172,10.658>, <3.061,0,7.391>, <5.657,0,5.657> }
		triangle { <3.061,0,7.391>, <4.415,1.172,10.658>, <0,1.172,11.536> }
		triangle { <0,1.172,11.536>, <0,0,8>, <3.061,0,7.391> }
		triangle { <0,0,8>, <0,1.172,11.536>, <-4.415,1.172,10.658> }
		triangle { <-4.415,1.172,10.658>, <-3.061,0,7.391>, <0,0,8> }
		triangle { <-4.415,1.172,10.658>, <-4.975,4,12.01>, <-9.192,4,9.192> }
		triangle { <-9.192,4,9.192>, <-8.157,1.172,8.157>, <-4.415,1.172,10.658> }
		triangle { <-8.157,1.172,8.157>, <-9.192,4,9.192>, <-12.01,4,4.975> }
		triangle { <-12.01,4,4.975>, <-10.658,1.172,4.415>, <-8.157,1.172,8.157> }
		triangle { <-10.658,1.172,4.415>, <-12.01,4,4.975>, <-13,4,0> }
		triangle { <-13,4,0>, <-11.536,1.172,0>, <-10.658,1.172,4.415> }
		triangle { <11.536,1.172,0>, <13,4,0>, <12.01,4,4.975> }
		triangle { <12.01,4,4.975>, <10.658,1.172,4.415>, <11.536,1.172,0> }
		triangle { <10.658,1.172,4.415>, <12.01,4,4.975>, <9.192,4,9.192> }
		triangle { <9.192,4,9.192>, <8.157,1.172,8.157>, <10.658,1.172,4.415> }
		triangle { <8.157,1.172,8.157>, <9.192,4,9.192>, <4.975,4,12.01> }
		triangle { <4.975,4,12.01>, <4.415,1.172,10.658>, <8.157,1.172,8.157> }
		triangle { <4.415,1.172,10.658>, <4.975,4,12.01>, <0,4,13> }
		triangle { <0,4,13>, <0,1.172,11.536>, <4.415,1.172,10.658> }
		triangle { <0,1.172,11.536>, <0,4,13>, <-4.975,4,12.01> }
		triangle { <-4.975,4,12.01>, <-4.415,1.172,10.658>, <0,1.172,11.536> }
	}
	object { _2_dash_4cyli_dot_dat matrix <13,0,0,0,13,0,0,0,13,0,4,0> }
	mesh {
		triangle { <-3.061,21,7.391>, <-4.415,19.828,10.658>, <-8.157,19.828,8.157> }
		triangle { <-8.157,19.828,8.157>, <-5.657,21,5.657>, <-3.061,21,7.391> }
		triangle { <-5.657,21,5.657>, <-8.157,19.828,8.157>, <-10.658,19.828,4.415> }
		triangle { <-10.658,19.828,4.415>, <-7.391,21,3.061>, <-5.657,21,5.657> }
		triangle { <-7.391,21,3.061>, <-10.658,19.828,4.415>, <-11.536,19.828,0> }
		triangle { <-11.536,19.828,0>, <-8,21,0>, <-7.391,21,3.061> }
		triangle { <-8,21,0>, <-11.536,19.828,0>, <-10.658,19.828,-4.415> }
		triangle { <-10.658,19.828,-4.415>, <-7.391,21,-3.061>, <-8,21,0> }
		triangle { <-7.391,21,-3.061>, <-10.658,19.828,-4.415>, <-8.157,19.828,-8.157> }
		triangle { <-8.157,19.828,-8.157>, <-5.657,21,-5.657>, <-7.391,21,-3.061> }
		triangle { <-5.657,21,-5.657>, <-8.157,19.828,-8.157>, <-4.415,19.828,-10.658> }
		triangle { <-4.415,19.828,-10.658>, <-3.061,21,-7.391>, <-5.657,21,-5.657> }
		triangle { <-3.061,21,-7.391>, <-4.415,19.828,-10.658>, <0,19.828,-11.536> }
		triangle { <0,19.828,-11.536>, <0,21,-8>, <-3.061,21,-7.391> }
		triangle { <0,21,-8>, <0,19.828,-11.536>, <4.415,19.828,-10.658> }
		triangle { <4.415,19.828,-10.658>, <3.061,21,-7.391>, <0,21,-8> }
		triangle { <3.061,21,-7.391>, <4.415,19.828,-10.658>, <8.157,19.828,-8.157> }
		triangle { <8.157,19.828,-8.157>, <5.657,21,-5.657>, <3.061,21,-7.391> }
		triangle { <5.657,21,-5.657>, <8.157,19.828,-8.157>, <10.658,19.828,-4.415> }
		triangle { <10.658,19.828,-4.415>, <7.391,21,-3.061>, <5.657,21,-5.657> }
		triangle { <7.391,21,-3.061>, <10.658,19.828,-4.415>, <11.536,19.828,0> }
		triangle { <11.536,19.828,0>, <8,21,0>, <7.391,21,-3.061> }
		triangle { <8,21,0>, <11.536,19.828,0>, <10.658,19.828,4.415> }
		triangle { <10.658,19.828,4.415>, <7.391,21,3.061>, <8,21,0> }
		triangle { <7.391,21,3.061>, <10.658,19.828,4.415>, <8.157,19.828,8.157> }
		triangle { <8.157,19.828,8.157>, <5.657,21,5.657>, <7.391,21,3.061> }
		triangle { <5.657,21,5.657>, <8.157,19.828,8.157>, <4.415,19.828,10.658> }
		triangle { <4.415,19.828,10.658>, <3.061,21,7.391>, <5.657,21,5.657> }
		triangle { <3.061,21,7.391>, <4.415,19.828,10.658>, <0,19.828,11.536> }
		triangle { <0,19.828,11.536>, <0,21,8>, <3.061,21,7.391> }
		triangle { <0,21,8>, <0,19.828,11.536>, <-4.415,19.828,10.658> }
		triangle { <-4.415,19.828,10.658>, <-3.061,21,7.391>, <0,21,8> }
		triangle { <-4.415,19.828,10.658>, <-4.975,17,12.01>, <-9.192,17,9.192> }
		triangle { <-9.192,17,9.192>, <-8.157,19.828,8.157>, <-4.415,19.828,10.658> }
		triangle { <-8.157,19.828,8.157>, <-9.192,17,9.192>, <-12.01,17,4.975> }
		triangle { <-12.01,17,4.975>, <-10.658,19.828,4.415>, <-8.157,19.828,8.157> }
		triangle { <-10.658,19.828,4.415>, <-12.01,17,4.975>, <-13,17,0> }
		triangle { <-13,17,0>, <-11.536,19.828,0>, <-10.658,19.828,4.415> }
		triangle { <11.536,19.828,0>, <13,17,0>, <12.01,17,4.975> }
		triangle { <12.01,17,4.975>, <10.658,19.828,4.415>, <11.536,19.828,0> }
		triangle { <10.658,19.828,4.415>, <12.01,17,4.975>, <9.192,17,9.192> }
		triangle { <9.192,17,9.192>, <8.157,19.828,8.157>, <10.658,19.828,4.415> }
		triangle { <8.157,19.828,8.157>, <9.192,17,9.192>, <4.975,17,12.01> }
		triangle { <4.975,17,12.01>, <4.415,19.828,10.658>, <8.157,19.828,8.157> }
		triangle { <4.415,19.828,10.658>, <4.975,17,12.01>, <0,17,13> }
		triangle { <0,17,13>, <0,19.828,11.536>, <4.415,19.828,10.658> }
		triangle { <0,19.828,11.536>, <0,17,13>, <-4.975,17,12.01> }
		triangle { <-4.975,17,12.01>, <-4.415,19.828,10.658>, <0,19.828,11.536> }
		triangle { <0,24,6>, <-2.3,24,5.54>, <-3.06,24,7.39> }
		triangle { <-3.06,24,7.39>, <0,24,8>, <0,24,6> }
		triangle { <-2.3,24,5.54>, <-4.24,24,4.24>, <-5.66,24,5.66> }
		triangle { <-5.66,24,5.66>, <-3.06,24,7.39>, <-2.3,24,5.54> }
		triangle { <-4.24,24,4.24>, <-5.54,24,2.3>, <-7.39,24,3.06> }
		triangle { <-7.39,24,3.06>, <-5.66,24,5.66>, <-4.24,24,4.24> }
		triangle { <-5.54,24,2.3>, <-6,24,0>, <-8,24,0> }
		triangle { <-8,24,0>, <-7.39,24,3.06>, <-5.54,24,2.3> }
		triangle { <-6,24,0>, <-5.54,24,-2.3>, <-7.39,24,-3.06> }
		triangle { <-7.39,24,-3.06>, <-8,24,0>, <-6,24,0> }
		triangle { <-5.54,24,-2.3>, <-4.24,24,-4.24>, <-5.66,24,-5.66> }
		triangle { <-5.66,24,-5.66>, <-7.39,24,-3.06>, <-5.54,24,-2.3> }
		triangle { <-4.24,24,-4.24>, <-2.3,24,-5.54>, <-3.06,24,-7.39> }
		triangle { <-3.06,24,-7.39>, <-5.66,24,-5.66>, <-4.24,24,-4.24> }
		triangle { <-2.3,24,-5.54>, <0,24,-6>, <0,24,-8> }
		triangle { <0,24,-8>, <-3.06,24,-7.39>, <-2.3,24,-5.54> }
		triangle { <0,24,-6>, <2.3,24,-5.54>, <3.06,24,-7.39> }
		triangle { <3.06,24,-7.39>, <0,24,-8>, <0,24,-6> }
		triangle { <2.3,24,-5.54>, <4.24,24,-4.24>, <5.66,24,-5.66> }
		triangle { <5.66,24,-5.66>, <3.06,24,-7.39>, <2.3,24,-5.54> }
		triangle { <4.24,24,-4.24>, <5.54,24,-2.3>, <7.39,24,-3.06> }
		triangle { <7.39,24,-3.06>, <5.66,24,-5.66>, <4.24,24,-4.24> }
		triangle { <5.54,24,-2.3>, <6,24,0>, <8,24,0> }
		triangle { <8,24,0>, <7.39,24,-3.06>, <5.54,24,-2.3> }
		triangle { <6,24,0>, <5.54,24,2.3>, <7.39,24,3.06> }
		triangle { <7.39,24,3.06>, <8,24,0>, <6,24,0> }
		triangle { <5.54,24,2.3>, <4.24,24,4.24>, <5.66,24,5.66> }
		triangle { <5.66,24,5.66>, <7.39,24,3.06>, <5.54,24,2.3> }
		triangle { <4.24,24,4.24>, <2.3,24,5.54>, <3.06,24,7.39> }
		triangle { <3.06,24,7.39>, <5.66,24,5.66>, <4.24,24,4.24> }
		triangle { <2.3,24,5.54>, <0,24,6>, <0,24,8> }
		triangle { <0,24,8>, <3.06,24,7.39>, <2.3,24,5.54> }
		triangle { <1,0,3.87>, <1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <0,0,4>, <1,0,3.87> }
		triangle { <-1,0,3.87>, <-1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <0,0,4>, <-1,0,3.87> }
		triangle { <-3.85,0,-1.07>, <-1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <-3.46,0,-2>, <-3.85,0,-1.07> }
		triangle { <-2.85,0,-2.8>, <0,0,-1.15>, <0,0,0> }
		triangle { <0,0,0>, <-3.46,0,-2>, <-2.85,0,-2.8> }
		triangle { <2.85,0,-2.8>, <0,0,-1.15>, <0,0,0> }
		triangle { <0,0,0>, <3.46,0,-2>, <2.85,0,-2.8> }
		triangle { <3.85,0,-1.07>, <1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <3.46,0,-2>, <3.85,0,-1.07> }
		triangle { <1,4,3.87>, <1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <0,4,4>, <1,4,3.87> }
		triangle { <-1,4,3.87>, <-1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <0,4,4>, <-1,4,3.87> }
		triangle { <-3.85,4,-1.07>, <-1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <-3.46,4,-2>, <-3.85,4,-1.07> }
		triangle { <-2.85,4,-2.8>, <0,4,-1.15>, <0,4,0> }
		triangle { <0,4,0>, <-3.46,4,-2>, <-2.85,4,-2.8> }
		triangle { <2.85,4,-2.8>, <0,4,-1.15>, <0,4,0> }
		triangle { <0,4,0>, <3.46,4,-2>, <2.85,4,-2.8> }
		triangle { <3.85,4,-1.07>, <1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <3.46,4,-2>, <3.85,4,-1.07> }
		triangle { <1,0,3.87>, <1,0,0.58>, <1,4,0.58> }
		triangle { <1,4,0.58>, <1,4,3.87>, <1,0,3.87> }
		triangle { <-1,0,3.87>, <-1,0,0.58>, <-1,4,0.58> }
		triangle { <-1,4,0.58>, <-1,4,3.87>, <-1,0,3.87> }
		triangle { <-3.85,0,-1.07>, <-1,0,0.58>, <-1,4,0.58> }
		triangle { <-1,4,0.58>, <-3.85,4,-1.07>, <-3.85,0,-1.07> }
		triangle { <-2.85,0,-2.8>, <0,0,-1.15>, <0,4,-1.15> }
		triangle { <0,4,-1.15>, <-2.85,4,-2.8>, <-2.85,0,-2.8> }
		triangle { <2.85,0,-2.8>, <0,0,-1.15>, <0,4,-1.15> }
		triangle { <0,4,-1.15>, <2.85,4,-2.8>, <2.85,0,-2.8> }
		triangle { <3.85,0,-1.07>, <1,0,0.58>, <1,4,0.58> }
		triangle { <1,4,0.58>, <3.85,4,-1.07>, <3.85,0,-1.07> }
		triangle { <4,0,0>, <3.696,0,1.531>, <3.696,4,1.531> }
		triangle { <3.696,4,1.531>, <4,4,0>, <4,0,0> }
		triangle { <3.696,0,1.531>, <2.828,0,2.828>, <2.828,4,2.828> }
		triangle { <2.828,4,2.828>, <3.696,4,1.531>, <3.696,0,1.531> }
		triangle { <2.828,0,2.828>, <1,0,3.87>, <1,4,3.87> }
		triangle { <1,4,3.87>, <2.828,4,2.828>, <2.828,0,2.828> }
		triangle { <-1,0,3.87>, <-2.828,0,2.828>, <-2.828,4,2.828> }
		triangle { <-2.828,4,2.828>, <-1,4,3.87>, <-1,0,3.87> }
		triangle { <-2.828,0,2.828>, <-3.696,0,1.531>, <-3.696,4,1.531> }
		triangle { <-3.696,4,1.531>, <-2.828,4,2.828>, <-2.828,0,2.828> }
		triangle { <-3.696,0,1.531>, <-4,0,0>, <-4,4,0> }
		triangle { <-4,4,0>, <-3.696,4,1.531>, <-3.696,0,1.531> }
		triangle { <-4,0,0>, <-3.85,0,-1.07>, <-3.85,4,-1.07> }
		triangle { <-3.85,4,-1.07>, <-4,4,0>, <-4,0,0> }
		triangle { <-2.85,0,-2.8>, <-1.531,0,-3.696>, <-1.531,4,-3.696> }
		triangle { <-1.531,4,-3.696>, <-2.85,4,-2.8>, <-2.85,0,-2.8> }
		triangle { <-1.531,0,-3.696>, <0,0,-4>, <0,4,-4> }
		triangle { <0,4,-4>, <-1.531,4,-3.696>, <-1.531,0,-3.696> }
		triangle { <0,0,-4>, <1.531,0,-3.696>, <1.531,4,-3.696> }
		triangle { <1.531,4,-3.696>, <0,4,-4>, <0,0,-4> }
		triangle { <1.531,0,-3.696>, <2.85,0,-2.8>, <2.85,4,-2.8> }
		triangle { <2.85,4,-2.8>, <1.531,4,-3.696>, <1.531,0,-3.696> }
		triangle { <3.85,0,-1.07>, <4,0,0>, <4,4,0> }
		triangle { <4,4,0>, <3.85,4,-1.07>, <3.85,0,-1.07> }
// 
	}
}
#end

#declare _3626bp01_dot_dat = #if (QUAL = 0) box { <-13,-4,-13>, <13,24,13> } #else union {
// Minifig Head with Standard Grin Pattern
// Name: 3626bp01.dat
// Author: Tore Eriksson
// Modified March-1999: Chris Dee (chris_w_dee@hotmail.com)
// Official LCad update 99-02
	mesh {
		triangle { <-11.536,1.172,0>, <-13,4,0>, <-12.01,4,-4.975> }
		triangle { <-12.01,4,-4.975>, <-10.658,1.172,-4.415>, <-11.536,1.172,0> }
		triangle { <-10.658,1.172,-4.415>, <-12.01,4,-4.975>, <-9.192,4,-9.192> }
		triangle { <-9.192,4,-9.192>, <-8.157,1.172,-8.157>, <-10.658,1.172,-4.415> }
		triangle { <-8.157,1.172,-8.157>, <-9.192,4,-9.192>, <-4.975,4,-12.01> }
		triangle { <-4.975,4,-12.01>, <-4.415,1.172,-10.658>, <-8.157,1.172,-8.157> }
		triangle { <-4.415,1.172,-10.658>, <-4.975,4,-12.01>, <0,4,-13> }
		triangle { <0,4,-13>, <0,1.172,-11.536>, <-4.415,1.172,-10.658> }
		triangle { <0,1.172,-11.536>, <0,4,-13>, <4.975,4,-12.01> }
		triangle { <4.975,4,-12.01>, <4.415,1.172,-10.658>, <0,1.172,-11.536> }
		triangle { <4.415,1.172,-10.658>, <4.975,4,-12.01>, <9.192,4,-9.192> }
		triangle { <9.192,4,-9.192>, <8.157,1.172,-8.157>, <4.415,1.172,-10.658> }
		triangle { <8.157,1.172,-8.157>, <9.192,4,-9.192>, <12.01,4,-4.975> }
		triangle { <12.01,4,-4.975>, <10.658,1.172,-4.415>, <8.157,1.172,-8.157> }
		triangle { <10.658,1.172,-4.415>, <12.01,4,-4.975>, <13,4,0> }
		triangle { <13,4,0>, <11.536,1.172,0>, <10.658,1.172,-4.415> }
		triangle { <-13,4,0>, <-13,17,0>, <-12.01,17,-4.975> }
		triangle { <-12.01,17,-4.975>, <-12.01,4,-4.975>, <-13,4,0> }
		triangle { <-12.01,4,-4.975>, <-12.01,17,-4.975>, <-9.192,17,-9.192> }
		triangle { <-9.192,17,-9.192>, <-9.192,4,-9.192>, <-12.01,4,-4.975> }
		triangle { <-9.192,4,-9.192>, <-9.192,17,-9.192>, <-4.975,17,-12.01> }
		triangle { <-4.975,17,-12.01>, <-4.975,4,-12.01>, <-9.192,4,-9.192> }
		triangle { <-4.975,4,-12.01>, <-4.975,8.75,-12.01>, <0,8.75,-13> }
		triangle { <0,8.75,-13>, <0,4,-13>, <-4.975,4,-12.01> }
		triangle { <0,4,-13>, <0,8.75,-13>, <4.975,8.75,-12.01> }
		triangle { <4.975,8.75,-12.01>, <4.975,4,-12.01>, <0,4,-13> }
		triangle { <4.75,8.75,-12.055>, <4.975,8.75,-12.01>, <4.975,11.25,-12.01> }
		triangle { <4.975,11.25,-12.01>, <4.75,11.25,-12.055>, <4.75,8.75,-12.055> }
	}
	object { _4_dash_4disc_dot_dat matrix <1.25,0,0.244,0.244,0,1,0,-1.25,0,3.5,10,-12.304> #if (version >= 3.1) material #else texture #end { Color0 } }
	object { _4_dash_4ndis_dot_dat matrix <1.25,0,0.244,0.244,0,1,0,-1.25,0,3.5,10,-12.304> }
	mesh {
		triangle { <0,8.75,-13>, <2.25,8.75,-12.552>, <2.25,11.25,-12.552> }
		triangle { <2.25,11.25,-12.552>, <0,11.25,-13>, <0,8.75,-13> }
		triangle { <0,8.75,-13>, <-2.25,8.75,-12.552>, <-2.25,11.25,-12.552> }
		triangle { <-2.25,11.25,-12.552>, <0,11.25,-13>, <0,8.75,-13> }
	}
	object { _4_dash_4disc_dot_dat matrix <1.25,0,-0.244,-0.244,0,1,0,-1.25,0,-3.5,10,-12.304> #if (version >= 3.1) material #else texture #end { Color0 } }
	object { _4_dash_4ndis_dot_dat matrix <1.25,0,-0.244,-0.244,0,1,0,-1.25,0,-3.5,10,-12.304> }
	mesh {
		triangle { <-4.75,8.75,-12.055>, <-4.975,8.75,-12.01>, <-4.975,11.25,-12.01> }
		triangle { <-4.975,11.25,-12.01>, <-4.75,11.25,-12.055>, <-4.75,8.75,-12.055> }
		triangle { <-4.975,11.25,-12.01>, <-4.975,14.2,-12.01>, <0,14.2,-13> }
		triangle { <0,14.2,-13>, <0,11.25,-13>, <-4.975,11.25,-12.01> }
		triangle { <0,11.25,-13>, <0,14.2,-13>, <4.975,14.2,-12.01> }
		triangle { <4.975,14.2,-12.01>, <4.975,11.25,-12.01>, <0,11.25,-13> }
		triangle { <0,15,-13>, <0,14.2,-13>, <1.75,14.2,-12.652> }
		triangle { <1.75,14.2,-12.652>, <1.75,14.75,-12.652>, <0,15,-13> }
		triangle { <1.75,14.75,-12.652>, <1.75,14.2,-12.652>, <3,14.2,-12.403> }
		triangle { <3,14.2,-12.403>, <3.5,14.5,-12.304>, <3.5,14.2,-12.304> }
		triangle { <3.5,14.2,-12.304>, <4.975,14.2,-12.01>, <4.975,16,-12.01> }
		triangle { <4.975,16,-12.01>, <3.5,16,-12.304>, <3.5,14.2,-12.304> }
		triangle { <3.5,15,-12.304>, <4.975,16,-12.01>, <1.75,16,-12.652> }
		triangle { <1.75,16,-12.652>, <1.75,15.75,-12.652>, <3.5,15,-12.304> }
		triangle { <1.75,15.75,-12.652>, <1.75,16,-12.652>, <0,16,-13> }
	}
	mesh {
		triangle { <0,16,-13>, <0,15,-13>, <1.75,14.75,-12.652> }
		triangle { <1.75,14.75,-12.652>, <1.75,15.75,-12.652>, <0,16,-13> }
		triangle { <1.75,15.75,-12.652>, <1.75,14.75,-12.652>, <3,14.2,-12.403> }
		triangle { <3,14.2,-12.403>, <3.5,15,-12.304>, <1.75,15.75,-12.652> }
		triangle { <3.5,15,-12.304>, <3,14.2,-12.403>, <3.5,14.5,-12.304> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <0,15,-13>, <0,14.2,-13>, <-1.75,14.2,-12.652> }
		triangle { <-1.75,14.2,-12.652>, <-1.75,14.75,-12.652>, <0,15,-13> }
		triangle { <-1.75,14.75,-12.652>, <-1.75,14.2,-12.652>, <-3,14.2,-12.403> }
		triangle { <-3,14.2,-12.403>, <-3.5,14.5,-12.304>, <-3.5,14.2,-12.304> }
		triangle { <-3.5,14.2,-12.304>, <-4.975,14.2,-12.01>, <-4.975,16,-12.01> }
		triangle { <-4.975,16,-12.01>, <-3.5,16,-12.304>, <-3.5,14.2,-12.304> }
		triangle { <-3.5,15,-12.304>, <-4.975,16,-12.01>, <-1.75,16,-12.652> }
		triangle { <-1.75,16,-12.652>, <-1.75,15.75,-12.652>, <-3.5,15,-12.304> }
		triangle { <-1.75,15.75,-12.652>, <-1.75,16,-12.652>, <0,16,-13> }
	}
	mesh {
		triangle { <0,16,-13>, <0,15,-13>, <-1.75,14.75,-12.652> }
		triangle { <-1.75,14.75,-12.652>, <-1.75,15.75,-12.652>, <0,16,-13> }
		triangle { <-1.75,15.75,-12.652>, <-1.75,14.75,-12.652>, <-3,14.2,-12.403> }
		triangle { <-3,14.2,-12.403>, <-3.5,15,-12.304>, <-1.75,15.75,-12.652> }
		triangle { <-3.5,15,-12.304>, <-3,14.2,-12.403>, <-3.5,14.5,-12.304> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-4.975,16,-12.01>, <-4.975,17,-12.01>, <0,17,-13> }
		triangle { <0,17,-13>, <0,16,-13>, <-4.975,16,-12.01> }
		triangle { <0,16,-13>, <0,17,-13>, <4.975,17,-12.01> }
		triangle { <4.975,17,-12.01>, <4.975,16,-12.01>, <0,16,-13> }
		triangle { <4.975,4,-12.01>, <4.975,17,-12.01>, <9.192,17,-9.192> }
		triangle { <9.192,17,-9.192>, <9.192,4,-9.192>, <4.975,4,-12.01> }
		triangle { <9.192,4,-9.192>, <9.192,17,-9.192>, <12.01,17,-4.975> }
		triangle { <12.01,17,-4.975>, <12.01,4,-4.975>, <9.192,4,-9.192> }
		triangle { <12.01,4,-4.975>, <12.01,17,-4.975>, <13,17,0> }
		triangle { <13,17,0>, <13,4,0>, <12.01,4,-4.975> }
		triangle { <-11.536,19.828,0>, <-13,17,0>, <-12.01,17,-4.975> }
		triangle { <-12.01,17,-4.975>, <-10.658,19.828,-4.415>, <-11.536,19.828,0> }
		triangle { <-10.658,19.828,-4.415>, <-12.01,17,-4.975>, <-9.192,17,-9.192> }
		triangle { <-9.192,17,-9.192>, <-8.157,19.828,-8.157>, <-10.658,19.828,-4.415> }
		triangle { <-8.157,19.828,-8.157>, <-9.192,17,-9.192>, <-4.975,17,-12.01> }
		triangle { <-4.975,17,-12.01>, <-4.415,19.828,-10.658>, <-8.157,19.828,-8.157> }
		triangle { <-4.415,19.828,-10.658>, <-4.975,17,-12.01>, <0,17,-13> }
		triangle { <0,17,-13>, <0,19.828,-11.536>, <-4.415,19.828,-10.658> }
		triangle { <0,19.828,-11.536>, <0,17,-13>, <4.975,17,-12.01> }
		triangle { <4.975,17,-12.01>, <4.415,19.828,-10.658>, <0,19.828,-11.536> }
		triangle { <4.415,19.828,-10.658>, <4.975,17,-12.01>, <9.192,17,-9.192> }
		triangle { <9.192,17,-9.192>, <8.157,19.828,-8.157>, <4.415,19.828,-10.658> }
		triangle { <8.157,19.828,-8.157>, <9.192,17,-9.192>, <12.01,17,-4.975> }
		triangle { <12.01,17,-4.975>, <10.658,19.828,-4.415>, <8.157,19.828,-8.157> }
		triangle { <10.658,19.828,-4.415>, <12.01,17,-4.975>, <13,17,0> }
		triangle { <13,17,0>, <11.536,19.828,0>, <10.658,19.828,-4.415> }
	}
	object { s_slash_3626bs01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
// 
}
#end

#declare _4485_dot_dat = #if (QUAL = 0) box { <-14,-11.96,-28.38>, <14,8.72,14.74> } #else union {
// Minifig Cap
// Name: 4485.dat
// Author: Thomas Burger (ber00439@berk.com)
// Official LCad update 98-05
	object { _2_dash_4disc_dot_dat matrix <14,0,0,1,1,0,0,-0.73,-13.98,0,7.26,-14.4> }
	object { _2_dash_4ndis_dot_dat matrix <14,0,0,1,1,0,0,-0.73,-13.98,0,7.99,-0.42> }
// 
	mesh {
		triangle { <11.59,8.15,2.69>, <13.52,8.18,3.2>, <14,7.99,-0.42> }
		triangle { <14,7.99,-0.42>, <12,7.99,-0.42>, <11.59,8.15,2.69> }
		triangle { <10.39,8.3,5.58>, <12.12,8.36,6.58>, <13.52,8.18,3.2> }
		triangle { <13.52,8.18,3.2>, <11.59,8.15,2.69>, <10.39,8.3,5.58> }
		triangle { <8.49,8.43,8.06>, <9.9,8.51,9.46>, <12.12,8.36,6.58> }
		triangle { <12.12,8.36,6.58>, <10.39,8.3,5.58>, <8.49,8.43,8.06> }
		triangle { <6,8.53,9.95>, <7,8.63,11.68>, <9.9,8.51,9.46> }
		triangle { <9.9,8.51,9.46>, <8.49,8.43,8.06>, <6,8.53,9.95> }
		triangle { <3.11,8.6,11.15>, <3.62,8.7,13.08>, <7,8.63,11.68> }
		triangle { <7,8.63,11.68>, <6,8.53,9.95>, <3.11,8.6,11.15> }
		triangle { <0,8.61,11.56>, <0,8.72,13.56>, <3.62,8.7,13.08> }
		triangle { <3.62,8.7,13.08>, <3.11,8.6,11.15>, <0,8.61,11.56> }
		triangle { <-3.11,8.6,11.15>, <-3.62,8.7,13.08>, <0,8.72,13.56> }
		triangle { <0,8.72,13.56>, <0,8.61,11.56>, <-3.11,8.6,11.15> }
		triangle { <-6,8.53,9.95>, <-7,8.63,11.68>, <-3.62,8.7,13.08> }
		triangle { <-3.62,8.7,13.08>, <-3.11,8.6,11.15>, <-6,8.53,9.95> }
		triangle { <-8.49,8.43,8.06>, <-9.9,8.51,9.46>, <-7,8.63,11.68> }
		triangle { <-7,8.63,11.68>, <-6,8.53,9.95>, <-8.49,8.43,8.06> }
		triangle { <-10.39,8.3,5.58>, <-12.12,8.36,6.58>, <-9.9,8.51,9.46> }
		triangle { <-9.9,8.51,9.46>, <-8.49,8.43,8.06>, <-10.39,8.3,5.58> }
		triangle { <-11.59,8.15,2.69>, <-13.52,8.18,3.2>, <-12.12,8.36,6.58> }
		triangle { <-12.12,8.36,6.58>, <-10.39,8.3,5.58>, <-11.59,8.15,2.69> }
		triangle { <-12,7.99,-0.42>, <-14,7.99,-0.42>, <-13.52,8.18,3.2> }
		triangle { <-13.52,8.18,3.2>, <-11.59,8.15,2.69>, <-12,7.99,-0.42> }
		triangle { <-11.59,7.83,-3.53>, <-13.52,7.8,-4.04>, <-14,7.99,-0.42> }
		triangle { <-14,7.99,-0.42>, <-12,7.99,-0.42>, <-11.59,7.83,-3.53> }
		triangle { <-10.39,7.68,-6.41>, <-12.12,7.62,-7.4>, <-13.52,7.8,-4.04> }
		triangle { <-13.52,7.8,-4.04>, <-11.59,7.83,-3.53>, <-10.39,7.68,-6.41> }
		triangle { <-8.49,7.55,-8.89>, <-9.9,7.47,-10.3>, <-12.12,7.62,-7.4> }
		triangle { <-12.12,7.62,-7.4>, <-10.39,7.68,-6.41>, <-8.49,7.55,-8.89> }
		triangle { <-6,7.44,-10.79>, <-7,7.35,-12.52>, <-9.9,7.47,-10.3> }
		triangle { <-9.9,7.47,-10.3>, <-8.49,7.55,-8.89>, <-6,7.44,-10.79> }
		triangle { <-3.11,7.38,-11.99>, <-3.62,7.28,-13.92>, <-7,7.35,-12.52> }
		triangle { <-7,7.35,-12.52>, <-6,7.44,-10.79>, <-3.11,7.38,-11.99> }
		triangle { <0,7.36,-12.4>, <0,7.26,-14.4>, <-3.62,7.28,-13.92> }
		triangle { <-3.62,7.28,-13.92>, <-3.11,7.38,-11.99>, <0,7.36,-12.4> }
		triangle { <3.11,7.38,-11.99>, <3.62,7.28,-13.92>, <0,7.26,-14.4> }
		triangle { <0,7.26,-14.4>, <0,7.36,-12.4>, <3.11,7.38,-11.99> }
		triangle { <6,7.44,-10.79>, <7,7.35,-12.52>, <3.62,7.28,-13.92> }
		triangle { <3.62,7.28,-13.92>, <3.11,7.38,-11.99>, <6,7.44,-10.79> }
		triangle { <8.49,7.85,-8.62>, <9.9,7.83,-10.03>, <7,7.79,-12.26> }
		triangle { <7,7.79,-12.26>, <6,7.81,-10.53>, <8.49,7.85,-8.62> }
		triangle { <10.39,7.68,-6.41>, <12.12,7.62,-7.4>, <9.9,7.47,-10.3> }
		triangle { <9.9,7.47,-10.3>, <8.49,7.55,-8.89>, <10.39,7.68,-6.41> }
		triangle { <11.59,7.83,-3.53>, <13.52,7.8,-4.04>, <12.12,7.62,-7.4> }
		triangle { <12.12,7.62,-7.4>, <10.39,7.68,-6.41>, <11.59,7.83,-3.53> }
		triangle { <12,7.99,-0.42>, <14,7.99,-0.42>, <13.52,7.8,-4.04> }
		triangle { <13.52,7.8,-4.04>, <11.59,7.83,-3.53>, <12,7.99,-0.42> }
// 
// 
	}
	object { _2_dash_4disc_dot_dat matrix <14,0,0,1,1,0,0,-0.73,-13.98,0,4.26,-14.25> }
	object { _2_dash_4ndis_dot_dat matrix <14,0,0,1,1,0,0,-0.73,-13.98,0,5,-0.26> }
	object { _2_dash_4cyli_dot_dat matrix <-14,0,0,0,3,-0.15,0,-0.73,-13.98,0,4.26,-14.25> }
	mesh {
		triangle { <-14,7.99,-0.42>, <-14,7.26,-14.4>, <-14,4.26,-14.25> }
		triangle { <-14,4.26,-14.25>, <-14,5,-0.26>, <-14,7.99,-0.42> }
		triangle { <14,7.99,-0.42>, <14,7.26,-14.4>, <14,4.26,-14.25> }
		triangle { <14,4.26,-14.25>, <14,5,-0.26>, <14,7.99,-0.42> }
	}
	object { _4_dash_4cyli_dot_dat matrix <12,0,0,0,8,0,0,0,12,0,-1,0> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,-2,0> }
	#end
	object { _4_dash_8sphe_dot_dat matrix <-12,0,0,0,-8,0,0,0,12,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <14,0,0,0,9,0,0,0,14,0,-1.5,0> }
	object { _4_dash_8sphe_dot_dat matrix <-14,0,0,0,-9.98,0.7,0,0.98,13.97,0,-1,0.07> }
// 
}
#end

#declare legoman_dot_dat = union {
// The lazy legoman
// Original name:
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_971_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (version >= 3.1) material #else texture #end { Color1 } 
		#if (clock>=0.68 & clock<0.73) rotate -90*(clock-0.68)/0.03*x #end  
		#if (clock>=0.73) rotate -90*x #end 
		translate 44*y
	}
	object {
		_972_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (version >= 3.1) material #else texture #end { Color1 }  
		#if (clock>=0.68 & clock<0.73) rotate -90*(clock-0.68)/0.03*x #end  
		#if (clock>=0.73) rotate -90*x #end    
		translate 44*y
	}
	object {
		_970_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,32,0>
		#if (version >= 3.1) material #else texture #end { Color0 }
	} 
	//RightHand
	object {
		_977_dot_dat
		matrix <0,-0.71,0.71,0,0.71,0.71,-1,0,0,-22.5,20,-15.5>
		#if (version >= 3.1) material #else texture #end { Color14 }
		#if (clock<.36) rotate -10+14-7*abs(mod(clock*100,4)-2)*x  #end 
		#if (clock>=0.53 & clock<0.58) rotate -120*(clock-0.53)/0.05*x #end    
		#if (clock>=0.58) rotate -120*x #end
		#if (clock>=0.65 & clock<0.68) rotate 50*(clock-0.65)/0.03*x #end  
		#if (clock>=0.68) rotate 50*x #end    
		translate 8*y
	}          
	//LeftHand
	object {
		_977_dot_dat
		matrix <0,-0.71,0.71,0,0.71,0.71,-1,0,0,22.5,20,-15.5>
		#if (version >= 3.1) material #else texture #end { Color14 }   
		#if (clock<.36) rotate -10+7*abs(mod(clock*100,4)-2)*x #end  
		#if (clock>=0.53 & clock<0.58) rotate -120*(clock-0.53)/0.05*x #end    
		#if (clock>=0.58) rotate -120*x #end     
		#if (clock>=0.65 & clock<0.68) rotate 50*(clock-0.65)/0.03*x #end  
		#if (clock>=0.68) rotate 50*x #end  
		translate 8*y
	}
	object {
		_975_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (version >= 3.1) material #else texture #end { Color1 }   
		#if (clock<.36) rotate -10+14-7*abs(mod(clock*100,4)-2)*x #end    
		#if (clock>=0.53 & clock<0.58) rotate -120*(clock-0.53)/0.05*x #end    
		#if (clock>=0.58) rotate -120*x #end
		#if (clock>=0.65 & clock<0.68) rotate 50*(clock-0.65)/0.03*x #end  
		#if (clock>=0.68) rotate 50*x #end   
		translate 8*y
	}
	object {
		_976_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (version >= 3.1) material #else texture #end { Color1 }  
		#if (clock<.36) rotate -10+7*abs(mod(clock*100,4)-2)*x #end 
		#if (clock>=0.53 & clock<0.58) rotate -120*(clock-0.53)/0.05*x #end    
		#if (clock>=0.58) rotate -120*x #end
		#if (clock>=0.65 & clock<0.68) rotate 50*(clock-0.65)/0.03*x #end  
		#if (clock>=0.68) rotate 50*x #end 
		translate 8*y
	}
	object {
		_973p17_dot_dat
		matrix <1-SW/38,0,0,0,1-SW/44,0,0,0,1-SW/20,0,SW/4.4,0>
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (version >= 3.1) material #else texture #end { Color1 }
	}
	object {
		_3626bp01_dot_dat
		matrix <1-SW/26,0,0,0,1-SW/28,0,0,0,1-SW/26,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,0,-24,0>
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	object {
		_4485_dot_dat
		matrix <1-SW/28,0,0,0,1-SW/20.68,0,0,0,1-SW/43.12,0,SW/-12.7654,SW/-6.32258>
		matrix <1,0,0,0,1,0,0,0,1,0,-24,0>
		#if (version >= 3.1) material #else texture #end { Color1 }
	}  
	#if (clock>=0.68 & clock<0.88)
	  translate <-292,-7,3>
	  #if (clock<0.73)
	    rotate (45*(clock-0.68)/0.05)*z
	  #end
	  #if (clock>=0.73 & clock<0.83)      
	    rotate 45*z       
	    rotate (-90*(clock-0.73)/0.1)*y	 
	  #end
	  #if (clock>=0.83)            
	    rotate (45-45*(clock-0.83)/0.05)*z
	    rotate -90*y 
	    translate -30*(clock-0.83)/0.05*y
	  #end 
	  translate <292,7,-3>
	#end             
	#if (clock>=0.9)
	  rotate (-270*(clock-0.9)/0.1-270*((clock-0.9)*(clock-0.9))/0.01)*y
	#end
	#if (clock>=0.88)
	  translate <-292,-7,3>
	  rotate -90*y 
	  translate <292,7,-3>
	  translate -30*y
	#end
// 
// 
}

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4186)
		#include "lg_4186.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4186_dot_dat = #if (QUAL = 0) box { <-480,-4,-480>, <480,4,480> } #else object {
// Baseplate 48 x 48
	lg_4186
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4186_dot_dat_clear = #if (QUAL = 0) box { <-480,-4,-480>, <480,4,480> } #else object {
// Baseplate 48 x 48
	lg_4186_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare irtc_dot_mpd = union {
// FILE D:\LDRAW\LDRAW\MODELS\contra2.ldr
// Untitled
// Name: contra2.ldr
// Author: MLCad
// Unofficial Model
// ROTATION CENTER -22 24 58.002 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		_2986_dot_dat
		matrix <1-SW/47.04,0,0,0,1-SW/44,0,0,0,1-SW/47.04,0,SW/2.44444,0>
		matrix <1,0,0,0,1,0,0,0,1,-8,57,71>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3456_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,-8,97,70>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object { legoman_27_s__chair_dot_dat matrix <0,0,-1,0,1,0,1,0,0,-3,73,342> #if (version >= 3.1) material #else texture #end { Color7 } }
	object { whole__arm_dot_dat matrix <0,0,-1,0,1,0,1,0,0,-7,-31,52> #if (version >= 3.1) material #else texture #end { Color7 } }
	object { contrap_dot_ldr matrix <1,0,0,0,1,0,0,0,1,358,43,121> #if (version >= 3.1) material #else texture #end { Color7 } }
	object { legoman_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,284,33,41> #if (version >= 3.1) material #else texture #end { Color7 } }
	/*object { 
	// This is a large baseplate that may be placed under the LEGO machine.  I have it commented out
	// Because the slight increase in "coolness" is offset by the fact that it slows rendering down
	// To about a tenth of regualar speed. 
		_4186_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,173,105,230>
		#if (version >= 3.1) material #else texture #end { Color2 }
	}*/
// 
}


object { irtc_dot_mpd #if (version >= 3.1) material #else texture #end { Color7 } }


// Floor:
object {
	plane { y, 109.441 hollow }
	texture {
		pigment { color rgb <0.2,0.5,0.2> }
		finish { ambient 0.1 diffuse 0.4 }
	}
}

// Background:
background { color rgb <0.3,0.8,1>}

// Camera (Latitude,Longitude,Radius = 30,45,0)
camera {
	#declare PCT = 0; // Percentage further away
	#declare STEREO = 0; // Normal view
	//#declare STEREO =  degrees(atan2(1,12))/2; // Left view
	//#declare STEREO = -degrees(atan2(1,12))/2; // Right view
	//location vaxis_rotate(<844.044,-300.201,-441.044> + PCT/100.0*<578.739,-472.538,-578.739>,
	// 
	right    -4/3*x                     //<-273476,-669877,273476>,STEREO) 
	sky      -y
	#if (clock<0.36) location <200,-125,-60> #end  
	#if (clock>=0.36 & clock<0.41)
	  location <200,-125-(clock-0.36)*1500,-60+(clock-0.36)*20*340>
	#end
	#if (clock<0.30) look_at  <320,33,100> #end
	#if (clock>=0.30 & clock<0.36)
	  look_at <320-(clock-0.3)/0.06*3,33-(clock-0.3)/0.06*66,100+(clock-0.3)/0.06*68>
	#end
	#if (clock>=0.36 & clock<0.41)
	  look_at <317-(clock-0.36)*6500,-33-(clock-0.36)*240,168-(clock-0.36)*4000>
	#end   
	#if (clock>=0.41 & clock<0.53)
	  location <200+100*(clock-0.41)/0.12,-200-25*(clock-0.41)/0.12,280+220*(clock-0.41)/0.12>
	  look_at <-8+56*(clock-0.41)/0.12,-45,-30+100*(clock-0.41)/0.12>
	#end    
	#if (clock>=0.53 & clock<0.58)
	  location <300-20*(clock-0.53)/0.05,-225+50*(clock-0.53)/0.05,500-100*(clock-0.53)/0.05>
	  look_at <50+230*(clock-0.53)/0.05,-45+95*(clock-0.53)/0.05,70-30*(clock-0.53)/0.05>
	#end   
	#if (clock>=0.58 & clock<0.68)
	  location <280,-175,400>
	  look_at <280,50,40>
	#end    
	#if (clock>=0.68 & clock<0.88)
	  location <280,-175-200*(clock-0.68)/0.2,400-200*(clock-0.68)/0.2>
	  look_at <280-280*(clock-0.68)/0.2,50-88*(clock-0.68)/0.2,40+303*(clock-0.68)/0.2>
	#end   
	#if (clock>=0.88)
	  location <280-100*(clock-0.88)/0.12,-375+100*(clock-0.88)/0.12,200-200*(clock-0.88)/0.12>
	  look_at <0,-38+10*(clock-0.88)/0.12,343>
	#end 
	angle    67.3801
	rotate   <0,1e-5,0> // Prevent gap between adjecent quads
	//orthographic
}

// Lights:
light_source {
	<173,-722.033,-438.27>  // Latitude,Longitude,Radius: 45,0,945.076
	color rgb <1,1,1>
}
light_source {
	<881.807,-526.301,639.23>  // Latitude,Longitude,Radius: 30,120,945.076
	color rgb <1,1,1>
}
light_source {
	<-236.23,-872.223,466.269>  // Latitude,Longitude,Radius: 60,-120,945.076
	color rgb <1,1,1>
}    
   
#if (clock>=0.41 & clock <0.73)     
light_source {
        <60,12,54>, rgb <1,1,1>
}               
#end

// Number of processed parts: 127
// From PARTS: 62
// LGEO parts: 31 (50%)
// stud.dat: 52
// BoundingBox: <-307,-216.967,-250> <653,109.441,710>
// Center: <173,-53.7631,230>
// Size: <960,326.408,960>
