// Persistence of Vision Ray Tracer Scene Description File
// File: SprayPnt.pov
// Vers: 3.5
// Desc: IRTC Animation Entry - 04/02
// Date: 04/10/02
// Auth: Mark J. Murphy
//

#version 3.5;

#include "colors.inc"
#include "finish.inc"
#include "woods.inc"
#include "metals.inc"
#include "rand.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

#declare R1 = seed(12345);

// Animation frame data //////////////////////////////////////////////////////////////////////////// 
 
#declare DishStartFrame = 65;
#declare DishRelativeFrame = frame_number - DishStartFrame;  

#declare MouseTrapStartFrame = DishStartFrame + 240;
#declare MouseTrapRelativeFrame = frame_number - MouseTrapStartFrame;
#declare BallsStartFrame =  MouseTrapStartFrame + 5;
#declare BallsRelativeFrame = frame_number - BallsStartFrame;

#declare MatchStartFrame = BallsStartFrame + 20;
#declare MatchRotateSeconds = 1;
#declare MatchRotateFrameCt = MatchRotateSeconds*25;    
#declare MatchBurnStartFrame = MatchStartFrame+(MatchRotateFrameCt/2)+2;
#declare MatchBurnEndFrame = MatchBurnStartFrame+35;
    
#declare CannonSequenceStartFrame =  MatchStartFrame + 27;
#declare CannonSequenceRelativeFrame = frame_number - CannonSequenceStartFrame; 
#declare WickSeconds = 2;	
#declare WickAngle = ((CannonSequenceRelativeFrame)/(WickSeconds*25))*360;
#declare CannonShotStartFrame = CannonSequenceStartFrame + (WickSeconds*25);
   
#declare KnifeStartFrame = CannonShotStartFrame + 2;
#declare PaintStartFrame = KnifeStartFrame + 69; 

#declare SignStartFrame = DishStartFrame + 470;
#declare SignRelativeFrame = frame_number - SignStartFrame;   


// Dish ////////////////////////////////////////////////////////////////////////////////////////////

#declare DishLeg =
object {
	cylinder { <0,0,0><0,15,0> 0.15
		texture { T_Wood15
			rotate 84*x
	 		scale 1 
		}
	}
}  
      
#declare DishHolder =
union {
	// ring
	torus { 2.92 0.13 
		texture { T_Chrome_1B }
		normal { dents 0.7 }
 	}
	// rivets
	sphere { <0,0,0> 0.12
		texture { T_Brass_4A }
		translate <3.18,0,0>
	}
	sphere { <0,0,0> 0.12
		texture { T_Brass_4A }
		translate <3.18,0,0>
		rotate 120*y 
	}
	sphere { <0,0,0> 0.12
		texture { T_Brass_4A }
		translate <3.18,0,0>
		rotate 240*y 
	}
}	      
  
#declare Dish =   
union {
	difference {
		sphere { <0,0,0> 3 }
	 	sphere { <0,0,0> 2.9 }
	 	box { <-4,0,-4><4,4,4> }
		cylinder { <0,-6,0><0,-2,0> 0.55}	 	
	 	scale <1,1.2,1>
	} 
	intersection {
		difference {
			torus { 1.5 0.55 }
			torus { 1.5 0.5 }
			box { <-3,-3,-3><3,3,3> rotate  55*y translate <2.65,0,0>}
		}	
		box { <-3,-2.5,0><0,2.5,-3> }
	 	pigment {Blue}
	 	finish { phong 0.9 }
	 	rotate -90*x
  	rotate 180*y
	 	translate <-1.5,-3.5,0>
	}	                       
 	object { DishHolder
 		translate -1*y 
	} 		
 	object { DishHolder
 		translate -5.7*y 
 	}
 	object { DishHolder
 		translate -11*y 
	} 		
	// legs
	cylinder { <0,0,0><0,15,0> 0.20
		texture { T_Wood15
			rotate 85*x
		}
		translate <3.05,-15.7,0>
	}		
	cylinder { <0,0,0><0,15,0> 0.20
		texture { T_Wood15
			rotate 82*x
		}
		translate <3.05,-15.7,0>
		rotate 120*y
	}		
	cylinder { <0,0,0><0,15,0> 0.20
		texture { T_Wood15
			rotate 93*x
		}
		translate <3.05,-15.7,0>
		rotate 240*y
	}		
	texture {
		pigment { color Red }
		finish { phong 0.9 ambient 0.5 }
	}
}
    
// Ramp ////////////////////////////////////////////////////////////////////////////////////////////    
    
#declare Ramp_90 = 
intersection {
	difference {
		torus { 2 0.55 }
		torus { 2 0.55 translate <0,0.1,0> }
		plane {-y,0}
	}	
	box { <-3,-2.5,0><0,2.5,-3> }
}	

#declare Ramp_Straight =
difference {
	cylinder { <0,0,0><1,0,0> 0.55 }
	cylinder { <-0.1,0,0><1.1,0,0> 0.55 translate 0.1*y }
	plane {-y,0}	
}		 

#declare Ramp =
union {
	object { Ramp_Straight
		translate <-2.5,0,0>
	}			
	object { Ramp_90
		translate <-2.5,0,2>
	}			
	object { Ramp_90
		rotate 90*y
		translate <-2.5,0,2>
	}
	object { Ramp_Straight
		scale <2,1,1>
		translate <-2.5,0,4> 
	} 
	object { Ramp_90
		rotate 180*y
		translate <-0.5,0,2>
	}
	object { Ramp_Straight
		scale <6,1,1>
		rotate 90*y
		translate <1.5,0,2> 
	}
	pigment {Blue}	
	finish { phong 0.9 ambient 0.5 }
	translate <0,-5,0>
}	
  
// Bouncer /////////////////////////////////////////////////////////////////////////////////////////

#declare Bounce_Frame_Straight =
cylinder { <0,0,0><1,0,0> 0.10 
}	 

#declare Bounce_Frame_Joint =
sphere { <0,0,0> 0.25 
}	 
   
#declare Bounce_Mesh =
union {
	box { <0,0,-2><0.5,0.1,2> }
	cylinder { <0,0,0><0.5,0,0> 0.12 translate 2*z }
	cylinder { <0,0,0><0.5,0,0> 0.12 translate -2*z }
	pigment { VLightGray } 
	normal { dents .2 scale <0.05,1,1>}
	translate -0.25*x 
}	    
   
#declare Bouncer =   
union {
	// frame
	object { Bounce_Frame_Straight scale <4,1,1> rotate 90*y translate <0,2.8,2>}  		
	object { Bounce_Frame_Straight scale <4,1,1> rotate 90*y translate <0,0,2> }
	object { Bounce_Frame_Straight scale <4,1,1> rotate 90*y translate <-4,0,2> }
	object { Bounce_Frame_Straight scale <4,1,1> translate <-4,0,-2> }	
	object { Bounce_Frame_Straight scale <4,1,1> translate <-4,0,2> }	
	object { Bounce_Frame_Straight scale <2.8,1,1> rotate 90*z translate <0,0,-2> }	
	object { Bounce_Frame_Straight scale <2.8,1,1> rotate 90*z translate <0,0,2> }	
	object { Bounce_Frame_Straight scale <5.0,1,1> rotate 35*z translate <-4,0,2> }
	object { Bounce_Frame_Straight scale <5.0,1,1> rotate 35*z translate <-4,0,-2> }
	object { Bounce_Frame_Joint translate <0,2.8,-2> }  		
	object { Bounce_Frame_Joint translate <0,2.8,2> }  	
	object { Bounce_Frame_Joint translate <0,0,-2> }  		
	object { Bounce_Frame_Joint translate <0,0,2> }  	
	object { Bounce_Frame_Joint translate <-4,0,-2> }  		
	object { Bounce_Frame_Joint translate <-4,0,2> }   		
	// net
	union {
		object { Bounce_Mesh rotate 180*z translate 0.25*x }
		object { Bounce_Mesh translate 1.33*x }
		object { Bounce_Mesh rotate 180*z translate 2.41*x }
		object { Bounce_Mesh translate 3.49*x }
	 	rotate 35*z 
	 	translate <-3.50,0.35,0>
	}	
	union {
		object { Bounce_Mesh scale <1,1,1.22> rotate 90*y translate 1.25*z }
		object { Bounce_Mesh scale <1,1,1.22> rotate 270*y translate -0*z }		
		object { Bounce_Mesh scale <1,1,1.22> rotate 90*y translate -1.25*z }		
	 	rotate 35*z 
	 	translate <-2,1.4,0>
	}				
  box { <-1,0,-1><1,0.1,1> scale <1.9,1,1.5> rotate 35*z translate <-2,1.43,0> 
  	pigment { Gray30 }
  	normal { bumps 1 scale 0.05 }  
  }
	pigment { Black }
	finish { phong 3 }
}	

// Dish-Ramp-Bouncer ///////////////////////////////////////////////////////////////////////////////

#declare DishRampBouncer = 
union {	
	object { Dish }  
	object { Ramp } 
	object { Bouncer scale 0.9 rotate -90*y translate <1.5,-14.75,-3> }
	// ball
	#switch(DishRelativeFrame)
		#range(-10000,0)
			
		#break
		#range(0,100)
			#declare Rad = pow((0.2*DishRelativeFrame),1.25);	
				sphere { <0,0,0> 0.45
					texture { T_Copper_3D}
					translate <(2.5-(1.7*DishRelativeFrame/100))*sin(Rad),-((DishRelativeFrame/100)*1.95)-0.7,(2.5-(1.7*DishRelativeFrame/100))*cos(Rad)>
				}
		#break
 		#range(107,116)
			// dropping from dish
			#declare Rad = radians((DishRelativeFrame-107)*10);
			sphere { <0,0,0> 0.45
					translate <(cos(Rad)*1.5)-1.5,(-3.5-(sin(Rad)*1.5)),0>
					texture { T_Copper_3D}
			}		
 	 	#break 
  	#range(117,120)
   		// first straight
			sphere { <0,0,0> 0.45
					translate <-1.5-((DishRelativeFrame-116)*0.2),-5.1,0>
					texture { T_Copper_3D}
			}
   	#break
   	#range(121,152)
   		// 180 
			#declare Rad = radians(((DishRelativeFrame-121)*(180/31)));
			sphere { <0,0,0> 0.45
					translate <-2.5-(sin(Rad)*2),-5.1,2-(cos(Rad)*2)>
					texture { T_Copper_3D}
			}
   	#break
   	#range(153,161)
   		// second straight
			sphere { <0,0,0> 0.45
					translate <-2.5+((DishRelativeFrame-152)*0.2),-5.1,4>
					texture { T_Copper_3D}
			}
   	#break
   	#range(162,177)
   		// 90 
			#declare Rad = radians((DishRelativeFrame-162)*6);
			sphere { <0,0,0> 0.45
					translate <(sin(Rad)*2)-0.5,-5.1,(cos(Rad)*2)+2>
					texture { T_Copper_3D}
			}
		#break		
		#range(178,208)
   		// third straight
			sphere { <0,0,0> 0.45
					translate <1.5,-5.1,2-((DishRelativeFrame-177)*0.2)>
					texture { T_Copper_3D}
			}
 		#break
 		#range(209,215)     
   		// falling ball
			sphere { <0,0,0> 0.45
			translate <1.5,-5.1-((8.05/7)*(DishRelativeFrame-208)),-4.35-((DishRelativeFrame-208)*0.1)>
					texture { T_Copper_3D}
   		}
		#break
		#range(216,239)
			// bounce
			#declare Rad = radians((DishRelativeFrame-215)*8); 		
			sphere { <0,0,0> 0.45 translate <1.5,-13+(sin(Rad)*5.5),-5.6-((DishRelativeFrame-216)*0.5)> texture { T_Copper_3D}	}			
  	#break
  	#range(240,260)
			// richochet
			sphere { <0,0,0> 0.45 translate <1.5-((DishRelativeFrame-239)*2.5),-14.2+((DishRelativeFrame-239)*0.55),-17> texture { T_Copper_3D}	}			
 		#break
	#end 
	rotate   90*y      
	translate 15*y
}

// MouseTrap /////////////////////////////////////////////////////////////////////////////////////// 

#declare FiveBallBaseLeft =
box { <-4,0,-0.35><4,0.5,0.35>
	texture {
		T_Wood14 
			rotate 87*y
			translate 10*x
	}
}

#declare FiveBallBaseRight =
box { <-4,0,-0.35><4,0.5,0.35>
	texture {
		T_Wood14 
			rotate 92*y
			translate 30*x
	}
} 


#declare FiveBallTopLeft =
intersection {
	box { <-4,-0.25,-0.35><4,0.25,0.35> }
  cylinder { <-5,0,0><4,0,0> 0.35 }
	texture {
		T_Wood14 
			rotate 92*y
			translate 22*x
	}
}


#declare FiveBallTopRight =
intersection {
	box { <-4,-0.25,-0.35><4,0.25,0.35> }
  cylinder { <-5,0,0><5,0,0> 0.35 }
	texture {
		T_Wood14 
			rotate 94*y
			translate 12*x
	}
}

#declare SwingingBall =
union {
	sphere { <0,-5.0 ,0> 0.82
		texture {T_Chrome_2B}
	}
	cylinder {<0,0,0><0,-4.6,0> 0.03 
		rotate -23*x
		translate -1.8*z
		pigment {Black}
	}
	
	cylinder {<0,0,0><0,-4.6,0> 0.03 
		rotate 23*x
		translate 1.8*z
		pigment {Black}
	}
	cylinder { <0,0,0><0,1.0,0> 0.12 
		translate -5.1*y
		texture {T_Chrome_3D}
	}
}

#declare Wire_90 =
	intersection {
		torus { 0.3 0.05 }
		box { <0,-1,-1><1,1,0> }
		rotate 90*x 
	}
	
#declare Wire_Holder =
union {	
	object { Wire_90 translate <0.75,-0.3,0.0> }		
	cylinder { <-0.75,0,0><0.75,0,0> 0.05 translate <0,0,0> }		
	object { Wire_90 rotate 180*y translate <-0.75,-0.3,0.0> }		
	scale 0.8
	texture { T_Chrome_3A }	
}	
	
#declare Wire_Frame =
union {
	cylinder { <0,0,0><0,1.3,0> 0.05 translate <0,0,-0.72> }	
	object { Wire_90 rotate 90*y translate <0,1.3,-0.42> }	
	cylinder { <-0.42,0,0><0.42,0,0> 0.05 rotate 90*y translate <0,1.6,0> }		
	object { Wire_90 rotate -90*y translate <0,1.3,0.42> }	
	cylinder { <0,0,0><0,1.3,0> 0.05 translate <0,0,0.72> }
	texture { T_Chrome_1A }	
}	

#declare Holder_Brace =
union {
	box { <-0.08,0,-0.02><0.08,0.4,0.02> }
	intersection {
		sphere { <0,0,0> 0.1 }
		box { <-0.2,0,-0.2><0.2,0.2,0> }
		scale <0.6,1.1,0.8> 
		translate <0,0.28,0>
	}	
	texture { T_Copper_1A } 
}			

#declare Food_Holder =
union {
	box { <-0.22,0,-0.35><0.22,0.05,0.35> }
	cone { <0,0.05,0> 0.03 <0,0.20,0> 0.01 translate <-0.1,0,-0.25> }			
	cone { <0,0.05,0> 0.03 <0,0.20,0> 0.01 translate <-0.1,0,0.25> }
	cone { <0,0.05,0> 0.03 <0,0.20,0> 0.01 translate <-0.1,0,0> }
	cone { <0,0.05,0> 0.03 <0,0.20,0> 0.01 translate <0.1,0,0> }
	cone { <0,0.05,0> 0.03 <0,0.20,0> 0.01 translate <0.1,0,-0.25> }
	cone { <0,0.05,0> 0.03 <0,0.20,0> 0.01 translate <0.1,0,0.25> }
	texture { T_Copper_3A}
}

#declare Holder_Arm =
union {
	cylinder { <0,0,0><2.7,0,0> 0.03 } 	
	torus { 0.09 0.03 translate -0.09*x }	
	intersection {
		torus { 0.09 0.03 rotate 90*x }
		box { <-0.2,-0.2,-0.2><0.2,0,0.2> }
		scale <1.3,0.8,1>
		translate <2.78,0.02,0>
	}	
	cylinder { <0,0,0><0.15,0,0> 0.03 translate 2.88*x }
	object { Food_Holder translate <0.4,0,0> }
	texture { T_Silver_1B }
  translate 0.18*x
}	
   
#declare Spring =
union {
  #declare Ct = 0;
  #while (Ct<8)
  	torus { 0.08 0.05 rotate <90,12,0> translate <0,0.48,0.15+(Ct*0.08)> }
  	torus { 0.08 0.05 rotate <90,12,0> translate <0,0.48,-0.15-(Ct*0.08)> }
		#declare Ct = Ct + 1;
	#end
	cylinder { <-0.5,0,0><0,0,0> 0.05 rotate 9*z translate <-0.1,0.41,0.15> }
	cylinder { <-0.5,0,0><0,0,0> 0.05 rotate 9*z translate <-0.1,0.41,-0.15> }
	texture { T_Copper_5A }
}	   
   
#declare MouseTrap = 
union {
	box { <-1.9,0.3,-0.9><1.9,0,0.9> 
		texture { T_Wood10 rotate 82*y scale 1.5}
    normal { dents 3 scale 0.3 }
	}
	// brace
	object { Wire_Holder rotate 90*y translate <0,0.5,0> }	
	object { Spring }
	
	#switch(MouseTrapRelativeFrame)
		#range(-10000,0)
			// frame
			object { Wire_Frame rotate 88*z translate <0,0.5,0> }
  		// holder
  		object { Holder_Brace	translate <-1.8,0.3,0.08> } 
			object { Holder_Arm	rotate <0,180,0> translate <1.2,0.6,0> }
	 	#break
		#range(1,6)
			// frame
			object { Wire_Frame rotate (88-(MouseTrapRelativeFrame*(176/6)))*z translate <0,0.5,0> }
  		// holder
  		object { Holder_Brace	translate <-1.8,0.3,0.08> } 
			object { Holder_Arm	rotate <0,180,(-MouseTrapRelativeFrame*(190/6))> translate <1.2,0.6,0> }
	 	#break
	 	#range(7,10000)
			// frame
			object { Wire_Frame rotate -88*z translate <0,0.5,0> }
  		// holder
  		object { Holder_Brace	translate <-1.8,0.3,0.08> } 
			object { Holder_Arm	rotate <0,180,-190> translate <1.2,0.6,0> }
	 	#break
	#end
	
	// holder hook
	union { 
		torus { 0.09 0.03 rotate 90*x translate <1.17,0.6,0> }	
		cylinder { <0,0,0><0,0.5,0> 0.03 translate <1.17,0,0> }
 		texture { T_Copper_3A }
 	}		
}	

// swinging balls //////////////////////////////////////////////////////////////////////////////////

#declare SwingPath = array[211] {90.00000,88.89236,85.59596,80.19199,72.81348,63.64213,52.90374,40.86273,27.81559,14.08355,0.00473,-14.07418,-27.80657,-40.85429,-52.89608,-63.63542,-72.80791,-80.18768,-85.59304,-88.89088,-90.00000,-88.89310,-85.59743,-80.19415,-72.81625,-63.64548,-52.90759,-40.86695,-27.82010,-14.08825,0.00000,14.06527,27.70319,40.49939,52.06507,62.04884,70.14735,76.11453,79.76910,81.00000,79.76984,76.11600,70.14948,62.05158,52.06834,40.50308,27.70720,14.06947,0.00426,-14.06108,-27.69919,-40.49569,-52.06180,-62.04611,-70.14523,-76.11307,-79.76836,-81.00000,-79.77058,-76.11745,-70.15161,-62.05432,-52.07161,-40.50677,-27.71120,-14.07366,0.00000,14.04627,27.55277,40.00047,50.91102,59.86515,66.51878,70.61622,72.00000,70.61695,66.52023,59.86726,50.91370,40.00362,27.55627,14.04999,0.00379,-14.04256,-27.54927,-39.99731,-50.90834,-59.86306,-66.51733,-70.61547,-72.00000,-70.61770,-66.52168,-59.86937,-50.91638,-40.00677,-27.55977,-14.05370,0.00000,14.01859,27.33425,39.27930,49.25479,56.76052,61.42014,63.00000,61.42088,56.76197,49.25687,39.28191,27.33725,14.02182,0.00331,-14.01536,-27.33127,-39.27672,-49.25274,-56.75909,-61.41941,-63.00000,-61.42161,-56.76338,-49.25889,-39.28444,-27.34017,-14.02499,0.00000,13.97600,26.99959,38.18326,46.76490,52.15969,54.00000,52.16042,46.76632,38.18528,27.00205,13.97875,0.00284,-13.97326,-26.99712,-38.18125,-46.76348,-52.15895,-54.00000,-52.16116,-46.76774,-38.18729,-27.00451,-13.98149,0.00000,13.90554,26.44995,36.40535,42.79725,45.00000,42.79798,36.40674,26.45187,13.90780,0.00237,-13.90328,-26.44804,-36.40395,-42.79652,-45.00000,-42.79871,-36.40813,-26.45379,-13.91005,0.00000,13.77638,25.45551,33.25939,36.00000,33.26012,25.45685,13.77814,0.00189,-13.77464,-25.45417,-33.25866,-36.00000,-33.26084,-25.45819,-13.77989,0.00000,13.49980,23.38245,27.00000,23.38316,13.50103,0.00142,-13.49856,-23.38174,-27.00000,-23.38387,-13.50226,0.00000,12.72775,18.00000,12.72843,0.00095,-12.72708,-18.00000,-12.72910,0.00000,9.00000,0.00047,-9.00000,0.00000}

#declare SwingingBalls =  
union {
	object { FiveBallBaseLeft translate <0,0,-1.8> }
	object { FiveBallBaseRight translate <0,0,1.8> }
	object { FiveBallTopLeft translate <0,6.4,-1.8> }
	object { FiveBallTopRight translate <0,6.4,1.8> }
	// vertical bars
	cylinder { <-3.5,0,-1.8><-3.5,6.7,-1.8> 0.16 texture {T_Chrome_2A} } 
	cylinder { <-3.5,0,1.8><-3.5,6.7,1.8> 0.16 texture {T_Chrome_2A} } 
	cylinder { <3.5,0,-1.8><3.5,6.7,-1.8> 0.16 texture {T_Chrome_2A} } 
	cylinder { <3.5,0,1.8><3.5,6.7,1.8> 0.16 texture {T_Chrome_2A} } 
	// horizontal bars
	cylinder { <3.65,0.25,-1.8><3.65,0.25,1.8> 0.14 texture {T_Chrome_2A} } 
	cylinder { <3.65,6.55,-1.8><3.65,6.55,1.8> 0.14 texture {T_Chrome_2A} } 
	cylinder { <-3.75,0.25,-1.8><-3.75,0.25,1.8> 0.14 texture {T_Chrome_2A} } 
	cylinder { <-3.75,6.55,-1.8><-3.75,6.55,1.8> 0.14 texture {T_Chrome_2A} } 
	// balls
	object { SwingingBall translate <-1.63,6.4,0> }
	object { SwingingBall translate <0,6.4,0> }
	object { SwingingBall translate <1.63,6.4,0> }

	object { MouseTrap scale 1.3 rotate 90*y translate <8.9,0,2.2> }
                                                  
	#switch(BallsRelativeFrame)
		#range(-10000,0)
			object { SwingingBall translate <-3.26,6.4,0> }
			object { SwingingBall rotate 90*z translate <3.26,6.4,0> }
		  // rod holding up ball
  		cylinder { <0,0,0><0,5.2,0> 0.2 texture { T_Wood6 rotate 91*x scale 3 } translate <8.25,0.4,0> }
		#break
		#range(1,200)
			// swing outer balls based on frame
			#if(SwingPath[BallsRelativeFrame]<0)
				object { SwingingBall rotate SwingPath[BallsRelativeFrame]*z translate <-3.26,6.4,0> }
				object { SwingingBall translate <3.26,6.4,0> }
			#else
				object { SwingingBall translate <-3.26,6.4,0> }
				object { SwingingBall rotate SwingPath[BallsRelativeFrame]*z translate <3.26,6.4,0> }
			#end
			#if(BallsRelativeFrame<100)
				// flying rod 
				#declare RodAngle = BallsRelativeFrame*15;
  			cylinder { <0,0,0><0,5.2,0> 0.2
  				texture { T_Wood6 rotate 91*x scale 3 }
  				translate -2.6*y
    			rotate RodAngle*x
    			translate 2.6*y
 					translate <8.25,0.3+(sin(radians(RodAngle/3))*2),-(BallsRelativeFrame*0.65)-0.9>
  			}
 			#end 			
		#break
		#range(101,10000)
			object { SwingingBall translate <-3.26,6.4,0> }
			object { SwingingBall translate <3.26,6.4,0> }
		#break		
	#end
}

// Match /////////////////////////////////////////////////////////////////////////////////////////// 
 
#declare Match =
union {
	// pole
	lathe {
    quadratic_spline 
    6,
    <0,0>,
    <2,0>,
    <1,0.6>,
    <0.3,0.7>
    <0.2,0.8>,
    <0,0.8>
	}         
  cylinder { <0,0,0><0,6,0> 0.10 }
  cylinder { <0,0,0><0,1,0> 0.18 }  
	sphere { <0,6,0> 0.10 }
	// spinner
	union {
  	cylinder { <0,0,0><0,0.3,0> 0.2 texture {T_Silver_4D}}   	
  	cylinder { <-4.3,0,0><2,0,0> 0.1 texture {T_Silver_1B} }
 		// target
  	union { 
  		cylinder { <-0.2,0,0><0.2,0,0> 0.15 } 
  		box { <-0.12,0,-0.1><0.12,1.4,0.1> }	
  		cylinder { <0,0,-0.1><0,0,0.1> 0.8 
  			pigment {
  				spiral2 5
  				  color_map {
  						[ 0.0 color red 1.0 green 0.0 blue 0.0]
  						[ 0.3 color red 0.0 green 0.0 blue 1.0]
  						[ 1.0 color red 1.0 green 1.0 blue 1.0]
  					
						}
  			}
 				translate <0,1.4,-0.05>
 			}
 			pigment {Blue}
 			finish { phong 1 }
  		translate -4*x 
 		}
   	// match
   	union {
  		cylinder { <-0.2,0,0><0.2,0,0> 0.15 texture {T_Brass_5A} } 
   		union {
   			box { <-0.06,0,-0.06><0.06,2,0.06> texture { T_Wood10 rotate 90*x} } 
   			// matchhead
				#switch(frame_number)
					#range(0,max(0,(MatchBurnStartFrame)))
   					sphere { <0,0,0> 0.11 scale <1,1.3,1> pigment { Red }	translate 2*y }
   					sphere { <0,0,0> 0.08 scale <1,1.3,1> pigment { White }	translate 2.12*y }
					#break
					#range(MatchBurnStartFrame,MatchBurnEndFrame+20)
	 					sphere { <0,0,0> 0.11 scale <1,1.3,1> pigment { Orange }	translate 2*y }
						// flame
						union {
							sphere { <0,0,0> 0.40 }
							cone { <0,0,0> 0.4 <0,1.4,0> 0.03 } 		
  						finish { ambient 2 }
							pigment {
								bozo
									color_map {
										[0.0   color Red]
  									[0.33  color Red]
  									[0.55  color Orange]
  									[1.0   color Yellow]
									}
								scale 0.6
								translate <frame_number*7,frame_number*167,frame_number*1223>
							}
							normal { bozo 6}
							scale <0.35,0.55+(sin(frame_number*0.2)*0.08),0.35,>
							rotate 90*z
							translate <-0.12,2,0>	
     				}
					#break
					#range(MatchBurnEndFrame+20,MatchBurnEndFrame+110)
   					sphere { <0,0,0> 0.08 scale <1,1.1,1> pigment { Black }	translate 2*y }
						// smoke
  					merge {
						sphere { <-10,0,0> 3 }
						cone { <-10,0,0> 3 <0,0,0> 1 }
						pigment {  color rgbf <1, 1, 1, 1> }
						finish {
							ambient 0
				 			diffuse 0
						}
						interior {
							media {
								absorption (0.85-((frame_number-(MatchBurnEndFrame+20))/100)*0.85) 
								samples 5
								method 3
								density {
									agate 
									agate_turb 0.5
									scale 2
									turbulence 0.6
									color_map {
										[0.0 color rgb <0.2, 0.2, 0.2>]
										[0.6 color rgb <0.4, 0.4, 0.4>]
										[1.0 color rgb <0.9, 0.9, 0.9>]
									}	
								}	
							}
		 				}
						scale <0.14,0.16,0.16>
						scale 0.5+(0.8*((frame_number-(MatchBurnEndFrame+20))/100)) 
						hollow yes
						translate <0,2,0>
					}	
					#break	
					#else 
   					sphere { <0,0,0> 0.08 scale <1,1.1,1> pigment { Black }	translate 2*y }
					#else
 				#end

				rotate -90*z 			        
   		}	
    	pigment {Green}
  		translate 2*x     	
   	}
   	// collar 
 		cylinder { <0,-0.5,0><0,0,0> 0.15 texture { T_Chrome_3C } }

		// rotate 
		#declare MatchRotateAngle = 10;
		#switch(frame_number)
			#range(0,max(0,(MatchStartFrame-1)))
				#declare MatchRotateAngle = -10;	
			#break
			#range(MatchStartFrame,(MatchStartFrame+MatchRotateFrameCt))
				#declare MatchRotateAngle = -10-(((MatchStartFrame-frame_number)/MatchRotateFrameCt)*20);
			#break
 		#end

		rotate MatchRotateAngle*y  		
   	translate 5*y
	} 	
	// match striker
 	union {
 		cylinder { <0,-0.2,0><0,0.2,0> 0.12 }   	
  	cylinder { <0,0,0><4.6,0,0> 0.1 }
  	union {
  		cylinder { <-0.2,0,0><0.2,0,0> 0.15 }   		
  		box { <-0.04,0,-0.1><0.04,1.2,0.1> }	
  		box { <-0.15,0.8,-0.25><-0.04,1.2,0.25>
  			pigment {
	  			granite	   
  				  color_map {
  						[ 0.0 color Black ]
  						[ 1.0 color Gray50 ]
						} 
					scale 0.1				
  			}
        normal{ dents 0.3 }
  		}
			pigment { DarkGreen }
			finish { phong 1 }  		
     	translate 4.3*x 	
  	}
		pigment { Firebrick }
		finish { phong 1 }
  	translate 4*y
 	}	 	
  texture { T_Copper_3B }
  translate <-1,0,  10 >  
}   
    
// Cannon //////////////////////////////////////////////////////////////////////////////////////////

#declare Cannon_Barrel =
union {
	intersection {
		sphere { <0,0,0> 3 }
		box { <0,-5,-5><5,5,5> }
	}
	difference {
		cone { <0,0,0> 3 <-17,0,0> 1.85 }
	  cylinder { <0,0,0><-19,0,0> 1.4 }
	}
  // axle
  cylinder { <0,0,-5.0><0,0,5.0> 1 translate -3.5*x }  
  // door
  union {
  	cylinder { <0,0,0><2.15,0,0> 2 }
  	sphere { <0.25,0> 0.8
  		translate 2.5*x
  		texture { T_Chrome_2B }	
  	} 
  	translate 0.8*x
  	texture { T_Chrome_1B }
  }
  // door opener
  union {
  	cylinder { <0,0,0><0,3.5,0> 0.2 }
  	sphere { <0,0,0> 0.28 translate 3.5*y }
		rotate -90*x
		translate <2.5,0,0>
  	texture { T_Chrome_1C }
	}  	
  // wick holder
  cylinder { <0,0,0><0,1,0> 0.7
  	translate 2.5*y
   	texture { T_Brass_3A }
  }
	translate 3.5*x
  normal {
    crackle 0.6 
    scale 0.2
	}
	pigment { Black }
  finish { phong 0.2 }
}
                
#declare Cannon_Wheel_Spoke =
	sphere { <0,0,0> 0.32 scale <1,4.5,1> translate 1.90*y 
		texture { T_Wood13 }
		 }

#declare Cannon_Wheel =
union {
	difference {
		union {
			cylinder { <0,0,-0.8><0,0,0.8> 4 }
			// band
	   	cylinder { <0,0,-0.7><0,0,0.7> 4.05 
	   		texture { T_Copper_2A }
	   		normal { agate 0.2 }
	   		finish { Shiny }
	   	}	
		}
		cylinder { <0,0,-0.85><0,0,0.85> 3.1 }
		texture { T_Wood7 rotate 87*y scale 2 }
	}               
	// hub
	cylinder { <0,0,-0.3><0,0,0.3> 0.78
		texture { T_Wood14 }
	}
	// spokes
	#declare SpokeAngle = 0;	
	#while(SpokeAngle < 360)
		object { Cannon_Wheel_Spoke rotate SpokeAngle*z }			
	 	#declare SpokeAngle = SpokeAngle + 36;
	#end 	
}
     
#declare Cannon_Vertical_Holder =
union {     
	box { <0,0,-1><4,5,1> } 	
	cylinder { <2,5,-0.8><2,5,0.8> 1.2 }
}	  		    
     
#declare Cannon_Frame =
union {
	object { Cannon_Vertical_Holder translate <-2,-5,-4> }
	object { Cannon_Vertical_Holder translate <-2,-5,4> }
	box { <0,0,-4><4,2,4> translate <-2,-5,0> }
	// axle
	cylinder { <0,0,-7><0,0,7> 0.50 translate <0,-3,0>
		pigment { Gray60 }
		finish { Shiny }
		normal { crackle 1 } 
	}
  // arm
	box { <0,0,-4><6,1.5,4> translate <0,-5,0> }	
	box { <0,0,-1.3><6,1.5,1.3> rotate -20*z translate <3,-5,0> }	
	box { <0,0,-1.3><3,1.5,1.3> translate <8,-7,0> }	
  sphere { <0,0,0> 0.6 translate <10,-5,0> texture { T_Brass_4A } }
	texture { T_Wood14 }	
}	

#if(WickAngle>180)
	#declare Wick1Angle = 180;
	#declare Wick2Angle = 180+(360-WickAngle);
	#declare WickX = -cos((2*pi*WickAngle)/360)*5-5 ;
 	#declare WickY = -sin((2*pi*WickAngle)/360)*5; 
#else
	#declare Wick1Angle = WickAngle;
	#declare Wick2Angle = 0;
	#declare WickX =  cos((2*pi*WickAngle)/360)*5+10 ;
 	#declare WickY = -sin((2*pi*WickAngle)/360)*5; 
#end                       

#declare Wick =
union {
	#if(WickAngle<180)  
		difference {
			torus { 5 0.1 rotate 90*x }	
			box { <-10,-10,-1><10,0,1> }
			#if(CannonSequenceRelativeFrame>-1)
				#if(WickAngle<140)
					box { <-4.5,-10,-1><10,0,1> rotate Wick1Angle*z }
				#else
					box { <-10,-10,-1><10,0,1> rotate Wick1Angle*z }
				#end
			#end
			rotate 180*x
			translate 10*x
		}
	#end	
	difference {
		torus { 5 0.1 rotate 90*x }	
		box { <-10,-10,-1><10,0,1> }
		box { <-10,-10,-1><10,0,1> rotate Wick2Angle*z }
		rotate 270*y
		translate <5,0,5>
 	}
	#if(frame_number>=CannonSequenceStartFrame)
		// flame
		union {
			sphere { <0,0,0> 0.40 }
			cone { <0,0,0> 0.4 <0,1.4,0> 0.03 } 		
			finish { ambient 2 }
			pigment {
				bozo
				color_map {
					[0.0  color Red]
  				[0.33 color Red]
  				[0.55 color Orange]
  				[1.0  color Yellow]
				}
				scale 0.6
				translate <frame_number*7,frame_number*167,frame_number*1223>
			}
			scale <0.75,0.85+(sin(frame_number*150)*0.25),0.75,>	
			#if(WickAngle>180)
				translate <5,WickY,-WickX>	
			#else
				translate <WickX,WickY,0>	
			#end
		}
	#end		
 	rotate  70*y
 	pigment { Gray70 }
 	normal { spiral1 4, 1.8 scale  0.5 }
} 	

#declare Cannon =
union {
	union {
		object { Cannon_Barrel rotate -10*z } 
  	object { Cannon_Frame}

		#declare CannonShotXOffset = 2.1;
  	#switch (frame_number)
  		#range (0,(CannonShotStartFrame-1))
  			#declare CannonShotXOffset = 0;	
  		#break
			#range (CannonShotStartFrame,(CannonShotStartFrame+10))
				#declare CannonShotXOffset = (frame_number-CannonShotStartFrame)*0.2;
			#break
		#end

		// wheels
 		object { Cannon_Wheel rotate -CannonShotXOffset*30*z translate <0,-3,6> }
		object { Cannon_Wheel rotate -(CannonShotXOffset+152)*30*z translate <0,-3,-6> }
			
		translate CannonShotXOffset*x
	}
	
	#if(frame_number<=CannonShotStartFrame)
		object { Wick rotate -90*y translate <2.8,2.7,-11.2> }
	#else
		// need dummy object to supress 'Only 1 Object in Union' message
		sphere { <0,0,0> 0.01 pigment { rgb<0,0,0> } }
	#end
		  
	#switch(frame_number)
		#range(CannonShotStartFrame,(CannonShotStartFrame+50))
			// smoke
  		merge {
				sphere { <-10,0,0> 3 }
				cone { <-10,0,0> 3 <0,0,0> 1 }
				cylinder { <-1,0,0><4,0,0> 1 }
				pigment { color rgbf <1,1,1,1> }
				finish {
					ambient 0
				 	diffuse 0
				}
				interior {
					media {
						absorption (0.35-((frame_number-CannonShotStartFrame)/50)*0.35) 
						samples 5
						method 3
						density {
							agate 
							agate_turb 0.5
							scale 2
							turbulence 0.6
							color_map {
								[0.0 color rgb <0.2, 0.2, 0.2>]
								[0.6 color rgb <0.4, 0.4, 0.4>]
								[1.0 color rgb <0.9, 0.9, 0.9>]
							}	
						}	
					}
		 		}
				scale 1 
				hollow yes
 				rotate -10*z
				translate <-12,2.3,0>
			}	
  #break
	#end
	translate 7*y 
	scale 0.5
}
  
// Wheel ///////////////////////////////////////////////////////////////////////////////////////////  
  
#declare WheelStand =
union {
	box { <-20,0,-7><22,1,4> texture { T_Wood6 rotate 91*y scale 5 }	}	
	box { <-0.5,0,-0.5><0.5,16,0.5> texture { T_Wood6 rotate  90*x scale 5 }	 }	
	box { <-0.5,0,-0.45><0.5,10,0.45> texture { T_Wood6 rotate 94*x scale 3 }	rotate 30*z translate 5*x }	
	box { <-0.5,0,-0.45><0.5,10,0.45> texture { T_Wood6 rotate  90*x scale 6 }	rotate -30*z translate -5*x }	
  // eye hooks
  torus { 0.4 0.1 rotate 90*z translate <10,1.25,-3.3> texture { T_Copper_5A } }
  torus { 0.4 0.1 rotate 90*z translate <15,1.25,-3.3> texture { T_Copper_5A } }
  torus { 0.4 0.1 rotate 90*z translate <-6.1,0.9,-1.5> texture { T_Copper_5A } }
  torus { 0.4 0.1 rotate 90*z translate <-11,0.9,-1.5> texture { T_Copper_5A } }

	//right end
	box { <16.1,0,-9><22,12.3,4> texture { T_Wood6 rotate 77*x scale 1 }	}	
}	 

#switch(frame_number-PaintStartFrame)
	#range(-10000,0)
		#declare WheelAngle = 120;
	#break
	#range(1,45) 	
		#declare WheelAngle = 120 + ((frame_number-PaintStartFrame)*4);
 	#break
 	#range(46,10000)
 		#declare WheelAngle = 300;
 	#break
#end
 	
#declare Wheel = 
union {
	union {
		difference {
			cylinder { <0,0,-0.5><0,0,0.5> 6 }
			torus { 6, 0.3 rotate 90*x }
		}
		// axle
		cylinder { <0,0,-1><0,0,2> 0.45 pigment { Gray70 } }	
		cylinder { <0,0,-0.75><0,0,2> 0.65 texture { T_Chrome_1A } }	
 	 	// peg
  	union {
  		cylinder { <0,0,0><0,0,-2.5> 0.4 }
  		sphere { <0,0,-2.5> 0.4 }
			pigment { Gray20 }
  		translate 2*x
  	}
   	texture {
   		T_Copper_1A
   		normal { spiral1 1 scale 1 }		 
   	}
 		rotate -WheelAngle*z 
	}
	// string - right
	union {
		cylinder { <cos(((WheelAngle)/360)*2*pi)*2,-sin(((WheelAngle)/360)*2*pi)*2,0><10,-13.6,0> 0.1 } 
		cylinder { <10,-13.6,0><15,-13.6,0> 0.1 } 
		pigment {Gray80 }
		translate <0,0,-2> 
 	}
}

#declare Weight =
union {
	sphere { <0,0,0> 1 }
	// hook
	torus { 0.35 0.1  scale <1,0.8,1> rotate 90*x translate 1*y } 
	// string
	cylinder { <0,1.15,0><0,20,0> 0.1	
		pigment { Goldenrod  }
		normal { spiral1 4, 3.8 scale 0.5 }		
	}		
	texture {	
		pigment { Black }
		finish { Dull} 
  	normal { dents 3 scale .20 }
  }	
}	 
  
// Sprayer //////////////////////////////////////////////////////////////////////////////////////////
  
#declare SprayPaintGreen =
union {
	cylinder { <0,0,0><0,6,0> 1.3 	
		pigment {
  		spiral1 1 
  		  color_map {
  				[ 0.0 color red 0.0 green 1.0 blue 0.0]
  				[ 0.0 color red 0.0 green 1.0 blue 0.0]
  				[ 1.0 color red 1.0 green 1.0 blue 1.0]
  		  } 
  		rotate 90*x 
  		scale <1,2,1>
		}
	}	
	cone { <0,0,0> 1.3 <0,1.1,0> 0.2
		texture { T_Silver_1B }
		translate 6*y
	}
	cylinder { <0,0,0><0,1,0> 0.3 translate 6.6*y pigment { Green } }
}	
  
#declare SprayPaintBlue =
union {
	cylinder { <0,0,0><0,6,0> 1.3 	
		pigment {
  		spiral1 1 
  		  color_map {
  				[ 0.0 color red 0.0 green 0.0 blue 1.0]
  				[ 0.0 color red 0.0 green 0.0 blue 1.0]
  				[ 1.0 color red 1.0 green 1.0 blue 1.0]
  		  } 
  		rotate 90*x 
  		scale <1,2,1>
		}
	}	
	cone { <0,0,0> 1.3 <0,1.1,0> 0.2
		texture { T_Silver_1B }
		translate 6*y
	}
	cylinder { <0,0,0><0,1,0> 0.3 translate 6.6*y pigment { Blue } }
}	
  
#declare SprayPaintRed =
union {
	cylinder { <0,0,0><0,6,0> 1.3 	
		pigment {
  		spiral1 1 
  		  color_map {
  				[ 0.0 color red 1.0 green 0.0 blue 0.0]
  				[ 0.0 color red 1.0 green 0.0 blue 0.0]
  				[ 1.0 color red 1.0 green 1.0 blue 1.0]
  		  } 
  		rotate 90*x 
  		scale <1,2,1>
		}
	}	
	cone { <0,0,0> 1.3 <0,1.1,0> 0.2
		texture { T_Silver_1B }
		translate 6*y
	}
	cylinder { <0,0,0><0,1,0> 0.3 translate 6.6*y pigment { Red } }
}	
  
#declare SprayPaintAll =
union {
	object { SprayPaintGreen }	  
	object { SprayPaintBlue translate 2.8*x }	  
	object { SprayPaintRed translate -2.8*x }	  
}	   
  
#declare Template	=
union { 
	difference {
		box { <-4.8,-2,-0.1><4.8,2,0.1> }	
   	text { ttf "c:\WINDOWS\FONTS\Tubular.ttf","IRTC",1,0 scale 3 translate <-2.95,-1.25,-0.5> pigment {Yellow} }
	}
	// add bar connecting 'island' in "R"
	box { <-1.9,0.25,-0.1><0,0.3,0.1> }		 
	// box around frame
	box { <-4.65,1.5,-0.20><4.65,2.0,.20> texture { T_Wood1 rotate 94*y } }	
	box { <-0.25,0,-0.20><0.25,10,0.20> translate <-4.85,-8,0> texture { T_Wood1 rotate 89*x } }
	box { <-0.25,0,-0.20><0.25,10,0.20> translate <4.85,-8,0> texture { T_Wood1 rotate 91*x } }
  // paper
	box { <-4,-2.0,-0.1><4,2.0,0.1> translate 0.1*z pigment {White} }	 
	texture { T_Copper_1A }		
}	 

#declare PaintMistBlue =
object {
	cone { <-10,0,0> 3 <0,0,0> 1 }
	pigment {  color rgbf <1, 1, 1, 1> }
	finish {
		ambient 0
		diffuse 0
	}
	interior {
		media {
			emission (0.75) 
			samples 5
			method 3
			density {
				agate 
				agate_turb 0.5
				scale 2
				turbulence 0.6
				color_map {
					[0.0 color rgb <0.0, 0.0, 0.0>]
					[0.6 color rgb <0.0, 0.0, 0.6>]
					[1.0 color rgb <0.0, 0.0, 0.9>]
				}	
			}	
		}
	}
	hollow yes
	scale 0.43  
}	
 
#declare PaintMistGreen =
object {
	cone { <-10,0,0> 3 <0,0,0> 1 }
	pigment {  color rgbf <1, 1, 1, 1> }
	finish {
		ambient 0
		diffuse 0
	}
	interior {
		media {
			emission (0.75) 
			samples 5
			method 3
			density {
				agate 
				agate_turb 0.5
				scale 2
				turbulence 0.6
				color_map {
					[0.0 color rgb <0.0, 0.0, 0.0>]
					[0.6 color rgb <0.0, 0.6, 0.0>]
					[1.0 color rgb <0.0, 0.9, 0.0>]
				}	
			}	
		}
	}
	hollow yes
	scale 0.43  
}

#declare PaintMistRed =
object {
	cone { <-10,0,0> 3 <0,0,0> 1 }
	pigment {  color rgbf <1, 1, 1, 1> }
	finish {
		ambient 0
		diffuse 0
	}
	interior {
		media {
			emission (0.75) 
			samples 5
			method 3
			density {
				agate 
				agate_turb 0.5
				scale 2
				turbulence 0.6
				color_map {
					[0.0 color rgb <0.0, 0.0, 0.0>]
					[0.6 color rgb <0.6, 0.0, 0.0>]
					[1.0 color rgb <0.9, 0.0, 0.0>]
				}	
			}	
		}
	}
	hollow yes
	scale 0.43  
}	

#declare Sprayer =
union {
	// string
	cylinder { <0,1.3,0><0,(20.1+(cos(((WheelAngle-30)/360)*2*pi))),0> 0.1 }
	// bar supports
	box { <-0.25,0,-0.20><0.25,10,0.20> translate <2.6,10.5,-4.85> texture { T_Wood1 rotate 89*x } }
	box { <-0.25,0,-0.20><0.25,10,0.20> translate <2.6,10.5,4.85> texture { T_Wood1 rotate 91*x } }
	// bar
	union {
		box { <0,-0.2,-4.75><1,0.2,4.75> }
		box { <0,-0.2,-0.5><3,0.2,0.5> }
		cylinder { <0.2,0,-5.2><0.2,0,5.2> 0.1 texture { T_Silver_1C } } 			
		rotate (cos(((WheelAngle-30)/360)*2*pi)*20)*z 			
		texture { T_Wood1 }
		rotate 180*y
		translate <2.8,20,0> 	 
	}	
	// spaypaint
	object { SprayPaintAll rotate 90*y translate <2.5,12.3,0> }
	// template and frame 
  object { Template rotate 90*y translate <6.5,20,0> }
  // horizontal supports
  box { <0,0,-0.20><3.7,0.5,0.20> translate <2.9,17,-4.85> texture { T_Wood1 rotate 88*y } }
  box { <0,0,-0.20><3.7,0.5,0.20> translate <2.9,17,4.85> texture { T_Wood1 rotate 88*y } }
	// mist 
	#switch(WheelAngle)
		#range(165,255)
			union {
				object { PaintMistBlue translate 2.8*z }
				object { PaintMistGreen }
				object { PaintMistRed translate -2.8*z }
	  		rotate 180*y
  			translate <2,19.8,0>
			}
		#break
	#end		
 	pigment { Gray80 }
}	

// knife ///////////////////////////////////////////////////////////////////////////////////////////

#declare Knife =
union {
	// pole
	lathe {
    quadratic_spline 
    6,
    <0,0>,
    <2,0>,
    <1,0.6>,
    <0.3,0.7>
    <0.2,0.8>,
    <0,0.8>
	}         
  cylinder { <0,0,0><0,8,0> 0.10 }
  cylinder { <0,0,0><0,1,0> 0.18 }  
	sphere { <0,8,0> 0.10 }
	// threads
	#declare SpiralY = 3.2;
	#while(SpiralY<7.5)
		cylinder { <0,0,0><0,0.16,0> 0.17 rotate -22*z translate <-0.04,SpiralY,0> }	
		#declare SpiralY = SpiralY + 0.2;
	#end	
	// stopper
  cylinder { <0,0,0><0,0.5,0> 0.25 translate 2.9*y texture { T_Brass_5E } }  	
	// spinner
	union {
  	cylinder { <0,-0.3,0><0,0.3,0> 0.3 texture { T_Silver_4D } }   	
  	cylinder { <-4,0,0><4,0,0> 0.1 texture { T_Silver_1B } }
  	cylinder { <3.6,0,0><4,0,0> 0.15 pigment { DarkGreen } finish { phong 1 } }
 		// target
  	union { 
  		cylinder { <-0.2,0,0><0.2,0,0> 0.15 } 
  		cylinder { <0,0,-0.1><0,0,0.1> 0.8 
  			pigment {
  				wood 
  				  color_map {
  						[ 0.0 color red 1.0 green 0.0 blue 0.0]
  						[ 0.5 color red 2.0 green 2.0 blue 2.0]
  						[ 1.0 color red 1.0 green 0.0 blue 0.0]
						}
  			}
 				translate <0,0,-0.05>
 			}
 			pigment { Gray20 }
 			finish { phong 1 }
  		translate -3.7*x 
  	}
 	  // knife
 	  union {
 	  	// handle
 	  	union {	
 	  		cylinder { <0,0,-0.1><0,0,0.1> 0.25 }
				box { <-0.25,0,-0.1><0.25,-1.25,0.1> } 	  	
 	  		texture { T_Wood4 scale 3 }
 	  	}
 	  	// blade
 	  	intersection {
 	  		cylinder { <0,0,-0.02><0,0,0.02> 2 scale <0.2,1.1,1> }
 	  		box { <0,0,-10><10,10,10> }
 	  		rotate 180*z
 	  		translate <0.2,-1.25,0>
 	  	  texture { T_Silver_1A }
 	  	}
 	  	rotate -90*y
			translate <3.8,0,0>
 	  }
		#declare RelativeFrame = frame_number-KnifeStartFrame;
 	  #switch(RelativeFrame)
 	  	#range(-10000,0)
				translate 7.5*y
				rotate  0*y
			#break
 	  	#range(0,70)
				translate (7.5-(RelativeFrame*0.055))*y
				rotate  RelativeFrame*(20+(RelativeFrame/12))*y
			#break
 	  	#range(70,10000)
				translate (7.5-(70*0.055))*y
				rotate  0*y
			#break
  	#end
	}
 	#switch(RelativeFrame)
 		#range(0,8)
			object {
				sphere { <0,0,0> 3 }
				pigment {  color rgbf <1, 1, 1, 1> }
				finish {
					ambient 0
					diffuse 0
				}
				interior {
					media {
						emission (0.55-(RelativeFrame*0.065)) 
						samples 5
						method 3
						density {
							agate 
							agate_turb 0.5
							scale 2
							turbulence 0.6
							color_map {
								[0.0 color rgb <0.0, 0.0, 0.0>]
								[0.6 color rgb <0.4, 0.4, 0.4>]
								[1.0 color rgb <0.8, 0.8, 0.8>]
							}	
						}	
					}
				}
				hollow yes
				scale (0.2+(RelativeFrame/15)) 
				translate <-3.7,7.3,-1> 
			}	
		#break
	#end		
  texture { T_Copper_3B }
}	

#declare Sign =	
union {
	box { <-3.5,-1.75,0.1><3.5,1.75,0> pigment { rgb<1,1,1> }	finish {ambient 1 } }
  text { ttf "c:\WINDOWS\FONTS\Tubular.ttf","IRTC",1,0 scale <3,3,0.1> translate <-2.98,-1.15,-0.02>
		pigment { 
			gradient x 
			frequency  1
			phase 0.45   
      color_map {
        [0.00 color rgb <1.0,0.0,0.0> ]
        [0.5 color rgb <0.0,1.0,0.0> ]
        [1.00 color rgb <0.0,0.0,1.0> ]
      }
      scale 7 
		}
		finish { ambient 1 }
	}
}		 	 
 	 
#declare KnifeWheelSprayer =  
union {
	object { WheelStand translate 1.5*z }
  object { Wheel translate 15*y}
	// lower weight
  intersection {
  	object { Weight translate <5.9,10.2-((WheelAngle-120)/180*8),0> }
   	box { <-5,0,-5><15,15,5> pigment { rgb<0,0,0> } }
  }
	// broken string
	cylinder { <-11.2,0,0><-9.5,0,0> 0.1 pigment { Gray80 } translate <0,1.05,0> }
	#if(WheelAngle<170)
		cylinder { <-9.5+(((WheelAngle-120)/50)*3.5),0,0><-5.85,0,0> 0.1 pigment { Gray80 } translate <0,1.05,0> }
	#end
	cylinder { <0,14.85,0><0,max(0,((WheelAngle-170)/170)*12),0> 0.1 pigment { Gray80 } translate <-5.9,1.15,0> }
 
  object { Sprayer translate <15.1,0,-2> }
	object { Knife scale 1.5 translate <-15.2,1,0> } 
	// sign
 	#switch(SignRelativeFrame)
 		#range(1,45)
 	  	object { Sign rotate 90*y translate < 21.9,19.8,-3-((SignRelativeFrame/45)*14)> } 
		#break		 	  
 		#range(46,90)
 	  	object { Sign rotate 90*y translate < 21.9-((min(SignRelativeFrame,90)-45)*0.88),19.8,-17> }
   	#break
   	#range(91,150) 
 	 		object { box { <-100,-100,-0.1><100,100,0> rotate 90*y translate <-17,0,-70> pigment { rgbt<0,0,0,max(0,1-((SignRelativeFrame-91)/40))> } } }
 	  	object { Sign rotate 90*y translate <21.9-((min(SignRelativeFrame,90)-45)*0.88),19.8,-17> } 
   	#break
	#end
  rotate    0*y
  translate <8,3,25>
}
 
// Room //////////////////////////////////////////////////////////////////////////////////////////// 
 
#declare Floor =
union {
	#declare BoardWidth = 3;
	#declare Xpos = -120;
	#while(Xpos<120)
		box { <0,0,-120><(BoardWidth*0.95),-1,120>
			texture { T_Wood14
				rotate (87+(6*rand(R1)))*y
				translate <(rand(R1)*5),(rand(R1)*2),(rand(R1)*5)> 
				scale 50+(rand(R1)*4)
		} 
	 		translate Xpos*x
	 	}
		#declare Xpos = Xpos + BoardWidth;
	#end
	box { <-120,-1,-120><120,-0.4,120> pigment { Brown } } 
}
				 					
#declare Wall =
union {
	box { <-120,0,-3><120,100,3> pigment { color rgb<0.4,0.4,1.0> } }
  // floor board
  union {
  	box { <-120,0,-4><120,3,-2> }
  	cylinder { <-120,0,0><120,0,0> 1 translate <0,3,-3> }
   	pigment { color <0.7,0.8,0.8> }
  }
  // molding
  union {
  	cylinder { <-120,0,0><120,0,0> 4 } 
  	cylinder { <-120,0,0><120,0,0> 1 scale <1,4.7,1.1> translate <0,-2,0> } 
  	cylinder { <-120,0,0><120,0,0> 1 scale <1,4.7,1.1> rotate 90*x translate <0,0,-2> } 
   	pigment { color <0.7,0.8,0.8> }
    translate <0,100,-3> 
  }
}     

#declare Photo1 =
union {
	box { <0,0,0><1,1,1>
		pigment { image_map { jpeg "woods6.jpg" }	}
		scale <30,22,1>
		translate <-15,-11,0>
	}
	// frame
	box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 89*z scale 20 } translate 12.5*y}
	box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 91*z scale 20 } translate -12.5*y}
	box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate 90*y scale 18 } translate -16.5*x}
	box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate -91*y scale 19 } translate 16.5*x}
}

#declare Photo2 =
union {
	box { <0,0,0><1,1,1>
		pigment { image_map { jpeg "woods5.jpg" }	}
		scale <30,22,1>
		translate <-15,-11,0>
	}
	// frame 
	box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 89*z scale 20 } translate 12.5*y}
	box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 91*z scale 20 } translate -12.5*y}
	box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate 90*y scale 18 } translate -16.5*x}
	box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate -91*y scale 19 } translate 16.5*x}
}	

#declare Photo3 =
union {
	box { <0,0,0><1,1,1>
		pigment { image_map { jpeg "woods3.jpg" }	}
		scale <30,22,1>
		translate <-15,-11,0>
	}
	// frame 
	union {
		box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 89*z scale 20 } translate 12.5*y}
		box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 91*z scale 20 } translate -12.5*y}
		box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate 90*y scale 18 } translate -16.5*x}
		box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate -91*y scale 19 } translate 16.5*x}
		rotate 180*z
	}	
}

#declare Photo4 =
union {
	box { <0,0,0><1,1,1>
		pigment { image_map { jpeg "woods2.jpg" }	}
		scale <30,22,1>
		translate <-15,-11,0>
	}
	// frame 
	union {
		box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 89*z scale 20 } translate 12.5*y}
		box { <-18,-1.5,-1><18,1.5,1> texture { T_Wood14 rotate 91*z scale 20 } translate -12.5*y}
		box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate 90*y scale 18 } translate -16.5*x}
		box { <-1.5,-14,-1><1.5,14,1> texture { T_Wood14 rotate -91*y scale 19 } translate 16.5*x}
		rotate 180*z
	}	
}

#declare Room =  
union {
	object { Floor rotate 90*y }
	object { Wall rotate 0*y translate 120*z}
	union {
		object { Wall  rotate -180*y }
	 	object { Photo1 translate <45,60,5> }
	 	object { Photo3 translate <-45,60,5> }
		translate -120*z
	}
	union {
		object { Wall } 
	 	object { Photo2 translate < -45,60, -5> }
	 	rotate -90*y 
		translate -100*x
	}
	// wall with door
	union {
		difference { 
			object { Wall }
		 	box { <-20,0,-4.35><20,80,4.35> }
		}
		// door frame
		box { <-1.5,0,-3.75><1.5,78,3.75> translate -20*x }
		box { <-1.5,0,-3.75><1.5,78,3.75> translate 20*x }
		box { <-21,78,-3.75><21,82,3.75> } 
		cylinder { <0,0,-4.25><0,0,4.25> 2.75 translate <20,80,0> }
		cylinder { <0,0,-4.25><0,0,4.25> 2.75 translate <-20,80,0> }
	  // door
	  box { <-18.5,0,-4><18.5,77.95,0> pigment { color <0.2,0.2,0.8> } } 
	  // doorknob
	  sphere { <0,0,0> 1.8 scale <1,1,0.7> texture { T_Brass_3C } translate <15.5,38,-5> }
	  // lightswitch
	  union
	  {
	  	superellipsoid { <0.3,0.1> scale <2.5,3.5,1> }
	  	box { <-0.4,0,-0.4><0.4,3,0.4> rotate -45*x pigment { Gray70 } }
	  	translate <27, 46, -3.0> 		
	  	pigment { Tan }
	  }	
		// hinges
		cylinder { <0,-2,0><0,2,0> 0.7 texture { T_Copper_1B } translate <-18.5,70,-4.75> }
		cylinder { <0,-2,0><0,2,0> 0.7 texture { T_Copper_1B } translate <-18.5,39,-4.75> } 
		cylinder { <0,-2,0><0,2,0> 0.7 texture { T_Copper_1B } translate <-18.5,8,-4.75> } 
  	// photos 
		object { Photo4 translate <65,60,-4> }
		pigment { color <0.7,0.8,0.8> } 
    rotate 90*y
    translate 100*x
	}
}	 
     
#declare Ceiling =
union {
	box { <-120,0,-120><120,0,120> pigment { color <0.7,0.8,0.8> } finish { ambient 0.7 } }
	// lights
	union { 
		cylinder { <0,0,0><0,30,0> 0.75 texture { T_Chrome_5A } }
		sphere { <0,0,0> 4 pigment { color <0.9,0.9,0.7> } finish { ambient 1.25 } } 
		light_source { 0*x color rgb <1,1,1> translate -5*y }
		translate <-30,-20,0> 
		no_shadow 
	}			
	union { 
		cylinder { <0,0,0><0,30,0> 0.75 texture { T_Chrome_5A } }
		sphere { <0,0,0> 4 pigment { color <0.9,0.9,0.7> } finish { ambient 1.25 } } 
		light_source { 0*x color rgb <1,1,1> translate -5*y }
		translate <30,-20,0>
		no_shadow  
	}
	translate 99*y	
}
  
#declare Table =
union {
	// table top
	#declare TableTopZ = -27;
	#while(TableTopZ<27)
		box { <-34,46,TableTopZ><34,48,TableTopZ+5.95>
			texture {
				T_Wood34
				scale 45
			 	rotate (88+rand(R1)*4)*y translate (rand(R1)*45)*z 
			}				
		}
		#declare TableTopZ = TableTopZ + 6;
	#end
	// legs
	box { <-2.0,0,-2.0><2.0,46,2.0> texture { T_Wood34 scale 5 rotate 90*x translate 10*y } translate <-28,0, 23> }
	box { <-2.0,0,-2.0><2.0,46,2.0> texture { T_Wood34 scale 9 rotate 90*x translate 20*y } translate <-28,0,-23> }
	box { <-2.0,0,-2.0><2.0,46,2.0> texture { T_Wood34 scale 2 rotate 90*x translate  0*y } translate < 28,0, 23> }
	box { <-2.0,0,-2.0><2.0,46,2.0> texture { T_Wood34 scale 4 rotate 90*x translate 40*y } translate < 28,0,-23> }
	// leg supports
	box { <-29,0,-1><29,5,1> texture { T_Wood34 scale 18 rotate 90*y translate 30*z } translate <0,22,-23> }
	box { <-29,0,-1><29,5,1> texture { T_Wood34 scale 15 rotate 90*y translate 20*z } translate <0,22,23> }
	box { <-1,0,-24><1,3,24> texture { T_Wood34 scale 13 rotate 90*z translate 20*z } translate <28,32,0> }
	box { <-1,0,-24><1,3,24> texture { T_Wood34 scale 16 rotate 90*z translate 20*z } translate <-28,32,0> }
}
 	 
// Scene /////////////////////////////////////////////////////////////////////////////////////////// 	
   
union {
	union {
		union {
			object { DishRampBouncer } 
			object { SwingingBalls translate <-26,0,-2.7> }
			union {
				object { Match } 
				object { Cannon rotate 180*y translate <11.5,0,6.2>} 	
  	 	 	rotate -90*y
 		 		translate <-25.9,0,2.3>
			}	
			object { KnifeWheelSprayer translate <-18.1,-3,25> }
			no_shadow
			translate <12,32,-25>
		}
		object { Table rotate 90*y translate -16*y }
	 	translate <0,0,60> 
	} 
	union {
		object { Room rotate 180*y }
 		object { Ceiling }
	}
	light_source {
		0*x
		color rgb <1,1,1>
		fade_distance 30
		fade_power 1  
	 	translate <0,55,-100>
	}
}	

// Camera ////////////////////////////////////////////////////////////////////////////////////////// 

#declare ZoomRate = 1.9;
#switch (frame_number)
	#range(1,50) 
		// zoom woth logo
		camera {
  		location  <0,38,-90+(frame_number*ZoomRate)>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <0,38,30>
		}
		// logo
		union {
			text { ttf "c:\WINDOWS\FONTS\JANIHB__.ttf","Spray Paint",0,0 scale <3,3,0.1> translate <-8,38,-70+(frame_number*ZoomRate)> }
			text { ttf "c:\WINDOWS\FONTS\JANIHB__.ttf","Mark Murphy    2002",0,0 scale <1.3,1.3,0.1> translate <-6,33,-70+(frame_number*ZoomRate)> }
			pigment { rgbt<1,1,0,min(1,(frame_number/40))> }
			finish { ambient 3 }	
		}		
	#break
	#range(51,60)
		// pause  
		camera {
  		location  <0,38,5>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <0,38,30>
		}
	#break
	#range(61,140)
		// rotate over dish  
		camera {
  		location  <max(13,(30-(18*((frame_number-60)/30)))),58,35>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <12,48,35>
		}
	#break
	#range(141,260)
		// watch ball on track  
		camera {
  		location  <12,47,50>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <12,43,35>
		}
	#break
	#range(261,300)
		// static view of bouncing ball  
		camera {
  		location  <0.7,40,12>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <0.7,37,35>
		}
	#break
	#range(301,326)
		// rotating view of ball/mousetrap/swinging balls  
		camera {
  		location  <0.7,40,12>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <0.7-((frame_number-301)*0.5),37,35>
		}
	#break
	#range(327,362)
		// match and cannon 
		camera {
  		location  <-10,40,42>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <-26,35,35>
		}
	#break
	#range(363,403)
		// pivot view behind cannon
		// location <-10,40,42> --> <-17,40,31.5>
		// look_at <-26,35,35> --> <-20,38,55> 	      
		#declare Ratio = (frame_number-363)/40;
		camera {
  		location  <-10-(Ratio*7),40,42-(Ratio*10.5)>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <-26+(Ratio*6),35+(Ratio*3),35+(Ratio*20)>
		} 
///
		union {
			text { ttf "c:\WINDOWS\FONTS\JANIHB__.ttf","Spray Paint",0,0 scale <3,3,0.1> }
			text { ttf "c:\WINDOWS\FONTS\JANIHB__.ttf","Mark Murphy",0,0 scale <1.4,1.4,0.1> 
				translate <-7.5,-5.2,0>	}
			text { ttf "c:\WINDOWS\FONTS\JANIHB__.ttf","2002",0,0 scale <1.4,1.4,0.1> 
				translate <-6.0,-7.2,0>	}
			pigment { rgb<1,1,0> }
			finish { ambient 3 }
			no_shadow 
			scale 0.40
			rotate -20*y	
	translate <-21.5,39.7,45>
		}		
///
	#break      
	#range(404,434)
		// cannon firing 
		camera {
  		location  <-17,40,31.5>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <-20,38,55>
		}
	#break
	#range(435,530)
		// wheel/spraypaint 
		camera {
  		location  <7,46,37>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <7,46,55>
		}
	#break
	#range(531,680)
		// sign
		camera {
  		location  <-25,51.8,68>
  		direction 1.5*z
  		right     x*image_width/image_height
  		look_at   <100,51.8,68>
		}
	#break
#end		                          