#include "devmath.inc"
#include "ship4.pov"
#include "ship2.pov"
#include "terrain.pov"

global_settings{max_trace_level 7}

#declare Clock=clock*0.8;

#declare ShipPos=z*3000+x*350000+x*60000*Clock
#declare Ship1Rot=<0,0,0>;
#declare Ship2Rot=<0,0,0>;   
#declare ShotPos=0
#switch(Clock)
	#range(0.2,1)
		#declare ShotPos=(Clock-0.2)*60000
  #break
#end 


#declare GoodShipRot=<45,0,0>;
#declare GoodShipHeading=-<0,0,0>*Clock;							//It is probably unnecessary to break 
																 											//this into two variables, 
#declare GoodShipPos=	x*60000*Clock+<330000,6000,3000>//but I don't know any matrix math,
																 											//so this is simpler.

#switch(Clock)
	#range(0,0.4)
		#declare GoodShipPos=GoodShipPos+x*3000*(Clock/0.4)-y*Smooth(Clock/0.4)*4000;
		#declare GoodShipRot=x*(45-90*Smooth(Clock/0.4));
		#declare GoodShipHeading=Smooth(Clock/0.2)*-30*z;
	#break
	#range(0.4,1.01)
		#declare GoodShipPos=GoodShipPos+x*3000-y*4000
													+y*20000+vrotate(y*-20000,z*90*(Clock-0.4)/0.6)*<0.7,1,1>;
		#declare GoodShipRot=x*-45;
		#declare GoodShipHeading=z*90*(Clock-0.4)/0.6;
#end

#declare FireTime1=0.4;
#declare FireTime2=0.5;
#declare FireTime3=0.6;

#declare FireDelay=0.1;

#switch(Clock)
	#range(FireTime1,FireTime1+FireDelay)
		cylinder{
			GoodShipPos-z*150,ShipPos+<-3000,3000,0>
			100
			pigment{rgbt 1}
			hollow
			interior{
				media{
					emission rgb<0.005,0.03,0.005>*0.07
				}
			}
		}	
	#break
	#range(FireTime2,FireTime2+FireDelay)
		cylinder{
			GoodShipPos-z*150,ShipPos+<0,6000,0>
			100
			pigment{rgbt 1}
			hollow
			interior{
				media{
					emission rgb<0.005,0.03,0.005>*0.07
				}
			}
		}	
	#break
	#range(FireTime3,FireTime3+FireDelay)
		cylinder{
			GoodShipPos-z*150,ShipPos+<-3000,9000,0>
			100
			pigment{rgbt 1}
			hollow
			interior{
				media{
					emission rgb<0.005,0.03,0.005>*0.07
				}
			}
		}	
	#break
#end		

// Don't Ask.  Really.  Don't.
camera
{
// (camera types)
//  perspective (default) | orthographic | fisheye |
//  ultra_wide_angle | omnimax | panoramic | cylinder 1
  location  <0.0, 1.0, -6.0> // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
//  sky       y                // rarely used
  up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
//  angle FLOAT                // overrides "direction" with specific angle
//  normal { ripples 0.2 }     // perturb the camera lens with a pattern
// (focal blur extras)
//  aperture 0.2               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point <VECTOR>       // x,y,z point that is in focus
}


camera{
	location <290000,3000,20000>+x*60000*Clock
	sky z
	up        1/2*y    
  right     2/3*x
	look_at ShipPos-x*15000+y*4000
}

/*camera{
	location <320000,3000,10000>+x*60000*Clock
	sky z
	look_at ShipPos-x*15000+y*8000
}*/

//Explosion
#macro explosion(size) 
sphere{
	0,20
	pigment{rgbt<0,0,0,1>}
	//finish{ambient 10}
	hollow
	interior{
		media{
			density{
				spherical                
				warp{turbulence 0.5 lambda 1.01}
				scale <10,10,10>
				warp{turbulence 2 octaves 9 lambda 2 omega 0.6}
				//warp{turbulence 4 octaves 0 lambda 0 omega 0}
				rotate x*-45
				//rotate z*clock*360
				translate <0,0,0>
				color_map{
					[0 	 rgb<0,0,0>*0.005]
					[0.1 rgb<0.5,0.2,0>*0.005]
					[0.5 rgb<0.5,0,0.2>*0.005]
					[1   rgb<0.5,0.2,1>*0.005]
				}	
			}
			emission rgb<0.5,0.5,0.5>
		}
	}
	scale 750*size
}
#end


union{
	union{
		union{
		object{
			sfod
			rotate Ship1Rot
		}
		#switch(Clock)
			#range(FireTime2,2)
				object{explosion(Clock-FireTime2)}
				rotate <735*(Clock-FireTime2),
								234*(Clock-FireTime2),
								-464*(Clock-FireTime2)>
				translate z*(10000*(Clock-FireTime2)
							-20000*pow((Clock-FireTime2),2))
			#break
		#end
		}		
				
		union{	
		object{
			sfod                    
			rotate Ship1Rot
		}
		#switch(Clock)
			#range(FireTime3,2)
				object{explosion(Clock-FireTime3)}
				rotate <424*(Clock-FireTime3),
								-887*(Clock-FireTime3),
								-234*(Clock-FireTime3)>				
				translate z*(12000*(Clock-FireTime3)
							-20000*pow((Clock-FireTime3),2))
			#break
		#end
		translate <-3000,3000,0>
		}
		
		
		union{
		object{
			sfod          
			rotate Ship1Rot
		}
		#switch(Clock)
			#range(FireTime1,2)
				object{explosion(Clock-FireTime1)}
				rotate <-654*(Clock-FireTime1),
								142*(Clock-FireTime1),
								-412*(Clock-FireTime1)>				
				translate z*(5000*(Clock-FireTime1)
							-20000*pow((Clock-FireTime1),2))
			#break
		#end
		translate <-3000,-3000,0>
		}
		
		
		translate y*6000
	}
	union{
		object{
			sfod
			rotate Ship2Rot
		}
	
		object{
			sfod                    
			rotate Ship2Rot
			translate <-3000,3000,0>
		}
		
		
		object{
			sfod          
			rotate Ship2Rot
			translate <-3000,-3000,0>
		}
		translate y*-6000
	}
  translate ShipPos
	//rotate z*180
}

object{
	ship2(1,0,0,1)
	rotate GoodShipRot
	rotate GoodShipHeading
	translate GoodShipPos
}	

