//#version unofficial MegaPov 0.7;


#ifndef( Winter )
#declare Winter = false;
#end

#declare ClearTexture = texture {
	pigment { color rgbf 1 }
}

#local BrownLevel = 0;
#if( MasterClock >= FirstMorphStartsAt )
	#local BrownLevel = Timer( MasterClock, FirstMorphStartsAt, FirstMorphDoneAt, true );
#end
#declare Rock = texture {
	pigment {
		wrinkles
		color_map {
		 	[ 0.1 rgb 0.3 ]
			[ 0.9 rgb <0.5,0.45,0.45> ]
		}
	}
	normal {
		granite 0.2
		bump_size 0.75
		scale 0.1 
	}
	finish {
		specular 0.05
		roughness 0.8
	}
}
texture {
	pigment {
		bozo
		color_map {
			[ 0.4-0.4*BrownLevel rgbf 1 ]
		 	[ 0.5-0.4*BrownLevel rgbft <0.3,0.075,0, 0.49975,0.75> ]
		 	[ 0.5 rgbft <0.3,0.075,0, 0.49975,0.5> ]
		 	[ 0.5+0.4*BrownLevel rgbft <0.3,0.075,0, 0.49975,0.75> ]
			[ 0.6+0.4*BrownLevel rgbf 1 ]
		}
		turbulence 0.5
		scale 6
	}
}

#declare GreenGrass = texture {
	pigment {
		granite
		color_map {
			[ 0.33 rgbf <0,0.25,0,0> ]
			[ 0.66 rgbf <0,0.75,0,0> ]
		}
		scale <1,1,4>
		rotate y*45
	}
	normal {
		granite 0.3
		bump_size 0.5
		scale <1,1,4>
		rotate y*45
	}
	finish {
		specular 0.3
		roughness 0.3
	}
	scale 0.01
}	

#declare DeadGrass = texture {
	pigment {
		granite
		color_map {
			[ 0.33 rgb <0.309987, 0.295872, 0.027909> ]
			[ 0.66 rgb <0.465858, 0.499992, 0.295003> ]
		}
		scale <1,1,4>
		rotate y*45
	}
	normal {
		granite 0.3
		bump_size 0.5
		scale <1,1,4>
		rotate y*45
	}
	finish {
		specular 0.3
		roughness 0.3
	}
	scale 0.01
}	
	
#declare Soil = texture {
	pigment {
		granite
		color_map {
			[ 0.33 rgb <0.366522, 0.158358, 0.066026> ]
			[ 0.66 rgb <0.447730, 0.277165, 0.179828> ]
		}
		scale <1,1,4>
		rotate y*45
	}
	normal {
		granite 0.3
		bump_size 0.6
		scale <1,1,2>
		rotate y*22.5
	}
	finish {
		specular 0.1
		roughness 0.3
	}
	scale 0.02
}	
	
#declare Snow = texture {
	pigment {
		rgbf <1,1,1,0> //<0.882994, 0.870008, 1.000000>	
	}
	normal {
		granite 0.5 bump_size 0.4
		scale 0.1
	}
	finish {
		diffuse 0.8
		ambient <0,0.1,0.2>
		specular 0.7 roughness 0.05
	}
}	
	
#declare Grass = texture { DeadGrass  }
#if( MasterClock >= SpringStartsAt )
	#declare Grass = texture { Soil }
	#local GrassClock = Timer( MasterClock, SpringCompleteAt, SummerInFullBloomAt, true );
	#declare Grass = texture { 
		average
		texture_map {
			[ (1-GrassClock) Soil  ]
			[ GrassClock GreenGrass  ]
		}
	 }
#end

#ifndef( SnowBlanketClock )
#declare SnowBlanketClock = 0;
#end
#if( Winter )
#declare Grass = texture {
	bozo
	texture_map {
		[ 0 Grass ]
		[ (1-SnowBlanketClock)*0.9 Grass  ]
		[ (1-SnowBlanketClock) Snow  ]
		[ 1 Snow ]
	}
	scale 0.5
}
#end

#declare Vege2Rock =
texture {
	slope { -y, 0, 0.5 }
	texture_map {
		[ 0.4 Grass ]
		[ 0.65 Rock ]
	}
}	

#declare Rock2Snow =
texture {
	slope { -y, 0, 0.5 }
	texture_map {
		[ 0.6 Snow ]
		[ 1 Rock ]
	}	
}

#declare Snow2Rock =
texture {
	slope { -y, 0, 0.5 }
	texture_map {
		[ 0.3 Snow ]
		[ 0.85 Rock ]
	}
}	
#ifndef( WinterClock )
	#debug "\nNo WinterClock set!"
	#declare WinterClock = 0;
#end
#declare VegeLevel = 0.45+(0.5*WinterClock);
#declare RockCreepClock = Timer( WinterClock, 0, 0.5, true );

#declare SnowLevel = 0.7-(0.1*RockCreepClock);

#if( MasterClock > SpringStartsAt )
	// Rock creeps backwards here..
	#declare RockCreepLock = 1-RockCreepClock;
//	#declare SnowLevel = 0.7-(0.1*RockCreepClock);
	#declare SnowLevel = 1-0.4*(1-RockCreepClock); // Starts from 0.6, ends up at 1... I hope
#end

#declare TestiTex = texture {
	gradient y 
	texture_map {
//		#if( Winter )
//		[ 0.5 Snow2Rock ]
//		[ 0.6 Rock2Snow ]
//		#else
		[ VegeLevel Vege2Rock ]	// 0.45
		[ 0.55+(0.05*RockCreepClock) Rock ]				// 0.55
		[ 0.65-(0.05*RockCreepClock) Rock ]				// 0.65
		[ SnowLevel Rock2Snow ]		// 0.7
//		#end
	}
	turbulence 0.15
}
#declare SummerTex = texture {
	gradient y 
	texture_map {
//		#if( Winter )
//		[ 0.5 Snow2Rock ]
//		[ 0.6 Rock2Snow ]
//		#else
		[ 0.45 Vege2Rock ]	// 0.45
		[ 0.55 Rock ]				// 0.65
//		#end
	}
	turbulence 0.05
}
#if( MasterClock >= SpringStartsAt )
	#declare TestiTex = texture
	{
		average
		texture_map {
			[ WinterClock TestiTex ]
			[ 1-WinterClock SummerTex ]
		}
	}
#end

#macro Cloud( Size, TextureTrans ) 

#ifndef( CloudIntensity )
#local CloudIntensity = 0.8;
#end
#ifndef( CloudDensity )
#local CloudDensity = 0.6;
#end
#ifndef( CloudPatternScale )
#local CloudPatternScale = <1,1,1>;
#end

#local CloudBase = density {
	bozo
	color_map {
		[ 1-CloudDensity rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]	//black
		[ 1.000 rgbft <CloudIntensity, CloudIntensity, CloudIntensity, 0.0, 0.0> ]	//white
	}
	turbulence 2.5
	scale CloudPatternScale
}
#local CloudClear = density {
	rgb 0
}
box {
	<-2,-2,-2> <2,2,2>
	material {
		texture { 
			pigment { 
				color rgbf 1
			}
		}
		interior {
			media {
				scattering {
					2	//isotropic_scattering
					rgb <0.25, 0.25, 0.25>
					extinction 1.0
			 	}
				absorption rgb 0.15
				emission rgb 0.2
				density {
					spherical
					density_map {
						[ 0.00 CloudClear ]	//black
						[ 0.400 CloudBase scale 1/Size translate TextureTrans ]	//white
					}
				}
				intervals 2.0
				samples 5,  5
				confidence 0.9
				scale 2
			}
		}
	}
	hollow
	no_shadow
	scale Size
}
#end

#declare Bark = texture {
	pigment {
		gradient y
		color_map {
			[ 0 rgbf <0.309987, 0.124590, 0.024811,0> ]
			[ 1 rgbf <0.519997, 0.308354, 0.135210,0> ]
		}
	}
	normal {
		crackle 0.9
		bump_size 0.5
		scale 0.2
	}	
	finish {
		specular 0.1
		roughness 0.1
	}
}

#declare TreeTextureBase = 
texture {
	#if( Winter )
	slope y
	texture_map {
		[ 0 GreenGrass ]
		[ 0.65 GreenGrass ]
		[ 0.8 Snow ]
	}
	#else
	GreenGrass
	#end
}

#declare TreeTexture =
texture {
	granite 
	texture_map {
		[ 0.375 ClearTexture ]
		[ 0.4 TreeTextureBase ]
	}
	scale 0.5
}

// The Tree macro stuff starts here
#declare TreeTop =
lathe {
	bezier_spline
	8, 
	<0.64331, -0.00000>,
	<0.61783, 0.18590>,
	<0.32484, 0.21795>,
	<0.22293, 0.45513>,
	<0.22293, 0.45513>,
	<0.12075, 0.69293>,
	<0.14013, 0.80128>,
	<0.00000, 1.00000>
	sturm
}

#ifndef( TreeScale )
#declare TreeScale = 1;
#end
#ifndef( TreeRand )
#declare TreeRand = seed( 0 );
#end

#declare VisibleTrees = 0;
#macro Tree()
	#local ClearTreeTexture = texture {
		pigment { color rgbf <1,1,1,1> }
	}
	#local TreeHeightScale = 2+1.5*rand( TreeRand );
	#local TreeWidthScale = 1.5+rand( TreeRand );
	#local TreeTextureTrans = <1000*rand( TreeRand ),0,1000*rand( TreeRand )>;
	#local TreeTrunkWidth = 0.1+0.1*rand( TreeRand );
	#local BarkTexture = texture { Bark }
	#local TheTreeTexture = texture { TreeTexture }
	#local DrawTree = true;
//	#local TheTreeTexture = texture { ClearTreeTexture }
	#local TreeTime = rand( TreeRand )*0.9;
	#ifdef( TreesClock )
		#local TreeTimer = Timer( TreesClock, TreeTime, TreeTime+0.1, false );
//		#debug concat( "\nTreeTimer ", str( TreeTime, 0, 2 ) )
		#local TreeTimer2 = TreeTimer;
		#if( TreeTimer > -1 )
			#local TreeTimer2 = sin( TreeTimer*pi );
			#declare VisibleTrees = VisibleTrees+1;
		#end
		#local BarkTexture = texture {
			#if( TreeTimer > -1 )
//			#debug "\nAveraging tree textures"
			average
			texture_map {
				[ (1-TreeTimer2) ClearTreeTexture ]
				[ TreeTimer2 BarkTexture ]
			}
			#else
				ClearTreeTexture
				#local DrawTree = false;
			#end
		}
		#local TheTreeTexture = texture {
			#if( TreeTimer > -1 )
			average
			texture_map {
				[ (1-TreeTimer2) ClearTreeTexture ]
				[ TreeTimer2 TreeTexture ]
			}
			#else
				ClearTreeTexture
			#end
		}
	#end
	#if( DrawTree )
union {
	cylinder { <0,-0.1,0>, <0,1,0>, TreeTrunkWidth
		texture { BarkTexture translate TreeTextureTrans  } 
		scale <1,TreeHeightScale,1> 
	}
//	cone { <0,0.9,0>, 1, <0,3,0>, 0.01 texture { TreeTexture } }
	merge {
		object { TreeTop scale <TreeWidthScale,0.75*TreeHeightScale,TreeWidthScale> translate y*(TreeHeightScale-1)  }
		object { TreeTop scale <TreeWidthScale*0.75,0.75*TreeHeightScale,TreeWidthScale*0.75> translate y*(TreeHeightScale-0.5)  }
		texture { TheTreeTexture translate TreeTextureTrans }
	}
	scale TreeScale
}
	#else
	sphere { <0,0,0>, 0 texture { ClearTexture } }
	#end
#end

#ifndef( StartHeight )
#declare StartHeight = 10;
#end

#macro Treepulate( Object, BlockObject, Min, Max, Number )
	#local Count = 0;
	#local BailOut = 0;
	#while( Count < Number )
		#local TreeStartLoc = <(Max.x-Min.x)*rand( TreeRand )+Min.x,StartHeight,(Max.z-Min.z)*rand( TreeRand )+Min.z>;
		#local Norm = <0,0,0>;
		#local TreeLoc  = trace( Object, TreeStartLoc, -y, Norm );
		#local Norm = <0,0,0>;
		#local Temp = trace( BlockObject, TreeStartLoc, -y, Norm );
		#local PlantIt = true;
		#if( (Norm.x = 0 ) & (Norm.y = 0 ) & (Norm.z = 0 ) )
			#local PlantIt = true;
		#else
			#debug "\nTree hits glacier!"
			#local PlantIt = false;
		#end
		#if( ( TreeLoc.y > Min.y ) & ( TreeLoc.y < Max.y ) )
			#local aTree = object { Tree() }
			#if( PlantIt )
				object { aTree translate TreeLoc }
			#end
			#local Count = Count+1;
			#local BailOut = 0;
		#else
			#local BailOut = BailOut+1;
			#if( BailOut > 9 )
				#local Count = Count+1;
				#local BailOut = 0;
				#debug "\nBailed out after nine attempts to plant a tree"
			#end
		#end
	#end
	#debug concat( "\nVisible trees: ", str( VisibleTrees, 0, 0 ) )
#end
// Tree macro stuff ends

#ifndef( WaterClock )
	#declare WaterClock = 0;
#end
#declare Water =
material {
	texture{
		pigment {
//			rgbf <0.397589, 0.556527, 1.000000, 0.97>
			rgbt <1,1,1,0.98>
		}
		normal {
			bozo 0.5 
			bump_size 0.5
			scale 0.1
			phase WaterClock
		}
		finish {
			reflection {
				rgb 0.4
			}
			specular 0.8
			roughness 0.005
		}
	}
	interior {
		ior 1.3
	}

}


