//glacier.inc:
#declare GlacierRandom = seed ( 494949 );		//did I ever mention Alaska's the 49th state?

//#declare GlacierClock = clock;	//for testing glacier.inc


//Glacier sub-clocks
#declare GlacierInClock = Timer(GlacierClock, 0, GlacierParksAt, true);
#declare GlacierInTexClock = pow(GlacierInClock, 1.3);		//for the texture morph on the way out
#declare GlacierInClock = pow(GlacierInClock, .45);				//for the translation: raise power to slow early entrance speed

#declare GlacierOutClock = Timer(GlacierClock, GlacierLeavesAt, 1, true);
#declare GlacierOutTexClock = pow(GlacierOutClock, .8);	//for the texture morph on the way out
#declare GlacierOutClock = pow(GlacierOutClock, .7);				//for the translation: raise power to slow meltdown

//#debug str(GlacierClock, 5, 5)

//Start and stop translation vectors
#declare GlacierInInit = <-.7, .9, -2.6>;
#declare GlacierInFull = <1.8, .9, -2.6>;
#declare GlacierOutInit = GlacierInFull;
#declare GlacierOutFull = <1.2, .4, -2.6>;

//define GlacierTrans translation value for this frame
#switch (GlacierClock)
	#range (0, GlacierParksAt)
		#declare GlacierTransX =((abs(GlacierInInit.x)+abs(GlacierInFull.x))*GlacierInClock - abs(GlacierInInit.x));
		#declare GlacierTrans = <GlacierTransX, GlacierInInit.y, GlacierInInit.z>;
		#break
	#range (GlacierParksAt, GlacierLeavesAt)
		#declare GlacierTrans = GlacierInFull;
		#break
	#range (GlacierLeavesAt, 1)
		#debug str(GlacierOutClock,5,5)
		#declare GlacierTransX = GlacierOutInit.x - ((GlacierOutInit.x-GlacierOutFull.x)*GlacierOutClock);
		#declare GlacierTransY = GlacierOutInit.y - ((GlacierOutInit.y-GlacierOutFull.y)*GlacierOutClock);
		#declare GlacierTrans = <GlacierTransX, GlacierTransY, GlacierOutInit.z>;
		#break
#end

#declare GlacierIce =
	texture{
		pigment {
						//rgbt <0.226444, 0.806180, 0.902266, .2>
						rgb <0.226444, 0.806180, 0.902266>
		}
		normal {
			wrinkles
		}
		finish {
			diffuse .6
			specular .2
		}
	}

#declare Ice2Snow =
texture {
	slope { -y, 0, 0.5 }
	texture_map {
		[ 0.2 Snow ]
		[ 1 GlacierIce ]
	}	
}

#declare PatternBumps =
pigment{
	granite
	pigment_map{
			[0.0 color rgb .3]
		#local pigmentcount = 0; 
		#while (pigmentcount <= 10)
			[(pigmentcount / 10) color rgb .4 * 1.1 * ((rand(GlacierRandom)*.6)+1) ]
			#declare pigmentcount = pigmentcount +1;
		#end
	}
	scale 4.5
	translate 1900
}

#declare PatternGrooves =
pigment{
	wrinkles
	pigment_map{
			[0.0 color rgb .4]
		#local pigmentcount = 0; 
		#while (pigmentcount <= 10)
			[(pigmentcount / 10) color rgb .5 * 1.1 * ((rand(GlacierRandom)*.5)+1) ]
			#declare pigmentcount = pigmentcount +1;
		#end
	}
	turbulence .9
	scale 1
	translate 1800
}

//"Randomize" the glacier's texture offset pattern
#if (GlacierClock < GlacierParksAt)
	#declare GlacierTexTransOne = 24053;
	#declare GlacierTexTransTwo = -15930;
#else
	#declare GlacierTexTransOne = -15930;
	#declare GlacierTexTransTwo = 40576;
#end

#declare PatternGlacierOne=
pigment{
	average
	pigment_map{
	[1 PatternBumps]
	[.9 PatternGrooves ]
	}
	translate GlacierTexTransOne
	scale <2.5, 4, 2.5>
}

#declare PatternGlacierTwo=
pigment{
	average
	pigment_map{
	[1 PatternBumps]
	[.9 PatternGrooves ]
	}
	translate GlacierTexTransTwo
	scale <2.5, 4, 2.5>
}

#declare GlacierFuncOne =
function{
	pigment{ PatternGlacierOne  }
}

#declare GlacierFuncTwo =
function{
	pigment{ PatternGlacierTwo  }
}

//Set and translate the texture offset pattern according to the clock
#declare GlacierTexFunc =
function{
	#switch (GlacierClock)
		#range (0, GlacierParksAt)
			(((1-GlacierInTexClock)*(1.35* GlacierFuncOne(x, y, z).y))  + (GlacierInTexClock*(1.35* GlacierFuncTwo(x, y, z).y)))
			#break
		#range (GlacierParksAt, GlacierLeavesAt)
			(1.3 * GlacierFuncOne(x, y, z).y)
			#break
		#range (GlacierLeavesAt, 1)
			(((1-GlacierOutTexClock)*(1.35* GlacierFuncOne(x, y, z).y))  + (GlacierOutTexClock*(1.35* GlacierFuncTwo(x, y, z).y)))
			#break
	#end
}

//And, declare the object itself
#declare Glacier =
isosurface {
		
	function {
		1.5*pow(y,2) + (.5*x) + .55*pow(z,2)  + GlacierTexFunc(x,y,z)
	}
	threshold 0.001
	accuracy 0.001
	max_gradient  10
	contained_by { 	box { <-7, -.1, -2.5>, <3, 3, 4.5>	}	}
	texture{ Ice2Snow }		
	
	scale <1.09, .75, 1>
	translate GlacierTrans

}