//
// Glenn's BlobMan POV-Ray Scene File - Athlete
// last update 11-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
// This file does not render.  #include "Athlete.inc" in another .pov file
//
// Objects:
// Blobman (headless)
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Origin at base of neck
// +X is towards the back of the person.
// Sorry, this system does not incorporate inverse kinematics. 8-)


//===============================================
//             Variable Declarations
//===============================================

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
//	#include "GRuler.inc"
	#include "Colors.inc"
	#include "Textures.inc"
	#include "GIncludeRH.inc"
	#declare RenderMe = 1;
#end

//#include "BlobHead31.inc"

#declare HandPose = 1;
#declare FFat = 1.23; // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 32; // thumb, outer joint
#declare TB  = 15; // thumb, middle joint
#declare TRot  = 30; // thumb rotation angle
#declare TExt  = 0; // thumb extension from hand
#declare F1A  = 4; // index finger, outer joint
#declare F1B  = 12; // index finger, middle joint
#declare F1C  = 0; // index finger angle
#declare F1Rot  = 10; // index finger rotation
#declare F2A  = 10; // middle finger, outer joint
#declare F2B  = 10; // middle finger, middle joint
#declare F2C  = 10; // middle finger angle
#declare F2Rot  = 0; // middle finger rotation
#declare F3A  = 15; // ring finger, outer joint
#declare F3B  = 18; // ring finger, middle joint
#declare F3C  = 16; // ring finger angle
#declare F3Rot  = -4; // ring finger rotation
#declare F4A  = 12; // pinky finger, outer joint
#declare F4B  = 16; // pinky finger, middle joint
#declare F4C  = 12; // pinky finger angle
#declare F4Rot  = -10; // pinky finger rotation
#declare WRot = -12; // wrist angle
#declare WCock = -25; // wrist cock side-to-side


//#include "Accessories.inc"

#ifndef ( Pose )
// Pose Angles ( in order )
#declare HPan     = 32;   // head, positive = towards his left
#declare HTiltFwd = 15;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 60;   // twists the hand, positive = palms up
#declare REAng    = 70;  // elbow
#declare RAFwd    = 43;   // total arm
#declare RARot    = 1;   // claps hands
#declare RAOut    = 12;   // opens underarm
#declare RAFwd2   = 0;    // total arm
#declare RARot2   = 10;    // claps hands
#declare RKnee    = 65;    // knee bend
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 65;    // leg angle fwd
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 0;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle
#declare LETwist  = 60;  // twists the hand, positive = palms up
#declare LEAng    = 62;   // elbow
#declare LAFwd    = 46;   // total arm
#declare LARot    = 1;   // claps hands
#declare LAOut    = 16;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = 10;  // claps hands
#declare LKnee    = 65;    // knee bend
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 65;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle
#end

//===============================================
//             Textures
//===============================================
#declare HelmetTex =
	texture {
//		pigment { color rgb<.002,.001,.008>*1.00 }
		pigment { color rgb<.002,.001,.208>*1.00 }
//		finish { specular 0.96 roughness .008 reflection 0 }
		finish { specular 0.96 roughness .008 reflection <0.02,0.04,0.05> }
	}

#declare FaceShieldTex =
	texture {
		pigment { color rgbt<.182,.181,.182,.7> }
		finish { specular 0.96 roughness .008 reflection <0.02,0.04,0.05> }
	}

#declare SuitTex =
	texture {
//		pigment { color rgb<.02,.01,.08>*1.00 }
		pigment { color rgb<.02,.01,.38>*1.00 }
		finish { specular 0.45 roughness .022 }
	}
#declare ClothTex = texture { SuitTex }
/*
#declare ClothTex = // White test
	texture {
		pigment {color rgb<1.0,1.0,1.0>*0.7 }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .3 specular .28 roughness .086 }
	}
*/
#declare PantsTex =
	texture {
		SuitTex
	}
#declare SocksTex =
	texture {
		SuitTex
	}
#declare ShoesTex =
	texture {
		SuitTex
	}


//===============================================
//             Head
//===============================================

#declare HelmetShape =
	difference {
		union {
			sphere {
				<0,0,0>,5
			}
			cylinder {
				<0,0,0>,<0,0,-5>,5
			}
		} // end union
		sphere { // inside
			<0,0,0>,4.3
		}
		cylinder { // inside
			<0,0,0.1>,<0,0,-6,>4.3
		}
		box { // cut off back base
			<-8,-8,-6>,<8,8,0>
			rotate x*20
			translate <0,0,-3.2>
		}
/*
		cylinder { // faceplate cutout
			<0,-6,0>,<0,0,0>,3
			scale <1,1,.6>
			translate <0,0,-1>
		}
*/
		union { // faceplate cutout
			cylinder {
				<0,-6,0>,<0,0,0>,3
				scale <1,1,.6>
				translate <0,0,-1>
			}
			box {
				<-3,-6,0>,<3,0,3>
				scale <1,1,.6>
				translate <0,0,-1>
			}
		} // end union
	texture { HelmetTex }		
	} // end difference

#declare FaceShield =
	intersection {
		union { // outer
			sphere {
				<0,0,0>,5
			}
			cylinder {
				<0,0,0>,<0,0,-5>,5
			}
		} // end union
		union { // inner
			sphere {
				<0,0,0>,4.8
			}
			cylinder {
				<0,0,0>,<0,0,-5>,4.8
			}
			inverse
		} // end union
		union { // faceplate cutout
			cylinder {
				<0,-6,0>,<0,0,0>,3
				scale <1,1,.6>
				translate <0,0,-1>
			}
			box {
				<-3,-6,0>,<3,6,3>
				scale <1,1,.6>
				translate <0,0,-1>
			}
		} // end union
		texture { FaceShieldTex }
	} // end intersection

#declare FaceS =
	sphere {
		<0,0,0>,3.8
		scale <1,1,1>
		texture {
			pigment { color rgb <0.929,0.804,0.702> }
		}
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "Face.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
				rotate x*90
				scale <8,1,12>
				translate <-4,0,-6>
			}
			finish { ambient .6 }
		}
	}
#declare BackHead =
	sphere {
		<0,0,0>,3.8
		scale <1,1,1>
		texture {
			pigment { color rgb <0.929,0.804,0.702> }
		}
	}
#declare Helmet =
	union {
		object { HelmetShape }
		object { FaceS }
		object { BackHead translate <0,0.1,0> }
		object { FaceShield translate <0,1,-1> rotate x*-60 translate <0,-1,1> }
	} // end union


//===============================================
//       Body
//===============================================

#include "Gloves.inc"

#declare TorsoHalf =
	union {
		sphere { // upper shoulders
			<0,0,0>,9
			scale <.4,1,.4>
			texture { ClothTex }
		}
		cylinder { //torso
			<0,0,0>,<0,0,-14>,9
			scale <.4,1,1>
			texture { ClothTex }
		}
		sphere { // lower end
			<0,0,0>,9
			scale <.4,1,.3>
			translate <0,0,-14>
			texture { ClothTex }
		}
		rotate <10,0,0>
		clipped_by { box {<-6,0,6>,<6,-12,-30>}}
	}

#declare Torso = //center where neck/shoulder join each other
	union {
		object { TorsoHalf }
		object { TorsoHalf transform InverseY }
	}
#declare LHand = // points straight down
	object { LeftHand
//	object { LeftHandWithGunFiring
			rotate <0,-90,0> // point downwards
			rotate <0,LWCock,LWAng> // wrist angles
			translate <-0.0,0.6,-1.6> // drop down, move to touch sleeve
		}
#declare LLowerArm =
	union {
		object { LHand }
			cone { //lower sleeve except cuff
				<0,0,2>,1.82,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		difference {
			cylinder { //lower sleeve outer
				<0,0,0>,<0,0,2.1>,1.9
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.85
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare LeftArm = //origin at shoulder
	union {
		object { LLowerArm rotate <0,0,LETwist> rotate <0,LEAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RHand = // points straight down
	object { RightHand
		rotate <0,-90,0> // point downwards
		translate <0.0,-0.6,-1.0> // drop down, move to touch sleeve
	}
#declare RLowerArm =
	union {
		object { RHand }
		difference {
			cone { //lower sleeve outer
				<0,0,0>,1.9,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.8
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare RightArm = //origin at shoulder
	union {
		object { RLowerArm rotate <0,0,-RETwist> rotate <0,REAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare FootShoe =
	union {
		cylinder {
			<0,0,1>,<0,0,8>,1.85
			scale <1,.6,1>
			texture { SocksTex }
		}
		superellipsoid { // main shoe
			<.5,.5>
			scale <4.6,2.8,2>
			rotate <0,-11,0>
			translate <-4,0,0.8>
			texture { ShoesTex }
		}
		box { // heel
			<-1,-1.5,0>,<1,1.5,.8>
			texture { ShoesTex }
		}
	} // end union

#declare RLowerLeg =
	union {
		object { FootShoe translate <0,0,-4> }
		sphere { // knee end
			<0,0,17>,2.5
			texture { PantsTex }
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare LLowerLeg =
	union {
		object { FootShoe translate <0,0,-4> }
		sphere { // knee end
			<0,0,17>,2.5
			texture { PantsTex }
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare RightLeg = // origin at pelvis joint
	union {
		object { RLowerLeg rotate <0,0,-RLTwist> rotate <0,-RKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
			texture { PantsTex }
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,18>,3.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
			texture { PantsTex }
		}
		translate <0,0,-18> // origin at pelvis joint
	}

#declare LeftLeg = // origin at pelvis joint
	union {
		object { LLowerLeg rotate <0,0,-LLTwist> rotate <0,-LKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
			texture { PantsTex }
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,18>,3.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
			texture { PantsTex }
		}
		translate <0,0,-18> // origin at pelvis joint
	}

#declare Hips =
	union {
		sphere { // top of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,8>
			texture { ClothTex }
		}
		cylinder { // main part
			<0,0,0>,<0,0,8>,5
			scale <.8,1,1>
			translate <0,0,0>
			texture { ClothTex }
		}
		sphere { // bottom of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,0>
			texture { ClothTex }
		}
		sphere { // butt cheek RH
			<0,0,0>,5
			scale <.7,.8,1>
			translate <0,-2,0>
			texture { ClothTex }
		}
		sphere { // butt cheek LH
			<0,0,0>,5
			scale <.7,.8,1>
			translate <0,2,0>
			texture { ClothTex }
		}
	} // end union

#declare LowerTorso =
	union {
		object { Hips translate <.5,0,0> }
		object { LeftLeg
			rotate <-LLOut,LLAng,0>
			translate <0,-3,0>
		}
		object { RightLeg
			rotate <RLOut,RLAng,0>
			translate <0,3,0>
		}
	} // end union

#declare BlobMan = //center at base of neck
	union {

//		object { MaleHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Torso rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}

		object { LowerTorso
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
	}
#declare Athlete =
	union {
//	RoundedHalfBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		object { Helmet }
/*
		object { RoundedHalfBox2(24,7,12,2.4)
			translate <-12,-3.2,-18>
			texture { SuitTex }
		}
*/
		cylinder { // lower neck
			<0,0,-12>,<0,0,-4.5>,3.2
			scale <1,.6,1>
			texture { pigment { color rgb<1,1,1> } }
		}
		cylinder { // upper neck
			<0,0,-6>,<0,0,0>,2.8
			scale <1,.6,1>
			rotate x*-18
			translate <0,2,-2>
			texture { pigment { color rgb<1,1,1> } }
		}
		object { BlobMan rotate z*90 translate <0,0,-7> }
	} // end union
/*
#declare HelmetGroup =
	union {
		object { Helmet }
		object { BobGuy }
	} // end union
*/

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-13, -10, 7> // origin closeup
//  look_at   <0.000, 0.000, 0.000>
//  location  <-33, -0, 7> // head front view
//  look_at   <0.000, 0.000, 4.000>
//  location  <2, -30, 4> // head side view
//  look_at   <2, 0, 4>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-25, -22, 7> // 3/4 head view
//  look_at   <0.000, 0.000, 4.000>
//  location  <0, -66, 0> // overall side view
//  look_at   <0, 0, -6>
//  location  <-60, 0, 4> // overall front view
//  look_at   <0, 0, -4>
//  location  <-52, -48, 8> // 3/4 overall view
//  look_at   <0.000, 0.000, -8.000>
  location  <-18, -15*Feet, 58> // render view
  look_at   <-8, 0, 36>
	angle 40
}
camera { Render_Cam }

light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 12 }


object { Athlete rotate <20,0,0> translate <0,0,5*Feet> }
object { Athlete rotate <20,0,90> translate <3*Feet,0,5*Feet> }
object { Athlete rotate <20,0,-60> translate <-4*Feet,6*Feet,5*Feet> }

//sphere {<0,0,-3>,3 pigment { White } }

#end
