
// POV-Ray Object File - Bobsled Environment
// created 14-Nov-02
// last update 30-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "BobEnviron.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
//
// A flat plane world, with clouds in sky, fog,
// and a Sun definition
// Intended scale is English system (inches), ground is +Z
// Origin in the middle of the ground plane
// Everything is tilted 17-degrees to simulate the slope of the track

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#include "TrackMaker.inc"
	#declare RenderMe = 1;
	#declare AreaSun = 0; // 0=normal light, 1=area light for the sun
	#declare DoFog = 0; // 0=no fog, 1=fog
#end

//===============================================
//             Textures
//===============================================

#declare SnowyTex =
	texture {
		pigment { color rgb<1,1,1> }
		normal { bumps 0.1 scale 12 }
		finish { ambient 0.2 diffuse 0.5 specular 0.13 roughness 0.24 }
	}
#declare BrightSnowyTex =
	texture {
		pigment { color rgb<1,1,1> }
		normal { bumps 0.1 scale 12 }
		finish { ambient 0.4 diffuse 0.5 specular 0.13 roughness 0.24 }
	}

/*
#declare EarthTex =
	texture {
		pigment {
			bozo
			color_map
			{
		[ 0.1  color rgb<.4,.4,.4> ]
		[ 0.3  color rgb<.9,.9,.6> ]
		[ 0.5  color rgb<.5,.4,.2> ]
		[ 0.7  color rgb<.1,.5,.2> ]
		[ 1.0  color rgb<.4,.4,.4> ]
			} // color_map
			scale 50000
			turbulence .02
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}
*/

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {StdBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }
#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.660,0.663,0.671>*2.3
//		#if (AreaSun=1)
//			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient // too soft!
//			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,2,2 jitter circular orient
//		#end
	}

object { Sun
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate y*35 // towards right
  rotate z*18 // behind camera
}



//===============================================
//             Environment
//===============================================

background { color rgb <0.2, 0.4, 0.8> } // light blue
//background { color rgb <0.0, 0.0, 0.0> } // black
//#include "skies.inc"
//sky_sphere { S_Cloud5 rotate <90,0,0> }

sky_sphere {
    pigment {
      gradient z
      color_map {
        [ 0.5  color rgb<.70,.70,.99> ]
        [ 0.7  color rgb<.22,.22,.75> ]
      }
      scale 2
      translate -1
      rotate x*-17
    }
  }

//object { O_Cloud1 rotate <90,0,0> }
//object {GroundPlaneWhite translate z*-0}

//#include "World.inc"

#declare NearbyMountains =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "MountHF1.png"
		smooth
		water_level 1/255
		double_illuminate
		rotate x*90
		scale <1,-1,1>
		scale <4000*Feet,3000*Feet,600*Feet>
		texture { SnowyTex }
//		translate <-2000*Feet,-1000*Feet,0>
//		rotate x*-17
//		translate <-1500*Feet,-1000*Feet,0>
	}

#declare TrackTerrain =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "TrackMapHF.png"
		smooth
		water_level 1/255
		double_illuminate
		rotate x*90
		scale <1,-1,1>
		scale <600*Feet,1000*Feet,40*Feet>
		texture { SnowyTex }
//		rotate x*17
//		translate <-500*Feet,0,100*Feet>
	}

#declare Plain =
		plane {
			z,0
			texture { SnowyTex }
		}

#if (DoFog=1)
fog {
	fog_type 1 // general fog adds distance
		distance 400*Feet
//		color rgbt<.980,.980,.998,.06> // transmittance (lower trans dulls out sky)
		color rgbt<.480,.480,.498,.06> // transmittance (lower trans dulls out sky)
		turbulence .001
	}
#end

#declare PosCone =
	cone {
		<0,0,0>,0,<0,0,500*Feet>,80*Feet
		texture { pigment { rgb<.1,.1,1> } }
	}
#declare StartP = <200*Feet, 950*Feet, 500*Feet>; 
#declare EndP = <0,0,-1>;
//#declare Inter = trace ( TrackTerrain, StartP, EndP );
//object { PosCone translate Inter }
//#debug concat("Value is:",str(Inter.x,7,2),str(Inter.y,7,2),str(Inter.z,7,2),"\n")
#declare CamPos = <200*Feet,950*Feet,15*Feet>;

//===============================================
//             Object Positioning
//===============================================




//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {
	max_trace_level 50
}
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 95
//		location  <-30*Feet, -1000*Feet, 12000*Feet> // satellite
//		look_at <0*Feet,10*Feet,16*Feet>
//		location  <-30*Feet, -4000*Feet, 4000*Feet> // overall
//		look_at <0*Feet,10*Feet,16*Feet>
//		location  <-3000*Feet, 500*Feet, 1000*Feet> // overall from left
//		look_at <0*Feet,10*Feet,16*Feet>
//		location  <-0*Feet, 0*Feet, 140*Feet> // crane view
//		look_at <300*Feet,500*Feet,6*Feet>
		location  <280*Feet, 520*Feet, 40*Feet> // loop
		look_at <130*Feet,560*Feet,60*Feet>
//			location CamPos
//			look_at CamPos+<100*Feet,-10*Feet,20*Feet>
	}

/*
light_source
{ <140*Feet,-135*Feet,150*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-120*Feet,130*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
*/
background { rgb<.34,.36,.98> }
//plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { TestSphere scale 20 translate <0,0,20> }

object { Plain rotate x*-17 }
object { TrackTerrain }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> }

object { TotalTrack translate <0,0,3*Feet> }

#end
