
// Glenn's POV-Ray Animation File - Bobsled master file
// created 7-Nov-02
// last update 6-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )

//#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

//===============================================
//             Variables
//===============================================

/*
SHOTS at 30 fps
Shot Sec  Frames       TotalF    Description
100	5.0	150	frames	150	cum	titles over black background, fades to
102	3.0	90	frames	240	cum	helicopter flyover top of track
105	4.0	120	frames	360	cum	child tosses a little snowball, it lands and bounces
110	3.8	114	frames	474	cum	shiny black helmet, lowering shield
120	2.4	72	frames	546	cum	gloved hands push & pull back grip on sled
130	1.0	30	frames	576	cum	freeze frame: runners are poised to push
135	2.4	72	frames	648	cum	snowball rolls, grows visibly
140	2.0	60	frames	708	cum	nose of sled begins to move
150	0.8	24	frames	732	cum	hands push out of frame
160	3.0	90	frames	822	cum	ground level: runners and boots go by
170	3.2	96	frames	918	cum	snowball takes a bounce
180	5.0	150	frames	1068	cum	coasting away, retract handles, settle in
190	3.0	90	frames	1158	cum	sled runs slowly towards camera
200	3.2	96	frames	1254	cum	first turn, low and slow
210	1.8	54	frames	1308	cum	passing the camera exit turn 1
220	0.8	24	frames	1332	cum	bumpy in-sled view down the track, heads bobble
230	2.2	66	frames	1398	cum	turn 2, mid-level
240	1.3	39	frames	1437	cum	exit turn, straight under fixed double camera
245	3.8	114	frames	1551	cum	big snowball bounces over track, then sled is seen
250	2.0	60	frames	1611	cum	sled runner cam, snow sprays out
260	1.6	48	frames	1659	cum	turn 6, from close by the camera
265	3.0	90	frames	1749	cum	huge snowball splats onto track
270	2.7	81	frames	1830	cum	turn 7 high level zoom view from radius center
275	2.0	60	frames	1890	cum	sled shoots underpass, past track-cam
280	4.0	120	frames	2010	cum	helicopter shot following over long straight
290	1.8	54	frames	2064	cum	static view of snow blockage
300	1.0	30	frames	2094	cum	view of driver's eyes: alarm!
310	1.4	42	frames	2136	cum	pulling the brake handle
320	2.2	66	frames	2202	cum	crash, black sled launches
330	1.6	48	frames	2250	cum	slo-mo, sled rises up towards the sky
340	1.2	36	frames	2286	cum	sled flies over spectators heads, they point
350	2.4	72	frames	2358	cum	driver and brakeman look down, puzzled
360	0.7	21	frames	2379	cum	sled flies directly over camera, heading towards ground
370	2.0	60	frames	2439	cum	static cam, shadow grows, sled bounces in view
380	1.3	39	frames	2478	cum	sled bangs sidewalls
385	2.4	72	frames	2550	cum	turn-cam, sled passes overhead
390	1.2	36	frames	2586	cum	crossing finish line, heads swivel
410	3.6	108	frames	2694	cum	sled skids to a halt, turning
420	4.0	120	frames	2814	cum	time 0:38.000 flashes on electronic sign
430	5.0	150	frames	2964	cum	end credits
Initial_Clock = 0
Final_Clock = 2964

*/

// "Sclock" is the shot clock, goes from 0 to 1 within each shot
// "Sframes" is the number of frames in this shot, allowing
// each frame to know the speed of realtime.
#declare FPS = 30; // frames per second
#declare Debug = 0;

// following 3 lines are for testing only:
//#declare Sclock = 0.41; // between 0+ and 1.0
//#declare Sframes = 120;
//#include "Shot105.pov"

// Shot List Goes Here
#if ( clock <= 150 )		
	#if ( clock > 0 )	
		#declare Sclock = (clock-0)/150;
		#declare Sframes = 150;
		#include "Shot100.pov"
	#end	
#end		
#if ( clock <= 240 )		
	#if ( clock > 150 )	
		#declare Sclock = (clock-150)/90;
		#declare Sframes = 90;
		#include "Shot102.pov"
	#end	
#end		
#if ( clock <= 360 )		
	#if ( clock > 240 )	
		#declare Sclock = (clock-240)/120;
		#declare Sframes = 120;
		#include "Shot105.pov"
	#end	
#end		
#if ( clock <= 474 )		
	#if ( clock > 360 )	
		#declare Sclock = (clock-360)/114;
		#declare Sframes = 114;
		#include "Shot110.pov"
	#end	
#end		
#if ( clock <= 546 )		
	#if ( clock > 474 )	
		#declare Sclock = (clock-474)/72;
		#declare Sframes = 72;
		#include "Shot120.pov"
	#end	
#end		
#if ( clock <= 576 )		
	#if ( clock > 546 )	
		#declare Sclock = (clock-546)/30;
		#declare Sframes = 30;
		#include "Shot130.pov"
	#end	
#end		
#if ( clock <= 648 )		
	#if ( clock > 576 )	
		#declare Sclock = (clock-576)/72;
		#declare Sframes = 72;
		#include "Shot135.pov"
	#end	
#end		
#if ( clock <= 708 )		
	#if ( clock > 648 )	
		#declare Sclock = (clock-648)/60;
		#declare Sframes = 60;
		#include "Shot140.pov"
	#end	
#end		
#if ( clock <= 732 )		
	#if ( clock > 708 )	
		#declare Sclock = (clock-708)/24;
		#declare Sframes = 24;
		#include "Shot150.pov"
	#end	
#end		
#if ( clock <= 822 )		
	#if ( clock > 732 )	
		#declare Sclock = (clock-732)/90;
		#declare Sframes = 90;
		#include "Shot160.pov"
	#end	
#end		
#if ( clock <= 918 )		
	#if ( clock > 822 )	
		#declare Sclock = (clock-822)/96;
		#declare Sframes = 96;
		#include "Shot170.pov"
	#end	
#end		
#if ( clock <= 1068 )		
	#if ( clock > 918 )	
		#declare Sclock = (clock-918)/150;
		#declare Sframes = 150;
		#include "Shot180.pov"
	#end	
#end		
#if ( clock <= 1158 )		
	#if ( clock > 1068 )	
		#declare Sclock = (clock-1068)/90;
		#declare Sframes = 90;
		#include "Shot190.pov"
	#end	
#end		
#if ( clock <= 1254 )		
	#if ( clock > 1158 )	
		#declare Sclock = (clock-1158)/96;
		#declare Sframes = 96;
		#include "Shot200.pov"
	#end	
#end		
#if ( clock <= 1308 )		
	#if ( clock > 1254 )	
		#declare Sclock = (clock-1254)/54;
		#declare Sframes = 54;
		#include "Shot210.pov"
	#end	
#end		
#if ( clock <= 1332 )		
	#if ( clock > 1308 )	
		#declare Sclock = (clock-1308)/24;
		#declare Sframes = 24;
		#include "Shot220.pov"
	#end	
#end		
#if ( clock <= 1398 )		
	#if ( clock > 1332 )	
		#declare Sclock = (clock-1332)/66;
		#declare Sframes = 66;
		#include "Shot230.pov"
	#end	
#end		
#if ( clock <= 1437 )		
	#if ( clock > 1398 )	
		#declare Sclock = (clock-1398)/39;
		#declare Sframes = 39;
		#include "Shot240.pov"
	#end	
#end		
#if ( clock <= 1551 )		
	#if ( clock > 1437 )	
		#declare Sclock = (clock-1437)/114;
		#declare Sframes = 114;
		#include "Shot245.pov"
	#end	
#end		
#if ( clock <= 1611 )		
	#if ( clock > 1551 )	
		#declare Sclock = (clock-1551)/60;
		#declare Sframes = 60;
		#include "Shot250.pov"
	#end	
#end		
#if ( clock <= 1659 )		
	#if ( clock > 1611 )	
		#declare Sclock = (clock-1611)/48;
		#declare Sframes = 48;
		#include "Shot260.pov"
	#end	
#end		
#if ( clock <= 1749 )		
	#if ( clock > 1659 )	
		#declare Sclock = (clock-1659)/90;
		#declare Sframes = 90;
		#include "Shot265.pov"
	#end	
#end		
#if ( clock <= 1830 )		
	#if ( clock > 1749 )	
		#declare Sclock = (clock-1749)/81;
		#declare Sframes = 81;
		#include "Shot270.pov"
	#end	
#end		
#if ( clock <= 1890 )		
	#if ( clock > 1830 )	
		#declare Sclock = (clock-1830)/60;
		#declare Sframes = 60;
		#include "Shot275.pov"
	#end	
#end		
#if ( clock <= 2010 )		
	#if ( clock > 1890 )	
		#declare Sclock = (clock-1890)/120;
		#declare Sframes = 120;
		#include "Shot280.pov"
	#end	
#end		
#if ( clock <= 2064 )		
	#if ( clock > 2010 )	
		#declare Sclock = (clock-2010)/54;
		#declare Sframes = 54;
		#include "Shot290.pov"
	#end	
#end		
#if ( clock <= 2094 )		
	#if ( clock > 2064 )	
		#declare Sclock = (clock-2064)/30;
		#declare Sframes = 30;
		#include "Shot300.pov"
	#end	
#end		
#if ( clock <= 2136 )		
	#if ( clock > 2094 )	
		#declare Sclock = (clock-2094)/42;
		#declare Sframes = 42;
		#include "Shot310.pov"
	#end	
#end		
#if ( clock <= 2202 )		
	#if ( clock > 2136 )	
		#declare Sclock = (clock-2136)/66;
		#declare Sframes = 66;
		#include "Shot320.pov"
	#end	
#end		
#if ( clock <= 2250 )		
	#if ( clock > 2202 )	
		#declare Sclock = (clock-2202)/48;
		#declare Sframes = 48;
		#include "Shot330.pov"
	#end	
#end		
#if ( clock <= 2286 )		
	#if ( clock > 2250 )	
		#declare Sclock = (clock-2250)/36;
		#declare Sframes = 36;
		#include "Shot340.pov"
	#end	
#end		
#if ( clock <= 2358 )		
	#if ( clock > 2286 )	
		#declare Sclock = (clock-2286)/72;
		#declare Sframes = 72;
		#include "Shot350.pov"
	#end	
#end		
#if ( clock <= 2379 )		
	#if ( clock > 2358 )	
		#declare Sclock = (clock-2358)/21;
		#declare Sframes = 21;
		#include "Shot360.pov"
	#end	
#end		
#if ( clock <= 2439 )		
	#if ( clock > 2379 )	
		#declare Sclock = (clock-2379)/60;
		#declare Sframes = 60;
		#include "Shot370.pov"
	#end	
#end		
#if ( clock <= 2478 )		
	#if ( clock > 2439 )	
		#declare Sclock = (clock-2439)/39;
		#declare Sframes = 39;
		#include "Shot380.pov"
	#end	
#end		
#if ( clock <= 2550 )		
	#if ( clock > 2478 )	
		#declare Sclock = (clock-2478)/72;
		#declare Sframes = 72;
		#include "Shot385.pov"
	#end	
#end		
#if ( clock <= 2586 )		
	#if ( clock > 2550 )	
		#declare Sclock = (clock-2550)/36;
		#declare Sframes = 36;
		#include "Shot390.pov"
	#end	
#end		
#if ( clock <= 2694 )		
	#if ( clock > 2586 )	
		#declare Sclock = (clock-2586)/108;
		#declare Sframes = 108;
		#include "Shot410.pov"
	#end	
#end		
#if ( clock <= 2814 )		
	#if ( clock > 2694 )	
		#declare Sclock = (clock-2694)/120;
		#declare Sframes = 120;
		#include "Shot420.pov"
	#end	
#end		
#if ( clock <= 2964 )		
	#if ( clock > 2814 )	
		#declare Sclock = (clock-2814)/150;
		#declare Sframes = 150;
		#include "Shot430.pov"
	#end	
#end		




