
// POV-Ray Object File - Helicopter
// created 6-Dec-02
// last update 5-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Helicoptor.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Chopper9
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Bobsled nose at X=0, rails at z=0, sled extends into +X
// Sky is +Z
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================

//#declare RotorSeed = seed(12345);
#declare RotorRot = rand(RotorSeed)*360;


//===============================================
//             Textures
//===============================================

#declare ChopperTex =
	texture {
		pigment { color rgb <0.117,0.222,0.420> }
		finish { ambient .10 specular .88 roughness .015 }
	}
#declare RotorTex =
	texture {
		pigment { color rgbt <0.317,0.322,0.320,0.76> }
		finish { ambient .10 metallic specular .38 roughness .035 }
	}
#declare RotorBladeTex =
	texture {
		pigment { color rgbt<0.117,0.222,0.420,0.55> }
		finish { ambient .10 specular .88 roughness .015 }
	}


//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================

//---------------- Helicopter ----------------------

#declare BT = 1.0; // blob threshold
#declare MBRF = 11.0;
#declare BSF = 2.0; // Main Blob Strength Factor
#declare OBRF = 11.0;  // Offset Component Radius Factor
#declare OBSF = 0.8; // Offset Blob Strength Factor
#declare OffsetB = 12.5; // distance between components
#declare ChopperShape =
	union {
		blob {
		threshold BT
			sphere { // main
				<0,0,0>,
				MBRF, BSF*1.0
				scale <1.0,1.0,1.0>
				translate <0,0,0>
			}
			sphere { // pull rear
				<0,0,0>,
				OBRF, OBSF
				scale <1.0,1.0,1.0>
				translate <OffsetB,0,-2>
			}
			sphere { // pull front
				<0,0,0>,
				OBRF, OBSF
				scale <1.0,1.0,1.0>
				translate <-OffsetB,0,-5>
			}
			scale <10,6,6>
		}
		superellipsoid {
			<.5,.5>
			scale <32,11,12>
			translate <2.2*Feet,0,3.5*Feet>
		}
/*
		cone { // boom
			<0,0,0>,14,<20.2*Feet,0,0>,10
			translate <2.0*Feet,0,2.2*Feet>
		}
		box { // tailevator
			<0,-33,0>,<27,33,1.6>
			translate < 20*Feet,0,3*Feet>
		}
		box { // tailfin
			<0,-1,-18>,<22,1,33>
			translate < 20*Feet,30,3*Feet>
		}
		box { // tailfin
			<0,-1,-18>,<22,1,33>
			translate < 20*Feet,-30,3*Feet>
		}
*/
		cone { // boom
			<0,0,0>,13,<20.2*Feet,0,0>,4
			translate <2.0*Feet,0,2.2*Feet>
		}
		box { // tailevator
			<0,-18,0>,<20,18,1.6>
			translate < 20.5*Feet,0,5*Feet>
		}
		box { // tailfin
			<0,-1,-18>,<14,1,33>
			rotate <0,20,0>
			translate < 20*Feet,4,3*Feet>
		}
		cylinder { // tail rotor
			<0,0,0>,<0,1.8,0>,19
			translate <20*Feet,-9,2.6*Feet>
			texture { RotorTex }
		}
		cylinder { // hub
			<0,0,0>,<0,0,2.8*Feet>,4
			translate <0,0,3*Feet>
		}
		cylinder { // hub disk
			<0,0,0>,<0,0,8>,19
			translate <0,0,4.7*Feet>
		}
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*0*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*1*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*2*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*3*360/5 }
		cylinder { <0,0,0>,<32,0,0>,4.2 scale <1,1,.4> translate <0,0,4.9*Feet> rotate z*4*360/5 }
		cylinder { // spinning rotor
			<0,0,0>,<0,0,3.5>,13*Feet
			translate <0,0,5*Feet>
			texture { RotorTex }
		}
		cylinder { // rotor blade
			<-13*Feet,0,0>,<13*Feet,0,0>,8
			scale <1,1,.1>
			translate <0,0,5*Feet>
			rotate z*RotorRot
			texture { RotorBladeTex }
		}
		texture { ChopperTex }
	} // end union
#declare Skid =
	union {
		cylinder { // main
			<0,0,0>,<9*Feet,0,0>,3.5
		}
		object { CurveTube(3*Feet,3.5,42) rotate z*180 }
		cylinder { // fore strut
			<0,0,0>,<0,0,4*Feet>,2.5
			scale <1.6,1,1>
			translate <3*Feet,0,0>
		}
		cylinder { // aft strut
			<0,0,0>,<0,0,4*Feet>,2.5
			scale <1.6,1,1>
			translate <6.8*Feet,0,0>
		}
		texture { ChopperTex }
	} // end union

#declare Chopper9 = // extends into +x
	union {
		object { ChopperShape }
		object { Skid rotate x*18 translate <-4*Feet,3.0*Feet,-5*Feet> }
		object { Skid rotate x*-18 translate <-4*Feet,-3.0*Feet,-5*Feet> }
		translate <0,0,5*Feet>
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 30
		location  <-3*Feet, -100*Feet, 50*Feet> // overall
		look_at <0*Feet,0*Feet,2*Feet>
	}

//background { rgb<.43,.34,.95> } // sky blue
background { rgb<.03,.04,.05> } // black
light_source
{ <140*Feet,-135*Feet,150*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-120*Feet,130*Feet>, <1.13,1.08,0.83>*.6
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
light_source
{ <-14*Feet,-12*Feet,130*Feet>, <1.00,1.18,1.03>*.4
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1*Feet }
//object { TestSphere scale 20 translate <0,0,20> }

object { Chopper9 scale 1 rotate z*0 translate <-0*Feet,0*Feet ,0*Feet> }


#end
