
// Glenn's POV-Ray Animation File - Bobsled Shot 100
// created 25-Nov-02
// last update 2-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

//===============================================
//             Variables
//===============================================

#declare SignPoint = <0,0,48>;
//#declare Sclock = 0.75; // for testing only

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50
	location SignPoint-<5*Feet,0,0>
  look_at SignPoint
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//	location <40*Feet,-90*Feet,6*Feet>
//	look_at <71*Feet,0,5*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare FlatBlack = // does not illuminate
	texture {
		pigment { Black }
		finish { ambient 0 specular 0 roughness .005 }
	}

#declare BrightBlue =
    texture {
      pigment { color <.1,.1,1> }
      finish { ambient .8 phong .6 }
    }

#declare AmbientWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient 1.0 phong .6 }
    }

//===============================================
//             Lighting
//===============================================

object {FadeBulb(60,48) translate <-40*Feet,12*Feet,14*Feet> }


//===============================================
//             Environment
//===============================================


//===============================================
//             Objects
//===============================================

#declare SignBackground =
	box {
		<0,0,0>,<1,6*Feet,4*Feet>
		translate <0.2,-3*Feet,-2*Feet>
		texture { FlatBlack }
//		texture { WhitePaint }
	}
#declare Lettering1 =
	text {
		ttf "c:\Windows\Fonts\ARIALBD.TTF",
		"A Snowball's",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
//		texture { BrightWhite }
		texture { AmbientWhite }
		scale <3.5,3.2,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare Lettering2 =
	text {
		ttf "c:\Windows\Fonts\ARIALBD.TTF",
		"CHANCE",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
		texture { BrightBlue }
		scale <6,4,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare Lettering3 =
	text {
		ttf "c:\Windows\Fonts\ARIAL.TTF",
		"by",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
		texture { AmbientWhite }
		scale <2.8,2.5,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare Lettering4 =
	text {
		ttf "c:\Windows\Fonts\ARIAL.TTF",
		"Glenn McCarter",
		.05,     // THICKNESS_FLOAT
		0       //OFFSET_VECTOR
//		texture { WhitePaint }
		texture { AmbientWhite }
		scale <3,2.6,1>
		rotate <90,0,-90>
		translate <0,0,0>
	}
#declare YBox =
	union {
	box {
		<0,0,0>,<.01,1,1>
		texture {
			pigment {
				gradient y
				color_map {
//					[0.00 color rgb<0,0,2> ] // ends visible
					[0.03 color rgb<0,0,0> ]
					[0.30 color rgb<0,0,0> ]
					[0.32 color rgb<1,1,1> ]
					[0.36 color rgb<1,1,1> ]
					[0.50 color rgbt<1,1,1,1> ]
					[0.97 color rgbt<1,1,1,1> ]
//					[1.00 color rgb<2,0,0> ] // ends visible
				}
			}
			finish { ambient .6 }
			scale 1
			translate <0,-1,0>
		}
	}
	box { // long black tail
		<0,-1,0>,<.01,0.01,1>
		texture { pigment { color rgb<0,0,0> } finish { ambient 0 } }
	}
	} // end union
#declare ZBox =
	union {
	box {
		<0,0,0>,<.01,1,1>
		texture {
			pigment {
				gradient z
				color_map {
//					[0.00 color rgb<0,0,2> ] // ends visible
					[0.03 color rgb<0,0,0> ]
					[0.35 color rgb<0,0,0> ]
					[0.36 color rgb<1,1,1> ]
					[0.39 color rgb<1,1,1> ]
					[0.48 color rgbt<1,1,1,1> ]
					[0.97 color rgbt<1,1,1,1> ]
//					[1.00 color rgb<2,0,0> ] // ends visible
				}
			}
			finish { ambient .6 }
			scale 1
			translate <0,-1,0>
		}
	}
	box { // long black tail
		<0,0,-1>,<.01,1,0.01>
		texture { pigment { color rgb<0,0,0> } finish { ambient 0 } }
	}
	} // end union
#declare Sign =
	union {
		object { SignBackground translate <0,0,0>}
		object { Lettering1 translate <-.1,14,(-Sclock*4)+8> } //Air
		object { Lettering2 translate <-.1,(-Sclock*7)+9,0> } //Freight
		object { Lettering3 translate <-.1,20,(-Sclock*4)-7> } //by
		object { Lettering4 translate <-.1,(Sclock*5)+11,-11> } //GMc
		object { ZBox scale <1,24,150> translate <-.5,-8,(-Sclock*130)-30> } //Air
		object { YBox scale <1,260,4> translate <-.4,(-Sclock*240)-00,-.5> } //Freight
		object { ZBox scale <1,4,150> translate <-.3,17,(-Sclock*250)+50> } //by
		object { YBox scale <1,-260,3> translate <-.2,(Sclock*300)-50,-11.6> } //GMc
	}


//===============================================
//             Object Placement
//===============================================

object { Sign translate SignPoint }
