
// Glenn's POV-Ray Animation File - Bobsled Shot 105
// created 26-Dec-02
// last update 28-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>; // start
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

#include "AnimMacros.inc"

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  angle 26+5*Seconds
  location  <-60*Feet,-72*Feet, 12*Feet>
//  look_at   <-33*Feet+3*Feet*Seconds*Seconds,-10*Feet-10*Feet*Seconds, 10*Feet-2*Feet*Seconds >
  look_at   <-36*Feet+3*Feet*Seconds*Seconds,-10*Feet-1*Feet*Seconds, 10*Feet-3*Feet*Seconds >
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <20*Feet,0*Feet, 18*Feet> // scene view
  look_at   <0*Feet,10*Feet , 16*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

#declare ConcreteBlockTex =
	texture {
		pigment { color rgb<.86,.88,.89>*1.3 }
//pigment { rgb<1,1,1> }
//		finish { ambient .2 specular .4 roughness 0.12 }
//		finish { ambient 0.2 diffuse 0.5 specular 0.13 roughness 0.24 }
		finish { ambient 0.63 diffuse 0.1 specular 0.13 roughness 0.16 } // no shadows
	}

//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,30*Feet-22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,30*Feet-22,0> }
		texture { BluePaintTex } 
	} // end union

#declare LowerFloor =
	union {
		difference {
			box {
				<-30*Feet,0,-10*Feet>,<0*Feet,20*Feet,10*Feet>
			}
			box { // window
				<-6,0,0>,<1,4*Feet,3*Feet>
				translate <0,3*Feet,48>
			}
		} // end difference
		box {
			<-1,0,-10*Feet>,<3.3*Feet,10*Feet,7*Feet>
			translate <0,10*Feet,0>
		}
		texture { ConcreteBlockTex }
	} // end union
#declare UpperFloor =
	union {
		box {
			<-18*Feet,0,0>,<0,12*Feet,9*Feet>
		}
		texture { ConcreteBlockTex }
	} // end union

#declare StartingBuilding =
	union {
		object { LowerFloor }
		object { UpperFloor translate <0,-24,10*Feet> }
	} // end union

#declare BigSign =
	union {
		box {
			<0,0,0>,<16*Feet,2*Feet,8*Feet> // backdrop
		}
		cylinder { <0,0,-50>,<0,0,3*Feet>,5 translate <3*Feet,18,0> }
		cylinder { <0,0,-50>,<0,0,3*Feet>,5 translate <16*Feet-3*Feet,18,0> }
		texture {
			pigment { color rgb<1,1,1> }
			finish { ambient 0.2 specular 0.4 roughness 0.05 }
		}
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "WCsign.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
				rotate x*90
				scale <14*Feet,1,6*Feet>
				translate <1*Feet,0,1*Feet>
			}
			finish { ambient .6 }
		}
	} // end union

//===============================================
//             Objects
//===============================================

#include "WinterChild.inc"

#declare SnowballTossingChild =
	union {
		object { CoatWithHood translate <0,0,20> }
		object { SnowPantsWithBoots }
		#switch (Seconds)
		#range (0,1.1)
			object { RightArm rotate y*45 rotate x*18 translate <-8,0,35> }
		#break
		#range (1.101,2.0)
			object { RightArm rotate y*45 rotate x*(18-180*(Seconds-1.1)) translate <-8,0,35> }
		#break
		#else
			object { RightArm rotate y*45 rotate x*(18-180*(2-1.1)+120*(Seconds-2.0)-12*(Seconds-2.0)*(Seconds-2.0)) translate <-8,0,35> }
		#end
		object { RightArm scale <-1,1,1> rotate <0,-55-24*Seconds,0> translate <8,0,35> } // left arm
	} // end union

#declare RS = seed(20549);
#declare SnowBall =
	union {
//		cylinder { <0,0,-20*Feet>,<0,0,0>,3 } // test
		#declare SS = 0;
		#while ( SS < 11 )
			sphere {
				<0,0,0>,1.4+rand(RS)*0.3
				translate <0,0,-0.8>
				rotate y*(360*rand(RS))
				rotate z*(360*rand(RS))
			}
			#declare SS = SS + 1;
		#end
		texture { BrightSnowyTex scale 0.3 }
	} // end union

#declare Snowman =
	union {
		object { SnowBall scale 6 translate <0,0,10> }
		object { SnowBall rotate <230,22,80> scale 4 translate <0,0,25> }
		object { SnowBall rotate <20,232,189> scale 3 translate <0,0,39> }
		sphere { <0,0,0>,1.4 scale <1,2,1> texture { pigment {rgb<.7,.4,.2>} } translate <-2,-6,41> }
		sphere { <0,0,0>,1.4 scale <1,2,1> texture { pigment {rgb<.7,.4,.2>} } translate < 2,-6,41> }
		cone { <0,0,0>,1.3,<0,-8,0>,0.3 texture { pigment {rgb<.7,.4,.2>} } translate <0,-6,37> }
	} // end union

#declare WST = 2.2; // trail width
#declare FakeSnowTrail =
	union {
		sphere { <0,0,-2>,WST }
		box { <WST/2,0,-4>,<WST/2,-2*Feet*(Seconds-2.54),0.1> }
		sphere { <0,0,0>,WST translate <0,-2*Feet*(Seconds-2.54),0> }
		texture { SnowyTex scale 0.3 }
	} // end union

#macro Peeps(RS)
	union {
		cylinder {
			<0,0,-48>,<0,0,24>,12
			scale <.6,1,1>
		}
		sphere {
			<0,0,0>,5
			translate <0,0,28>
		}
		texture {
			pigment { color rgb<rand(RS),rand(RS),rand(RS)> }
			finish { ambient 0.05+rand(RS)*.4 specular 0.3+rand(RS)*0.3 roughness 0.05 }
		}
	} // end union
#end

#declare RS = seed(103495);
#declare GrandStand =
	union {
		#declare Steps = 1;
		#while ( Steps < 14 )
			box {
				<0,0,-20*Feet>,<18,40*Feet,Steps*10>
				translate <Steps*18,0,0>
				texture { ConcreteBlockTex }
			}
			#local Peepl = 1;
			#while ( Peepl < 20 )
				object { Peeps(RS) translate <9+Steps*18,30+rand(RS)*36*Feet,Steps*10> }
				#local Peepl = Peepl + 1;
			#end
			#declare Steps = Steps + 1;
		#end
		box { <-4*Feet,-4*Feet,-10*Feet>,<40*Feet,50*Feet,0> texture { ConcreteBlockTex } }
		cone { <0,0,0>,4,<0,0,30*Feet>,2 texture { BluePaintTex } translate <22*Feet,4*Feet,0> }
		cone { <0,0,0>,4,<0,0,30*Feet>,2 texture { BluePaintTex } translate <22*Feet,4*Feet+1*8*Feet,0> }
		cone { <0,0,0>,4,<0,0,30*Feet>,2 texture { BluePaintTex } translate <22*Feet,4*Feet+2*8*Feet,0> }
		cone { <0,0,0>,4,<0,0,30*Feet>,2 texture { BluePaintTex } translate <22*Feet,4*Feet+3*8*Feet,0> }
	} // end union


//===============================================
//             Object Placement
//===============================================

object { StartingGround translate <0,0,13*Feet> }
object { Pavilion translate <0,30*Feet,13*Feet> }
object { StartingBuilding scale <-1,1,1> rotate z*40 translate <-60*Feet,-1*Feet,5*Feet> }
object { GrandStand translate <10*Feet,-40*Feet,12*Feet> }
object { BigSign scale <0.8,1,1> translate <-40*Feet,-15*Feet,8*Feet> }
object { Snowman rotate z*-70 translate <-42*Feet,-48*Feet,6*Feet> }
object { SnowBall rotate <330,122,20> scale 5 translate <-40*Feet,-58*Feet,6.5*Feet> }

//camera <-60*Feet,-72*Feet, 12*Feet>
#declare ChildPos = <-50*Feet,-40*Feet,6*Feet>;
#switch ( Seconds )
#range (0,1.8)
	object { SnowballTossingChild rotate <0,0,0> translate ChildPos } 
#break
#else
	object { SnowballTossingChild rotate <0,Shake(1,10382,(Seconds-1.8)/2)*15,0> translate ChildPos } 
#end

#declare SBZHeight =
	ChildPos.z + <0,0,26>
		+ <0,0,25*Feet*(Seconds-1.4)>
		+ <0,0,-32*Feet*(Seconds-1.4)*(Seconds-1.4)>;
#if ( Debug = 1) #debug concat("SnowballZHeight: ",str(SBZHeight.z/12,5,3),"\n") #end
//#if (SBZHeight < 6*Feet)
//	#declare SBZVel = -SBZVel;
//#end
#declare SBPos =
	ChildPos + <-21,0,26>
		+ <3*Feet*(Seconds-1.4),-18*Feet*(Seconds-1.4),25*Feet*(Seconds-1.4)>
		+ <0,0,-32*Feet*(Seconds-1.4)*(Seconds-1.4)>;
#if ( Debug = 1) #debug concat("SBPos:","<",str(SBPos.x,5,1),",",str(SBPos.y,5,1),",",str(SBPos.z,5,1),">","\n") #end

#switch (Seconds)
#range(0,1.4)
object { SnowBall // static
	translate ChildPos + <-21,0,26>
}
#break
#range (1.401,2.240)
object { SnowBall // tossed
	rotate x*360*Seconds
		translate SBPos
}
#break
#range (2.241,2.540)
object { SnowBall // between bounces
	rotate x*360*Seconds
		scale 1.1
		translate <-580.8,-661.4,79.0>
		+ <2.4*Feet*(Seconds-2.24),-14*Feet*(Seconds-2.24),10*Feet*(Seconds-2.24)>
		+ <0,0,-32*Feet*(Seconds-2.24)*(Seconds-2.24)>
}
#break
#else
object { SnowBall // rolling
	rotate x*360*Seconds
		scale 1.1
		translate <-580.8,-661.4,79.0>
		+ <2.4*Feet*(2.54-2.24),-14*Feet*(2.54-2.24),10*Feet*(2.54-2.24)>
		+ <0,0,-32*Feet*(2.54-2.24)*(2.54-2.24)>
		+ <0,-2*Feet*(Seconds-2.54),0>
}
object { FakeSnowTrail
		translate <-580.8,-661.4,79.0>
		+ <2.4*Feet*(2.54-2.24),-14*Feet*(2.54-2.24),10*Feet*(2.54-2.24)>
		+ <0,0,-32*Feet*(2.54-2.24)*(2.54-2.24)>
		+ <-1,0,-1>
} 
#end

