
// Glenn's POV-Ray Animation File - Bobsled Shot 245
// created 29-Dec-02
// last update 2-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <210*Feet,630*Feet,0>; // beginning of turn 6
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

//#declare SledPos = <110*Feet,0,5*Feet>;
#declare SledPos = <150*Feet,0,5*Feet>;
#declare SledPos = SledPos + <-73*Feet*Seconds,0,0>;

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end
#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location  <6*Feet,16*Feet, 12*Feet>
  look_at   SledPos +<-0*Feet,-0, 18> 
//look_at <110*Feet,0,5*Feet> // static
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 65
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  SledPos + <-3*Feet,1.5*Feet, 120*Feet>
  look_at   SledPos +<3*Feet,1.5*Feet, 320> 
  }


camera {
//  Special_Cam
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <0*Feet,9*Feet,2*Feet> }
object { TrackLight translate <24*Feet,9*Feet,2*Feet> }
object { TrackLight translate <48*Feet,9*Feet,2*Feet> }
object { TrackLight translate <72*Feet,9*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"

object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin+<0,0,4*Feet> }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,5*Feet> }

#declare SnowballHill =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "SnowHillHF.png"
		smooth
		water_level 1/255
		double_illuminate
		rotate x*90
		scale <1,-1,1>
		scale <80*Feet,60*Feet,12*Feet>
		texture { SnowyTex }
//		rotate x*17
//		translate <-500*Feet,0,100*Feet>
	}

object { SnowballHill translate <25*Feet,-20*Feet,0> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare RS = seed(10389);

#declare ThreeFootSnowball =
	union {
		sphere { // main
			<0,0,0>,18
		}
		#declare SS = 0;
		#while (SS<50)
			sphere {
				<0,0,0>,3.6+rand(RS)*2.0
				translate <0,0,-18>
				rotate y*(360*rand(RS))
				rotate z*(360*rand(RS))
			}
			#declare SS = SS + 1;
		#end
		texture { IcyTex scale 0.3 }
		rotate x*360*2.5*Seconds
		translate <0,0,12>
	} // end union


//===============================================
//             Object Placement
//===============================================

// speed 73 ft/s
object { BobsledSFull
	translate SledPos
}

object { ThreeFootSnowball
	translate <35*Feet,20*Feet,10*Feet>+<0,-33*Feet*Seconds,22*Feet*Seconds>+<0,0,-32*Feet*Seconds*Seconds>
//	translate <35*Feet,20*Feet,10*Feet>+<0,-30*Feet*Seconds,6*Feet*Seconds>
	}

/*
cylinder { // for testing snowball position
	<0,0,-30*Feet>,<0,0,0>,1.2*Feet
	texture { SnowyTex }
	translate <35*Feet,20*Feet,10*Feet>+<0,-33*Feet*Seconds,20*Feet*Seconds>+<0,0,-32*Feet*Seconds*Seconds>
}
*/