
// Glenn's POV-Ray Animation File - Bobsled Shot 330
// created 12-Dec-02
// last update 10-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,400*Feet,0>; // end of straight 9
#declare Seconds = Sclock*(Sframes/FPS)/5+0.9; // SLO-MO: time speeded up 5x in this shot
#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

#include "TrackMaker.inc"

// 95 ft/sec
#switch ( Seconds )
#range ( 0, 1.0 )
	#declare SledRot = <0,0,0>;
	#declare SledPos = <0,110*Feet,2*Feet>;
	#declare SledPos = SledPos + <0,-90*Feet*Seconds,0>;
#break
#range ( 1.001, 1.100 )
	#declare SledRot = <0-200*(Seconds-1),0,0>;
	#declare SledPos = <0,20*Feet,2*Feet>;
	#declare SledPos = SledPos + <0,-65*Feet*(Seconds-1.0),50*Feet*(Seconds-1.0)>;
#break
#else
	#declare SledRot = <-20-15*(Seconds-1.1),0,0>;
	#declare SledPos = <0,20*Feet,2*Feet>;
	#declare SledPos = SledPos + <0,-65*Feet*0.1-65*Feet*(Seconds-1.1),50*Feet*0.1+40*Feet*(Seconds-1.1)>;
#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end
#end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 24
  location  <-50*Feet,-20*Feet,10*Feet>
  look_at   <0,20*Feet,8*Feet> + <0*Feet,-0*Feet*Seconds,0*Feet+0*Feet*Seconds*Seconds> 
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 65
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  SledPos + <-3*Feet,1.5*Feet, 120*Feet>
  look_at   SledPos +<3*Feet,1.5*Feet, 320> 
  }


camera {
//  Special_Cam
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,80*Feet,2*Feet> }
object { TrackLight rotate z*-45 translate <-40*Feet,-24*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-40*Feet,130*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"

object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare RS = seed(105478);

#declare SixFootSnowball =
	union {
		sphere { // main
			<0,0,0>,36
		}
		#declare SS = 0;
		#while (SS<60)
			sphere {
				<0,0,0>,5.2+rand(RS)*4.2
				translate <0,0,-33>
				rotate y*(0+180*rand(RS))
				rotate z*(0+360*rand(RS))
			}
			#declare SS = SS + 1;
		#end
		texture { IcyTex scale 0.3 }
	} // end union

#declare SB=1.03; // time when spray effect begins
#declare SBArray = array[18][2] // snowball initial positions and velocities
{
	{<0,-10,40>,  < -2*Feet*(Seconds-SB),-55*Feet*(Seconds-SB),45*Feet*(Seconds-SB)>},
	{<-8,23,44>,  < -1*Feet*(Seconds-SB),-32*Feet*(Seconds-SB),55*Feet*(Seconds-SB)>},
	{<-12,12,42>, <  4*Feet*(Seconds-SB),-42*Feet*(Seconds-SB),31*Feet*(Seconds-SB)>}
	{<4,4,38>,    < -1*Feet*(Seconds-SB),-45*Feet*(Seconds-SB),64*Feet*(Seconds-SB)>},
	{<-18,-13,39>,<-14*Feet*(Seconds-SB),-33*Feet*(Seconds-SB),50*Feet*(Seconds-SB)>},
	{<-2,-8,37>,  < -5*Feet*(Seconds-SB),-32*Feet*(Seconds-SB),45*Feet*(Seconds-SB)>}

	{<6,-20,38>,  < -8*Feet*(Seconds-SB),-14*Feet*(Seconds-SB),72*Feet*(Seconds-SB)>},
	{<-18,23,38>, <-11*Feet*(Seconds-SB),-22*Feet*(Seconds-SB),65*Feet*(Seconds-SB)>},
	{<12,-22,37>, <  5*Feet*(Seconds-SB), -8*Feet*(Seconds-SB),99*Feet*(Seconds-SB)>}
	{<14,14,29>,  < -8*Feet*(Seconds-SB), -5*Feet*(Seconds-SB),118*Feet*(Seconds-SB)>},
	{<12,3,34>,   <-12*Feet*(Seconds-SB),-34*Feet*(Seconds-SB),85*Feet*(Seconds-SB)>},
	{<-22,18,36>, <-25*Feet*(Seconds-SB),-16*Feet*(Seconds-SB),75*Feet*(Seconds-SB)>}

	{<-6,10,38>,  <-28*Feet*(Seconds-SB), -9*Feet*(Seconds-SB),42*Feet*(Seconds-SB)>},
	{<-22,13,32>, <-31*Feet*(Seconds-SB),-12*Feet*(Seconds-SB),35*Feet*(Seconds-SB)>},
	{<7,22,40>,   < 35*Feet*(Seconds-SB), -8*Feet*(Seconds-SB),22*Feet*(Seconds-SB)>}
	{<-4,10,39>,  <-18*Feet*(Seconds-SB),-15*Feet*(Seconds-SB),46*Feet*(Seconds-SB)>},
	{<-12,-3,38>, <-33*Feet*(Seconds-SB), -4*Feet*(Seconds-SB),49*Feet*(Seconds-SB)>},
	{<12,-10,38>, <-25*Feet*(Seconds-SB),-16*Feet*(Seconds-SB),54*Feet*(Seconds-SB)>}
}

#declare SprayEffect =
	union {
#declare SB = 0;
#while ( SB < 18)
	sphere {
		<0,0,0>,2+rand(RS)*5
		texture { IcyTex scale 0.3 }
		translate <0*Feet,20*Feet,2.5*Feet>
			+ SBArray[SB][0] // position
			+ SBArray[SB][1] // velocity
			+ <0,0,-32*Feet*(Seconds-1.0)*(Seconds*1.0)> // acceleration
	}
	#declare SB = SB + 1;
#end
} // end union

//===============================================
//             Object Placement
//===============================================

object { SixFootSnowball translate <0*Feet,20*Feet,2.5*Feet> }
#if (Seconds > 1.03 )
	object { SprayEffect }
#end

// speed 95 ft/s
object { BobsledSFull
	rotate z*90
	translate <0,-6*Feet,0>
		rotate x*SledRot
	translate <0, 6*Feet,0>
	translate SledPos
}


