
// Glenn's POV-Ray Animation File - Bobsled Shot 380
// created 14-Dec-02
// last update 14-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,170*Feet,0>; // impact point
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

#declare SledSpline =
	spline {
		natural_spline
		0.0, <  0,  0*Feet,0>,
		0.1, < 21, -5*Feet,0>,
		0.2, <  0,-10*Feet,0>,
		0.3, <-21,-15*Feet,0>,		
		0.4, <  0,-20*Feet,0>,
		0.5, < 12,-25*Feet,0>,
		0.6, < -6,-30*Feet,0>,
		1.0, <  0,-50*Feet,0>,
		1.3, <  0,-65*Feet,0>,
	}

// 60 ft/sec
//#declare SledRot = <0,0,0>;
#declare Deriv = SledSpline((Seconds-0.03)*1.0) - SledSpline((Seconds-0.02)*1.0);
#declare Alpha = degrees(atan2(Deriv.y,Deriv.x))-90;
#declare SledRot = <0,0,Alpha/2>;
//#declare SledPos = <0,0*Feet,2*Feet>+<0,-60*Feet*Seconds,0>;
#declare SledPos = <0,0*Feet,2*Feet>+SledSpline(Seconds*1.0);

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end
#if ( Debug = 1) #debug concat("D.x: ",str(Deriv.x,5,3),"\n") #end
#if ( Debug = 1) #debug concat("D.y: ",str(Deriv.y,5,3),"\n") #end
#if ( Debug = 1) #debug concat("Alpha: ",str(Alpha,5,3),"\n") #end
#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end



//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 15+40*Seconds
  location  <-2.5*Feet,-60*Feet,4.0*Feet+6*Feet*Seconds*Seconds>
  look_at   SledPos + <0*Feet,5*Feet*Seconds,2*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <30*Feet,05*Feet, 12*Feet>
  look_at   SledPos +<0*Feet,.5*Feet, 0> 
  }

camera {
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,-20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,-80*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-24*Feet,-80*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
//object { Plain rotate x*-17 translate -LocalOrigin }
object { Plain rotate x*-17 translate -LocalOrigin+<0,-200*Feet,0> }
object { TrackTerrain translate -LocalOrigin }
//object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1200*Feet,220*Feet> translate -LocalOrigin }
//object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1000*Feet ,-500*Feet> translate -LocalOrigin }

object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"


//===============================================
//             Object Placement
//===============================================


// speed 80 ft/s
object { BobsledSFull
	rotate z*90
	rotate SledRot
	translate SledPos
}

