
// Glenn's POV-Ray Animation File - Bobsled Shot 390
// created 14-Dec-02
// last update 5-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <400*Feet,150*Feet,0>; // finish line
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"


// 60 ft/sec
#declare SledRot = <0,0,0>;
#declare SledPos = <0,-40*Feet,2*Feet>+<0,60*Feet*Seconds,0>;

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end
#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end



//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50
  location  <7*Feet,4*Feet,2*Feet+5.5*Feet>
  look_at   <0*Feet,0*Feet,2*Feet+3*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <30*Feet,05*Feet, 12*Feet>
  look_at   SledPos +<0*Feet,.5*Feet, 0> 
  }

camera {
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,-20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,-80*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-24*Feet,-80*Feet,2*Feet> }

#declare FinishSpot =
  light_source {
    <3*Feet,0,6*Feet>
    color rgb<1.12, 1.07, 0.97>*0.7
    spotlight
    point_at <0,0,0>
    radius 22    // degrees fully lit (*2)
    falloff 40   // degrees no lighting (*2)
    tightness 1
	}
#object { FinishSpot translate <0,0,2*Feet> }

#declare FluorescentSpot =
  light_source {
    <6*Feet,5*Feet,11.5*Feet>
    color rgb<0.92, 1.1, 1.3>*0.9
    spotlight
    point_at <0,0,0>
    radius 42    // degrees fully lit (*2)
    falloff 60   // degrees no lighting (*2)
    tightness 1
	}
#object { FluorescentSpot translate <0,0,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
//object { Plain rotate x*-17 translate -LocalOrigin }
object { Plain rotate x*-17 translate -LocalOrigin+<0,-200*Feet,0> }
object { TrackTerrain translate -LocalOrigin }
//object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1200*Feet,220*Feet> translate -LocalOrigin }
//object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1000*Feet ,-500*Feet> translate -LocalOrigin }

object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"
#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,30*Feet-22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,30*Feet-22,0> }
		texture { BluePaintTex } 
	} // end union


#declare FinishLine =
	union {
		box {
			<-6,0,0>,<0,6,5*Feet>
			texture { pigment { rgb<.9,.9,1.3> } }
		}
		box {
			<-6,2.5,0>,<0.3,3.5,5*Feet>
			texture { pigment { rgb<.9,.9,1.3>*.2 } }
		}
		cylinder {
			<-12,0,0>,<4,0,0>,2
			texture { pigment { rgb<.47,.47,.49> } }
			translate <0,0,24>
		}
		sphere {
			<0,0,0>,1.7
			scale <.7,1,1>
			texture {
				pigment { rgb<.47,.47,.49>*0.2 }
				finish { reflection 0.9 }
			}
			translate <4,0,24>
		}
		cylinder {
			<-12,0,0>,<4,0,0>,0.7
			texture { pigment { rgb<.47,.47,.49>*.6 } }
			translate <0,0,29>
		}
		cylinder {
			<-12,0,0>,<4,0,0>,1.2
			texture { pigment { rgb<.47,.87,.49>*.96 } }
			rotate y*30
			translate <0,-1.6,36>
		}
			translate <-34,0,0>
	} // end union

//===============================================
//             Object Placement
//===============================================

object { Pavilion translate <0,-20*Feet,2*Feet> }
object { FinishLine translate <0,0,2*Feet> }

// speed 80 ft/s
object { BobsledSFull
	rotate z*-90
	rotate SledRot
	translate SledPos
}

