
// Glenn's POV-Ray Animation File - Bobsled Shot 420
// created 14-Dec-02
// last update 24-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <400*Feet,150*Feet,0>; // finish line
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	#if ( Seconds < 1)
		angle 20-5*Seconds
	#else
		angle 15
	#end 
  location  <33*Feet,20*Feet,6*Feet>
  look_at   <27.5*Feet,0,10*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <30*Feet,05*Feet, 12*Feet>
  look_at   <0*Feet,.5*Feet, 0> 
  }

camera {
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

#declare WhiteSignTex =
	texture {
		pigment { color rgb<.96,.98,.99>*1.3 }
		finish { ambient 0.14 specular 0.85 roughness 0.02 metallic }
	}
#declare BlackSignTex =
	texture {
		pigment { color rgb<.036,.038,.039> }
		finish { ambient 0.04 diffuse 0.4 specular 0.1 roughness 0.04 }
	}
#declare LEDTex =
	texture {
		pigment { color rgb<1.96,.98,.09> }
		finish { ambient 0.44 specular 0.5 roughness 0.04 }
	}
#switch (Seconds)
#range (0,0.2)
	#declare BlinkTex = BlackSignTex;
#break
#range (0.201,0.4)
	#declare BlinkTex = LEDTex;
#break
#range (0.401,0.6)
	#declare BlinkTex = BlackSignTex;
#break
#range (0.601,0.8)
	#declare BlinkTex = LEDTex;
#break
#range (0.801,1.0)
	#declare BlinkTex = BlackSignTex;
#break
#range (1.001,1.2)
	#declare BlinkTex = LEDTex;
#break
#range (1.201,1.4)
	#declare BlinkTex = BlackSignTex;
#break
#else
	#declare BlinkTex = LEDTex;
#end

//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,-20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,-80*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-24*Feet,-80*Feet,2*Feet> }

#declare FinishSpot =
  light_source {
    <3*Feet,0,6*Feet>
    color rgb<1.12, 1.07, 0.97>*0.7
    spotlight
    point_at <0,0,0>
    radius 22    // degrees fully lit (*2)
    falloff 40   // degrees no lighting (*2)
    tightness 1
	}
#object { FinishSpot translate <0,0,2*Feet> }

#declare FluorescentSpot =
  light_source {
    <6*Feet,5*Feet,11.5*Feet>
    color rgb<0.92, 1.1, 1.3>*0.9
    spotlight
    point_at <0,0,0>
    radius 42    // degrees fully lit (*2)
    falloff 60   // degrees no lighting (*2)
    tightness 1
	}
#object { FluorescentSpot translate <0,0,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
//object { Plain rotate x*-17 translate -LocalOrigin }
object { Plain rotate x*-17 translate -LocalOrigin+<0,-200*Feet,0> }
object { TrackTerrain translate -LocalOrigin }
//object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1200*Feet,220*Feet> translate -LocalOrigin }
//object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1000*Feet ,-500*Feet> translate -LocalOrigin }

object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

//#include "Bobsled.inc"

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		translate <0,-12*Feet,0>
		texture { BluePaintTex } 
	} // end union


#declare FinishLine =
	union {
		box {
			<-6,0,0>,<0,6,5*Feet>
			texture { pigment { rgb<.9,.9,1.3> } }
		}
		box {
			<-6,2.5,0>,<0.3,3.5,5*Feet>
			texture { pigment { rgb<.9,.9,1.3>*.2 } }
		}
		cylinder {
			<-12,0,0>,<4,0,0>,2
			texture { pigment { rgb<.47,.47,.49> } }
			translate <0,0,24>
		}
		sphere {
			<0,0,0>,1.7
			scale <.7,1,1>
			texture {
				pigment { rgb<.47,.47,.49>*0.2 }
				finish { reflection 0.9 }
			}
			translate <4,0,24>
		}
		cylinder {
			<-12,0,0>,<4,0,0>,0.7
			texture { pigment { rgb<.47,.47,.49>*.6 } }
			translate <0,0,29>
		}
		cylinder {
			<-12,0,0>,<4,0,0>,1.2
			texture { pigment { rgb<.47,.87,.49>*.96 } }
			rotate y*30
			translate <0,-1.6,36>
		}
			translate <-34,0,0>
	} // end union

#declare StrArray = array[6]
#declare StrArray[0] = "1"
#declare StrArray[1] = "2  Germany II"
#declare StrArray[2] = "3  Canada I"
#declare StrArray[3] = "4  Bulgaria"
#declare StrArray[4] = "5  Austria I"
#declare StrArray[5] = "6  Romania"
#declare SignText =
#declare TimeArray = array[6]
//#declare TimeArray[0] = "  :59.007"
#declare TimeArray[0] = " "
#declare TimeArray[1] = "1:06.463"
#declare TimeArray[2] = "1:06.509"
#declare TimeArray[3] = "1:07.122"
#declare TimeArray[4] = "1:07.126"
#declare TimeArray[5] = "1:07.139"

#declare SignText =
	union {
		#declare TCount = 0;
		#while ( TCount < 6 )
		text {
			ttf "arialbd.ttf"
			StrArray[TCount]
			.1,0
			rotate x*90
			scale <3.4,1,3.4>
			translate <6,-0.0,25-TCount*4>
		}
		text {
			ttf "arialbd.ttf"
			TimeArray[TCount]
			.1,0
			rotate x*90
			scale <3.4,1,3.4>
			translate <34,-0.0,25-TCount*4>
		}
		#declare TCount = TCount + 1;
		#end
		text {
			ttf "arialbd.ttf"
			"    Bermuda            :59.007 WR"
			.1,0
			rotate x*90
			scale <3.4,1,3.4>
			translate <6,-0.0,25>
			texture { BlinkTex }
		}
		text {
			ttf "arialbd.ttf"
			"FINAL STANDINGS"
			.1,0
			rotate x*90
			scale <3.4,1,3.4>
			translate <14,-0.0,30>
			texture { LEDTex }
		}
		texture { LEDTex }
	} // end union

#declare Scoreboard =
	union {
		box {
			<0,0.5,0>,<60,10,40>
			texture { WhiteSignTex }
		}
		box {
			<4,0,4>,<60-4,10,40-4>
			texture { BlackSignTex }
		}
		object { SignText }
		cylinder {
			<0,0,-10*Feet>,<0,0,30>,4
			translate <12,5,0>
			texture { WhiteSignTex }
		}
		cylinder {
			<0,0,-10*Feet>,<0,0,30>,4
			translate <60-12,5,0>
			texture { WhiteSignTex }
		}
	} // end union


//===============================================
//             Object Placement
//===============================================

object { Pavilion translate <0,0,2*Feet> }
object { FinishLine translate <0,0,2*Feet> }

object { Scoreboard rotate z*150 translate <30*Feet,0,8*Feet> }
