#declare block_size=<16, 8, 8>/2;
#declare mortr_size=<0, 0, 0>/2;

global_settings {
	ambient_light 1/100000
}

#macro block(vec)
	box {
		0, block_size-mortr_size
		texture {
			pigment {
				rgb 0.5+vturbulence(2, 0.5, 6, vec).z/3
			}
		}
		translate mortr_size/2
	}
	/*box {
		0, <block_size.x, block_size.y, mortr_size.z>
		translate z*block_size/2
		texture {
			pigment {
				rgb 1
			}
		}
	}*/
#end

#macro wall(long, hi)
	#local cx=0;
	#while (cx < long)
		#local cy=0;
		#while (cy <= hi)
			#if (cy=hi)
				#if (mod(cx,2)=0)
					object {
						#declare this_trans=<cx+(mod(cy,2)/2), cy, 0>*block_size;
						block(this_trans)
						translate this_trans+z*vturbulence(2, 0.5, 6, this_trans)*2
					}
				#end
			#else
				object {
					#declare this_trans=<cx+(mod(cy,2)/2), cy, 0>*block_size;
					block(this_trans)
					translate this_trans+z*vturbulence(2, 0.5, 6, this_trans)*2
				}
			#end
			#local cy=cy+1;
		#end
		#local cx=cx+1;
	#end
#end

union {
	#declare wall_len=25;
	#declare wall_hi=10;
	union {
		wall(wall_len, wall_hi)
		translate -x*block_size.x/2
	}
	union {
		wall(wall_len, wall_hi)
		translate z*(wall_len-0.5)*block_size.x
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
		translate x*(wall_len-0.5)*block_size.x
	}
	translate x*(-wall_len*block_size.x/2+28)
	translate z*(-wall_len*block_size.x/2+28)
}

#declare P_Sky=pigment {
	gradient y
	color_map {
		[0.0 rgb <0.5, 0.2, 0.2>]
		[1.0 rgb <0.2, 0.2, 0.5>]
	}
}
#declare P_Clouds = pigment {
	bozo
	turbulence 0.65
	octaves 6
	omega 0.7
	lambda 2
	//phase ((frame_start+frame_number)/150)*pi
	rotate (frame_start+frame_number)*z
	pigment_map {
		[0.0 rgb 0.85]
		[0.1 rgb 0.75]
		[0.5 rgbf 1.0]
	}
}

/*sky_sphere {
	pigment { P_CloudySky }
}*/

sphere {
	0, 1
	hollow
	texture {
		pigment { P_Sky }
		finish {
			ambient 100000
			diffuse 1
		}
	}
	texture {
		pigment { P_Clouds }
		finish {
			ambient 100000
			diffuse 1
		}
	}
	scale 600
}

height_field {
	sys
	"ground_hf.bmp"
	smooth
	scale <400, 8, 400>
	translate <-200, -1, -200>
	translate <28, 0, 28>
	texture {
		pigment { rgb 1 }
		finish {
			diffuse 0.4
			specular 0.0
		}
	}
}

#declare BlackSquare=texture {
	T_Wood22
	scale 8
	rotate 30
}

#declare WhiteSquare=texture {
	#include "whiteash.map"
	//#include "ash.map"
	//#include "bubinga.map"
	//#include "teak.map"
	pigment {
	    wood
	    colour_map { M_WhiteAsh }
	    //colour_map { M_Ash }
	    //color_map { M_Bubinga }
	    //color_map { M_Teak }
	    turbulence 0.05
	    omega 0.65
	    scale <0.2 0.2 1>
	    rotate -x*2
	}
	scale 2
	//scale 1/8
	rotate -30
}

#declare T_Board=texture {
	checker texture {BlackSquare}, texture {WhiteSquare}
	scale 8
}

union {
	#declare bx=0;
	#declare tr=seed(34.098);
	#while (bx < 8)
		#declare bz=0;
		#while (bz < 8)
			box {
			   	-y, <8, 0, 8>
			   	texture {
			   		#if (mod(bx+bz,2)) WhiteSquare #else BlackSquare #end
			   		rotate rand(tr)*90
			   	}
			   	translate <bx*8, 0, bz*8>
			}
			#declare bz=bz+1;
		#end
		#declare bx=bx+1;
	#end
   	translate <-4, 0, -4>
}
