//+kf3 +kff150 +o1gild

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"

#declare _textures=array[4];
#declare _textures[0]=texture { T_Chrome_5B }
#declare _textures[1]=texture { T_Gold_5B }

#declare frame_start=0;
#include "pgn.inc"
#include "env.inc"

/*-----------------clock-----------------
//0-1:	crown drops
//1-3:  king guilded
//3-4:	platform drops
//
//-------------------------------------*/
#declare KingGrow_clock=min(clock*1.22, 1.22)-.22;
#declare gild_clock=min(max(clock-1,0), 1);
#declare platform_clock=min(max(clock-2, 0), 1);

#declare plat_drop_dist=20;
#declare gold_drop=15*gild_clock;
#declare plat_drop=platform_clock*plat_drop_dist;

#declare king_loc=<4, 0, 7>*8;

#declare T_WhitePiece=texture {
	T_Chrome_5B
}
#declare T_BlackPiece=texture {
	T_Gold_5B
}
#declare T_Sand=texture {
	pigment { rgb 1 }
	normal {
		average
		normal_map {
			[1.0 bumps 0.5 scale 0.25]
			[1.0 agate scale 1]
		}
	}
	finish {
		diffuse 0.4
		specular 0.0
	}
}
#declare T_Recay=texture {
	average
	texture_map {
		[1-gild_clock T_Sand]
		[gild_clock T_Gold_5B]
	}
}
#declare M_BlowingSand=material {
	texture {
		pigment {
			bumps
			color_map {
				[0.2 rgb 1]
				//[0.9 rgb 2]
				[0.6 rgbf 1]
			}
			scale 0.25
		}
		finish {
			diffuse 0.4
			specular 0
		}
	}
	translate y*-clock*13.5*4
}

camera {
	location <0, 10, -40>-(<4, 1-clock/final_clock, 0>*8)
	right x*(image_width/image_height)
	up y
	angle 40
	look_at 0
	rotate y*(clock/final_clock*-45)
	translate (king_loc+y*8)+y*(plat_drop_dist-plat_drop)
}

box {
	0, <8, plat_drop_dist/*-plat_drop*/, 8>
	texture { WhiteSquare }
	translate king_loc-<4, 0, 4>-y*plat_drop
}

#declare S_KingWidth=spline {
 cubic_spline
 -0.0250, <-1.000000, 0.000000, 13.500000>
 0.0000, <0.000000, 0.000000, 13.500000>
 0.0250, <0.274727, 0.000000, 13.288561>
 0.0500, <0.251597, 0.000000, 12.811949>
 0.0750, <0.181606, 0.000000, 12.337991>
 0.1000, <0.357390, 0.000000, 11.987634>
 0.1250, <0.836644, 0.000000, 11.998362>
 0.1500, <1.313789, 0.000000, 12.046896>
 0.1750, <1.512887, 0.000000, 11.724772>
 0.2000, <1.393326, 0.000000, 11.260195>
 0.2250, <1.342952, 0.000000, 10.783467>
 0.2500, <1.301216, 0.000000, 10.305800>
 0.2750, <1.174162, 0.000000, 9.843694>
 0.3000, <1.007999, 0.000000, 9.393528>
 0.3250, <0.860982, 0.000000, 8.937024>
 0.3500, <0.860053, 0.000000, 8.466123>
 0.3750, <1.275389, 0.000000, 8.276951>
 0.4000, <1.721471, 0.000000, 8.161009>
 0.4250, <1.579790, 0.000000, 7.740703>
 0.4500, <1.114678, 0.000000, 7.649419>
 0.4750, <0.638736, 0.000000, 7.612931>
 0.5000, <0.476780, 0.000000, 7.203585>
 0.5250, <0.599955, 0.000000, 6.740553>
 0.5500, <0.761685, 0.000000, 6.288755>
 0.5750, <0.914131, 0.000000, 5.833832>
 0.6000, <1.024718, 0.000000, 5.367255>
 0.6250, <1.063036, 0.000000, 4.889359>
 0.6500, <1.054221, 0.000000, 4.409638>
 0.6750, <1.060924, 0.000000, 3.930219>
 0.7000, <1.208567, 0.000000, 3.479217>
 0.7250, <1.584009, 0.000000, 3.190887>
 0.7500, <2.042430, 0.000000, 3.050679>
 0.7750, <2.478893, 0.000000, 2.881363>
 0.8000, <2.073684, 0.000000, 2.644091>
 0.8250, <1.698432, 0.000000, 2.364364>
 0.8500, <1.940744, 0.000000, 1.977007>
 0.8750, <2.319254, 0.000000, 1.682140>
 0.9000, <2.676505, 0.000000, 1.362792>
 0.9250, <2.916744, 0.000000, 0.951124>
 0.9500, <2.997665, 0.000000, 0.479781>
 0.9750, <3.000000, 0.000000, 0.000000>
 1.0000, <3.000000, 0.000000, -1.000000>
}

#declare KingGrow=union {
	intersection {
		object { King }
		plane { y, KingGrow_clock*13.5 }
	}
	cone {
		y*KingGrow_clock*13.5, S_KingWidth(1-KingGrow_clock).x,
		y*min(max(KingGrow_clock*13.51,KingGrow_clock*13.5+S_KingWidth(1-KingGrow_clock).x*1), 13.51), 0.5
	}
	texture { T_Sand }
}

#switch (clock)
#range (0,1)
	union {
		object { KingGrow }
		cylinder {
			0, y*120, 0.5
			material { M_BlowingSand }
		}
		translate king_loc
		translate y*(plat_drop_dist-plat_drop)
	}
	#break
#range (1,2)
	sphere {
		0, 1
		hollow
		pigment { rgbf 1 }
		interior {
			media {
				emission rgb 0.5*(1-(abs(1-gild_clock*2)))
				density {
					spherical
				}
			}
		}
		scale <6, 12, 6>
		translate king_loc
		translate y*(plat_drop_dist-plat_drop+6.75)
	}
#else
	object {
		King
		texture { T_Recay }
		translate king_loc
		translate y*(plat_drop_dist-plat_drop)
	}
#end

#include "lights.inc"
light_source {
	<40, 80, -20>
	//color rgb 3
	color sun_color/2
	spotlight
	radius 10
	falloff 20
	point_at king_loc+y*(plat_drop_dist-plat_drop)
}
light_source {
	<10, 70, 20>
	//color rgb 3
	color flood1_color/2
	spotlight
	radius 5
	falloff 10
	point_at king_loc+y*(plat_drop_dist-plat_drop)
}
light_source {
	<-20, 100, -20>
	//color rgb 3
	color flood2_color/2
	spotlight
	radius 5
	falloff 10
	point_at king_loc+y*(plat_drop_dist-plat_drop)
}

#include "anim2.pgn.inc"

object {
	Pawn
	#declare loc=S_QRP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QNP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QBP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Pawn
	#declare loc=S_KP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KBP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KNP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KRP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Rook
	#declare loc=S_KR_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Rook
	#declare loc=S_QR_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_KN_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_QN_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_KB_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_QB_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Queen
	#declare loc=S_Q_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	King
	#declare loc=S_K_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
//--------------------------------------------------------------------------------
object {
	Pawn
	#declare loc=S_QRP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QNP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QBP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Pawn
	#declare loc=S_KP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KBP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KNP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KRP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Rook
	#declare loc=S_KR_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Rook
	#declare loc=S_QR_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_KN_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_QN_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	#debug concat("\nKing's bishop is at <",vstr(3,S_KB_Black(0)*8,",",-1,-1),">\n")
	Bishop
	rotate y*180
	#declare loc=S_KB_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_QB_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	#debug concat("\nQueen is at <",vstr(3,S_Q_Black(0)*8,",",-1,-1),">\n")
	Queen
	#declare loc=S_Q_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
/*object {
	King
	#declare loc=S_K_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}*/

