//+ft +w360 +h203 +a0.3 -j +l..\ +kf1.5714 +kff440 +oinspec.tga
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "pgn.inc"
//#include "lights.inc"
#include "lightsys_CIE-sRGB.inc"
#include "lightsys.inc"
#declare frame_start=0;
#include "inspection.inc"

/*object {
	#include "origin.inc"
	scale 8
}*/

#declare WHITE_POINT=Wp_Indoor_Film;
#declare WHITE_POINT=Wp_Daylight_Film;
#declare quick=0;
#declare walk_clock=min(clock, 1);//0-1
#declare turn_clock=min(max((clock-1)*4,0),1);//1-1.25
#declare retreat_clock=min(max((clock-1.25)*3.25,0),1);//1.25-1.375

#declare lb=sphere {
	0, 0.375
	pigment { rgb Light_Color(Cl_Incandescent_60w,Lm_Incandescent_25w/50)*1000 }
	finish { ambient 10000 }
}
#if (quick)
	#declare LS=light_source {
		<0, 0, 0>
		color rgb 1
		looks_like { lb }
		Light_Fading()
	}
#else
	#declare LS=light_source {
		<0, 0, 0>
		Light_Color(Cl_Incandescent_60w,Lm_Incandescent_25w/10)
		looks_like { lb }
		Light_Fading()
	}
#end

//floor
plane {
	y, 0
	texture {
		pigment { rgb 1 }
		finish {
			diffuse 0.2
		}
		normal {
			average
			normal_map {
				[2.0 crackle 2 scale 2]
			}
		}
	}
	texture {
		pigment {
			bozo
			color_map {
				[0.3 rgbf 1]
				[0.8 rgbf <0.2, 0.3, 0.4, 0.7>]
			}
			scale <4, 1/2, 1/2>
		}
		finish {
			diffuse 0.4
		}
		normal {
			average
			normal_map {
				[2.0 crackle 2 scale 2]
			}
		}
	}
}

//ceiling
intersection {
	plane {
		-y, -17
		texture {
			pigment { rgb 0.5 }
			finish {
				diffuse 0.8
			}
			normal {
				crackle
				scale 4
			}
		}
		texture {
			pigment {
				bozo
				color_map {
					[0.3 rgbf 1]
					[0.8 rgbf <0.2, 0.3, 0.4, 0.7>]
				}
				scale 4
			}
			finish {
				diffuse 0.1
			}
			normal {
				crackle
				scale 4
			}
		}
	}
	box {
		<-40, 0, -24-7>, <40, 24, 24+7>
	}
}

//sun
light_source {
	 <-100, 100, 500>
	//color 1
	Light_Color(Cl_Moonlight,12000/2)
	//Cl_Sunlight
	Light_Fading()
}

//hall lights
#include "swing.inc"
#local a=S_Swing(mod(clock*2*1.75,1)).x*30-15;
#local b=S_Swing(mod(clock*2*2,1)).x*30-15;
#declare SS_Cord=sphere_sweep {
	cubic_spline
	4,
	y*-2, 0.125
	<0, 0, 0>, 0.125
	<2*sin(radians(a)), -2*cos(radians(a)), 0>, 0.125
	<4*sin(radians(a)), -4*cos(radians(a)), 0>, 0.125
	no_shadow
}
union {
	object {
		LS
		translate y*-2.375
		rotate z*a
	}
	object {
		SS_Cord
		texture {
			pigment { rgb 0.2 }
			finish {
				diffuse 0.8
				specular 1
			}
		}
	}
	rotate y*80
	translate <-25, 17, 0>
}
#declare SS_Cord=sphere_sweep {
	cubic_spline
	4,
	y*-2, 0.125
	<0, 0, 0>, 0.125
	<2*sin(radians(b)), -2*cos(radians(b)), 0>, 0.125
	<4*sin(radians(b)), -4*cos(radians(b)), 0>, 0.125
	no_shadow
}
union {
	object {
		LS
		translate y*-2.375
		rotate z*b
	}
	object {
		SS_Cord
		texture {
			pigment { rgb 0.2 }
			finish {
				diffuse 0.8
				specular 1
			}
		}
	}
	rotate y*255
	translate <25, 17, 0>
}

object {
	side_of_cells
}
object {
	side_of_cells
	scale <1, 1, -1>
}

//prisoners------------------------------------------------------------------------
#declare T_Dirty=
texture {
	pigment {
		bozo
		color_map {
			[0.4 rgbf 1]
			[0.9 rgbf <0.2, 0.3, 0.4, 0.7>/2]
		}
	}
	finish {
		diffuse 0.5
	}
	normal {
		bozo 4
	}
	scale <2, 1, 1>*2
}

#if (quick)
	#declare T_WhitePiece=texture {
		pigment { rgb 2 }
	}
	#declare T_BlackPiece=texture {
		pigment { red 2 }
	}
#else
	#declare T_WhitePiece=
		texture {T_Chrome_4A}
		texture {T_Dirty}
	#declare T_BlackPiece=
		texture {T_Gold_2A}
		texture {T_Dirty}
#end

union {
	#include "prison.pgn.inc"
	translate <-28, 0, -28>
}
//------------------------------------------------------------

/*camera {
	location <-60, 13, 0>
	right x*(image_width/image_height)
	up y
	look_at <0, 13, 0>
}
camera {
	location <0, 130, 0>
	right x*(image_width/image_height)
	up y
	look_at <0, 0, 0>
}
camera {
	location <10, 13, 0>
	right x*(image_width/image_height)
	up y
	look_at <10, 8, 8>
}
camera {
	location <-45, 13, 0>
	right x*(image_width/image_height)
	up y
	angle 25
	look_at <-25, 15.5, 0>
}*/
#switch (clock)
#range (0, 1.125)
	camera {
		location <-25, 4, -6>
		right x*(image_width/image_height)
		up y
		//angle 60
		direction (<walk_clock*9*8-40, 6.5, 0>-<-25, 4, -6>)/15
		look_at <walk_clock*9*8-40, 6.5, 0>
	}
	#break
#range (1.125, 1.25)
	camera {
		location <29, 16, 8>
		right x*(image_width/image_height)
		up y
		angle 60
		look_at <24, 4, -24>
	}
#range (1.25, 1.75)
#else
	camera {
		location S_Flyaway_loc(retreat_clock)
		right x*(image_width/image_height)
		up y
		angle 60
		look_at S_Flyaway_la(retreat_clock)
	}
#end

#include "walk.inc"
object {
	King
	rotate y*(90+turn_clock*90)
	translate x*(S_King_Walk(walk_clock*9)*8-40)
	texture { T_Gold_5B }
}


union {
	#declare wall_len=100;
	#declare wall_hi=10;
	union {
		wall(wall_len, wall_hi)
		translate -x*block_size.x/2
	}
	union {
		wall(wall_len, wall_hi)
		translate z*(wall_len-0.5)*block_size.x
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
		translate x*(wall_len-0.5)*block_size.x
	}
	translate x*(-wall_len*block_size.x/2+28)
	translate z*(-wall_len*block_size.x/2+28)
}
