#global_settings {
	ambient_light 1/100000
}

#declare P_Sky=pigment {
	gradient y
	color_map {
		[0.0 rgb <0.5, 0.2, 0.2>]
		[1.0 rgb <0.2, 0.2, 0.5>]
	}
}
#declare P_Clouds = pigment {
	bozo
	turbulence 0.65
	octaves 6
	omega 0.7
	lambda 2
	//phase ((frame_start+frame_number)/150)*pi
	rotate (frame_start+frame_number)*x
	pigment_map {
		[0.0 rgb 0.85]
		[0.1 rgb 0.75]
		[0.5 rgbf 1.0]
	}
}

light_group {
	sphere {
		0, 1
		hollow
		texture {
			pigment { P_Sky }
			finish {
				ambient 100000
				diffuse 1
			}
		}
		texture {
			pigment { P_Clouds }
			finish {
				ambient 100000
				diffuse 1
			}
		}
		scale 600
	}
	global_lights off
}

#declare BlackSquare=texture {
	T_Wood22
	scale 8
	rotate 30
}

#declare WhiteSquare=texture {
	#include "whiteash.map"
	pigment {
	    wood
	    colour_map { M_WhiteAsh }
	    turbulence 0.05
	    omega 0.65
	    scale <0.2 0.2 1>
	    rotate -x*2
	}
	scale 2
	rotate -30
}

#macro M_C_Wall(wall_size)
	#declare square_size=<8, 0, 8>*0.25;
	union {
		#declare bx=0;
		#declare tr=seed(34.098);
		#while (bx < wall_size.x)
			#declare bz=0;
			#while (bz < wall_size.z)
				box {
				   	-y, square_size
				   	texture {
				   		#if (mod(bx/square_size.x+bz/square_size.z,2)) WhiteSquare #else BlackSquare #end
				   		rotate rand(tr)*90
				   	}
				   	translate <bx, 0, bz>//*square_size
					texture {
						pigment {
							bozo
							color_map {
								[0.4 rgbf 1]
								[0.9 rgbf <0.2, 0.3, 0.4, 0.7>/2]
							}
						}
						normal {
							bozo 4
						}
						finish {
							diffuse 0.05
						}
						scale <2, 8, 1>
					}
				}
				#declare bz=bz+square_size.z;
			#end
			#declare bx=bx+square_size.x;
		#end
		rotate x*-90
	   	//translate <-4, 0, -4>
	}
#end

#declare cell=union {
	#local ctr=0;
	#while (ctr < 6)
		cylinder {
			0, y*17, 0.25
			texture {
				pigment { rgb 0.1 }
				finish { diffuse 0.2 }
			}
			translate <ctr*(16/6)-8, 0, 1>
		}
		#local ctr=ctr+1;
	#end
	#local ctr=0;
	#while (ctr < 6)
		cylinder {
			0, y*17, 0.125
			texture {
				pigment { rgb 0.1 }
				finish { diffuse 0.2 }
			}
			translate <ctr*(8/6)-4, 6, 24.5>
		}
		#local ctr=ctr+1;
	#end
	difference {
		object {
			M_C_Wall(<17, 0, 17>)
		}
		box {
			0, 6
			translate <8-3, 10, -0.25>
		}
		translate <-8-3, 0, 24>
	}
	object {
		M_C_Wall(<24, 0, 17>)
		rotate y*-90
		translate <-8, 0, 0>
	}
	object {
		M_C_Wall(<24, 0, 17>)
		rotate y*-90
		translate <8, 0, 0>
	}
	/*object {
		LS
		translate vturbulence(3, 3, 3, <3, 4, 5>)/2
	}*/
}
#declare side_of_cells=union {
	object { cell }
	object {
		cell
		translate x*16
	}
	object {
		cell
		translate x*-16
	}
	object {
		cell
		translate x*16*2
	}
	object {
		cell
		translate x*-16*2
	}
	translate z*7
}

#declare block_size=<16, 8, 8>/2;
#declare mortr_size=<0, 0, 0>/2;

#macro block(vec)
	box {
		0, block_size-mortr_size
		texture {
			pigment {
				rgb 0.5+vturbulence(2, 0.5, 6, vec).z/3
			}
		}
		translate mortr_size/2
	}
#end

#macro wall(long, hi)
	#local cx=0;
	#while (cx < long)
		#local cy=0;
		#while (cy <= hi)
			#if (cy=hi)
				#if (mod(cx,2)=0)
					object {
						#declare this_trans=<cx+(mod(cy,2)/2), cy, 0>*block_size;
						block(this_trans)
						translate this_trans+z*vturbulence(2, 0.5, 6, this_trans)*2
					}
				#end
			#else
				object {
					#declare this_trans=<cx+(mod(cy,2)/2), cy, 0>*block_size;
					block(this_trans)
					translate this_trans+z*vturbulence(2, 0.5, 6, this_trans)*2
				}
			#end
			#local cy=cy+1;
		#end
		#local cx=cx+1;
	#end
#end

#declare BlackSquare=texture {
	T_Wood22
	scale 8
	rotate 30
}

#declare WhiteSquare=texture {
	#include "whiteash.map"
	pigment {
	    wood
	    colour_map { M_WhiteAsh }
	    turbulence 0.05
	    omega 0.65
	    scale <0.2 0.2 1>
	    rotate -x*2
	}
	scale 2
	rotate -30
}

#declare T_Board=texture {
	checker texture {BlackSquare}, texture {WhiteSquare}
	scale 8
}

#declare ceiling=union {
	#declare bx=0;
	#declare tr=seed(34.098);
	#while (bx < 8)
		#declare bz=0;
		#while (bz < 8)
			#if ((bz<3) | (bz>4))
				#if (drop_clock>0)
					#if (undrop_clock>0)
						//#debug "\nrotate squares up\n"
						#local ra=z*(undrop_clock*90-90);
					#else
						//#debug "\nrotate squares down\n"
						#local ra=-z*drop_clock*90;
					#end
				#else
					#local ra=<0,0,0>;
				#end
			#else
				#local ra=<0, 0, 0>;
			#end
			union {
				box {
				   	-0.5*y, <8, 0, 8>
				   	texture {
				   		#if (mod(bx+bz,2)) WhiteSquare #else BlackSquare #end
				   		rotate rand(tr)*90
				   	}
				   	rotate ra
				   	translate <bx*8, 0, bz*8>
				}
				box {
					-y, <8, -0.5, 8>
					rotate ra
					translate <bx*8, 0, bz*8>
					texture {
						pigment { rgb 0.5 }
						finish {
							diffuse 0.8
						}
						normal { crackle scale 4 }
					}
					texture {
						pigment {
							bozo
							color_map {
								[0.3 rgbf 1]
								[0.8 rgbf <0.2, 0.3, 0.4, 0.7>]
							}
							scale 4
						}
						finish { diffuse 0.1 }
						normal { crackle scale 4 }
					}
				}
			}
			#declare bz=bz+1;
		#end
		#declare bx=bx+1;
	#end
   	translate <-4, 0, -4>
}
