//+ft +w360 +h203 +a0.3 -j +l..\ +ki14 +kf34 +kff225 +orestart.tga
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "pgn.inc"
//#include "lights.inc"
#include "lightsys_CIE-sRGB.inc"
#include "lightsys.inc"
#declare frame_start=0;

#declare WHITE_POINT=Wp_Daylight_Film;

#declare quick=0;

#declare game_clock=max(clock, 17);
#declare sink_clock=(max(clock,14)-14)*17;
#declare drop_clock=min(max(clock, 15), 16)-15;
#declare undrop_clock=(min(max(clock, 16.5), 17)-16.5)*2;
#declare raise_clock=(min(max(clock, 16), 17)-16)*1;
#declare cam_clock=(clock-14);
#include "restart.inc"

#declare lb=sphere {
	0, 0.375
	pigment { rgb Light_Color(Cl_Incandescent_60w,Lm_Incandescent_25w/50)*1000 }
	finish { ambient 10000 }
}
#if (quick)
	#declare LS=light_source {
		<0, 0, 0>
		color rgb 1
		looks_like { lb }
		Light_Fading()
	}
#else
	#declare LS=light_source {
		<0, 0, 0>
		Light_Color(Cl_Incandescent_60w,Lm_Incandescent_25w/10)
		looks_like { lb }
		Light_Fading()
	}
#end

//floor
plane {
	y, 0
	texture {
		pigment { rgb 1 }
		finish {
			diffuse 0.2
		}
		normal {
			average
			normal_map {
				[2.0 crackle 2 scale 2]
			}
		}
	}
	texture {
		pigment {
			bozo
			color_map {
				[0.3 rgbf 1]
				[0.8 rgbf <0.2, 0.3, 0.4, 0.7>]
			}
			scale <4, 1/2, 1/2>
		}
		finish {
			diffuse 0.4
		}
		normal {
			average
			normal_map {
				[2.0 crackle 2 scale 2]
			}
		}
	}
}

//ceiling
object {
	ceiling
	translate <-28, 18, -28>
}

//sun
light_source {
	 <-100, 100, 500>
	//color 1
	Light_Color(Cl_Moonlight,12000/2)
	//Cl_Sunlight
	Light_Fading()
	rotate x*((max(23, clock)/23)*-90)
}

//hall lights
#include "swing.inc"
#local a=S_Swing(mod(clock*0.5*1.75,1)).x*30-15;
#local b=S_Swing(mod(clock*0.5*2,1)).x*30-15;
#declare SS_Cord=sphere_sweep {
	cubic_spline
	4,
	y*-2, 0.125
	<0, 0, 0>, 0.125
	<2*sin(radians(a)), -2*cos(radians(a)), 0>, 0.125
	<4*sin(radians(a)), -4*cos(radians(a)), 0>, 0.125
	no_shadow
}
union {
	object {
		LS
		translate y*-2.375
		rotate z*a
	}
	object {
		SS_Cord
		texture {
			pigment { rgb 0.2 }
			finish {
				diffuse 0.8
				specular 1
			}
		}
	}
	rotate y*80
	translate <-25, 17, 0>
}
#declare SS_Cord=sphere_sweep {
	cubic_spline
	4,
	y*-2, 0.125
	<0, 0, 0>, 0.125
	<2*sin(radians(b)), -2*cos(radians(b)), 0>, 0.125
	<4*sin(radians(b)), -4*cos(radians(b)), 0>, 0.125
	no_shadow
}
union {
	object {
		LS
		translate y*-2.375
		rotate z*b
	}
	object {
		SS_Cord
		texture {
			pigment { rgb 0.2 }
			finish {
				diffuse 0.8
				specular 1
			}
		}
	}
	rotate y*255
	translate <25, 17, 0>
}

union {
	object {
		side_of_cells
	}
	object {
		side_of_cells
		scale <1, 1, -1>
	}
	translate y*-sink_clock
}

//prisoners------------------------------------------------------------------------
#declare T_Dirty=
texture {
	pigment {
		bozo
		color_map {
			[0.4 rgbf 1]
			[0.9 rgbf <0.2, 0.3, 0.4, 0.7>/2]
		}
	}
	finish {
		diffuse 0.5
	}
	normal {
		bozo 4
	}
	scale <2, 1, 1>*2
}

#if (quick)
	#declare T_WhitePiece=texture {
		pigment { rgb 2 }
	}
	#declare T_BlackPiece=texture {
		pigment { red 2 }
	}
#else
	#declare T_WhitePiece=
		texture {T_Chrome_4A}
		texture {T_Dirty}
	#declare T_BlackPiece=
		texture {T_Gold_2A}
		texture {T_Dirty}
#end

#declare S_Raise=spline {
	natural_spline
	0, 0
	0.5, 0.7
	0.8, 1.1
	1, 1
}

union {
	#include "restart.pgn.inc"
	translate <-28, 0, -28>
	translate y*S_Raise(raise_clock)*18
}
//------------------------------------------------------------
#declare S_Cam_L=spline {
	natural_spline
	0, <-25, 8, 0>
	3, <-45, 18, 0>
	6, <0, 36, -28>
	9, <45, 54, 0>
	12, <0, 54, 28>
	15, <-45, 54, 0>
	18, <0, 54, -28>
	20, <45, 54, 0>
}
#declare S_Cam_P=spline {
	natural_spline
	0, <32, 8, 0>
	3, <32, 18, 0>
	6, <0, 0, 0>
}
camera {
	location S_Cam_L(cam_clock)
	right x*(image_width/image_height)
	up y
	look_at S_Cam_P(cam_clock)
}

union {
	#declare wall_len=100;
	#declare wall_hi=10;
	union {
		wall(wall_len, wall_hi)
		translate -x*block_size.x/2
	}
	union {
		wall(wall_len, wall_hi)
		translate z*(wall_len-0.5)*block_size.x
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
		translate x*(wall_len-0.5)*block_size.x
	}
	translate x*(-wall_len*block_size.x/2+28)
	translate z*(-wall_len*block_size.x/2+28)
}
