//+kf2.15 +kff115 +o5seg
#declare frame_start=150;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "pgn.inc"
#include "lights.inc"

#declare quick=0;

#if (quick)
	#declare T_WhitePiece=texture {
		pigment { rgb 2 }
	}
	#declare T_BlackPiece=texture {
		pigment { red 2 }
	}
	_Table()
	_Board(0)
#else
	#include "env.inc"
	#declare T_WhitePiece=texture {
		T_Chrome_5B
	}
	#declare T_BlackPiece=texture {
		T_Gold_5B
	}
#end

#declare seg_clock=clock/2;

#declare l1p=spline {
	linear_spline
	0,<32, 0, 56>,
	1, <32, 0, 32>
}
#declare l1r=spline {
	linear_spline
	0, 10,
	1, 20
}
#declare l1f=spline {
	linear_spline
	0, (x+y+z)*20,
	1, (x+y+z)*45
}

#declare l2p=spline {
	linear_spline
	0, <32, 0, 56>,
	0.25, <31, 0, 31>
}
#declare l2r=spline {
	linear_spline
	0, 5,
	1, 25
}
#declare l2f=spline {
	linear_spline
	0, 10,
	1, 45
}

#declare l3p=spline {
	linear_spline
	0, <32, 0, 56>,
	0.25, <33, 0, 33>
}
#declare l3r=spline {
	linear_spline
	0, 5,
	1, 22
}
#declare l3f=spline {
	linear_spline
	0, 10,
	1, 45
}
#declare c1l=spline {
	//#if (seg_clock < 0.5) linear_spline #else natural_spline #end
	natural_spline
	//quadratic_spline
	0, <37.65685425, 18, 6.91168825>
	0.4, <96, 95, 72>
	0.41, <96, 95.2, 72>
	0.42, <96, 95.4, 72>
	0.43, <96, 95.6, 72>
	0.44, <96, 95.8, 72>
	0.45, <96, 96.0, 72>
	0.46, <96, 96.2, 72>
	0.47, <96, 96.4, 72>
	0.48, <96, 96.6, 72>
	0.49, <96, 96.8, 72>
	0.5, <96, 97, 72>
	0.85168356479, <37, 11, 65>
	0.9, <32, 8, 52>
}
#declare c1p=spline {
	linear_spline
	0.0, <32, 8, 56>
	0.4, <28, 0, 28>
	0.5, <28, 0, 28>
	0.9, <32, 7, 48>
}
#declare c1a=spline {
	linear_spline
	0.0, 40
	0.4, 60
}

camera {
	location c1l(seg_clock)
	right x*(image_width/image_height)
	up y
	angle c1a(seg_clock).x
	look_at c1p(seg_clock)
}

#if (quick)
	light_source {
		<40, 80, -20>
		color rgb 1
	}
#else
	light_source {
		<40, 80, -20>
		color sun_color/2
		spotlight
		radius l1r(seg_clock).x
		falloff l1f(seg_clock).x
		point_at l1p(seg_clock)
	}
	light_source {
		<10, 70, 20>
		//color rgb 3
		color flood1_color/2
		spotlight
		radius l2r(seg_clock).x
		falloff l2f(seg_clock).x
		point_at l2p(seg_clock)
	}
	light_source {
		<-20, 100, -20>
		//color rgb 3
		color flood2_color/2
		spotlight
		radius l3r(seg_clock).x
		falloff l3f(seg_clock).x
		point_at l3p(seg_clock)
	}
#end

#include "anim2.pgn.inc"

object {
	Pawn
	#declare loc=S_QRP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QNP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QBP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Pawn
	#declare loc=S_KP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KBP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KNP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KRP_White(0);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Rook
	#declare loc=S_KR_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Rook
	#declare loc=S_QR_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_KN_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_QN_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_KB_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_QB_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Queen
	#declare loc=S_Q_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	King
	#declare loc=S_K_White(0);
	translate loc*8
	texture { T_WhitePiece }
}
//--------------------------------------------------------------------------------
object {
	Pawn
	#declare loc=S_QRP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QNP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QBP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Pawn
	#declare loc=S_KP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KBP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KNP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KRP_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Rook
	#declare loc=S_KR_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Rook
	#declare loc=S_QR_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_KN_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_QN_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_KB_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_QB_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Queen
	#declare loc=S_Q_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	King
	#declare loc=S_K_Black(0);
	translate loc*8
	texture { T_BlackPiece }
}
