//////////////////////////////////////////////////////////////////////////
// BallBoy.inc  1.0  KEA  Copyright(c) 2003, K.E. Ayers Designs         //
//////////////////////////////////////////////////////////////////////////
// The animation's main (and only!) character.                          //
//////////////////////////////////////////////////////////////////////////

#ifndef (_BallBoy_Inc_)
#declare _BallBoy_Inc_ = true;

#include "SceneConstants.inc"
#include "Textures.inc"


//////////////////////////////////////////////////////////////////////////
// Ball Boy is ... well ... a ball! But, he has two eyes that float     //
// above the center of his body and slightly out front. Furthermore,    //
// each eye has an eyebrow that floats slightly above the eye.          //
// The eyes will generally be oriented with reference to the body's     //
// orientation and with respect to each other. However, each eye can be //
// positioned independently for certain effects.                        //
//////////////////////////////////////////////////////////////////////////

#local BodyColor        = color rgb < 0.5, 0.8, 0.9 >;
#local BodyStripeColor  = color rgb < 0.0, 0.0, 0.6 >;
#local EyeballColor     = White;
#local PupilColor       = Black;
#local EyelidColor      = BodyColor;
#local EyebrowColor     = Black;


#local BodyTexture =
texture {
    pigment {
        radial
        color_map {
            [ 0.0   BodyColor ]
            [ 0.24  BodyColor ]
            [ 0.241 BodyStripeColor ]
            [ 0.259 BodyStripeColor ]
            [ 0.26  BodyColor ]
            [ 0.74  BodyColor ]
            [ 0.741 BodyStripeColor ]
            [ 0.759 BodyStripeColor ]
            [ 0.76  BodyColor ]
            [ 1.01  BodyColor ]
        }
        rotate -90 * z
        rotate -90 * y
    }
    finish { ambient Ambient diffuse Diffuse }
}

#local EyeballTexture =
texture {
    pigment { EyeballColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
    }
}

#local PupilTexture =
texture {
    pigment { PupilColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
    }
}

#local EyelidTexture =
texture {
    pigment { EyelidColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
    }
}

#local EyebrowTexture =
texture {
    pigment { EyebrowColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
    }
}


#local EyeballShape = sphere { < 0, 0, 0 >, BallBoyEyeRad }

#local EyelidShape =
intersection {
    object { EyeballShape scale 1.05}
    plane { x, 0 }
    texture { EyelidTexture }
}

#local Pupil =
sphere {
    < 0, 0, 0 >, BallBoyEyeRad * 0.25
    texture { PupilTexture }
    scale < 0.01, 1, 1 >
    translate BallBoyEyeRad * x
}

#local Eyebrow =
intersection {
    difference {
        cylinder {
            < -BallBoyEyebrowWid / 2, 0, 0 >,
            <  BallBoyEyebrowWid / 2, 0, 0 >,
            BallBoyEyebrowRad + BallBoyEyebrowWid / 2
        }
        cylinder {
            < -BallBoyEyebrowWid, 0, 0 >,
            <  BallBoyEyebrowWid, 0, 0 >,
            BallBoyEyebrowRad - BallBoyEyebrowWid / 2
        }
    }
    plane { -z, 0 rotate -(BallBoyEyebrowArc / 2) * x }
    plane {  z, 0 rotate  (BallBoyEyebrowArc / 2) * x }
    texture { EyebrowTexture }
}


#local Eye =
union {
    object { EyeballShape texture { EyeballTexture } }
    object { Pupil }
    object { EyelidShape }
}

#local LeftEye =
union {
    union {
        object { Eye }
        object { EyelidShape rotate  LeftBlinkRotate }
        object { EyelidShape rotate -LeftBlinkRotate }
        scale LeftEyeScale
        rotate LeftEyeRotate
    }
    object { Eyebrow translate LeftEyebrowPosition }
    translate LeftEyePosition
}

#local RightEye =
union {
    union {
        object { Eye }
        object { EyelidShape rotate  RightBlinkRotate }
        object { EyelidShape rotate -RightBlinkRotate }
        scale RightEyeScale
        rotate RightEyeRotate
    }
    object { Eyebrow translate RightEyebrowPosition }
    translate RightEyePosition
}

#local Eyes =
union {
    object { LeftEye }
    object { RightEye }
    rotate EyeRotate
}

#local Body =
sphere {
    < 0, 0, 0 >, BallBoyRad
    texture { BodyTexture }
    rotate BodyZRotate * z
    rotate BodyXRotate * x
}


// This is our composite character: "Ball Boy"!
#declare BallBoy =
union {
    object { Body }
    object { Eyes }
    scale BodyScale
    rotate BodyYRotate * y
    rotate CharacterRotate
    translate BodyPosition
}


#end    // #ifndef (_BallBoy_Inc_)
