//////////////////////////////////////////////////////////////////////////
// Set.inc  1.0  KEA  Copyright(c) 2003, K.E. Ayers Designs             //
//////////////////////////////////////////////////////////////////////////
// Defines the pen and the world beyond. The "world beyond" is just a   //
// featureless gray plane. Defines the object "Set".                    //
//////////////////////////////////////////////////////////////////////////

#ifndef (_Set_Inc_)
#declare _Set_Inc_ = true;


#include "SceneConstants.inc"
#include "Textures.inc"


/* Dark gray floor
#local GroundColor = DarkGray;
*/

/* Dark green floor
#local GroundColor = color rgb < 0.0, 0.5, 0.0 >;
*/

//* Dark blue floor
#local GroundColor = color rgb < 0.0, 0.0, 0.6 >;
//*/

/* Dark brown floor
#local GroundColor = color rgb < 0.5, 0.3, 0.1 >;
*/
  
#local Ground =
plane {
    < 0, -1, 0 >, 0
    pigment { GroundColor }
    hollow
}

#local MortarColor              = color rgb < 0.8, 0.8, 0.8 >;
#local FoundationColor          = color rgb < 0.7, 0.7, 0.7 >;
#local FoundationGrainColor     = color rgb < 0.5, 0.5, 0.5 >;

#local BlockPigment =
pigment {
    granite
    turbulence 0.15
    color_map {
        [ 0.0   FoundationColor ]
        [ 0.4   FoundationColor ]
        [ 0.5   FoundationGrainColor ]
        [ 0.6   FoundationColor ]
    }
}

#local WallTexture =
texture {
    pigment {
        brick pigment { MortarColor } pigment { BlockPigment }
        brick_size < 12, 9, PenWallThick * 2 >
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
    }
}


/* Brown-ish floor
#local FloorTileLightColor  = color rgb < 1.0, 0.8, 0.5 >;
#local FloorTileMediumColor = color rgb < 0.8, 0.6, 0.3 >;
#local FloorTileDarkColor   = color rgb < 0.5, 0.3, 0.1 >;
*/

//* Green-ish floor
#local FloorTileLightColor  = color rgb < 0.9, 1.0, 0.6 >;
#local FloorTileMediumColor = color rgb < 0.3, 0.8, 0.3 >;
#local FloorTileDarkColor   = color rgb < 0.0, 0.5, 0.0 >;
//*/

/* Blue-ish floor
#local FloorTileLightColor  = color rgb < 0.8, 0.8, 1.0 >;
#local FloorTileMediumColor = color rgb < 0.6, 0.6, 0.8 >;
#local FloorTileDarkColor   = color rgb < 0.0, 0.0, 0.5 >;
*/

#local FloorTexture =
texture {
    pigment {
        hexagon
            FloorTileLightColor,
            FloorTileMediumColor,
            FloorTileDarkColor
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
    }
    scale 6
}

#local Pen =
union {
    // North wall
    box {
        < WestWallPos - PenWallThick, 0, NorthWallPos >,
        < EastWallPos + PenWallThick, PenWallHgt, NorthWallPos + PenWallThick >
    }
    // South wall
    box {
        < WestWallPos - PenWallThick, 0, SouthWallPos - PenWallThick >,
        < EastWallPos + PenWallThick, PenWallHgt, SouthWallPos >
    }
    // East wall
    box {
        < EastWallPos, 0, SouthWallPos >,
        < EastWallPos + PenWallThick, PenWallHgt, NorthWallPos >
    }
    // West wall
    box {
        < WestWallPos - PenWallThick, 0, SouthWallPos >,
        < WestWallPos, PenWallHgt, NorthWallPos >
    }
    // Center wall
    box {
        < WestWallPos + OpeningWid, 0, CenterWallPos - PenWallThick / 2 >,
        < EastWallPos, PenWallHgt, CenterWallPos + PenWallThick / 2 >
    } 
    texture { WallTexture }
}

#local Floor =
box {
        < WestWallPos - PenWallThick / 2, 0,   SouthWallPos - PenWallThick / 2 >,
        < EastWallPos + PenWallThick / 2, 0.1, NorthWallPos + PenWallThick / 2 >
        texture { FloorTexture }
}

// The composite set.
#declare TheSet =
union {
    object { Ground }
    object { Floor }
    object { Pen }
}

#end    // #ifndef (_Set_Inc_)
