//////////////////////////////////////////////////////////////////////////
// SpinningStars.inc  1.0  KEA  Copyright(c) 2003, K.E. Ayers Designs   //
//////////////////////////////////////////////////////////////////////////
// The stars that spin over our character's head.                       //
//////////////////////////////////////////////////////////////////////////

#ifndef (_SpinningStars_Inc_)
#declare _SpinningStars_Inc_ = true;


#include "SceneConstants.inc"
#include "Textures.inc"


#declare SpinningStarsHgt = BallBoyRad * 1.25;
#declare SpinningStarsRad = BallBoyRad * 0.75;


#macro SpinningStars(fadeClock)

    #local endFadein    = 0.2;
    #local startFadeout = 0.8;
    
    #switch (fadeClock)
        #range (0.0, endFadein)
            // Fading in!
            #local starTransparency = 1 - (fadeClock / endFadein);
        #break
        
        #range (startFadeout, 1.0)
            // Fading out!
            #local starTransparency =
                (fadeClock - startFadeout) / (1 - startFadeout);
        #break
        
        #else
            // The stars are out!
            #local starTransparency = 0;

    #end
    
    
    #local starsPigment =
    pigment {
        image_map {
            // This is a standard 16-color VGA palette.
            gif "SpinningStars.gif"
            // The background is ALWAYS transparent
            transmit 0, 1
            // All remaining colors are controlled by
            // the computed star transparency value.
            transmit  1, starTransparency
            transmit  2, starTransparency
            transmit  3, starTransparency
            transmit  4, starTransparency
            transmit  5, starTransparency
            transmit  6, starTransparency
            transmit  7, starTransparency
            transmit  8, starTransparency
            transmit  9, starTransparency
            transmit 10, starTransparency
            transmit 11, starTransparency
            transmit 12, starTransparency
            transmit 13, starTransparency
            transmit 14, starTransparency
            transmit 15, starTransparency
            // The stars are arranged around a cylinder.
            map_type 2
            once
        }
    }
    
    cylinder {
        < 0, 0, 0 >,
        < 0, SpinningStarsHgt, 0 >,
        SpinningStarsRad
        texture {
            pigment { starsPigment }
            finish { ambient 1 diffuse 0 }
        }
        scale < 1, SpinningStarsHgt, 1 >
    }

#end    // #macro SpinningStars

#end    // #ifndef (_SpinningStars_Inc_)
