
// Show small maze in top view, visualize movement path
//
#declare f_visualize_path = false;

// Suppress textures
//
#declare f_suppress_textures = false;



// Path of movement in the maze
//
#declare s_movement_in_maze = spline {
	cubic_spline
	-0.04, <-1.8, 0, -2.5>
	 0.00, <-0.8, 0, -2.5>
	 0.08, < 0.3, 0, -2.3>
	 0.12, < 0.3, 0, -1.7>
	 0.16, <-0.3, 0, -1.3>
	 0.24, <-0.3, 0,  0.3>
	 0.28, < 0.3, 0,  0.3>
	 0.32, < 0.7, 0, -0.3>
	 0.40, < 2.3, 0, -0.7>
	 0.48, < 2.3, 0, -2.3>
	 0.52, < 1.6, 0, -2.5>
	 0.54, < 1.5, 0, -2.4>
	 0.56, < 1.6, 0, -2.3>
	 0.60, < 2.3, 0, -2.3>
	 0.68, < 2.3, 0, -0.7>
	 0.72, < 1.7, 0, -0.3>
	 0.80, < 1.7, 0,  1.3>
	 0.84, < 2.3, 0,  1.7>
	 0.88, < 2.3, 0,  2.2>
	 0.96, < 0.7, 0,  2.7>
	 1.00, < 0.5, 0,  3.5>
	 1.04, < 0.5, 0,  4.5>
	 1.08, < 0.5, 0,  5.5>
};



#if (f_visualize_path)


// Show small maze in top view
//
camera {
	location <0, 8, 0>
	look_at <0, 0, 0>
}

// Show movement path
//
#declare c = 0;
#while (c <= 1)
	sphere {
		s_movement_in_maze (c) + <0, 1, 0>, 0.1
		pigment {
			#switch (c)
			#range (0.0, 0.2)
				 color rgb <1, c / 0.2, 0>
			#break
			#range (0.2, 0.4)
				 color rgb <2 - c / 0.2, 1, 0>
			#break
			#range (0.4, 0.6)
				 color rgb <0, 1, c / 0.2 - 2>
			#break
			#range (0.6, 0.8)
				 color rgb <0, 4 - c / 0.2, 1>
			#break
			#else
				 color rgb <c / 0.2 - 4, 0, 1>
			#end
		}
	}
	#declare c = c + 0.001;
#end

#declare lumi = 1;


#else /* !f_visualize_path */


#switch (clock)

// Movement in the small maze
//
#range (0.00, 0.70)
	#declare c = clock / 0.70;

	#declare v_pos = s_movement_in_maze (c);
	#declare v_dir = vnormalize (s_movement_in_maze (c + 0.01) - v_pos);

	camera {
		location v_pos         + <0, 0.55, 0>
		look_at  v_pos + v_dir + <0, 0.50, 0>
	}
#break

// Standing at the exit, flashing question mark
//
#range (0.70, 0.75)
	#declare c = (clock - 0.70) / 0.05;

	#declare v_pos = s_movement_in_maze (1.00);
	#declare v_dir = vnormalize (s_movement_in_maze (1.01) - v_pos);

	camera {
		location v_pos         + <0, 0.55, 0>
		look_at  v_pos + v_dir + <0, 0.50, 0>
	}

	#if (c >= 0.125 & c < 0.875)
		text {
			ttf "trebuc.ttf" "?" 0.00001, 0
			scale 2.5
			translate <0, 0.1, 7>
			pigment {
				color rgbt <1.0, 0.0, 0.0, 1.0 - pow (sin (4 * pi * (c - 0.125)), 2)>
			}
			finish {
				ambient 1
				diffuse 0
			}
			no_shadow
			no_reflection
		}
	#end
#break

// Camera zooms back to reveal large maze
//
#else
	#declare c = (clock - 0.75) / 0.25;

	#declare v_pos = s_movement_in_maze (1.00);
	#declare v_dir = vaxis_rotate (vnormalize (s_movement_in_maze (1.01) - v_pos), y, 130 * pow (c, 0.3));

	camera {
		location v_pos         + <0, 0.55, 0> + <-350 * pow (c, 5), 100 * pow (c, 3), -350 * pow (c, 5)>
		look_at  v_pos + v_dir + <0, 0.50, 0> + <0, 25 * pow (c, 4), 0>
	}
#end


// Luminescence of the whole scene, fade in/out in the first/last 3% of the time
//
#switch (clock)
#range (0.00, 0.03)
	#declare lumi = clock / 0.03;
#break
#range (0.03, 0.97)
	#declare lumi = 1;
#break
#else
	#declare lumi = (1 - clock) / 0.03;
#end


#end /* !f_visualize_path */



global_settings {
	assumed_gamma 1.0
	ambient_light rgb lumi
}

light_source {
	<-25, 100, 0>
	color rgb lumi
}

light_source {
	<0, 100, -25>
	color rgb lumi
}

sky_sphere {
	pigment {
		gradient y
		color_map {
			[ 0.5 color rgb lumi * <0.4, 0.8, 1.0> ]
			[ 0.7 color rgb lumi * <0.0, 0.0, 0.8> ]
		}
		scale 2
		translate -1
	}

	pigment {
		bozo
		turbulence 0.8
		color_map {
			[ 0.6 color rgbt <lumi, lumi, lumi, 1> ]
			[ 0.7 color rgbt <lumi, lumi, lumi, 0.2> ]
			[ 0.9 color rgb lumi ]
			[ 1.0 color rgb lumi * 0.6 ]
		}
		scale <0.2, 0.05, 0.2>
	}
}



// Ground surface (swamp)
//
box {
	<0, -0.00001, 0>, <111.15, 0, 111.15>
	translate <-55.5, 0, -55.5>
	scale <30, 1, 30>
#if (f_suppress_textures)
	texture {
		pigment {
			color rgb <0.3, 0.4, 0.0>
		}
	}
#else
	#declare t_invisible = texture {
		pigment {
			color rgbt 1
		}
	};

	#declare t_water = texture {
		pigment {
			color rgb <0.3, 1.0, 0.5>
		}
		normal {
			ripples 0.2
			frequency 2
			phase 100 * clock
			scale 0.5
		}
		finish {
			ambient 0.1
			diffuse 0.1
			reflection { 0.8 }
		}
	};

	texture {
		pigment {
			bozo
			turbulence 1.5
			color_map {
				[ 0.5 color rgb <0.20, 0.10, 0.00> ]
				[ 0.8 color rgb <0.15, 0.05, 0.00> ]
				[ 0.9 color rgb <0.10, 0.05, 0.00> ]
			}
		}
		scale 10
	}
	texture {
		pigment {
			bumps
			turbulence 0.1
			color_map {
				[ 0.10 color rgbt <0.0, 0.1, 0.0, 1.0> ]
				[ 0.90 color rgb  <0.1, 0.2, 0.0> ]
				[ 0.96 color rgb  <0.1, 0.3, 0.0> ]
				[ 1.00 color rgb  <0.3, 0.4, 0.0> ]
			}
		}
		translate x
		scale 3
	}
}

box {
	<0, -0.00001, 0>, <111.15, 0.00001, 111.15>
	translate <-55.5, 0, -55.5>
	scale <30, 1, 30>
	texture {
		bumps
		turbulence 1.5
		texture_map {
			[ 0.5 t_invisible ]
			[ 0.8 t_water ]
		}
	}
#end
}


// Large maze
//
union {
	#include "largemaze.inc"
	translate <-55.575, 0, -55.575>
	scale <30, 1, 30>
	pigment {
		color rgb <1.0, 1.0, 0.7>
	}
}


// Small maze
//
union {
	#include "smallmaze.inc"
	translate <-3.075, 0, -3.075>
	scale <1, 1.05, 1>
#if (f_suppress_textures)
	pigment { color rgb <1, 0, 0> }
#else
	#declare t_mortar = texture {
		pigment {
			color rgb 0.5
		}
	}
	texture {
		pigment {
			agate
			agate_turb 5.0
			color_map {
				[ 0.96 color rgbt <0.2, 0.2, 0.2, 1> ]
				[ 0.98 color rgb  <0.2, 0.2, 0.2>    ]
			}
		}
		rotate 1
	}
	texture {
		pigment {
			agate
			agate_turb 5.0
			color_map {
				[ 0.96 color rgbt <1, 1, 1, 1> ]
				[ 0.98 color rgb  <1, 1, 1>    ]
			}
		}
	};

	#declare t_stone = texture {
		pigment {
			color rgb <0.8, 0, 0>
		}
		normal {
			bumps 0.08
			scale 0.8
		}
	};

	texture {
		brick texture { t_mortar }, texture { t_stone }
		translate <0.0, 0.35, 1.0>
		scale 0.025
	}
#end
}



// Grass
//
#declare blade = mesh2 {
  vertex_vectors {
    15,
    <-0.015, 0.00, 0.00>, <-0.005, 0.00, 0.01>, <0.005, 0.00, 0.01>, <0.015, 0.00, 0.00>,
    <-0.012, 0.25, 0.02>, <-0.004, 0.25, 0.03>, <0.004, 0.25, 0.03>, <0.012, 0.25, 0.02>,
    <-0.009, 0.50, 0.06>, <-0.003, 0.50, 0.07>, <0.003, 0.50, 0.07>, <0.009, 0.50, 0.06>,
    <-0.005, 0.75, 0.12>,  <0.005, 0.75, 0.12>,
    <0, 1.00, 0.20>
  }
  normal_vectors {
    15,
    <-1,  0.00, 1>, <-1,  0.00, 2>, <1,  0.00, 2>, <1,  0.00, 1>,
    <-1, -0.03, 1>, <-1, -0.04, 2>, <1, -0.04, 2>, <1, -0.03, 1>,
    <-1, -0.08, 1>, <-1, -0.13, 2>, <1, -0.13, 2>, <1, -0.08, 1>,
    <-1, -0.17, 1>,  <1, -0.17, 1>,
    <0, -0.20, 1>
  }
  face_indices {
    17,
    <0, 5, 4>, <0, 1, 5>, <1, 2, 5>, <2, 6, 5>, <2, 7, 6>, <2, 3, 7>,
    <4, 5, 8>, <5, 9, 8>, <5, 10, 9>, <5, 6, 10>, <6, 7, 10>, <7, 11, 10>,
    <8, 9, 12>, <9, 10, 12>, <10, 13, 12>, <10, 11, 13>,
    <12, 13, 14>
  }
}

#declare R = seed (0);

#macro grass (X, Z)
	#local I = 0;
	#local N = int (rand (R) * 5) + 3;
	#while (I < N)
		union {
			object {
				blade
				scale <0.2, 0.12 + 0.02 * rand (R), 0.24 + 0.02 * rand (R)>
				rotate y * 360 * rand (R)
			}
			object {
				blade
				scale <0.2, 0.16 + 0.02 * rand (R), 0.20 + 0.02 * rand (R)>
				rotate y * 360 * rand (R)
			}
			object {
				blade
				scale <0.2, 0.20 + 0.02 * rand (R), 0.16 + 0.02 * rand (R)>
				rotate y * 360 * rand (R)
			}
			object {
				blade
				scale <0.2, 0.24 + 0.02 * rand (R), 0.12 + 0.02 * rand (R)>
				rotate y * 360 * rand (R)
			}
			translate <X + rand (R) * 0.2 - 0.1, 0, Z + rand (R) * 0.2 - 0.1>
			scale <1.0, rand (R) + 1.0, 1.0>
			pigment {
				color rgb <0.2, 0.5, 0.1>
			}
		}
		#local I = I + 1;
	#end
#end

grass ( 0.8, -2.8)
grass ( 0.8, -1.5)
grass (-0.8, -1.7)
grass (-0.8, -1.4)
grass (-0.8, -1.0)
grass (-1.0,  0.2)
grass (-0.8,  0.5)
grass (-0.6,  1.6)
grass (-0.4,  1.4)
grass ( 0.7,  0.7)
grass ( 2.1, -0.8)
grass ( 2.2, -1.1)
grass ( 1.2, -2.0)
grass ( 1.2,  1.7)
grass ( 1.9,  1.2)
grass ( 1.2,  2.2)
grass ( 0.8,  2.8)
grass ( 1.2   3.8)
grass ( 2.4,  3.4)
grass ( 2.6,  3.4)
grass ( 2.4,  3.6)
grass ( 2.6,  3.6)
