/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : five_majors.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : five hourglasses that get a close look
 Date        : 20031122
 Created by  : Dennis Borree (trulayne - at - new - dot - rr - dot - com)
 Modified by : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031220 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

 

/*
* the ONE clock
*/
#declare hourglass_texture=T_Wood8;
#declare the_one= union{object{ 
        #local row=9;
        #local column=12;
	#local half_height = 0.16;
	#local glass_radius = 0.4*half_height;
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = sl;
	#local sand_level_2 = half_height*0.5;
	#local time_end = 10.2;	
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness, 0>
	translate <-0.78, 0.052*half_height/.20+row*0.5+.1, -3.55+column*0.3>
        }

#declare hourglass_base_style = 1;
#declare hourglass_rods_style = 1;
#declare name_number=100;
#declare hg_rotate=30;
#declare hg_rotate1=hg_rotate;

        object {hourglass_holder() rotate y*hg_rotate  translate <-0.78,0.11+row*0.5,-3.55+column*0.3> }
        
#local web_text=texture{pigment{rgbt<1.5, 1.5, 1.5, 0.4>}}
#local web_spokes=7;
#local web_x=0.3;
#local web_y=0.5;
#local web_spiral=0.0008;
#local web_thickness=0.0005;
#local web_rot=-90; 
#local web_trans_y=0; 
#local web_trans_z=-0.28; 
#local web_yclip=0.28; 
#local web_xclip=0.48;
#local web_yy=web_x;
#local web_x=web_y; 
#local web_y=web_yy;
#local webx_locate=-0.705-0.25;        
        
        object{web(web_spokes,web_x,web_y,web_thickness,web_spiral,123,web_text)
           rotate x*180 
           clipped_by{plane{y,web_yclip} } 
           rotate x*180   
           clipped_by{plane{x,web_xclip} }   
           rotate z*web_rot
           rotate y*90  
           translate <webx_locate, web_trans_y+ 0.59+row*0.5, web_trans_z-3.41+column*0.3>}
        }


        
/*
* the third left clock
*/ 
#declare hourglass_texture=T_Wood23;
#declare third_left_one=union{
object {
        #local row=9;
        #local column=9;
	#local half_height = 0.12;
	#local glass_radius = 0.4*half_height;
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.07;
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness, 0>
	translate <-0.78, 0.052*half_height/.20+row*0.5+.1, -3.55+column*0.3>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 5;
#declare hourglass_rods_style = 5;
#declare name_number=104;
#declare hg_rotate=(30+rand(r)*5);
#declare hg_rotate1=hg_rotate;

        object {hourglass_holder() rotate y*hg_rotate  translate <-0.78, 0.11+row*0.5, -3.55+column*0.3> }
        }

/*
* the second left clock
*/
#declare hourglass_texture=T_Wood18;
#declare second_left_one=union{object {
        #local row=9;
        #local column=10;
	#local half_height = 0.17;
	#local glass_radius = 0.4*half_height;
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.06;
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness, 0>
	translate <-0.78, 0.052*half_height/.20+row*0.5+.1, -3.55+column*0.3>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 4;
#declare hourglass_rods_style = 4;
#declare name_number=103;
#declare hg_rotate=(30+rand(r)*5);
#declare hg_rotate1=hg_rotate;

        object {hourglass_holder() rotate y*hg_rotate  translate <-0.78, 0.11+row*0.5, -3.55+column*0.3> }
        }
        
/*
* the left clock
*/
#declare hourglass_texture=T_Wood3;
#declare left_one=union{
 object{
        #local row=9;
        #local column=11; 
	#local half_height = 0.15;
	#local glass_radius = 0.4*half_height;
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.04;
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness, 0>
	translate <-0.78, 0.052*half_height/.20+row*0.5+.1, -3.55+column*0.3>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 3;
#declare hourglass_rods_style = 2;
#declare name_number=101;
#declare hg_rotate=(30+rand(r)*5);
#declare hg_rotate1=hg_rotate;

        object {hourglass_holder() rotate y*hg_rotate  translate <-0.78, 0.11+row*0.5, -3.55+column*0.3> }
        }

/*
* the right clock
*/
#declare hourglass_texture=T_Wood7;
#declare right_one=union{
object {
        #local row=9;
        #local column=13;
	#local half_height = 0.145;
	#local glass_radius = 0.4*half_height;
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.10;
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness, 0>
	translate <-0.78, 0.052*half_height/.20+row*0.5+.1, -3.55+column*0.3>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 2;
#declare hourglass_rods_style = 3;
#declare name_number=102;
#declare hg_rotate=(30+rand(r)*5);
#declare hg_rotate1=hg_rotate;

        object {hourglass_holder() rotate y*hg_rotate  translate <-0.78, 0.11+row*0.5, -3.55+column*0.3> }
        }