/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : skeleton_hand.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Makes skeleton hand
 Date        : 20031129
 Created by  : Dennis Borree (trulayne - at - new - dot - rr - dot - com)
 Modified    : Dennis Borree 20031130 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031206 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/


#macro Skeleton_hand()

#include "include/math.inc"


#local hand_norm = normal {
                            bump_map {
                               jpeg "image/wood_bone1.jpg"
                            bump_size 1.0
                            }
                            no_bump_scale
                            }
  
#local hand_finish = finish {ambient 0.65 
                              crand 0.01
                               reflection 0.01
                               diffuse 0.2
                              }
                              
#local hand_pigment = rgb <1, 0.95, 0.7>;

/*********************************** finger section types *********************************************/
            	        
            	        
#local dia=0.05;
#local len=0.2;
#local len1=0.2;
#local len2=0.169;

#declare sk_finger_sec1=  blob{
            		threshold 0.6
            		cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <0, 0, 9> translate <0, len2, 0>}
            	        cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <0, 0, -9> translate <0, len2, 0>}
            		cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <9, 0, 0> translate <0, len2, 0>}
            		cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <-9, 0, 0> translate <0, len2, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <0, 0, -9> translate <0, len1, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <0, 0, 9> translate <0, len1, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <9, 0, 0> translate <0, len1, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <-9, 0, 0> translate <0, len1, 0>}
            		sphere {<0, 0, 0>, 0.08, 1 scale <1,.3,1>translate <0, -0.03, 0>}
            		sphere {<0, 0, 0>, 0.06, 1 scale <1,.4,1>translate <0, 0.4, 0>}
            	        scale <0.8, 1.05, 0.8> translate y*0.01 
            	        finish {hand_finish}
            	        normal {hand_norm }
                        pigment {hand_pigment}
                        }
                        
#declare sk_finger_sec2=  blob{
            		threshold 0.6
            		cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <0, 0, 9> translate <0, len2, 0>}
            	        cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <0, 0, -9> translate <0, len2, 0>}
            		cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <9, 0, 0> translate <0, len2, 0>}
            		cylinder { <0, 0, 0>, <0, -len, 0>, dia, 1 rotate <-9, 0, 0> translate <0, len2, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <0, 0, -9> translate <0, len1, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <0, 0, 9> translate <0, len1, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <9, 0, 0> translate <0, len1, 0>}
            		cylinder { <0, 0, 0>, <0, len, 0>, dia, 1 rotate <-9, 0, 0> translate <0, len1, 0>}
            		sphere {<0, 0,0>,  0.08, 1 scale <1, 0.3, 1>translate <0, -0.03, 0>}
            		sphere {<0, 0,0>, 0.06, 1 scale <1,.4,1>translate <0, 0.4, 0>}
            	        scale <0.8, 1.05, 0.8> translate y*0.05 
            	        finish {hand_finish}
            	        normal {hand_norm }
                        pigment {hand_pigment}
                        }
                        
#declare sk_finger_sec3=   blob{
            		threshold 0.6
            	        cylinder { <0, 0, 0>, <0, 0.1, 0>, 0.09, 1 }
            	        cylinder { <0, 0, 0>, <0, 0.2, 0>, 0.06, 2 }
            	        cylinder { <0, 0, 0>, <0, 0.25, 0>, 0.03, 5 }
            	        sphere { < 0, 0, 0 >, 0.06, 3 scale < 1.1, 1, 1.3> translate <0, 0.22, 0>}
            	        sphere { < 0, 0, 0 >, 0.06, 1 scale < 1, 1.4, 1> translate <0.03, -0.01, 0>}
            		sphere { < 0, 0, 0 >, 0.06, 1 scale < 1, 1.4, 1> translate <-0.03, -0.01, -0>}
            	        finish {hand_finish}
            	        normal {hand_norm }
                        pigment {hand_pigment}
                        }                                                            	        

/*******************************************************************************************************/

/*********************************** finger section scaleing *********************************************/

#declare seg_scale=.8;            	        
  
#declare pinky1 = object { sk_finger_sec1  rotate y*00 scale <0.85, 0.81, 0.85>*seg_scale*<0.9, 0.88, 0.9>  translate y*0.01}
#declare pinky2 = object { sk_finger_sec2  rotate y*10 scale <0.77, 0.49, 0.77>*seg_scale*<0.9, 0.86, 0.9>}
#declare pinky3 = object { sk_finger_sec2  rotate y*50 scale <0.59, 0.41, 0.59>*seg_scale*<1, 0.58, 1> translate y*0.02}
#declare pinky4 = object { sk_finger_sec3  rotate y*-20 scale 0.3*seg_scale translate y*0.04}

#declare ring1 = object { sk_finger_sec1  rotate y*50 scale <0.85, 0.91, 0.85>*seg_scale*<0.9, 0.78, 0.9>  translate y*0.010}
#declare ring2 = object { sk_finger_sec2  rotate y*30 scale <0.77, 0.59, 0.77>*seg_scale*<0.9, 1, 0.9>}
#declare ring3 = object { sk_finger_sec2  rotate y*-90 scale <0.59, 0.43, 0.59>*seg_scale*<1, 0.77, 1> translate y*0.02}
#declare ring4 = object { sk_finger_sec3  rotate y*-50 scale 0.3*seg_scale translate y*0.04}

#declare middle1 = object { sk_finger_sec1  rotate y*30 scale <0.85, 1, 0.85>*seg_scale*<1, 0.83, 1>  translate y*0.012}
#declare middle2 = object { sk_finger_sec2  rotate y*-10 scale <0.77, 0.59, 0.77>*seg_scale translate y*0.010}
#declare middle3 = object { sk_finger_sec2  rotate y*40 scale <0.59, 0.48, 0.59>*seg_scale*<1, 0.7, 1> translate y*0.04}
#declare middle4 = object { sk_finger_sec3  rotate y*80 scale 0.3*seg_scale  translate y*0.06}

#declare index1 = object { sk_finger_sec1  rotate y*90 scale <0.85, 0.91, 0.85>*seg_scale  translate y*0.010}
#declare index2 = object { sk_finger_sec2  rotate y*-90 scale <0.77, 0.59, 0.77>*seg_scale translate y*0.005}
#declare index3 = object { sk_finger_sec2  rotate y*40 scale <0.59, 0.43, 0.59>*seg_scale*<1.1, 0.77, 1.1> translate y*0.028}
#declare index4 = object { sk_finger_sec3  rotate y*-70 scale 0.3*seg_scale*<1.1, 1, 1.1> translate y*0.045}

#declare thumb1 = object { sk_finger_sec1  rotate y*-30 scale <1.02, 0.70, 1.02>*seg_scale  translate y*0.01}
#declare thumb2 = object { sk_finger_sec2  rotate y*60 scale <0.85, 0.51, 0.85>*seg_scale*<1, 0.8, 1> translate y*0.003}
#declare thumb3 = object { sk_finger_sec3  rotate y*50 scale <0.50, 0.42, 0.50>*seg_scale translate y*0.028}   

/***************************************************************************************************/

/*************************************************** wrist *****************************************/
                        
#declare Skeleton_hand_3=   blob{
            		threshold 0.6
            	        sphere { < 0, 0, 0 >, 0.06, 1 scale < 1, 1, 0.7> translate <0.12, -0.14, 0>}
            	        sphere { < 0, 0, 0 >, 0.08, 1 scale < 1.5, 1.5, 1> translate <-0.10, -0.12, 0>}
            	        sphere { < 0, 0, 0 >, 0.05, 1 scale < 1.5, 1.5, 1> translate <-0.04, -0.08, 0>}
            		cylinder { <0, 0, 0>, <0, 0.12, 0>, 0.06, 1 rotate z*-37 scale <1, 1, 1> translate<-0.03, -0.19, 0> }
            		cylinder { <0, 0, 0>, <0, 0.12, 0>, 0.12, 0.7 rotate z*-50 scale <1, 1, 1> translate<0.05, -0.21, 0> }
            		scale <1, 1, 1>
            	        finish {hand_finish}
            	        normal {hand_norm scale 1.5 rotate 25}
                        pigment {hand_pigment}
                        }                        
            	        
/****************************************************************************************************/

/**************************************************** arm *******************************************/            	        

            	        
#declare Skeleton_hand_4=   blob{
            		threshold 0.6
            		cylinder { <0, 0, 0>, <0,-0.40,0>, 0.15, 1 translate<0, 0, 0>}
            		sphere { < 0, 0, 0 >, 0.06, 2 scale < 1, 2, 1> translate <0, 0.03, 0.06>}
            		sphere { < 0, 0, 0 >, 0.06, 2 scale < 1, 2, 1> translate <0, -0.02, -0.06>}
            		finish {hand_finish}
            		normal {hand_norm }
                        pigment {hand_pigment}
                        }
            		
/****************************************************************************************************/            		
            		

/*************************** set up angles from angle specs *******************************/

#declare p_finger_angle_1= <0, 0, 15>;                       // first joint angle-pinkyfinger -x curl toward palm
#declare p_finger_angle_2= <-P_Finger1, 0, 0>;               // second joint angle-pinkyfinger
#declare p_finger_angle_3= <-P_Finger2, 0, 0>;               // third joint angle-pinkyfinger
#declare p_finger_angle_4= <-P_Finger3, 0, 0>;               // forth joint angle-pinkyfinger            	        
#declare r_finger_angle_1= <0, 0, 10>;                       // first joint angle-ringfinger
#declare r_finger_angle_2= <-R_Finger1, 0, 0>;               // second joint angle-ringfinger
#declare r_finger_angle_3= <-R_Finger2, 0, 0>;               // third joint angle-ringfinger
#declare r_finger_angle_4= <-R_Finger3, 0, 0>;               // forth joint angle-ringfinger            	        
#declare m_finger_angle_1= <0, 0, 5>;                        // first joint angle-middlefinger
#declare m_finger_angle_2= <-M_Finger1, 0, 0>;               // second joint angle-middlefinger
#declare m_finger_angle_3= <-M_Finger2, 0, 0>;               // third joint angle-middlefinger
#declare m_finger_angle_4= <-M_Finger3, 0, 0>;               // forth joint angle-middlefinger
#declare i_finger_angle_1= <0, 0, 0>;                        // first joint angle-indexfinger
#declare i_finger_angle_2= <-I_Finger1, 0, 0>;               // second joint angle-indexfinger
#declare i_finger_angle_3= <-I_Finger2, 0, 0>;               // third joint angle-indexfinger
#declare i_finger_angle_4= <-I_Finger3, 0, 0>;               // forth joint angle-indexfinger
#declare thumb_angle_1   = <-3*Thumb1/3, 0, Thumb1-Thumb1a>; // first joint angle-thumb
#declare thumb_angle_2   = <3*Thumb2/3, 0, 2*Thumb2/3>;      // second joint angle-thumb
#declare thumb_angle_3   = <3*Thumb3/3, 0, 2*Thumb3/3>;      // third joint angle-thumb

/***********************************************************************************************/

/********************************************* joint locations *********************************/

#declare wrist_trans            = 0.2;
#declare p_finger_joint_origin_1= <-0.13, -0.07, 0>*seg_scale; 
#declare p_finger_joint_origin_2= <0, 0.35, 0>*seg_scale;
#declare p_finger_joint_origin_3= <0, 0.54, 0>*seg_scale;
#declare p_finger_joint_origin_4= <0, 0.66, 0>*seg_scale;
#declare r_finger_joint_origin_1= <-0.03, -0.02, 0>*seg_scale;
#declare r_finger_joint_origin_2= <0, 0.35, 0>*seg_scale;
#declare r_finger_joint_origin_3= <0, 0.63, 0>*seg_scale;
#declare r_finger_joint_origin_4= <0, 0.80, 0>*seg_scale;
#declare m_finger_joint_origin_1= <0.07, -0.02, 0>*seg_scale;
#declare m_finger_joint_origin_2= <0, 0.39, 0>*seg_scale;
#declare m_finger_joint_origin_3= <0, 0.66, 0>*seg_scale;
#declare m_finger_joint_origin_4= <0, 0.83, 0>*seg_scale;
#declare i_finger_joint_origin_1= <0.17, -0.03, 0>*seg_scale;
#declare i_finger_joint_origin_2= <0, 0.43, 0>*seg_scale;
#declare i_finger_joint_origin_3= <0, 0.71, 0>*seg_scale;
#declare i_finger_joint_origin_4= <0, 0.88, 0>*seg_scale;
#declare thumb_joint_origin_1=    <0.25, -0.06, 0>*seg_scale;
#declare thumb_joint_origin_2=    <0, 0.34, 0>*seg_scale;
#declare thumb_joint_origin_3=    <0, 0.55, 0>*seg_scale;

/************************************************************************************************/

/********************************************** joint transformation ****************************/

#local p_finger_joint_location_2=vrotate(p_finger_joint_origin_2,p_finger_angle_1); // p_finger
#local p_finger_joint_location_3=vrotate((p_finger_joint_origin_3-p_finger_joint_origin_2),(p_finger_angle_1+p_finger_angle_2))+p_finger_joint_location_2;//  p_finger
#local p_finger_joint_location_4=vrotate(p_finger_joint_origin_4-p_finger_joint_origin_3,(p_finger_angle_1+p_finger_angle_2+p_finger_angle_3))+p_finger_joint_location_3;//  p_finger
#local r_finger_joint_location_2=vrotate(r_finger_joint_origin_2,r_finger_angle_1); // r_finger
#local r_finger_joint_location_3=vrotate((r_finger_joint_origin_3-r_finger_joint_origin_2),(r_finger_angle_1+r_finger_angle_2))+r_finger_joint_location_2;//  r_finger
#local r_finger_joint_location_4=vrotate(r_finger_joint_origin_4-r_finger_joint_origin_3,(r_finger_angle_1+r_finger_angle_2+r_finger_angle_3))+r_finger_joint_location_3;//  r_finger
#local m_finger_joint_location_2=vrotate(m_finger_joint_origin_2,m_finger_angle_1); // m_finger
#local m_finger_joint_location_3=vrotate((m_finger_joint_origin_3-m_finger_joint_origin_2),(m_finger_angle_1+m_finger_angle_2))+m_finger_joint_location_2;//  m_finger
#local m_finger_joint_location_4=vrotate(m_finger_joint_origin_4-m_finger_joint_origin_3,(m_finger_angle_1+m_finger_angle_2+m_finger_angle_3))+m_finger_joint_location_3;//  m_finger
#local i_finger_joint_location_2=vrotate(i_finger_joint_origin_2,i_finger_angle_1); // i_finger
#local i_finger_joint_location_3=vrotate((i_finger_joint_origin_3-i_finger_joint_origin_2),(i_finger_angle_1+i_finger_angle_2))+i_finger_joint_location_2;//  i_finger
#local i_finger_joint_location_4=vrotate(i_finger_joint_origin_4-i_finger_joint_origin_3,(i_finger_angle_1+i_finger_angle_2+i_finger_angle_3))+i_finger_joint_location_3;//  i_finger
#local thumb_joint_location_2=vrotate(thumb_joint_origin_2,thumb_angle_1); // thumb
#local thumb_joint_location_3=vrotate((thumb_joint_origin_3-thumb_joint_origin_2),(thumb_angle_1+thumb_angle_2))+thumb_joint_location_2;//  thumb

/*********************************************************************************************/

/************************************************* build hand *************************************/            	        		
 #ifdef (clock09)
 union{ 
 #end
 union{union { 
                                object{pinky1 rotate p_finger_angle_1  translate p_finger_joint_origin_1}                  //pinky1
                                object{pinky2 rotate (p_finger_angle_1+p_finger_angle_2)   translate p_finger_joint_location_2 translate p_finger_joint_origin_1}        //pinky2
                                object{pinky3 rotate (p_finger_angle_1+p_finger_angle_2+p_finger_angle_3)   translate( p_finger_joint_location_3) translate p_finger_joint_origin_1}       //pinky3
                                object{pinky4 rotate (p_finger_angle_1+p_finger_angle_2+p_finger_angle_3+p_finger_angle_4)    translate p_finger_joint_location_4 translate p_finger_joint_origin_1}               //pinky4
                                
                                object{ring1 rotate r_finger_angle_1  translate r_finger_joint_origin_1}                  //ring1
                                object{ring2 rotate (r_finger_angle_1+r_finger_angle_2)   translate r_finger_joint_location_2 translate r_finger_joint_origin_1}        //ring2
                                object{ring3 rotate (r_finger_angle_1+r_finger_angle_2+r_finger_angle_3)   translate( r_finger_joint_location_3) translate r_finger_joint_origin_1}       //ring3
                                object{ring4 rotate (r_finger_angle_1+r_finger_angle_2+r_finger_angle_3+r_finger_angle_4)    translate r_finger_joint_location_4 translate r_finger_joint_origin_1}               //ring4
                                
                                object{middle1 rotate m_finger_angle_1 translate m_finger_joint_origin_1 }                  //middle1
                                object{middle2 rotate (m_finger_angle_1+m_finger_angle_2)   translate m_finger_joint_location_2 translate m_finger_joint_origin_1 }        //middle2
                                object{middle3 rotate (m_finger_angle_1+m_finger_angle_2+m_finger_angle_3)   translate( m_finger_joint_location_3) translate m_finger_joint_origin_1 }       //middle3
                                object{middle4 rotate (m_finger_angle_1+m_finger_angle_2+m_finger_angle_3+m_finger_angle_4)    translate m_finger_joint_location_4 translate m_finger_joint_origin_1 }               //middle4
                                
                                object{index1 rotate i_finger_angle_1  translate i_finger_joint_origin_1}                  //index1
                                object{index2 rotate (i_finger_angle_1+i_finger_angle_2)   translate i_finger_joint_location_2 translate i_finger_joint_origin_1}        //index2
                                object{index3 rotate (i_finger_angle_1+i_finger_angle_2+i_finger_angle_3)   translate( i_finger_joint_location_3) translate i_finger_joint_origin_1}       //index3
                                object{index4 rotate (i_finger_angle_1+i_finger_angle_2+i_finger_angle_3+i_finger_angle_4)    translate i_finger_joint_location_4 translate i_finger_joint_origin_1}               //index4
                                
                                object{thumb1  rotate thumb_angle_1   translate thumb_joint_origin_1}                  //thumb1
                                object{thumb2  rotate (thumb_angle_1+thumb_angle_2)   translate thumb_joint_location_2  translate thumb_joint_origin_1}        //thumb2
                                object{thumb3  rotate (thumb_angle_1+thumb_angle_2+thumb_angle_3)   translate( thumb_joint_location_3) translate thumb_joint_origin_1}       //thumb3
                                
                                object {Skeleton_hand_3 rotate z*15 translate y*0.02}
                                translate <0, wrist_trans, 0> rotate <wrist_angle_rot, 0, wrist_angle_pivot> translate <0, -wrist_trans, 0> scale<1, 1.07, 1> 
                                }
                                object {Skeleton_hand_4 scale <0.7, 0.7, 0.7> rotate y*90 translate <0.11, (-0.26+0.09*sind(wrist_angle_pivot)), 0>}
                                object {Skeleton_hand_4 scale <0.4, 0.5, 0.4> rotate y*-90 translate <-0.05, (-0.23-0.09*sind(wrist_angle_pivot)), 0>} 
                                rotate <0, wrist_angle_twist, 0> finish{ambient 0.75 crand 0.1} pigment {rgb <1, 1, 0.9>}
                                }
                                #ifdef (clock09)
                                union{cone{<0,0,0>, 0.2,<0,-1,0>, 0.19 }
                                torus { 0.2, 0.005} scale<1.25, 1, 3> rotate <0, 45, 0>  translate<-0.25, -0.5, -0.35> pigment{Gray25}}
                                
                                }
                                #end
                                
/************************************************************************************************************/

/*********************************************** end macro **************************************************/                                
                                
#end                                                                            
                                
                                