/**********************************************
* Spider.inc
* by Andy Read
* notes:
* This is not a spider because it only has 6 legs!
* Created over 10 years ago just as a walking 'Bug' model
* The beauty of this code (despite its overwhelming ugliness)
* is the inverse-kinimatics which keep its feet
* firmly on the spot even as its hips swing :-)
* Originally written in 'C' for home-grown ray-tracing software
* (Which is why the code is so obscure!)
* Converted to POV-Ray 2002(?)
* Modified for IMP "The End of" Jan 2004
**********************************************/

#include "include/colors.inc"

/**************************************************************
*  These are the animation variables                          *
**************************************************************/

#declare var00 = 0;

#declare var01 = 70;
#declare var02 = 30;
#declare var03 = 100;

#declare var04 = -0;
#declare var05 = 15;
#declare var06 = 100;

#declare var07 = -0;
#declare var08 = 15;
#declare var09 = 100;

#declare var10 = 05;
#declare var11 = 30;
#declare var12 = 100;

#declare var13 = 05;
#declare var14 = 30;
#declare var15 = 100;

#declare var16 = -45;
#declare var17 = 15;
#declare var18 = 100;

#declare var19 = 10;

/**************************************************************
*  This is the animation code                                 *
**************************************************************/

#declare a =  8.0;
#declare b = 12.0;
#declare d =  6.0;
#declare h =  5.5;
#declare k = 30;

#declare Cycle = 2; // 3 cycles in 6 seconds; Originaaly was Frames = 20; // derived from (lastFrame-firstFrame)
#declare tt = mod(clock_room,Cycle); // or some derivative

#declare T = Cycle / 2;
#if (T<1)
  #declare T = 1;
#end

#declare TT = T * 2;

#declare var00 = d * clock_room / T;

#declare var19 = 10 * cos (2*pi*tt/TT);

#declare P = var19 * pi / 180;

#declare K = atan2 (4.0, 3.0);

// use macros as functions:

#macro set_ABC (p0,p1,p2, tt, m, e, c)
//int tt, m;
//real *pp,e,c;

  //real f,g,D,E;

  #local cl = c - d * tt / T;

  #declare p0 = m * 180/pi * atan2 (cl, e) - var19;

  #local f = sqrt (cl*cl + e*e);
  #local g = sqrt (f*f + h*h);

  #declare p2 = m * 180/pi * (pi - acos((a*a+b*b-g*g)/(2*a*b)));

  #local D = acos((a*a+g*g-b*b)/(2*a*g));
  #local E = atan2(f, h);

  #declare p1 = m * 180/pi * (pi - D - E);
#end

#macro set_leg (p0,p1,p2, tt, m, e, c)
//int tt, m;
//real *pp,e,c;
  #if (tt<T)	
    set_ABC (p0,p1,p2, tt, m, e, c)	
  #else	
    //real p0[3], pT[3];
    #declare p00=0;
    #declare p01=0;
    #declare p02=0;
    #declare pT0=0;
    #declare pT1=0;
    #declare pT2=0;
    set_ABC (p00,p01,p02, 0, m, e, c)
    set_ABC (pT0,pT1,pT2, T, m, e, c)
    #local tl = tt - T;
    #declare p0 = ((T-tl)*pT0 + tl*p00) / T;
    #declare p2 = ((T-tl)*pT2 + tl*p02) / T;
    #declare p1 = ((T-tl)*pT1 + tl*p01) / T - m * k * sin(pi*tl/T);
  #end
#end

#declare tt0 = tt;
#declare tt1 = mod((tt+T),TT);

set_leg (var01, var02, var03, tt0, 1, 14.0 - 5*cos(K+P), 6.0 + 5*sin(K-P))
set_leg (var04, var05, var06, tt1, 1,-14.0 + 5*cos(K-P), 6.0 + 5*sin(K+P))
set_leg (var07, var08, var09, tt1, 1,  7.0 + 5*cos( P ), 3.0 - 5*sin( P ))
set_leg (var10, var11, var12, tt0,-1,  7.0 + 5*cos( P ), 3.0 + 5*sin( P ))
set_leg (var13, var14, var15, tt0, 1, 14.0 - 5*cos(K-P), 0.0 - 5*sin(K+P))
set_leg (var16, var17, var18, tt1, 1,-14.0 + 5*cos(K+P), 0.0 - 5*sin(K-P))


/**************************************************************
*  This is the scene definition                               *
**************************************************************/


#declare EyeTxt = texture { pigment { colour<0.5,0,0>}
                            finish { ambient 0.4 diffuse 0.9 } }

#declare BodyTxt = texture { pigment { colour <0,0.2,0.1> }
                             finish { ambient 0.6 diffuse 0.3 phong 0.9 phong_size 20 } }
  
union // "bug"
{
  union // "head"
  {
    sphere // "skull"
    {
      0, 3
      texture { pigment { colour Gray30 } finish { ambient 0.4 diffuse 0.9 } }
    }
    sphere // "left eye"
    {
      0, 2
      scale <1.1,0.8,1>
      translate <0,1.555,0>
      rotate -z*65
      rotate y*55
      texture { EyeTxt }
    }
    sphere // "right eye"
    {
      0, 2
      scale <1.1,0.8,1>
      translate <0,1.555,0>
      rotate -z*65
      rotate -y*55
      texture { EyeTxt }
    }
    translate <5, 2, 0>
  }

  union // "main body"
  {
    sphere
    { 0, 1
      scale <5.0,3.0,5.0>
      texture { BodyTxt }
    }

    union // "front right leg"
    {
      sphere { 0, 1.1 }
      cylinder { 0, y*8, 0.7 }
      union
      {
        sphere { 0, 0.7 }
        cylinder { 0, y*12, 0.7 }
        sphere { 0, 0.7 translate <0,12,0> }
	rotate -x*var03 translate <0,8,0> 
      }
      rotate -x*var02 rotate -y*var01 translate <3,0,-4>
    }
    union // "front left leg"
    {
      sphere { 0, 1.1 }
      cylinder { 0, y*8, 0.7 }
      union
      {
        sphere { 0, 0.7 }
        cylinder { 0, y*12, 0.7 }
        sphere { 0, 0.7 translate <0,12,0> }
	rotate -x*var06 translate <0,8,0> 
      }
      rotate -x*var05 rotate -y*var04 translate <3,0,4>
    }

    union // "mid right leg"
    {
      sphere { 0, 1.1 }
      cylinder { 0, y*8, 0.7 }
      union
      {
        sphere { 0, 0.7 }
        cylinder { 0, y*12, 0.7 }
        sphere { 0, 0.7 translate <0,12,0> }
	rotate -x*var09 translate <0,8,0> 
      }
      rotate -x*var08 rotate -y*var07 translate <0,0,-5>
    }
    union // "mid left leg"
    {
      sphere { 0, 1.1 }
      cylinder { 0, y*8, 0.7 }
      union
      {
        sphere { 0, 0.7 }
        cylinder { 0, y*12, 0.7 }
        sphere { 0, 0.7 translate <0,12,0> }
	rotate -x*var12 translate <0,8,0> 
      }
      rotate -x*var11 rotate -y*var10 translate <0,0,5>
    }

    union // "rear right leg"
    {
      sphere { 0, 1.1 }
      cylinder { 0, y*8, 0.7 }
      union
      {
        sphere { 0, 0.7 }
        cylinder { 0, y*12, 0.7 }
        sphere { 0, 0.7 translate <0,12,0> }
	rotate -x*var15 translate <0,8,0> 
      }
      rotate -x*var14 rotate -y*var13 translate <-3,0,-4>
    }
    union // "rear left leg"
    {
      sphere { 0, 1.1 }
      cylinder { 0, y*8, 0.7 }
      union
      {
        sphere { 0, 0.7 }
        cylinder { 0, y*12, 0.7 }
        sphere { 0, 0.7 translate <0,12,0> }
	rotate -x*var18 translate <0,8,0> 
      }
      rotate -x*var17 rotate -y*var16 translate <-3,0,4>
    }

    sphere // "tail
    {
      0, 1
      scale <8,4,4>
      translate <-8,2,0>
      texture { BodyTxt }
    }

  }

  rotate -y*var19
  translate <var00,0,0>
  scale 0.005
  rotate -x*90
  rotate -z*45
  //translate <0, 4, 0>
  translate <-1.2,1.6,-0.1>
  texture { pigment { colour Gray30 } finish{ ambient 0.4 diffuse 0.9 }} // Legs!
}

/****************************************  -oOo-  ******************************************/