/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : room.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : room with door and window
 Date        : 20031108
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031122 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#default {
	texture {
		finish {
			ambient 0
		}
	}
}

#include "include/colors.inc"
#include "include/woods.inc"
#include "include/functions.inc"
#include "scenes/hourglass/hourglass.inc"

/*
* lights
*/


/*
// key light
#ifndef (clock06) // took out this light from shot06
light_source {
	<0,5,0>
	color rgb <1,0.7,0.4>
	fade_power 2
	fade_distance 100
} 
#end

#ifndef (clock04)
light_source {
	<100,100,-10>
	color rgb <0.3,0.4,0.5>
	parallel
	shadowless
}
#end
*/

/*
* floor
*/

#include "scenes/room/floor.inc"

#declare T_Wood =
texture {
    pigment {
        wood
        turbulence 0.03725
        omega 0.65725
        lambda 2.425
        color_map {
            [0.250 color rgbt <1.00000, 0.53373, 0.11665, 0.000>]
            [0.350 color rgbt <0.66275, 0.28607, 0.00000, 0.000>]
            [0.525 color rgbt <1.00000, 0.53363, 0.11715, 0.000>]
            [0.600 color rgbt <0.66475, 0.28647, 0.00000, 0.000>]
            [0.750 color rgbt <1.00000, 0.53353, 0.11565, 0.000>]
            [0.850 color rgbt <0.66275, 0.28667, 0.00000, 0.000>]
            [1.000 color rgbt <1.00000, 0.53143, 0.11795, 0.000>]
        }
        scale <0.25, 0.225, 1.0>
    }
    finish { ambient 0 diffuse 1 }
}
texture {
    pigment {
        wood
        scale 1.01275
        turbulence 0.0435
        omega 0.65
        lambda 3.15
        color_map {
            [0.200 color rgbt <0.56695, 0.17347, 0.00000, 0.8250>]
            [0.350 color rgbt <0.96471, 0.54510, 0.22753, 0.7710>]
            [0.400 color rgbt <0.56341, 0.17547, 0.00000, 0.9150>]
            [0.615 color rgbt <0.96472, 0.54510, 0.22553, 0.7590>]
            [0.700 color rgbt <0.56671, 0.17687, 0.00000, 0.7920>]
            [0.850 color rgbt <0.96485, 0.54510, 0.22453, 0.8975>]
            [1.000 color rgbt <0.56478, 0.17247, 0.00000, 0.9750>]
        }
        scale <0.225, 0.2725, 1.0>
        translate <-0.35, 0.095, 1.25>
    }
    finish { ambient 0 diffuse 1 }
}

/*
* a wood bar
*/
#declare r = seed(0);
#macro bar()
        box {
                <-0.15,-0.01,-20>,<0.15,0.01,20>
                texture { T_Wood scale 0.5 translate <rand(r)*0.05,rand(r)*0.05,rand(r)> }
        }
#end

/*
* fog
*/
/*
fog {
	color rgb 0
	distance 5
}
*/

/*
* the shelfs
*/
#declare n = -200;
#while (n <= 200)
	object { bar() rotate <90,90,0> translate <-1,5,0.3 * n> }
	object { bar() rotate <90,0,0> translate <-0.85,5,0.2 + 0.3 * n> }
	#declare n = n + 1;
#end

#declare n = 0;
#while (n <= 20)
	object { bar() translate <-0.79,n * 0.5 + 0.1, 0> }
	#declare n = n + 1;
#end

/*
#declare X = -10;
#while (X <= 10)
	#declare Y = 0;
	#while (Y <= 5)
		object {
		#local half_height = 0.20;
		#local glass_radius = 0.08;
		#local cone_height = 0.08;
		#local round = 0.01;
		#local hole_radius = 0.003;
		#local glass_thickness = 0.001;
		#local sand_level_1 = 0.05;
		#local sand_level_2 = 0.05;
		#local time_end = 1000;
		
		#local grain_size = 0.001;
		#local deltaT = 1/framerate;
		#local time = clock_shelfs;
		
		hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end)
		translate <0,half_height + glass_thickness,0>
		translate <-0.95,0.01 + Y*0.50,X*0.3>
		}
		
		#declare Y = Y + 1;
	#end
	#declare X = X + 1;
#end
*/

#ifndef (clock06)

#declare n = -200;
#while (n <= 200)
	object { bar() rotate <90,90,0> translate <1,5,0.3 * n> }
	object { bar() rotate <90,0,0> translate <0.85,5,0.2 + 0.3 * n> }
	#declare n = n + 1;
#end

#declare n = 0;
#while (n <= 20)
	object { bar() translate <0.79,n * 0.5 + 0.1, 0> }
	#declare n = n + 1;
#end
#end
