/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : bat.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Makes Bat
 Date        : 20031231
 Created by  : Dennis Borree (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#macro web_fill()

#declare web_text=texture{pigment{rgbt<1.5, 1.5, 1.5, 0.4>}}
#declare web_distribution=rand(r);
#declare web_spokes=int(4+rand(r)*6);
#declare web_x=0.1+0.4*rand(r);
#declare web_y=0.1+0.6*rand(r);

#if (web_y<(0.5*web_x)) #declare web_y=0.5*web_x; #end
#if (web_y>(2*web_x)) #declare web_y=2*web_x; #end 
#if (web_y>0.7) #declare web_y=0.7; #end

#declare web_spiral=(1-rand(r)/10)*(0.007*(web_x*web_y)+0.0009);
#declare web_thickness=.0005;
#declare web_corner=int(rand(r)*4)+1;
#declare web_yclip=0.48;
#declare web_xclip=0.28;

#if (web_corner=1)
        #declare web_rot=0;
        #declare web_trans_y=0;
        #declare web_trans_z=0;
#end
    
#if (web_corner=2) 
        #declare web_rot=90; 
        #declare web_trans_y=-0.48; 
        #declare web_trans_z=0; 
        #declare web_yclip=0.28; 
        #declare web_xclip=0.48;
        #declare web_yy=web_x;
        #declare web_x=web_y; 
        #declare web_y=web_yy; 
#end

#if (web_corner=3) 
        #declare web_rot=180; 
        #declare web_trans_y=-0.48; 
        #declare web_trans_z=-0.28; 
#end

#if (web_corner=4) 
        #declare web_rot=-90; 
        #declare web_trans_y=0; 
        #declare web_trans_z=-0.28; 
        #declare web_yclip=0.28; 
        #declare web_xclip=0.48;
        #declare web_yy=web_x;
        #declare web_x=web_y; 
        #declare web_y=web_yy; 
#end



#if(web_distribution<0.4)  // percent fill

    object{web(web_spokes,web_x,web_y,web_thickness,web_spiral,123,web_text)
           rotate x*180 
           clipped_by{plane{y,web_yclip} } 
           rotate x*180   
           clipped_by{plane{x,web_xclip} }   
           rotate z*web_rot
           rotate y*90  
           translate <webx_locate, web_trans_y+ 0.59+row*0.5, web_trans_z-3.41+column*0.3>}
#end



#end