/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot04.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : a shot in the narrow alleyway
 Date        : 20031108
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031226 (trulayne - at - new - dot - rr - dot - com)  
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   14 seconds
//

/*
#include "include/colors.inc"
#include "include/textures.inc"
#include "include/shapes.inc"
#include "include/metals.inc"
#include "include/glass.inc"
#include "include/woods.inc"
*/

#declare clock_shelfs=clock04;
#declare camera_location = <0,10,0> + <-0.3,0,0.3 * clock_shelfs>;

//#include "scenes/flame/flame.inc"
#include "scenes/shelfs/shelfs.inc"
#include "scenes/shelfs/shelf_fill.inc"
#include "scenes/shelfs/hourglass_holder.inc"
#include "scenes/shelfs/torch.inc" 


camera {
	right <16/9,0,0>
	up <0,1,0>
	sky vnormalize(<0.8,0,0.2>)
	location camera_location
	look_at <0,0,0.6> + <-0.3,0,0.3 * clock_shelfs>
	//rotate <0,70,0>
	angle 55
	//translate <-0.3,0,0.3 * clock_shelfs>
}

//////////// Fog //////////////////////

  /*fog {
    distance 1.5
    color rgbft<1, 1, 1, 0, .7>
    turbulence .9
    turb_depth .9
  }
  
  fog {
    distance 1.5
    color rgbft<1.0, 1.0, 1.0, 0, .9>
    turbulence 1
    turb_depth .9
    fog_type 2
    fog_offset .4
    fog_alt .3
  }*/


///// Fill Shelves  ///////////////////////////////////////////////

#declare pre_row1=15;
#declare pre_row2=17;
#declare pre_column1=9;
#declare pre_column2=22;
#declare row_finish=17;    
#declare column_finish=26;
#declare row_start=10;    
#declare column_start=5;  
#declare shelving=1;

shelf_fill(row_start,row_finish,column_start,column_finish,shelving)

#declare pre_row1=12;
#declare pre_row2=17;
#declare pre_column1=6;
#declare pre_column2=23;
#declare row_finish=16;    
#declare column_finish=27;
#declare row_start=7;     
#declare column_start=4;  
#declare shelving=2;

shelf_fill(row_start,row_finish,column_start,column_finish,shelving) 

/// basic death figure ///////////

/*
merge{cone{<0,0,0>,.6
     <0,1,0>,.3
     scale <.5,1,.3>     
     rotate z*-10
     translate <0,-.1,0>
     }
     
difference{cone {<0,0,0>,.2
      <0,.5,0>,.03
      scale <1,1,.7>
      rotate <0,0,120>
      translate <.25,1,0>
      }
      box{<.2,-2,2>,<4,2,-2>}translate x*.1}
      scale 2 rotate y*-90 translate z*(-1+clock_shelfs) no_shadow pigment{Gray50}}
      
*/

#include "scenes/splines/splines2D.inc"

#local death_outline_1 = array[11 * 5] {
	0.00,	2.00,	0.5,	0.5,	0,
	0.20,	1.80,	1,	1,	0,
	0.10,	1.67,	1,	1,	0,
	0.40,	1.40,	1,	1,	0,
	0.50,	0.70,	1,	1,	0,
	0.60,	0.00,	1,	0,	0,
	-0.60,	0.00,	0,	1,	0,
	-0.50,	0.70,	1,	1,	0,
	-0.40,	1.40,	1,	1,	0,
	-0.10,	1.67,	1,	1,	0,
	-0.20,	1.80,	1,	1,	0,
}

#local death_outline_2 = array[11 * 5] {
	0.02,	1.95,	0.5,	0.5,	0,
	0.20,	1.75,	1,	1,	0,
	0.10,	1.60,	1,	1,	0,
	0.40,	1.37,	1,	1,	0,
	0.55,	0.70,	1,	1,	0,
	0.50,	0.00,	1,	0,	0,
	-0.65,	0.00,	0,	1,	0,
	-0.45,	0.70,	1,	1,	0,
	-0.40,	1.37,	1,	1,	0,
	-0.10,	1.60,	1,	1,	0,
	-0.20,	1.75,	1,	1,	0,
}

#local death_outline_3 = array[11 * 5] {
	-0.02,	1.95,	0.5,	0.5,	0,
	0.20,	1.75,	1,	1,	0,
	0.10,	1.60,	1,	1,	0,
	0.40,	1.37,	1,	1,	0,
	0.45,	0.70,	1,	1,	0,
	0.65,	0.00,	1,	0,	0,
	-0.50,	0.00,	0,	1,	0,
	-0.55,	0.70,	1,	1,	0,
	-0.40,	1.37,	1,	1,	0,
	-0.10,	1.60,	1,	1,	0,
	-0.20,	1.75,	1,	1,	0,
}


#declare cycle = mod(clock04/0.8/2,1);

object {
	#if(cycle >= 0 & cycle <= 0.25)
		drawPrism(interpolateShape(death_outline_1,death_outline_2,(cycle * 4)),0,1)
	#end
	#if(cycle > 0.25 & cycle <= 0.5)
		drawPrism(interpolateShape(death_outline_2,death_outline_1,((cycle - 0.25) * 4)),0,1)
	#end
	#if(cycle > 0.5 & cycle <= 0.75)
		drawPrism(interpolateShape(death_outline_1,death_outline_3,((cycle -0.5) * 4)),0,1)
	#end
	#if(cycle > 0.75 & cycle <= 1)
		drawPrism(interpolateShape(death_outline_3,death_outline_1,((cycle - 0.75) * 4)),0,1)
	#end
	pigment {
		color rgb <0,0,0>
	}
	finish { ambient 0 diffuse 0 }
	scale 0.85
	translate <0,0,7.5 + clock04 * 0.8>
}
/*
#declare Dimmer= 0.7;

light_source {
	<0,4,22>
	color rgb <10,10,5>*Dimmer
	spotlight
	point_at <0,0,0>
	radius 5
	falloff 10
}

light_source {
	<-200,200,-200>
	color <0.5,0.5,1.8>*Dimmer
	parallel
	shadowless
}


light_source {
	<200,200,-200>
	color <0.5,0.5,1.8>*Dimmer
	parallel
	shadowless
}

light_source {
	<0,10,0>
	color rgb <1.0,0.9,0.3>*Dimmer
	shadowless
}
*/

/*
* spotlight for reaper-shadow on floor
*/
#if(true)
	light_source {
		<0,4,22>
		color rgb <1.0,1.0,0.5>*1.5
		spotlight
		point_at <0,0,0>
		radius 5
		falloff 10
	}
#end

/*
* some blue fill-lights from above
*/
#if(true)
	light_source {
		<-200,200,-200>
		color <0.05,0.05,0.2>*0.75
		parallel
		shadowless
	}
	light_source {
		<200,200,-200>
		color <0.07,0.07,0.25>*0.75
		parallel
		shadowless
	}
#end

/*
* another yellow fill-light
*/
#if(true)
	light_source {
		<0,10,0>
		color rgb <0.3,0.2,0.1>*0.75
		shadowless
	}
#end

/*
* "negative" headlight
*/
#if(true)
	light_source {
		camera_location + <0.2,0,0>
		color rgb -<0.4,0.3,0.2>
		fade_power 2
		fade_distance 0.75
		shadowless
	}
#end

///////////  Bat   ////////////////// 

#declare bat_move1= spline{
                        cubic_spline
    
                        -.2, <0, 5.1, -3.1>
                        0, <-0, 8.2, -2>,
                        0.1, <0.1,  8, 0>,
                        0.25, <-0.1,  6.6, 1>,
                        0.3, < 0.2,  7.3, 0>,
                        0.4, <-0.1, 5.9, 0.5>,
                        0.55, <-0.3, 5.2, 0>,
                        0.6, <0.3, 6.6, 1>,
                        0.79, <0, 5.9, 1>,
                        0.85, <0.2, 6.6, 0.5>,
                        0.9, <0.3, 5.9, 1>,
                        1.0, <0.5, 5.2, 2>,
                        1.1, <0, 5.1, 3.1>,
                        }
                        
#declare bat_move2= spline{
                        cubic_spline
                        
                        -.2, <0, 5.1, 3.1>,
                        0, <0.5, 5.2, 2>,
                        0.1, <0.3, 5.9, 1>,
                        0.25, <0.2, 6.6, 0.5>,
                        0.3, <0, 5.9, 1>,
                        0.49, <0.3, 6.6, 1>,
                        0.55, <-0.3, 5.2, 0>,
                        0.6, <-0.1, 5.9, 0.5>,
                        0.7, < 0.2,  7.3, 0>,
                        0.85, <-0.1,  6.6, 1>,
                        0.9, <0.1,  8, 0>,
                        1.0, <-0, 5.2, -2>,
                        1.1, <0, 5.1, -3.1>
                                                
                        }

#declare bat_color=rgb <1, 1, 0.6>;
#declare bat_time=clock04;
#include "scenes/room/bat.inc"
                   
object {bat scale 0.01 Spline_Trans(bat_move1,(bat_time/6), y, 0.01, 0.05) pigment{rgb bat_color}}
object {bat scale 0.01 Spline_Trans(bat_move2,(bat_time/6), y, 0.01, 0.05) pigment{rgb bat_color}}






/*#declare tt=0;
#while (tt<1)
sphere{<0,0,0>,.03 Spline_Trans(bat_move1,tt, y, 0.1, 0) translate x*0 pigment {Red}}
sphere{<0,0,0>,.03 Spline_Trans(bat_move2,tt, y, 0.1, 0) translate x*0 pigment {Blue}}
#declare tt=tt+.005;
#end*/

 

////// torch positions //////////////////////////
/*
object{torch translate <-.4,3.39+.5,-.7+.3*-10>}
object{torch rotate y*180 translate <.4,3.39+.5,-.7+.3*4>}
object{torch translate <-.4,3.39+.5,-.7+.3*18>}                 
*/

#local torch_mount_height = 3.5;

#local flame_0_pos = <.4,torch_mount_height,-.7-.3*10>;  
#local flame_1_pos = <-.4,torch_mount_height,-.7+.3*05>;  
#local flame_2_pos = <.4,torch_mount_height,-.7+.3*20>;   
#local flame_3_pos = <-.4,torch_mount_height,-.7+.3*35>;

object{torch scale 0.66 rotate y*180 translate flame_0_pos}
object{torch scale 0.66 translate flame_1_pos}
object{torch scale 0.66 rotate y*180 translate flame_2_pos}
object{torch scale 0.66 translate flame_3_pos}

//flame(camera_location, flame_position, flame_height, time, hotair)
/*
* flames
*/

#declare simple_flame_pigment = pigment {
	onion
	color_map {
		[0.0 color rgbt <1,1,1,0.0>]
		[0.1 color rgbt <1,1,0.1,0.3>]
		[0.25 color rgbt <1,0.2,0.1,0.8>]
		[0.4 color rgbt <1,0.1,0.1,1>]
		[0.6 color rgbt <1,0.1,0.1,1>]
		[0.75 color rgbt <1,0.2,0.1,0.8>]
		[0.9 color rgbt <1,1,0.1,0.3>]
		[1.0 color rgbt <1,1,1,0.0>]
	}
	scale 2
	turbulence 0.005 octaves 10 omega 1
	translate f_agate(clock04*4,0,0)*0.1
}

#declare simple_lens_flare = pigment {
	onion
	color_map {
		[0.0 color rgbt <1,1,1,0.0>]
		[0.2 color rgbt <1,1,0.1,0.3>]
		[0.4 color rgbt <1,0.2,0.1,1>]
		//[0.5 color rgbt <1,0.2,0.1,1>]
		[0.4 color rgbt <1,0.5,0,1>]
		[0.42 color rgbt <1,0.5,0,0.5>]
		[0.44 color rgbt <1,0.5,0,1>]
		[1.0 color rgbt <1,0.5,0,1>]
	}
}

#declare cv0 = vnormalize(camera_location - flame_0_pos);
#declare cv1 = vnormalize(camera_location - flame_1_pos);
#declare cv2 = vnormalize(camera_location - flame_2_pos);
#declare cv3 = vnormalize(camera_location - flame_3_pos);

#if(true)
	light_source { flame_0_pos + y + 0.1 color rgb <2,2,1>*1 fade_power 3 fade_distance 1 }
	light_source { flame_1_pos + y + 0.1 color rgb <2,2,1>*1 fade_power 3 fade_distance 1 }
	light_source { flame_2_pos + y + 0.1 color rgb <2,2,1>*1 fade_power 3 fade_distance 1 }
	light_source { flame_3_pos + y + 0.1 color rgb <2,2,1>*1 fade_power 3 fade_distance 1 }
	disc { 0,y,1,0 no_shadow pigment { simple_flame_pigment } finish { ambient 1.25 } scale (0.06 + 0.03*f_agate(clock04*2+50,0,0).x) translate camera_location translate -cv0}
	disc { 0,y,1,0 no_shadow pigment { simple_flame_pigment } finish { ambient 1.25 } scale (0.06 + 0.03*f_agate(clock04*2+100,0,0).x) translate camera_location translate -cv1}
	disc { 0,y,1,0 no_shadow pigment { simple_flame_pigment } finish { ambient 1.25 } scale (0.06 + 0.03*f_agate(clock04*2+150,0,0).x) translate camera_location translate -cv2}
	disc { 0,y,1,0 no_shadow pigment { simple_flame_pigment } finish { ambient 1.25 } scale (0.06 + 0.03*f_agate(clock04*2+200,0,0).x) translate camera_location translate -cv3}
#end


