/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot11.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Closing Credits Shot
 Date        : 20031031
 Created by  : Tom Galvin (tom - at - imp - dot - org)
 Modified by : Dennis Borree 20031123 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com) 
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   14 seconds
//

#include "include/colors.inc"
#include "include/woods.inc"
#include "scenes/hourglass/hourglass.inc"
#include "scenes/shelfs/hourglass_holder.inc"
#include "scenes/shelfs/web.inc"

#declare size_1= 1.9;
#declare hg_location= <-0.5, -0.35, -180>;
#declare grain_size = 0.00025;
#declare time = clock11 * 0.2;
#declare deltaT = 1/framerate * 0.2;
#declare fit_factor = 0.9;
#declare r = seed(0);
//#declare sl = pow((7.2-time),1/3)*0.01;
#declare rotate_2 = clock11 / 16 * 30;

/*
#if (time > 7.2)
	#declare sl = 0;
#end#
*/

camera {
   location <0, 0, -182> 
   look_at <0, 0, 0>
   up <0,1,0>
   right <16/9,0,0>
   angle 40
}

light_source {<-50, 20, -130> color rgb 1}  // moved the light sources
light_source {<50, 20, -130> color rgb 1}   // 

light_source {
	<-0.6, 0, -182>        
	color rgb <1.8, 1.7, 1.6>
	spotlight
	#local r1 = 50;
	radius r1 falloff r1*2 
	point_at hg_location  
}

#declare fontname="fonts/babyface.ttf"

#include "include/textfunc.inc"

union {
	textscroll("data/credits.txt", clock11, 0, 4.0)
	no_reflection
}

///////////////////// added hourglass  /////////////////////////

#declare web_text=texture{pigment{rgbt<1,1,1,.4>}}

#declare web_spokes=5;
#declare web_y=.2;
#declare web_x=.3;
#declare web_spiral=0.001;
#declare web_thickness=.0005;
#declare web_corner=4; 
#declare web_rot=-90; 
#declare web_trans_y=0; 
#declare web_trans_z=-0.28; 
#declare web_yclip=0.28; 
#declare web_xclip=0.48; 



object {
	#local half_height = 0.16;
	#local glass_radius = 0.4*half_height;
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = pow((2.8-time),1/3)*0.01;
	#if (time > 2.8)
		#local sand_level_1 = 0;
	#end
	#local sand_level_2 = half_height*0.5;
	#local time_end = 2.8;
	#local level_of_detail = 3;               
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,false,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness + 0.025, 0>
	scale size_1
	rotate y*rotate_2
	translate hg_location
}


#declare hourglass_base_style = 1;
#declare hourglass_rods_style = 1;
#declare name_number= 100;
#declare hourglass_texture=T_Wood8;
#declare hg_rotate= 10;
#declare hg_rotate1= hg_rotate+150;
#declare nameplate_font= "fonts/riverave.ttf";



union{object {hourglass_holder() rotate y*hg_rotate }
      object{web(web_spokes,web_x,web_y,web_thickness,web_spiral,123,web_text)  
        rotate x*180 
        clipped_by{plane{y,web_yclip}} 
        rotate x*180  
        clipped_by{plane{x,web_xclip}} 
        rotate z*web_rot rotate y*-35  scale 1/size_1 translate <.07, 0.35, -.02>}
      rotate y*rotate_2 scale size_1 translate hg_location} 
