/* checkerball.pov - part 1 of yin-yang animation
Created:     2003.12.31.16.20
Last edited: 2004.01.07.18.00
By:          William de Beaumont
*/
/* The scene:
0.0 b/w static
... fades to
0.2 mirrored sphere on checkered plane, foggy background
... sphere turns white (no reflection), illumination increases,
    ambient decreases, zoom in on sphere, so that terminator is vertical
1.0 prepare to turn into a wine glass
*/
#include "colors.inc"

//#declare CAMERALOC = <3-3*clock,2,-2>;

#declare CAMPATH =
 spline
 {
   natural_spline
   -.50, <5,2,-2>,
   -.25, <4,2,-2>,
   0.00, <3,2,-2>,
   0.50, <1,2,-2>,
   0.70, <0.2,2.4,-1.6>,
   0.85, <0.03, 2.7,-1>,
   1.00, <0,2.82,0>,
   1.25, <0,2.82,0>
/*   1.25, <0,2.82,2>,
   1.50, <0,2.82,4>   */
 }

camera
{
//  location CAMERALOC
  location CAMPATH(clock)
  look_at <0,0,0>
/*
#if (clock < .5)
  normal
  {
    bumps 10 - 20 * clock
    scale .1
  }
  scale (1-clock)*(1-clock)*4
#end
  */
}
//light_source {<10,10,-10> color White}
/*
#if (clock < .5)
plane
{ CAMERALOC, sqrt(9*(1-clock)*(1-clock) + 8)*.8
  texture
  {
    finish {ambient 1}
    pigment
    {
      bumps
      color_map
      {
	[0.0 rgbf<0,0,0,clock*2>]
	[0.5 rgbf<1,1,1,clock*2>]
	[1.0 rgbf<0,0,0,clock*2>]
      }
      scale <.1,.005,.1>
    }
  }
}
#end
*/
plane
{ y, -1
  texture
  {
    finish {ambient 1}
    pigment {checker Black White}
  }
/*#if (clock > .5)
  rotate x*sin((clock-.5)*3.14159265)*-45
#end*/
}

fog
{
  distance 5
  color Gray50
  fog_type 2
  fog_offset -2
  fog_alt 8 - 8*clock
#if (clock > .5)
  rotate x*sin((clock-.5)*3.14159265)*-45
#end
}

sphere
{ <0,0,0>,1
  texture
  {
    finish
    {
      reflection 1 - clock
      ambient .5+clock/2
    }
#if (clock > .5)
    pigment 
    { gradient x
      color_map
      {
        [(clock-.5) Black]
        [1-(clock-.5)   White]
      }
      scale 2
      translate x
    }
#else
    pigment
    { gradient x
      color_map
      {
	[0 Black]
	[1 White]
      }
      scale 2
      translate x
    }
#end
  }
}

