/* explosiont.pov - planes collide head-on and cause an explosion
Created:     2004.01.09.17.20
Last edited: 2004.01.15.20.15
By:          William de Beaumont
(much carried over from previous scene, planes.pov)
*/

/* TODO
fix peak in isosurface
fix visibility of plane tail fin on underside
make planes disintegrate (violent noise function?) --oh well, this is ok
*/

#include "colors.inc"
#include "functions.inc"

//#declare DEBUG = 1;

#if (clock < .9)
 #declare fadeval = 1;
#else
 #declare fadeval = 1 - (clock - .9)*10;
#end

camera
{
  location <.2,-.2,-.2>
  look_at <0,0,0>
}

light_source {<-5,5,-5> color rgb<fadeval, fadeval, fadeval>}

#ifndef (DEBUG)
isosurface
{
  function
  { -z + 
    .8 * (.1 * f_noise3d(x*8,y*8,0) +
		  .2-.2*pow( sin(f_th(x,z,y) +
				 6.28*(pow(x/(-4.5),2) + 
				       pow(y/(4.5),2)
				      )
				),3
			   ) +
                  select(f_r(x,y,z) - .1, .1 - f_r(x,y,z), 0)
		 )
  }
  contained_by {box {<-10,-10,0>,<10,10,10>}}
  max_gradient 10
#else
intersection
{
  plane {-z, -.1}
  sphere {<0,0,-.1>,1.3}
#end

  texture
  {
    finish {ambient .5*fadeval phong 1 phong_size 40}
    pigment
    {
      function { f_th(x,z,y)/6.28 + (x*x+y*y) }
      color_map
      {
	[0 Black]
	[0.49999 Black]
	[0.50001 White]
	[1 White]
      }
      scale <-4.5,4.5,1>
    }
  }
}

/*#if (clock < .2)
  #declare clk = 0;
#else
  #if (clock < .8)
    #declare clk = (clock-.2)/.6;
  #else
    #declare clk = 1;
  #end
#end*/

union
{
  intersection
  {
    blob
    { threshold .2
      sphere {<0,0,0>,1.35,2 scale <.2,.2,.9>}
      cylinder
      {<0,0,.15>,<1,0,-.15>,.3,2 scale <1,.2,1>}
      cylinder
      {<0,0,.15>,<-1,0,-.15>,.3,2 scale <1,.2,1>}
      sphere {<0,0,-1.2>,.6,2 scale <1,.15,1>}
      sphere {<0,0,-1.2>,.6,2 scale <.15,1,1>}
    }
    sphere{<0,0,0>,1}
  }
  isosurface
  {
    function
    { 
      f_r(x/.2,y/.2,z/.9) * (1 + (f_noise3d(x*5,y*5,z*5)-.5)*clock)
    }
    threshold 1.1+.1*clock
    max_gradient 10
    contained_by {box {-1,1}}
  }
  scale .1
  rotate y*180
  rotate x*-90

  translate z*-.001
  translate y*.1
//  translate y*-.1*(1-(1-clock)*(1-clock))
  scale y*(1-.5*clock)
  rotate z*-59
  texture
  {
    finish {ambient .5*fadeval phong 1}
    pigment {color Black}
  }
}

union
{
  intersection
  {
    blob
    { threshold .2
      sphere {<0,0,0>,1.35,2 scale <.2,.2,.9>}
      cylinder
      {<0,0,.15>,<1,0,-.15>,.3,2 scale <1,.2,1>}
      cylinder
      {<0,0,.15>,<-1,0,-.15>,.3,2 scale <1,.2,1>}
      sphere {<0,0,-1.2>,.6,2 scale <1,.15,1>}
      sphere {<0,0,-1.2>,.6,2 scale <.15,1,1>}
    }
    sphere{<0,0,0>,1}
  }
  isosurface
  {
    function
    { 
      f_r(x/.2,y/.2,z/.9) * (1 + (f_noise3d(x*5,y*5,z*5)-.5)*clock)
    }
    threshold 1.1+.1*clock
    max_gradient 10
    contained_by {box {-1,1}}
  }
  scale .1
  rotate x*-90

  translate z*-.001
  translate y*-.1
//  translate y*.1*(1-(1-clock)*(1-clock))
  scale y*(1-.5*clock)
  rotate z*-59
  texture
  {
    finish {ambient .5*fadeval phong 1}
    pigment {color White}
  }
}

#declare exploamt = clock;

isosurface
{
  function
  { f_r(x,y,z) +
    .2*f_noise3d(x*5,y*5,z*5) + 
    .5*f_noise3d(x*2,y*2,z*2)
  }
  threshold 4*exploamt
  max_gradient 2.5
  contained_by {box {-4,4}}
  texture
  {
    finish {ambient 1*fadeval}
    pigment
    { function
      { .8*f_noise3d(f_r(x,y,z),f_th(x,y,-z),f_ph(x,y,z)) + 
        .2*f_noise3d(x,y,z)
      }
      color_map
      {
	[0 rgbt<1,1,0,exploamt*exploamt>]
        #if (exploamt < .5)
	  [.999 - (exploamt*2)*.999 rgbt<1,1,0,exploamt>]
	#end
	[1 rgbt<1,0,0,exploamt>]
      }
      scale .5
    }
  }
  #if (exploamt < .5)
    interior {ior 1.5 - .5*exploamt}
  #else
    interior {ior 1 + pow((1-exploamt),4)*4}
  #end
  scale .07
}

