#version 3.6 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "metals.inc"
#include "woods.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------

#declare pi2=2*pi/360;
#declare tclock=clock-1000;

#declare place = <-1.2+2.4*(clock-1000)/210  ,.05,5.5 >;

/*
light_source { place + <-2,2,0> color <1,1,1>*.2 shadowless}
light_source { place + <2,2,0> color <1,1,1>*.2 shadowless}
light_source{place color<1,1,1>*.6 shadowless}
*/

//light_source{<-1000,1000,1000> color<1,1,1>*1}
light_source{<-1000,1000,-1000> color<1,1,1>*1}

camera {location place
right 16/9*x
look_at <0,1000,4000 >
angle 79
sky <0,1,0>
up <0,1,0> // -1 flips left to right
}

sky_sphere{S_Cloud2 rotate 0*y }

// declare rainbow's colors

// 0.8 to 0.6, 1.0 to 0.6
  #declare r_violet1 = color rgbft<1.0, 0.5, 1.0, 0.4, 0.6>;
  #declare r_violet2 = color rgbft<1.0, 0.5, 1.0, 0.4, 0.6>;
  #declare r_indigo  = color rgbft<0.5, 0.5, 1.0, 0.4, 0.6>;
  #declare r_blue    = color rgbft<0.2, 0.2, 1.0, 0.4, 0.6>;
  #declare r_cyan    = color rgbft<0.2, 1.0, 1.0, 0.4, 0.6>;
  #declare r_green   = color rgbft<0.2, 1.0, 0.2, 0.4, 0.6>;
  #declare r_yellow  = color rgbft<1.0, 1.0, 0.2, 0.4, 0.6>;
  #declare r_orange  = color rgbft<1.0, 0.5, 0.2, 0.4, 0.6>;
  #declare r_red1    = color rgbft<1.0, 0.2, 0.2, 0.4, 0.6>;
  #declare r_red2    = color rgbft<1.0, 0.2, 0.2, 0.4, 0.6>;

  // create the rainbow

  rainbow {

    angle 20//42.5 size in sky

    width 3//thickness

    distance 1.0e7/1.0e7//7

    direction <-0, .25, 1>// .25 location

//    jitter 0.01

arc_angle 300// 120

falloff_angle 30

    color_map {
      [0.000  color r_violet1]
      [0.100  color r_violet2]
      [0.214  color r_indigo]
      [0.328  color r_blue]
      [0.442  color r_cyan]
      [0.556  color r_green]
      [0.670  color r_yellow]
      [0.784  color r_orange]
      [0.900  color r_red1]
    }
  }

#declare oz1 = union{

height_field {png "/home/matt/povray/h-fields/hills1.png" 
	pigment { color rgb <.3,.7,.1>} 
//	finish{ambient .3}
	finish{roughness 10 ambient .6}
//	normal {ripples 1 frequency 10000 turbulence <1,1,10> omega 1 lambda 10}

	translate <-.5,0,-.5> scale <200,10,200>*3
translate -.0001*y }

#declare citytex = texture{
//pigment{color rgbf<101/256,196/256,80/256,.5>}
pigment{color rgb<101/256,196/256,80/256>}
finish{ambient .5 roughness .01 reflection 0 phong 1 phong_size 50}
}

//plane {<0,1,0>, 0 pigment{color <.5,1,1>}}

#declare tower= union{
cylinder{<0,0,0>,<0,10,0> .4}
sphere{<0,10,0> .4}
}

#declare city= union{

#declare rr=10;
#declare rr2=0;
#declare rr3=0;
#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower translate <rr2,0,rr3>}

#declare rr=8;
#declare rr2=.4;
#declare rr3=.4;

#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower translate <rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr3>}
object{tower translate <-rr2-rr2,0.-rr3>}

#declare rr=6.5;
#declare rr2=.7;
#declare rr3=.3;
#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower 
translate <rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr2-rr3>}

#declare rr=6.5;
#declare rr2=1.3;
#declare rr3=1.1;
#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower translate <rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr2-rr3>}

#declare rr=7.5;
#declare rr2=1.7;
#declare rr3=1.3;
#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower translate <rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr2-rr3>}

#declare rr=6.0;
#declare rr2=1.1;
#declare rr3=1.3;
#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower translate <rr2+rr3,0,-rr3>}
object{tower translate <-rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr2-rr3>}
object{tower translate <-rr2-rr2,0,-rr2-rr3>}

#declare rr=5;
#declare rr2=1.1;
#declare rr3=2.3;
#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower translate <rr2,0,-rr3>}
object{tower translate <rr2,0,-rr3+rr2>}
object{tower translate <-rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr2-rr3>}
object{tower translate <-rr2+rr3,0,-rr2-rr3>}

#declare rr=5.5;
#declare rr2=.5;
#declare rr3=2.3;
#declare tower = union{
cylinder{<0,0,0>,<0,rr,0> rr/10/4 }
sphere{<0,rr,0> rr/10/4}
}
object{tower translate <rr2,0,-rr3>}
object{tower translate <-rr2,0,-rr3>}
object{tower translate <-rr2-rr3,0,-rr2-rr3>}
object{tower translate <rr2-rr3,0,-rr3>}
object{tower translate <-rr2,0,-rr3+rr2>}
object{tower translate <-rr2-rr3,0,rr2-rr3>}

// thick ones
#declare rr=.75;
#declare tower = union {
cylinder{<0,0,0>,<0,rr*2,0> rr}
sphere{<0,rr*2,0> rr}
}
object {tower translate <-4,0,-2>}

#declare rr=.5;
#declare tower = union {
cylinder{<0,0,0>,<0,rr*2,0> rr}
sphere{<0,rr*2,0> rr}
}
object {tower translate <-1,0,-4>}
}//city

object{city scale<1,1,1>*8.5 rotate 30*y translate<10,0,150> texture{citytex}}

box{<-1,-1,-1>,<1,.001,1> scale <1,1,20000> 
pigment{Yellow}


finish {ambient .6 roughness 10 }

//ORIGINAL
	normal {ripples 1 frequency 10000
	turbulence <1,1,10> omega 1 lambda 2
}
//normal{cylindrical 10 rotate 90*z}
}


#declare rr=seed(23);

#declare lilac=union{
// lilac
#declare i=0;
#while (i<2000)

sphere{<0,0,0> .1 scale <1,.01,1> 
translate <2*rand(rr)+2*(rand(rr)-.5),0,3*rand(rr)+3*(rand(rr)-.5)> 
pigment{color <.75 +( rand(rr)-.5)/2, .5+(rand(rr)-.5)/2, .75+(rand(rr)-.5)/2>}
finish{ambient .5 roughness .01}
}
#declare i=i+1;
#end
}

object{lilac translate <0,0,3>}

#declare yellow = union{
//yellow
#declare i=0;
#while (i<2000)

sphere{<0,0,0> .1 scale <1,.01,1> 
translate <-4*rand(rr)+2*(rand(rr)-.5),0,6*rand(rr)+5*(rand(rr)-.5)> 
pigment{color <.75 +( rand(rr)-.5)/2, .75+(rand(rr)-.5)/2, .5+(rand(rr)-.5)/2>}
finish{ambient .5 roughness .01}
}
#declare i=i+1;
#end
}
object {yellow translate <0,0,5>}

#declare rose = union{
//yellow
#declare i=0;
#while (i<2000)

sphere{<0,0,0> .1 scale <1,.01,1> 
translate <-4*rand(rr)+2*(rand(rr)-.5),0,6*rand(rr)+5*(rand(rr)-.5)> 
pigment{color <1 +( rand(rr)-.5)/2, .5+(rand(rr)-.5)/2, .5+(rand(rr)-.5)/2>}
finish{ambient .5 roughness .01}
}
#declare i=i+1;
#end
}
object {rose translate <10,0,15>}
}
object {oz1}

/*
#declare screen = object{
mesh{
triangle {<-1,-1,0>,<-1,1,0>,<1,1,0>}
triangle {<-1,-1,0>,<1,1,0>,<1,-1,0>}
texture {pigment {image_map{
tga "aud-use.tga" 
once map_type 0}}}
finish {ambient .6}
translate<-.5,-.5,0>
}//mesh

}//screen

object{screen finish {ambient .6} scale <16,9,1>*.335 
scale <9, 5 ,1> 
translate 6*y
translate -15*z }
*/

#declare dancers = union{

////////ROB 0000000
#if (clock>999)
#if (clock<1048)
#include "rob0a.inc"
#include "robot.inc"
object{roba 
translate -2.5*y rotate 2*x*((360/48)*(clock-1000))  translate 2.5*y
rotate 180*y 
translate z*24 
translate <0,8*sin( (pi/48)*(clock-1000) ),-16*(clock-1000)/48>
}
#end
#end

#if (clock>1047)
#include "rob0.inc"
#include "robot.inc"
object{roba 
//translate -2.5*y rotate 90*x translate 2.5*y
rotate 180*y 
translate z*24 
//translate -4*4*z
translate <0,0,-16>
}
#end

//////////ROB 444444444
#if (clock>999)
#if (clock<1048)
#include "rob4.inc"
#include "robot.inc"
object{roba rotate 180*y translate -2*x translate z*(-4)
translate z*24
}
object{roba rotate 180*y translate 2*x  translate z*(-4)
translate z*24
}
#end
#end

////444444444444 JUMP
#if (clock>1047)
#if (clock<1097)
#include "rob4a.inc"
#include "robot.inc"
object{roba 
translate -2.5*y rotate 2*x*((360/48)*(clock-1000))  translate 2.5*y
rotate 180*y translate -2*x translate z*(-4)
translate z*24
translate <0,8*sin( (pi/48)*(clock-1048) ), -16*(clock-1048)/48>
}
object{roba 
translate -2.5*y rotate 2*x*((360/48)*(clock-1000))  translate 2.5*y
rotate 180*y translate 2*x  translate z*(-4)
translate z*24
translate <0,8*sin( (pi/48)*(clock-1048) ), -16*(clock-1048)/48>
}
#end
#end

#if (clock>1096)
#include "rob4.inc"
#include "robot.inc"
object{roba 
rotate 180*y translate -2*x translate z*(-4)
translate z*24 translate -16*z
}
object{roba 
rotate 180*y translate 2*x  translate z*(-4)
translate z*24 translate -16*z
}
#end

/////ROB 8888888888888888
#if (clock>999)
#if (clock<1097)
#include "rob8.inc"
#include "robot.inc"
object{roba rotate 180*y translate -2*x translate z*(-8)
translate z*24
}
object{roba rotate 180*y translate 2*x translate z*(-8)
translate z*24
}
#end
#end

//////////*88888888 JUMP
#if (clock>1096)
#if (clock<1145)
#include "rob8a.inc"
#include "robot.inc"
object{roba 
translate -2.5*y rotate 2*x*((360/48)*(clock-1000))  translate 2.5*y
rotate 180*y translate -2*x translate z*(-8)
translate z*24
translate <0,8*sin( (pi/48)*(clock-1096) ), -16*(clock-1096)/48>
}
object{roba 
translate -2.5*y rotate 2*x*((360/48)*(clock-1000))  translate 2.5*y
rotate 180*y translate 2*x translate z*(-8)
translate z*24
translate <0,8*sin( (pi/48)*(clock-1096) ), -16*(clock-1096)/48>
}
#end
#end

#if (clock>1144)

#include "rob8.inc"
#include "robot.inc"
object{roba rotate 180*y translate -2*x translate z*(-8)
translate z*24 translate -16*z
}
object{roba rotate 180*y translate 2*x translate z*(-8)
translate z*24 translate -16*z
}
#end

///////////////1212121212121212
#if (clock>999)
#if (clock<1145)
#include "rob12.inc"
#include "robot.inc"
object{roba rotate 180*y translate -2*x translate z*(-12)
translate z*24
}
object{roba rotate 180*y translate 2*x translate z*(-12)
translate z*24
}
#end
#end

/////////JUMP
#if(clock>1144)
#if(clock<1193)

#include "rob12a.inc"
#include "robot.inc"

object{roba
translate -2.5*y rotate 2*x*((360/48)*(clock-1000))  translate 2.5*y
rotate 180*y translate -2*x translate z*(-12)
translate z*24
translate <0,8*sin( (pi/48)*(clock-1096-48) ), -16*(clock-1096-48)/48>
}
object{roba 
translate -2.5*y rotate 2*x*((360/48)*(clock-1000))  translate 2.5*y
rotate 180*y translate 2*x translate z*(-12)
translate z*24
translate <0,8*sin( (pi/48)*(clock-1096-48) ), -16*(clock-1096-48)/48>
}
#end
#end

#if (clock>1192)
#include "rob12.inc"
#include "robot.inc"

object{roba rotate 180*y translate -2*x translate z*(-12)
translate z*24 translate -16*z
}
object{roba rotate 180*y translate 2*x translate z*(-12)
translate z*24 translate -16*z
}
#end

}//union dancers 

object {dancers scale .25 translate 0*z translate z*1*(clock-1000)/48
translate z*5//added
}
