// 2004 - Gene Wadleigh

#macro curtain(stageWidth)
#local X = -(stageWidth/2);
union
{
	#while (X < stageWidth/2)
		cylinder {0,200*y,5 translate X*x }
		#declare X = X + 10;
	#end
}
#end

#macro curtainOpening(stageWidth)
#local X = -(stageWidth/2);
union
{
	#while (X < stageWidth/2)
		cylinder {0,200*y,6 translate (X*(1.0001-(clock-0.3))+((X/abs(X+0.0001))*stageWidth*(clock-0.3))/2)*x}
		#declare X = X + 9;
	#end
}
#end

#macro curtainOpen(stageWidth)
#local X = -(stageWidth/2);
union
{
	#while (X < stageWidth/2)
		cylinder {0,200*y,6 translate (X*(0.3)+((X/abs(X+0.0001))*stageWidth*(0.7))/2)*x}
		#declare X = X + 9;
	#end
}
#end

#declare stageLight =
union
{
	difference
	{
		sphere {0,1}
		sphere {0,1 translate -0.1*z}
		light_source { 0 color White }
	}
}

#macro stage(stageWidth)
union
{
	cylinder { 0,-60*y,stageWidth/2 }
	
	#declare lightAngle = -60;
	#while (lightAngle < 60)
		// object {stageLight translate 79*z rotate lightAngle*y }
		#declare lightAngle = lightAngle + 2;
	#end
}
#end


#include "woods.inc"
#declare Natural_Oak = T_Wood1
#declare Dark_Walnut = T_Wood2
#declare Bleached_Oak = T_Wood3
#declare Mahogany = T_Wood4
#declare Red_Oak = T_Wood5
#declare Cocabola = T_Wood6
#declare Yellow_Pine = T_Wood7
#declare Burly_Maple = T_Wood9
#declare Soft_Pine = T_Wood10
#declare Spruce = T_Wood11
#declare Golden_Oak = T_Wood19
#declare Rosewood = T_Wood32
