// Persistence of Vision Ray Tracer Scene Description File
// File: bkdrp_cr.inc
// Vers: 3.5
// Desc: Include-File for basic scenery 
// Date: 10.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 12.10.04 (dd.mm.yy)

//Description
// Modified version of bkdrp_desert.inc with a rectangular cut in the
// heightfield for the crater.

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#ifndef (Desert_HFDetail) #declare Desert_HFDetail = 250; #end
#ifndef (Desert_HF_Smooth) #declare Desert_HF_Smooth = off; #end
#ifndef (Desert_BaseColor) #declare Desert_BaseColor = <.7,.3,.1>; #end
#ifndef (Desert_UseDetailTex) #declare Desert_UseDetailTex = false; #end
#ifndef (Desert_UseSun) #declare Desert_UseSun = off; #end
#ifndef (Desert_SunPos) #declare Desert_SunPos = <200,1500,400>; #end
#ifndef (Desert_SunArealights) #declare Desert_SunArealights = 0; #end
#ifndef (Desert_SunColor) #declare Desert_SunColor = 1; #end
#ifndef (Desert_SunSizeMultiplier) #declare Desert_SunSizeMultiplier=1; #end

#ifndef (Desert_Clouds) #declare Desert_Clouds = on; #end
#ifndef (Desert_CloudTransform) #declare Desert_CloudTransform = transform{} #end
#ifndef (Desert_CloudPercentage) #declare Desert_CloudPercentage = 40; #end
#ifndef (Desert_CloudShadow) #declare Desert_CloudShadow = off; #end

#ifndef (Desert_ObjectScale) #declare Desert_ObjectScale = 1; #end

#macro Create_Backdrop()

//Basic skysphere for blue sky
sky_sphere{
  pigment{
    gradient y
    color_map{[0 rgb <.4,.4,.4>][.2 rgb <.5,.5,.8>][1 rgb <.3,.3,.6>]}
    scale 2 translate -1
    poly_wave 2
  }
}
//Some simple groundfog for hazy depth at horizon
fog{
  fog_type 2 fog_alt 17*Desert_ObjectScale fog_offset 0 distance 800*Desert_ObjectScale rgbt <.3,.3,.4,.85>
  turbulence .3 turb_depth .2
}
fog{
  fog_type 2 fog_alt 25*Desert_ObjectScale fog_offset 0 distance 1250*Desert_ObjectScale rgbt <.5,.5,.8,.4>
}

//Pigments and preparations for the heightfield-function
#declare HF_Flat = pigment{granite color_map{[0 rgb 0][1 rgb .03]}}
#declare HF_Flat = pigment{rgb 0}
#declare HF_Bumpy =
  pigment{
    bozo color_map{[0 rgb .3][.7 rgb 1][1 rgb 1]}
    turbulence .7 omega .3 octaves 8 lambda 2.5
    poly_wave 2
    scale .05
    }

#declare MR_Pigment = pigment{spherical
 pigment_map{
 [0 HF_Flat]
 [.03 HF_Flat]
 [.2 HF_Bumpy]
 [.6 HF_Bumpy]
 [.9 HF_Flat]
 [1 HF_Flat]
 }
 scale .5
 translate <.5,.5,0>
 }

#declare MR_Function = function{ pigment{MR_Pigment}}

#declare Mountain_Range = 
 height_field{
  function Desert_HFDetail,Desert_HFDetail{MR_Function(x,y,z).x}
  #if (Desert_HF_Smooth) smooth #end
  translate <-.5,0,-.5>
  }

#declare MR_Base = Desert_BaseColor;

#declare DryBed_Tex=
texture{
  pigment{
    crackle scale .1
    color_map{[0 rgb MR_Base*.1][.01 rgb MR_Base*.3][.1 rgb MR_Base][1 rgb MR_Base*.95]}
  }
  normal{crackle .0003 no_bump_scale scale .1}
  finish{specular .04 roughness .1}
}

#declare Mountains_Tex = texture{pigment{rgb MR_Base}}
                            
#if (Desert_UseDetailTex)
  #declare MR_Texture =
  texture{
    cylindrical
    scale 20
    texture_map{
      [0 Mountains_Tex]
      [1 DryBed_Tex scale 1/20]
    }
  }
#else
  #declare MR_Texture = texture{Mountains_Tex}
#end

difference{
  object{Mountain_Range
    scale <1500,30,1500>
    texture{MR_Texture}
    scale Desert_ObjectScale
  }
  box{<-25,1,-25><25,-25,25> scale 1.4 pigment{rgb 0}}
}
//Sun-Object for Reflections
#if (Desert_UseSun)

light_source{
  vnormalize(Desert_SunPos)*1750
  rgb Desert_SunColor
  #if (Desert_SunArealights > 0)
    area_light x*250,y*250,Desert_SunArealights,Desert_SunArealights adaptive 2 orient circular
  #end
  #if (Desert_Clouds & Desert_CloudShadow)
    photons{reflection off refraction off}
  #end
  
  scale Desert_ObjectScale
  }

sphere{0,1
  hollow
  pigment{rgbt 1}
  interior{
    media{
      emission 1/(900*Desert_SunSizeMultiplier)
      method 2 samples 1,1 intervals 15
      density{spherical poly_wave 2 color_map{[0 rgb 0][.1 rgb <1,.4,.2>][1 rgb 1]}}
    }
  }
  scale 900*Desert_SunSizeMultiplier
  translate vnormalize(Desert_SunPos)*1500*10
  no_shadow
  scale Desert_ObjectScale
}
#end

//Clouds
#if (Desert_Clouds & Desert_CloudPercentage > 0)

#if (Desert_UseSun & !Desert_CloudShadow)
light_group{
  light_source{
    vnormalize(Desert_SunPos)*25000 rgb Desert_SunColor photons{reflection off refraction off}
    parallel point_at <0,0,0>
    scale Desert_ObjectScale
  }
#end

#local A=0;
#while (A<5)
  sphere{0,1 hollow inverse
    texture{
      pigment{
        bozo
        scale <1,.5,1>*.125
        translate y*.005*A
        turbulence .4 octaves 9 omega .51 lambda 3
        #if (Desert_CloudPercentage > 6 & Desert_CloudPercentage<100)
          color_map{[0 rgbt 1][1-Desert_CloudPercentage/100 rgbt 1][1.05-Desert_CloudPercentage/100 rgb 1.5 transmit .8][1 rgbt <.7,.7,.9,.4>]}
        #end
        #if (Desert_CloudPercentage <= 6 & Desert_CloudPercentage > 0)
          color_map{[0 rgbt 1][1-Desert_CloudPercentage/100 rgbt 1][1 rgb 1.5 transmit .8]}
        #end
        #if (Desert_CloudPercentage >= 100)
          color_map{[0 rgb 1.5 transmit .8][1 rgbt <.7,.7,.9,.4>]}
        #end
        transform{Desert_CloudTransform}
      }
      finish{diffuse 1}
    }
    double_illuminate
    photons{pass_through collect off}
    #if (Desert_CloudShadow)
      scale (<1500,300,1500>+A*5)
    #else
      scale (<1500,300,1500>+A*5)*10
    #end
    scale Desert_ObjectScale
  }
  #declare A=A+1;
#end

#if (Desert_UseSun & !Desert_CloudShadow)
global_lights off
}
#end

#end

#end