// Persistence of Vision Ray Tracer Scene Description File
// File: jet.inc
// Vers: 3.5
// Desc: Creates the Jet-Object 
// Date: 16.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 29.09.04 (dd.mm.yy)

//Required Files
// io_macs.inc  - To load values and arrays
// bsplines.inc - To parse BSplines

//Description
// Prepares and delivers a "Jet"-Object, facing -z

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#ifndef (_io_macs_inc_tnw) #include "io_macs.inc" #end
#ifndef (_bsplines_inc_tnw) #include "bsplines.inc" #end

#ifndef (Jet_WingDetail) #declare Jet_WingDetail = <50,2>; #end

//0=Good, 1=1st hit, 2=Crashed
#ifndef (Jet_Condition) #declare Jet_Condition = 0; #end
//0=Black for Occlusion, 1=Textured according to condition
#ifndef (Jet_Textured) #declare Jet_Textured = 1; #end
#ifndef (Jet_Missiles) #declare Jet_Missiles = <1,1,1,1>; #end
#ifndef (Jet_Exhaust) #declare Jet_Exhaust = 0; #end

//==================
// Jet Wing's Spline
//==================
#declare Jet_WingFront_BSpline = Load_Array("jet/jet_wngf.spl");
#declare Jet_WingRear_BSpline = Load_Array("jet/jet_wngr.spl");

#declare Jet_WingSpline =
union{

#declare A=0;
#while (A<Jet_WingDetail.u-1)
  #declare LoopClock = A/(Jet_WingDetail.u-1);
  #declare LoopClock_B = (A+1)/(Jet_WingDetail.u-1);
  cone{
    BSpline_Pos(Jet_WingFront_BSpline,LoopClock),(.1*(1-LoopClock)+.025),
    BSpline_Pos(Jet_WingFront_BSpline,LoopClock_B),(.1*(1-LoopClock_B)+.025)
  }
  sphere{
    BSpline_Pos(Jet_WingFront_BSpline,LoopClock_B),(.1*(1-LoopClock_B)+.025)
  }    
  #declare A=A+1;
#end
  
  cone{
    V3(Jet_WingFront_BSpline[4]),.025,
    V3(Jet_WingRear_BSpline[4]),0
  }
}

//==========
//Body Parts
//==========

//End Stabilizer - Singe Style
#declare Jet_StabilizerPart=
union{
  difference{
    box{<.5,0,0><0,.125,1>}
    cylinder{<0,-.1,0><0,.2,0>,.45 scale <1,1,2> translate < .5,0,1>}
  }
  difference{
    box{<.45,0,0><0,.175,1>}
    cylinder{<0,-.1,0><0,.2,0>,.5 scale <1,1,2> translate < .5,0,1>}
  }
  
  torus{.5,.05 scale <1,1,2> translate <.5,.125,1>
    clipped_by{box{<.45,0,1><0,.175,0>}}
  }
  
  intersection{
    cylinder{<.45,.125,0>,<.45,.125,0.5>,.05}
    cylinder{<.5,.125,0>,<.3,.125,0>,.05 scale <1,1,2>}
  }
  scale <1,1,.5>
  translate z*2

}  

//Engine
#declare Jet_Engine=
union{
  #include "jet/jet_engn.msh"
  torus{.19,.01 translate <0,1.25,.1> rotate x*90}
  cone{y*.5,0,y*1.25,.18 open hollow translate z*.1 rotate x*90
    pigment{rgb 0}
    finish{ambient 0 diffuse 0}
  }
  //** Textures **
  //Non-Textured
  #if (Jet_Textured=0)
    pigment{rgb 0}
    finish{ambient 0 diffuse 0}
  #end
  //Textured
  #if (Jet_Textured=1)
    texture{
      pigment{rgb .6}
      finish{
        //reflection{.1,.8 falloff 2}
        specular .8 roughness .02
        brilliance 3
      }
    }
    texture{
      pigment{gradient z scale 1.3 poly_wave 3 color_map{[0 rgbt <0,0,0,1>][.7 rgbt <0,0,0,.2>][1 rgbt <0,0,0,0>]}}
    }  
  #end
  translate <0,-.15,.9>
}

#declare Jet_Propulsion=
  sphere{0,1 hollow
    pigment{rgbt <0,0,0,1>}
    interior{
      media{
        emission (3+3*Jet_Exhaust)*Jet_Exhaust
        method 2 samples 1,1 intervals 15
        density{spherical poly_wave .5 color_map{[0 rgb 0][.7 rgb 1][1 rgb 1]}}
        density{gradient z color_map{[0 rgb x*(1-Jet_Exhaust)][.25 rgb z][.475 rgb 0][.5 rgb 0][1 rgb 0]} scale 2}
        //density{bozo color_map{[0 rgb 1][.5 rgb <1,.25,.25>][1 rgb .2]}scale .05 translate z*frame_number/.15}
      }
    }
    scale <1,1,3+4*Jet_Exhaust>*.18
    translate <0,-.25,2.15>
    no_shadow
  }

//================
// Jet Declaration
//================
#declare Jet_Missile1 = Load_Value("jet/jet_m1.vec");
#declare Jet_Missile2 = Load_Value("jet/jet_m2.vec");

#declare Jet_Missile =
  union{
    //Main Missile-Body
    sphere{0,.075 scale <1,1,3>
      pigment{rgb x}
      finish{
        specular .2 roughness .02
        brilliance 2
      }
    }
    cylinder{0,z,.075}
    cone{z,.075,z*1.25,.04 open hollow}
    cone{z*1.25,.02,z,0 open hollow
      pigment{rgb 0}
    }
    torus{.03,.01 rotate x*90 translate z*1.25}
    #declare Missile_Fins=
    mesh{
      //Tiny front Fins
      triangle{<0,0,.1>,< .05,0,.25>,<0,.175,.2>}
      triangle{<0,0,.1>,<-.05,0,.25>,<0,.175,.2>}
      triangle{<.05,0,.25>,<-.05,0,.25>,<0,.175,.2>}
      //Large Fins
      triangle{<0,0,.5>,< .05,0,.95>,<0,.2,.85>}
      triangle{<0,0,.5>,<-.05,0,.95>,<0,.2,.85>}
      triangle{<.05,0,.95>,<-.05,0,.95>,<0,.2,.85>}
      //Smaller rear Fins
      triangle{<0,0,.9>,< .05,0,1.1>,<0,.2,1.1>}
      triangle{<0,0,.9>,<-.05,0,1.1>,<0,.2,1.1>}
      triangle{<.05,0,1.1>,<-.05,0,1.1>,<0,.2,1.1>}
    }
    union{
      object{Missile_Fins}
      object{Missile_Fins rotate z*90}
      object{Missile_Fins rotate z*180}
      object{Missile_Fins rotate z*270}
      pigment{rgb .2}
      finish{
        specular .2 roughness .03
        brilliance 3
      }
    }
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*45}        
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*135}        
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*225}        
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*315}        

    pigment{rgb 1}
    finish{
      specular .4 roughness .01
      brilliance 3
      diffuse .8
    }
    rotate z*45
    translate z*-.5
  }

#declare Missile_Attachment =
  union{
    prism{linear_spline -.025,.025,5
      <-.4,0>,<0,-.25>,<.4,-.25>,<.4,0>,<-.4,0>
      rotate <-90,-90,0>
    }
    //Rounding Edge
    sphere{<0,0,-.4>,.025}
    cylinder{<0,0,-.4>,<0,-.25,0>,.025}
    sphere{<0,-.25,0>,.025}
    cylinder{<0,-.25,0>,<0,-.25,.4>,.025}
    sphere{<0,-.25,.4>,.025}
    cylinder{<0,-.25,.4>,<0,0,.4>,.025}
    sphere{<0,0,.4>,.025}
    //Details
    union{
      union{
        sphere{0,.025 scale <1,1,4> translate <0,-.125,0>}
        cylinder{0,z*.2,.025 translate <0,-.125,0>}
        sphere{<0,-.125,.2>,.025}
        cylinder{<0,-.125,.2>,<0,-.2,.2>,.025}
        sphere{0,.025 scale <1,1,4> translate <0,-.2,.2>}
        scale <.5,1,1>
        translate <.025,0,0>
      }      
      union{
        sphere{0,.025 scale <1,1,4> translate <0,-.125,0>}
        cylinder{0,z*.2,.025 translate <0,-.125,0>}
        sphere{<0,-.125,.2>,.025}
        cylinder{<0,-.125,.2>,<0,-.2,.2>,.025}
        sphere{0,.025 scale <1,1,4> translate <0,-.2,.2>}
        scale <.5,1,1>
        translate <-.025,0,0>
      }      
      #if (Jet_Textured=1)
        pigment{rgb .2}
        finish{
          specular .5 roughness .04
          brilliance 2
        }
      #end
    }
    translate y*.05
    #if (Jet_Textured=0)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    #if (Jet_Textured=1)
      pigment{rgb .6}
      finish{
        specular .4 roughness .08
      }
    #end

  }

#declare Jet_Main=union{

  box{<-.5,-.25,-.75><.5,.125,.5>}
  //Top rounding
  cylinder{<-.45,.125,-.75>,<-.45,.125,2>,.05}
  cylinder{<.45,.125,-.75>,<.45,.125,2>,.05}
  box{<-.45,.125,-.75><.45,.175,2>}
  //Base
  cylinder{<0,0,-.75><0,0,.5>,.5 scale <1,.5,1> translate y*-.25}
  
  //Tip-Sensor
  //cone{<0,-.25,-2.5>,.02 <0,-.25,-3>,0}
  
  //Rounded end base
  difference{
  union{
    box{<-.5,-.25,.5><.5,.125,2>}
    cylinder{<0,0,.5><0,0,1.25>,.5 scale <1,.5,1> translate y*-.25}
  }
  cylinder{<-.6,-.5,0><.6,-.5,0>,.5 scale <1,1,2> translate <0,0,2>}
  }
  
  object{Jet_StabilizerPart}
  object{Jet_StabilizerPart scale <-1,1,1>}
  
  //Single End Finn
  union{
  
  prism{linear_spline -.05,.05,7
    <0,0>,<.2,.125>,<.3,.4>,<.1,.75>,<-.1,.75>,<-2,.125>,<0,0>
    rotate <-90,-90,0>
    translate <0,0,3>
  }
  cylinder{<0,.175,.75><0,.175,3>,.05}
  sphere{<0,.175,0>,.05 scale <1,1,3> translate z*.75}
  //From rear to front of prism
  cylinder{<0,.125,1><0,.75,2.9>,.05}
  sphere{<0,.75,2.9>,.05}
  cylinder{<0,.75,2.9>,<0,.75,3.1>,.05}
  sphere{<0,.75,3.1>,.05}
  cylinder{<0,.75,3.1>,<0,.4,3.3>,.05}
  sphere{<0,.4,3.3>,.05}
  cylinder{<0,.4,3.3>,<0,.125,3.2>,.05}
  sphere{<0,.125,3.2>,.05}
  cylinder{<0,.125,3.2>,<0,0,3>.05}
  translate z*-.5
  }
  sphere{<0,0,2.5>,.05}
  cylinder{<0,0,2.5>,<0,0,0>,.05}
  
  //Detail on top
    //Leading to Stabilizers
    cylinder{<.25,.175,1.8><.25,.175,1>,.025}
    cylinder{<-.25,.175,1.8><-.25,.175,1>,.025}
    torus{.25,.025 clipped_by{box{<-.3,0,0><.3,.1,-.3>}} translate <0,.175,1>}
    torus{.25,.025 clipped_by{box{<-.3,0,0><.3,.1,-.3>}} translate <0,.175,1.3>}
    torus{.25,.025 clipped_by{box{<-.3,0,0><.3,.1,.3>}} translate <0,.175,1.8>}
    
    //Cockpit to Wings
    sphere{0,1 scale <.125,.05,.125> translate <.25,.175,-.5>}
    cylinder{0,z*.9,1 scale <.125,.05,1> translate <.25,.175,-.5>}
    sphere{0,1 scale <.125,.05,.35> translate <.25,.175,.4>}
    sphere{0,1 scale <.125,.05,.125> translate <-.25,.175,-.5>}
    cylinder{0,z*.9,1 scale <.125,.05,1> translate <-.25,.175,-.5>}
    sphere{0,1 scale <.125,.05,.35> translate <-.25,.175,.4>}
    cylinder{<-.25,0,0>,<.25,0,0>,.05 scale <1,.5,2> translate <0,.16,-.4>}
    cylinder{<-.25,0,0>,<.25,0,0>,.05 scale <1,.5,2> translate <0,.16,.1>}
    cylinder{<-.25,0,0>,<.25,0,0>,.05 scale <1,.5,2> translate <0,.16,.5>}

  #include "jet/jet_cpit.msh"
  #include "jet/jet_cptb.msh"
  
  #declare Jet_WholeWing =    
  union{
    #include "jet/jet_wngt.msh"
    #include "jet/jet_wngb.msh"
    object{Jet_WingSpline}
    translate x*.5
  }
  object{Jet_WholeWing}
  object{Jet_WholeWing scale <-1,1,1>}
  
  
  //** Textures **
  //Non-Textured
  #if (Jet_Textured=0)
    pigment{rgb 0}
    finish{ambient 0 diffuse 0}
  #end
  //Camouflage-Textured
  #if (Jet_Textured=1)
    #declare Jet_TextureScale = <1,1,2>;
    texture{
      pigment{bozo color_map{[0 rgb <.7,.5,.3>][.5 rgb <.7,.5,.3>][.5 rgb .1][1 rgb .1]} scale <1,1,1>*.3*Jet_TextureScale}
    }
    texture{
      pigment{bozo color_map{[0 rgbt <0,0,0,1>][.5 rgbt <0,0,0,1>][.5 rgb <.5,.3,.1>][1 rgb <.5,.3,.1>]}translate -15 scale <1,1,1>*.12*Jet_TextureScale}
    }
    texture{
      pigment{bozo color_map{[0 rgbt <0,0,0,1>][.7 rgbt <0,0,0,1>][.7 rgb .4][1 rgb .4]}translate 35 scale <1,1,1>*.25*Jet_TextureScale}
    }
    texture{
      pigment{bozo color_map{[0 rgbt <0,0,0,1>][.7 rgbt <0,0,0,1>][.7 rgb <.7,.5,.3>][1 rgb <.7,.5,.3>]}translate 15 scale <1,1,1>*.2*Jet_TextureScale}
    }
    texture{
      pigment{rgbt <1,1,1,.8>}
      finish{
        specular .4 roughness .08
        brilliance 3
      }
    }
  #end
}

#declare Jet_Glass=
sphere{0,1
  scale <.25,.25,.5> rotate x*-15 translate <0,0,-.7>+<0,-.1,-.75>
  #if (Jet_Textured=0)
    pigment{rgb 0}
    finish{ambient 0 diffuse 0}
  #end
  #if (Jet_Textured=1)
    pigment{rgb <.5,.25,0>}
    interior{ior 1.45}
    finish{
      specular 1 roughness .009 metallic .9
      diffuse .05
      reflection{<.2,.08,0>,1 fresnel exponent .92}
      conserve_energy
    }
  #end
}

#declare Jet = union{
  object{Jet_Main}
  object{Jet_Engine}
  object{Jet_Glass}
  #if (Jet_Exhaust>0)
    object{Jet_Propulsion}
  #end
  object{Missile_Attachment translate Jet_Missile1+<.5,0,0>}
  object{Missile_Attachment translate (Jet_Missile1+<.5,0,0>)*<-1,1,1>}
  object{Missile_Attachment translate Jet_Missile2+<.5,0,0>}
  object{Missile_Attachment translate (Jet_Missile2+<.5,0,0>)*<-1,1,1>}
  
  #if (Jet_Missiles.x)
    object{Jet_Missile translate Jet_Missile2+<.5,-.275,0> scale <-1,1,1>}
  #end
  #if (Jet_Missiles.y)
    object{Jet_Missile translate Jet_Missile1+<.5,-.275,0> scale <-1,1,1>}
  #end
  #if (Jet_Missiles.z)
    object{Jet_Missile translate Jet_Missile1+<.5,-.275,0>}
  #end
  #if (Jet_Missiles.t)
    object{Jet_Missile translate Jet_Missile2+<.5,-.275,0>}
  #end

}

#declare Jet_MissilePos_1 = (Jet_Missile2+<.5,-.275,0>)*<-1,1,1>;
#declare Jet_MissilePos_2 = (Jet_Missile1+<.5,-.275,0>)*<-1,1,1>;
#declare Jet_MissilePos_3 = Jet_Missile1+<.5,-.275,0>;
#declare Jet_MissilePos_4 = Jet_Missile2+<.5,-.275,0>;


//Jet-Missile Macro for controlled afterburn
#macro Missile(_Afterburn)
  union{
    object{Jet_Missile}
    sphere{0,1 hollow
      pigment{rgbt 1}
      interior{
        media{
          emission _Afterburn*15
          method 2 samples 1,1 intervals 10
          density{spherical color_map{[0 rgb 0][1 rgb <1,1,0>]}}
        }
      }
      no_shadow
      scale <1,1,1+15*_Afterburn>*.04
      translate z*.75
    }
  }
#end