// Persistence of Vision Ray Tracer Scene Description File
// File: poster.pov
// Vers: 3.6.1
// Desc: Poster for the IRTC-Entry "Duel" 
// Date: 14.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 14.10.04 (dd.mm.yy)

//Description

/*Commandline
+W320 +H240 +AM2 +A0.3 +R3
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#include "duel.inc"
#include "bkdrp_desert.inc"

global_settings{
  assumed_gamma 1
  max_trace_level 25
}

// Camera
//========
#declare Camera_Location = <0,5,-10>;
#declare Camera_Look_At = <0,7,0>;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Rockets = <1,1,1,1>;
#declare Jet_Exhaust = .5;

#include "jet.inc"

object{Jet
  rotate <-15,0,-45>
  translate <-3,5,0>
}

// UFO
//=====
#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = 1;

#include "ufo.inc"

object{UFO
  scale .5
  rotate <-15,0,45>
  translate <2.5,5,0>
}

// Title, Author, URL
//====================
light_group{
#declare Title_Pigment = pigment{image_map{tga "texts\title.tga"}translate y*.2}
Text_Layer(Title_Pigment,15,<1,0,0>,0)
#declare Director_Pigment = pigment{image_map{tga "texts\directed.tga"}translate y*.2}
Text_Layer(Director_Pigment,1.2,<1,0,0>,0)
#declare Director_Pigment = pigment{image_map{tga "texts\cr_url.tga"}translate y*-.45}
Text_Layer(Director_Pigment,2,<1,0,0>,0)
global_lights off
}

// Background
//============
#declare Desert_HFDetail = 750;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <0,150,20>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = 1;
#declare Desert_CloudTransform = transform{translate x*.01*clock}
#declare Desert_CloudPercentage = 50;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
//Ambient light
light_source{<100,0,-150> rgb <.2,.2,.5>*.5 shadowless}
light_source{<0,-50,-150> rgb Desert_BaseColor*.35 shadowless}
