// Persistence of Vision Ray Tracer Scene Description File
// File: scene1_.pov
// Vers: 3.6.1
// Desc: Scene 1 of Duel-Entry : Titles and introduction of Jet
// Date: 22.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 02.10.04 (dd.mm.yy)

//Description
// Scene 1 of Duel-Entry
// Flyby through clouds with titles showing up. Pan to the Jet, which
// is communicating with Headquarters. It is shown that the jet is
// actually expecting something to happen.

/* Commandline
+KFI1 +KFF425 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 17;

#include "duel.inc"
#include "timers.inc"

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 256
}

//For the jet's hovering
#declare _Shake_DirLength = .05;
Create_Shake(7,.03,5,"splines/sc1_jet.spl","Jet_Hover")

#declare Landscape_Detail = 350;
#declare Landscape_Move = 600;
#declare Clouds_Move = 900;

//Clock for Cam-Movement
#declare Camera_Clock = Clock_Cubic(8,6);
#declare Cam_Zoom = Clock_Cubic(14,3);
#declare Camera_Location = <0,55,-2>+<0,-.25,.25>*Cam_Zoom;
#declare Camera_Look_At = <-5,45,0>+<5,8,0>*Camera_Clock;
Camera()

//Three point lighting
light_source{<500,960,-300> rgb 1}
light_source{<500,960,-300>*<-1,-1,1> rgb <.7,.3,.1>*.3 shadowless}
light_source{<500,960,-300>*<-1,1,-1> rgb <.2,.2,.4> shadowless}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Rockets = <1,1,1,1>;
#declare Jet_Exhaust = .5;

#include "jet.inc"

object{Jet
  scale .5
  translate <0,53,1>
  translate Linear_Pos(Jet_Hover,clock)
  }

// Title and Subtitles
//=====================
#declare Title_Clock = Duration_Faded(1,5,<.3,.5>);
#declare Director_Clock = Duration_Faded(2.5,3.5,<.3,.5>);
#declare txtJet1_Clock = Duration(8,3.5);
#declare txtJet2_Clock = Duration(14,2.5);
#declare txtHQ1_Clock = Duration(11.75,2);

// The movie-title and Author required their own light-groups
// in order to avoid a shadow on the title. 
// The workaround was simply placing a similiar light in a nearby
// location, but move it position to cast the shadow above the title.
#if (Title_Clock)
light_group{
  light_source{<650,900,-300> rgb 1
    parallel point_at <0,0,0>
  }
  #declare Title_Pigment = pigment{image_map{tga "texts\title.tga"}}
  Text_Layer(Title_Pigment,28,<2,1,1-Title_Clock>,0)
  global_lights off
}
#end
#if (Director_Clock)
light_group{
  light_source{<650,900,-300> rgb 1
    parallel point_at <0,0,0>
  }
  #declare Director_Pigment = pigment{image_map{tga "texts\directed.tga"}}
  Text_Layer(Director_Pigment,29,<2,1,1-Director_Clock>,0)
  global_lights off
}
#end
#if (txtJet1_Clock)
  #declare txt_Jet1 = pigment{image_map{tga "texts\sc1_j1.tga"}}
  Text_Layer(txt_Jet1,.5,<2,1,0>,1)
#end
#if (txtHQ1_Clock)
  #declare txt_HQ1 = pigment{image_map{tga "texts\sc1_hq1.tga"}}
  Text_Layer(txt_HQ1,.5,<2,1,0>,1)
#end
#if (txtJet2_Clock)
  #declare txt_Jet2 = pigment{image_map{tga "texts\sc1_j2.tga"}}
  Text_Layer(txt_Jet2,.5,<2,1,0>,1)
#end


// Skysphere
//===========
sky_sphere{
  pigment{
    gradient y
    color_map{[0 rgb <.4,.4,.4>][.2 rgb <.5,.5,.8>][1 rgb <.3,.3,.6>]}
    scale 2 translate -1
    poly_wave 2
  }
}

// Horizon-Haze
//==============
fog{
  fog_type 2 fog_alt 17 fog_offset 0 distance 800 rgbt <.3,.3,.4,.85>
  turbulence .3 turb_depth .2
}
fog{
  fog_type 2 fog_alt 25 fog_offset 0 distance 1250 rgbt <.5,.5,.8,.4>
}


// Mountain-Range
//================
#declare MR_Base = <.7,.3,.1>;

//Pigments and preparations for the heightfield-function
#declare HF_Bumpy =
  pigment{
    bozo color_map{[0 rgb .2][.05 rgb .3][.7 rgb 1][1 rgb 1]}
    turbulence .7 omega .3 octaves 8 lambda 2.5
    poly_wave 2
    scale .05*<1,1/(Landscape_Move/300*3),1>
    }

#declare MR_Function = function{ pigment{HF_Bumpy}}

#declare Mountain_Range = 
 height_field{
  function Landscape_Detail,Landscape_Detail{MR_Function(x,y,z).x}
  smooth
  translate <-.5,0,-.5>
  }

#declare MR_Texture =
  texture{
    pigment{gradient y color_map{[0 rgb MR_Base][1 rgb MR_Base*<.8,.5,.5>]}}
    finish{specular .1 roughness .01 metallic 1} 
  }
                            
object{Mountain_Range
  texture{MR_Texture}
  scale <300,10,Landscape_Move*3>
  translate z*Landscape_Move*clock
  translate y*-20
}

// Clouds
//========
light_group{
light_source{<500,960,-300> rgb 1}

#declare A=0;
#while (A<10)

plane{y,0
  pigment{
    bozo color_map{[0 rgbt 1][.6 rgbt 1][.8 rgb 1.5 transmit .6][1 rgbt <.8,.8,1,.4>]}
    turbulence .2 omega .6 octaves 9 lambda 2.8
    translate y*(A*.125)
    scale 9*<1.5,1,1>
  }
  finish{ambient .3 diffuse .7}
  translate y*(40+A/2)
  translate z*Clouds_Move*clock
  double_illuminate
}

#declare A=A+1;
#end
global_lights off
}